#version 100

#ifdef GL_ES
    precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform float mAlpha;
uniform float mSize;
uniform float mMotion;
uniform float mTheme;

varying vec2 vTextureCoord;
varying vec2 vResolution;
varying float vAClipDist;
varying float vBClipDist;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    srcColor.w = srcColor.w * mAlpha;

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/vResolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void getColor(in float mClipDist, in float mNoClipDist, out float alpha) {
    if(mClipDist >= -2.0 && mClipDist < -1.5 && mNoClipDist < -mSize+2.0) {
        alpha = 1.0;
    } else if(mClipDist >= -1.5 && mClipDist < -1.0 && mNoClipDist < -mSize+1.5) {
        alpha = 1.0;
    } else if(mClipDist >= -1.0 && mClipDist < -0.5 && mNoClipDist < -mSize+1.0) {
        alpha = 1.0;
    } else if(mClipDist >= -0.5 && mClipDist < 0.0 && mNoClipDist < -mSize+0.5) {
        alpha = 1.0;
    } else if(mClipDist >= 0.0 && mClipDist < 0.5 && mNoClipDist < -mSize) {
        alpha = 1.0;
    } else if(mClipDist >= 0.5 && mClipDist < 1.0 && mNoClipDist < -mSize-0.5) {
        alpha = 1.0;
    } else if(mClipDist >= 1.0 && mClipDist < 1.5 && mNoClipDist < -mSize-1.0) {
        alpha = 1.0;
    } else if(mClipDist >= 1.5 && mClipDist < 2.0 && mNoClipDist < -mSize-1.5) {
        alpha = 1.0;
    } else {
        alpha = 0.0;
    }
}

void main ()
{
    float alpha = 1.0;
    float DrawSrc = 1.0;

    if(mMotion > 0.0) {
        getColor(vBClipDist, vAClipDist, alpha);

        if(mMotion == 2.0) {
            if(alpha == 1.0)
                alpha = 0.0;
            else
                alpha = 1.0;
        }

        if(alpha == 0.0) {
            DrawSrc = 0.0;
        }
    }

    if(DrawSrc == 1.0) {
        if(alpha == 0.0) {
            gl_FragColor = vec4(1.0, 1.0, 1.0, 0.0);
        } else {
            gl_FragColor = Theme();
        }
    } else {
        gl_FragColor = vec4(0.34, 0.72, 0.99, 1.0);
    }
}