#version 100

precision mediump float;

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform float mSize;
uniform float mTrans;
uniform float mDirect;
uniform float mCover;
uniform float mAlpha;
uniform float mTheme;

uniform vec2 resolution;

varying vec2 vTextureCoord;
varying float vGXClipDist;
varying float vGYClipDist;
varying float vGAClipDist;
varying float vGBClipDist;
varying float vGCClipDist;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    srcColor.w = srcColor.w * mAlpha;

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/resolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void main ()
{
    if(vGXClipDist >= 0.0 && mDirect == 0.0) {
        discard;
    } else if(vGXClipDist < 0.0 && mDirect == 1.0) {
        discard;
    } else if(vGAClipDist >= 0.0 && mDirect == 2.0) {
        discard;
    } else if(vGAClipDist < 0.0 && mDirect == 3.0) {
        discard;
    } else if(vGCClipDist < 0.0 && mDirect == 4.0) {
        discard;
    } else if(vGCClipDist >= 0.0 && mDirect == 5.0) {
        discard;
    }

    if(mTrans == 1.0) {
        if(vGXClipDist > mSize && mCover == 0.0) {
            discard;
        } else if(vGXClipDist < mSize && mCover == 1.0) {
            discard;
        } else if(vGYClipDist > mSize && mCover == 2.0) {
            discard;
        } else if(vGYClipDist < mSize && mCover == 3.0) {
            discard;
        }
    }

    if(mAlpha == 0.0)
        discard;

    gl_FragColor = Theme();
}