#version 100

#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform vec2 resolution;
uniform float mAlpha;
uniform float mTheme;
uniform float mTransType;

uniform float mSize;
uniform float mReverse;
uniform float mImageRatio;

varying vec2 vTextureCoord;
varying vec3 vTexturePosition;

varying vec4 vCenter;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 DrawCover() {
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    float mDiscard = 0.0;

    if(mTransType == 1.0) {
        if((vTexturePosition.x+vTexturePosition.y*mImageRatio) < -2.0*mImageRatio*mSize)
            mDiscard = 1.0;
    } else if(mTransType == 2.0) {
        if((vTexturePosition.x-vTexturePosition.y*mImageRatio) >= 2.0*mImageRatio*mSize)
            mDiscard = 1.0;
    } else if(mTransType == 3.0) {
        if((vTexturePosition.x-vTexturePosition.y*mImageRatio) < -2.0*mImageRatio*mSize)
            mDiscard = 1.0;
    } else if(mTransType == 4.0) {
        if((vTexturePosition.x+vTexturePosition.y*mImageRatio) >= 2.0*mImageRatio*mSize)
            mDiscard = 1.0;
    } else if(mTransType == 5.0) {
        float angle = radians((mSize+1.0)/2.0*360.0);
        float rotate_X = cos(angle)*vTexturePosition.x - sin(angle)*vTexturePosition.y;
        if(mSize < 0.0) {
            if(rotate_X < 0.0 || vTexturePosition.x >= 0.0)
                mDiscard = 1.0;
        } else if(mSize >= 0.0) {
            if(rotate_X < 0.0)
                mDiscard = 1.0;
            if(vTexturePosition.x < 0.0)
                mDiscard = 0.0;
        }
    } else if(mTransType == 6.0) {
        float angle = radians((mSize+1.0)/2.0*121.0);
        float rotate_X = cos(angle)*vTexturePosition.x - sin(angle)*vTexturePosition.y;
        float rotate_Y = sin(angle)*vTexturePosition.x + cos(angle)*vTexturePosition.y;

        if(vTexturePosition.y < 0.0) {
            if((rotate_X+rotate_Y*mImageRatio) < 0.0 || (vTexturePosition.x+vTexturePosition.y*mImageRatio) >= 0.0)
                mDiscard = 1.0;
        } else if(vTexturePosition.y >= 0.0) {
            if((rotate_X+rotate_Y*mImageRatio) >= 0.0 || (vTexturePosition.x+vTexturePosition.y*mImageRatio) < 0.0)
                mDiscard = 1.0;
        }

        angle = radians((mSize+1.0)/2.0*59.0);
        rotate_X = cos(angle)*vTexturePosition.x - sin(angle)*vTexturePosition.y;
        rotate_Y = sin(angle)*vTexturePosition.x + cos(angle)*vTexturePosition.y;

        if(vTexturePosition.x < 0.0) {
            if((rotate_X-rotate_Y*mImageRatio) >= 0.0 && (vTexturePosition.x-vTexturePosition.y*mImageRatio) < 0.0)
                mDiscard = 0.0;
        } else if(vTexturePosition.x >= 0.0) {
            if((rotate_X-rotate_Y*mImageRatio) < 0.0 && (vTexturePosition.x-vTexturePosition.y*mImageRatio) >= 0.0)
                mDiscard = 0.0;
        }
    } else if(mTransType == 7.0) {
             float left = 1.0;
             float right = 1.0;
             if((vTexturePosition.x-vTexturePosition.y*mImageRatio) >= 2.0*mImageRatio*mSize)
                 left = 0.0;
             if((vTexturePosition.x-vTexturePosition.y*mImageRatio) < -2.0*mImageRatio*mSize)
                 right = 0.0;

             if((left + right) == 2.0)
                 mDiscard = 0.0;
             else if((left + right) == 1.0)
                 mDiscard = 0.5;
             else
                 mDiscard = 1.0;
     } else if(mTransType == 8.0) {
            float left = 1.0;
            float right = 1.0;
            if((vTexturePosition.x+vTexturePosition.y*mImageRatio) < -2.0*mImageRatio*mSize)
                left = 0.0;
            if((vTexturePosition.x+vTexturePosition.y*mImageRatio) >= 2.0*mImageRatio*mSize)
                right = 0.0;

            if((left + right) == 2.0)
                mDiscard = 0.0;
            else if((left + right) == 1.0)
                mDiscard = 0.5;
            else
                mDiscard = 1.0;
     }

    if(mReverse == 0.0 && mDiscard == 1.0)
        discard;
    else if(mReverse == 1.0 && mDiscard == 0.0)
        discard;
    else if(mDiscard == 0.5)
        srcColor.w = 0.3;

    srcColor.w = srcColor.w * mAlpha;
    return srcColor;
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = DrawCover();

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/resolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void main() {
    gl_FragColor = Theme();
}
