#ifdef GL_ES
  precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform mat3 matrix;
uniform vec2 resolution;
uniform float mAlpha;
uniform float mIsBG;
uniform float mTheme;

varying vec2 vTextureCoord;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 gray(vec4 color) {
    float y = dot(color, vec4(0.299, 0.587, 0.114, 0));
    return vec4(y, y, y, color.a);
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    srcColor.w = srcColor.w * mAlpha;

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/resolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 5.0) {
            mResultColor = 0.1 * vec4(1.0, 1.0, 1.0, mAlpha) + 0.9 * gray(srcColor);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void main() {
    if(mIsBG == 0.0) {
        gl_FragColor = Theme();
    } else {
        gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
    }
    gl_FragColor.w = mAlpha;
}
