uniform mat4 uMVPMatrix;
uniform mat4 uMVMMatrix;

attribute vec4 aPosition;
attribute vec4 aTextureCoord;

uniform float mDoBurst;
uniform float mProgress;
uniform float mIntensity;
uniform vec2 mMeshSize;
uniform vec2 mOffsetMap[10];

varying vec2 vTextureCoord;
varying vec4 vCenter;
varying vec3 vTexturePosition;


void main() {

    if(mDoBurst == 1.0) {
        float GridIndex = aPosition.z;
        float MeshWidth = (mMeshSize.x);
        float MeshHeigh = (mMeshSize.y);
        vec2 GridCenterPoint = vec2(-1.0+mod(GridIndex,MeshWidth)*2.0/MeshWidth+1.0/MeshWidth,
                                    -1.0+(GridIndex-mod(GridIndex,MeshWidth))/MeshWidth*2.0/MeshHeigh+1.0/MeshHeigh);

        if(GridCenterPoint.x > 1.0)
            GridCenterPoint.x = -1.0;
        if(GridCenterPoint.y > 1.0)
            GridCenterPoint.y = -1.0;

        float random_index_x = GridCenterPoint.x;
        float random_index_y = GridCenterPoint.y;

        if(random_index_x < 0.1 && random_index_x > -0.1)
            random_index_x = random_index_x + 0.5;
        if(random_index_y < 0.1 && random_index_y > -0.1)
            random_index_y = random_index_y + 0.5;

        int index = int(mod(GridIndex*random_index_y*random_index_x*MeshWidth*MeshHeigh,10.0));

        vec4 mPos = vec4(aPosition.x+(GridCenterPoint.x+mOffsetMap[index].x)*mProgress*mIntensity,
                         aPosition.y+(GridCenterPoint.y+mOffsetMap[index].y)*mProgress*mIntensity,
                         0.0,
                         aPosition.w);

        gl_Position = uMVPMatrix * mPos;
    } else {
        gl_Position = uMVPMatrix * aPosition;
    }

    //To get center position in global coords
    vCenter = uMVMMatrix * vec4(0.0, 0.0, 0.0, 1.0);

    vTextureCoord = aTextureCoord.xy;

    vTexturePosition = (uMVMMatrix * aPosition).xyz;
}