uniform mat4 uMVPMatrix;
uniform mat4 uMVMMatrix;

attribute vec4 aPosition;
attribute vec4 aTextureCoord;

varying vec2 vTextureCoord;
varying vec4 vCenter;
varying vec3 vTexturePosition;

void main() {
    gl_Position = uMVPMatrix * aPosition;

    //To get center position in global coords
    vCenter = uMVMMatrix * vec4(0.0, 0.0, 0.0, 1.0);

    vTextureCoord = aTextureCoord.xy;

    vTexturePosition = (uMVMMatrix * aPosition).xyz;
}