#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform vec3 uCleanColor;
uniform float uDifference;

void main()
{
    vec4 base = texture2D(inputImageTexture, textureCoordinate);

    vec4 resultColor;
    if (((base.r >= (uCleanColor.r - uDifference) && base.r <= (uCleanColor.r + uDifference))
                    && (base.g >= (uCleanColor.g - uDifference) && base.g <= (uCleanColor.g + uDifference)))
            ||
            ((base.r >= (uCleanColor.r - uDifference) && base.r <= (uCleanColor.r + uDifference))
                    && (base.b >= (uCleanColor.b - uDifference) && base.b <= (uCleanColor.b + uDifference)))
            ||
            ((base.g >= (uCleanColor.g - uDifference) && base.g <= (uCleanColor.g + uDifference))
                    && (base.b >= (uCleanColor.b - uDifference) && base.b <= (uCleanColor.b + uDifference)))
            ) {
        resultColor.a = 0.0;
        resultColor.r = 0.0;
        resultColor.g = 0.0;
        resultColor.b = 0.0;
    } else {
        resultColor = base;
    }

    /* another algorithm
    if ((base.r >= (clearColor.r - difference) && base.r <= (clearColor.r + difference))
            && (base.g >= (clearColor.g - difference) && base.g <= (clearColor.g + difference))
            && (base.b >= (clearColor.b - difference) && base.b <= (clearColor.b + difference))
            ) {
        resultColor.a = 0.0;
        resultColor.r = 0.0;
        resultColor.g = 0.0;
        resultColor.b = 0.0;
    } else {
        resultColor = base;
    }/**/

    /* for green
    if (base.g >= (1.0 - difference) && (base.b <= difference || base.r <= difference)) {
        resultColor.a = 0.0;
        resultColor.r = 0.0;
        resultColor.g = 0.0;
        resultColor.b = 0.0;
    } else {
        resultColor = base;
    }/**/

    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);
}