#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform vec3 uShadowColor;
uniform float uDifference;

void main()
{
    vec4 base = texture2D(inputImageTexture2, textureCoordinate2);
    vec4 blend = texture2D(inputImageTexture, textureCoordinate);

    vec4 resultColor;
    if (blend.b <= uDifference || blend.r <= uDifference) {
        resultColor.a = (1.0 - blend.g);
        resultColor.rgb = uShadowColor.rgb;
    } else {
        float shadowAlpha = 1.0 - blend.g;
        resultColor = vec4(mix(base.rgb, uShadowColor.rgb, shadowAlpha), base.a);
    }

    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);
}