#version 100

#ifdef GL_ES
    precision mediump float;
#endif

const float OVERLAY    = 1.0;
const float MULTIPLY   = 2.0;
const float SCREEN     = 3.0;
const float SOFT_LIGHT = 4.0;

const int PHOTO  = 100;
const int COLOR  = 101;
const int IMAGE  = 102;
const int RESULT = 103;

///* temp--
//const int mLayerType[6] = int[6](COLOR, PHOTO, PHOTO, PHOTO, PHOTO, PHOTO);
//const float mBlendType[6] = float[6](0.0, 0.0, SCREEN, OVERLAY, MULTIPLY, SOFT_LIGHT);
//const float mSaturation[6] = float[6](0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
//const float mLevel[6] = float[6](1.0, 0.5, 0.8, 0.6, 0.5, 0.4);
//const vec3 color = vec3(0.0, 0.0, 1.0);
//vec3 mBlendColor[6] = vec3[6](color, color, color, color, color, color);/**/

varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform highp float uAlpha;

float blendOverlayF(float base, float blend) {
    return ((base < 0.5) ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)));
}

vec3 blendOverlay(vec4 base, vec4 blend) {
    return vec3(blendOverlayF(base.r, blend.r), blendOverlayF(base.g, blend.g), blendOverlayF(base.b, blend.b));
}

vec3 blendMultiply(vec4 base, vec4 blend) {
    return vec3(base.rgb * blend.rgb);
}

float blendScreenF(float base, float blend) {
    return (1.0 - ((1.0 - base) * (1.0 - blend)));
}

vec3 blendScreen(vec4 base, vec4 blend) {
    return vec3(blendScreenF(base.r, blend.r), blendScreenF(base.g, blend.g), blendScreenF(base.b, blend.b));
}

float blendSoftLightF(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec3 blendSoftLight(vec4 base, vec4 blend) {
    return vec3(blendSoftLightF(base.r, blend.r), blendSoftLightF(base.g, blend.g), blendSoftLightF(base.b, blend.b));
}


vec4 blendAlpha(vec4 baseColor, vec4 blendColor, float alpha) {
    return vec4(mix(baseColor.rgb, blendColor.rgb, (blendColor.a * alpha)), baseColor.a);
}

vec4 setSaturation(float range, vec4 srcColor) { // -1.0 ~ 1.0, default = 0.0
    vec3 luminanceWeighting = vec3(0.299f, 0.587f, 0.114f); //  vec3(0.2125f, 0.7154f, 0.0721f);

    float saturation = 1.0; // 0.0 ~ 2.65, default = 1.0
    if (range > 0.0) {
        saturation = (range * 1.65) + 1.0;
    } else if(range < 0.0) {
        saturation = (range * 1.0) + 1.0;
    }
    float luminance = dot(srcColor.rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);

    return vec4(mix(greyScaleColor, srcColor.rgb, saturation), srcColor.a);
}

vec4 blend(vec4 baseColor, vec4 blendColor, float blendType, float blendAlpha) {
    vec4 mTempColor = blendColor;

    if (blendType == OVERLAY) {
        mTempColor = vec4(blendOverlay(baseColor, blendColor), baseColor.a);
    } else if(blendType == MULTIPLY) {
        mTempColor = vec4(blendMultiply(baseColor, blendColor), baseColor.a);
    } else if(blendType == SCREEN) {
        mTempColor = vec4(blendScreen(baseColor, blendColor), baseColor.a);
    } else if(blendType == SOFT_LIGHT) {
        mTempColor = vec4(blendSoftLight(baseColor, blendColor), baseColor.a);
    }

    return blendAlpha(baseColor, mTempColor, blendAlpha);
}

// temp, default = loop
vec4 drawLayer(bool isFirstLayer,vec4 mResultColor, vec4 srcColor, int layerType, float blendType, float saturation, float level, vec3 blendColor) {
    if (isFirstLayer) {
        if (layerType == PHOTO) {
            mResultColor = vec4(srcColor.r, srcColor.g, srcColor.b, srcColor.a * level);
        } else if (layerType == COLOR) {
            mResultColor = vec4(blendColor.r, blendColor.g, blendColor.b, level);
        } else if (layerType == IMAGE) {
            // mResultColor = vec4(blandImageColor.r, blandImageColor.g, blandImageColor.b, blandImageColor.a * level);
        } else if (layerType == RESULT) {
            mResultColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
        mResultColor = setSaturation(saturation, mResultColor);
    } else {
        if (layerType == PHOTO) {
            vec4 mTempColor = setSaturation(saturation, srcColor);
            mResultColor = blend(mResultColor, mTempColor, blendType, level);
        } else if (layerType == COLOR) {
            vec4 mTempColor = vec4(blendColor.r, blendColor.g, blendColor.b, 1.0);
            mTempColor = setSaturation(saturation, mTempColor);
            mResultColor = blend(mResultColor, mTempColor, blendType, level);
        } else if (layerType == IMAGE) {
            // vec4 mTempColor = setSaturation(saturation, blandImageColor);
            // mResultColor = blend(mResultColor, mTempColor, blendType, level);
        } else if (layerType == RESULT) {
            vec4 mTempColor = setSaturation(saturation, mResultColor);
            mResultColor = blend(mResultColor, mTempColor, blendType, level);
        }
    }
    return mResultColor;
}

void main()
{
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 mResultColor = srcColor;

    /* temp demo - 1
    mResultColor = drawLayer(true, mResultColor, srcColor, COLOR, 0.0, 0.0, 1.0, vec3(0.0, 0.0, 1.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, 0.0, 0.0, 0.5, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, SCREEN, 0.0, 0.8, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, OVERLAY, 0.0, 0.6, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, MULTIPLY, 0.0, 0.5, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, SOFT_LIGHT, 0.0, 0.4, vec3(0.0, 0.0, 0.0));/**/

//    /* temp demo - 2
    mResultColor = drawLayer(true, mResultColor, srcColor, PHOTO, 0.0, 0.0, 1.0, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, SCREEN, 0.0, 0.5, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, OVERLAY, 0.0, 1.0, vec3(0.0, 0.0, 0.0));
    mResultColor = drawLayer(false, mResultColor, srcColor, PHOTO, SOFT_LIGHT, 0.0, 1.0, vec3(0.0, 0.0, 0.0));/**/

    // function(x)++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    int layerCount = mLayerType.length(); // equal "MAX_LAYER_COUNT" = 10;
    // vec4 blandImageColor = texture2D(SingleBlendTexture, vSingleBlendTextureCoord);

    for (int i = 0; i < layerCount; i++) {
        if (i == 0) {
            if (mLayerType[0] == PHOTO) {
                mResultColor = vec4(srcColor.r, srcColor.g, srcColor.b, srcColor.a * mLevel[0]);
            } else if (mLayerType[0] == COLOR) {
                mResultColor = vec4(mBlendColor[0].r, mBlendColor[0].g, mBlendColor[0].b, mLevel[0]);
            } else if (mLayerType[0] == IMAGE) {
                // mResultColor = vec4(blandImageColor.r, blandImageColor.g, blandImageColor.b, blandImageColor.a * mLevel[0]);
            } else if (mLayerType[0] == RESULT) {
                mResultColor = vec4(0.0, 0.0, 0.0, 0.0);
            } else {
                break;
            }

            mResultColor = setSaturation(mSaturation[0], mResultColor);
        } else {
            if (mLayerType[i] == PHOTO) {
                vec4 mTempColor = setSaturation(mSaturation[i], srcColor);
                mResultColor = blend(mResultColor, mTempColor, mBlendType[i], mLevel[i]);
            } else if (mLayerType[i] == COLOR) {
                vec4 mTempColor = vec4(mBlendColor[i].r, mBlendColor[i].g, mBlendColor[i].b, 1.0);
                mTempColor = setSaturation(mSaturation[i], mTempColor);
                mResultColor = blend(mResultColor, mTempColor, mBlendType[i], mLevel[i]);
            } else if (mLayerType[i] == IMAGE) {
                // vec4 mTempColor = setSaturation(mSaturation[i], blandImageColor);
                // mResultColor = blend(mResultColor, mTempColor, mBlendType[i], mLevel[i]);
            } else if (mLayerType[i] == RESULT) {
                vec4 mTempColor = setSaturation(mSaturation[i], mResultColor);
                mResultColor = blend(mResultColor, mTempColor, mBlendType[i], mLevel[i]);
            } else {
                break;
            }
        }
    }/**/
    // function(x)---------------------------------------------------

    mResultColor.a = mResultColor.a * uAlpha;
    gl_FragColor = mResultColor;
}