#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform vec3 uGlowColor;

void main()
{
    vec4 base = texture2D(inputImageTexture, textureCoordinate);

    float alpha = (base.r + base.g + base.b) / 3.0;
    vec4 resultColor = vec4(mix(base.rgb, uGlowColor.rgb, (1.0 - alpha)), alpha);
    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);
}