#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

void main()
{
    vec4 base = texture2D(inputImageTexture2, textureCoordinate2);
    vec4 blend = texture2D(inputImageTexture, textureCoordinate);

    float alpha = (blend.r + blend.g + blend.b) / 3.0;
    vec4 resultColor = vec4(base.rgb, alpha);
    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);
}