#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform float uRange; // -1.0 ~ 1.0, 0.0 is default color

vec4 setSaturation(float range, vec4 srcColor) {
    vec3 luminanceWeighting = vec3(0.299, 0.587, 0.114); //  vec3(0.2125f, 0.7154f, 0.0721f);

    float saturation = 1.0; // 0.0 ~ 2.65, default = 1.0
    if (range > 0.0) {
        saturation = (range * 1.65) + 1.0;
    } else if(range < 0.0) {
        saturation = (range * 1.0) + 1.0;
    }
    float luminance = dot(srcColor.rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);

    return vec4(mix(greyScaleColor, srcColor.rgb, saturation), srcColor.a);
}

void main()
{
    vec4 base = texture2D(inputImageTexture, textureCoordinate);
    gl_FragColor = setSaturation(uRange, base);
}