#version 100

#ifdef GL_ES
    precision mediump float;
#endif

varying vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform float uDifference;

void main()
{
    vec4 base = texture2D(inputImageTexture, textureCoordinate);

    float alpha = (base.r + base.g + base.b) * uDifference / 3.0;
    vec4 resultColor;
    if (alpha != 0.0 ) {
        resultColor = vec4(base.rgb / alpha, alpha);
    } else {
        resultColor = vec4(0.0);
    }

    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);

    /* meteor
    vec4 base = texture2D(inputImageTexture, textureCoordinate);

    float alpha = (base.r + base.g + base.b) / 3.0;
    vec4 resultColor = vec4(base.rgb, alpha);
    if (resultColor.a != 1.0) {
        resultColor.rgb = vec3(0.0, 0.0, 1.0);
    }
    gl_FragColor = vec4(resultColor.rgb * resultColor.a, resultColor.a);/**/
}