

precision highp float;
uniform sampler2D iChannel0;
//necessary

varying vec2 textureCoordinate;
uniform float  intensity;

//end necessary

// Code taken from https://www.shadertoy.com/view/XsfGzj and modified to work in this context as an example
// of how quickly and easily you can get up and running with shadercam

// passed in via our SuperAwesomeRenderer.java
uniform float	iTime;

// play around with xy for different sized effect, or pass in via GLES20.glUniform3f();
uniform vec3    iResolution;

#define VHS 1

void main ()
{
    vec2 uv = textureCoordinate.xy;
    float amount = sin(iTime) * 0.1;

    amount *= 0.3;
    float split = 1. - fract(iTime / 2.);
    float scanOffset = 0.01;
    vec2 uv1 = vec2(uv.x + amount, uv.y);
    vec2 uv2 = vec2(uv.x, uv.y + amount);
    if (uv.y > split) {
        uv.x += scanOffset;
        uv1.x += scanOffset;
        uv2.x += scanOffset;
    }

    float r = texture2D(iChannel0, uv1).r;
    float g = texture2D(iChannel0, uv).g;
    float b = texture2D(iChannel0, uv2).b;

    gl_FragColor = vec4(r, g, b, 1.);

     vec4 texori = texture2D(iChannel0, textureCoordinate.xy);
    gl_FragColor = vec4(texori.rgb*(1.0-intensity) + gl_FragColor.rgb*intensity,1.);
}