

precision highp float;

uniform sampler2D iChannel0;
//necessary

varying vec2 textureCoordinate;
uniform float  intensity;

//end necessary

// Code taken from https://www.shadertoy.com/view/XsfGzj and modified to work in this context as an example
// of how quickly and easily you can get up and running with shadercam

// passed in via our SuperAwesomeRenderer.java
uniform float	iTime;

// play around with xy for different sized effect, or pass in via GLES20.glUniform3f();
uniform vec3    iResolution;


 float rand(vec2 co)
{
     float a = 12.9898;
     float b = 78.233;
     float c = 43758.5453;
     float dt= dot(co.xy ,vec2(a,b));
     float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}


void main ()
{
    vec2 uv = textureCoordinate;
   	 float magnitude = 0.0009;

   	// Set up offset
    vec2 offsetRedUV = uv;
    offsetRedUV.x = uv.x + rand(vec2(iTime*0.03,uv.y*0.42)) * 0.001;
   	offsetRedUV.x += sin(rand(vec2(iTime*0.2, uv.y)))*magnitude;

   	vec2 offsetGreenUV = uv;
   	offsetGreenUV.x = uv.x + rand(vec2(iTime*0.004,uv.y*0.002)) * 0.004;
   	offsetGreenUV.x += sin(iTime*9.0)*magnitude;

   	vec2 offsetBlueUV = uv;
   	offsetBlueUV.x = uv.y;
   	offsetBlueUV.x += rand(vec2(cos(iTime*0.01),sin(uv.y)));

    // Load Texture
   	float r = texture2D(iChannel0, offsetRedUV).r;
   	float g = texture2D(iChannel0, offsetGreenUV).g;
   	float b = texture2D(iChannel0, uv).b;

   	gl_FragColor = vec4(r,g,b,1.0);

	vec4 texori = texture2D(iChannel0, uv);
    gl_FragColor = vec4(texori.rgb*(1.0-intensity) + gl_FragColor.rgb*intensity,1.);
}
