

precision highp float;

uniform sampler2D iChannel0;
//necessary

varying vec2 textureCoordinate;uniform float  intensity;

//end necessary

// Code taken from https://www.shadertoy.com/view/XsfGzj and modified to work in this context as an example
// of how quickly and easily you can get up and running with shadercam

// passed in via our SuperAwesomeRenderer.java
uniform float	iTime;

// play around with xy for different sized effect, or pass in via GLES20.glUniform3f();
uniform vec3    iResolution;


#define INTERLACING_SEVERITY 0.001

#define TRACKING_HEIGHT 0.15
#define TRACKING_SEVERITY 0.025
#define TRACKING_SPEED 0.2

#define SHIMMER_SPEED 30.0

#define RGB_MASK_SIZE 2.0


void main ()
{
    vec2 uv = textureCoordinate;
    uv.x -= sin(uv.y * 500.0 + iTime) * INTERLACING_SEVERITY;

    float yOffset = floor(sin(iTime*SHIMMER_SPEED));
    float pix = (textureCoordinate.xy.y+yOffset) * iResolution.x + textureCoordinate.xy.x;
    pix = floor(pix);

    // Tracking
    float t = -iTime * TRACKING_SPEED;
    float fractionalTime = (t - floor(t)) * 1.3 - TRACKING_HEIGHT;
    if(fractionalTime + TRACKING_HEIGHT >= uv.y && fractionalTime <= uv.y) {
        uv.x -= fractionalTime * TRACKING_SEVERITY;
    }

    vec4 texColor = texture2D(iChannel0, uv);
    float col = (texColor.r + texColor.g + texColor.b) / 3.0;
    gl_FragColor = vec4(col, col, col, 1.0);

    vec4 texori = texture2D(iChannel0, textureCoordinate);
    gl_FragColor = vec4(texori.rgb*(1.0-intensity) + gl_FragColor.rgb*intensity,1.);
}
