precision highp float;
varying vec2 vTexCoord;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform float opacity;

uniform float mode;

//
float blendLighten(float base, float blend) {
    return max(blend, base);
}

vec3 blendLighten(vec3 base, vec3 blend) {
    return vec3(blendLighten(base.r, blend.r), blendLighten(base.g, blend.g), blendLighten(base.b, blend.b));
}

vec3 blendLighten(vec3 base, vec3 blend, float opacity) {
    return (blendLighten(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendLinearBurn(float base, float blend) {
    // Note : Same implementation as BlendSubtractf
    return max(base+blend-1.0, 0.0);
}

vec3 blendLinearBurn(vec3 base, vec3 blend) {
    // Note : Same implementation as BlendSubtract
    return max(base+blend-vec3(1.0), vec3(0.0));
}

vec3 blendLinearBurn(vec3 base, vec3 blend, float opacity) {
    return (blendLinearBurn(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendLinearDodge(float base, float blend) {
    // Note : Same implementation as BlendAddf
    return min(base+blend, 1.0);
}

vec3 blendLinearDodge(vec3 base, vec3 blend) {
    // Note : Same implementation as BlendAdd
    return min(base+blend, vec3(1.0));
}

vec3 blendLinearDodge(vec3 base, vec3 blend, float opacity) {
    return (blendLinearDodge(base, blend) * opacity + base * (1.0 - opacity));
}

//
vec3 blendMultiply(vec3 base, vec3 blend) {
    return base*blend;
}

vec3 blendMultiply(vec3 base, vec3 blend, float opacity) {
    return (blendMultiply(base, blend) * opacity + base * (1.0 - opacity));
}

//
vec3 blendNegation(vec3 base, vec3 blend) {
    return vec3(1.0)-abs(vec3(1.0)-base-blend);
}

vec3 blendNegation(vec3 base, vec3 blend, float opacity) {
    return (blendNegation(base, blend) * opacity + base * (1.0 - opacity));
}

//
vec3 blendNormal(vec3 base, vec3 blend) {
    return blend;
}

vec3 blendNormal(vec3 base, vec3 blend, float opacity) {
    return (blendNormal(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendOverlay(float base, float blend) {
    return base<0.5?(2.0*base*blend):(1.0-2.0*(1.0-base)*(1.0-blend));
}

vec3 blendOverlay(vec3 base, vec3 blend) {
    return vec3(blendOverlay(base.r, blend.r), blendOverlay(base.g, blend.g), blendOverlay(base.b, blend.b));
}

vec3 blendOverlay(vec3 base, vec3 blend, float opacity) {
    return (blendOverlay(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendReflect(float base, float blend) {
    return (blend==1.0)?blend:min(base*base/(1.0-blend), 1.0);
}

vec3 blendReflect(vec3 base, vec3 blend) {
    return vec3(blendReflect(base.r, blend.r), blendReflect(base.g, blend.g), blendReflect(base.b, blend.b));
}

vec3 blendReflect(vec3 base, vec3 blend, float opacity) {
    return (blendReflect(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendScreen(float base, float blend) {
    return 1.0-((1.0-base)*(1.0-blend));
}

vec3 blendScreen(vec3 base, vec3 blend) {
    return vec3(blendScreen(base.r, blend.r), blendScreen(base.g, blend.g), blendScreen(base.b, blend.b));
}

vec3 blendScreen(vec3 base, vec3 blend, float opacity) {
    return (blendScreen(base, blend) * opacity + base * (1.0 - opacity));
}


//
float blendSoftLight(float base, float blend) {
    return (blend<0.5)?(2.0*base*blend+base*base*(1.0-2.0*blend)):(sqrt(base)*(2.0*blend-1.0)+2.0*base*(1.0-blend));
}

vec3 blendSoftLight(vec3 base, vec3 blend) {
    return vec3(blendSoftLight(base.r, blend.r), blendSoftLight(base.g, blend.g), blendSoftLight(base.b, blend.b));
}

vec3 blendSoftLight(vec3 base, vec3 blend, float opacity) {
    return (blendSoftLight(base, blend) * opacity + base * (1.0 - opacity));
}


//
float blendSubstract(float base, float blend) {
    return max(base+blend-1.0, 0.0);
}

vec3 blendSubstract(vec3 base, vec3 blend) {
    return max(base+blend-vec3(1.0), vec3(0.0));
}

vec3 blendSubstract(vec3 base, vec3 blend, float opacity) {
    return (blendSubstract(base, blend) * opacity + blend * (1.0 - opacity));
}


//
float blendSubtract(float base, float blend) {
    return max(base+blend-1.0, 0.0);
}

vec3 blendSubtract(vec3 base, vec3 blend) {
    return max(base+blend-vec3(1.0), vec3(0.0));
}

vec3 blendSubtract(vec3 base, vec3 blend, float opacity) {
    return (blendSubtract(base, blend) * opacity + base * (1.0 - opacity));
}


// Add
float blendAdd(float base, float blend) {
    return min(base+blend, 1.0);
}

vec3 blendAdd(vec3 base, vec3 blend) {
    return min(base+blend, vec3(1.0));
}

vec3 blendAdd(vec3 base, vec3 blend, float opacity) {
    return (blendAdd(base, blend) * opacity + base * (1.0 - opacity));
}

// Average
vec3 blendAverage(vec3 base, vec3 blend) {
    return (base+blend)/2.0;
}

vec3 blendAverage(vec3 base, vec3 blend, float opacity) {
    return (blendAverage(base, blend) * opacity + base * (1.0 - opacity));
}

// ColorBurn
float blendColorBurn(float base, float blend) {
    return (blend==0.0)?blend:max((1.0-((1.0-base)/blend)), 0.0);
}

vec3 blendColorBurn(vec3 base, vec3 blend) {
    return vec3(blendColorBurn(base.r, blend.r), blendColorBurn(base.g, blend.g), blendColorBurn(base.b, blend.b));
}

vec3 blendColorBurn(vec3 base, vec3 blend, float opacity) {
    return (blendColorBurn(base, blend) * opacity + base * (1.0 - opacity));
}

// ColorDodge
float blendColorDodge(float base, float blend) {
    return (blend==1.0)?blend:min(base/(1.0-blend), 1.0);
}

vec3 blendColorDodge(vec3 base, vec3 blend) {
    return vec3(blendColorDodge(base.r, blend.r), blendColorDodge(base.g, blend.g), blendColorDodge(base.b, blend.b));
}

vec3 blendColorDodge(vec3 base, vec3 blend, float opacity) {
    return (blendColorDodge(base, blend) * opacity + base * (1.0 - opacity));
}

// Darken
float blendDarken(float base, float blend) {
    return min(blend, base);
}

vec3 blendDarken(vec3 base, vec3 blend) {
    return vec3(blendDarken(base.r, blend.r), blendDarken(base.g, blend.g), blendDarken(base.b, blend.b));
}

vec3 blendDarken(vec3 base, vec3 blend, float opacity) {
    return (blendDarken(base, blend) * opacity + base * (1.0 - opacity));
}

// Difference
vec3 blendDifference(vec3 base, vec3 blend) {
    return abs(base-blend);
}

vec3 blendDifference(vec3 base, vec3 blend, float opacity) {
    return (blendDifference(base, blend) * opacity + base * (1.0 - opacity));
}

// Exclusion
vec3 blendExclusion(vec3 base, vec3 blend) {
    return base+blend-2.0*base*blend;
}

vec3 blendExclusion(vec3 base, vec3 blend, float opacity) {
    return (blendExclusion(base, blend) * opacity + base * (1.0 - opacity));
}

//
vec3 blendHardLight(vec3 base, vec3 blend) {
    return blendOverlay(blend, base);
}

vec3 blendHardLight(vec3 base, vec3 blend, float opacity) {
    return (blendHardLight(base, blend) * opacity + base * (1.0 - opacity));
}

//
float blendVividLight(float base, float blend) {
    return (blend<0.5)?blendColorBurn(base, (2.0*blend)):blendColorDodge(base, (2.0*(blend-0.5)));
}

vec3 blendVividLight(vec3 base, vec3 blend) {
    return vec3(blendVividLight(base.r, blend.r), blendVividLight(base.g, blend.g), blendVividLight(base.b, blend.b));
}

vec3 blendVividLight(vec3 base, vec3 blend, float opacity) {
    return (blendVividLight(base, blend) * opacity + base * (1.0 - opacity));
}

//
vec3 blendGlow(vec3 base, vec3 blend) {
    return blendReflect(blend, base);
}

vec3 blendGlow(vec3 base, vec3 blend, float opacity) {
    return (blendGlow(base, blend) * opacity + base * (1.0 - opacity));
}


//
float blendHardMix(float base, float blend) {
    return (blendVividLight(base, blend)<0.5)?0.0:1.0;
}

vec3 blendHardMix(vec3 base, vec3 blend) {
    return vec3(blendHardMix(base.r, blend.r), blendHardMix(base.g, blend.g), blendHardMix(base.b, blend.b));
}

vec3 blendHardMix(vec3 base, vec3 blend, float opacity) {
    return (blendHardMix(base, blend) * opacity + base * (1.0 - opacity));
}


//
float blendLinearLight(float base, float blend) {
    return blend<0.5?blendLinearBurn(base, (2.0*blend)):blendLinearDodge(base, (2.0*(blend-0.5)));
}

vec3 blendLinearLight(vec3 base, vec3 blend) {
    return vec3(blendLinearLight(base.r, blend.r), blendLinearLight(base.g, blend.g), blendLinearLight(base.b, blend.b));
}

vec3 blendLinearLight(vec3 base, vec3 blend, float opacity) {
    return (blendLinearLight(base, blend) * opacity + base * (1.0 - opacity));
}


//
vec3 blendPhoenix(vec3 base, vec3 blend) {
    return min(base, blend)-max(base, blend)+vec3(1.0);
}

vec3 blendPhoenix(vec3 base, vec3 blend, float opacity) {
    return (blendPhoenix(base, blend) * opacity + base * (1.0 - opacity));
}


//
float blendPinLight(float base, float blend) {
    return (blend<0.5)?blendDarken(base, (2.0*blend)):blendLighten(base, (2.0*(blend-0.5)));
}

vec3 blendPinLight(vec3 base, vec3 blend) {
    return vec3(blendPinLight(base.r, blend.r), blendPinLight(base.g, blend.g), blendPinLight(base.b, blend.b));
}

vec3 blendPinLight(vec3 base, vec3 blend, float opacity) {
    return (blendPinLight(base, blend) * opacity + base * (1.0 - opacity));
}

vec3 blendMode(float mode, vec3 base, vec3 blend) {
    if (mode == 1.){
        return blendAdd(base, blend);
    } else
    if (mode == 2.){
        return blendAverage(base, blend);
    } else
    if (mode == 3.){
        return blendColorBurn(base, blend);
    } else
    if (mode == 4.){
        return blendColorDodge(base, blend);
    } else
    if (mode == 5.){
        return blendDarken(base, blend);
    } else
    if (mode == 6.){
        return blendDifference(base, blend);
    } else
    if (mode == 7.){
        return blendExclusion(base, blend);
    } else
    if (mode == 8.){
        return blendGlow(base, blend);
    } else
    if (mode == 9.){
        return blendHardLight(base, blend);
    } else
    if (mode == 10.){
        return blendHardMix(base, blend);
    } else
    if (mode == 11.){
        return blendLighten(base, blend);
    } else
    if (mode == 12.){
        return blendLinearBurn(base, blend);
    } else
    if (mode == 13.){
        return blendLinearDodge(base, blend);
    } else
    if (mode == 14.){
        return blendLinearLight(base, blend);
    } else
    if (mode == 15.){
        return blendMultiply(base, blend);
    } else
    if (mode == 16.){
        return blendNegation(base, blend);
    } else
    if (mode == 17.){
        return blendNormal(base, blend);
    } else
    if (mode == 18.){
        return blendOverlay(base, blend);
    } else
    if (mode == 19.){
        return blendPhoenix(base, blend);
    } else
    if (mode == 20.){
        return blendPinLight(base, blend);
    } else
    if (mode == 21.){
        return blendReflect(base, blend);
    } else
    if (mode == 22.){
        return blendScreen(base, blend);
    } else
    if (mode == 23.){
        return blendSoftLight(base, blend);
    } else
    if (mode == 24.){
        return blendSubtract(base, blend);
    } else
    if (mode == 25.){
        return blendVividLight(base, blend);
    }

    return base;
}

vec3 blendMode(float mode, vec3 base, vec3 blend, float opacity){
    if (mode == 1.){
        return blendAdd(base, blend, opacity);
    } else
    if (mode == 2.){
        return blendAverage(base, blend, opacity);
    } else
    if (mode == 3.){
        return blendColorBurn(base, blend, opacity);
    } else
    if (mode == 4.){
        return blendColorDodge(base, blend, opacity);
    } else
    if (mode == 5.){
        return blendDarken(base, blend, opacity);
    } else
    if (mode == 6.){
        return blendDifference(base, blend, opacity);
    } else
    if (mode == 7.){
        return blendExclusion(base, blend, opacity);
    } else
    if (mode == 8.){
        return blendGlow(base, blend, opacity);
    } else
    if (mode == 9.){
        return blendHardLight(base, blend, opacity);
    } else
    if (mode == 10.){
        return blendHardMix(base, blend, opacity);
    } else
    if (mode == 11.){
        return blendLighten(base, blend, opacity);
    } else
    if (mode == 12.){
        return blendLinearBurn(base, blend, opacity);
    } else
    if (mode == 13.){
        return blendLinearDodge(base, blend, opacity);
    } else
    if (mode == 14.){
        return blendLinearLight(base, blend, opacity);
    } else
    if (mode == 15.){
        return blendMultiply(base, blend, opacity);
    } else
    if (mode == 16.){
        return blendNegation(base, blend, opacity);
    } else
    if (mode == 17.){
        return blendNormal(base, blend, opacity);
    } else
    if (mode == 18.){
        return blendOverlay(base, blend, opacity);
    } else
    if (mode == 19.){
        return blendPhoenix(base, blend, opacity);
    } else
    if (mode == 20.){
        return blendPinLight(base, blend, opacity);
    } else
    if (mode == 21.){
        return blendReflect(base, blend, opacity);
    } else
    if (mode == 22.){
        return blendScreen(base, blend, opacity);
    } else
    if (mode == 23.){
        return blendSoftLight(base, blend, opacity);
    } else
    if (mode == 24.){
        return blendSubtract(base, blend, opacity);
    } else
    if (mode == 25.){
        return blendVividLight(base, blend, opacity);
    }

    return base;
}

float LINEARLIGHT(float base, float overlay) {
    return (overlay < 0.5) ? max(base + 2.0 * overlay - 1.0, 0.0) : min(base + 2.0 * overlay - 1.0, 1.0);
}

float LINEARDODGE(float base, float overlay) {
    return min(base + overlay, 1.0);
}

float COLORBURN(float base, float overlay) {
    return (overlay == 0.0) ? overlay : max((1.0-((1.0-base)/overlay)), 0.0);
}

float HARDLIGHT(float base, float overlay) {
    return overlay < 0.5 ? (2.0 * base * overlay) : (1.0 - 2.0 * (1.0 - base) * (1.0 - overlay));
}

vec3 hardmix_blend(vec4 base, vec4 overlay) {
    float plato = base.a * overlay.a;
    vec3 color = step(plato, overlay.rgb * base.a + base.rgb * overlay.a) * (1.0 - step(plato, 0.0));
    return (1.0 - overlay.a) * base.rgb + (1.0 - base.a) * overlay.rgb + base.a * overlay.a * color;
}

vec3 linearburn_blend(vec4 base, vec4 overlay) {
    //     return base.rgb + overlay.rgb - base.a * overlay.a;

    vec3 baseRGB = base.rgb / (base.a + step(base.a, 0.0));
    vec3 overlayRGB = overlay.rgb / (overlay.a + step(overlay.a, 0.0));
    return (1.0 - overlay.a) * base.rgb + (1.0 - base.a) * overlay.rgb + base.a * overlay.a * clamp(baseRGB + overlayRGB - 1.0, 0.0, 1.0);
}


float PINLIGHT(float base, float overlay) {
    return (overlay < 0.5) ? min(base, 2.0 * overlay) : max(base, 2.0 * (overlay - 0.5));
}

vec3 substract_blend(vec4 base, vec4 overlay) {
    vec3 baseRGB = base.rgb / (base.a + step(base.a, 0.0));
    vec3 overlayRGB = overlay.rgb / (overlay.a + step(overlay.a, 0.0));
    vec3 color = max(baseRGB - overlayRGB, 0.0);
    return (1.0 - overlay.a) * base.rgb + (1.0 - base.a) * overlay.rgb + base.a * overlay.a * color;
}

float VIVIDLIGHT(float base, float overlay) {
    return (overlay <= 0.0 || overlay >= 1.0) ? overlay : (overlay < 0.5 ? max(1.0 - (1.0 - base) / (2.0 * overlay), 0.0) : min(base / (2.0 * (1.0 - overlay)), 1.0));
}

float OVERLAY(float base, float overlay) {
    return base < 0.5 ? (2.0 * base * overlay) : (1.0 - 2.0 * (1.0 - base) * (1.0 - overlay));
}

void main(){
    vec4 col1 = texture2D(inputImageTexture, vTexCoord);
    vec4 col2 = texture2D(inputImageTexture2, vTexCoord);

    //    vec4 base = col1;
    //    vec4 blend = col2;
    //    float a = base.a + blend.a * (1.0 - base.a);
    //    vec4 result = vec4(base.rgb + blend.rgb, a);
    //
    //    gl_FragColor = result;
    vec2 textureCoordinate = vTexCoord;
    vec2 textureCoordinate2 = vTexCoord;
    float mixturePercent = opacity;

    if (mode == 1. || mode == 13.) {
        vec4 base = texture2D(inputImageTexture, vTexCoord);
        vec4 overlay = texture2D(inputImageTexture2, vTexCoord);
        gl_FragColor = vec4(mix(base.rgb, vec3(LINEARDODGE(base.r, overlay.r), LINEARDODGE(base.g, overlay.g), LINEARDODGE(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }
    if (mode == 3.){
        vec4 base = texture2D(inputImageTexture, vTexCoord);
        vec4 overlay = texture2D(inputImageTexture2, vTexCoord);
        gl_FragColor = vec4(mix(base.rgb, vec3(COLORBURN(base.r, overlay.r), COLORBURN(base.g, overlay.g), COLORBURN(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
    }
    if (mode == 4.) {
        vec4 base = texture2D(inputImageTexture, vTexCoord);
        vec4 overlay = texture2D(inputImageTexture2, vTexCoord)*mixturePercent;

        vec3 baseOverlayAlphaProduct = vec3(overlay.a * base.a);
        vec3 rightHandProduct = overlay.rgb * (1.0 - base.a) + base.rgb * (1.0 - overlay.a);
        vec3 firstBlendColor = baseOverlayAlphaProduct + rightHandProduct;
        vec3 overlayRGB = clamp((overlay.rgb / clamp(overlay.a, 0.01, 1.0)) * step(0.0, overlay.a), 0.0, 0.99);
        vec3 secondBlendColor = (base.rgb * overlay.a) / (1.0 - overlayRGB) + rightHandProduct;
        vec3 colorChoice = step((overlay.rgb * base.a + base.rgb * overlay.a), baseOverlayAlphaProduct);
        vec3 Cr = mix(firstBlendColor, secondBlendColor, colorChoice);

        gl_FragColor = vec4(Cr, base.a + overlay.a - base.a * overlay.a);
        return;
    }
    if (mode == 5.) {
        vec4 base = texture2D(inputImageTexture, vTexCoord);
        vec4 overlay = texture2D(inputImageTexture2, vTexCoord)*mixturePercent;

        float alpha = overlay.a + base.a - overlay.a * base.a;
        gl_FragColor = vec4(min(overlay.rgb * base.a, base.rgb * overlay.a) + overlay.rgb * (1.0 - base.a) + base.rgb * (1.0 - overlay.a), alpha);
        return;
    }
    if (mode == 6.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2)*mixturePercent;

        float alpha = overlay.a + base.a - overlay.a * base.a;
        gl_FragColor = vec4(abs(overlay.rgb - base.rgb), alpha);
        return;
    }
    if (mode == 7.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2)*mixturePercent;

        //     Dca = (Sca.Da + Dca.Sa - 2.Sca.Dca) + Sca.(1 - Da) + Dca.(1 - Sa)

        float alpha = overlay.a + base.a - overlay.a * base.a;
        gl_FragColor = vec4((overlay.rgb * base.a + base.rgb * overlay.a - 2.0 * overlay.rgb * base.rgb) + overlay.rgb * (1.0 - base.a) + base.rgb * (1.0 - overlay.a), alpha);
        return;
    }
    if (mode == 9.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2);
        gl_FragColor = vec4(mix(base.rgb, vec3(HARDLIGHT(base.r, overlay.r), HARDLIGHT(base.g, overlay.g), HARDLIGHT(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }
    if (mode == 10.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2)*mixturePercent;

        gl_FragColor = vec4(hardmix_blend(base, overlay), base.a + overlay.a - base.a * overlay.a);
        return;
    }
    if (mode == 11.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2)*mixturePercent;
        gl_FragColor = vec4(max(overlay.rgb + (1.0 - overlay.a) * base.rgb, base.rgb + (1.0 - base.a) * overlay.rgb), base.a + overlay.a - base.a * overlay.a);
        return;
    }
    if (mode == 12.) { //linearburn
        lowp vec4 base = texture2D(inputImageTexture, textureCoordinate);
        lowp vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2) * opacity;

        gl_FragColor = vec4(linearburn_blend(base, overlay), base.a + overlay.a - base.a * overlay.a);
        return;
    }
    if (mode == 14.) {
        vec4 base = texture2D(inputImageTexture, vTexCoord);
        vec4 overlay = texture2D(inputImageTexture2, vTexCoord);
        gl_FragColor = vec4(mix(base.rgb, vec3(LINEARLIGHT(base.r, overlay.r), LINEARLIGHT(base.g, overlay.g), LINEARLIGHT(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }
    if (mode == 15.) {
        lowp vec4 base = texture2D(inputImageTexture, textureCoordinate);
        lowp vec4 overlayer = texture2D(inputImageTexture2, textureCoordinate2) * opacity;

        gl_FragColor = overlayer * base + overlayer * (1.0 - base.a) + base * (1.0 - overlayer.a);
        return;
    }
    if (mode == 17.) {
        lowp vec4 base = texture2D(inputImageTexture, vTexCoord);
        lowp vec4 overlay = texture2D(inputImageTexture2, vTexCoord) * opacity;
        gl_FragColor = base + overlay - base * overlay.a;
        return;
    }
    if (mode == 18.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2);
        gl_FragColor = vec4(mix(base.rgb, vec3(OVERLAY(base.r, overlay.r), OVERLAY(base.g, overlay.g), OVERLAY(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }
    if (mode == 20.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2);
        gl_FragColor = vec4(mix(base.rgb, vec3(PINLIGHT(base.r, overlay.r), PINLIGHT(base.g, overlay.g), PINLIGHT(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }
    if (mode == 22.) {
        vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);
        vec4 textureColor2 = texture2D(inputImageTexture2, textureCoordinate2) * opacity;

        vec4 whiteColor = vec4(1.0);
        gl_FragColor = whiteColor - ((whiteColor - textureColor2) * (whiteColor - textureColor));
        return;
    }
    if (mode == 23.) {
        mediump vec4 base = texture2D(inputImageTexture, textureCoordinate);
        mediump vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2) * opacity;
        gl_FragColor = 2.0 * base * overlay + base*base -2.0*base*base*overlay;
        return;
    }
    if (mode == 24.) {
        lowp vec4 base = texture2D(inputImageTexture, textureCoordinate);
        lowp vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2) * opacity;

        gl_FragColor = vec4(substract_blend(base, overlay), base.a + overlay.a - base.a * overlay.a);
        return;
    }
    if (mode == 25.) {
        vec4 base = texture2D(inputImageTexture, textureCoordinate);
        vec4 overlay = texture2D(inputImageTexture2, textureCoordinate2);
        gl_FragColor = vec4(mix(base.rgb, vec3(VIVIDLIGHT(base.r, overlay.r), VIVIDLIGHT(base.g, overlay.g), VIVIDLIGHT(base.b, overlay.b)), overlay.a * mixturePercent), base.a);
        return;
    }

    gl_FragColor = vec4(blendMode(mode, col1.rgb, col2.rgb, opacity), 1.0);

}