precision highp float;
#define fragColor gl_FragColor
varying  vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform  float strength;
uniform  float warp;

//const vec3 W = vec3(0.2125, 0.7154, 0.0721);
//float rgb2gray(vec3 color){
//    return dot(color.rgb, W);
//}
//
//
//float sobelDx(){
//    float dx = rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(-1., -1.) / 720.).rgb) * 0.187
//    + rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(-1., 0.) / 720.).rgb) * (1. - 0.187 * 2.)
//    + rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(-1., 1.) / 720.).rgb) * 0.187
//
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(1., -1.) / 720.).rgb) * 0.187
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(1., 0.) / 720.).rgb) * (1. - 0.187 * 2.)
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate +  vec2(1., 1.) / 720.).rgb) * 0.187;
//    return dx;
//}
//
//
//float sobelDy(){
//    float dy = rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(1., -1.) / 720.).rgb) * 0.187
//    + rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(0., -1.) / 720.).rgb) * (1. - 0.187 * 2.)
//    + rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(-1., -1.) / 720.).rgb) * 0.187
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(1., 1.) / 720.).rgb) * 0.187
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(0., 1.) / 720.).rgb) * (1. - 0.187 * 2.)
//    - rgb2gray(texture2D(inputImageTexture2, textureCoordinate + vec2(-1., 1.) / 720.).rgb) * 0.187;
//    return dy;
//}


void main() {
    vec2 uv = textureCoordinate;
    vec4 tempPixel = texture2D(inputImageTexture2, uv);
    vec4 srcPixel = texture2D(inputImageTexture, uv);

    float lumSrc = (srcPixel.r + srcPixel.g + srcPixel.b) / 3.;
    float lum = (tempPixel.r + tempPixel.g  + tempPixel.b) / 3.;

//    lum = max(0., lum - 0.5) + 0.1;
//
    float scale = (1. - pow(abs(lum * 10.), 0.8));
//
//    vec2 dxdy = vec2(sobelDx(), sobelDy());
//
//    if(dxdy.x < 0.){
//        dxdy.x -= 0.1;
//    }else{
//        dxdy.x += 0.1;
//    }
//
//    if(dxdy.y < 0.){
//        dxdy.y -= 0.1;
//    }else{
//        dxdy.y += 0.1;
//    }
//
//    dxdy = dxdy / max(abs(dxdy.x), abs(dxdy.y));

    uv += (strength * lum * scale * uv / (1. + warp));

    vec3 col = texture2D(inputImageTexture, uv).rgb;

    col += (strength * col * scale / (1. + warp));
    gl_FragColor = vec4(col, 1.0);

}