precision highp float;

uniform sampler2D sTexture;
uniform sampler2D u_Texture2;

uniform float angle;

varying float lum;


vec4 blendScreen(vec4 col1, vec4 col2, float opacity) {
    vec4 whiteColor = vec4(1.0);
    return whiteColor - ((whiteColor - col2 * opacity) * (whiteColor - col1));
}

vec4 blendMultiply(vec4 col1, vec4 col2) {
    return col1 * col2;
}

vec4 blendColorDodge(vec4 col1, vec4 col2, float opacity) {
    vec4 base = col1;
    vec4 overlay = col2 * opacity;

    vec3 baseOverlayAlphaProduct = vec3(overlay.a * base.a);
    vec3 rightHandProduct = overlay.rgb * (1.0 - base.a) + base.rgb * (1.0 - overlay.a);

    vec3 firstBlendColor = baseOverlayAlphaProduct + rightHandProduct;
    vec3 overlayRGB = clamp((overlay.rgb / clamp(overlay.a, 0.01, 1.0)) * step(0.0, overlay.a), 0.0, 0.99);

    vec3 secondBlendColor = (base.rgb * overlay.a) / (1.0 - overlayRGB) + rightHandProduct;

    vec3 colorChoice = step((overlay.rgb * base.a + base.rgb * overlay.a), baseOverlayAlphaProduct);

    float alpha = overlay.a + base.a - overlay.a * base.a;

    return vec4(mix(firstBlendColor, secondBlendColor, colorChoice), alpha);
}

void main() {
    vec2 uv = vec2(gl_PointCoord.x, 1.0 - gl_PointCoord.y);

    uv -= vec2(0.5);
    uv *= mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
    uv += vec2(0.5);

    vec4 shape = texture2D(sTexture, uv);
//    vec4 col = texture2D(u_Texture2, uv);
//    vec4 shape0 = shape;

    //    shape = blendColorDodge(shape0, shape0, 1.0);
    //    shape = blendColorDodge(shape, shape0, lum);

    //    if (lum > 0.3f) {
    //        shape = blendColorDodge(shape0, shape0, lum);
    //    }
    //    if (lum > 0.7f) {
    //        shape = blendColorDodge(shape, shape0, lum);
    //    }
    //    if (lum > 0.9f) {
    //        shape = blendColorDodge(shape, shape0, lum);
    //    }

//    vec4 res = shape;//
    //    res = blendMultiply(shape, col);

    //    res = blendScreen(res, res, lum);

    gl_FragColor = shape;

    //    gl_FragColor = vec4(vec3(lum), 1.0);

}