attribute vec4 aPosition;
attribute float brightness;

uniform vec2 u_Size;

uniform sampler2D u_Texture1;
uniform float scale1;
uniform float scale2;
uniform float scale3;
uniform float scale4;
uniform float tex_num;
uniform vec4 thresold;
varying float lum;


float calcPointSize(float brightness, float intensity) {
    float p = intensity/0.5;
    return u_Size.x *2./10.*mix(0.5, 4., brightness/6.)*(1./0.3*0.3*p);
}

void main(){
    vec2 uv = aPosition.xy*0.5+0.5;
    float r = texture2D(u_Texture1, uv).r;

    lum = brightness;

    //    gl_PointSize = u_Size.x *2./10.*brightness*(1./0.3*scale);
    gl_PointSize = calcPointSize(brightness, 0.5);

    if (tex_num == 2.) {
        if (lum <= thresold.x) {
            gl_PointSize = calcPointSize(brightness, scale2);
        } else {
            gl_PointSize = calcPointSize(brightness, scale1);
        }
    }
    else if (tex_num == 3.) {
        if (lum <= thresold.x) {
            gl_PointSize = calcPointSize(brightness, scale3);
        } else if (lum <= thresold.y) {
            gl_PointSize = calcPointSize(brightness, scale2);
        } else {
            gl_PointSize = calcPointSize(brightness, scale1);
        }
    }
    else if (tex_num == 4.) {
        if (lum <= thresold.x) {
            gl_PointSize = calcPointSize(brightness, scale4);
        } else if (lum <= thresold.y) {
            gl_PointSize = calcPointSize(brightness, scale3);
        } else if (lum <= thresold.z) {
            gl_PointSize = calcPointSize(brightness, scale2);
        } else {
            gl_PointSize = calcPointSize(brightness, scale1);
        }
    } else {
        gl_PointSize = calcPointSize(brightness, scale1);
    }

    gl_Position = aPosition;

}