attribute vec4 aPosition;
attribute float brightness;

uniform vec2 u_Size;

uniform sampler2D u_Texture1;
uniform float scale;

varying float lum;

void main(){
    vec2 uv = aPosition.xy*0.5+0.5;
    float r = texture2D(u_Texture1, uv).r;

    lum = r;

    gl_PointSize = u_Size.x *2./10.*brightness*(1./0.3*scale);//mix(0., u_Size.x *2./3., step(0.1, r));
    gl_Position = aPosition;
}