#extension GL_OES_EGL_image_external : require
precision highp float;

varying vec2 outTexCoord;

uniform sampler2D texture;
uniform samplerExternalOES oesOverlayTexture;

void main() {
    vec4 color = texture2D(texture, outTexCoord);
    vec2 coord = vec2(outTexCoord.x, 1.0 - outTexCoord.y);
    vec4 overlayColor = texture2D(oesOverlayTexture, coord);
    gl_FragColor = overlayColor + (1.0 - overlayColor.a) * color;
//    gl_FragColor = overlayColor.a * overlayColor + (1.0 - overlayColor.a) * color;
//    gl_FragColor = mix(overlayColor, color, (1.0 - overlayColor.a));
}