precision highp float;

varying vec2 outTexCoord;

uniform sampler2D texture;
uniform sampler2D lutTexture;
uniform float intensity;

void main() {

    vec4 textureColor = texture2D(texture, outTexCoord);

    float blueColor = textureColor.b * 63.0;
    vec2 quad1;
    quad1.y = floor(floor(blueColor) / 8.0);
    quad1.x = floor(blueColor) - (quad1.y * 8.0);
    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 8.0);
    quad2.x = ceil(blueColor) - (quad2.y * 8.0);
    vec2 texPos1;
    texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
    texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);

//    vec2 t11;
//    t11.x = 1. / 512. * floor(texPos1.x / (1. / 512.));
//    t11.y = 1. / 512. * floor(texPos1.y / (1. / 512.));
//    vec2 t12;
//    t12.x = 1. / 512. * ceil(texPos1.x / (1. / 512.));
//    t12.y = 1. / 512. * ceil(texPos1.y / (1. / 512.));
//    vec4 color11 = texture2D(lutTexture, t11);
//    vec4 color12 = texture2D(lutTexture, vec2(t11.x, t12.y));
//    vec4 color21 = texture2D(lutTexture, vec2(t12.x, t11.y));
//    vec4 color22 = texture2D(lutTexture, t12);
//
//    float weight1 = mod(texPos1.x, 1. / 512.) * 512.;
//    float weight2 = mod(texPos1.x, 1. / 512.) * 512.;
//    vec4 newColor1 = mix(mix(color11, color21, weight1), mix(color12, color22, weight1), weight2);


    vec2 texPos2;
    texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
    texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);

//    t11.x = 1. / 512. * floor(texPos2.x / (1. / 512.));
//    t11.y = 1. / 512. * floor(texPos2.y / (1. / 512.));
//    t12.x = 1. / 512. * ceil(texPos2.x / (1. / 512.));
//    t12.y = 1. / 512. * ceil(texPos2.y / (1. / 512.));
//    color11 = texture2D(lutTexture, t11);
//    color12 = texture2D(lutTexture, vec2(t11.x, t12.y));
//    color21 = texture2D(lutTexture, vec2(t12.x, t11.y));
//    color22 = texture2D(lutTexture, t12);

//    weight1 = mod(texPos2.x, 1. / 512.) * 512.;
//    weight2 = mod(texPos2.x, 1. / 512.) * 512.;
//    vec4 newColor2 = mix(mix(color11, color21, weight1), mix(color12, color22, weight1), weight2);


    vec4 newColor1 = texture2D(lutTexture, texPos1);
    vec4 newColor2 = texture2D(lutTexture, texPos2);
    vec4 newColor = mix(newColor1, newColor2, fract(blueColor));
    gl_FragColor = mix(textureColor, vec4(newColor.rgb, textureColor.w), intensity);
}