precision highp float;

varying vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform vec2 u_Size;
uniform float bstep;
uniform int radius;
uniform float spacesmooth2;

#define RADIUS    (5)
//#define BLENDCMIN   (-2.)
//#define BLENCCMAX   (-1.)
//#define DIAMETER    (2*RADIUS+1)
#define SPACESMOOTH (2./1.41)
#define INTENSITYSMOOTH (0.12)

#define EPSILON    (1e-15)
#define LUMWEIGHT   (vec4(0.2126, 0.7152, 0.0722, 0.))
//转YUV lum = 0.2126R + 0.7152G + 0.0722B
#define INTENSITYSMOOTH2 (INTENSITYSMOOTH*INTENSITYSMOOTH)
#define SPACESMOOTH2 (float(RADIUS*RADIUS)*SPACESMOOTH*SPACESMOOTH)

//#define STEP (5)


void main()
{
    vec2 fragCoord = u_Size*textureCoordinate;
    vec4 pixelColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 fragColor = vec4(0.);
    vec4 diff = vec4(0.);
    vec4 color = vec4(0.);
    float sum = 0.;
    float coeff = 0.;

    for (int i = -radius; i <= radius; i++){
        for (int j = -radius; j <= radius; j++){
            color = texture2D(inputImageTexture, (fragCoord+vec2(float(i)*bstep, float(j)*bstep))/u_Size);
            diff = color - pixelColor;
            coeff = exp(-(dot(diff*diff, LUMWEIGHT)/INTENSITYSMOOTH2+float(i*i+j*j)/spacesmooth2));
            fragColor += color*coeff;
            sum += coeff;
        }
    }

    fragColor = fragColor/sum;


    coeff = 1.;
    //    coeff = clamp((log(sum/float(DIAMETERSQUARE))-BLENDCMIN)/(BLENCCMAX-BLENDCMIN), 0., 1.);

    diff = (pixelColor - fragColor)*coeff;
    gl_FragColor =vec4( ((diff+1.)/2.).rgb, 1.);
}