package com.inmovation.android.assets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import com.inmovation.tools.LogUtil;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

public class AssetsDataBaseManager {

	public static final String TAG = AssetsDataBaseManager.class.getSimpleName();
	Context context;

	String dbname;

	public AssetsDataBaseManager(Context context, String dbName) {
		this.context = context;
		this.dbname = dbName;
	}

	public SQLiteDatabase getSQLiteDatabase() {
		
		String dbpath = getFilepath(dbname);
		File file = new File(dbpath);
		if(!file.exists())
		{
			copyAssetsDBToFileCache(dbname);
		}
		
		LogUtil.d(TAG, "getSQLiteDatabase:"+dbpath);
		return context.openOrCreateDatabase(dbpath, Context.MODE_PRIVATE, null);
	}

	private String getFilepath(String filename) {
		return context.getFilesDir().getAbsolutePath() + "/" + filename;
	}

	public void closeSQLiteDatabase(SQLiteDatabase db)
	{
		if(db !=null)
		{
			db.close();
		}
		db = null;
	}
	/**
	 * 将assets目录下文件复制到
	 * @param fileName
	 */
	private void copyAssetsDBToFileCache(String fileName) {
		try {
			InputStream input = context.getAssets().open(fileName);
			String filedir = getFilepath(fileName);
			File file = new File(filedir);
			if (file != null && file.exists()) {
				file.delete();
			}
			FileOutputStream fos = new FileOutputStream(file);
			int i = 0;
			byte[] buffer = new byte[2048];
			while ((i = input.read(buffer)) != -1) {
				fos.write(buffer, 0, i);
			}
			fos.close();
			input.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
