package com.inmovation.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class DbBlobUtil {

	public static Object getObjectFromBlob(byte[] bys)
			throws StreamCorruptedException, IOException,
			ClassNotFoundException {
		if(isEmpty(bys)) return null;
		ByteArrayInputStream bis = new ByteArrayInputStream(bys);
		ObjectInputStream ois = new ObjectInputStream(bis);
		return ois.readObject();
	}

	public static  byte[] getBlobFromObject(Object obj) throws IOException {
		if(obj == null) return null;
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos;
		oos = new ObjectOutputStream(baos);
		oos.writeObject(obj);
		return baos.toByteArray();
	}
	
	public static boolean isEmpty(byte[] bys)
	{
		if(bys!= null&&bys.length>0) return false;
		return true;
	}
}
