package com.inmovation.db;

import java.util.List;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

/**
 * 
 * @文件描述 
 * @author whroid
 * @create 2014-3-26
 */
public  class IDBManager {
	
    private SQLiteOpenHelper    dbHelper  ;
    private SQLiteDatabase      mReadDB;
    private SQLiteDatabase      mWriteDB;
    private static IDBManager    mDBManager;
    Context mContext;
    
    public static synchronized IDBManager getInstance(Context mContext)
    {
    	if(mDBManager == null)
    	{
    		 synchronized (IDBManager.class) {
                 if (mDBManager == null) {
                	 mDBManager = new IDBManager(mContext);
                 }
             }
    	}
    	return mDBManager;
    }
    
    public IDBManager(Context mContext)
    {
    	dbHelper = new MSQLiteOpenHelper(mContext, getDatabaseName(), getDatabaseVersion(),getAllTable());
    }
    
    public IDBManager(){}
    public synchronized SQLiteDatabase getReadSQLiteDatabase()
    {
    	if(mReadDB == null)
    	{
    		mReadDB = dbHelper.getReadableDatabase();
    	}
    	return mReadDB;
    }
    public synchronized SQLiteDatabase getWritableDatabase()
    {
    	if(mWriteDB == null)
    	{
    		mWriteDB = dbHelper.getWritableDatabase();
    	}
    	return mWriteDB;
    }
    
    public synchronized void close()
    {
    	if(mWriteDB != null)
    	{
    		mWriteDB.close();
    	}
    	if(mReadDB != null)
    	{
    		mReadDB.close();
    	}
    }

    public   List<ITable> getAllTable(){
    	return null;
    }
    public String getDatabaseName()
    {
    	return mContext.getPackageName();
    }
    public int getDatabaseVersion()
    {
    	return 1;
    }
}
