package com.inmovation.tools.file;

import java.io.File;

public class WFile implements Comparable<WFile> {

	String filename;
	String filepath;
	long length;
	boolean isDirectory;
	int childCount;

	public WFile(){}
	public WFile(File file) {
		filename = file.getName();
		filepath = file.getAbsolutePath();
		length = file.length();
		isDirectory = file.isDirectory();
		
		File[] files = file.listFiles();
		if(files != null)
		{
			childCount = files.length;
		}
	}

	public int getChildCount() {
		return childCount;
	}
	public void setChildCount(int childCount) {
		this.childCount = childCount;
	}
	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public String getFilepath() {
		return filepath;
	}

	public void setFilepath(String filepath) {
		this.filepath = filepath;
	}

	public long getLength() {
		return length;
	}

	public void setLength(long length) {
		this.length = length;
	}

	public boolean isDirectory() {
		return isDirectory;
	}

	public void setDirectory(boolean isDirectory) {
		this.isDirectory = isDirectory;
	}

	@Override
	public int compareTo(WFile another) {

		if (isDirectory() && another.isDirectory()) {
			return getFilename().toLowerCase().compareTo(another.getFilename().toLowerCase());
		} else if (isDirectory() && !another.isDirectory()) {
			return 1;
		} else if (!isDirectory() && another.isDirectory()) {
			return -1;
		}
		return 0;
	}

}
