package com.inmovation.tools.image.crop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

/**
 * 头像图片选择框的浮层
 *
 */
public class FloatDrawable extends Drawable {
	
	private Context mContext;
	private Paint mLinePaint=new Paint();
	{
	    mLinePaint.setARGB(200, 50, 50, 50);
	    mLinePaint.setStrokeWidth(1F);
	    mLinePaint.setStyle(Paint.Style.STROKE);
	    mLinePaint.setAntiAlias(true);
	    mLinePaint.setColor(Color.WHITE);
	}
	
	public FloatDrawable(Context context) {
		super();
		this.mContext=context;
	}
	

	@Override
	public void draw(Canvas canvas) {
		
		int left=getBounds().left;
		int top=getBounds().top;
		int right=getBounds().right;
		int bottom=getBounds().bottom;
		
		Rect mRect=new Rect(
				left, 
				top, 
				right, 
				bottom);
		//方框
		canvas.drawRect(mRect, mLinePaint);
		
	/*	//左上
		mCropPointDrawable.setBounds(left, top, left+mCropPointDrawable.getIntrinsicWidth(), top+mCropPointDrawable.getIntrinsicHeight());
		mCropPointDrawable.draw(canvas);
		
		//右上
		mCropPointDrawable.setBounds(right-mCropPointDrawable.getIntrinsicWidth(), top, right, top+mCropPointDrawable.getIntrinsicHeight());
		mCropPointDrawable.draw(canvas);
		
		//左下
		mCropPointDrawable.setBounds(left, bottom-mCropPointDrawable.getIntrinsicHeight(), left+mCropPointDrawable.getIntrinsicWidth(), bottom);
		mCropPointDrawable.draw(canvas);
		
		//右下
		mCropPointDrawable.setBounds(right-mCropPointDrawable.getIntrinsicWidth(), bottom-mCropPointDrawable.getIntrinsicHeight(), right, bottom);
		mCropPointDrawable.draw(canvas);*/
		
	}

	@Override
	public void setBounds(Rect bounds) {
		super.setBounds(new Rect(
				bounds.left, 
				bounds.top, 
				bounds.right, 
				bounds.bottom));
	}

	@Override
	public void setAlpha(int alpha) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setColorFilter(ColorFilter cf) {
		// TODO Auto-generated method stub

	}

	@Override
	public int getOpacity() {
		// TODO Auto-generated method stub
		return 0;
	}

}
