package com.inmovation.tools.image.load;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;

import com.inmovation.tools.image.load.impl.Imager;

public class LoaderImagerRunnable implements  Runnable{
	Handler handler;
	Imager mImageObserver;

	boolean no_use_cache_but_does;

	public LoaderImagerRunnable(Imager mImageObserver, Handler handler) {
		this.handler = handler;
		this.mImageObserver = mImageObserver;
	}

	public LoaderImagerRunnable(Imager mImageObserver, Handler handler,
			boolean no_use_cache_but_does) {
		this.handler = handler;
		this.mImageObserver = mImageObserver;
		this.no_use_cache_but_does = no_use_cache_but_does;
	}

	@Override
	public void run() {
		Bitmap bitmap = ImageMemoryCacheManager.getInstance()
				.getBitmapFromMemoryCache(
						mImageObserver.getMemoryCacheName());
		if (no_use_cache_but_does || bitmap == null) {
			bitmap = ImageLoader.loadImageFromUrl(mImageObserver.getUrl());
		}
		if (mImageObserver.getMemoryCacheName() != null && bitmap != null) {
			ImageMemoryCacheManager.getInstance().addBitmapToMemoryCache(
					mImageObserver.getMemoryCacheName(), bitmap);
		}
		mImageObserver.setBitmap(bitmap);
		Message message = handler.obtainMessage(0, mImageObserver);
		handler.sendMessage(message);
	}
}
