package com.inmovation.tools.image.load;

import java.io.FileNotFoundException;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;

import com.inmovation.tools.image.load.impl.Imager;

public class LoaderImagerSDRunnable implements Runnable{
	
	public static final String TAG = LoaderImagerSDRunnable.class.getSimpleName();
	Handler handler;

	Imager mImageObserver;

	public LoaderImagerSDRunnable(Imager mImageObserver, Handler handler) {
		this.handler = handler;
		this.mImageObserver = mImageObserver;
	}

	@Override
	public void run() {

		Bitmap bitmap = ImageMemoryCacheManager.getInstance()
				.getBitmapFromMemoryCache(
						mImageObserver.getMemoryCacheName());
		if (bitmap == null) {
			try {
				bitmap = ImageLoader.loadImageFromSDCard(mImageObserver
						.getUrl());
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				ImagerLog.e(TAG, "图片路径未找到：" + mImageObserver.getUrl());
			} catch (OutOfMemoryError error) {
				ImagerLog.e(TAG, "图片内存溢出：" + mImageObserver.getUrl());
				System.gc();
			}
		}
		if (mImageObserver.getMemoryCacheName() != null && bitmap != null) {
			ImageMemoryCacheManager.getInstance().addBitmapToMemoryCache(
					mImageObserver.getMemoryCacheName(), bitmap);
		}
		mImageObserver.setBitmap(bitmap);
		Message message = handler.obtainMessage(0, mImageObserver);
		handler.sendMessage(message);
	}
}
