package com.inmovation.tools.image.load.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.inmovation.tools.image.ImageObserver;
import com.inmovation.tools.image.load.ImageMemoryCacheManager;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.ImageView;

public class AsyncImagerManager implements IAsyncImagerManager{

	static ExecutorService mExecutorService;
	
	public static void initImager()
	{
		int nThreads = Runtime.getRuntime().availableProcessors();
		mExecutorService = Executors.newFixedThreadPool(nThreads);
	}
	public AsyncImagerManager()
	{
		
	}
	 void execute(Runnable run){
		 if(mExecutorService != null)
		mExecutorService.execute(run);
	}
	@Override
	public Bitmap loadImage(Imager imager, final ImagerCallback imageCallback) {
		Bitmap bitmap = ImageMemoryCacheManager.getInstance()
				.getBitmapFromMemoryCache(imager.getMemoryCacheName());
		if (bitmap != null) {
			return bitmap;
		}

		final Handler handler = new Handler() {
			public void handleMessage(Message message) {
				imageCallback.imageLoaded((Imager) message.obj);
			}
		};

//		Runnable loadTask;
//		if (!imager.isHttpUrl()) {
//			loadTask = new LoaderImageSdTask(imager, handler);
//		} else {
//			loadTask = new LoaderImageTask(imager, handler);
//		}
//		mExecutorService.execute(loadTask);
//		return null;
		return null;
	}
	@Override
	public void loadImage(Imager imager, ImageView imageview) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void loadImage(Imager imager, ImageView imageview, View parentView) {
		// TODO Auto-generated method stub
		
	}
	 
}
