package com.inmovation.tools.image.load.impl;

import android.graphics.Bitmap;

import com.inmovation.tools.StringUtil;
import com.inmovation.tools.image.load.MD5FileNameGenerator;

public abstract class Imager {

	protected String id;  //文件保存的名称
	protected String url; //网络请求地址,或者本地路径
	protected String tag; //tag
	
	public Imager()
	{
		this.tag = System.currentTimeMillis() +""+(int)(Math.random()*50);
	}
	public Imager(String id,String url)
	{
		this.id = id;
		this.url = url;
		this.tag = MD5FileNameGenerator.generate(url);
	}
	public Imager(String url)
	{
		this.url = url;
		this.tag = MD5FileNameGenerator.generate(url);
		this.id = tag;
	}
	
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getTag() {
		return tag;
	}
	public void setTag(String tag) {
		this.tag = tag;
	}
	public   String getMemoryCacheName()
	{
		if(StringUtil.isEmpty(id))
		{
			return MD5FileNameGenerator.generate(url);
		}
		return id;
	}
	public  String getFileCacheName()
	{
		if(StringUtil.isEmpty(id))
		{
			return MD5FileNameGenerator.generate(url);
		}
		return id;
	}
	
	public abstract void setBitmap(Bitmap bitmap);
	
	public boolean isHttpUrl()
	{
		return true;
	}
}
