package com.inmovation.tools.pinyin;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

import com.inmovation.tools.pinyin.HanziToPinyin.Token;

public class HanziToPinyinUtil extends ChineseToPinyin {

	public static String getHanziToPinyin(String source) {
		boolean isChina=!Arrays.asList(Collator.getAvailableLocales()).contains(
				Locale.CHINA)&&!Arrays.asList(Collator.getAvailableLocales()).contains(
						Locale.CHINESE);
		if (isChina) {
			return source;
		}

		ArrayList<Token> tokens = HanziToPinyin.getInstance().get(source);

		if (tokens == null || tokens.size() == 0) {
			return source;
		}

		StringBuffer result = new StringBuffer();
		for (Token token : tokens) {
			if (token.type == Token.PINYIN) {
				result.append(token.target);
			} else {
				result.append(token.source);
			}
		}
		return result.toString();
	}

	public static String getFirstPinYin(String source) {
		boolean isChina=!Arrays.asList(Collator.getAvailableLocales()).contains(
				Locale.CHINA)&&!Arrays.asList(Collator.getAvailableLocales()).contains(
						Locale.CHINESE);
		if (isChina) {
			return source;
		}
		ArrayList<Token> tokens = HanziToPinyin.getInstance().get(source);
		if (tokens == null || tokens.size() == 0) {
			return source;
		}
		StringBuffer result = new StringBuffer();
		for (Token token : tokens) {
			if (token.type == Token.PINYIN) {
				result.append(token.target.charAt(0));
			} else {
				result.append("#");
			}
		}
		return result.toString();
	}


	@Override
	public Set<String> getChineseToPinyin(String chinese) {
		// TODO Auto-generated method stub
		String pinyi = getHanziToPinyin(chinese);
		Set<String> set = new HashSet<String>();
		set.add(pinyi);
		return set;

	}
}
