package com.inmovation.tools.pinyin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.inmovation.tools.LogUtil;


import android.widget.Filter;

/**
 * 模板类T，是通过T的tostring（）数据进行比对
 * 
 * @description
 * @author whroid
 * @creator 2014-4-29 下午2:04:49
 * 
 * @param <T>
 */
public class PinyinFilter<T> extends Filter {
	public static final String TAG = "PinyinFilter";
	private List<T> mObjects;
	private List<Set<String>> pinyinList;// 支持多音字,类似:{{z,c},{j},{z},{q,x}}的集合
	private final Object mLock = new Object();
	private ArrayList<T> mOriginalValues;
	public static final int ALL = -1;// 全部
	private int maxMatch = 0;// 最多显示多少个可能选项
	PinyinFilterAdatper<T> mBaseApdater;

	
	ChineseToPinyin mChineseToPinyin = ChineseToPinyinFactory
			.getChineseToPinyin();

	
	// 支持多音字
	public PinyinFilter(T[] objects, PinyinFilterAdatper<T> mBaseApdater) {
		init(objects);
		this.pinyinList = getHanziSpellList(objects);
		this.mBaseApdater = mBaseApdater;
	}

	public PinyinFilter(List<T> objects, PinyinFilterAdatper<T> mBaseApdater) {
		init(objects);
		this.pinyinList = getHanziSpellList(objects);
		this.mBaseApdater = mBaseApdater;
	}

	public void setSearchMaxMatchNum(int maxMatch)
	{
		this.maxMatch = maxMatch;
	}
	private void init(List<T> objects) {
		mObjects = objects;
	}

	private void init(T[] objects) {
		mObjects = Arrays.asList(objects);
	}

	/**
	 * 获得汉字拼音首字母列表
	 */
	private List<Set<String>> getHanziSpellList(T[] hanzi) {
		List<Set<String>> listSet = new ArrayList<Set<String>>();
		for (int i = 0; i < hanzi.length; i++) {
			// listSet.add(pinyin.getPinyin(hanzi[i].toString()));
			listSet.add(mChineseToPinyin.getChineseToPinyin(hanzi[i].toString()));
		}
		return listSet;
	}

	/**
	 * 获得汉字拼音首字母列表
	 */
	private List<Set<String>> getHanziSpellList(List<T> hanzi) {
		List<Set<String>> listSet = new ArrayList<Set<String>>();
		if (hanzi == null) {
			return listSet;
		}
		for (int i = 0; i < hanzi.size(); i++) {
			LogUtil.d(TAG, hanzi.get(i).toString());
			// listSet.add(pinyin.getPinyin(hanzi.get(i).toString()));
			listSet.add(mChineseToPinyin.getChineseToPinyin(hanzi.get(i)
					.toString()));
		}
		return listSet;
	}

	@Override
	protected FilterResults performFiltering(CharSequence prefix) {
		FilterResults results = new FilterResults();

		if (mOriginalValues == null) {
			synchronized (mLock) {
				mOriginalValues = new ArrayList<T>(mObjects);//
			}
		}

		if (prefix == null || prefix.length() == 0) {
			synchronized (mLock) {
				ArrayList<T> list = new ArrayList<T>(mOriginalValues);// List<T>
				results.values = list;
				results.count = list.size();
			}
		} else {
			String prefixString = prefix.toString().toLowerCase();

			final ArrayList<T> hanzi = mOriginalValues;// 汉字String
			final int count = hanzi.size();

			final Set<T> newValues = new HashSet<T>(count);// 支持多音字,不重复

			for (int i = 0; i < count; i++) {
				final T value = hanzi.get(i);// 汉字String
				final String valueText = value.toString().toLowerCase();// 汉字String
				final Set<String> pinyinSet = pinyinList.get(i);// 支持多音字,类似:{z,c}
				Iterator iterator = pinyinSet.iterator();// 支持多音字
				while (iterator.hasNext()) {// 支持多音字
					final String pinyin = iterator.next().toString()
							.toLowerCase();// 取出多音字里的一个字母

					if (pinyin.indexOf(prefixString) != -1) {// 任意匹配
						newValues.add(value);
					} else if (valueText.indexOf(prefixString) != -1) {// 如果是汉字则直接添加
						newValues.add(value);
					}
				}
				if (maxMatch > 0) {// 有数量限制
					if (newValues.size() > maxMatch - 1) {// 不要太多
						break;
					}
				}

			}
			List<T> list = Set2List(newValues);// 转成List
			results.values = list;
			results.count = list.size();
		}
		return results;
	}

	protected void publishResults(CharSequence constraint, FilterResults results) {

		mObjects = (List<T>) results.values;
		if (mBaseApdater == null) {
			return;
		}
		for (T t : mObjects) {
			LogUtil.d(TAG, "publishResults:" + t.toString());
		}
		mBaseApdater.setData(mObjects);
		if (results.count > 0) {
			mBaseApdater.notifyDataSetChanged();
		} else {
			mBaseApdater.notifyDataSetInvalidated();
		}
	}

	// List Set 相互转换
	public <T extends Object> Set<T> List2Set(List<T> tList) {
		Set<T> tSet = new HashSet<T>(tList);
		// TODO 具体实现看需求转换成不同的Set的子类。
		return tSet;
	}

	public <T extends Object> List<T> Set2List(Set<T> oSet) {
		List<T> tList = new ArrayList<T>(oSet);
		// TODO 需要在用到的时候另外写构造，根据需要生成List的对应子类。
		return tList;
	}
}
