package com.whroid.tool.audiorecorder.voice;

import java.io.File;
import java.io.IOException;

import com.inmovation.android.Exception.CommonException;

import android.os.Environment;
import android.text.TextUtils;

public abstract class AbstractRecorder {
	static final String TAG = AbstractRecorder.class.getSimpleName();
	protected static final int STATUS_ING = 0x01;// 正在录音
	protected static final int STATUS_NONE = 0x02;// 正常状态，没有录音
	// 频率

	protected int MAX_VU_SIZE = 10;// 音量最大的等级数
	protected String rootDir = Environment.getExternalStorageDirectory().toString();
	protected String voiceType = ".amr";
	protected String voicePath;// 录制时的路径
	protected long voiceTime = 0;
	protected VoiceTimer voiceTimer;
	protected int currentStatus = STATUS_NONE;

	public AbstractRecorder() {
		initVoice();
	}

	protected void initVoice() {
		voiceTimer = new VoiceTimer();
		voiceTimer.setVoiceRecoder(this);
	}

	protected void setRecorderType(String voiceType) {
		this.voiceType = voiceType;
	}

	public String getVoiceFilePath() {
		return voicePath;
	}

	public void setMaxVoiceSize(int value) {
		this.MAX_VU_SIZE = value;
	}

	public OnVoiceValueListener onVoiceValueListener;

	public void setOnVoiceValueListener(
			OnVoiceValueListener onVoiceValueListener) {
		this.onVoiceValueListener = onVoiceValueListener;
	}

	public void setVoiceValue(int value) {
		if (onVoiceValueListener != null) {
			onVoiceValueListener.onVoiceValue(value);
		}
	}

	public void setVoiceTime(long value) {
		voiceTime = value;
	}

	public long getVoiceTime() {
		return voiceTime;
	}

	/**
	 * 设置语音放置的根文件夹
	 * 
	 * @param dir
	 */
	public void setRootDir(String dir) {
		if (TextUtils.isEmpty(dir)) {
			return;
		}
		File file = new File(dir);
		if (file.exists() && file.isDirectory()) {
			rootDir = dir;
		} else if (!file.exists()) {
			file.mkdir();
			rootDir = dir;
		}
	}

	/**
	 * 开始录音
	 * 
	 * @throws IOException
	 */
	public abstract void start() throws CommonException;

	/**
	 * 停止录音
	 * 
	 * @throws IOException
	 */
	public abstract void stop() throws CommonException;

	/**
	 * 得到原始音量值，需要异步获取
	 * 
	 * @return
	 */
	public abstract int getAmplitude();

	/**
	 * 判断是否在录音中
	 * 
	 * @return
	 */
	public boolean isRecording() {
		if (currentStatus == STATUS_NONE) {
			return false;
		} else {
			return true;
		}
	}

	public interface OnVoiceValueListener {

		public void onVoiceValue(int value);
	}
}