package com.whroid.tool.audiorecorder.voice;

import java.io.File;
import java.io.IOException;

import com.inmovation.android.Exception.CommonException;


import android.media.MediaRecorder;

/**
 * 
 * @author Administrator
 *
 */
public class VoiceAmrRecorder extends AbstractRecorder {
	static final String TAG = VoiceAmrRecorder.class.getSimpleName();
	protected static int SAMPLE_RATE_IN_HZ = 8000;
	MediaRecorder recorder = new MediaRecorder();

	/**
	 * 开始录音
	 * 
	 * @throws IOException
	 */
	public void start() throws CommonException {

		String state = android.os.Environment.getExternalStorageState();
		if (!state.equals(android.os.Environment.MEDIA_MOUNTED)) {
			throw new CommonException("SD Card is not mounted,It is  " + state
					+ ".");
		}
		voicePath = rootDir + "/voice" + System.currentTimeMillis() + voiceType;
		File directory = new File(voicePath).getParentFile();
		if (!directory.exists() && !directory.mkdirs()) {
			throw new CommonException("Path to file could not be created");
		}
		voiceTime = 0l;
		try {
			recorder = new MediaRecorder();
			recorder.setAudioSource(MediaRecorder.AudioSource.MIC);
			recorder.setOutputFormat(MediaRecorder.OutputFormat.RAW_AMR);
			recorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
			recorder.setAudioSamplingRate(SAMPLE_RATE_IN_HZ);
			recorder.setOutputFile(voicePath);
			recorder.prepare();
			recorder.start();

			voiceTimer.start();
			currentStatus = STATUS_ING;
		} catch (Exception e) {
			throw new CommonException("VoiceRecorder start excption", e);
		}
	}

	/**
	 * 停止录音
	 * 
	 * @throws IOException
	 */
	public void stop() throws CommonException {
		try {
			recorder.stop();
			recorder.release();
		} catch (Exception e) {
			throw new CommonException(e);
		} finally {
			recorder = null;
			voiceTimer.stop();
			currentStatus = STATUS_NONE;
		}
	}

	/**
	 * 得到原始音量值，需要异步获取
	 * 
	 * @return
	 */
	public int getAmplitude() {
		if (recorder != null) {
			try {
				return (MAX_VU_SIZE * recorder.getMaxAmplitude() / 32768);// 32768
																			// ==
																			// pow(2,16)
			} catch (Exception e) {
				e.printStackTrace();
				return 0;
			}
		} else
			return 0;
	}
}