package com.whroid.tool.audiorecorder.voice;


import com.inmovation.tools.LogUtil;

import android.os.Handler;

/**
 * 
 * @description remain recording time
 * @project myctu
 * @author wuhongren
 * @create 2013-6-4上午9:55:07
 * 
 */
public class VoiceTimer {

	static final String TAG = "VoiceTimer";
	static long MIN_THREAD_TIME = 100;// 最小线程停顿时间
	static int MAX_RECORD_TIME = 0;// 最大录音时间 0表示没有限制
	static int MIN_RECORD_TIME = 0;// 最小录音时间 0表示没有限制

	static final int RECODE_ING = 0x11;// 正在录音
	static final int RECODE_NONE = 0x12;// 不是录音状态

	static final int MESSAGE_STOP = 0x13;// 停止
	static final int MESSAGE_OVERMAX = 0x14;// 超过最大值
	static final int MESSAGE_VOICEVALUE = 0x15;// 获取声音值

	int recordState = RECODE_NONE;// 默认正常状态
	long recordTime = 0;// 录音时间
	int voiceValue = 0;// 音量大小
	AbstractRecorder mVoiceRecorder;

	Thread recordThread;

	public void start() {
		recordState = RECODE_ING;
		recordThread = new Thread(recordRunable);
		recordThread.start();
	}

	public void stop() {
		recordState = RECODE_NONE;
	}

	public void setVoiceRecoder(AbstractRecorder voiceRecorder) {
		this.mVoiceRecorder = voiceRecorder;
	}

	Handler mHandler = new Handler() {
		public void handleMessage(android.os.Message msg) {

			switch (msg.what) {
			case MESSAGE_STOP:
				if (mVoiceRecorder != null) {
					mVoiceRecorder.setVoiceTime(recordTime);
				}
				LogUtil.d(TAG, "voiceTimer:" + recordTime);
				recordTime = 0;
				break;
			case MESSAGE_OVERMAX:
				stop();
				break;
			case MESSAGE_VOICEVALUE:
				if (mVoiceRecorder != null) {
					mVoiceRecorder.setVoiceValue(voiceValue);
					mVoiceRecorder.setVoiceTime(recordTime);
				}
				break;
			}
		};
	};

	Runnable recordRunable = new Runnable() {

		@Override
		public void run() {
			recordTime = 0l;
			while (recordState == RECODE_ING) {
				if (MAX_RECORD_TIME != 0 && recordTime >= MAX_RECORD_TIME) {
					mHandler.sendEmptyMessage(MESSAGE_OVERMAX);
				} else {
					try {
						Thread.sleep(MIN_THREAD_TIME);
						recordTime += MIN_THREAD_TIME;
						if (recordState == RECODE_ING && mVoiceRecorder != null) {
							if (mVoiceRecorder.isRecording()) {
								try {
									voiceValue = mVoiceRecorder.getAmplitude();
									mHandler.sendEmptyMessage(MESSAGE_VOICEVALUE);
								} catch (Exception e) {
									e.printStackTrace();
									break;
								}
							}
						}
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
			mHandler.sendEmptyMessage(MESSAGE_STOP);
		}

	};
}
