﻿var urlList = [
    "http://www.zkcserv.com/download.html",
    "http://www.zkcserv.com/download.html"
];
var gwUrl = "http://www.zkcserv.com/";

function IsURL(domain) {
    var name = /[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\.?/;
    if (!(name.test(domain))) {
        return false;
    } else {
        return true;
    }
}

function getDay(num, str, date) {
    var today = date ? new Date(date) : new Date();
    var nowTime = today.getTime();
    var ms = 24 * 3600 * 1000 * num;
    today.setTime(parseInt(nowTime + ms));
    var oYear = today.getFullYear();
    var oMoth = (today.getMonth() + 1).toString();
    if (oMoth.length <= 1) oMoth = '0' + oMoth;
    var oDay = today.getDate().toString();
    if (oDay.length <= 1) oDay = '0' + oDay;
    return oYear + str + oMoth + str + oDay;
}

function seekData(aBgnDate, aEndDate, isHalf) {
    var r = ((new Date(aBgnDate) - new Date(aEndDate) + 86400000) / 86400000).toFixed(1);
    if (isHalf) {
        var nList = r.toString().split('.');
        if (nList.length == 2) {
            if (nList[1] > 5) {
                r = parseFloat(parseInt(nList[0]) + 1 + '.0')
            } else if (nList[1] < 5 && nList[1] > 0) {
                r = parseFloat(parseInt(nList[0]) + '.5')
            }
        }
    }
    return r
}
angular.module('citymobi.controllers', [])

    .controller('deptComponentCtrl', function ($scope, $rootScope, $ionicHistory, $compile, $stateParams, $timeout, $location, $ionicPlatform, $deptComponentSer, $ionicScrollDelegate) {
        $scope.isShow = false;
        $scope.iIndex = null;

        $scope.search_control = {
            search_val: ''
        };

        var routerPageConfig = {
            'default': 'deptComponentCtrlDefault',
            'message': 'deptComponentCtrlMessage',
            'at': 'deptComponentCtrlAt',
            'sign': 'deptComponentCtrlSign',
            'person': 'deptComponentCtrlPerson'
        }


        $scope.historyBar = $deptComponentSer.getHistoryBar();
        $scope.opt = $deptComponentSer.getOpt();


        $scope.ii = new Date().getTime();

        $scope.opt.isAllSelect = true;


        $scope.iconX_nav = null;

        $scope.iconX_nav_style = {
            width: "1000px",
            height: "50px"
        }

        $scope.resizeIonContent = function () {
            if ($scope.iconX_nav) {
                $scope.iconX_nav.resize();
            } else {
                for (var i in $ionicScrollDelegate._instances) {
                    if ($ionicScrollDelegate._instances[i].$$delegateHandle == "x_nav") {
                        $scope.iconX_nav = $ionicScrollDelegate._instances[i];
                    }
                }

                if ($scope.iconX_nav) {

                    $scope.iconX_nav.resize();
                }
            }
        };


        $scope.$on("$ionicView.afterEnter", function (event, data) {

            $scope.activeObj = $deptComponentSer.getActiveNumber();
            $rootScope.showLoading();

            //控制navbar
            $timeout(function () {
                $("[nav-bar='active'] .title.title-center.header-item").css({
                    left: '35px',
                    right: '35px'
                })
            }, 50);

            var mtWdith = 0;

            var addNum = 30;

            $timeout(function () {
                var el_List = $('ion-content[i="' + $scope.ii + '"] .mobile_tree_title_x div');
                el_List.each(function (i, e) {
                    mtWdith += $(e).width();
                })
                $('ion-content[i="' + $scope.ii + '"] .mobile_tree_title_x').css({
                    width: mtWdith + addNum,
                    height: 50
                });

                // $$delegateHandle
                $scope.resizeIonContent();

                if ((mtWdith + addNum) > $(document.body).width()) {
                    var l = (mtWdith + addNum) - $(document.body).width();
                    $ionicScrollDelegate.$getByHandle('x_nav').scrollTo(l, 0, true);
                }
            }, 0);



            if (!$scope.opt.isLoadDataSucceed) {
                //是否已经把数据完全加载回来：未加载

                var promise = $deptComponentSer.postData();

                promise.then(function (greeting) {
                    $scope.isShow = true;
                    //获取数据
                    $scope.iIndex = $stateParams.pid;
                    $scope.sd = $deptComponentSer.getData();



                    $timeout(function () {
                        $rootScope.hideLoading();
                        $ionicScrollDelegate.resize();

                        $scope.opt.isLoadDataSucceed = true;
                    }, 800);
                }, function (reason) {
                    $rootScope.hideLoading();
                });
            } else {
                //已加载


                $timeout(function () {
                    $scope.isShow = true;
                    $scope.iIndex = $stateParams.pid;
                    $scope.sd = $deptComponentSer.getData();

                    $timeout(function () {
                        $rootScope.hideLoading();
                        $ionicScrollDelegate.resize();
                    }, 800);

                }, 700);


            }
        });

        $scope.allSelect = function () {

            if ($scope.search_control.search_val && $scope.search_control.search_val.length) {

                if ($scope.opt.isAllSelect) {
                    $scope.opt.isAllSelect = !$scope.opt.isAllSelect;
                    var i_arr = [];
                    for (var i = 0, len = $scope.sd[$scope.iIndex].length; i < len; i++) {
                        if ($scope.sd[$scope.iIndex][i].name.indexOf($scope.search_control.search_val) >= 0) {
                            i_arr[i_arr.length] = $scope.sd[$scope.iIndex][i];
                        }
                    }

                    for (var i = 0, len = i_arr.length; i < len; i++) {
                        if (!i_arr[i].checked) {
                            i_arr[i].checked = true;
                            $deptComponentSer.updateActive(i_arr[i].id, true, i_arr[i]);
                        }

                        if ($scope.opt.isInherit && i_arr[i].children && i_arr[i].children.length) {
                            $scope.selectRecursion(i_arr[i].children)
                        }
                    }

                    // //全选过滤
                    // if($scope.opt.isInherit){
                    //     $scope.selectRecursion(i_arr);
                    // }
                } else {
                    $scope.opt.isAllSelect = !$scope.opt.isAllSelect;
                    var i_arr = [];
                    for (var i = 0, len = $scope.sd[$scope.iIndex].length; i < len; i++) {
                        if ($scope.sd[$scope.iIndex][i].name.indexOf($scope.search_control.search_val) >= 0) {
                            i_arr[i_arr.length] = $scope.sd[$scope.iIndex][i];
                        }
                    }

                    for (var i = 0, len = i_arr.length; i < len; i++) {
                        if (i_arr[i].checked) {
                            i_arr[i].checked = false;
                            $deptComponentSer.updateActive(i_arr[i].id, false, i_arr[i]);
                        }

                        if ($scope.opt.isInherit && i_arr[i].children && i_arr[i].children.length) {
                            $scope.cancelRecursion(i_arr[i].children)
                        }
                    }
                }


            } else {

                if ($scope.opt.isAllSelect) {
                    $scope.opt.isAllSelect = !$scope.opt.isAllSelect;
                    for (var i = 0, len = $scope.sd[$scope.iIndex].length; i < len; i++) {
                        if (!$scope.sd[$scope.iIndex][i].checked) {
                            $scope.sd[$scope.iIndex][i].checked = true;
                            $deptComponentSer.updateActive($scope.sd[$scope.iIndex][i].id, true, $scope.sd[$scope.iIndex][i]);
                        }

                        if ($scope.opt.isInherit && $scope.sd[$scope.iIndex][i].children && $scope.sd[$scope.iIndex][i].children.length) {

                            $scope.selectRecursion($scope.sd[$scope.iIndex][i].children);
                        }
                    }
                } else {
                    $scope.opt.isAllSelect = !$scope.opt.isAllSelect;
                    for (var i = 0, len = $scope.sd[$scope.iIndex].length; i < len; i++) {
                        if ($scope.sd[$scope.iIndex][i].checked) {
                            $scope.sd[$scope.iIndex][i].checked = false;
                            $deptComponentSer.updateActive($scope.sd[$scope.iIndex][i].id, false, $scope.sd[$scope.iIndex][i]);
                        }

                        if ($scope.opt.isInherit && $scope.sd[$scope.iIndex][i].children && $scope.sd[$scope.iIndex][i].children.length) {

                            $scope.cancelRecursion($scope.sd[$scope.iIndex][i].children);
                        }
                    }

                }

            }
        };

        $scope.selectRecursion = function (d) {
            for (var i = 0, len = d.length; i < len; i++) {
                if (!d[i].checked) {
                    d[i].checked = true;
                    $deptComponentSer.updateActive(d[i].id, true, d[i]);
                }
                if (d[i].children && d[i].children.length) {
                    $scope.selectRecursion(d[i].children)
                }
            }
        }

        $scope.cancelRecursion = function (d) {
            for (var i = 0, len = d.length; i < len; i++) {
                if (d[i].checked) {
                    d[i].checked = false;
                    $deptComponentSer.updateActive(d[i].id, false, d[i]);
                }
                if (d[i].children && d[i].children.length) {
                    $scope.cancelRecursion(d[i].children)
                }
            }
        }

        $scope.back = function () {

            if ($scope.historyBar.length == 1) {
                //如果在rootView 即需要清楚数据
                $deptComponentSer.clearActivePersonnel();
            }

            $deptComponentSer.popBar();
            $ionicHistory.goBack();
        };

        $scope.goBack = function (i) {

            if (($scope.historyBar.length - 1) == i) {
                console.log('当前位置');
                return;
            }


            $timeout(function () {
                var stepNum = $scope.historyBar.length - 1 - i;
                $deptComponentSer.goBackBar(i + 1);
                var backStepNum = 0 - stepNum;
                $ionicHistory.goBack(backStepNum);
            }, 0)

        };

        $scope.sure = function () {

            //回调返回数据
            $deptComponentSer.callback();

            //是否保存常用联系人
            if ($scope.opt.isShowContact && $scope.opt.isNeedSaveContact) {

            } else {
                // console.log('不保存常用联系人');
            }

            //返回到入口,清除数据
            $deptComponentSer.goBackBar(0);
            $ionicHistory.goBack(-$scope.historyBar.length);

        };

        $ionicPlatform.onHardwareBackButton($scope.back);


        $scope.$on("$ionicView.beforeLeave", function (event, data) {

            $ionicPlatform.offHardwareBackButton($scope.back);

        });


        $scope.selectOption = function (item) {

            if ($scope.opt.isSingleSelect) {
                //单选
                if (item.checked) {
                    $deptComponentSer.callback(item);
                    $deptComponentSer.goBackBar(0);
                    $ionicHistory.goBack(-$scope.historyBar.length);
                }


            } else {
                //多选

                var id = item.id,
                    state = item.checked;

                $deptComponentSer.updateActive(id, state, item);

                if (item.children && item.children.length && $scope.opt.isInherit) {
                    if (item.checked) {
                        $scope.selectRecursion(item.children);
                    } else {
                        $scope.cancelRecursion(item.children);
                    }
                }
            }

        };

        $scope.isTriggerJump = false;



        $scope.openSubClass = function (item, i) {

            if (item.children && item.children.length) {

                if (!$scope.isTriggerJump) {
                    $scope.isTriggerJump = true;

                    var num = parseInt($stateParams.pid) + 1;
                    //    /emplComponentCtrl/1
                    // $deptComponentSer.pushBar(name, id);
                    $scope.sd[num] = $scope.sd[$stateParams.pid][item.iIndex].children;
                    $deptComponentSer.pushBar(item.name, item.id);
                    $timeout(function () {
                        $location.path('home_page/' + routerPageConfig[$scope.opt.routerName] + '/' + num);
                    }, 150);
                    $timeout(function () {
                        $scope.isTriggerJump = false;
                    }, 350);
                }


            } else {
                if ($scope.opt.isSingleSelect) {
                    //单选
                    item.checked = !item.checked;

                    if (item.checked) {
                        $deptComponentSer.callback(item);
                        $deptComponentSer.goBackBar(0);
                        $ionicHistory.goBack(-$scope.historyBar.length);
                    }


                } else {
                    //多选
                    item.checked = !item.checked;

                    var id = item.id,
                        state = item.checked;

                    $deptComponentSer.updateActive(id, state, item);

                    if (item.children && item.children.length && $scope.opt.isInherit) {
                        if (item.checked) {
                            $scope.selectRecursion(item.children);
                        } else {
                            $scope.cancelRecursion(item.children);
                        }
                    }

                    // $timeout(function(){
                    //   console.log($deptComponentSer.getOData());


                    // },3000);
                }
            }

        };

        if ($('body').hasClass('searchInputState')) {
            $('body').removeClass('searchInputState');
        }

        $scope.toggleSearch = function () {
            $scope.searchState = !$scope.searchState;
            if ($scope.searchState) {
                $('body').addClass('searchInputState');

            } else {
                $('body').removeClass('searchInputState');
            }
        }

        if ($stateParams.isSearch == 'true') {
            if ($('body').hasClass('hideSearchBtn')) {
                $('body').removeClass('hideSearchBtn');
            }
            $scope.searchState = false;
        } else {

            if (!$('body').hasClass('hideSearchBtn')) {
                $('body').addClass('hideSearchBtn');
            }
        }
    })
    .controller('emplComponentCtrl', function ($scope, $rootScope, $ionicHistory, $compile, $stateParams, $timeout, $location, $ionicPlatform, $emplComponentService, $ionicScrollDelegate, $emplSearchComponent, $setstatusBar) {
        $scope.isShow = false;
        $scope.icon_src = local_resource + 'img/emp_section_icon.png';
        $scope.search_control = {
            search_val: ''
        };
        // console.log($stateParams); 获取pid

        var routerPageConfig = {
            'default': 'emplComponentCtrlDefault',
            'message': 'emplComponentCtrlMessage',
            'at': 'emplComponentCtrlAt',
            'sign': 'emplComponentCtrlSign',
            'person': 'emplComponentCtrlPerson'
        }

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            var opt = {"colorStr" : "#53afff"};
            	StatusBar.setStatusBarColor(opt);

        });


        $scope.opt = $emplComponentService.getOpt();
        $scope.historyBar = $emplComponentService.getHistoryBar();

        $scope.ii = new Date().getTime();

        // $scope.renderFinish = function(){

        // };

        $scope.$on("$ionicView.afterEnter", function (event, data) {

            $scope.activeObj = $emplComponentService.getActiveNumber();
            $rootScope.showLoading();

            //控制navbar
            $timeout(function () {
                $("[nav-bar='active'] .title.title-center.header-item").css({
                    left: '35px',
                    right: '35px'
                })
            }, 50);
            // console.log($('ion-content[i="'+$scope.ii+'"] .mobile_tree_title_x div'));

            var mtWdith = 0;
            var el_List = $('ion-content[i="' + $scope.ii + '"] .mobile_tree_title_x div');
            var el_width_arr = [];
            // el_List.each(function(i,e){
            //   el_width_arr.push($(e).width());
            // })

            // el_List = el_List.slice(el_List.length-$scope.historyBar.length,el_List.length);
            // el_width_arr = el_width_arr.slice(el_List.length-$scope.historyBar.length,el_List.length);

            // el_List.each(function(i,e){
            //   // alert($(e).width());
            //   mtWdith+=$(e).width();
            // });

            $timeout(function () {
                el_List.each(function (i, e) {
                    mtWdith += $(e).width();
                });
                $('ion-content[i="' + $scope.ii + '"] .mobile_tree_title_x').width(mtWdith + 12 + 'px');

                if ((mtWdith + 12) > $(document.body).width()) {
                    var l = (mtWdith + 12) - $(document.body).width();
                    $ionicScrollDelegate.$getByHandle('x_nav').scrollTo(l, 0, true);
                }

            }, 0);
            // $(el_width_arr).each(function(i, e) {
            //        mtWdith+=e;
            //   });



            //加载数据
            var promise = $emplComponentService.postData();

            promise.then(function (greeting) {
                $scope.isShow = true;
                //获取数据
                $scope.sd = $emplComponentService.getData();


                var outTime = 0;

                if ($scope.historyBar.length == 1) {
                    outTime = 1200;
                } else {
                    outTime = 700;
                }

                $timeout(function () {
                    $rootScope.hideLoading();
                    $ionicScrollDelegate.resize();

                }, outTime);
            }, function (reason) {
                $rootScope.hideLoading();
            });
        });

        $scope.del_contact = function (i, empl_no) {
            $scope.sd.contact_list.splice(i, 1);
            $.ajax({
                type: "GET",
                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.deleteEmplCompContact&_dc=' + new Date().getTime(),
                timeout: _var_timeout,
                data: {
                    delete_employee_no: empl_no
                },
                success: function (_data) {},
                error: function (data) {}
            });
            $ionicScrollDelegate.resize();
        }

        $scope.back = function () {

            if ($scope.historyBar.length == 1) {
                //如果在rootView 即需要清楚数据
                $emplComponentService.clearActivePersonnel();
            }

            $emplComponentService.popBar();
            $ionicHistory.goBack();
        };

        $scope.goBack = function (i) {

            if (($scope.historyBar.length - 1) == i) {
                console.log('当前位置');
                return;
            }


            $timeout(function () {
                var stepNum = $scope.historyBar.length - 1 - i;
                $emplComponentService.goBackBar(i + 1);
                var backStepNum = 0 - stepNum;
                $ionicHistory.goBack(backStepNum);
            }, 0)

        };

        $scope.sure = function () {

            //回调返回数据
            $emplComponentService.callback();

            //是否保存常用联系人
            if ($scope.opt.isShowContact && $scope.opt.isNeedSaveContact) {

            } else {
                // console.log('不保存常用联系人');
            }

            //返回到入口,清除数据
            $emplComponentService.goBackBar(0);
            $ionicHistory.goBack(-$scope.historyBar.length);

        };



        $ionicPlatform.onHardwareBackButton($scope.back);


        $scope.$on("$ionicView.beforeLeave", function (event, data) {

            $ionicPlatform.offHardwareBackButton($scope.back);

        });


        $scope.selectOption = function (item, isContact, isA) {
            if (isA) {
                item.checked = !item.checked;
            }

            if ($scope.opt.isSingleSelect) {
                //单选

                if (item.checked) {
                    $emplComponentService.callback(item);
                    $emplComponentService.goBackBar(0);
                    $ionicHistory.goBack(-$scope.historyBar.length);
                }

            } else {
                //多选

                var id = item.empl_no,
                    state = item.checked;

                if (isContact) {
                    if ($scope.sd.empl_list && $scope.sd.empl_list.length) {
                        for (var i = 0, len = $scope.sd.empl_list.length; i < len; i++) {
                            if ($scope.sd.empl_list[i].empl_no == id && $scope.sd.empl_list[i].checked != state) {
                                $scope.sd.empl_list[i].checked = state;
                                break;
                            }
                        }
                    }
                } else {
                    if ($scope.sd.contact_list && $scope.sd.contact_list.length) {
                        for (var i = 0, len = $scope.sd.contact_list.length; i < len; i++) {
                            if ($scope.sd.contact_list[i].empl_no == id && $scope.sd.contact_list[i].checked != state) {
                                $scope.sd.contact_list[i].checked = state;
                                break;
                            }
                        }
                    }
                }

                $emplComponentService.updateActive(id, state, item);
            }

        };

        $scope.stopPropagation = function (ev) {
            ev.stopPropagation();
        }

        $scope.isTriggerJump = false;

        $scope.openSubClass = function (id, name) {

            // $ionicHistory.clearCache().then(function(){
            //     $emplComponentService.pushBar(name, id);
            //     $location.path('home_page/'+ routerPageConfig[$scope.opt.routerName] +'/'+id);
            // });

            if (!$scope.isTriggerJump) {
                $scope.isTriggerJump = true;
                //    /emplComponentCtrl/1
                $emplComponentService.pushBar(name, id);
                // $emplComponentService.addBar(name, id);
                $location.path('home_page/' + routerPageConfig[$scope.opt.routerName] + '/' + id);
                $timeout(function () {
                    $scope.isTriggerJump = false;
                }, 200);
            }
        };

        if ($('body').hasClass('searchInputState')) {
            $('body').removeClass('searchInputState');
        }

        $scope.openSearch = function () {
            if ($scope.opt.isSearch) {

                emplSearchModal = $emplSearchComponent.init({
                    isSingleSelect: $scope.opt.isSingleSelect, //单选模式
                    extName: $scope.opt.extName, //选中tips
                    selectEmplList: $scope.opt.selectEmplList,
                    params: $scope.opt.params ? $scope.opt.params : null,
                    hideCallback: function () {

                        $ionicPlatform.onHardwareBackButton($scope.back);
                    },
                    sure: function (selectData) {


                        $timeout(function () {



                            if ($scope.sd.empl_list && $scope.sd.empl_list.length) {
                                angular.forEach($scope.sd.empl_list, function (data, index, array) {
                                    if ($scope.activeObj[data.empl_no]) {

                                        data.checked = true;
                                    } else {
                                        data.checked = false;
                                    }

                                });
                            }

                            if ($scope.sd.empl_list && $scope.sd.contact_list.length) {
                                angular.forEach($scope.sd.contact_list, function (data, index, array) {
                                    if ($scope.activeObj[data.empl_no]) {

                                        data.checked = true;
                                    } else {
                                        data.checked = false;
                                    }
                                });
                            }
                        }, 0);
                    }
                });

                $ionicPlatform.offHardwareBackButton($scope.back);
                emplSearchModal.show();
            }
        }

        $scope.toggleSearch = function () {
            // $scope.searchState = !$scope.searchState;
            // if($scope.searchState){
            //   $('body').addClass('searchInputState');
            //
            // }else{
            //   $('body').removeClass('searchInputState');
            // }
        }

        // if($stateParams.isSearch == 'true'){
        //   if($('body').hasClass('hideSearchBtn')){
        //     $('body').removeClass('hideSearchBtn');
        //   }
        //   $scope.searchState = false;
        // }else{
        //
        //   if(!$('body').hasClass('hideSearchBtn')){
        //     $('body').addClass('hideSearchBtn');
        //   }
        // }


    })

    .controller('homePageCtrl', function ($scope, homemessageSev, regIdxService, $ionicHistory, $location) {
                $('#fufu_spinner_container').css("display","none");
        $scope.img_home = local_resource + 'img/menus/home.png';
        $scope.img_home_active = local_resource + 'img/menus/home-active.png';
        $scope.img_at = local_resource + 'img/menus/at.png';
        $scope.img_at_active = local_resource + 'img/menus/at-active.png';
        $scope.img_salary = local_resource + 'img/menus/salary.png';
        $scope.img_salary_active = local_resource + 'img/menus/salary-active.png';
        $scope.img_personal = local_resource + 'img/menus/personal.png';
        $scope.img_personal_active = local_resource + 'img/menus/personal-active.png';
        $scope.img_at_sign_in_active = local_resource + 'img/menus/at_sign_in_active.png';
        $scope.img_at_sign_in_normal = local_resource + 'img/menus/at_sign_in_normal.png';
        $scope.img_message_on = local_resource + 'img/menus/message_on.png';
        $scope.img_message_off = local_resource + 'img/menus/message_off.png';
        //homemessageSev.loadMessageCount();
        $scope.home_message_count = homemessageSev.getMessageCount();

        $scope.redirect_tab = function (tab) {

            /*
            $location.path(tab);
            */

            $ionicHistory.clearCache().then(function () {
                $location.path(tab);
            });


        }
    })

    .controller('registerIndex', function ($scope, regIdxService) {
        regIdxService.loadData();
        $scope.reg_index_ck = regIdxService.regIndexAll();
        $scope.saveIndex = function () {
            regIdxService.saveIndex();
        }
    })
    .controller('registerAl', function ($scope, regAlService) {
        regAlService.loadData();
        $scope.al_setting_data = regAlService.getAlSettingData();
        $scope.saveRegAl = function () {
            regAlService.saveRegAl();
        }
        $scope.addAlRuleItem = function () {
            var al_rule_setting = $scope.al_setting_data['al_rule_setting'];
            var length = al_rule_setting.length;
            var _val;
            if (length == 0) {
                _val = 1
            } else {
                _val = al_rule_setting[length - 1].to
            };
            $scope.al_setting_data['al_rule_setting'].push({
                'from': _val,
                'to': '',
                'days': ''
            })
        }
        $scope.deleteAlRuleItem = function (item) {
            var idx = $scope.al_setting_data['al_rule_setting'].indexOf(item);
            $scope.al_setting_data['al_rule_setting'].splice(idx, 1);
        }
    })
    .controller('registerAt1', function ($scope, regAt1Service) {
        regAt1Service.loadData();
        $scope.reg_at1_data = regAt1Service.getAt1SettingData();
        $scope.saveRegAt1 = function () {
            regAt1Service.saveRegAt1();
        }
    })
    .controller('registerAt2', function ($scope, regAt2Service) {
        regAt2Service.loadData();
        $scope.reg_at2_data = regAt2Service.getAt2SettingData();
        $scope.saveRegAt2 = function () {
            regAt2Service.saveRegAt2();
        }
    })
    .controller('loginHomeNavigationCtrl', function ($scope, $ionicHistory, $ionicViewSwitcher, $location, $ionicModal, userLoginService) {
        //alert(document.getElementById("login_home_navigation_bot_div"))

        // $scope.css_vertical=(document.body.scrollHeight -100-350)/2+"px";
        $scope.css_vertical = (window.screen.height - 100 - 350) / 2 + "px";


        //$scope.$on("$ionicView.enter", function () {
        //
        //  //alert(document.body.scrollHeight   );
        //  //alert(document.getElementById("login_home_navigation_bot_div").offsetHeight);
        //  document.getElementById("login_home_navigation_mar_top").style.height=(document.body.scrollHeight -document.getElementById("login_home_navigation_bot_div").offsetHeight-350)/2+"px";
        //  document.getElementById("login_home_navigation_bot_div").style.marginTop=(document.body.scrollHeight -document.getElementById("login_home_navigation_bot_div").offsetHeight-350)/2+"px";
        //})

$scope.$on("$ionicView.afterEnter", function (event, data) {
           	var opt = {"colorStr" : "#f8f8f8"};
	StatusBar.setStatusBarColor(opt);
});

$scope.$on("$ionicView.beforeLeave", function (event, data) {
	var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);
});





        $scope.icon_forward = local_resource + 'img/icon/icon_forward.png';
        $scope.icon_company_name = local_resource + 'img/icon/icon_company_name.png';
        $scope.icon_user = local_resource + 'img/icon/icon_user.png';
        $scope.freeExpr = userLoginService.getFreeData();
        clearInterval(fufu_register_timeout);
        $scope.freeExpr.cmp_name = window.localStorage['free_trial_cmp_name'];
        $scope.freeExpr.cmp_contact = window.localStorage['free_trial_cmp_contact'];
        $scope.freeExpr.tel_no = window.localStorage['free_trial_tel_no'];
        $scope.freeExpr.valid_code = window.localStorage['free_trial_valid_code'];
        $ionicViewSwitcher.nextDirection('back');
        $scope.navigate_login = function () {
            $ionicViewSwitcher.nextDirection('forward');
            $location.path("/")
        }
        $ionicModal.fromTemplateUrl('free_experience_account.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.free_modal = modal;

        });
        $scope.closeFreeModal = function () {
            $scope.free_modal.hide();
        };
        $scope.sendPwdVCode = function () {
            userLoginService.sendPwdVCode();
        }
        $scope.free_experience_account = function () {
            $scope.free_modal.show()
        }
        $scope.demoLogin = function () {
            userLoginService.demoLogin($scope.free_modal);
        }
        $scope.comp_reg = function () {
            $location.path('comp_reg')
        }
        $scope.swiperData = [{
                imgUrl: local_resource + 'img/register/navigation_banner_new_1.png',
                locationUrl: '',
                title: '互联网打卡',
                text: '无论身处何地，打卡随心所欲'
            },
            {
                imgUrl: local_resource + 'img/register/navigation_banner_new_2.png',
                locationUrl: '',
                title: '薪资管理',
                text: '薪酬计算、工资单发放，既便捷又安全'
            },
            {
                imgUrl: local_resource + 'img/register/navigation_banner_new_3.png',
                locationUrl: '',
                title: '补签卡',
                text: '解决手脱皮、卡钟坏、忘打卡等各种状况'
            },
            {
                imgUrl: local_resource + 'img/register/navigation_banner_new_4.png',
                locationUrl: '',
                title: '查看状态',
                text: '叮咚，您收到一条待办消息哟～'
            },
            {
                imgUrl: local_resource + 'img/register/navigation_banner_new_5.png',
                locationUrl: '',
                title: '小秘书',
                text: '点我你就都懂了'
            }
        ];



    })

    .controller('compRegCtrl', function ($scope, $ionicHistory, $ionicViewSwitcher, $location, $ionicModal, userLoginService, $ionicPopup, compRegSev) {
        var ionNavBarHeight = (ionic.Platform.platform() == 'ios') ? '64' : '44';

        $scope.$on('$ionicView.beforeEnter', function () {
            //进入之前
            $('ion-view[nav-view="active"] ion-content').css('top', '0');
            $('ion-nav-bar').css('display', 'none');


            var imitateBarStr = (ionic.Platform.platform() == 'ios') ?
                '<div class="imitateBar" style="position: absolute;top: 0;left: 0; right: 0; height: ' + ionNavBarHeight + 'px; background: #53afff; background-image: linear-gradient(0deg,#ddd,#ddd 50%,transparent 50%); background-position: bottom; background-size: 100% 1px; background-repeat: no-repeat;"><div style="width: auto; height: 44px; margin-left:10px; margin-right: 10px; margin-top: 20px; line-height: 44px; position: relative; text-align: center;text-overflow: ellipsis;white-space: nowrap;font-size: 17px;font-weight: 500; color: white"><button class="button back-button buttons button-clear button-light button-icon ion-ios-arrow-left header-item" style="position: absolute;top: 1px; left: -4px;font-size: 24px"><span class="back-text" style="transform: translate3d(0px, 0px, 0px);font-size: 24px"></span></button>注册新企业</div></div>' :
                '<div class="imitateBar" style="position: absolute;top: 0;left: 0; right: 0; height: ' + ionNavBarHeight + 'px; background: #53afff; background-image: linear-gradient(0deg,#ddd,#ddd 50%,transparent 50%); background-position: bottom; background-size: 100% 1px; background-repeat: no-repeat;"><div style="width: auto; height: 44px;  margin-left:10px; margin-right: 10px; line-height: 44px; position: relative; text-align: center;text-overflow: ellipsis;white-space: nowrap;font-size: 19px;font-weight: 500; color: white"><button class="button back-button buttons button-clear button-light button-icon ion-ios-arrow-left header-item" style="position: absolute;top: 1px; left: -4px;font-size: 24px"><span class="back-text" style="transform: translate3d(0px, 0px, 0px);font-size: 24px"></span></button>注册新企业</div></div>';

            $('ion-view[nav-view!="active"]').append(imitateBarStr);
            $('ion-view[nav-view!="active"] ion-content').css('top', ionNavBarHeight + 'px');

        });
        $scope.$on('$ionicView.afterEnter', function () {
            //进入之后
            $('ion-nav-bar').css('display', '');
            $('.imitateBar').remove();
            $('ion-view[title="注册新企业"] ion-content').css('top', '');

        });
        $scope.$on('$ionicView.beforeLeave', function () {
            //离开之前
            $('ion-view[title="注册新企业"] ion-content').css('top', ionNavBarHeight + 'px');
            var imitateBarStr = (ionic.Platform.platform() == 'ios') ?
                '<div class="imitateBar" style="position: absolute;top: 0;left: 0; right: 0; height: ' + ionNavBarHeight + 'px; background: #53afff; background-image: linear-gradient(0deg,#ddd,#ddd 50%,transparent 50%); background-position: bottom; background-size: 100% 1px; background-repeat: no-repeat;"><div style="width: auto; height: 44px; margin-left:10px; margin-right: 10px; margin-top: 20px; line-height: 44px; position: relative; text-align: center;text-overflow: ellipsis;white-space: nowrap;font-size: 17px;font-weight: 500; color: white"><button class="button back-button buttons button-clear button-light button-icon ion-ios-arrow-left header-item" style="position: absolute;top: 1px; left: -4px;font-size: 24px"><span class="back-text" style="transform: translate3d(0px, 0px, 0px);font-size: 24px"></span></button>注册新企业</div></div>' :
                '<div class="imitateBar" style="position: absolute;top: 0;left: 0; right: 0; height: ' + ionNavBarHeight + 'px; background: #53afff; background-image: linear-gradient(0deg,#ddd,#ddd 50%,transparent 50%); background-position: bottom; background-size: 100% 1px; background-repeat: no-repeat;"><div style="width: auto; height: 44px;  margin-left:10px; margin-right: 10px; line-height: 44px; position: relative; text-align: center;text-overflow: ellipsis;white-space: nowrap;font-size: 19px;font-weight: 500; color: white"><button class="button back-button buttons button-clear button-light button-icon ion-ios-arrow-left header-item" style="position: absolute;top: 1px; left: -4px;font-size: 24px"><span class="back-text" style="transform: translate3d(0px, 0px, 0px);font-size: 24px"></span></button>注册新企业</div></div>';

            $('ion-view[nav-view="active"]').append(imitateBarStr);


        });
        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后

            $('.imitateBar').remove();
        });

        $scope.valid_img_src = _redis_url + "/UserServer/captcha";
        $scope.changeCaptchaCode = function (event) {
            $(".imgauthcode").attr("src", _redis_url + "/UserServer/captcha?" + new Date().getTime())
        }

        $scope.icon_forward = local_resource + 'img/icon/icon_forward.png';
        $scope.icon_company_name = local_resource + 'img/icon/icon_company_name.png';
        $scope.icon_user = local_resource + 'img/icon/icon_user.png';
        $scope.regModel = compRegSev.getRegModel();
        $scope.freeExpr = compRegSev.getFreeData();
        clearInterval(fufu_register_timeout);
        $scope.getValidCode = function () {
            compRegSev.getValidCode();
        }
        $scope.path_log = function () {
            $location.path("/")
        }

        var reg = /^1[3|4|5|7|8]\d{9}$/;
        //alert(document.getElementById("forget_tel_no").value)


        $scope.$on("$ionicView.enter", function () {
            if (!reg.test(document.getElementById("forget_tel_no").value)) {
                document.getElementById("reg_valid_vcode").style.opacity = '0.5';
            } else {
                document.getElementById("reg_valid_vcode").style.opacity = '1';
            }
            if (document.getElementById("forget_valid_code").value != '' && document.getElementById("forget_tel_no").value != '') {
                document.getElementById("_find_pwd_action").style.opacity = '1';
            } else {
                document.getElementById("_find_pwd_action").style.opacity = '0.5';
            }
        });

        document.getElementById("forget_tel_no").oninput = function () {
            if (!reg.test(document.getElementById("forget_tel_no").value)) {
                document.getElementById("reg_valid_vcode").style.opacity = '0.5';
            } else {
                document.getElementById("reg_valid_vcode").style.opacity = '1';
            }

            if (document.getElementById("forget_valid_code").value != '' && document.getElementById("forget_tel_no").value != '') {
                document.getElementById("_find_pwd_action").style.opacity = '1';
            } else {
                document.getElementById("_find_pwd_action").style.opacity = '0.5';
            }

        }
        document.getElementById("forget_valid_code").oninput = function () {
            if (document.getElementById("forget_valid_code").value != '' && document.getElementById("forget_tel_no").value != '') {
                document.getElementById("_find_pwd_action").style.opacity = '1';
            } else {
                document.getElementById("_find_pwd_action").style.opacity = '0.5';
            }


        }


        $scope.regCompAcct = function () {
            if ($scope.regModel._phone_num == '' || $scope.regModel.valid_code == '') {
                $ionicPopup.alert({
                    title: '提示',
                    template: '<div style="text-align: center;">手机号或者验证码为空</div>',
                    okText: '确定'
                })
            } else {
                if (!reg.test($scope.regModel._phone_num)) {
                    $ionicPopup.alert({
                        title: '提示',
                        template: '<div style="text-align: center;">手机号格式不正确</div>',
                        okText: '确定'
                    })
                } else {
                    $location.path("comp_reg_content/" + $scope.regModel._phone_num + "/" + $scope.regModel.valid_code);
                }

            }

        }


    })

    .controller('compRegContentCtrl', function ($scope, $ionicHistory, $ionicViewSwitcher, $location, $ionicModal, userLoginService, sideSelect, $timeout, $stateParams, $rootScope, $ionicPopup, compRegSev) {
        $scope.show_pwd = local_resource + 'img/icon/show_pwd_icon.png';
        $scope.hide_pwd = local_resource + 'img/icon/hide_pwd_icon.png';
        $scope.old_psw_flag = true;
        $scope.regModel = compRegSev.getRegModel();
        $scope.freeExpr = compRegSev.getFreeData();
        $scope.regModel._phone_num = $stateParams.tel_no;
        $scope.regModel.valid_code = $stateParams.valid_code;
		$scope.regModel.is_agree=false;
        $scope.path_log = function () {
            $location.path("/")
        }
        $scope.old_pwd_click = function (flag) {
            $scope.old_psw_flag = !flag;
            if (flag) {
                $("#modifyPwdold").attr('type', 'text')
            } else {
                $("#modifyPwdold").attr('type', 'password')
            }
        }

        $scope.side_category_data = [{
                "key": "1",
                "value": "IT|通信|电子|互联网"
            }, {
                "key": "2",
                "value": "金融业"
            }, {
                "key": "3",
                "value": "房地产|建筑业"
            },
            {
                "key": "4",
                "value": "商业服务"
            }, {
                "key": "5",
                "value": "生产|加工|制造"
            },
            {
                "key": "6",
                "value": "服务业"
            }, {
                "key": "7",
                "value": "能源|矿产|环保"
            },
            {
                "key": "8",
                "value": "贸易|批发|零售|租赁业"
            }, {
                "key": "9",
                "value": "交通|运输|物流|仓储"
            },
            {
                "key": "10",
                "value": "文体教育|工艺美术"
            }, {
                "key": "11",
                "value": "文化|传媒|娱乐|体育"
            },
            {
                "key": "12",
                "value": "农|林|牧|渔|其他"
            }, {
                "key": "13",
                "value": "政府|非盈利机构"
            }
        ]
        $scope.side_category_index = 0;
        $scope.side_category = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.side_category_data,
                selectIndex: $scope.side_category_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("login_category").innerHTML = $scope.side_category_data[index].value;
                        $scope.side_category_index = index;
                        $scope.regModel._category = document.getElementById("login_category").innerHTML;
                    }
                }
            });
        }
        $scope.side_empl_num_data = [{
                "key": "1",
                "value": "100人以下"
            }, {
                "key": "2",
                "value": "100~200人"
            }, {
                "key": "3",
                "value": "300~400人"
            },
            {
                "key": "4",
                "value": "400~500人"
            }, {
                "key": "5",
                "value": "500人以上"
            }
        ]
        $scope.side_empl_num_index = 0;
        $scope.side_empl_num = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.side_empl_num_data,
                selectIndex: $scope.side_empl_num_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("login_empl_num").innerHTML = $scope.side_empl_num_data[index].value;
                        $scope.side_empl_num_index = index;
                        $scope.regModel._empl_num = document.getElementById("login_empl_num").innerHTML;
                    }
                }
            });
        }

        document.getElementById("forget_tel_no").oninput = function () {
            if (document.getElementById("forget_tel_no").value != '' && document.getElementById("modifyPwdold").value != '' && document.getElementById("forget_contact").value != '' && document.getElementById("forget_position").value != '') {
                document.getElementById('_find_pwd_action').style.opacity = '1';
            } else {
                document.getElementById('_find_pwd_action').style.opacity = '0.5';
            }
        }
        document.getElementById("modifyPwdold").oninput = function () {
            if (document.getElementById("forget_tel_no").value != '' && document.getElementById("modifyPwdold").value != '' && document.getElementById("forget_contact").value != '' && document.getElementById("forget_position").value != '') {
                document.getElementById('_find_pwd_action').style.opacity = '1';
            } else {
                document.getElementById('_find_pwd_action').style.opacity = '0.5';
            }
        }
        document.getElementById("forget_position").oninput = function () {
            if (document.getElementById("forget_tel_no").value != '' && document.getElementById("modifyPwdold").value != '' && document.getElementById("forget_contact").value != '' && document.getElementById("forget_position").value != '') {
                document.getElementById('_find_pwd_action').style.opacity = '1';
            } else {
                document.getElementById('_find_pwd_action').style.opacity = '0.5';
            }
        }
        document.getElementById("forget_contact").oninput = function () {
            if (document.getElementById("forget_tel_no").value != '' && document.getElementById("modifyPwdold").value != '' && document.getElementById("forget_contact").value != '' && document.getElementById("forget_position").value != '') {
                document.getElementById('_find_pwd_action').style.opacity = '1';
            } else {
                document.getElementById('_find_pwd_action').style.opacity = '0.5';
            }
        }


		$scope.service_and_privacy=function(){
			
            if (ionic.Platform.isIOS()) {
                window.open('http://www.zkcserv.com/app/secrecy_treaty.html', '_system', 'enableViewportScale=yes');
            } else {
                window.open('http://www.zkcserv.com/app/secrecy_treaty.html', '_system');
            }			
			

		}



        $scope.regCompAcct = function () {
			
			if(!$scope.regModel.is_agree){
				window.fufuMessageBox("请您阅读并勾选《用户协议与隐私政策》", fufu_message_box_duration, function() {});
				return;
			}
            var reg = /^1[3|4|5|7|8]\d{9}$/;
			var re = /^(?=.*[0-9])(?=.*[a-zA-Z])(.{8,20})$/;
            if ($scope.regModel._phone_num == '' || $scope.regModel._pwd1 == '' || $scope.regModel._comp_name == '' || $scope.regModel._contact_name == '' || $scope.regModel._contact_position == '' || $scope.regModel.valid_code == '') {
                $scope.regModel._flag = 0;
                $scope.regModel._message = '注册信息不能为空!';
                $timeout(function () {
                    $scope.regModel._flag = 1;
                    $scope.regModel._message = '';
                }, 1500);
                return;
            } 
			
			else if($scope.regModel._pwd1.length<8 || $scope.regModel._pwd1.length>20 || !re.test($scope.regModel._pwd1)){
				
                $scope.regModel._flag = 0;
                $scope.regModel._message = '密码长度8-20位，必须包含字母与数字!!';
				
				
			}
			else {
                $rootScope.showLoading();
                var _val = '';
                if ($scope.regModel._empl_num == "100人以下") {
                    _val = "100";
                } else if ($scope.regModel._empl_num == "100~200人") {
                    _val = "200";
                } else if ($scope.regModel._empl_num == "200~300人") {
                    _val = "300";
                } else if ($scope.regModel._empl_num == "300~400人") {
                    _val = "400";
                } else {
                    _val = "500";
                }
                var _m = new Date().getMonth() + 1;
                var _d = new Date().getDate();
                var _now = new Date().getFullYear() + "-" + (_m <= 9 ? '0' + _m : _m) + "-" + (_d <= 9 ? '0' + _d : _d);
                var _str = "";
                _str = _str + "user_name:" + $scope.regModel._phone_num + "\n";
                _str = _str + "password:" + $scope.regModel._pwd1 + "\n";
                _str = _str + "company_name:" + $scope.regModel._comp_name + "\n";
                _str = _str + "category:" + $scope.regModel._category + "\n";
                _str = _str + "employee_ct:" + _val + "\n";
                _str = _str + "contact:" + $scope.regModel._contact_name + "\n";
                _str = _str + "position:" + $scope.regModel._contact_position + "\n";
				_str = _str + "register_from:fufu_app"+ "\n";
                _str = _str + "input_date:" + _now + "\n";

                $.ajax({
                    type: "GET",
                    url: _redis_url + '/UserServer/user?action=addcus&data=' + encodeURI(_str) + '&jsonp=true&checkCode=' + $scope.regModel.valid_code,
                    dataType: "jsonp",
                    jsonp: "callback",
                    jsonpCallback: "jsonpCallBack",
                    timeout: _var_timeout,
                    success: function (data) {
                        $rootScope.hideLoading();
                        if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
                            $rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            });
                            return;
                        }
                        if (angular.isDefined(data) && angular.isDefined(data.message)) {
                            if (data.message == 'sn') {
                                if (data.value == true) {
                                    $scope.regModel._message = "考勤机序列号已被注册";
                                } else {
                                    $scope.regModel._message = "考勤机序列号不允许接入";
                                }
                            } else if (data.message == 'user_name_exists') {
                                $scope.regModel._message = '手机号码已注册!';
                            } else {
                                $scope.regModel._message = '创建企业失败,请与管理员联系!';
                                if (angular.isDefined(data) && data.message && data.message == "check_code_error") {
                                    $scope.regModel._message = '创建企业帐号失败,验证码错误';
                                }
                            }
                            $scope.regModel._flag = 0;
                            $timeout(function () {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            }, 1500);
                            return;
                        } else if (!angular.isDefined(data) || (angular.isDefined(data) && data.success == false)) {
                            $scope.regModel._flag = 0;
                            $scope.regModel._message = '创建企业帐号失败,请与管理员联系!';
                            if (angular.isDefined(data) && data.message && data.message == "check_code_error") {
                                $scope.regModel._message = '创建企业帐号失败,验证码错误';
                            }
                            $timeout(function () {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            }, 1500);
                            return;
                        } else {
                            fufuMobclickAgent('click_company_register');
                            $ionicPopup.alert({
                                    title: '运行结果',
                                    template: '<div style="text-align: center;">创建企业帐号成功,请登录</div>',
                                    okText: '确定'
                                })
                                .then(function (res) {
                                    //$scope.modal.hide();
                                    $location.path("/");
                                    $scope.regModel = {
                                        _phone_num: '',
                                        _pwd1: '',
                                        _pwd2: '',
                                        _comp_name: '',
                                        _category: '请选择您所属的行业',
                                        _empl_num: '请选择企业规模',
                                        _sn_list: '',
                                        _contact_name: '',
                                        _contact_position: '',
                                        _flag: 1,
                                        _message: ''
                                    }
                                });
                        }
                    },
                    error: function () {
                        $rootScope.hideLoading();
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                            okText: '确定'
                        })
                    }
                });
            }
        }
    })



    .controller('loginCtrl', function ($scope, userLoginService, $ionicModal, $timeout, $rootScope, $ionicPopup, $ionicActionSheet, sideSelect, $ionicHistory, $location, MsgSettingSev, $ionicScrollDelegate) {
        $scope.fufuLogo = local_resource + 'img/register/img_login_logo@2x.svg';
		

		 if (angular.isDefined(window.localStorage['_is_first_open']) && window.localStorage['_is_first_open'] == 0) {
		 
			
		 }
		 else{
					if (ionic.Platform.isIOS()) {
						
					}
					else{
							//document.getElementById("serve_treaty_popup").style.display='block';
					}
					
			
				
		 }

        $scope.icon_company_name = local_resource + 'img/icon/icon_company_name.png';
        $scope.icon_user = local_resource + 'img/icon/icon_user.png';
        $scope.close_login_page = local_resource + 'img/icon/close_login_page.png';
        clearInterval(fufu_register_timeout);
        $scope.side_category_data = [{
                "key": "1",
                "value": "IT|通信|电子|互联网"
            }, {
                "key": "2",
                "value": "金融业"
            }, {
                "key": "3",
                "value": "房地产|建筑业"
            },
            {
                "key": "4",
                "value": "商业服务"
            }, {
                "key": "5",
                "value": "生产|加工|制造"
            },
            {
                "key": "6",
                "value": "服务业"
            }, {
                "key": "7",
                "value": "能源|矿产|环保"
            },
            {
                "key": "8",
                "value": "贸易|批发|零售|租赁业"
            }, {
                "key": "9",
                "value": "交通|运输|物流|仓储"
            },
            {
                "key": "10",
                "value": "文体教育|工艺美术"
            }, {
                "key": "11",
                "value": "文化|传媒|娱乐|体育"
            },
            {
                "key": "12",
                "value": "农|林|牧|渔|其他"
            }, {
                "key": "13",
                "value": "政府|非盈利机构"
            }
        ]
        $scope.side_category_index = 0;
        $scope.side_category = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.side_category_data,
                selectIndex: $scope.side_category_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("login_category").innerHTML = $scope.side_category_data[index].value;
                        $scope.side_category_index = index;
                        $scope.regModel._category = document.getElementById("login_category").innerHTML;
                    }
                }
            });
        }
        $scope.side_empl_num_data = [{
                "key": "1",
                "value": "100人以下"
            }, {
                "key": "2",
                "value": "100~200人"
            }, {
                "key": "3",
                "value": "300~400人"
            },
            {
                "key": "4",
                "value": "300~400人"
            }, {
                "key": "5",
                "value": "500人以上"
            }
        ]
        $scope.side_empl_num_index = 0;
        $scope.side_empl_num = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.side_empl_num_data,
                selectIndex: $scope.side_empl_num_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("login_empl_num").innerHTML = $scope.side_empl_num_data[index].value;
                        $scope.side_empl_num_index = index;
                        $scope.regModel._empl_num = document.getElementById("login_empl_num").innerHTML;
                    }
                }
            });
        }

        $scope.debug_mode = debug_mode;
        $scope.loginModel = {
            _user_name: angular.isDefined(window.localStorage['_user_name']) ? window.localStorage['_user_name'] : '',
            _pass_word: ''
        }
        $scope.loginMsg = userLoginService.loginMsg();

        $scope.userLogin = function () {
			$rootScope.ad_user_flag = 1;
            if ($scope.loginModel._user_name == '' || $scope.loginModel._pass_word == '') {
                return;
            }
            MsgSettingSev.notData();
            userLoginService.userLogin($scope.loginModel);
        }

        $scope.getValidCode = function () {
            userLoginService.getValidCode();
        }

        $scope.freeExpr = userLoginService.getFreeData();


        $scope.freeExpr.cmp_name = window.localStorage['free_trial_cmp_name'];
        $scope.freeExpr.cmp_contact = window.localStorage['free_trial_cmp_contact'];
        $scope.freeExpr.tel_no = window.localStorage['free_trial_tel_no'];
        $scope.freeExpr.valid_code = window.localStorage['free_trial_valid_code'];

        $scope.sendPwdVCode = function () {
            userLoginService.sendPwdVCode();
        }
        $scope.showLoginMenu = function () {
            //$ionicActionSheet.show({
            //  buttons: [
            //    {
            //      text: '立即体验'
            //    }, {
            //      text: '企业注册'
            //    }
            //  ],
            //  titleText: '',
            //  cancelText: '取消',
            //  cancel: function() {
            //  },
            //  buttonClicked: function(index) {
            //    if(index==0){
            $scope.openFreeModal();
            //    }else{
            //      $scope.openModal();
            //    }
            //    return true;
            //  }
            //});
        }

        $scope.chooseTestingServer = function () {
            $ionicActionSheet.show({
                buttons: [{
                    text: '118'
                }, {
                    text: '120'
                }, {
                    text: 'S0'
                }, {
                    text: 'S1'
                }, {
                    text: '111'
                }, {
                    text: '120 AK'
                }, {
                    text: '118 uat dev'
                }],
                titleText: '',
                cancelText: '取消',
                cancel: function () {},
                buttonClicked: function (index) {
                    if (index == 0) {
                        return;
                        //alert('已经切换到118环境');
                        _cdn_url = 'http://192.168.2.118/fufu/fufu/www/';
                        _redis_url = 'http://120.24.153.50';
                        _login_debug_url = 'http://192.168.2.118/fufu/cb_hrms/index.cfm';
                        setLocalStorageVar("_cdn_url", "http://192.168.2.118/fufu/fufu/www/");
                        setLocalStorageVar("_redis_url", 'http://120.24.153.50');
                        setLocalStorageVar("_login_debug_url", 'http://192.168.2.118/fufu/cb_hrms/index.cfm');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 1) {
                        //alert('已经切换到120环境');
                        _cdn_url = 'http://120.24.153.50/fufu/www/';
                        _redis_url = 'http://120.24.153.50';
                        _login_debug_url = '';
                        setLocalStorageVar("_cdn_url", 'http://120.24.153.50/fufu/www/');
                        setLocalStorageVar("_redis_url", 'http://120.24.153.50');
                        setLocalStorageVar("_login_debug_url", '');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 6) {
                        //alert('已经切换到120环境');
                        _cdn_url = 'http://192.168.2.118/fufu/www/';
                        _redis_url = 'http://192.168.2.118';
                        _login_debug_url = 'http://192.168.2.118/cb_hrms/index.cfm';

                        setLocalStorageVar("_cdn_url", 'http://192.168.2.118/fufu/www/');
                        setLocalStorageVar("_redis_url", 'http://192.168.2.118');
                        setLocalStorageVar("_login_debug_url", 'http://192.168.2.118/cb_hrms/index.cfm');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 2) {
                        //alert('已经切换到S0环境');
                        _cdn_url = 'https://s0.zkcserv.com/fufu/www/';
                        _redis_url = 'https://s0.zkcserv.com';
                        _login_debug_url = '';

                        setLocalStorageVar("_cdn_url", 'https://s0.zkcserv.com/fufu/www/');
                        setLocalStorageVar("_redis_url", 'https://s0.zkcserv.com');
                        setLocalStorageVar("_login_debug_url", '');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 3) {
                        //alert('已经切换到S1环境');
                        _cdn_url = 'https://cname.zkcserv.com/fufu/www/';
                        _redis_url = 'https://zkcserv.com';
                        _login_debug_url = '';

                        setLocalStorageVar("_cdn_url", 'https://cname.zkcserv.com/fufu/www/');
                        setLocalStorageVar("_redis_url", 'https://zkcserv.com');
                        setLocalStorageVar("_login_debug_url", '');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 4) {
                        //alert('已经切换到111环境');
                        _cdn_url = 'http://192.168.2.111:8888/fufu/fufu/www/';
                        _redis_url = 'http://120.24.153.50';
                        _login_debug_url = 'http://192.168.2.111:8888/fufu/cb_hrms/index.cfm';

                        setLocalStorageVar("_cdn_url", 'http://192.168.2.111:8888/fufu/fufu/www/');
                        setLocalStorageVar("_redis_url", 'http://120.24.153.50');
                        setLocalStorageVar("_login_debug_url", 'http://192.168.2.111:8888/fufu/cb_hrms/index.cfm');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    } else if (index == 5) {
                        //alert('已经切换到120 AK环境');
                        _cdn_url = 'http://120.24.153.50/fufu_ak/www/';
                        _redis_url = 'http://120.24.153.50';
                        _login_debug_url = '';

                        setLocalStorageVar("_cdn_url", 'http://120.24.153.50/fufu_ak/www/');
                        setLocalStorageVar("_redis_url", 'http://120.24.153.50');
                        setLocalStorageVar("_login_debug_url", '');

                        if (ionic.Platform.isWebView()) {
                            setLocalStorageVar("_resource_version", '1.0');
                        } else {
                            setLocalStorageVar("_resource_version", '99.99');
                        }
                        window.location.reload();
                    }
                    return true;
                }
            });
        }

        $scope.demoLogin = function () {
            userLoginService.demoLogin($scope.free_modal);
        }
        $ionicModal.fromTemplateUrl('free_experience_account.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.free_modal = modal;
        });
        $scope.openFreeModal = function () {
            $scope.free_modal.show();
        };
        $scope.closeFreeModal = function () {
            $scope.free_modal.hide();
        };
        $scope.$on('$destroy', function () {
            $scope.free_modal.remove();
        });

        $scope.regModel = userLoginService.getRegModel();
        $scope.regCompAcct = function () {
            var reg = /^1[3|4|5|7|8]\d{9}$/;
            if ($scope.regModel._phone_num == '' || $scope.regModel._pwd1 == '' || $scope.regModel._pwd2 == '' || $scope.regModel._comp_name == '' || $scope.regModel._sn_list == '' || $scope.regModel.valid_code == '') {
                $scope.regModel._flag = 0;
                $scope.regModel._message = '注册信息不能为空!';
                $timeout(function () {
                    $scope.regModel._flag = 1;
                    $scope.regModel._message = '';
                }, 1500);
                return;
            } else if ($scope.regModel._pwd1 != $scope.regModel._pwd2) {
                $scope.regModel._flag = 0;
                $scope.regModel._message = '密码与确认密码不相同!';
                $timeout(function () {
                    $scope.regModel._flag = 1;
                    $scope.regModel._message = '';
                }, 1500);
                return;
            } else {
                $rootScope.showLoading();
                var _val = '';
                if ($scope.regModel._empl_num == "100人以下") {
                    _val = "100";
                } else if ($scope.regModel._empl_num == "100~200人") {
                    _val = "200";
                } else if ($scope.regModel._empl_num == "200~300人") {
                    _val = "300";
                } else if ($scope.regModel._empl_num == "300~400人") {
                    _val = "400";
                } else {
                    _val = "500";
                }
                var _m = new Date().getMonth() + 1;
                var _d = new Date().getDate();
                var _now = new Date().getFullYear() + "-" + (_m <= 9 ? '0' + _m : _m) + "-" + (_d <= 9 ? '0' + _d : _d);
                var _str = "";
                _str = _str + "user_name:" + $scope.regModel._phone_num + "\n";
                _str = _str + "password:" + $scope.regModel._pwd1 + "\n";
                _str = _str + "company_name:" + $scope.regModel._comp_name + "\n";
                _str = _str + "category:" + $scope.regModel._category + "\n";
                _str = _str + "employee_ct:" + _val + "\n";
                _str = _str + "sn_list:" + $scope.regModel._sn_list + "\n";
				_str = _str + "register_from:fufu_app"+ "\n";
                _str = _str + "input_date:" + _now + "\n";
                $.ajax({
                    type: "GET",
                    url: _redis_url + '/UserServer/user?action=addcus&data=' + encodeURI(_str) + '&jsonp=true&checkCode=' + $scope.regModel.valid_code,
                    dataType: "jsonp",
                    jsonp: "callback",
                    jsonpCallback: "jsonpCallBack",
                    timeout: _var_timeout,
                    success: function (data) {
                        $rootScope.hideLoading();
                        if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
                            $rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            });
                            return;
                        }
                        if (angular.isDefined(data) && angular.isDefined(data.message)) {

                            if (data.message == 'sn') {
                                if (data.value == true) {
                                    $scope.regModel._message = "考勤机序列号已被注册";
                                } else {
                                    $scope.regModel._message = "考勤机序列号不允许接入";
                                }
                            } else if (data.message == 'user_name_exists') {
                                $scope.regModel._message = '手机号码已注册!';
                            } else {
                                $scope.regModel._message = '创建企业失败,请与管理员联系!';
                                if (angular.isDefined(data) && data.message && data.message == "check_code_error") {
                                    $scope.regModel._message = '创建企业帐号失败,验证码错误';
                                }
                            }
                            $scope.regModel._flag = 0;
                            $timeout(function () {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            }, 1500);
                            return;
                        } else if (!angular.isDefined(data) || (angular.isDefined(data) && data.success == false)) {

                            $scope.regModel._flag = 0;
                            $scope.regModel._message = '创建企业帐号失败,请与管理员联系!';
                            if (angular.isDefined(data) && data.message && data.message == "check_code_error") {
                                $scope.regModel._message = '创建企业帐号失败,验证码错误';
                            }
                            $timeout(function () {
                                $scope.regModel._flag = 1;
                                $scope.regModel._message = '';
                            }, 1500);
                            return;
                        } else {
                            fufuMobclickAgent('click_company_register');
                            $ionicPopup.alert({
                                    title: '运行结果',
                                    template: '<div style="text-align: center;">创建企业帐号成功,请登录</div>',
                                    okText: '确定'
                                })
                                .then(function (res) {
                                    $scope.modal.hide();
                                    $scope.regModel = {
                                        _phone_num: '',
                                        _pwd1: '',
                                        _pwd2: '',
                                        _comp_name: '',
                                        _category: '请选择您所属的行业',
                                        _empl_num: '请选择企业规模',
                                        _sn_list: '',
                                        _flag: 1,
                                        _message: ''
                                    }
                                });
                        }
                    },
                    error: function () {
                        $rootScope.hideLoading();
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                            okText: '确定'
                        })
                    }
                });
            }
        }

        $ionicModal.fromTemplateUrl('comp-reg-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });

        $scope.loginUserChange = function () {
            if ($scope.loginModel._user_name == '' || $scope.loginModel._pass_word == '') {
                document.getElementById('loginSubmit').style.color = '#cccccc';
                document.getElementById('loginSubmit').style.borderColor = '#cccccc';
            } else {
                document.getElementById('loginSubmit').style.color = '#53afff';
                document.getElementById('loginSubmit').style.borderColor = '#53afff';
            }

        }

        $scope.loginPwdChange = function () {

            if ($scope.loginModel._user_name == '' || $scope.loginModel._pass_word == '') {
                document.getElementById('loginSubmit').style.color = '#cccccc';
                document.getElementById('loginSubmit').style.borderColor = '#cccccc';
            } else {
                document.getElementById('loginSubmit').style.color = '#53afff';
                document.getElementById('loginSubmit').style.borderColor = '#53afff';
            }
        }

    })
    .controller('userHomeCtrl', function ($interval,$scope, homemessageSev, userHomeService, $location, $ionicHistory, $ionicPopup, $ionicLoading, $rootScope, $ionicScrollDelegate, $timeout, searchDeviceSev, $setstatusBar, scanBluetoothStateSev, aiDeviceSev, attendanceNetStateSev, tripApplyForSev) {
        $scope.net_error = local_resource + 'img/icon/net_error.png';
        $scope.rq_icon = local_resource + 'img/icon_scan.png';
		$scope.icon_route = local_resource + 'img/icon/icon_route.png';
		$scope.icon_arrow = local_resource + 'img/icon/icon_arrow.png';
        $scope.local_resource = local_resource;
		
		$scope.is_hide_fangyi = window.localStorage['_user_name']=='fufu';
		
     
		
		$scope.fangyi_path=function(){
			
				if(window.localStorage['_user_name']=='fufu'){
					return;
				}
			
			fufuMobclickAgent('tencent_action');
				//春运防疫	
				try{
						// var opt = {'userName': 'gh_ad64296dc8bd', 'path': 'launch/launch?target=epidemic&from=fufu', 'miniprogramType': 0};
						// WXMiniProgram.launchMiniProgram(opt, function(data){
						// 	if(data.code=='3001'){
						// 			window.fufuMessageBox('请安装微信', fufu_message_box_duration, function () {});
						// 	}
							
						// });
						// return;
                         if (ionic.Platform.isIOS()) {
                            NativeBrowser.openBrowser(opt);
                            window.open('https://vip1.zkcserv.com/fufu/www/ZM200_detail.html', '_system', 'enableViewportScale=yes');
                        } else {
                            window.open('https://vip1.zkcserv.com/fufu/www/ZM200_detail.html', '_system');
                        }   
                        return;
				}catch(e){
					console.log(e.message);
				}

		}
        
		/* add by kevin at 2018-08-29 begin */ 
        /* 广告模块 */
		if($rootScope.ad_user_flag == 1 || $rootScope.playStatus){
			
			if($('.tab-nav.tabs').css("display","flex").css("display") == "none"){
				$('.tab-nav.tabs').css("display","-webkit-flex");
			}
            $('#adBlock').css("display","none");
		}else{

			$scope.adTime = 5;
			$scope.resource_url = '';
			if(typeof(window.localStorage._ads_local_resource)=='undefined'||window.localStorage._ads_local_resource==''){
				$scope.resource_url = local_resource;
			}else{
				$scope.resource_url = window.localStorage._ads_local_resource;
			}
			
			if(typeof(window.localStorage._ads_url)!='undefined'&&window.localStorage._ads_url!=""){
				$scope.ad1 = $scope.resource_url + window.localStorage._ads_url;
			}else{
				$scope.ad1 = $scope.resource_url + 'img/ads/ads.png';
			}
			$scope.remainTime = $scope.adTime + "s 跳过";
			var timer = null;
			
			
			$scope.navigateToPage = function(url,e){
				
				window.event ? window.event.cancelBubble = true : e.stopPropagation();
				if($('.tab-nav.tabs').css("display","flex").css("display") == "none"){
					$('.tab-nav.tabs').css("display","-webkit-flex");
				}
				$('#adBlock').css("cssText","display:none !important;");
				$rootScope.playStatus = true;
				if(timer != null){
					$interval.cancel(timer);
					timer = null;
				}
				
			};
			$scope.$on("$ionicView.enter", function (event, data) {
				
				if(timer == null){
					
				}

				//进入之后
				timer = $interval(function(){
					$scope.adTime -= 1;
					if($scope.adTime <= 0){
						$scope.remainTime = "跳过";
						$interval.cancel(timer);
						timer = null;
						if($('.tab-nav.tabs').css("display","flex").css("display") == "none"){
							$('.tab-nav.tabs').css("display","-webkit-flex");
						}
						$('#adBlock').css("cssText","display:none !important;");
						$rootScope.playStatus = true;
					}else{
						$scope.remainTime = $scope.adTime + "s 跳过";
					}
				},1000)
			});
		
		}

		 
		/* 2018-11-16 修改 */


        $scope.openQr = function () {


            if (ionic.Platform.isIOS()) {


                barcodeScanner.scan(function (msg) {
					barcodeScanner.close();
                    if (msg) {
                        if (msg == urlList[0] || msg == urlList[1]) {
                            searchDeviceSev.setReset(true);
                            autosignin.pauseSignIn();
                            homemessageSev.setLyFlag(1);
                            scanBluetoothStateSev.setState(true);
                            searchDeviceSev.setResetNetState(false);
                            attendanceNetStateSev.setDeviceType(0);
                            $location.path('/home_page/home_default/search_device');
                        } else if (IsURL(msg)) {
							if(msg.indexOf("/UserServer/qrcode?action=bind&sn=")!=-1){
								if(localStorage._role_name!='ess'&&localStorage._role_name!='ESS'){
									userHomeService.addScanCodeDevice(getQueryString(msg,"sn"));
								}else{
									$ionicPopup.alert({
										title: '提醒',
										template: '<div style="text-align: center;">对不起，您没有权限操作，请联系管理员</div>',
										okText: '确定'
									}).then(function () {
									});
								}
							}else{
								 var ref = cordova.InAppBrowser.open(msg, '_blank', 'location=yes');
							}
                            
                        } else {
                            var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');
                        }
                    } else {
                        //扫描失败 或者是 取消
                        barcodeScanner.close();
                    }

                });
            } else {

                barcodeScanner.checkCameraPermission(function (msg) {

                    if (msg == 1) {
                        barcodeScanner.scan(function (msgs) {
							barcodeScanner.close();
                            if (msgs) {

                                if (msgs == urlList[0] || msgs == urlList[1]) {
                                    $timeout(function () {
                                        searchDeviceSev.setReset(true);
                                        autosignin.pauseSignIn();
                                        homemessageSev.setLyFlag(1);
                                        scanBluetoothStateSev.setState(true);
                                        searchDeviceSev.setResetNetState(false);
                                        attendanceNetStateSev.setDeviceType(0);
                                        $location.path('/home_page/home_default/search_device');

                                    }, 0);
                                } else if (IsURL(msgs)) {
									if(msgs.indexOf("/UserServer/qrcode?action=bind&sn=")!=-1){
										if(localStorage._role_name!='ess'&&localStorage._role_name!='ESS'){
											userHomeService.addScanCodeDevice(getQueryString(msgs,"sn"));
										}else{
											$ionicPopup.alert({
												title: '提醒',
												template: '<div style="text-align: center;">对不起，您没有权限操作，请联系管理员</div>',
												okText: '确定'
											}).then(function () {
											});
										}
									}else{
										 var ref = cordova.InAppBrowser.open(msgs, '_blank', 'location=yes');
									}
									
                                } else {
                                    var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');
                                }

                            } else {
                                //扫描失败 或者是 取消
                                barcodeScanner.close();
                            }

                        });



                    } else {
                        console.log("相机权限失败");
                    }
                });
            }

        }

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $scope.lyFlag = homemessageSev.retLyFlag();

            if ($scope.lyFlag.state == 1) {
                autosignin.reopenSignIn();
                homemessageSev.setLyFlag(0);
            }

            $setstatusBar.white();

            // $rootScope.showLoading();
            // $rootScope.hideLoading();
            // window.fufuMessageBox("test", fufu_message_box_duration, function() {
            //   console.log(fufu_show_loading_counter);
            // });
        });

        $scope.wifi_obj = userHomeService.getWifiObj();
        $timeout(function () {
            if (document.getElementById("user_home_is_connected") != null && typeof (document.getElementById("user_home_is_connected")) != 'undefined') {
                document.getElementById("user_home_is_connected").style.display = 'block';
            }
        }, 1000);

        if (login_init_flag == 0) {
            if (typeof (login_flag) != 'undefined' && login_flag == 1) {
				checkAdsVersion(window.localStorage['_remote_server_addr']);
                checkMbAppVersion(window.localStorage['_remote_server_addr'], $ionicPopup, $ionicLoading, $rootScope, $location);
            }
            login_init_flag = 1;
        }
        homemessageSev.loadMessageCount();
        $scope.local_resource = local_resource;
        $scope.img_banner = local_resource + 'img/register/img_banner_2.png';
        $scope.img_exit_trial_login = local_resource + 'img/icon/exit_trial_login.png';
        if (window.localStorage["org_top_level"] != null && typeof (window.localStorage["org_top_level"]) != 'undefined' && window.localStorage["org_top_level"] != '') {

        } else {
            setLocalStorageVar("org_top_level", "本公司");
        }

        if (window.localStorage["is_free_trial_login"] != null && typeof (window.localStorage["is_free_trial_login"]) != 'undefined' && window.localStorage["is_free_trial_login"] != '') {
            document.getElementById("home_default_is_trial_login").style.display = 'block';
        } else {
            document.getElementById("home_default_is_trial_login").style.display = 'none';
        }


        if (window.localStorage["menu_home"] != null && typeof (window.localStorage["menu_home"]) != 'undefined' && window.localStorage["menu_home"] != '') {
            $scope.menuList = userHomeService.getMenuList();

            //$scope.menuList = $.parseJSON(window.localStorage["menu_home"]);
            userHomeService.setMenuList($.parseJSON(window.localStorage["menu_home"]));
            $rootScope.hideLoading();
        } else {
            userHomeService.loadMenuList();
            $scope.menuList = userHomeService.getMenuList();

        }


        $scope.redirectPage = function (menu_key, menu_name, fg) {

            if (angular.isDefined(fg) && fg == 0) {
                $location.path('home_page/home_default/' + menu_key + '/' + menu_name);
            } else {
                if (menu_key == 'staff_master') {
                    fufuMobclickAgent('menu_staff_master');
                } else if (menu_key == 'employee_contract') {
                    fufuMobclickAgent('menu_employee_contract');
                } else if (menu_key == 'at_empl_card_rec') {
                    fufuMobclickAgent('menu_at_empl_card_rec');
                } else if (menu_key == 'my_leave_balance') {
                    fufuMobclickAgent('menu_my_leave_balance');
                } else if (menu_key == 'pay_slip') {
                    fufuMobclickAgent('menu_pay_slip');
                } else if (menu_key == 'at_team_record') {
                    fufuMobclickAgent('menu_at_team_record');
                } else if (menu_key == 'leave_team_record') {
                    fufuMobclickAgent('menu_leave_team_record');
                } else if (menu_key == 'outdoor_team_record') {
                    fufuMobclickAgent('menu_outdoor_team_record');
                } else if (menu_key == 'leave_balance_team_record') {
                    fufuMobclickAgent('menu_leave_balance_team_record');
                } else if (menu_key == 'ot_team_record') {
                    fufuMobclickAgent('menu_ot_team_record');
                } else if (menu_key == 'customer_info') {
                    fufuMobclickAgent('menu_customer_info');
                } else if(menu_key == 'business_trip_apply'){
                    tripApplyForSev.clearData();
                    tripApplyForSev.setState(true);
                        // $location.path('home_page/home_menulist/business_trip_apply/add/0/0/0');
                    $ionicHistory.clearCache()
                    tripApplyForSev.setOpt('add', 0, 0, 0);
                }

               
                $location.path('home_page/home_menulist/' + menu_key);
            }
        }

		$scope.banner_click=function(i){
            if(window.localStorage['_user_name']=='fufu'){
                    return;
                }
			if(i=='0'){
				
				try{
						if (ionic.Platform.isIOS()) {
                            window.open('https://vip1.zkcserv.com/fufu/www/xface600TI_detail.html', '_system', 'enableViewportScale=yes');
                        } else {
                            window.open('https://vip1.zkcserv.com/fufu/www/xface600TI_detail.html', '_system');
                        }   
						return;
				}catch(e){
						console.log(e.message);
				}

			}
			if(i=='2'){
                try{
                        if (ionic.Platform.isIOS()) {
                            window.open('https://vip1.zkcserv.com/fufu/www/xface700_detail.html', '_system', 'enableViewportScale=yes');
                        } else {
                            window.open('https://vip1.zkcserv.com/fufu/www/xface700_detail.html', '_system');
                        }   
                        return;
                }catch(e){
                        console.log(e.message);
                }
            }
			
		}

        $scope.swiperData = [{
                imgUrl: local_resource + 'img/register/banner_01' + (angular.isDefined(window.localStorage._vip_bu) && window.localStorage._vip_bu != 'undefined' ? window.localStorage._vip_bu : '') + '.png',
                locationUrl: ''
            },{
                imgUrl: local_resource + 'img/register/banner_3_2' + (angular.isDefined(window.localStorage._vip_bu) && window.localStorage._vip_bu != 'undefined' ? window.localStorage._vip_bu : '') + '.jpg',
                locationUrl: ''
            },{
                imgUrl: local_resource + 'img/register/banner3_3' + (angular.isDefined(window.localStorage._vip_bu) && window.localStorage._vip_bu != 'undefined' ? window.localStorage._vip_bu : '') + '.jpg',
                locationUrl: ''
            }
        ];

        $scope.free_trial_log_out = function () {
            $ionicPopup.confirm({
                title: '退出登录',
                template: '<div style="text-align: center;">是否退出系统?</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    //$rootScope.showLoading();
                    $.ajax({
                        type: "GET",
                        url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
                        timeout: _var_timeout,
                        success: function (data) {
                            $rootScope.hideLoading();
                        },
                        error: function (data) {
                            $rootScope.hideLoading();
                            /*
                             $ionicPopup.alert({
                             title : '提醒',
                             template : '<div style="text-align: center;">'+fufu_network_error_msg+'</div>',
                             okText : '确定'
                             });
                             */
                        }
                    });
                    $ionicHistory.clearCache();
                    $ionicHistory.clearHistory();
                    setLocalStorageVar("_pass_word", "");
                    setLocalStorageVar("_is_login", "0");
                    if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
                        var model_list = window.localStorage["menu_list"].split(',');
                        for (var i = 0; i < model_list.length; i++) {
                            if (model_list[i] != '') {
                                setLocalStorageVar(model_list[i], "");
                            }
                        }
                    }
                    setLocalStorageVar("menu_list", "");
                    setLocalStorageVar("menu_home", "");
                    setLocalStorageVar("menu_message", "");
                    setLocalStorageVar("menu_organization_management", "");
                    setLocalStorageVar("menu_time", "");
                    setLocalStorageVar("menu_payroll", "");
                    setLocalStorageVar("menu_ess", "");
                    setLocalStorageVar("menu_My_Team", "");
                    setLocalStorageVar("menu_setting", "");
                    setLocalStorageVar("personnal_data", "");
                    setLocalStorageVar("is_free_trial_login", "");

                    login_init_flag = 0;
                    $location.path('/');

                }
            });
        }
    })

    .controller('searchDeviceCtrl', function ($scope, $rootScope, $location, searchDeviceSev, $ionicHistory, $ionicPopup, $ionicPlatform, bluetoothDeviceSev, $setstatusBar) {

        $setstatusBar.black();

        $scope.local_resource = local_resource;

        $scope.removeEvent = null;

        $scope.back = function () {
            //解除绑定
            bluetoothDeviceSev.perish();

            bluetooth.cancelBleConfig();

            $ionicHistory.goBack();

        };

        $scope.isIos = ionic.Platform.isIOS();


        $scope.ratioSmall = 200 > (screen.height - screen.width);

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前

            $ionicPlatform.onHardwareBackButton($scope.back);

            $scope.searchDeviceData = searchDeviceSev.getData();


            if ($scope.searchDeviceData.isReset) {
                searchDeviceSev.setReset();
                searchDeviceSev.test($scope.back);
            } else {

                searchDeviceSev.setReset();
                searchDeviceSev.test($scope.back, true);

            }

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

            barcodeScanner.close();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })

    .controller('deviceStateCtrl', function ($scope, $rootScope, $location, connectDeviceStateSev, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, bluetoothDeviceSev, $setstatusBar, $stateParams, configWifiSev, setConfigNetSev, configIpAddressSev) {
        $scope.local_resource = local_resource;
        $setstatusBar.black();
        var curView = "/home_page/home_default/device_state";

        $scope.timeout = null;
        $scope.cur_alleyway = {};
        $scope.cur_alleyway.state = null;

        $scope.myPopup = null;

        //调试用
        // connectDeviceStateSev.setDeviceState(2,"施特伟(深圳)科技有限公司");
        $scope.connectDeviceData = connectDeviceStateSev.getData();
        //              5    // 考勤机蓝牙连接成功
        //              6   // 考勤机蓝牙断开连接
        //              12    // 考勤机连接失败（蓝牙根本连接不了）
        $scope.back = function () {

            bluetooth.cancelBleConfig();
            bluetoothDeviceSev.perish();
            // if($scope.connectDeviceData.stateType == 5){
            //     //关闭通讯
            //     bluetooth.cancelBleConfig();
            //     //连接成功下 back
            //     $ionicHistory.goBack();
            // }else{
            //     $ionicHistory.goBack(-2);
            // }
            $ionicHistory.goBack(-2);
        };

        $scope.goToSetWifi = function () {
            $scope.timeout = $timeout(function () {
                if ($ionicHistory.currentView().url.indexOf(curView) < 0) {
                    return console.log($ionicHistory.currentView().url);
                }

                if ($scope.myPopup) {
                    return console.log("$scope.myPopup" + $scope.myPopup);
                }

                if ($stateParams.is_wlan == 0) {
                    configWifiSev.setBackStepNum(0);
                    $location.path('/home_page/home_default/config_wifi');
                } else if ($stateParams.is_wlan == 1) {
                    setConfigNetSev.resetData();
                    //重置配置IP地址信息
                    configIpAddressSev.resetData();
                    $location.path('/home_page/home_default/set_config_net');
                }



            }, 2000);
        }

        $scope.refresh = function () {
            $ionicHistory.goBack();
        };

        function scanBluetoothFunc(update) {
            if (update.status == 10) {


                if ($scope.timeout) {
                    $timeout.cancel($scope.timeout);
                    $scope.timeout = null;
                }

                if ($scope.cur_alleyway.state == 6) {
                    return;
                }

                if ($scope.myPopup) {
                    $scope.myPopup.close();
                    $scope.myPopup = null;
                }

                if ($ionicHistory.currentView().url.indexOf(curView) < 0) {
                    return console.log($ionicHistory.currentView().url);
                }

                $scope.myPopup = $ionicPopup.confirm({
                    title: '设备连接已断开',
                    scope: $scope,
                    buttons: [{
                            text: '返回',
                            type: 'button-light',
                            onTap: function () {
                                bluetoothDeviceSev.perish();
                                $ionicHistory.goBack(-1);
                                $timeout(function () {
                                    $scope.cur_alleyway.state = null;
                                }, 0);
                            }
                        },
                        {
                            text: '退出',
                            type: 'button-light',
                            type: 'button-positive',
                            onTap: function (e) {
                                $scope.back();
                                $timeout(function () {
                                    $scope.cur_alleyway.state = null;
                                }, 0);
                            }
                        }
                    ]
                });

            }


            if (update.status == 6) {

                if ($scope.timeout) {
                    $timeout.cancel($scope.timeout);
                    $scope.timeout = null;

                }

                if ($scope.myPopup) {
                    $scope.myPopup.close();
                    $scope.myPopup = null;
                }

                $scope.cur_alleyway.state = 6;

                if ($ionicHistory.currentView().url.indexOf(curView) < 0) {
                    return console.log($ionicHistory.currentView().url);
                }

                $scope.myPopup = $ionicPopup.confirm({
                    title: '设备连接已断开',
                    scope: $scope,
                    buttons: [{
                            text: '返回',
                            type: 'button-light',
                            onTap: function () {
                                bluetoothDeviceSev.perish();
                                $ionicHistory.goBack(-1);
                                $timeout(function () {
                                    $scope.cur_alleyway.state = null;
                                }, 0);
                            }
                        },
                        {
                            text: '退出',
                            type: 'button-light',
                            type: 'button-positive',
                            onTap: function (e) {
                                $scope.back();
                                $timeout(function () {
                                    $scope.cur_alleyway.state = null;
                                }, 0);
                            }
                        }
                    ]
                });

            }
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            $ionicPlatform.onHardwareBackButton($scope.back);

            bluetoothDeviceSev.perish();

            if ($scope.connectDeviceData.stateType == 5) {
                bluetoothDeviceSev.listen().then(null, null, scanBluetoothFunc);
            }

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            if ($scope.connectDeviceData.stateType == 5) {
                $timeout(function () {
                    $scope.goToSetWifi();
                }, 500);


            }
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            $ionicPlatform.offHardwareBackButton($scope.back);

            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }
        });


    })

    .controller('configWifiCtrl', function ($scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, configWifiSev, $headNotifySer, bluetoothDeviceSev, attendanceDeviceSev, scanBluetoothStateSev, searchDeviceSev, attendanceDeviceSettingSev, $ionicPlatform) {
        $scope.local_resource = local_resource;

        var curView = "/home_page/home_default/config_wifi";
        $scope.operateText = "";
        $scope.configWifiData = {};

        $scope.showPass = false;

        $scope.myPopup = null;

        $scope.is_back = false;

        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function () {
            if (fufu_show_loading_counter != 0 && !$scope.is_back) {
                return;
            }


            bluetoothDeviceSev.perish();

            $rootScope.hideLoading();


            $ionicHistory.goBack((-3 - configWifiSev.getBackStepNum()));
            $scope.leaveHandle();
            //断开设备通讯
            bluetooth.cancelBleConfig();

        };

        $scope.backNotClosePop = function () {

        };

        $scope.back2 = function () {
            bluetoothDeviceSev.perish();

            $rootScope.hideLoading();


            $ionicHistory.goBack((-3 - configWifiSev.getBackStepNum()));
            $scope.leaveHandle();
            //断开设备通讯
            bluetooth.cancelBleConfig();


        }

        $scope.diyback = function () {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否退出配置网络',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light',
                        onTap: function () {

                        }
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.back();
                        }
                    }
                ]
            });
        }

        $scope.loadNetListCallback = function () {


            $timeout(function () {
                $scope.configWifiData = configWifiSev.getData();
                $scope.configWifiData.netList.length ? $scope.operateText = "选择网络..." : $scope.operateText = "没有网络...";
                $rootScope.hideLoading();
            }, 0);
        };

        $scope.connectNetCallback = function (state) {

            switch (state) {
                case 0:
                    $timeout(function () {
                        $headNotifySer.notify("success", "设备成功连上网络啦", 2000);
                    }, 0);

                    $timeout(function () {

                        if (searchDeviceSev.getResetNetState()) {

                            var device_data = attendanceDeviceSettingSev.getData();
                            attendanceDeviceSettingSev.loadData(device_data.device_sn, device_data.device_name).then(function () {
                                if ($scope.myPopup) {
                                    $scope.myPopup.close();
                                    $scope.myPopup = null;
                                }
                                if ($ionicHistory.currentView().url != curView) {
                                    return console.log($ionicHistory.currentView().url);
                                }
                                $scope.is_back = true;

                                $timeout(function () {
                                    $scope.back();
                                }, 0);
                            });

                        } else {
                            try {

                                //
                                var date = new Date();
                                var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
                                var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
                                var inputdate = date.getFullYear() + "-" + month + "-" + day;

                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.addsn",
                                    timeout: 300000,
                                    data: {
                                        update_data: 'sn:' + _cur_sn_no + '\n' + 'id:' + '\n' + 'status:0' + '\n' + 'input_date:',
                                        data: 'sn:' + _cur_sn_no + '\n' + 'status:1' + '\n ' + 'input_date: ' + inputdate,
                                        device_sn: _cur_sn_no,
                                        device_name: _cur_sn_no,
                                        _is_new: 1
                                    },
                                    success: function (json) {

                                        var data = $.parseJSON(json);
                                        if (angular.isDefined(data.flag) && data.flag == '0') {



                                            $timeout(function () {
                                                if ($ionicHistory.currentView().url != curView) {
                                                    return console.log($ionicHistory.currentView().url);
                                                }
                                                $headNotifySer.notify("continue", "正在配置考勤机...");
                                            }, 0);
                                        } else {
                                            if ($scope.myPopup) {
                                                $scope.myPopup.close();
                                                $scope.myPopup = null;
                                            }
                                            if ($ionicHistory.currentView().url != curView) {
                                                return console.log($ionicHistory.currentView().url);
                                            }
                                            $scope.deregister();
                                            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                                                $scope.backNotClosePop, 401
                                            );
                                            // $rootScope.hideLoading();
                                            $scope.myPopup = $ionicPopup.show({
                                                template: '<div style="text-align: center;">' + data.message + '</div>',
                                                title: '提示',
                                                scope: $scope,
                                                buttons: [{
                                                    text: '<b>确定</b>',
                                                    type: 'button-positive',
                                                    onTap: function (e) {
                                                        $scope.back2();
                                                    }
                                                }]
                                            });
                                        }

                                    },
                                    error: function () {
                                        if ($scope.myPopup) {
                                            $scope.myPopup.close();
                                            $scope.myPopup = null;
                                        }
                                        if ($ionicHistory.currentView().url != curView) {
                                            return console.log($ionicHistory.currentView().url);
                                        }
                                        $scope.deregister();
                                        $scope.deregister = $ionicPlatform.registerBackButtonAction(
                                            $scope.backNotClosePop, 401
                                        );
                                        // $rootScope.hideLoading();
                                        $scope.myPopup = $ionicPopup.show({
                                            template: '<div style="text-align: center;">' + data.message + '</div>',
                                            title: '提示',
                                            scope: $scope,
                                            buttons: [{
                                                text: '<b>确定</b>',
                                                type: 'button-positive',
                                                onTap: function (e) {
                                                    $scope.back2();
                                                }
                                            }]
                                        });
                                    }
                                })
                                //
                            } catch (e) {
                                //alert(e);
                            }
                        }



                    }, 2000);
                    break;

                case 1:
                    $scope.operateText = "选择网络...";
                    $rootScope.hideLoading();

                    $timeout(function () {
                        $headNotifySer.notify("error", "网络连接失败", 2000);
                    }, 0);

                    break;

                case 2:
                    $scope.operateText = "选择网络...";
                    $rootScope.hideLoading();

                    //设备断开连接
                    $scope.disconnect();
                    break;

                case 3:
                    $scope.operateText = "选择网络...";
                    $rootScope.hideLoading();

                    // $timeout(function(){
                    //     $headNotifySer.notify("error","网络连接失败",2000);
                    // },0);
                    $scope.disconnect();
                    break;

                case 4:

                    // 蓝牙设备绑定成功
                    $scope.operateText = "选择网络...";
                    $rootScope.hideLoading();
                    bluetoothDeviceSev.perish();
                    if ($ionicHistory.currentView().url != curView) {
                        return console.log($ionicHistory.currentView().url);
                    }

                    $scope.goAttendanceDevice();
                    break;

                case 5:
                    // 蓝牙设备绑定失败(或绑定超时)
                    if ($scope.myPopup) {
                        $scope.myPopup.close();
                        $scope.myPopup = null;
                    }
                    try {
                        $scope.operateText = "选择网络...";
                        $rootScope.hideLoading();
                        $timeout(function () {
                            $headNotifySer.notify("error", "考勤机配置失败", 2000);
                        }, 0);
                        $headNotifySer.destroy();

                        $timeout(function () {
                            if ($scope.myPopup) {
                                $scope.myPopup.close();
                                $scope.myPopup = null;
                            }
                            $scope.notTap = true;
                            $scope.back();
                            $scope.configWifiData.cur_alleyway_state = null;
                        }, 2000);

                    } catch (e) {
                        alert(e);
                    }

                    break;

                case 2:
                    //设备断开连接
                    $scope.disconnect();
                    break;

                case 3:
                    // $timeout(function(){
                    //     $headNotifySer.notify("error","网络连接失败",2000);
                    // },0);
                    $scope.disconnect();
                    break;

                default:
                    // alert("没有出现的状态："+state);
            }


            //清空密码
            $scope.ionicPopupCancel();
        }

        $scope.configWifiSev = configWifiSev;

        $scope.ionicPopupCancel = function (e) {
            $scope.configWifiData.wifiPass = "";
            $scope.configWifiData.wifiName = "";


            $scope.configWifiData.connectNet.ssid = "";
            $scope.configWifiData.connectNet.bssid = "";
            $scope.configWifiData.connectNet.isPassWord = null;
            $scope.configWifiData.connectNet.level = null;

        };


        $scope.connectNet = function (itemNet) {
            if ($scope.notTap) {
                return;
            }

            if (itemNet.isPassWord) {


                $scope.myPopup = $ionicPopup.show({
                    template: '<div><div style="height:44px" class="flex-cont flex-vertical net-popup-box"><input type="{{showPass?\'text\':\'password\'}}" placeholder="请输入密码" ng-model="configWifiData.wifiPass"><i class="r-icon" ng-click="showPass = !showPass" ng-class="{\'r-zy-icon\':showPass,\'r-by-icon\':!showPass}"></i></div> </div>',
                    title: '请输入"' + itemNet.ssid + '"的密码',
                    scope: $scope,
                    cssClass: 'popup-body-not-pd',
                    buttons: [{
                            text: '取消',
                            type: 'button-light',
                            onTap: $scope.ionicPopupCancel
                        },
                        {
                            text: '确认',
                            type: 'button-positive',
                            onTap: function (e) {



                                if (itemNet.ssid && $scope.configWifiData.wifiPass) {

                                    $rootScope.showLoading();

                                    $scope.configWifiData.connectNetBak.ssid = itemNet.ssid;
                                    $scope.configWifiData.connectNetBak.bssid = itemNet.bssid;
                                    $scope.configWifiData.connectNetBak.isPassWord = itemNet.isPassWord;
                                    $scope.configWifiData.connectNetBak.level = itemNet.level;

                                    $scope.configWifiSev.connect_net(itemNet, $scope.configWifiData.wifiPass);



                                    $scope.operateText = "";
                                } else {
                                    window.fufuMessageBox('密码信息内容不能为空', fufu_message_box_duration, function () {});
                                }



                            }
                        },
                    ]
                });

            } else {
                $scope.myPopup = $ionicPopup.confirm({
                    title: '是否连接' + itemNet.ssid + '网络',
                    scope: $scope,
                    buttons: [{
                            text: '取消',
                            type: 'button-light',
                            onTap: $scope.ionicPopupCancel
                        },
                        {
                            text: '确定',
                            type: 'button-light',
                            type: 'button-positive',
                            onTap: function (e) {
                                $rootScope.showLoading();

                                $scope.configWifiData.connectNetBak.ssid = itemNet.ssid;
                                $scope.configWifiData.connectNetBak.bssid = itemNet.bssid;
                                $scope.configWifiData.connectNetBak.isPassWord = itemNet.isPassWord;
                                $scope.configWifiData.connectNetBak.level = itemNet.level;

                                $scope.configWifiSev.connect_net(itemNet, "");

                                $scope.operateText = "";

                            }
                        }
                    ]
                });
            }
        };

        $scope.connectHideNet = function () {

            if ($scope.notTap) {
                return;
            }

            $scope.showPass = false;

            $scope.myPopup = $ionicPopup.show({
                template: '<div class="net-popup-box"><div class="flex-cont flex-vertical" style="height:44px"><input type="text" placeholder="网络名称" ng-model="configWifiData.wifiName"></div><div class="flex-cont flex-vertical" style="height:44px"><input type="{{showPass?\'text\':\'password\'}}" placeholder="请输入密码" ng-model="configWifiData.wifiPass"><i class="r-icon" ng-click="showPass = !showPass" ng-class="{\'r-zy-icon\':showPass,\'r-by-icon\':!showPass}"></i></div> </div>',
                title: '其他网络',
                scope: $scope,
                cssClass: 'popup-body-not-pd',
                buttons: [{
                        text: '取消',
                        type: 'button-light',
                        onTap: function (e) {

                        }
                    },
                    {
                        text: '确认',
                        type: 'button-positive',
                        onTap: function (e) {

                            if ($scope.configWifiData.wifiName) {

                                $rootScope.showLoading();

                                $scope.configWifiSev.bakConnectInfo = {};
                                var opt = {
                                    ssid: $scope.configWifiData.wifiName,
                                    isPassWord: 1,
                                    level: 1,
                                    bssid: "",
                                };


                                $scope.configWifiData.connectNetBak.ssid = $scope.configWifiData.wifiName;
                                $scope.configWifiData.connectNetBak.bssid = "";
                                $scope.configWifiData.connectNetBak.isPassWord = 1;
                                $scope.configWifiData.connectNetBak.level = 1;

                                $scope.configWifiSev.connect_net(opt, $scope.configWifiData.wifiPass);

                                $scope.operateText = "";
                            } else {
                                window.fufuMessageBox('网络名称不能为空', fufu_message_box_duration, function () {});
                            }



                        }
                    },
                ]
            });

        };

        $scope.disconnect = function () {
            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }
            if ($ionicHistory.currentView().url != curView) {
                return console.log($ionicHistory.currentView().url);
            }

            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.backNotClosePop, 401
            );

            $scope.myPopup = $ionicPopup.confirm({
                title: '设备连接已断开',
                scope: $scope,
                buttons: [{
                        text: '返回',
                        type: 'button-light',
                        onTap: function () {
                            $rootScope.hideLoading();
                            bluetoothDeviceSev.perish();
                            $ionicHistory.goBack((-2 - configWifiSev.getBackStepNum()));
                            $scope.leaveHandle();

                            $timeout(function () {
                                $scope.configWifiData.cur_alleyway_state = null;
                            }, 0);
                        }
                    },
                    {
                        text: '退出',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.back2();
                            $timeout(function () {
                                $scope.configWifiData.cur_alleyway_state = null;
                            }, 0);
                        }
                    }
                ]
            });
        };



        $scope.goAttendanceDevice = function () {
            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }
            if (scanBluetoothStateSev.getState()) {
                attendanceDeviceSev.set_flag(true);
                attendanceDeviceSev.setOpenAttendanceDeviceMode(true);
                attendanceDeviceSev.setBackStepNum(configWifiSev.getBackStepNum());
                $scope.leaveHandle();
                $location.path('/home_page/home_default/new_attendance_device/' + _cur_sn_no + '/' + _cur_sn_no + '/0/0/1');
                //$location.path('/home_page/home_default/attendance_device/' + _cur_sn_no + '/' + _cur_sn_no+'/0');
            } else {
                $scope.back();
            }

        };


        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前

            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();

            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.back, 100
            );

            $scope.notTap = false;

            try {

                bluetooth.checkOneToOneConnect(function (msg) {
                    if (msg == 1) {
                        //清除蓝牙通讯
                        bluetoothDeviceSev.perish();

                        configWifiSev.connectBluetoothDevice($scope.disconnect, $scope.connectNetCallback);

                        configWifiSev.load_net_list().then($scope.loadNetListCallback);
                    } else {

                        if ($scope.myPopup) {
                            $scope.myPopup.close();
                            $scope.myPopup = null;
                        }
                        if ($ionicHistory.currentView().url != curView) {
                            return console.log($ionicHistory.currentView().url);
                        }

                        $scope.deregister();
                        $scope.deregister = $ionicPlatform.registerBackButtonAction(
                            $scope.backNotClosePop, 401
                        );

                        $scope.myPopup = $ionicPopup.confirm({
                            title: '设备连接已断开',
                            scope: $scope,
                            buttons: [{
                                    text: '返回',
                                    type: 'button-light',
                                    onTap: function () {
                                        bluetoothDeviceSev.perish();
                                        $ionicHistory.goBack((-2 - configWifiSev.getBackStepNum()));
                                        $scope.leaveHandle();
                                        $timeout(function () {
                                            $scope.configWifiData.cur_alleyway_state = null;
                                        }, 0);
                                    }
                                },
                                {
                                    text: '退出',
                                    type: 'button-light',
                                    type: 'button-positive',
                                    onTap: function (e) {
                                        $scope.back();
                                        $timeout(function () {
                                            $scope.configWifiData.cur_alleyway_state = null;
                                        }, 0);
                                    }
                                }
                            ]
                        });
                    }
                });
            } catch (e) {

            }




        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $headNotifySer.destroy();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);



            // if($scope.myPopup){
            //       $scope.myPopup.close();
            //       $scope.myPopup = null;
            // }
        });

        $scope.$on("$ionicView.afterLeave", function (event, data) {
            //离开之后
            $scope.ionicPopupCancel();
        });
    })

    .controller('holidayCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, holidaySev, $filter, holidaysTypeSev, $setstatusBar) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        // Search Start
        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;

            var entryList = [];
            $.extend(true, entryList, $scope.holidayData.list_data);

            $scope.searchObj.list = $filter('dataAndFilter')(entryList, 'zk_holiday_type_name,sub_bu_name', $scope.searchObj.str);

            $ionicScrollDelegate.$getByHandle('holidaySearchScroll').scrollTop(false);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-holiday-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function () {

            $scope.searchPopover.show();
            $ionicScrollDelegate.$getByHandle('holidaySearchScroll').scrollTop(false);

            return true;
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();

            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };

        // Search End

        $scope.deleteHoliday = function (item) {
            $ionicPopup.confirm({
                title: '是否确认删除',
                cancelText: '我再想想',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    holidaySev.delData(item);
                }
            });
        };
        $scope.load_flag = 0;
        $scope.openHolidayDetail = function (item) {
            $scope.searchPopover.hide();
            holidaysTypeSev.setSubBu(item.sub_business_unit_key);
            $location.path('/home_page/home_menulist/holidays_type/' + item.zk_holiday_type_id + '/1');
        }

        $scope.addHoliday = function () {

            $location.path('/home_page/home_menulist/add_holidays');
        }


        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);


            holidaySev.loadData().then(function () {
                $timeout(function () {
                    $scope.load_flag = 1;
                    $scope.holidayData = holidaySev.getData();
                }, 100);
            });

            $setstatusBar.black();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);
        });

    })
    .controller('addHolidayCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, addHolidaySev, sideSelect, holidaysTypeSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.save = function () {

            if (!$scope.addHolidayData.zk_holiday_type_name.length) {
                window.fufuMessageBox("节假日名称不能未空", fufu_message_box_duration, function () {});
                return;
            }

            if ($scope.addHolidayData.sub_bu_index == undefined) {
                window.fufuMessageBox("所属单位不能未空", fufu_message_box_duration, function () {});
                return;
            }

            addHolidaySev.saveData().then(function (hid) {
                holidaysTypeSev.setSubBu($scope.addHolidayData.sub_bu_key);
                $location.path('/home_page/home_menulist/holidays_type/' + hid + '/2');
            });
        }

        $scope.selectdw = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.addHolidayData.list_data,
                selectIndex: $scope.addHolidayData.sub_bu_index,
                selectedFunc: function (index) {
                    if (index == undefined) {

                    } else {
                        $scope.addHolidayData.sub_bu_key = $scope.addHolidayData.list_data[index].key;
                        $scope.addHolidayData.sub_bu_index = index;
                    }

                }
            });
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前


        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            var opt = {"colorStr" : "#ffffff"};
            	StatusBar.setStatusBarColor(opt);

            addHolidaySev.loadData().then(function () {
                $scope.addHolidayData = addHolidaySev.getData();
            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);

        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后
            $scope.addHolidayData.sub_bu_index = undefined;
            $scope.addHolidayData.zk_holiday_type_name = "";
        });

    })

    .controller('addHoliday2Ctrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, addHoliday2Sev, sideSelect, timeSelect) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.save = function () {
            if (!$scope.addHoliday2Data.holiday_name.length) {
                window.fufuMessageBox("假期名称不能为空", fufu_message_box_duration, function () {});
                return;
            }

            if (!$scope.addHoliday2Data.date_from.length ||
                !$scope.addHoliday2Data.date_to.length ||
                !$scope.addHoliday2Data.time_from.length ||
                !$scope.addHoliday2Data.time_to.length) {
                window.fufuMessageBox("假期时间不能为空", fufu_message_box_duration, function () {});
                return;
            }

            addHoliday2Sev.saveData($stateParams.hid);
        };

        $scope.local_resource = local_resource;


        $scope.selectTime = function (field) {

            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.addHoliday2Data[field] ? $scope.addHoliday2Data[field] : '00:00',
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                isCancel: true,
                selectedFunc: function (date) {

                    if (typeof (date) != 'undefined') {

                        $scope.addHoliday2Data[field] = date;

                    }
                }
            });
        }

        $scope.selectDate = function (field) {
            var defdata = '';
            var date = new Date();

            defdata += (date.getFullYear() + '-');
            if (date.getMonth() + 1 < 10) {
                defdata += ('0' + (date.getMonth() + 1) + '-');
            } else {
                defdata += ((date.getMonth() + 1) + '-');
            }

            defdata += date.getDate();

            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.addHoliday2Data[field] ? $scope.addHoliday2Data[field] : defdata,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.addHoliday2Data[field] = date;
                    }
                }
            })
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $scope.addHoliday2Data = addHoliday2Sev.getData();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);

        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后
            addHoliday2Sev.resetData();
        });

    })

    .controller('editHolidayNameCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, editHolidayNameSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.save = function () {
            if (!$scope.editHolidayNameData.zk_holiday_type_name.length) {
                window.fufuMessageBox("假期名称不能为空", fufu_message_box_duration, function () {});
                return;
            }

            editHolidayNameSev.saveData($stateParams.hid);
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

            $scope.editHolidayNameData = editHolidayNameSev.getData();

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后

        });

    })
    .controller('editHolidaysCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, editHolidaysSev, sideSelect, timeSelect) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.save = function () {
            if (!$scope.editHolidaysData.holiday_name.length) {
                window.fufuMessageBox("假期名称不能为空", fufu_message_box_duration, function () {});
                return;
            }

            if (!$scope.editHolidaysData.date_from.length ||
                !$scope.editHolidaysData.date_to.length ||
                !$scope.editHolidaysData.time_from.length ||
                !$scope.editHolidaysData.time_to.length) {
                window.fufuMessageBox("假期时间不能为空", fufu_message_box_duration, function () {});
                return;
            }

            editHolidaysSev.saveData($stateParams.hid);
        }

        $scope.selectTime = function (field) {

            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.editHolidaysData[field] ? $scope.editHolidaysData[field] : '00:00',
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                selectedFunc: function (date) {

                    if (typeof (date) != 'undefined') {

                        $scope.editHolidaysData[field] = date;

                    }
                }
            });
        }

        $scope.selectDate = function (field) {

            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.editHolidaysData[field] ? $scope.editHolidaysData[field] : '',
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.editHolidaysData[field] = date;
                    }
                }
            })
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);
            editHolidaysSev.loadData($stateParams.hid).then(function () {
                $scope.editHolidaysData = editHolidaysSev.getData();
            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后

        });

    })
    .controller('holidaysTypeCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, holidaysTypeSev, sideSelect, editHolidayNameSev) {

        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function (e) {
            if (e) {
                e.preventDefault();
            }

            if ($stateParams.opentype == "1") {
                $ionicHistory.goBack();
            } else if ($stateParams.opentype == "2") {
                $ionicHistory.goBack(-2);
            }

            $scope.leaveHandle();
        };

        $scope.PhysBack = function (e) {

            if (e) {
                e.preventDefault();
            }


            if ($stateParams.opentype == "1") {
                $ionicHistory.goBack();
            } else if ($stateParams.opentype == "2") {
                $ionicHistory.goBack(-2);
            }



            $scope.leaveHandle();


            return false;
        };

        $scope.local_resource = local_resource;

        $scope.selectdw = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.holidaysTypeData.bu_list,
                selectIndex: $scope.holidaysTypeData.sub_bu_index,
                selectedFunc: function (index) {
                    if (index == undefined) {

                    } else {
                        $scope.holidaysTypeData.sub_bu_key = $scope.holidaysTypeData.bu_list[index].key;
                        $scope.holidaysTypeData.sub_bu_index = index;

                        holidaysTypeSev.modifyData($stateParams.hid);
                    }

                }
            });
        }

        $scope.selectYear = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.holidaysTypeData.year_list,
                selectIndex: $scope.holidaysTypeData.year_list_index,
                selectedFunc: function (index) {
                    if (index == undefined) {

                    } else {
                        $scope.holidaysTypeData.year_list_key = $scope.holidaysTypeData.year_list[index].key;
                        $scope.holidaysTypeData.year_list_index = index;
                        holidaysTypeSev.getYearData($stateParams.hid);
                    }

                }
            });
        }

        $scope.editHolidayName = function () {

            editHolidayNameSev.setData($scope.holidaysTypeData.zk_holiday_type_name, $scope.holidaysTypeData.sub_bu_key);
            $location.path('/home_page/home_menulist/edit_holiday_name/' + $stateParams.hid);
        };

        $scope.addHoliday2 = function () {
            $location.path('/home_page/home_menulist/add_holiday2/' + $stateParams.hid);
        }

        $scope.editHoliday = function (item) {
            $location.path('/home_page/home_menulist/edit_holidays/' + item.holiday_details_id);
        }

        $scope.delHoliday = function (item) {
            $ionicPopup.confirm({
                title: '是否确认删除',
                cancelText: '我再想想',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    holidaysTypeSev.delItem(item);
                }
            });
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);
            holidaysTypeSev.loadData($stateParams.hid).then(function () {
                $scope.holidaysTypeData = holidaysTypeSev.getData();
            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
		
            sideSelect.close();
        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后

        });

    })

    .controller('openDoorTimeCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, openDoorTimeSev, $filter, editOpenDoorTimeSev, addOpenDoorTimeSev, $setstatusBar) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };


        // Search Start






        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;

            var entryList = [];
            $.extend(true, entryList, $scope.openDoorTimeData.list);

            $scope.searchObj.list = $filter('dataAndFilter')(entryList, 'sub_bu_name,time_division_name', $scope.searchObj.str);

            $ionicScrollDelegate.$getByHandle('openDoorTimeSearchScroll').scrollTop(false);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-open-door-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function () {

            $scope.searchPopover.show();
            $ionicScrollDelegate.$getByHandle('openDoorTimeSearchScroll').scrollTop(false);

            return true;
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();

            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };

        // Search End

        $scope.addOpenDoorTime = function () {
            $scope.searchPopover.hide();
            addOpenDoorTimeSev.resetData();
            $location.path('/home_page/home_menulist/add_open_door_time');
        }

        $scope.openEdit = function (item) {

            editOpenDoorTimeSev.setParam(item.time_division_id, item.bu, item.sub_bu);
            $location.path('/home_page/home_menulist/edit_open_door_time');
        }

        $scope.openEdit2 = function (item) {
            $scope.searchPopover.hide();
            editOpenDoorTimeSev.setParam(item.time_division_id, item.bu, item.sub_bu);
            $location.path('/home_page/home_menulist/edit_open_door_time');
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
		
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);

            openDoorTimeSev.loadData().then(function () {

                $scope.openDoorTimeData = openDoorTimeSev.getData();
            });

            $setstatusBar.black();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
		var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);
        });

    })
    .controller('addOpenDoorTimeCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, addOpenDoorTimeSev, timeSelect, sideSelect) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

	
        $scope.local_resource = local_resource;

        $scope.save = function () {
            if (!$scope.addOpenDoorTimeData.time_division_name) {
                window.fufuMessageBox('时间段名称不能为空', fufu_message_box_duration, function () {});
                return;
            }
            if ($scope.addOpenDoorTimeData.sub_bu_index == null || typeof ($scope.addOpenDoorTimeData.sub_bu_index) == 'undefined') {
                window.fufuMessageBox('所属单位不能为空', fufu_message_box_duration, function () {});
                return;
            }

            if (!$scope.addOpenDoorTimeData.mon_from || !$scope.addOpenDoorTimeData.mon_to ||
                !$scope.addOpenDoorTimeData.tue_from || !$scope.addOpenDoorTimeData.tue_to ||
                !$scope.addOpenDoorTimeData.wed_from || !$scope.addOpenDoorTimeData.wed_to ||
                !$scope.addOpenDoorTimeData.thu_from || !$scope.addOpenDoorTimeData.thu_to ||
                !$scope.addOpenDoorTimeData.fri_from || !$scope.addOpenDoorTimeData.fri_to ||
                !$scope.addOpenDoorTimeData.sat_from || !$scope.addOpenDoorTimeData.sat_to ||
                !$scope.addOpenDoorTimeData.sun_from || !$scope.addOpenDoorTimeData.sun_to) {
                window.fufuMessageBox('时间段不能为空', fufu_message_box_duration, function () {});
                return;
            }

            addOpenDoorTimeSev.saveData();
        };

        $scope.selectdw = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.addOpenDoorTimeData.sub_bu_list,
                selectIndex: $scope.addOpenDoorTimeData.sub_bu_index,
                selectedFunc: function (index) {
                    if (index == undefined) {

                    } else {
                        $scope.addOpenDoorTimeData.sub_bu_key = $scope.addOpenDoorTimeData.sub_bu_list[index].key;
                        $scope.addOpenDoorTimeData.sub_bu_index = index;
                    }

                }
            });
        }

        $scope.selectTime = function (field) {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.addOpenDoorTimeData[field] ? $scope.addOpenDoorTimeData[field] : '00:00',
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.addOpenDoorTimeData[field] = date;
                    }
                }
            });
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
		
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);

            addOpenDoorTimeSev.loadData().then(function () {
                $scope.addOpenDoorTimeData = addOpenDoorTimeSev.getData();
            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
		
        });

    })
    .controller('editOpenDoorTimeCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, editOpenDoorTimeSev, timeSelect, sideSelect) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.local_resource = local_resource;

        $scope.save = function () {
            editOpenDoorTimeSev.saveData();
        };

        $scope.del = function () {
            $ionicPopup.confirm({
                title: '确认删除?',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    editOpenDoorTimeSev.deleteData();
                }
            });

        }

        $scope.selectdw = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.editOpenDoorTimeData.sub_bu_list,
                selectIndex: $scope.editOpenDoorTimeData.sub_bu_index,
                selectedFunc: function (index) {
                    if (index == undefined) {

                    } else {
                        $scope.editOpenDoorTimeData.sub_bu_key = $scope.editOpenDoorTimeData.sub_bu_list[index].key;
                        $scope.editOpenDoorTimeData.sub_bu_index = index;
                    }

                }
            });
        }

        $scope.selectTime = function (field) {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.editOpenDoorTimeData[field] ? $scope.editOpenDoorTimeData[field] : '00:00',
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.editOpenDoorTimeData[field] = date;
                    }
                }
            });
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);
            editOpenDoorTimeSev.loadData().then(function () {
                $scope.editOpenDoorTimeData = editOpenDoorTimeSev.getData();
            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

    })

    .controller('aiDeviceCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, aiDeviceSev, searchDeviceSev, scanBluetoothStateSev, attendanceDeviceSev, $filter, attendanceNetStateSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };
		$scope.android_height = android_height;
        if (ionic.Platform.isIOS()) {
            $scope.content_top = '64px !important';
        } else {
            $scope.content_top = '44px !important';
        }
        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.SearchBack = function (e) {
            if (e) {
                e.preventDefault();
            }
            $scope.closeSearchPopover();
        }

        $scope.local_resource = local_resource;
        $scope.is_region = $stateParams.is_region;

        // Search Start


        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;

            // var entryList = [].concat(
            //     $scope.aiDeviceData.old_device,
            //     $scope.aiDeviceData.had_linked,
            //     $scope.aiDeviceData.not_had_linked);
            var entryList = [].concat($scope.aiDeviceData.had_linked);
            $scope.searchObj.list = $filter('dataAndFilter')(entryList, 'device_name,zone_name,device_sn', $scope.searchObj.str);

            $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').scrollTop(false);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-ai-device-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });

        $scope.doRefresh = function() {
            aiDeviceSev.loadData().then(function () {
                $timeout(function () {
                    $scope.aiDeviceData = aiDeviceSev.getData();
                    $scope.$broadcast('scroll.refreshComplete');
                    if($scope.searchObj.str){
                        $scope.search();
                    }
                }, 100);
            });
        };

        $scope.openSearchPopover = function () {

            $rootScope.removeEventGlobalBack();

            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.SearchBack, 401
            );

            $scope.searchPopover.show();
            $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').scrollTop(false);

            return true;
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();

            $scope.leaveHandle();
            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };



        // Search End
        $scope.adSearchIptFocus = function () {

            $timeout(function () {
                $("#aiSearchIpt").focus();
            }, 50);
            return true;
        };


        $scope.openList = function (ev) {
            var r_collapse_el = $(ev.target).parents('.r-collapse');
            if (!r_collapse_el.toggleClass("active").hasClass("active")) {
                r_collapse_el.find(".item-content").attr("style", "");
            }
        };

        $scope.openAttendanceConfig = function (item, isOld) {

            _cur_sn_no = item.device_sn;
            attendanceDeviceSev.resetData();
            try {
                autosignin.pauseSignIn();
            } catch (e) {

            }

            aiDeviceSev.setLyFlag(1);
            attendanceDeviceSev.set_flag(true);

            attendanceDeviceSev.setOpenAttendanceDeviceMode(false);

            if (item.isOld) {
                attendanceNetStateSev.setDeviceType(1);
            } else {
                attendanceNetStateSev.setDeviceType(0);
            }

            //if(item.sn_type=='5'){

            $ionicHistory.clearCache().then(function () {
                $location.path('/home_page/home_default/new_attendance_device/' + _cur_sn_no + '/' + item.device_name + '/' + item.zone_id + '/' + item.is_remote_open + "/" + item.device_function);
            });


            //}
            //else{
            //	$location.path('/home_page/home_default/attendance_device/' + _cur_sn_no + '/' + item.device_name+'/'+item.zone_id);	
            //}


        }

        $scope.addDevice = function () {
            // attendanceNetStateSev.setDeviceType(1);
            $location.path('/home_page/home_default/add_device');
            return 1;
        };

        $scope.haveDevice = function () {

            $location.path('/home_page/home_default/have_device_list/' + aiDeviceSev.retRegionId() + '/0');
            return 1;
        };


        $scope.unbundling = function (list, index, item, sflag) {

            $scope.myPopup = $ionicPopup.show({
                title: '确认解绑设备？',
                subTitle: '解绑后将找不回设备',
                scope: $scope,
                cssClass: 'popup-body-diy-title popup-body-diy2-title',
                buttons: [{
                        text: '取消',
                        type: 'button-light',
                        onTap: function (e) {

                        }
                    },
                    {
                        text: '确认',
                        type: 'button-positive',
                        onTap: function (e) {
                            $rootScope.showLoading();
                            var date = new Date();
                            var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
                            var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
                            var inputdate = date.getFullYear() + "-" + month + "-" + day;
                            if (item.zone_id == "" || item.zone_id == "null" || item.zone_id == "0") {
                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.deletesn',
                                    timeout: 300000,
                                    data: {
                                        add_data: 'sn:' + item.device_sn + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate,
                                        data: 'sn:' + item.device_sn + '\nstatus:0' + '\ninput_date: ',
                                        device_sn: item.device_sn
                                    },
                                    success: function (json) {
                                        $rootScope.hideLoading();
                                        var data = $.parseJSON(json);
                                        if (data.flag == '0') {
                                            //start ak delete device
                                            if (sflag) {
                                                window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {

                                                });
                                                $timeout(function () {
                                                    list.splice(index, 1);
                                                }, 0);

                                                for (var i = 0, len = $scope.aiDeviceData.not_had_linked.length; i < len; i++) {
                                                    if ($scope.aiDeviceData.not_had_linked[i].device_sn == item.device_sn) {
                                                        $timeout(function () {
                                                            $scope.aiDeviceData.not_had_linked.splice(i, 1);
                                                        }, 0);
                                                        break;
                                                    }
                                                }

                                                for (var i = 0, len = $scope.aiDeviceData.had_linked.length; i < len; i++) {
                                                    if ($scope.aiDeviceData.had_linked[i].device_sn == item.device_sn) {

                                                        $timeout(function () {
                                                            $scope.aiDeviceData.had_linked.splice(i, 1);
                                                        }, 0);
                                                        break;
                                                    }
                                                }

                                                for (var i = 0, len = $scope.aiDeviceData.old_device.length; i < len; i++) {
                                                    if ($scope.aiDeviceData.old_device[i].device_sn == item.device_sn) {

                                                        $timeout(function () {
                                                            $scope.aiDeviceData.old_device.splice(i, 1);
                                                        }, 0);
                                                        break;
                                                    }
                                                }

                                                $timeout(function () {
                                                    $ionicScrollDelegate.resize();

                                                    if ($ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top >= 79) {
                                                        $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top - 79, false);
                                                    }
                                                    if ($ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition() >= 79) {
                                                        $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition().top - 79, false);
                                                    }


                                                }, 0);
                                            } else {
                                                window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {

                                                });
                                                $timeout(function () {
                                                    list.splice(index, 1);
                                                }, 0);

                                                $timeout(function () {

                                                    $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').resize();
                                                    if ($ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top >= 79) {
                                                        $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top - 79, false);
                                                    }

                                                }, 0);
                                            }
                                            //end delete device 
                                        } else {
                                            $rootScope.hideLoading();
                                            window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                        }
                                    },
                                    error: function () {
                                        $rootScope.hideLoading();
                                        window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                    }
                                })
                            } else {
                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd',
                                    timeout: 300000,
                                    data: {
                                        sid: "cpe.att.person.deleteUserInfo",
                                        send_type: 3,
                                        sync_type: 3,
                                        zoneid: item.zone_id,
                                        sn: item.device_sn,
                                        device_sn_list: item.device_sn,
                                        zone_id: item.zone_id
                                    },
                                    success: function (json) {
                                        var data = $.parseJSON(json);
                                        if (angular.isDefined(data.flag) && data.flag == '1') {
                                            $.ajax({
                                                type: "POST",
                                                url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.deletesn',
                                                timeout: 300000,
                                                data: {
                                                    add_data: 'sn:' + item.device_sn + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate,
                                                    data: 'sn:' + item.device_sn + '\nstatus:0' + '\ninput_date: ',
                                                    device_sn: item.device_sn
                                                },
                                                success: function (json) {
                                                    $rootScope.hideLoading();
                                                    var data = $.parseJSON(json);
                                                    if (data.flag == '0') {
                                                        //start ak delete device
                                                        if (sflag) {
                                                            window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {

                                                            });
                                                            $timeout(function () {
                                                                list.splice(index, 1);
                                                            }, 0);

                                                            for (var i = 0, len = $scope.aiDeviceData.not_had_linked.length; i < len; i++) {
                                                                if ($scope.aiDeviceData.not_had_linked[i].device_sn == item.device_sn) {
                                                                    $timeout(function () {
                                                                        $scope.aiDeviceData.not_had_linked.splice(i, 1);
                                                                    }, 0);
                                                                    break;
                                                                }
                                                            }

                                                            for (var i = 0, len = $scope.aiDeviceData.had_linked.length; i < len; i++) {
                                                                if ($scope.aiDeviceData.had_linked[i].device_sn == item.device_sn) {

                                                                    $timeout(function () {
                                                                        $scope.aiDeviceData.had_linked.splice(i, 1);
                                                                    }, 0);
                                                                    break;
                                                                }
                                                            }

                                                            for (var i = 0, len = $scope.aiDeviceData.old_device.length; i < len; i++) {
                                                                if ($scope.aiDeviceData.old_device[i].device_sn == item.device_sn) {

                                                                    $timeout(function () {
                                                                        $scope.aiDeviceData.old_device.splice(i, 1);
                                                                    }, 0);
                                                                    break;
                                                                }
                                                            }

                                                            $timeout(function () {

                                                                $ionicScrollDelegate.resize();
                                                                if ($ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top >= 79) {
                                                                    $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top - 79, false);
                                                                }
                                                                if ($ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition().top >= 79) {
                                                                    $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceSearchScroll').getScrollPosition().top - 79, false);
                                                                }

                                                            }, 0);
                                                        } else {
                                                            window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {

                                                            });
                                                            $timeout(function () {
                                                                list.splice(index, 1);
                                                            }, 0);

                                                            $timeout(function () {

                                                                $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').resize();

                                                                if ($ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition() && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top && $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top >= 79) {
                                                                    $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').scrollTo(0, $ionicScrollDelegate.$getByHandle('aiDeviceMainScroll').getScrollPosition().top - 79, false);
                                                                }

                                                            }, 0);
                                                        }

                                                        //end delete device 
                                                    } else {
                                                        $rootScope.hideLoading();
                                                        window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                                    }
                                                },
                                                error: function () {
                                                    $rootScope.hideLoading();
                                                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                                }
                                            })
                                        } else {
                                            $rootScope.hideLoading();
                                            window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                        }

                                    },
                                    error: function () {
                                        $rootScope.hideLoading();
                                        window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                    }
                                })

                            }
                        }
                    },
                ]
            });

        };

        $scope.scan = function () {

            if (ionic.Platform.isIOS()) {


                barcodeScanner.scan(function (msg) {
					barcodeScanner.close();
                    if (msg) {
                        if (msg == urlList[0] || msg == urlList[1]) {
                            searchDeviceSev.setReset(true);
                            autosignin.pauseSignIn();
                            homemessageSev.setLyFlag(1);
                            scanBluetoothStateSev.setState(true);
                            searchDeviceSev.setResetNetState(false);
                            attendanceNetStateSev.setDeviceType(0);
                            $location.path('/home_page/home_default/search_device');
                        } else if (IsURL(msg)) {
							if(msg.indexOf("/UserServer/qrcode?action=bind&sn=")!=-1){
								if(localStorage._role_name!='ess'&&localStorage._role_name!='ESS'){
									aiDeviceSev.addScanCodeDevice(getQueryString(msg,"sn"));
								}else{
									$ionicPopup.alert({
										title: '提醒',
										template: '<div style="text-align: center;">对不起，您没有权限操作，请联系管理员</div>',
										okText: '确定'
									}).then(function () {
									});
								}
							}else{
								 var ref = cordova.InAppBrowser.open(msg, '_blank', 'location=yes');
							}
                        } else {
                            var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');

                        }
                    } else {
                        //扫描失败 或者是 取消
                        barcodeScanner.close();
                    }

                });
            } else {

                barcodeScanner.checkCameraPermission(function (msg) {

                    if (msg == 1) {

                        barcodeScanner.scan(function (msgs) {
							barcodeScanner.close();
                            if (msgs) {

                                if (msgs == urlList[0] || msgs == urlList[1]) {
                                    $timeout(function () {
                                        searchDeviceSev.setReset(true);
                                        autosignin.pauseSignIn();
                                        homemessageSev.setLyFlag(1);
                                        scanBluetoothStateSev.setState(true);
                                        searchDeviceSev.setResetNetState(false);
                                        attendanceNetStateSev.setDeviceType(0);
                                        $location.path('/home_page/home_default/search_device');

                                    }, 0);
                                } else if (IsURL(msgs)) {
									if(msgs.indexOf("/UserServer/qrcode?action=bind&sn=")!=-1){
										if(localStorage._role_name!='ess'&&localStorage._role_name!='ESS'){
											aiDeviceSev.addScanCodeDevice(getQueryString(msgs,"sn"));
										}else{
											$ionicPopup.alert({
												title: '提醒',
												template: '<div style="text-align: center;">对不起，您没有权限操作，请联系管理员</div>',
												okText: '确定'
											}).then(function () {
											});
										}
									}else{
										 var ref = cordova.InAppBrowser.open(msgs, '_blank', 'location=yes');
									}
									
                                } else {
                                    var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');
                                }

                            } else {
                                //扫描失败 或者是 取消
                                barcodeScanner.close();
                            }

                        });



                    } else {
                        console.log("相机权限失败");
                    }
                });
            }



            return 1;
        };

        $scope.findDevice = function () {

            searchDeviceSev.setReset(true);
            autosignin.pauseSignIn();
            scanBluetoothStateSev.setState(true);
            aiDeviceSev.setLyFlag(1);
            attendanceDeviceSev.setOpenAttendanceDeviceMode(true);
            searchDeviceSev.setResetNetState(false);
            $location.path('/home_page/home_default/search_device');
            return 1;
        };


        // .fromTemplateUrl() 方法
        $ionicPopover.fromTemplateUrl('my-func-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.popover = popover;
        });


        $scope.showFuncPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };
        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.popover.remove();
            $scope.searchPopover.remove();
        });
        // 在隐藏浮动框后执行
        $scope.$on('popover.hidden', function () {
            // 执行代码
        });
        // 移除浮动框后执行
        $scope.$on('popover.removed', function () {
            // 执行代码
        });

        $scope.scrollTop = function () {
            $ionicScrollDelegate.scrollTop();
            return 1;
        };

        $scope.hideItemUnbind = function () {
            $('.item-content[style="transform: translate3d(-75px, 0px, 0px);"]').attr("style", "");
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
		var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);

            $scope.lyFlag = aiDeviceSev.retLyFlag();

            if ($scope.lyFlag.state == 1) {
                try {
                    autosignin.reopenSignIn();
                } catch (e) {

                }

                aiDeviceSev.setLyFlag(0);
            }

            $setstatusBar.black();

            aiDeviceSev.loadData().then(function () {

                $scope.aiDeviceData = aiDeviceSev.getData();

            });

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
var opt = {"colorStr" : "#53afff"};
	StatusBar.setStatusBarColor(opt);
        });

    })


    .controller('deviceListCtrl', function ($http, $stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, deviceListSev, addRegionSev, attendanceDeviceSev, searchDeviceSev, attendanceNetStateSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };
        $scope.local_resource = local_resource;

        // Search Start


        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;


            $scope.searchObj.list = $filter('dataAndFilter')($scope.deviceListData.device_list, 'device_name,zone_name,device_sn', $scope.searchObj.str);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-device-list-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function () {
            $scope.searchPopover.show();

            return 1;
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();
            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };



        // Search End

        $scope.selectOption = function (item) {
            if (item.checked) {
                $scope.deviceListData.select_device_num += 1;
            } else {
                $scope.deviceListData.select_device_num -= 1;
            }
        };


        $scope.addDevice = function () {
            $scope.closePopover();

            $location.path('/home_page/home_default/add_device');
        };


        $scope.scan = function () {
            $scope.closePopover();

            if (ionic.Platform.isIOS()) {


                barcodeScanner.scan(function (msg) {
barcodeScanner.close();
                    if (msg) {

                        if (msg == urlList[0] || msg == urlList[1]) {
                            $timeout(function () {

                                searchDeviceSev.setReset(true);
                                autosignin.pauseSignIn();
                                scanBluetoothStateSev.setState(true);
                                aiDeviceSev.setLyFlag(1);
                                searchDeviceSev.setResetNetState(false);
                                attendanceNetStateSev.setDeviceType(0);
                                $location.path('/home_page/home_default/search_device');
                            }, 0);
                        } else if (IsURL(msg)) {

                            var ref = cordova.InAppBrowser.open(msg, '_blank', 'location=yes');
                            
                        } else {
                            var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');
                        }
                    } else {
                        //扫描失败 或者是 取消
                        barcodeScanner.close();
                    }

                });
            } else {

                barcodeScanner.checkCameraPermission(function (msg) {

                    if (msg == 1) {

                        barcodeScanner.scan(function (msgs) {
barcodeScanner.close();
                            if (msgs) {


                                if (msgs == urlList[0] || msgs == urlList[1]) {
                                    $timeout(function () {
                                        searchDeviceSev.setReset(true);
                                        autosignin.pauseSignIn();
                                        scanBluetoothStateSev.setState(true);
                                        aiDeviceSev.setLyFlag(1);
                                        searchDeviceSev.setResetNetState(false);
                                        attendanceNetStateSev.setDeviceType(0);
                                        $location.path('/home_page/home_default/search_device');

                                    }, 0);
                                } else if (IsURL(msgs)) {

                                    var ref = cordova.InAppBrowser.open(msgs, '_blank', 'location=yes');
                                } else {
                                    var ref = cordova.InAppBrowser.open(gwUrl, '_blank', 'location=yes');
                                    
                                }
                            } else {
                                //扫描失败 或者是 取消
                                barcodeScanner.close();
                            }

                        });



                    } else {
                        console.log("相机权限失败");
                    }
                });
            }



            return 1;
        };


        $scope.openAttendanceConfig = function (item) {
            _cur_sn_no = item.device_sn;
            try {
                autosignin.pauseSignIn();
            } catch (e) {

            }

            // aiDeviceSev.setLyFlag(1);
            attendanceDeviceSev.set_flag(true);

            attendanceDeviceSev.setOpenAttendanceDeviceMode(false);
            attendanceDeviceSev.setBackStepNum(0);
            $location.path('/home_page/home_default/new_attendance_device/' + _cur_sn_no + '/' + _cur_sn_no + '/0/0/1');

        }

        $scope.findDevice = function () {
            $scope.closePopover();

            searchDeviceSev.setReset(true);
            autosignin.pauseSignIn();
            scanBluetoothStateSev.setState(true);
            aiDeviceSev.setLyFlag(1);
            searchDeviceSev.setResetNetState(false);
            attendanceNetStateSev.setDeviceType(0);
            $location.path('/home_page/home_default/search_device');
            return 1;
        };

        $scope.cancel = function () {
            $scope.back();
        };


        $scope.select = function () {
            var zone_id = '';
            var sn_list = '';
            for (var i = 0; i < $scope.deviceListData.length; i++) {
                if ($scope.deviceListData[i].checked) {
                    zone_id = $scope.deviceListData[i].zone_id;
                    sn_list = sn_list + $scope.deviceListData[i].device_sn;
                }
            }
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $rootScope.showLoading();
            $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                timeout: _var_timeout,
                params: {
                    sid: "cpe.att.person.upload",
                    send_type: "3",
                    zoneid: zone_id,
                    sn: sn_list.substring(0, sn_list.length - 1),
                    device_sn_list: sn_list.substring(0, sn_list.length - 1),
                    zone_id: zone_id,
                    sync_type: 3
                }
            }).
            success(function (data, status, headers, config) {
                $rootScope.hideLoading();
                if (angular.isDefined(data.flag)) {
                    window.fufuMessageBox(data.message, fufu_message_box_duration, function () {
                        addRegionSev.config(
                            null,
                            null,
                            $scope.deviceListData.select_device_num,
                            null
                        );
                        $scope.back();
                    });
                } else {
                    window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
                }
            }).
            error(function (data, status, headers, config) {
                $rootScope.hideLoading();
                window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
            });
        };

        // .fromTemplateUrl() 方法
        $ionicPopover.fromTemplateUrl('my-func-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.popover = popover;
        });


        $scope.showFuncPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };

        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.popover.remove();
            $scope.searchPopover.remove();
        });

        $scope.scrollTop = function () {
            $ionicScrollDelegate.scrollTop();
            return 1;
        };

        $scope.hideItemUnbind = function () {
            $('.item-content[style="transform: translate3d(-75px, 0px, 0px);"]').attr("style", "");
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $setstatusBar.black();
            deviceListSev.loadData().then(function () {

                $scope.deviceListData = deviceListSev.getData();

            });

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })


    .controller('haveDeviceListCtrl', function ($http, $stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, haveDeviceListSev, addRegionSev, attendanceDeviceSev, searchDeviceSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
            $timeout(function () {
                $scope.haveDeviceListData.select_device_num = 0;
            }, 400);
        };
        $scope.local_resource = local_resource;

        // Search Start

        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;


            $scope.searchObj.list = $filter('dataAndFilter')($scope.haveDeviceListData.device_list, 'device_name,zone_name,device_sn', $scope.searchObj.str);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-device-list-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function () {
            $scope.searchPopover.show();

            return 1;
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();
            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };



        // Search End

        $scope.selectOption = function (item) {
            if (item.checked) {
                $scope.haveDeviceListData.select_device_num += 1;
            } else {
                $scope.haveDeviceListData.select_device_num -= 1;
            }
        };


        $scope.openAttendanceConfig = function (item) {
            _cur_sn_no = item.device_sn;
            try {
                autosignin.pauseSignIn();
            } catch (e) {

            }

            // aiDeviceSev.setLyFlag(1);
            attendanceDeviceSev.set_flag(true);

            attendanceDeviceSev.setOpenAttendanceDeviceMode(false);

            attendanceDeviceSev.setBackStepNum(0);

            $location.path('/home_page/home_default/new_attendance_device/' + _cur_sn_no + '/' + _cur_sn_no + '/0/0/1');

        }



        $scope.cancel = function () {
            $scope.back();
        };


        $scope.select = function () {
            var zone_id = $stateParams.z_id;
            var sn_list = '';
            console.log(zone_id);

            for (var i = 0; i < $scope.haveDeviceListData.device_list.length; i++) {
                if ($scope.haveDeviceListData.device_list[i].checked) {
                    // zone_id = $scope.haveDeviceListData[i].zone_id;
                    sn_list = sn_list + $scope.haveDeviceListData.device_list[i].device_sn + ',';
                }
            }

            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $rootScope.showLoading();
            $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                timeout: _var_timeout,
                params: {
                    sid: "cpe.att.person.upload",
                    send_type: "3",
                    zoneid: zone_id,
                    sn: sn_list.substring(0, sn_list.length - 1),
                    device_sn_list: sn_list.substring(0, sn_list.length - 1),
                    zone_id: zone_id,
                    sync_type: 3
                }
            }).
            success(function (data, status, headers, config) {
                $rootScope.hideLoading();
                if (angular.isDefined(data.flag)) {
                    window.fufuMessageBox(data.message, fufu_message_box_duration, function () {
                        addRegionSev.config(
                            null,
                            null,
                            $scope.haveDeviceListData.select_device_num,
                            null
                        );
                        $scope.back();
                    });
                } else {
                    window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
                }
            }).
            error(function (data, status, headers, config) {
                $rootScope.hideLoading();
                window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
            });
        };

        // .fromTemplateUrl() 方法
        $ionicPopover.fromTemplateUrl('my-func-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.popover = popover;
        });


        $scope.showFuncPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };

        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.popover.remove();
            $scope.searchPopover.remove();
        });

        $scope.scrollTop = function () {
            $ionicScrollDelegate.scrollTop();
            return 1;
        };

        $scope.hideItemUnbind = function () {
            $('.item-content[style="transform: translate3d(-75px, 0px, 0px);"]').attr("style", "");
        }

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $setstatusBar.black();
            haveDeviceListSev.loadData().then(function () {

                $scope.haveDeviceListData = haveDeviceListSev.getData();

            });

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })

    .controller('addDeviceCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, addDeviceSev, sideSelect) {

        $scope.back = function () {
            $ionicHistory.goBack();
            $timeout(function () {
                $scope.addDeviceData.device_name = "";
                $scope.addDeviceData.device_sn = "";
                $scope.addDeviceData.sub_bu_json_index = null;
            }, 200);
        };
        $scope.local_resource = local_resource;
        $scope.notDataStyle = {
            "color": "#cccccc"
        };

        $scope.theUnit = function () {
            if ($scope.addDeviceData.sub_bu_json && $scope.addDeviceData.sub_bu_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.addDeviceData.sub_bu_json,
                    selectIndex: $scope.addDeviceData.sub_bu_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if ($scope.addDeviceData.sub_bu_json_index) {
                                $scope.addDeviceData.sub_bu_json[$scope.addDeviceData.sub_bu_json_index].check = false;
                            }

                            $scope.addDeviceData.sub_bu_json[index].check = true;
                            $scope.addDeviceData.sub_bu_json_index = index;

                        }
                    }
                });
            }
        };

        $scope.save = function () {

            if ($scope.addDeviceData.device_name && $scope.addDeviceData.device_sn && $scope.addDeviceData.sub_bu_json_index != null) {
                addDeviceSev.saveData($scope.addDeviceData).then(function () {
                    $scope.back();
                });
            } else {
                window.fufuMessageBox("请填写设备名称、设备序列号、所属单位", fufu_message_box_duration, function () {});
            }


        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $rootScope.hideLoading();
var opt = {"colorStr" : "#ffffff"};
	StatusBar.setStatusBarColor(opt);
            addDeviceSev.loadData().then(function () {
                $scope.addDeviceData = addDeviceSev.getData();
            });

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })

    .controller('regionListCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, regionListSev, addRegionSev, editRegionSev, aiDeviceSev, attendanceMemberSev, $setstatusBar) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };


        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.SearchBack = function (e) {
            if (e) {
                e.preventDefault();
            }

            $scope.closeSearchPopover();

        }

        $scope.adSearchIptFocus = function () {
            $timeout(function () {
                $("#arSearchIpt").focus();
            }, 50);
            return true;
        };

        $scope.addRegion = function () {
            addRegionSev.clearData();
            addRegionSev.setSubBuJson($scope.regionListData.sub_bu_json, null);
            $location.path('/home_page/home_default/add_region');

            return 1;
        };

        $scope.editRegion = function (ritem) {
            editRegionSev.setState(0); //编辑区域
            editRegionSev.setOpenState(0);
            addRegionSev.clearData();

            addRegionSev.setSubBuJson($scope.regionListData.sub_bu_json, ritem.sub_units_key);
            addRegionSev.config(ritem.zone_id, ritem.region_name, ritem.device_num, ritem.staff_num);
            $location.path('/home_page/home_default/edit_region');

            return 1;
        };

        $scope.openAiDevice = function (region_item) {
            //区域id region_item.nid
            aiDeviceSev.setRegionId(region_item.zone_id);
            $location.path('home_page/home_menulist/ai_device/1');

            return 1;

        };

        $scope.openAttendanceMember = function (region_item) {

            attendanceMemberSev.setRegionId(region_item.zone_id);
            $location.path('home_page/home_default/attendance_member');

            return 1;

        };

        $scope.local_resource = local_resource;

        // Search Start

        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchObj.str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
            }
        });

        $scope.search = function () {
            $rootScope.showLoading();
            $scope.searchObj.state = true;


            $scope.searchObj.list = $filter('dataAndFilter')($scope.regionListData.region_list, 'region_name,sub_units_name', $scope.searchObj.str);

            $ionicScrollDelegate.$getByHandle('regionListSearchScroll').scrollTop(false);
            $rootScope.hideLoading();
        };

        $ionicPopover.fromTemplateUrl('search-region-list-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function () {
            $scope.searchPopover.show();

            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.SearchBack, 401
            );

            $ionicScrollDelegate.$getByHandle('regionListSearchScroll').scrollTop(false);
        };
        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();

            $scope.leaveHandle();

            $timeout(function () {
                $scope.searchObj.str = "";
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };


        // Search End


        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.searchPopover.remove();
        });
        // 在隐藏浮动框后执行
        $scope.$on('popover.hidden', function () {
            // 执行代码
        });
        // 移除浮动框后执行
        $scope.$on('popover.removed', function () {
            // 执行代码
        });

        $scope.scrollTop = function () {
            $ionicScrollDelegate.scrollTop();
            return 1;
        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

            $setstatusBar.black();
            $rootScope.hideLoading();


            regionListSev.loadData().then(function () {
                $scope.regionListData = regionListSev.getData();

            });
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

    })
    .controller('editRegionCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, addRegionSev, editRegionSev, sideSelect, deviceListSev, $emplComponentService, regionNameSev) {
        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function () {

            if ($scope.editRegionData.edit_state) {
                $ionicHistory.goBack(-2);
            } else {
                $ionicHistory.goBack();
            }

            $scope.leaveHandle();
        };

        $scope.PhysBack = function () {
            if (fufu_show_loading_counter != 0) {
                return;
            }

            if (sideSelect.isOpen()) {
                sideSelect.close();
                return;
            }

            if ($scope.editRegionData.edit_state) {
                $ionicHistory.goBack(-2);
            } else {
                $ionicHistory.goBack();

            }

            $scope.leaveHandle();
        }


        $scope.selectStaff = function () {
            $emplComponentService.open({
                title: '选择员工', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: false, //是否展示常用联系人
                isNeedSaveContact: false, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: $scope.editRegionData.empl_list, //打开窗口默认选中员工列表
                params: { //支持可用扩展参数
                    "is_permissions": "1",
                    "is_process": "0",
                    "process_instance": '0',
                    "ext_param": ""
                },
                sure: function (rd) { //返回数据，数组格式
                    if (rd.length > 0) {
                        var empl_list = '';
                        for (var i = 0; i < rd.length; i++) {
                            empl_list = empl_list + rd[i].empl_no + ',';
                        }
                        $rootScope.showLoading();
                        $.ajax({
                            type: "POST",
                            url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd',
                            timeout: 300000,
                            data: {
                                sid: "cpe.att.person.upload",
                                send_type: 3,
                                sync_type: 2,
                                zoneid: $scope.addRegionData.region_id,
                                employee_list: empl_list.substring(0, empl_list.length - 1),
                                zone_id: $scope.addRegionData.region_id,
                                _user_name: window.localStorage['_user_name'],
                                _pass_word: window.localStorage['_pass_word'],
                                _is_login: window.localStorage['_is_login'],
                                _notification_token: window.localStorage['_notification_token'],
                                _device_type: window.localStorage['_device_type']
                            },
                            success: function (json) {
                                $rootScope.hideLoading();
                                var _data = $.parseJSON(json);
                                if (angular.isDefined(_data.flag) && _data.flag == "1") {
                                    $scope.addRegionData.staff_num = rd.length;
                                } else {
                                    window.fufuMessageBox("添加区域员工失败", fufu_message_box_duration, function () {});
                                }
                            },
                            error: function () {
                                $rootScope.hideLoading();
                                window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                            }
                        })
                    }
                }
            });
        };


        $scope.del = function () {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否删除该区域',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light'
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $rootScope.showLoading();
                            $scope.myPopup.close();

                            var _str = '';
                            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
                            }
                            $.ajax({
                                type: 'POST',
                                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.deleteZkRegion&' + _str,
                                timeout: _var_timeout,
                                data: {
                                    zone_id: $scope.addRegionData.region_id
                                },
                                success: function (data, status, headers, config) {
                                    $rootScope.hideLoading();
                                    var _data = $.parseJSON(data);
                                    if (_data.flag == 0) {
                                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {
                                            $scope.back();
                                        });
                                    } else {
                                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
                                    }
                                },
                                error: function (data, status, headers, config) {
                                    $rootScope.hideLoading();
                                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                }
                            });
                        }
                    }
                ]
            });
        };

        $scope.notDataStyle = {
            "color": "#cccccc"
        };


        $scope.theUnit = function () {
            if ($scope.addRegionData.sub_bu_json && $scope.addRegionData.sub_bu_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.addRegionData.sub_bu_json,
                    selectIndex: $scope.addRegionData.sub_bu_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if ($scope.addRegionData.sub_bu_json_index) {
                                $scope.addRegionData.sub_bu_json[$scope.addRegionData.sub_bu_json_index].check = false;
                            }
                            $scope.addRegionData.sub_bu_json[index].check = true;
                            $scope.addRegionData.sub_bu_json_index = index;
                            $rootScope.showLoading();
                            var _str = '';
                            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
                            }
                            $.ajax({
                                type: 'POST',
                                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveDevZoneName&' + _str,
                                timeout: _var_timeout,
                                data: {
                                    zone_id: $scope.addRegionData.region_id,
                                    select_sub_bu: $scope.addRegionData.sub_bu_json[$scope.addRegionData.sub_bu_json_index].key,
                                    zone_name: $scope.addRegionData.region_name
                                },
                                success: function (data, status, headers, config) {
                                    $rootScope.hideLoading();
                                    var _data = $.parseJSON(data);
                                    window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
                                },
                                error: function (data, status, headers, config) {
                                    $rootScope.hideLoading();
                                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                }
                            });
                        }
                    }
                });
            }
        }


        $scope.selectDevice = function () {
            deviceListSev.setRegionConfig(
                $scope.addRegionData.region_id,
                $scope.addRegionData.region_name,
                $scope.addRegionData.device_num);
            $scope.leaveHandle();
            $location.path('/home_page/home_default/device_list');
        };

        $scope.openRegionName = function () {
            var region_key = '0';
            if ($scope.addRegionData.sub_bu_json_index) {
                region_key = $scope.addRegionData.sub_bu_json[$scope.addRegionData.sub_bu_json_index].key;
            }

            regionNameSev.setRegionNameKey(region_key);
            $scope.leaveHandle();
            $location.path('/home_page/home_default/region_name/' + $scope.addRegionData.region_id + '/0');
        };


        $scope.local_resource = local_resource;

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );

            if (!editRegionSev.getOpenState()) {
                $scope.addRegionData = addRegionSev.getData();

                editRegionSev.loadData($scope.addRegionData.region_id).then(function () {
                    $scope.editRegionData = editRegionSev.getData();

                });

                editRegionSev.setOpenState(1);
            } else {
                $scope.addRegionData = addRegionSev.getData();
                $scope.editRegionData = editRegionSev.getData();
            }




        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);

        });

    })


    .controller('setConfigNetCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, setConfigNetSev, configIpAddressSev, bluetoothDeviceSev, configWifiSev) {
        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function () {

            bluetoothDeviceSev.perish();
            $ionicHistory.goBack(-3);
            //断开设备通讯
            bluetooth.cancelBleConfig();

            $scope.leaveHandle();
        };

        $scope.backNotClosePop = function () {

        };

        $scope.PhysBack = function () {
            if (fufu_show_loading_counter != 0) {
                return;
            }
            bluetoothDeviceSev.perish();
            $ionicHistory.goBack(-3);
            //断开设备通讯
            bluetooth.cancelBleConfig();

            $scope.leaveHandle();
        };
        var curView = "/home_page/home_default/set_config_net";

        $scope.nextStep = function () {
            $scope.leaveHandle();
            if ($scope.setConfigNetData.isWlanNet) {
                $location.path('/home_page/home_default/config_ip_address');
            } else {
                configWifiSev.setBackStepNum(1);
                $location.path('/home_page/home_default/config_wifi');
            }
        };



        $scope.disconnect = function () {
            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }
            if ($ionicHistory.currentView().url != curView) {
                return console.log($ionicHistory.currentView().url);
            }
            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.backNotClosePop, 401
            );
            $scope.myPopup = $ionicPopup.confirm({
                title: '设备连接已断开',
                scope: $scope,
                buttons: [{
                        text: '返回',
                        type: 'button-light',
                        onTap: function () {
                            bluetoothDeviceSev.perish();
                            $ionicHistory.goBack(-2);
                            $scope.leaveHandle();
                        }
                    },
                    {
                        text: '退出',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.back();
                        }
                    }
                ]
            });
        };


        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );

            $scope.setConfigNetData = setConfigNetSev.getData();

            try {

                bluetooth.checkOneToOneConnect(function (msg) {
                    if (msg == 1) {
                        //清除蓝牙通讯
                        bluetoothDeviceSev.perish();

                        setConfigNetSev.connectBluetoothDevice($scope.disconnect);


                    } else {

                        $scope.disconnect();
                    }
                });
            } catch (e) {

            }
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);

        });

    })

    .controller('configIpAddressCtrl', function ($stateParams,
        $scope,
        $rootScope,
        $location,
        $ionicHistory,
        $ionicPopup,
        $ionicPlatform,
        $timeout,
        $ionicScrollDelegate,
        $setstatusBar,
        $ionicPopover,
        configIpAddressSev,
        bluetoothDeviceSev,
        $headNotifySer,
        searchDeviceSev,
        attendanceDeviceSettingSev,
        scanBluetoothStateSev,
        attendanceDeviceSev) {
        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function () {

            $ionicHistory.goBack();
            // bluetoothDeviceSev.perish();

            $scope.leaveHandle();
        };

        $scope.backNotClosePop = function () {

        };

        $scope.PhysBack = function () {
            if (fufu_show_loading_counter != 0) {
                return;
            }
            $ionicHistory.goBack();
            // bluetoothDeviceSev.perish();

            $scope.leaveHandle();
        };

        function isValidIP(ip) {
            var reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/
            return reg.test(ip);
        }

        var curView = "/home_page/home_default/config_ip_address";


        $scope.disconnect = function () {
            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }
            if ($ionicHistory.currentView().url != curView) {
                return console.log($ionicHistory.currentView().url);
            }

            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.backNotClosePop, 401
            );

            $scope.myPopup = $ionicPopup.confirm({
                title: '设备连接已断开',
                scope: $scope,
                buttons: [{
                        text: '返回',
                        type: 'button-light',
                        onTap: function () {
                            bluetoothDeviceSev.perish();
                            $ionicHistory.goBack(-3);
                            $scope.leaveHandle();
                            //断开设备通讯
                            bluetooth.cancelBleConfig();
                        }
                    },
                    {
                        text: '退出',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            bluetoothDeviceSev.perish();
                            $ionicHistory.goBack(-4);
                            $scope.leaveHandle();
                            //断开设备通讯
                            bluetooth.cancelBleConfig();
                        }
                    }
                ]
            });
        };


        $scope.goAttendanceDevice = function () {

            if ($scope.myPopup) {
                $scope.myPopup.close();
                $scope.myPopup = null;
            }

            if (scanBluetoothStateSev.getState()) {
                attendanceDeviceSev.set_flag(true);
                attendanceDeviceSev.setOpenAttendanceDeviceMode(true);
                attendanceDeviceSev.setBackStepNum(1);
                $scope.leaveHandle();
                $location.path('/home_page/home_default/new_attendance_device/' + _cur_sn_no + '/' + _cur_sn_no + '/0/0/1');
            } else {
                bluetoothDeviceSev.perish();
                $ionicHistory.goBack(-4);
                $scope.leaveHandle();
                //断开设备通讯
                bluetooth.cancelBleConfig();
            }

        };


        $scope.connectNetCallback = function (state) {

            switch (state) {
                case 0:
                    $timeout(function () {
                        $headNotifySer.notify("success", "设备成功连上网络啦", 2000);
                    }, 0);

                    $timeout(function () {

                        if (searchDeviceSev.getResetNetState()) {

                            var device_data = attendanceDeviceSettingSev.getData();
                            attendanceDeviceSettingSev.loadData(device_data.device_sn, device_data.device_name).then(function () {
                                if ($scope.myPopup) {
                                    $scope.myPopup.close();
                                    $scope.myPopup = null;
                                }
                                if ($ionicHistory.currentView().url != curView) {
                                    return console.log($ionicHistory.currentView().url);
                                }
                                $timeout(function () {
                                    $ionicHistory.goBack(-4);
                                    bluetooth.cancelBleConfig();
                                    $scope.leaveHandle();
                                }, 0);

                            });
                        } else {
                            try {

                                //
                                var date = new Date();
                                var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
                                var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
                                var inputdate = date.getFullYear() + "-" + month + "-" + day;

                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.addsn",
                                    timeout: 300000,
                                    data: {
                                        update_data: 'sn:' + _cur_sn_no + '\n' + 'id:' + '\n' + 'status:0' + '\n' + 'input_date:',
                                        data: 'sn:' + _cur_sn_no + '\n' + 'status:1' + '\n ' + 'input_date: ' + inputdate,
                                        device_sn: _cur_sn_no,
                                        device_name: _cur_sn_no,
                                        _is_new: 1
                                    },
                                    success: function (json) {

                                        var data = $.parseJSON(json);
                                        if (angular.isDefined(data.flag) && data.flag == '0') {



                                            $timeout(function () {
                                                if ($ionicHistory.currentView().url != curView) {
                                                    return console.log($ionicHistory.currentView().url);
                                                }
                                                $headNotifySer.notify("continue", "正在配置考勤机...");
                                            }, 0);
                                        } else {
                                            if ($scope.myPopup) {
                                                $scope.myPopup.close();
                                                $scope.myPopup = null;
                                            }
                                            if ($ionicHistory.currentView().url != curView) {
                                                return console.log($ionicHistory.currentView().url);
                                            }

                                            $scope.deregister();
                                            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                                                $scope.backNotClosePop, 401
                                            );

                                            $scope.myPopup = $ionicPopup.show({
                                                template: '<div style="text-align: center;">' + data.message + '</div>',
                                                title: '提示',
                                                scope: $scope,
                                                buttons: [{
                                                    text: '<b>确定</b>',
                                                    type: 'button-positive',
                                                    onTap: function (e) {
                                                        bluetoothDeviceSev.perish();
                                                        $ionicHistory.goBack(-4);
                                                        $scope.leaveHandle();
                                                        //断开设备通讯
                                                        bluetooth.cancelBleConfig();
                                                    }
                                                }]
                                            });
                                        }

                                    },
                                    error: function () {
                                        if ($scope.myPopup) {
                                            $scope.myPopup.close();
                                            $scope.myPopup = null;
                                        }

                                        if ($ionicHistory.currentView().url != curView) {
                                            return console.log($ionicHistory.currentView().url);
                                        }

                                        $scope.deregister();
                                        $scope.deregister = $ionicPlatform.registerBackButtonAction(
                                            $scope.backNotClosePop, 401
                                        );

                                        $scope.myPopup = $ionicPopup.show({
                                            template: '<div style="text-align: center;">' + data.message + '</div>',
                                            title: '提示',
                                            scope: $scope,
                                            buttons: [{
                                                text: '<b>确定</b>',
                                                type: 'button-positive',
                                                onTap: function (e) {
                                                    bluetoothDeviceSev.perish();
                                                    $ionicHistory.goBack(-4);
                                                    $scope.leaveHandle();
                                                    //断开设备通讯
                                                    bluetooth.cancelBleConfig();
                                                }
                                            }]
                                        });
                                    }
                                })
                                //
                            } catch (e) {
                                //alert(e);
                            }
                        }



                    }, 2000);
                    break;

                case 1:

                    $rootScope.hideLoading();

                    $timeout(function () {
                        $headNotifySer.notify("error", "网络连接失败", 2000);
                    }, 0);

                    break;

                case 4:

                    // 蓝牙设备绑定成功

                    $rootScope.hideLoading();
                    bluetoothDeviceSev.perish();
                    if ($ionicHistory.currentView().url != curView) {
                        return console.log($ionicHistory.currentView().url);
                    }
                    $scope.goAttendanceDevice();
                    break;

                case 5:
                    // 蓝牙设备绑定失败(或绑定超时)
                    if ($scope.myPopup) {
                        $scope.myPopup.close();
                        $scope.myPopup = null;
                    }
                    try {


                        $timeout(function () {
                            $headNotifySer.notify("error", "考勤机配置失败", 2000);
                        }, 0);
                        $headNotifySer.destroy();

                        $timeout(function () {
                            $rootScope.hideLoading();
                            bluetoothDeviceSev.perish();
                            $ionicHistory.goBack(-4);
                            $scope.leaveHandle();
                            //断开设备通讯
                            bluetooth.cancelBleConfig();
                        }, 2000);

                    } catch (e) {
                        alert(e);
                    }

                    break;
                default:
                    // alert("没有出现的状态："+state);
            }


        }

        $scope.save = function () {


            if (!$scope.configIpAddressData.DHCP) {

                if (!isValidIP($scope.configIpAddressData.IP)) {
                    return window.fufuMessageBox("请输入正确的IP地址", fufu_message_box_duration, function () {});
                }

                if (!isValidIP($scope.configIpAddressData.MASK)) {
                    return window.fufuMessageBox("请输入正确的子网掩码", fufu_message_box_duration, function () {});
                }

                if (!isValidIP($scope.configIpAddressData.GW)) {
                    return window.fufuMessageBox("请输入正确的默认网关", fufu_message_box_duration, function () {});
                }

                if (!isValidIP($scope.configIpAddressData.DNS)) {
                    return window.fufuMessageBox("请输入正确的DNS服务器", fufu_message_box_duration, function () {});
                }

            }


            configIpAddressSev.configNet();
        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );
            $scope.configIpAddressData = configIpAddressSev.getData();


            try {

                //清除蓝牙通讯
                bluetoothDeviceSev.perish();

                configIpAddressSev.connectBluetoothDevice($scope.disconnect, $scope.connectNetCallback);
            } catch (e) {

            }
        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);

        });

    })

    .controller('addRegionCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, addRegionSev, sideSelect, editRegionSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.save = function () {

            if (!$scope.addRegionData.region_name.length || ($scope.addRegionData.sub_bu_json_index == null)) {
                return window.fufuMessageBox("请填写区域名称和所属单位", fufu_message_box_duration, function () {});
            }

            addRegionSev.addRegion().then(function (ret) {
                if (ret) {
                    //成功
                    //editRegionSev.setState(1); //添加区域
                    //$location.path('/home_page/home_default/edit_region');
                    $ionicHistory.goBack();
                } else {

                    //失败
                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});

                }
            });
        };

        $scope.theUnit = function () {
            if ($scope.addRegionData.sub_bu_json && $scope.addRegionData.sub_bu_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.addRegionData.sub_bu_json,
                    selectIndex: $scope.addRegionData.sub_bu_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if ($scope.addRegionData.sub_bu_json_index) {
                                $scope.addRegionData.sub_bu_json[$scope.addRegionData.sub_bu_json_index].check = false;
                            }

                            $scope.addRegionData.sub_bu_json[index].check = true;
                            $scope.addRegionData.sub_bu_json_index = index;

                        }
                    }
                });
            }
        }

        $scope.openRegionName = function () {
            $location.path('/home_page/home_default/region_name/0/0');
        }


        $scope.notDataStyle = {
            "color": "#cccccc"
        };

        $scope.local_resource = local_resource;

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            //



        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $rootScope.showLoading();
            $scope.addRegionData = addRegionSev.getData();
            $rootScope.hideLoading();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

    })
    .controller('regionNameCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, $filter, addRegionSev, regionNameSev) {

        var regionDataBak = {};

        $scope.back = function () {

            angular.copy(regionDataBak, $scope.regionData);

            $ionicHistory.goBack();
        };

        $scope.save = function () {

            if ($stateParams.zid == 0) {
                $ionicHistory.goBack();
            } else {
                $rootScope.showLoading();
                var _str = '';
                if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                    _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
                }
                $.ajax({
                    type: 'POST',
                    url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveDevZoneName&' + _str,
                    timeout: _var_timeout,
                    data: {
                        zone_id: $stateParams.zid,
                        select_sub_bu: regionNameSev.getRegionNameKey(),
                        zone_name: $scope.regionData.region_name
                    },
                    success: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        var _data = $.parseJSON(data);

                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {
                            if (_data.flag != "0") {
                                angular.copy(regionDataBak, $scope.regionData);
                            }
                            $ionicHistory.goBack();
                        });
                    },
                    error: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                    }
                });
            }

        }



        $scope.local_resource = local_resource;

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前

            $scope.regionData = addRegionSev.getData();

            angular.copy($scope.regionData, regionDataBak);
            if (!$scope.regionData) {
                $scope.regionData = {};
                $scope.regionData.region_name = "";
            } else if (!$scope.regionData.region_name) {
                $scope.regionData.region_name = "";
            } else {
                $scope.regionData.region_name = jQuery.parseHTML($scope.regionData.region_name)[0].data;
            }

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $rootScope.hideLoading();


        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
        });

    })
    .controller('attendanceDeviceNameCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, attendanceDeviceSev,
        attendanceDeviceNameSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.device_name = attendanceDeviceNameSev.getData();
        if (!$scope.device_name) {
            $scope.device_name = {};
            $scope.device_name.str = "";
        } else if (!$scope.device_name.str) {
            $scope.device_name.str = "";
        } else {
            $scope.device_name.str = jQuery.parseHTML($scope.device_name.str)[0].data;
        }



        $scope.save = function () {

            if (!$scope.device_name.str.length) {
                return;
            }


            $rootScope.showLoading();
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $.ajax({
                type: 'POST',
                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveDeviceNameBySn&' + _str,
                timeout: _var_timeout,
                data: {
                    device_sn: $stateParams.device_sn,
                    device_name: $scope.device_name.str,
                    _user_name: window.localStorage['_user_name'],
                    _pass_word: window.localStorage['_pass_word'],
                    _is_login: window.localStorage['_is_login'],
                    _notification_token: window.localStorage['_notification_token'],
                    _device_type: window.localStorage['_device_type']

                },
                success: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    var _data = $.parseJSON(data);
                    if (_data.flag == 0) {

                        attendanceDeviceSev.setDeviceName($scope.device_name.str);
                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {
                            $ionicHistory.goBack();
                        });
                    } else {
                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
                    }
                },
                error: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                }
            });


        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

            $setstatusBar.black();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })

    .controller('attendanceNetStateCtrl', function (attendanceDeviceSettingSev, $stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, scanBluetoothStateSev, searchDeviceSev, attendanceNetStateSev, attendanceDeviceMoreSettingSev) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };


        $scope.deviceType = attendanceNetStateSev.getDeviceType();

        $scope.local_resource = local_resource;

        $scope.reconfigureNet = function () {

            try {
                searchDeviceSev.setReset(false);
                //这里不需要暂停
                // autosignin.pauseSignIn();
                scanBluetoothStateSev.setState(false);

                searchDeviceSev.setResetNetState(true);
                attendanceNetStateSev.setDeviceType(0);
                $location.path('/home_page/home_default/search_device');
            } catch (e) {
                alert(e);
            }

        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $scope.aNetStateData = attendanceDeviceMoreSettingSev.getData();

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $setstatusBar.black();

            $rootScope.removeEventGlobalBack();
            $rootScope.addEventGlobalBack();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })

    .controller('attendanceDeviceSettingCtrl', function (attendanceDeviceSettingSev, $stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, attendanceDeviceSev,
        attendanceDeviceNameSev) {

        // $scope.settingInfo = {
        //     'device_sn':$stateParams.device_sn,
        //     'device_name':$stateParams.device_name,
        //     'device_version':'',
        //     'net_status':''
        // }
        attendanceDeviceSettingSev.loadData($stateParams.device_sn, $stateParams.device_name).then(function () {
            $scope.settingInfo = attendanceDeviceSettingSev.getData();
        });

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.openDeviceName = function () {

            attendanceDeviceNameSev.setInfo($scope.settingInfo.device_name);
            $location.path('/home_page/home_default/attendance_device_name/' + $stateParams.device_name + '/' + $stateParams.device_sn);
        };

        $scope.openTimeZone = function () {
            $location.path('/home_page/home_default/time_zone/' + $stateParams.device_name + '/' + $stateParams.device_sn);
        };

        $scope.unbundling = function () {
            $scope.myPopup = $ionicPopup.show({
                title: '解除绑定后，考勤机内的数据将被清除，确认解绑',
                scope: $scope,
                cssClass: 'popup-body-diy-title',
                buttons: [{
                        text: '取消',
                        type: 'button-light',
                        onTap: function (e) {

                        }
                    },
                    {
                        text: '确认',
                        type: 'button-positive',
                        onTap: function (e) {


                            $rootScope.showLoading();
                            var date = new Date();
                            var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
                            var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
                            var inputdate = date.getFullYear() + "-" + month + "-" + day;
                            if ($stateParams.zone_id == "" || $stateParams.zone_id == "null" || $stateParams.zone_id == "0") {
                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.deletesn',
                                    timeout: 300000,
                                    data: {
                                        add_data: 'sn:' + $scope.settingInfo.device_sn + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate,
                                        data: 'sn:' + $scope.settingInfo.device_sn + '\nstatus:0' + '\ninput_date: ',
                                        device_sn: $scope.settingInfo.device_sn
                                    },
                                    success: function (json) {
                                        $rootScope.hideLoading();
                                        var data = $.parseJSON(json);
                                        if (data.flag == '0') {
                                            window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {
                                                if (attendanceDeviceSev.getOpenAttendanceDeviceMode()) {
                                                    $ionicHistory.goBack(-5 - attendanceDeviceSev.getBackStepNum());

                                                } else {
                                                    $ionicHistory.goBack(-2);
                                                }

                                                attendanceDeviceSev.resetData();
                                            });
                                        } else {
                                            $rootScope.hideLoading();
                                            window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                        }
                                    },
                                    error: function () {
                                        $rootScope.hideLoading();
                                        window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                    }
                                })
                            } else {
                                $.ajax({
                                    type: "POST",
                                    url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd',
                                    timeout: 300000,
                                    data: {
                                        sid: "cpe.att.person.deleteUserInfo",
                                        send_type: 3,
                                        sync_type: 3,
                                        zoneid: $stateParams.zone_id,
                                        sn: $scope.settingInfo.device_sn,
                                        device_sn_list: $scope.settingInfo.device_sn,
                                        zone_id: $stateParams.zone_id
                                    },
                                    success: function (json) {
                                        var data = $.parseJSON(json);
                                        if (angular.isDefined(data.flag) && data.flag == '1') {
                                            $.ajax({
                                                type: "POST",
                                                url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.deletesn',
                                                timeout: 300000,
                                                data: {
                                                    add_data: 'sn:' + $scope.settingInfo.device_sn + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate,
                                                    data: 'sn:' + $scope.settingInfo.device_sn + '\nstatus:0' + '\ninput_date: ',
                                                    device_sn: $scope.settingInfo.device_sn
                                                },
                                                success: function (json) {
                                                    $rootScope.hideLoading();
                                                    var data = $.parseJSON(json);
                                                    if (data.flag == '0') {
                                                        window.fufuMessageBox("解绑成功", fufu_message_box_duration, function () {
                                                            if (attendanceDeviceSev.getOpenAttendanceDeviceMode()) {
                                                                $ionicHistory.goBack(-5 - attendanceDeviceSev.getBackStepNum());
                                                            } else {
                                                                $ionicHistory.goBack(-2);
                                                            }

                                                            attendanceDeviceSev.resetData();
                                                        });
                                                    } else {
                                                        $rootScope.hideLoading();
                                                        window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                                    }
                                                },
                                                error: function () {
                                                    $rootScope.hideLoading();
                                                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                                                }
                                            })
                                        } else {
                                            $rootScope.hideLoading();
                                            window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                        }

                                    },
                                    error: function () {
                                        $rootScope.hideLoading();
                                        window.fufuMessageBox("解绑失败", fufu_message_box_duration, function () {});
                                    }
                                })

                            }

                        }
                    },
                ]
            });
        };


        $scope.net_state = function () {
            $location.path('/home_page/home_default/attendance_net_state');
        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);

        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            $setstatusBar.black();
        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);
        });

    })
    .controller('timeZoneCtrl', function ($scope, $location, $timeout, $ionicLoading, $ionicActionSheet, timeSelect, sideSelect, $ionicHistory, $ionicPopup, $rootScope, $ionicScrollDelegate, attendanceDeviceSettingSev, $ionicPopover, $stateParams, attendanceDeviceMoreSettingSev) {
        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.adSearchIptFocus = function () {
            $timeout(function () {
                $("#timeZoneSearchIpt").focus();
            }, 50);
            return true;
        };


        $scope.scrollTop = function () {
            $ionicScrollDelegate.$getByHandle('timeZoneSearchScroll').scrollTop();
        };

        // Search Start

        $scope.searchPagingConfig = {};
        $scope.searchPagingConfig.filter_str = "";

        $scope.$watch('searchPagingConfig.filter_str', function (newVal, oldVal) {
            // console.log(newVal.length);
            $scope.scrollTop();
        });

        $ionicPopover.fromTemplateUrl('time-zone-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });

        var isOpenSearchPopover = false;
        $scope.openSearchPopover = function ($event) {
            isOpenSearchPopover = true;
            $scope.searchPopover.show($event);
            $(".search-popover").parents(".popover-backdrop").css("zIndex", 9);
            return 1;
        };

        $scope.closeSearchPopover = function () {
            isOpenSearchPopover = false;
            $scope.searchPopover.hide();
            $timeout(function () {
                $scope.searchPagingConfig.filter_str = '';
            }, 100);

            return 1;
        };

        $scope.$on('$destroy', function () {

            $scope.searchPopover.remove();
        });

        // Search End

        $scope.$on("$ionicView.afterEnter", function (event, data) {

            var _time_zone_data;
            if (true) {
                _time_zone_data = attendanceDeviceMoreSettingSev.getData();
            } else {
                _time_zone_data = attendanceDeviceSettingSev.getData();
            }


            $scope.time_zone_data = {};
            $scope.time_zone_data.time_zone = [];
            angular.copy(_time_zone_data.time_zone, $scope.time_zone_data.time_zone);
            $scope.time_zone_data.select_time_zone_id = _time_zone_data.select_time_zone_id;
            $scope.time_zone_data.select_time_zone_text = _time_zone_data.select_time_zone_text;
            $scope.time_zone_data.select_time_zone_key = _time_zone_data.select_time_zone_key;
            $scope.time_zone_data.select_time_zone_value = _time_zone_data.select_time_zone_value;



        });


        $scope.set_time_zone = function (item) {
            $scope.time_zone_data.select_time_zone_id = item.id;
            $rootScope.showLoading();
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $.ajax({
                type: 'POST',
                url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.saveDeviceTimeZone&' + _str,
                timeout: _var_timeout,
                data: {
                    device_sn: $stateParams.device_sn,
                    device_name: $stateParams.device_name,
                    time_zone_key: item.key,
                    time_zone_id: item.id,
                    time_zone_val: item.value
                },
                success: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    var _data = $.parseJSON(data);
                    if (isOpenSearchPopover) {
                        $scope.closeSearchPopover();
                    }
                    $ionicHistory.goBack();
                },
                error: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    if (isOpenSearchPopover) {
                        $scope.closeSearchPopover();
                    }
                    $ionicHistory.goBack();
                }
            });

        }

    })
    .controller('attendanceDeviceCtrl', function ($http, $stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, attendanceDeviceSev, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, $emplComponentService, $filter, IONIC_BACK_PRIORITY, attendanceNetStateSev) {

        $scope.local_resource = local_resource;
        $scope.isSearch = false;
        $scope.isBackView = false;
        var device_sn = $stateParams.device_sn;


        $scope.title = $stateParams.device_name;
        $scope.zone_id = $stateParams.zone_id;
        $scope.searchObj = {

        };

        $scope.setstatusBar = $setstatusBar;

        $scope.attendanceDeviceSev = attendanceDeviceSev;

        var loadMoreState = false;

        $scope.loadMore = function () {
            if (loadMoreState) {
                return console.log("loadMoreState：" + loadMoreState);
            }

            loadMoreState = true;
            $scope.pagingConfig.cur_num += 1;
            attendanceDeviceSev.reloadPagingData($scope.adData.zone_json[$scope.adData.zone_json_index].key).then(function () {
                $rootScope.hideLoading();
                $scope.$broadcast('scroll.infiniteScrollComplete');
                loadMoreState = false;

            });
        };


        var searchLoadMoreState = false;

        $scope.searchLoadMore = function () {
            if (searchLoadMoreState) {
                return console.log("searchLoadMoreState：" + searchLoadMoreState);
            }

            searchLoadMoreState = true;

            $scope.searchPagingConfig.cur_num += 1;
            $rootScope.showLoading();
            attendanceDeviceSev.reloadSearchPagingData($scope.adData.zone_json[$scope.adData.zone_json_index].key).then(function (ret) {

                for (var i = 0; i < ret.length; i++) {
                    $scope.searchObj.list.push(ret[i]);
                }
                $rootScope.hideLoading();
                $scope.$broadcast('scroll.infiniteScrollComplete');
                searchLoadMoreState = false;

            });
        };


        $scope.adSearchIptFocus = function () {
            $timeout(function () {
                $("#adSearchIpt").focus();
            }, 50);
            return true;
        };


        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };


        $scope.back = function (e) {

            if (e) {
                e.preventDefault();
            }


            if (attendanceDeviceSev.getOpenAttendanceDeviceMode()) {

                $ionicHistory.goBack((-4 - attendanceDeviceSev.getBackStepNum()));
            } else {
                $ionicHistory.goBack();
            }

            $timeout(function () {
                attendanceDeviceSev.resetData();
            }, 300);

            $scope.leaveHandle();

            $scope.isBackView = true;

            return false;
        };


        $scope.PhysBack = function (e) {

            if (e) {
                e.preventDefault();
            }

            if (fufu_show_loading_counter != 0) {

                return;
            }


            if (sideSelect.isOpen()) {
                sideSelect.close();
                return;
            }

            if (attendanceDeviceSev.getOpenAttendanceDeviceMode()) {

                $ionicHistory.goBack((-4 - attendanceDeviceSev.getBackStepNum()));
            } else {

                $ionicHistory.goBack();
            }

            $timeout(function () {
                attendanceDeviceSev.resetData();
            }, 300);

            $scope.leaveHandle();

            $scope.isBackView = true;

            return false;
        };

        $scope.SearchBack = function (e) {
            if (e) {
                e.preventDefault();
            }

            $scope.closeSearchPopover();

        }

        $scope.scrollTop = function () {
            $ionicScrollDelegate.$getByHandle('attendanceDeviceSearchScroll').scrollTop();
        };

        // Search Start
        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;
        // $scope.searchPagingConfig.filter_str
        $scope.$watch('searchPagingConfig.filter_str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
                $ionicScrollDelegate.$getByHandle('attendanceDeviceSearchScroll').scrollTop(false);
            }
        });

        $scope.searchCarryOn = false;

        $scope.search = function () {


            $scope.searchPagingConfig.cur_num = 1;
            $scope.searchObj.list = [];
            $scope.searchPagingConfig.is_init = false;
            $scope.searchCarryOn = true;

            $rootScope.showLoading();
            $timeout(function () {
                attendanceDeviceSev.reloadSearchPagingData($scope.adData.zone_json[$scope.adData.zone_json_index].key).then(function (ret) {
                    $ionicScrollDelegate.$getByHandle('attendanceDeviceSearchScroll').scrollTop(false);
                    $scope.searchObj.state = true;
                    $scope.searchCarryOn = false;
                    $scope.searchObj.list = ret;
                    $scope.searchPagingConfig.is_init = true;
                    $rootScope.hideLoading();
                });
            }, 500);

        };

        $ionicPopover.fromTemplateUrl('search-attendance-device-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function ($event) {
            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.SearchBack, 401
            );

            $scope.searchPopover.show($event);
            $(".search-popover").parents(".popover-backdrop").css("zIndex", 9);
            return 1;
        };

        $scope.closeSearchPopover = function () {

            $scope.searchPopover.hide();
            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );
            $timeout(function () {
                $scope.searchPagingConfig.filter_str = "";
                $scope.searchPagingConfig.is_init = false;
                $scope.searchObj.list = [];
            }, 100);

            return 1;
        };



        // Search End

        $scope.reset_employee_no_list = function () {
            $timeout(function () {
                $scope.adData.employee_no_list = "";
                for (var i = 0, len = $scope.adData.empl_data.length; i < len; i++) {
                    if (i == len - 1) {
                        $scope.adData.employee_no_list += ($scope.adData.empl_data[i].employee_no);
                    } else {
                        $scope.adData.employee_no_list += ($scope.adData.empl_data[i].employee_no + ',');
                    }
                }

            }, 0);

        }

        $scope.delStaff = function (staffItem, index, sflag) {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否删除该员工',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light'
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.myPopup.close();
                            var _str = '';
                            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
                            }

                            $rootScope.showLoading();
                            $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                                params: {
                                    sid: "cpe.att.person.deleteUserInfo",
                                    send_type: 3,
                                    sync_type: 2,
                                    zoneid: $scope.zone_id,
                                    employee_list: staffItem.employee_no,
                                    zone_id: $scope.zone_id
                                },
                                timeout: _var_timeout
                            }).
                            success(function (data, status, headers, config) {
                                $rootScope.hideLoading();
                                window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
                                if (data.flag == "1") {
                                    attendanceDeviceSev.delStaff(staffItem, index).then(function () {

                                        $scope.reset_employee_no_list();
                                        if (!sflag) {
                                            return;
                                        }
                                        for (var i = 0, len = $scope.searchObj.list.length; i < len; i++) {
                                            if ($scope.searchObj.list[i].staff_no == staffItem.staff_no) {

                                                $timeout(function () {
                                                    $scope.searchObj.list.splice(i, 1);
                                                }, 0);

                                                break;
                                            }
                                        };
                                    });
                                }

                            }).
                            error(function (data, status, headers, config) {
                                $rootScope.hideLoading();
                                window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                            });
                        }
                    }
                ]
            });
        };

        $scope.openSetting = function () {
            $scope.leaveHandle();
            if (true) {
                $location.path('/home_page/home_default/attendance_device_more_setting' + '/' + $stateParams.device_sn + '/' + $stateParams.device_name + '/' + $scope.zone_id);
            } else {
                $location.path('/home_page/home_default/attendance_device_setting' + '/' + $stateParams.device_sn + '/' + $stateParams.device_name + '/' + $scope.zone_id);
            }


        };

        $scope.delFinger = function (fig, empl_no, index, isSearch, staffItem) {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否删除该指纹',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light'
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.myPopup.close();
                            attendanceDeviceSev.delFinger(fig, empl_no, index, isSearch, staffItem).then(function () {

                                if (isSearch) {
                                    $timeout(function () {

                                        if (fig == 0) {
                                            $scope.searchObj.list[index].fingerprint1 = 0;
                                        } else {
                                            $scope.searchObj.list[index].fingerprint2 = 0;
                                        }

                                        if ($scope.searchObj.list[index].fingerprint1 == 0 && $scope.searchObj.list[index].fingerprint2 == 0) {
                                            $scope.adData.staff_num_config.input_staff_size -= 1;
                                        }

                                    }, 0);

                                }


                            });
                        }
                    }
                ]
            });
        };

        $scope.cancelFinger = function () {
            $rootScope.showLoading();
            $.ajax({
                type: "POST",
                url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.execCmd",
                timeout: 300000,
                data: {
                    sid: "dms.control.cancel.fp",
                    sn: _cur_sn_no
                },
                success: function (json) {
                    $rootScope.hideLoading();
                    var data = $.parseJSON(json);
                    if (angular.isDefined(data.flag) && data.flag == '1') {
                        $scope.closePopover();

                    } else {
                        window.fufuMessageBox("请求指令执行失败", fufu_message_box_duration, function () {});
                        $scope.closePopover();
                    }
                },
                error: function () {
                    $rootScope.hideLoading();
                    window.fufuMessageBox("请求失败", fufu_message_box_duration, function () {});
                    $scope.closePopover();
                }
            })
        }



        $ionicPopover.fromTemplateUrl('my-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.popover = popover;
        });

        $scope.isOpenFingerprint = false;

        $scope.openPopover = function ($event) {
            $scope.isOpenFingerprint = true;
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.isOpenFingerprint = false;
            $scope.popover.hide();
        };
        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.popover.remove();
            $scope.searchPopover.remove();
        });
        // 在隐藏浮动框后执行
        $scope.$on('popover.hidden', function (ev) {
            // 执行代码
            if ($scope.isOpenFingerprint) {
                $scope.isOpenFingerprint = false;

                $.ajax({
                    type: "POST",
                    url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.execCmd",
                    timeout: 300000,
                    data: {
                        sid: "dms.control.cancel.fp",
                        sn: _cur_sn_no
                    },
                    success: function (json) {
                        $rootScope.hideLoading();
                        var data = $.parseJSON(json);
                        if (angular.isDefined(data.flag) && data.flag == '1') {
                            console.log("请求成功");

                        } else {
                            console.log("请求指令执行失败");

                        }
                    },
                    error: function () {
                        console.log("请求失败");
                    }
                })

            }
        });
        // 移除浮动框后执行
        $scope.$on('popover.removed', function (ev) {
            // 执行代码
            attendanceDeviceSev.resetInputFingerData();
        });



        $scope.resetInputFinger = function () {

            attendanceDeviceSev.resetInputFingerData($scope.inputFingerData.input_finger_name);
            attendanceDeviceSev.activeFingerState();

            var input_finger_flag = null;

            if ($scope.curStaff.fingerprint1 == "0") {
                input_finger_flag = 0;
            } else if ($scope.curStaff.fingerprint2 == "0") {
                input_finger_flag = 1;
            }


            $rootScope.showLoading();
            var xhr = $.ajax({
                type: 'POST',
                url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.addfpAction&_dc=' + new Date().getTime(),
                timeout: _var_timeout,
                data: {
                    device_sn: device_sn,
                    empl_no: $scope.curStaff.staff_no,
                    _user_name: window.localStorage['_user_name'],
                    _pass_word: window.localStorage['_pass_word'],
                    _is_login: window.localStorage['_is_login'],
                    _notification_token: window.localStorage['_notification_token'],
                    _device_type: window.localStorage['_device_type'],
                    fig_no: input_finger_flag
                },
                success: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    var _data = $.parseJSON(data);
                    if (angular.isDefined(_data.flag) && _data.flag == "0") {
                        $timeout(function () {
                            // $scope.inputFinger($scope.curStaff);

                            attendanceDeviceSev.updataInputFingerName($scope.curStaff.employee_name);
                            //激活录入指纹
                            attendanceDeviceSev.activeFingerState();

                        }, 0);
                    } else {
                        window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
                    }

                },
                error: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
                }
            });
            // attendanceDeviceSev.addFingerTemplate(device_sn,$scope.curStaff.staff_no,input_finger_flag).then(function(ret){

            //     if(ret.state){
            //      $timeout(function(){
            //         $scope.inputFinger($scope.curStaff);
            //       },0);
            //    }
            //     $rootScope.hideLoading();
            //     $timeout(function(){
            //       alert("$scope.deregister");
            //       $scope.deregister();
            //         $scope.deregister = $ionicPlatform.registerBackButtonAction(
            //             $scope.PhysBack, 150
            //         );
            //     },0);

            // })
        }

        $scope.inputFingerSuccess = function () {

            // attendanceDeviceSev.loadData($stateParams.device_sn);

            if ($scope.curStaff.fingerprint1 == "1" || $scope.curStaff.fingerprint2 == "1") {

            } else {

                $scope.adData.staff_num_config.input_staff_size += 1;
            }

            if ($scope.curStaff.fingerprint1 == "0") {
                $scope.curStaff.fingerprint1 = "1";
            } else if ($scope.curStaff.fingerprint2 == "0") {
                $scope.curStaff.fingerprint2 = "1";
            }

            if ($scope.curStaff.isSearch) {
                for (var i = 0, len = $scope.adData.empl_data.length; i < len; i++) {
                    if ($scope.adData.empl_data[i].employee_no == $scope.curStaff.employee_no) {

                        $scope.adData.empl_data[i].fingerprint1 = $scope.curStaff.fingerprint1;
                        $scope.adData.empl_data[i].fingerprint2 = $scope.curStaff.fingerprint2;
                        break;
                    }
                }

            }

            $scope.closePopover();


            //alert($scope.curStaff.fingerprint1 + " " + $scope.curStaff.fingerprint2);
        }



        window.setFingerStep = null;
        window.updataInputFingerError = null;



        $scope.inputFinger = function (staff) {

            if (!window.setFingerStep) {
                window.setFingerStep = function (num) {
                    $timeout(function () {
                        attendanceDeviceSev.setFingerStep(num);
                    }, 0);

                };
                window.updataInputFingerError = function (msg) {
                    $timeout(function () {
                        attendanceDeviceSev.updataInputFingerError(msg);
                    }, 0);

                }
            }

            attendanceDeviceSev.updataInputFingerName(staff.employee_name);
            //激活录入指纹
            attendanceDeviceSev.activeFingerState();

            $scope.openPopover();
            // attendanceDeviceSev.inputFinger(true);
        };

        $scope.curStaff = {};
        $scope.addFingerTemplate = function (staff, isSearch) {
            attendanceDeviceSev.resetInputFingerData();
            if (attendanceDeviceSev.retDebugState() && 0) {

                $scope.curStaff = staff;
                $scope.inputFinger(staff);
            } else {
                $rootScope.showLoading();
                $scope.curStaff = staff;
                $scope.curStaff.isSearch = isSearch;

                var input_finger_flag = null;

                if ($scope.curStaff.fingerprint1 == "0") {
                    input_finger_flag = 0;
                } else if ($scope.curStaff.fingerprint2 == "0") {
                    input_finger_flag = 1;
                }

                attendanceDeviceSev.addFingerTemplate(device_sn, staff.staff_no, input_finger_flag).then(function (ret) {
                    if (ret.state) {
                        $scope.inputFinger(staff);
                    }
                    $rootScope.hideLoading();
                })
            }

        }

        $scope.loadDataCallback = function (state) {

            $rootScope.hideLoading();
        };


        $scope.theUnit = function () {
            if ($scope.adData.sub_bu_json && $scope.adData.sub_bu_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.adData.sub_bu_json,
                    selectIndex: $scope.adData.sub_bu_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if ($scope.adData.sub_bu_json_index) {
                                $scope.adData.sub_bu_json[$scope.adData.sub_bu_json_index].check = false;
                            }

                            $scope.adData.sub_bu_json[index].check = true;
                            $scope.adData.sub_bu_json_index = index;
                            var _zone_key = '';
                            if ($scope.adData.zone_json_index == '' || $scope.adData.zone_json_index == null) {
                                _zone_key = '-1';
                            } else {
                                _zone_key = $scope.adData.zone_json[$scope.adData.zone_json_index].key;
                            }
                            attendanceDeviceSev.changeUnit(device_sn, $scope.adData.sub_bu_json[$scope.adData.sub_bu_json_index].key, _zone_key);
                        }
                    }
                });
            }
        }

        $scope.region = function () {
            if ($scope.adData.zone_json && $scope.adData.zone_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.adData.zone_json,
                    selectIndex: $scope.adData.zone_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if (typeof ($scope.adData.zone_json_index) == 'undefined' || $scope.adData.zone_json_index == null) {
                                attendanceDeviceSev.setZoneRegion(device_sn, $scope.adData.sub_bu_json[$scope.adData.sub_bu_json_index].key, $scope.adData.zone_json[index].key);
                            } else {
                                $scope.adData.zone_json[$scope.adData.zone_json_index].check = false;
                                attendanceDeviceSev.changeRegion($scope.adData.zone_json[$scope.adData.zone_json_index].key, device_sn, $scope.adData.sub_bu_json[$scope.adData.sub_bu_json_index].key, $scope.adData.zone_json[index].key);
                            }
                            $scope.adData.zone_json[index].check = true;
                            $scope.adData.zone_json_index = index;
                            $scope.zone_id = $scope.adData.zone_json[$scope.adData.zone_json_index].key;
                            $scope.pagingConfig.is_init = false;

                        }
                    }
                });
            }
        };


        function strEmployeeHandle(arr) {
            if (!arr.length) {
                return ''
            }
            var str = '';
            for (var i = 0, len = arr.length; i < len; i++) {
                if (i == len - 1) {
                    str += arr[i].empl_no;
                } else {
                    str += arr[i].empl_no + ',';
                }

            }

            return str
        }

        $scope.addStaff = function () {
            if (typeof ($scope.adData.zone_json_index) == 'undefined' || $scope.adData.zone_json_index == null || typeof ($scope.adData.sub_bu_json_index) == 'undefined' || $scope.adData.sub_bu_json_index == null) {
                window.fufuMessageBox("请选择【设备所属单位】及【区域名称】", fufu_message_box_duration, function () {});
            } else {
                $scope.leaveHandle();
                $emplComponentService.open({
                    title: '选择员工', //弹开窗口标题
                    barTitle: window.localStorage["org_top_level"], //导航开头
                    isSingleSelect: false, //是否单选
                    isShowContact: false, //是否展示常用联系人
                    isNeedSaveContact: false, //是否保存常用联系人
                    extName: '员工', //多选时提示后缀名
                    selectEmplList: $scope.adData.employee_no_list, //打开窗口默认选中员工列表
                    params: { //支持可用扩展参数
                        "is_permissions": "1",
                        "is_process": "0",
                        "process_instance": '0',
                        "ext_param": 'exclude_checked'
                    },
                    sure: function (rd) { //返回数据，数组格式
                        if (rd.length > 0 && angular.isDefined($scope.adData.zone_json_index) && $scope.adData.zone_json_index != null) {

                            $scope.adData.employee_no_list = (',' + strEmployeeHandle(rd));
                            $scope.adData.staff_num_config.staff_size += rd.length;

                            $scope.adData.empl_data = $scope.adData.empl_data.concat(rd);
                            attendanceDeviceSev.saveEmplData(device_sn, $scope.adData.zone_json[$scope.adData.zone_json_index].key, $scope.adData.employee_no_list);
                        }
                    }
                });
            }
        };


        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );

            $scope.isOldDevice = attendanceNetStateSev.getDeviceType();
            $scope.adData = attendanceDeviceSev.getData();

        });




        $scope.$watch('adData.staff_num_config', function (newValue, oldValue, scope) {

            if (newValue != undefined) {


                $(".adNotResolved").hide();
                $(".adResolved").hide();
                $(".adPending").hide();

                if (newValue.staff_size != 0) {
                    if (newValue.input_staff_size == 0) {
                        $(".adNotResolved").show();
                    } else if (newValue.input_staff_size == newValue.staff_size) {
                        $(".adResolved").show();
                    } else {
                        $(".adPending").show();
                    }
                }

            }

        }, true);

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            // alert($ionicHistory.currentView().url);


            $scope.pagingConfig = attendanceDeviceSev.getPagingConfig();
            $scope.searchPagingConfig = attendanceDeviceSev.getSearchPagingConfig();
            //web调试用
            //if($scope.adData.flag || window.addDataFlag){
            //app环境用
            if ($scope.adData.flag) {
                $scope.scrollTop();
                $rootScope.showLoading();
                $scope.inputFingerData = attendanceDeviceSev.getInputFingerData();
                attendanceDeviceSev.loadData(device_sn).then(function (state) {
                    $rootScope.hideLoading();
                });
                attendanceDeviceSev.set_flag(false);
                //web调试用
                window.addDataFlag = false;
            }

            $scope.setstatusBar.white();

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);


        });

        $scope.$on('$ionicView.afterLeave', function () {
            //离开之后
            if ($scope.isBackView) {

                $ionicScrollDelegate.$getByHandle('attendanceDeviceContent').scrollTop();
            }

        });


    })


    .controller('attendanceMemberCtrl', function ($stateParams, $scope, $rootScope, $location, $ionicHistory, $ionicPopup, $ionicPlatform, $timeout, attendanceMemberSev, $ionicScrollDelegate, $setstatusBar, $ionicPopover, sideSelect, $emplComponentService, $filter) {

        $scope.local_resource = local_resource;


        $scope.setstatusBar = $setstatusBar;


        var loadMoreState = false;

        $scope.loadMore = function () {
            if (loadMoreState) {
                return console.log("loadMoreState：" + loadMoreState);
            }

            loadMoreState = true;
            $scope.pagingConfig.cur_num += 1;
            attendanceMemberSev.reloadPagingData().then(function () {
                $rootScope.hideLoading();

                $timeout(function () {
                    $scope.$broadcast('scroll.infiniteScrollComplete');
                    loadMoreState = false;
                }, 1000);

            });
        };


        var searchLoadMoreState = false;

        $scope.searchLoadMore = function () {
            if (searchLoadMoreState) {
                return console.log("searchLoadMoreState：" + searchLoadMoreState);
            }

            searchLoadMoreState = true;

            $scope.searchPagingConfig.cur_num += 1;
            $rootScope.showLoading();
            attendanceMemberSev.reloadSearchPagingData().then(function (ret) {

                for (var i = 0; i < ret.length; i++) {
                    $scope.searchObj.list.push(ret[i]);
                }

                $rootScope.hideLoading();

                $timeout(function () {
                    $scope.$broadcast('scroll.infiniteScrollComplete');
                    searchLoadMoreState = false;
                }, 1000);

            });
        };


        $scope.adSearchIptFocus = function () {
            $timeout(function () {
                $("#admSearchIpt").focus();
            }, 50);
            return true;
        };

        $scope.leaveHandle = function () {

            $scope.deregister();

            $rootScope.addEventGlobalBack();

        };

        $scope.back = function () {

            $ionicHistory.goBack();
            $timeout(function () {
                attendanceMemberSev.resetData();
            }, 400);

            $scope.leaveHandle();
        };

        $scope.PhysBack = function () {
            if (fufu_show_loading_counter != 0) {
                return;
            }
            $ionicHistory.goBack();
            $timeout(function () {
                attendanceMemberSev.resetData();
            }, 400);

            $scope.leaveHandle();
        };

        $scope.SearchBack = function (e) {
            if (e) {
                e.preventDefault();
            }
            $scope.closeSearchPopover();
        }

        $scope.scrollTop = function () {
            $ionicScrollDelegate.scrollTop();
        };

        $scope.reset_employee_no_list = function () {
            $timeout(function () {
                $scope.adData.employee_no_list = "";
                for (var i = 0, len = $scope.adData.empl_data.length; i < len; i++) {
                    if (i == len - 1) {
                        $scope.adData.employee_no_list += ($scope.adData.empl_data[i].employee_no);
                    } else {
                        $scope.adData.employee_no_list += ($scope.adData.empl_data[i].employee_no + ',');
                    }
                }

            }, 0);

        }

        $scope.delStaff = function (staffItem, index, sflag) {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否删除该员工',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light'
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.myPopup.close();
                            attendanceMemberSev.delStaff(staffItem, index).then(function () {

                                $scope.reset_employee_no_list();
                                if (!sflag) {
                                    return;
                                }

                                for (var i = 0, len = $scope.searchObj.list.length; i < len; i++) {
                                    if ($scope.searchObj.list[i].staff_no == staffItem.staff_no) {

                                        $timeout(function () {
                                            $scope.searchObj.list.splice(i, 1);
                                            if ($scope.searchObj.list.length == 0) {
                                                $scope.searchPagingConfig.end_status = false;
                                            }
                                        }, 0);

                                        break;
                                    }
                                };



                            });


                        }
                    }
                ]
            });
        };


        $scope.cancelFinger = function () {
            $rootScope.showLoading();

            $.ajax({
                type: "POST",
                url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.execCmd",
                timeout: 300000,
                data: {
                    sid: "dms.control.cancel.fp",
                    sn: $scope.curDeviceSn
                },
                success: function (json) {
                    $rootScope.hideLoading();
                    var data = $.parseJSON(json);


                    if (angular.isDefined(data.flag) && data.flag == '1') {
                        $scope.popover.hide();
                        $scope.closePopover();
                    } else {
                        window.fufuMessageBox("请求指令执行失败", fufu_message_box_duration, function () {});
                        $scope.popover.hide();
                        $scope.closePopover();
                    }
                },
                error: function () {
                    $rootScope.hideLoading();
                    window.fufuMessageBox("请求失败", fufu_message_box_duration, function () {});
                    $scope.closePopover();
                }
            })
        }

        // Search Start
        $scope.searchObj = {};
        $scope.searchObj.str = "";
        $scope.searchObj.list = [];
        $scope.searchObj.state = false;

        $scope.$watch('searchPagingConfig.filter_str', function (newVal, oldVal) {
            // console.log(newVal.length);
            if (typeof (newVal) != 'undefined' && newVal.length == 0 && $scope.searchObj.state) {
                $scope.searchObj.state = false;
                $scope.searchObj.list = [];
                $ionicScrollDelegate.$getByHandle('attendanceSearchScroll').scrollTop(false);
            }
        });

        $scope.searchCarryOn = false;

        $scope.search = function () {

            $scope.searchPagingConfig.cur_num = 1;
            $scope.searchObj.list = [];
            $scope.searchPagingConfig.is_init = false;
            $scope.searchCarryOn = true;

            $rootScope.showLoading();
            $timeout(function () {
                attendanceMemberSev.reloadSearchPagingData().then(function (ret) {

                    $ionicScrollDelegate.$getByHandle('attendanceSearchScroll').scrollTop(false);

                    $scope.searchObj.state = true;
                    $scope.searchCarryOn = false;
                    $scope.searchObj.list = ret;
                    $scope.searchPagingConfig.is_init = true;
                    $rootScope.hideLoading();
                });
            }, 500);
        };

        $ionicPopover.fromTemplateUrl('search-attendance-device-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.searchPopover = popover;
        });


        $scope.openSearchPopover = function ($event) {


            $scope.searchPopover.show($event);

            $scope.deregister();

            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.SearchBack, 401
            );

            $(".search-popover").parents(".popover-backdrop").css("zIndex", 9);
            return true;
        };



        $scope.closeSearchPopover = function () {
            $scope.searchPopover.hide();

            $scope.deregister();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );

            $timeout(function () {
                $scope.searchPagingConfig.filter_str = "";
                $scope.searchPagingConfig.is_init = false;
                $scope.searchObj.list = [];
            }, 100);

            return true;
        };



        // Search End



        $scope.delFinger = function (fig, empl_no, index, isSearch) {
            $scope.myPopup = $ionicPopup.confirm({
                title: '是否删除该指纹',
                scope: $scope,
                buttons: [{
                        text: '取消',
                        type: 'button-light'
                    },
                    {
                        text: '确定',
                        type: 'button-light',
                        type: 'button-positive',
                        onTap: function (e) {
                            $scope.myPopup.close();
                            attendanceMemberSev.delFinger(fig, empl_no, index, isSearch).then(function () {

                                if (isSearch) {

                                    if (fig == 0) {
                                        $scope.searchObj.list[index].fingerprint1 = 0;
                                    } else {
                                        $scope.searchObj.list[index].fingerprint2 = 0;
                                    }
                                }

                            });
                        }
                    }
                ]
            });
        };

        //录入指纹  popover

        $ionicPopover.fromTemplateUrl('my-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.popover = popover;
        });

        $scope.isOpenFingerprint = false;

        $scope.openPopover = function ($event) {
            $scope.isOpenFingerprint = true;
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.isOpenFingerprint = false;
            $scope.popover.hide();
        };


        //选择考勤机  popover
        $ionicPopover.fromTemplateUrl('attendance-device-popover.html', {
            scope: $scope
        }).then(function (popover) {
            $scope.selectDevicePopover = popover;
        });

        $scope.openDevicePopover = function ($event) {
            //重置选择设备
            attendanceMemberSev.resetDefDevice();

            //重置指纹录入数据
            attendanceMemberSev.resetInputFingerData();

            //复位设备选择列表到顶部
            $ionicScrollDelegate.$getByHandle('small').scrollTop();

            $scope.selectDevicePopover.show($event);
        };
        $scope.closeDevicePopover = function () {
            $scope.selectDevicePopover.hide();
        };


        // 清除浮动框
        $scope.$on('$destroy', function () {
            $scope.popover.remove();
            $scope.searchPopover.remove();
            $scope.selectDevicePopover.remove();
        });
        // 在隐藏浮动框后执行
        $scope.$on('popover.hidden', function (ev) {
            // 执行代码
            if ($scope.isOpenFingerprint) {
                $scope.isOpenFingerprint = false;

                $.ajax({
                    type: "POST",
                    url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.execCmd",
                    timeout: 300000,
                    data: {
                        sid: "dms.control.cancel.fp",
                        sn: _cur_sn_no
                    },
                    success: function (json) {
                        $rootScope.hideLoading();
                        var data = $.parseJSON(json);
                        if (angular.isDefined(data.flag) && data.flag == '1') {
                            console.log("请求成功");

                        } else {
                            console.log("请求指令执行失败");

                        }
                    },
                    error: function () {
                        console.log("请求失败");
                    }
                })

            }
        });
        // 移除浮动框后执行
        $scope.$on('popover.removed', function (ev) {
            // 执行代码
            attendanceMemberSev.resetInputFingerData();
        });

        $scope.resetInputFinger = function () {

            attendanceMemberSev.resetInputFingerData($scope.inputFingerData.input_finger_name);
            attendanceMemberSev.activeFingerState();

            var input_finger_flag = null;

            if ($scope.curStaff.fingerprint1 == "0") {
                input_finger_flag = 0;
            } else if ($scope.curStaff.fingerprint2 == "0") {
                input_finger_flag = 1;
            }

            attendanceMemberSev.addFingerTemplate(
                $scope.curDeviceSn,
                $scope.curStaff.staff_no,
                input_finger_flag).then(function (ret) {

                if (ret.state) {
                    $scope.inputFinger(staff);
                }
                $rootScope.hideLoading();
            })
        }

        $scope.inputFingerSuccess = function () {
            // attendanceMemberSev.loadData();

            if ($scope.curStaff.fingerprint1 == "1" || $scope.curStaff.fingerprint2 == "1") {

            } else {
                $scope.adData.input_staff_size += 1;
            }

            if ($scope.curStaff.fingerprint1 == "0") {
                $scope.curStaff.fingerprint1 = "1";
            } else if ($scope.curStaff.fingerprint2 == "0") {
                $scope.curStaff.fingerprint2 = "1";
            }

            if ($scope.curStaff.isSearch) {
                for (var i = 0, len = $scope.adData.empl_data.length; i < len; i++) {
                    if ($scope.adData.empl_data[i].employee_no == $scope.curStaff.employee_no) {

                        $scope.adData.empl_data[i].fingerprint1 = $scope.curStaff.fingerprint1;
                        $scope.adData.empl_data[i].fingerprint2 = $scope.curStaff.fingerprint2;
                        break;
                    }
                }

                // employee_no
            }

            //alert($scope.curStaff.fingerprint1 + " " + $scope.curStaff.fingerprint2);
        }



        window.setFingerStep = null;
        window.updataInputFingerError = null;



        $scope.inputFinger = function (staff) {

            if (!window.setFingerStep) {
                window.setFingerStep = function (num) {
                    $timeout(function () {
                        attendanceMemberSev.setFingerStep(num);
                    }, 0);

                };
                window.updataInputFingerError = function (msg) {
                    $timeout(function () {
                        attendanceMemberSev.updataInputFingerError(msg);
                    }, 0);

                }
            }

            attendanceMemberSev.updataInputFingerName(staff.employee_name);
            //激活录入指纹
            attendanceMemberSev.activeFingerState();

            $scope.openPopover();

        };

        $scope.curStaff = {};
        $scope.addFingerTemplate = function (staff, index, is_search) {

            $scope.openDevicePopover();
            $scope.curStaff = staff;
            $scope.curStaff.isSearch = is_search;
        }

        $scope.cancelInput = function () {
            $scope.closeDevicePopover();
        }

        $scope.curDeviceSn = null;
        $scope.startInput = function (device_sn) {

            $scope.closeDevicePopover();
            $scope.curDeviceSn = device_sn;
            $scope.addFingerTemplate2($scope.curStaff, device_sn);
        }

        $scope.addFingerTemplate2 = function (staff, device_sn) {

            console.log(staff);
            console.log(device_sn);

            if (attendanceMemberSev.retDebugState()) {

                $scope.curStaff = staff;
                $scope.inputFinger(staff);
            } else {

                $rootScope.showLoading();
                $scope.curStaff = staff;

                var input_finger_flag = null;

                if ($scope.curStaff.fingerprint1 == "0") {
                    input_finger_flag = 0;
                } else if ($scope.curStaff.fingerprint2 == "0") {
                    input_finger_flag = 1;
                }

                attendanceMemberSev.addFingerTemplate(device_sn, staff.staff_no, input_finger_flag).then(function (ret) {
                    if (ret.state) {
                        $scope.inputFinger(staff);
                    }
                    $rootScope.hideLoading();
                })
            }
        }

        $scope.cancelFingerTemplate2 = function () {
            $scope.closeDevicePopover();
        }

        $scope.loadDataCallback = function (state) {



            $rootScope.hideLoading();
        };


        $scope.region = function () {
            if ($scope.adData.zone_json && $scope.adData.zone_json.length) {
                sideSelect.show({
                    type: 'ios',
                    data: $scope.adData.zone_json,
                    selectIndex: $scope.adData.zone_json_index,
                    selectedFunc: function (index) {
                        if (typeof (index) != 'undefined') {
                            if ($scope.adData.zone_json_index) {
                                $scope.adData.zone_json[$scope.adData.zone_json_index].check = false;
                            }

                            $scope.adData.zone_json[index].check = true;
                            $scope.adData.zone_json_index = index;

                            $scope.pagingConfig.is_init = false;

                            attendanceMemberSev.changeRegion(device_sn, $scope.adData.sub_bu_json[$scope.adData.sub_bu_json_index].key, $scope.adData.zone_json[$scope.adData.zone_json_index].key);
                        }
                    }
                });
            }
        };



        function strEmployeeHandle(arr) {
            if (!arr.length) {
                return ''
            }
            var str = '';
            for (var i = 0, len = arr.length; i < len; i++) {
                if (i == len - 1) {
                    str += arr[i].empl_no;
                } else {
                    str += arr[i].empl_no + ',';
                }

            }

            return str
        }

        $scope.addStaff = function () {
            $scope.leaveHandle();
            $emplComponentService.open({
                title: '选择员工', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: false, //是否展示常用联系人
                isNeedSaveContact: false, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: $scope.adData.employee_no_list, //打开窗口默认选中员工列表
                params: { //支持可用扩展参数
                    "is_permissions": "1",
                    "is_process": "0",
                    "process_instance": '0',
                    "ext_param": 'exclude_checked'
                },
                sure: function (rd) { //返回数据，数组格式

                    if (rd.length > 0) {

                        $scope.adData.employee_no_list = (',' + strEmployeeHandle(rd));



                        $scope.adData.empl_data = $scope.adData.empl_data.concat(rd);
                        attendanceMemberSev.saveEmplData('', $scope.adData.zone_id, $scope.adData.employee_no_list);
                    }
                }
            });
        };

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            // $ionicPlatform.onHardwareBackButton($scope.back);
            $rootScope.removeEventGlobalBack();
            $scope.deregister = $ionicPlatform.registerBackButtonAction(
                $scope.PhysBack, 100
            );


        });

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后
            // alert($ionicHistory.currentView().url);

            $setstatusBar.black();

            $rootScope.showLoading();


            attendanceMemberSev.loadData().then(function () {
                $scope.adData = attendanceMemberSev.getData();
                $scope.pagingConfig = attendanceMemberSev.getPagingConfig();
                $scope.searchPagingConfig = attendanceMemberSev.getSearchPagingConfig();

                $scope.inputFingerData = attendanceMemberSev.getInputFingerData();

                attendanceMemberSev.set_flag(false);
            });

        });

        $scope.$on("$ionicView.beforeLeave", function (event, data) {
            //离开之前
            // $ionicPlatform.offHardwareBackButton($scope.back);

        });


    })


    .controller('menulistCtrl', function ($scope, menulistService, $stateParams, $rootScope, $location, aiDeviceSev, $setstatusBar, $ionicScrollDelegate, $timeout, tripApplyForSev, $ionicHistory) {

        $scope.back = function () {
            $ionicHistory.goBack();
        };

        $scope.$on("$ionicView.afterEnter", function (event, data) {
            //进入之后

            $setstatusBar.white();
        });

        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            //进入之前
            $timeout(function () {
                $("ion-view[ng-controller='menulistCtrl'] ion-content")[0].style.top = "";
            }, 0);


        });



        $scope.model_title = $stateParams.menu_name;
        menulistService.clearData();

        if (window.localStorage["menu_" + $stateParams.menu_key] != null && typeof (window.localStorage["menu_" + $stateParams.menu_key]) != 'undefined' && window.localStorage["menu_" + $stateParams.menu_key] != '') {
            menulistService.setModelList($.parseJSON(window.localStorage["menu_" + $stateParams.menu_key]));
            $scope.model_list = menulistService.getModelList();
            $rootScope.hideLoading();
        } else {
            menulistService.loadModelList($stateParams.menu_key);
            $scope.model_list = menulistService.getModelList();
        }

        $scope.refreshData = function () {
            menulistService.refreshData($stateParams.menu_key, $scope);
        }

        $scope.redirectPage = function (menu_key) {
            if (menu_key == 'staff_master') {
                fufuMobclickAgent('menu_staff_master');
            } else if (menu_key == 'employee_contract') {
                fufuMobclickAgent('menu_employee_contract');
            } else if (menu_key == 'at_empl_card_rec') {
                fufuMobclickAgent('menu_at_empl_card_rec');
            } else if (menu_key == 'my_leave_balance') {
                fufuMobclickAgent('menu_my_leave_balance');
            } else if (menu_key == 'pay_slip') {
                fufuMobclickAgent('menu_pay_slip');
            } else if (menu_key == 'at_team_record') {
                fufuMobclickAgent('menu_at_team_record');
            } else if (menu_key == 'leave_team_record') {
                fufuMobclickAgent('menu_leave_team_record');
            } else if (menu_key == 'outdoor_team_record') {
                fufuMobclickAgent('menu_outdoor_team_record');
            } else if (menu_key == 'leave_balance_team_record') {
                fufuMobclickAgent('menu_leave_balance_team_record');
            } else if (menu_key == 'ot_team_record') {
                fufuMobclickAgent('menu_ot_team_record');
            } else if (menu_key == 'customer_info') {
                fufuMobclickAgent('menu_customer_info');
            }
            if (menu_key == "ai_device") {
                aiDeviceSev.setRegionId(null);
            }

            if (menu_key == "ai_device") {
                $location.path('home_page/home_menulist/ai_device/0');
            } else {
                if (menu_key == 'my_visitor') {
                    $location.path('home_page/home_menulist/' + menu_key + "/" + "0");

                    // access shift group 
                    //$location.path('home_page/home_menulist/access_shift_group');
                } else {
                    if (menu_key == "business_trip_apply") {
                        //必须清除数据
                        tripApplyForSev.clearData();
                        tripApplyForSev.setState(true);
                        // $location.path('home_page/home_menulist/business_trip_apply/add/0/0/0');
                        $ionicHistory.clearCache().then(function(){

                            $location.path('home_page/home_menulist/business_trip_apply');
                        });
                        tripApplyForSev.setOpt('add', 0, 0, 0);
                        // tripApplyForSev.setOpt('edit', $stateParams.p_inst, $stateParams.show_type, $stateParams.task_id);
                        // $location.path('home_page/home_menulist/business_trip_apply/edit/2809/1/my_apply');

                    } else {
                        $location.path('home_page/home_menulist/' + menu_key);
                    }


                }
            }

        }

        $scope.local_resource = local_resource;

    })
    .controller('staffMsCtrl', function ($scope, $ionicPopover, $ionicListDelegate, $ionicPlatform, staffService, $filter, $location, $ionicPopup) {
        $scope.img_empl_on_the_job_staff = local_resource + 'img/icon/empl_on_the_job_staff.png';
        $scope.empl_change_a_salary = local_resource + 'img/icon/empl_change-a-salary@2x.png';
        $scope.empl_scheduling = local_resource + 'img/icon/empl_scheduling@2x.png';
        $scope.empl_wages = local_resource + 'img/icon/empl_wages@2x.png';
        $scope.empl_on_the_job_staff = local_resource + 'img/icon/empl_on_the_job_staff.png';
        $scope.empl_post_this_month = local_resource + 'img/icon/empl_post_this_month.png';
        $scope.empl_leave_this_month = local_resource + 'img/icon/empl_leave_this_month.png';
        $scope.empl_leave_employee = local_resource + 'img/icon/empl_leave_employee.png';
        $scope.empl_all_staff = local_resource + 'img/icon/empl_all_staff.png';
        $scope.employee_resign_terminated = local_resource + 'img/icon/employee_resign_terminated.png';
        $scope.employee_resign_pending = local_resource + 'img/icon/employee_resign_pending.png';
        $scope.icon_filter = local_resource + 'img/icon/icon_filter.png';

        $scope._flag = "1";

        $scope.search_control = {};
        $scope.search_control.search_val = '';

        staffService.clearData();
        staffService.loadStaffMasterList();
        $scope.staff_data = staffService.getStaffMasterList();

        $scope.filterStaff = function (_flag, _title) {
            $scope._flag = _flag;
            $scope.staff_data.title = _title;
            $scope.closePopover();
        }

        $scope.loadStaffDetails = function (employee_no, param) {
            if (employee_no == 'empl_at_roster') {
                var _date = new Date();
                var _month = _date.getMonth() + 1;
                var _day = _date.getDate();
                $location.path("home_page/staff_master/" + employee_no + "/" + param + "/" + (_date.getFullYear() + "-" + (_month <= 9 ? "0" + _month : _month) + "-" + (_day <= 9 ? "0" + _day : _day)));
            } else if (employee_no == 'empl_payroll_adjust' || employee_no == 'empl_payroll_master') {
                $location.path("home_page/staff_master/" + employee_no + "/" + param);
            } else {
                $location.path("home_page/home_menulist/staff_master/" + employee_no);
            }
            $ionicListDelegate.closeOptionButtons();
        }

        $scope.closeOptions = function () {
            $ionicListDelegate.closeOptionButtons();
        };
        $ionicPopover.fromTemplateUrl("staff-master-popover.html", {
                scope: $scope
            })
            .then(function (popover) {
                $scope.popover = popover;
            })

        $scope.openPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };
        //销毁事件回调处理：清理popover对象
        $scope.$on("$destroy", function () {
            $scope.popover.remove();
        });
    })
    .controller('staffMsDetailCtrl', function ($scope, staffMsDetailSev, $stateParams, $location, $timeout, $ionicActionSheet, timeSelect, sideSelect, $selectDepartments) {
        $scope.edit_data_01 = local_resource + 'img/icon/edit_data_01.png';
        var selectDepartmentModal;
        var selectPositionModal;
        staffMsDetailSev.clearData();
        staffMsDetailSev.loadStaffMsDetails($stateParams.employee_no);
        $scope.staff_master_details = staffMsDetailSev.getStaffMsDetails();
        $scope.saveStaffDetails = function () {
            staffMsDetailSev.saveStaffDetails();
        }
        $scope.id_type = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.id_type_data,
                selectIndex: $scope.staff_master_details.id_type_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("id_type").innerHTML = $scope.staff_master_details.id_type_data[index].value;
                        $scope.staff_master_details.id_type_data_key = $scope.staff_master_details.id_type_data[index].key;
                        $scope.staff_master_details.id_type_index = index;
                    }

                }
            });
        }
        $scope.gender = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.gender_data,
                selectIndex: $scope.staff_master_details.gender_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("gender").innerHTML = $scope.staff_master_details.gender_data[index].value;
                        $scope.staff_master_details.gender_data_key = $scope.staff_master_details.gender_data[index].key;
                        $scope.staff_master_details.gender_index = index;
                    }
                }
            });
        }
        $scope.nationality = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.nationality_data,
                selectIndex: $scope.staff_master_details.nationality_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("nationality").innerHTML = $scope.staff_master_details.nationality_data[index].value;
                        $scope.staff_master_details.nationality_data_key = $scope.staff_master_details.nationality_data[index].key;
                        $scope.staff_master_details.nationality_index = index;
                    }
                }
            });
        }

        $scope.race = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.race_data,
                selectIndex: $scope.staff_master_details.race_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("race").innerHTML = $scope.staff_master_details.race_data[index].value;
                        $scope.staff_master_details.race_data_key = $scope.staff_master_details.race_data[index].key;
                        $scope.staff_master_details.race_index = index;
                    }
                }
            });
        }


        $scope.education_level = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.education_level_data,
                selectIndex: $scope.staff_master_details.education_level_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("education_level").innerHTML = $scope.staff_master_details.education_level_data[index].value;
                        $scope.staff_master_details.education_level_data_key = $scope.staff_master_details.education_level_data[index].key;
                        $scope.education_level_index = index;
                    }
                }
            });
        }
        $scope.showDate_join_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.staff_master_details.join_date,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.staff_master_details.join_date = date;

                    }
                }
            })
        }

        $scope.showDate_p_c_d = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.staff_master_details.p_c_d,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.staff_master_details.p_c_d = date;

                    }
                }
            })
        }

        $scope.date_of_birth = function () {
            var current_date = new Date();
            var month = current_date.getMonth() + 1;
            var day = current_date.getDate();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 50;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10);
            //endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: endDate + "-" + month + "-" + day,
                defaultDate: $scope.staff_master_details.date_of_birth,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.staff_master_details.date_of_birth = date;

                    }
                }
            })
        }
        document.getElementById('employee_name_img').onclick = function (e) {
            document.getElementById('employee_name_img').style.display = 'none';
            document.getElementById('employee_name_span').style.display = 'none';
            document.getElementById('employee_name_input').style.display = 'block';
            $timeout(function () {
                e.preventDefault();
                e.stopPropagation();
                document.getElementById('employee_name_input').focus();
            }, 0);
        }

        document.getElementById('employee_name_input').onblur = function () {
            document.getElementById('employee_name_img').style.display = '';
            document.getElementById('employee_name_span').style.display = '';
            document.getElementById('employee_name_span').innerHTML = document.getElementById('employee_name_input').value;
            document.getElementById('employee_name_input').style.display = 'none';
        }

        /*
        $scope.picklist_department = function(){
        	staffMsDetailSev.loadDepartmentTreeData();
        	selectDepartmentModal = $selectDepartments.init({
        		title : '请选择部门:',
        		barTitle : '选择部门',
        		isAllSelect : false, //是否有全选
        		isSearch : false, //是否有搜索
        		isSingleSelect:true, //单选模式
        		extName:'部门', //选中tips
        		data : staffMsDetailSev.getDepartmentTreeData(), //装载初始化数据
        		sure : function (selectData) {
        			console.log(selectData);
        		}
        	});
        	selectDepartmentModal.show();
        }

        $scope.picklist_position = function(){
        	staffMsDetailSev.loadPositionTreeData();
        	selectPositionModal = $selectDepartments.init({
        		title : '请选择职位:',
        		barTitle : '选择职位',
        		isAllSelect : false, //是否有全选
        		isSearch : false, //是否有搜索
        		isSingleSelect:true, //单选模式
        		extName:'部门', //选中tips
        		data : staffMsDetailSev.getPositionTreeData(), //装载初始化数据
        		sure : function (selectData) {
        			console.log(selectData);
        		}
        	});
        	selectPositionModal.show();
        }
        */


        $scope.picklist_position = function () {
            //$location.path('home_page/home_menulist/staff_master_position_tree_picklist/' + $("#o_n_i").val() + '/' + $("#dept_name_div").html() + '/' + $("#p_n_i").val() + '/' + $("#position_name_div").html() + '/' + 'staff_master');
            // use this temporary until apple approve newest app with tree plugin include
            $location.path('home_page/home_menulist/temp_staff_master_position_picklist/' + $("#o_n_i").val() + '/' + $("#dept_name_div").html() + '/' + $("#p_n_i").val() + '/' + $("#position_name_div").html());
        }


        $scope.change_photo = function () {
            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {


						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$('#staff_master_details_employee_photo').attr("src", uri);
										staffMsDetailSev.saveStaffPhoto($stateParams.employee_no);
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
									
									$('#staff_master_details_employee_photo').attr("src", data.uri);
									staffMsDetailSev.saveStaffPhoto($stateParams.employee_no);
								});
							} catch(e){
								
							}
							
						}







                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$('#staff_master_details_employee_photo').attr("src", uri);
										staffMsDetailSev.saveStaffPhoto($stateParams.employee_no);
									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
									
										$('#staff_master_details_employee_photo').attr("src", data.uri);
										staffMsDetailSev.saveStaffPhoto($stateParams.employee_no);
								});
							} catch(e){
								
							}	
							
						}
						


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
             $timeout(function() {
             hideSheet();
             }, 2000);
             */

        }
    })

    .controller('emplAtRosterCtrl', function ($scope, emplArSev, $stateParams, timeSelect, sideSelect) {
        /*Sunny改*/

        $scope.dot_abnormal = local_resource + 'img/icon/dot_abnormal.png';
        $scope.dot_normal = local_resource + 'img/icon/dot_normal.png';
        $scope.Legal_holiday = local_resource + 'img/icon/Legal_holiday.png';
        $scope.other_holiday = local_resource + 'img/icon/other_holiday.png';
        /*Sunny改*/
        var obj = $("#roster_date");
        obj.val($stateParams.curr_date);
        document.getElementById('roster_date_').innerHTML = $stateParams.curr_date;
        emplArSev.clearData();
        emplArSev.loadArData(obj.val(), $stateParams.employee_no);
        $scope.empl_ar_data = emplArSev.getArData();

        $scope.roster_date_ = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-01-01',
                defaultDate: document.getElementById("roster_date_").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("roster_date_").innerHTML = date;
                        obj.val(date);
                        emplArSev.loadArData(obj.val(), $stateParams.employee_no);
                    }
                }
            })
        }

        $scope.roster_policy = function () {

            sideSelect.show({
                type: 'ios',
                data: $scope.empl_ar_data.roster_policy_data,
                selectIndex: $scope.empl_ar_data.roster_policy_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("roster_policy").innerHTML = $scope.empl_ar_data.roster_policy_data[index].value;
                        $scope.empl_ar_data.roster_policy_data_key = $scope.empl_ar_data.roster_policy_data[index].key;
                        $scope.empl_ar_data.current_roster.roster_policy = $scope.empl_ar_data.roster_policy_data[index].key;
                        $scope.empl_ar_data.roster_policy_index = index;
                        emplArSev.lArByPolicy($scope.empl_ar_data.roster_policy_data[index].value);
                    }
                }
            });
        }
        obj.change(function () {
            emplArSev.loadArData(obj.val(), $stateParams.employee_no);
        });
        $scope.reArData = function (_flag) {
            if (_flag == 'c') {} else {
                var arr = (obj.val()).split('-');
                var year = arr[0];
                var month = arr[1];
                var day = arr[2];
                var days = new Date(year, month, 0);
                days = days.getDate();
                var year2 = year;
                if (_flag == 'p') {
                    var month2 = parseInt(month) - 1;
                    if (month2 == 0) {
                        year2 = parseInt(year2) - 1;
                        month2 = 12;
                    }
                } else {
                    var month2 = parseInt(month) + 1;
                    if (month2 == 13) {
                        year2 = parseInt(year2) + 1;
                        month2 = 1;
                    }
                }
                var day2 = day;
                var days2 = new Date(year2, month2, 0);
                days2 = days2.getDate();
                if (day2 > days2) {
                    day2 = days2;
                }
                if (month2 < 10) {
                    month2 = '0' + month2;
                }
                obj.val(year2 + '-' + month2 + '-' + day2);
                document.getElementById('roster_date_').innerHTML = year2 + '-' + month2 + '-' + day2;
            }
            emplArSev.loadArData(obj.val(), $stateParams.employee_no);
        }

        $scope.loadCurrentAr = function (_day, curobj) {
            if (_day == '') return;
            $("._ar_c").removeClass("_ar_c");
            $(curobj.currentTarget).addClass("_ar_c");
            var _day = parseInt(_day);
            var arr = (obj.val()).split('-');
            if (_day < 10) {
                _day = '0' + _day;
            }
            obj.val(arr[0] + '-' + arr[1] + '-' + _day);
            document.getElementById('roster_date_').innerHTML = arr[0] + '-' + arr[1] + '-' + _day;
            emplArSev.lArByDate(obj.val(), $stateParams.employee_no);
        }

        $scope.lArByPolicy = function () {
            emplArSev.lArByPolicy($scope.empl_ar_data.current_roster.roster_policy);
        }

        $scope.saveEmplAr = function () {
            emplArSev.saveEmplAr(obj.val(), $stateParams.employee_no, $scope.empl_ar_data.current_roster.roster_policy, $stateParams.curr_date);
        }

        $scope.deleteEmplAr = function () {
            emplArSev.deleteEmplAr(obj.val(), $stateParams.employee_no);
        }
    })

    .controller('padjCtrl', function ($scope, padjSev, $stateParams, timeSelect) {
        padjSev.clearData();
        padjSev.loadPadjData($stateParams.employee_no);
        $scope.padj_data = padjSev.getPadjData();
        $scope.savePadjData = function () {
            padjSev.savePadjData($stateParams.employee_no);
        }

        $scope.padj_eff_date = function () {
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.padj_data.eff_date,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.padj_data.eff_date = date;

                    }
                }
            })
        }

    })
    .controller('pMsCtrl', function ($scope, pMsSev, $stateParams) {
        pMsSev.clearData();
        pMsSev.loadPmsData($stateParams.employee_no);
        $scope.pms_data = pMsSev.getPmsData();
        $scope.savePmsData = function () {
            pMsSev.savePmsData($stateParams.employee_no);
        }
    })
    .controller('autoRosCtrl', function ($scope,$rootScope, autoRosSev, timeSelect, $location, $ionicPopup) {
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
        $scope.redirect_to_result = function () {
            $location.path("home_page/auto_roster/at_roster");
            autoRosSev.setProcessStatus('0');
        }

        $scope.close_process_div = function () {
            autoRosSev.setProcessStatus('0');
        }

        $scope.process_status = autoRosSev.getProcessStatus();
        document.getElementById('auto_roster_task_in_process_div').style.display = 'block';
        document.getElementById('auto_roster_task_complete_div').style.display = 'block';

        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_task_in_process_icon = local_resource + 'img/icon/task_in_process.png';
        $scope.img_task_complete_icon = local_resource + 'img/icon/task_complete.png';
        $scope.img_task_close = local_resource + 'img/icon/task_close.png';

        $scope.dates_line = local_resource + 'img/model/dates-line2x.png';

        var c_d = new Date();
        var _y = c_d.getFullYear();
        var _t_m = c_d.getMonth() + 1;
        var _m = _t_m <= 9 ? '0' + _t_m : _t_m;
        document.getElementById("au_ros_f").innerHTML = _y + '-' + _m + '-01';
        document.getElementById("au_ros_t").innerHTML = _y + '-' + _m + '-' + (c_d.getDate() <= 9 ? '0' + c_d.getDate() : c_d.getDate());
        //$("#au_ros_t").val(_y+'-'+_m+'-'+(c_d.getDate()<=9?'0'+c_d.getDate():c_d.getDate()));
        $scope.ros_overwrite = false;
        $scope.check_all = false;
        $scope.au_ros_f = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("au_ros_f").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("au_ros_f").innerHTML = date;
                    }
                }
            })
        }

        $scope.au_ros_t = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("au_ros_t").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("au_ros_t").innerHTML = date;
                    }
                }
            })
        }


        $scope.runRoster = function () {
            var flag = $scope.ros_overwrite == true ? 1 : 0;
            var _ck_all = $scope.check_all == true ? 1 : 0;

            if (!_ck_all && $("#auto_ros_empl_list_hidden").val() == '') {
                window.fufuMessageBox('请选择员工', fufu_message_box_duration, function () {});
                return;
            }

            $ionicPopup.confirm({
                title: '',
                template: '<div style="overflow:hidden;border-radius:10px;padding-left:0px !important;padding-right:0px !important;"><div style="width:7.2rem;height:4.66666666666rem;"><img src=' + local_resource + "img/icon/task_in_process_image.png" + ' alt="" style="width:100%;height:4.66666667rem;"/></div> <div style="padding:20px;color:#000;font-size:0.4266666667rem;padding-bottom:0px;line-height:150%;">该操作比较耗时，请确认继续进行，确认后您可执行其他操作，待系统计算后会以消息告知对班结果。</div></div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                cssClass: 'auto_roster_popup',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    autoRosSev.runRoster($("#auto_ros_empl_list_hidden").val(), document.getElementById("au_ros_f").innerHTML, document.getElementById("au_ros_t").innerHTML, flag, _ck_all);
                }
            });


        }

    })
    .controller('modalEmplCtrl', function ($scope, modalEmplSev, $ionicHistory, $stateParams, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        modalEmplSev.clearData();
        modalEmplSev.loadEmplList($stateParams.hidden_id);
        $scope.empl_list = modalEmplSev.getEmplList();
        //var str = $("#"+$stateParams.source_id).val();
        // $scope.selCt=0;
        //if(str != '' && str.length != 0){
        //  $scope.selCt=(str.split(',')).length;
        //}
        /*
            $scope.closeModal = function(){
              $ionicHistory.goBack();
            }
            $scope.ckItem = function(_flag){
              if(_flag == true){
                $scope.selCt =  $scope.selCt + 1;
              }else{
                $scope.selCt =  $scope.selCt - 1;
              }
            }
            $scope.rtAction = function(){
              var data = $scope.empl_list;
              var _empl_list='';
              var _staff_no_list='';
              for(var i=0;i<data.length;i++){
                if(data[i].ck==true){
                  _empl_list = _empl_list + data[i].en+',';
                  _staff_no_list = _staff_no_list + data[i].emp+',';
                }
              }
              $("#"+$stateParams.source_id).val(_empl_list.substring(0,_empl_list.length-1));
              $("#"+$stateParams.hidden_id).val(_staff_no_list.substring(0,_staff_no_list.length-1));
              $ionicHistory.goBack();
            }
        	*/
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.empl_list.total_checked++;
            } else {
                $scope.empl_list.total_checked--;
            }
            $scope.empl_list.show_footer_bar = true;

            if ($scope.empl_list.total_checked == $scope.empl_list.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            $scope.empl_list.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.empl_list.total_checked = $scope.empl_list.length;
            $scope.empl_list.show_footer_bar = true;
            for (var i = 0; i < $scope.empl_list.length; i++) {
                $scope.empl_list[i].ck = true;
            }
        }
        $scope.select_all_employee_cancel = function () {
            //$scope.all_selected = false;
            $scope.empl_list.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.empl_list.total_checked = 0;

            for (var i = 0; i < $scope.empl_list.length; i++) {
                $scope.empl_list[i].ck = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.cancel = function () {
            var employee_list = $("#" + $stateParams.hidden_id).val();
            var temp_total_checked = 0;
            //alert(employee_list);
            var SelectData_data = $scope.empl_list;
            employee_list = employee_list + ",";
            for (var i = 0; i < SelectData_data.length; i++) {
                if (employee_list.indexOf(SelectData_data[i].emp + ",") == -1) {
                    SelectData_data[i].ck = false;
                } else {
                    SelectData_data[i].ck = true;
                    temp_total_checked++;
                }
            }
            $scope.empl_list = SelectData_data;
            $scope.empl_list.show_footer_bar = false;
            $scope.empl_list.total_checked = temp_total_checked;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.shift_group_edit_employee_select_save = function () {
            var _empl_list = '';
            var _staff_no_list = '';
            for (var i = 0; i < $scope.empl_list.length; i++) {
                if ($scope.empl_list[i].ck == true) {
                    _empl_list = _empl_list + $scope.empl_list[i].en + ',';
                    _staff_no_list = _staff_no_list + $scope.empl_list[i].emp + ',';
                }
            }

            $("#" + $stateParams.source_id).val(_empl_list.substring(0, _empl_list.length - 1));
            $("#" + $stateParams.hidden_id).val(_staff_no_list.substring(0, _staff_no_list.length - 1));

            // $("#shift_group_edit_empl_list").val(_empl_list.substring(0,_empl_list.length-1));
            //$("#shift_group_edit_empl_list_hidden").val(_staff_no_list.substring(0,_staff_no_list.length-1));
            $ionicHistory.goBack();
        }
    })
    .controller('atRosCtrl', function ($scope, atRosSev, $ionicPopover, $location, timeSelect) {
        /*Sunny*/
        $scope.at_the_scheduled = local_resource + 'img/icon/at_the_scheduled@2x.png';
        $scope.at_not_scheduling = local_resource + 'img/icon/at_not_scheduling@2x.png';
        $scope.at_abnormal_class = local_resource + 'img/icon/at_abnormal_class@2x.png';
        $scope.at_all_scheduling = local_resource + 'img/icon/at_all_scheduling@2x.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        /*Sunny*/
        $scope.icon_filter = local_resource + 'img/icon/icon_filter.png';
        var d_obj = $("#at_roster_1");
        d_obj.change(function () {
            atRosSev.loadAtRosData(d_obj.val(), '0');
        })


        $scope.reAtRosData = function (_flag) {
            atRosSev.loadAtRosData(d_obj.val(), _flag);
        }

        $scope.loadEmplRoster = function (empl_no) {
            $location.path("home_page/staff_master/empl_at_roster/" + empl_no + "/" + d_obj.val());
        }
        $scope.at_roster_ = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("at_roster_").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("at_roster_").innerHTML = date;
                        d_obj.val(date);
                        atRosSev.loadAtRosData(d_obj.val(), '0');
                    }
                }
            })
        }

        $scope.search_val = "";
        $scope._flag = "";

        atRosSev.clearData();
        atRosSev.loadAtRosData(d_obj.val(), '0');
        $scope.at_ros_data = atRosSev.getAtRosData();
        $scope.filterStaff = function (_flag) {
            $scope._flag = _flag;
            $scope.closePopover();
        }

        $scope.closeOptions = function () {
            $ionicListDelegate.closeOptionButtons();
        };
        $ionicPopover.fromTemplateUrl("roster-result-popover.html", {
                scope: $scope
            })
            .then(function (popover) {
                $scope.popover = popover;
            })

        $scope.openPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };
        //销毁事件回调处理：清理popover对象
        $scope.$on("$destroy", function () {
            $scope.popover.remove();
        });
    })
    .controller('atAnalyCtrl', function ($scope, atAnalySev, timeSelect, $ionicPopup, $location) {
        $scope.redirect_to_result = function () {
            $location.path('home_page/home_menulist/at_result');
            atAnalySev.setProcessStatus('0');
        }

        $scope.close_process_div = function () {
            atAnalySev.setProcessStatus('0');
        }

        $scope.process_status = atAnalySev.getProcessStatus();
        document.getElementById('at_task_in_process_div').style.display = 'block';
        document.getElementById('at_task_complete_div').style.display = 'block';

        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_task_in_process_icon = local_resource + 'img/icon/task_in_process.png';
        $scope.img_task_complete_icon = local_resource + 'img/icon/task_complete.png';
        $scope.img_task_close = local_resource + 'img/icon/task_close.png';


        $scope.dates_line = local_resource + 'img/model/dates-line2x.png';
        var c_d = new Date();
        var _y = c_d.getFullYear();
        var _t_m = c_d.getMonth() + 1;
        var _m = _t_m <= 9 ? '0' + _t_m : _t_m;
        document.getElementById("at_analysis_f").innerHTML = _y + '-' + _m + '-01';
        document.getElementById("at_analysis_t").innerHTML = _y + '-' + _m + '-' + (c_d.getDate() <= 9 ? '0' + c_d.getDate() : c_d.getDate());
        $scope.check_all = false;
        $scope.at_analysis_f = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("at_analysis_f").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("at_analysis_f").innerHTML = date;
                    }
                }
            })
        }

        $scope.at_analysis_t = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("at_analysis_t").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("at_analysis_t").innerHTML = date;
                    }
                }
            })
        }

        $scope.runAnalysis = function () {
            var _ck_all = $scope.check_all == true ? 1 : 0;

            if (!_ck_all && $("#at_analysis_empl_list_hidden").val() == '') {
                window.fufuMessageBox('请选择员工', fufu_message_box_duration, function () {});
                return;
            }


            $ionicPopup.confirm({
                title: '',
                template: '<div style="overflow:hidden;border-radius:10px;padding-left:0px !important;padding-right:0px !important;"><div style="width:7.2rem;height:4.66666666666rem;"><img src=' + local_resource + "img/icon/task_in_process_image.png" + ' alt="" style="width:100%;height:4.66666667rem;"/></div> <div style="padding:20px;color:#000;font-size:0.4266666667rem;padding-bottom:0px;line-height:150%;">该操作比较耗时，请确认继续进行，确认后您可执行其他操作，待系统计算后会以消息告知计算结果。</div></div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                cssClass: 'at_cal_popup',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    atAnalySev.runAnalysis($("#at_analysis_empl_list_hidden").val(), document.getElementById("at_analysis_f").innerHTML, document.getElementById("at_analysis_t").innerHTML, _ck_all);
                }
            });
        }
    })
    .controller('atResultCtrl', function ($scope, atResultSev, $location, timeSelect) {
        var d_obj = $("#at_result_1");

        d_obj.change(function () {
            atResultSev.loadAtResultData(d_obj.val(), '0');
        })
        $scope.loadAtEmplDetail = function (empl_no) {
            $location.path("home_page/at_empl_detail/" + empl_no + "/" + d_obj.val());
        }
        $scope.reAtResultData = function (_flag) {
            atResultSev.loadAtResultData(d_obj.val(), _flag);
        }
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        atResultSev.clearData();
        atResultSev.loadAtResultData(d_obj.val(), '0');
        $scope.at_result_data = atResultSev.getAtResultData();

        $scope.at_result_2 = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("at_result_2").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("at_result_2").innerHTML = date;
                        d_obj.val(date);
                        atResultSev.loadAtResultData(d_obj.val(), '0');
                    }
                }
            })
        }

    })
    .controller('atEmplDetailCtrl', function ($scope, atEmplDetailSev, $stateParams, $ionicModal) {
        var d_obj = $("#at_empl_detail_1");
        d_obj.val($stateParams.curr_date);
        d_obj.change(function () {
            atEmplDetailSev.loadAtDetailData($stateParams.empl_no, d_obj.val(), 0);
        });
        atEmplDetailSev.clearData();
        atEmplDetailSev.loadAtDetailData($stateParams.empl_no, $stateParams.curr_date, 0);
        $scope.at_empl_detail_data = atEmplDetailSev.getAtDetailData();
        $scope.reAtDetailData = function (_flag) {
            atEmplDetailSev.loadAtDetailData($stateParams.empl_no, d_obj.val(), _flag);
        }
        $scope.reAtAnalysis = function () {
            atEmplDetailSev.reAtAnalysis($stateParams.empl_no, d_obj.val());
        }

        $ionicModal.fromTemplateUrl('at-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.modal.show();
            if (angular.isDefined($scope.at_empl_detail_data.daily_rec)) {
                var data = $scope.at_empl_detail_data.daily_rec;
                for (var i = 0; i < data.length; i++) {
                    $("#at_from_" + i).val(data[i].from);
                    $("#at_to_" + i).val(data[i].to);
                }
            }
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
        // 当隐藏的模型时执行动作
        $scope.$on('modal.hide', function () {
            // 执行动作
        });
        // 当移动模型时执行动作
        $scope.$on('modal.removed', function () {
            // 执行动作
        });
    })
    .controller('payrollCalCtrl', function ($scope, payrollCalSev, timeSelect, $ionicPopup, $location, sideSelect) {
        payrollCalSev.loadData();
        $scope.pay_roll_data = payrollCalSev.getData();

        $scope.pay_terms_picklist = function () {
            if ($scope.pay_roll_data.pay_terms_id == '0' || $scope.pay_roll_data.pay_terms == '') {
                window.fufuMessageBox('没有薪资帐套', fufu_message_box_duration, function () {});
                return;
            }
            sideSelect.show({
                type: 'ios',
                data: $scope.pay_roll_data.pay_terms_picklist,
                selectIndex: $scope.pay_roll_data.pay_pay_terms_picklist_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        if (index == $scope.pay_roll_data.pay_pay_terms_picklist_index) {
                            return;
                        }

                        $('#payroll_cal_empl_list').val('');
                        $('#payroll_cal_empl_list_hidden').val('');

                        $scope.pay_roll_data.pay_pay_terms_picklist_index = index;
                        $scope.pay_roll_data.pay_terms = $scope.pay_roll_data.pay_terms_picklist[index].value;
                        $scope.pay_roll_data.pay_terms_id = $scope.pay_roll_data.pay_terms_picklist[index].key;

                        $scope.pay_roll_data.pay_date_picklist = [];
                        $scope.pay_roll_data.pay_date_picklist_index = 0;
                        $scope.pay_roll_data.pay_date_key = $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start + '///' + $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_end;
                        $scope.pay_roll_data.pay_date_value = $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start.split('-')[0] + '-' + $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start.split('-')[1];
                        $scope.pay_roll_data.pay_date_picklist.push({
                            "key": $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start + '///' + $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_end,
                            "value": $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start.split('-')[0] + '-' + $scope.pay_roll_data.pay_terms_str[index].pay_date[0].pay_start.split('-')[1]
                        });
                        $scope.pay_roll_data.pay_date_picklist.push({
                            "key": $scope.pay_roll_data.pay_terms_str[index].pay_date[1].pay_start + '///' + $scope.pay_roll_data.pay_terms_str[index].pay_date[1].pay_end,
                            "value": $scope.pay_roll_data.pay_terms_str[index].pay_date[1].pay_start.split('-')[0] + '-' + $scope.pay_roll_data.pay_terms_str[index].pay_date[1].pay_start.split('-')[1]
                        });
                    }
                }
            });
        }

        $scope.pay_date_picklist = function () {
            if ($scope.pay_roll_data.pay_terms_id == '0' || $scope.pay_roll_data.pay_terms == '') {
                window.fufuMessageBox('没有薪资帐套', fufu_message_box_duration, function () {});
                return;
            }
            sideSelect.show({
                type: 'ios',
                data: $scope.pay_roll_data.pay_date_picklist,
                selectIndex: $scope.pay_roll_data.pay_date_picklist_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.pay_roll_data.pay_date_picklist_index = index;
                        $scope.pay_roll_data.pay_date_value = $scope.pay_roll_data.pay_date_picklist[index].value;
                        $scope.pay_roll_data.pay_date_key = $scope.pay_roll_data.pay_date_picklist[index].key;
                    }
                }
            });

        }

        $scope.redirect_to_result = function () {
            $location.path('home_page/home_menulist/payroll_result');
            payrollCalSev.setProcessStatus('0');
        }

        $scope.close_process_div = function () {
            payrollCalSev.setProcessStatus('0');
        }

        $scope.process_status = payrollCalSev.getProcessStatus();
        document.getElementById('payroll_task_in_process_div').style.display = 'block';
        document.getElementById('payroll_task_complete_div').style.display = 'block';

        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_task_in_process_icon = local_resource + 'img/icon/task_in_process.png';
        $scope.img_task_complete_icon = local_resource + 'img/icon/task_complete.png';
        $scope.img_task_close = local_resource + 'img/icon/task_close.png';

        var c_d = new Date();
        var _y = c_d.getFullYear();
        var _t_m = c_d.getMonth() + 1;
        var _m = _t_m <= 9 ? '0' + _t_m : _t_m;
        document.getElementById("payroll_cal_f").innerHTML = _y + '-' + _m + '-01';
        document.getElementById("payroll_cal_t").innerHTML = _y + '-' + _m + '-' + (c_d.getDate() <= 9 ? '0' + c_d.getDate() : c_d.getDate());
        $scope.check_all = false;
        $scope.payroll_cal_f = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("payroll_cal_f").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("payroll_cal_f").innerHTML = date;

                    }
                }
            })
        }
        $scope.payroll_cal_t = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("payroll_cal_t").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("payroll_cal_t").innerHTML = date;

                    }
                }
            })
        }



        $scope.runPayrollCal = function () {
            var _ck_all = $scope.check_all == true ? 1 : 0;
            if (!_ck_all && $("#payroll_cal_empl_list_hidden").val() == '') {
                window.fufuMessageBox('请选择员工', fufu_message_box_duration, function () {});
                return;
            }

            $ionicPopup.confirm({
                title: '',
                template: '<div style="overflow:hidden;border-radius:10px;padding-left:0px !important;padding-right:0px !important;"><div style="width:7.2rem;height:4.66666666666rem;"><img src=' + local_resource + "img/icon/task_in_process_image.png" + ' alt="" style="width:100%;height:4.66666667rem;"/></div> <div style="padding:20px;color:#000;font-size:0.4266666667rem;padding-bottom:0px;line-height:150%;">该操作比较耗时，请确认继续进行，确认后您可执行其他操作，待系统计算后会以消息告知计算结果。</div></div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                cssClass: 'payroll_cal_popup',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    payrollCalSev.runPayrollCal($("#payroll_cal_empl_list_hidden").val(), _ck_all);
                }
            });


        }
    })
    .controller('payrollSendCtrl', function ($scope, payrollSendSev) {
        payrollSendSev.clearData();
        payrollSendSev.loadData();
        $scope.pay_send_data = payrollSendSev.getData();

        $scope.sendPayroll = function () {
            payrollSendSev.sendPayroll($scope.pay_send_data.st_date, $scope.pay_send_data.en_date);
        }
    })
    .controller('payrollSlipCtrl', function ($scope, payrollSlipSev, $ionicModal, $ionicScrollDelegate) {
        $scope.payroll_slip_bg = local_resource + 'img/icon/payroll_slip_bg.png';
        $scope.pryroll_delete = local_resource + 'img/icon/pryroll_delete.png';

        $scope.current_password = '';
        $scope.retype_password = '';
        if (ionic.Platform.isIOS()) {
            payrollSlipSev.clearData();
            payrollSlipSev.loadData(0, '');
            $scope.pay_slip_data = payrollSlipSev.getData();

        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                payrollSlipSev.clearData();
                payrollSlipSev.loadData(0, '');
                $scope.pay_slip_data = payrollSlipSev.getData();
            });
        }

        if (ionic.Platform.isIOS()) {

            $scope.wrap_height = parseInt(window.innerHeight) - 64;
            $scope.top_height = (parseInt(window.innerHeight) - 64) * 0.3185;
            $scope.bottom_height = (parseInt(window.innerHeight) - 64) * 0.33;
            $scope.bottom_content_height = (parseInt(window.innerHeight) - 64) * 0.33 / 4;
            $scope.img_height = (parseInt(window.innerHeight) - 64) * 0.1171 * 2;
            $scope.img_width = (parseInt(window.innerHeight) - 64) * 0.1171 * 1.0196 * 2;
        } else {
            $scope.wrap_height = parseInt(window.innerHeight) - 44;
            $scope.top_height = (parseInt(window.innerHeight) - 44) * 0.3185;
            $scope.bottom_height = (parseInt(window.innerHeight) - 44) * 0.33;
            $scope.bottom_content_height = (parseInt(window.innerHeight) - 44) * 0.33 / 4;
            $scope.img_height = (parseInt(window.innerHeight) - 44) * 0.1171 * 2;
            $scope.img_width = (parseInt(window.innerHeight) - 44) * 0.1171 * 1.0196 * 2;
        }
        $scope.img_margin_height = ($scope.top_height - $scope.img_height) / 2;



        $scope.reloadData = function (_flag) {
            payrollSlipSev.loadData(_flag, $scope.pay_slip_data.data1.date);
        }

        $scope.input_password = function (current_input) {
            if (document.getElementById('payslip_password_setting_text').innerHTML == '设置密码' || document.getElementById('payslip_password_setting_text').innerHTML == '输入密码') {
                if (current_input == 'x') {
                    if ($scope.current_password == '') {
                        return;
                    } else {
                        if ($scope.current_password.length == 1) {
                            document.getElementById('password_char1').style.display = "none";
                        } else if ($scope.current_password.length == 2) {
                            document.getElementById('password_char2').style.display = "none";
                        } else if ($scope.current_password.length == 3) {
                            document.getElementById('password_char3').style.display = "none";
                        }
                        $scope.current_password = $scope.current_password.slice(0, -1);
                    }
                } else {
                    $scope.current_password = $scope.current_password + current_input;
                    if ($scope.current_password.length < 4) {
                        if ($scope.current_password.length == 1) {
                            document.getElementById('password_char1').style.display = "block";
                        } else if ($scope.current_password.length == 2) {
                            document.getElementById('password_char2').style.display = "block";
                        } else if ($scope.current_password.length == 3) {
                            document.getElementById('password_char3').style.display = "block";
                        }
                    } else {
                        document.getElementById('password_char4').style.display = "block";
                        if (document.getElementById('payslip_password_setting_text').innerHTML == '设置密码') {
                            document.getElementById('password_char1').style.display = "none";
                            document.getElementById('password_char2').style.display = "none";
                            document.getElementById('password_char3').style.display = "none";
                            document.getElementById('password_char4').style.display = "none";
                            document.getElementById('payslip_password_setting_text').innerHTML = '再次输入密码';
                        } else if (document.getElementById('payslip_password_setting_text').innerHTML == '输入密码') {
                            payrollSlipSev.payslipVerifyPassword($scope);
                        }
                    }
                }

            } else if (document.getElementById('payslip_password_setting_text').innerHTML == '再次输入密码') {
                if (current_input == 'x') {
                    if ($scope.retype_password == '') {
                        return;
                    } else {
                        if ($scope.retype_password.length == 1) {
                            document.getElementById('password_char1').style.display = "none";
                        } else if ($scope.retype_password.length == 2) {
                            document.getElementById('password_char2').style.display = "none";
                        } else if ($scope.retype_password.length == 3) {
                            document.getElementById('password_char3').style.display = "none";
                        }
                        $scope.retype_password = $scope.retype_password.slice(0, -1);
                    }
                } else {
                    $scope.retype_password = $scope.retype_password + current_input;
                    if ($scope.retype_password.length < 4) {
                        if ($scope.retype_password.length == 1) {
                            document.getElementById('password_char1').style.display = "block";
                        } else if ($scope.retype_password.length == 2) {
                            document.getElementById('password_char2').style.display = "block";
                        } else if ($scope.retype_password.length == 3) {
                            document.getElementById('password_char3').style.display = "block";
                        }
                    } else {
                        document.getElementById('password_char4').style.display = "block";
                        if ($scope.retype_password == $scope.current_password) {

                            payrollSlipSev.payslipSetPassword($scope);
                        } else {
                            window.fufuMessageBox("密码与确认密码不相同", fufu_message_box_duration, function () {});
                            $scope.retype_password = "";
                            document.getElementById('password_char1').style.display = "none";
                            document.getElementById('password_char2').style.display = "none";
                            document.getElementById('password_char3').style.display = "none";
                            document.getElementById('password_char4').style.display = "none";
                        }
                    }
                }
            }
        }
        $scope.reset_password = function () {
            $ionicScrollDelegate.resize();
            $scope.current_password = '';
            $scope.retype_password = '';
            document.getElementById('payroll_slip_reset_password_div').style.display = "none";
            document.getElementById('payslip_password_setting_forgetpwd').style.display = "none";
            document.getElementById('payslip_password_setting_text').innerHTML = '设置密码';
            document.getElementById('password_char1').style.display = "none";
            document.getElementById('password_char2').style.display = "none";
            document.getElementById('password_char3').style.display = "none";
            document.getElementById('password_char4').style.display = "none";
            document.getElementById('payslip_password_setting_div').style.display = 'block';
            document.getElementById('payslip_view_div').style.display = 'none';
        }


        var current_phone_num = window.localStorage['_user_name'];
        $scope.forget_password_phone_num = current_phone_num.substr(0, 3) + '****' + current_phone_num.substr(current_phone_num.length - 4, 4);

        $ionicModal.fromTemplateUrl('payroll_slip_forget_password.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.closeModal = function () {
            $scope.modal.hide();
        };

        $scope.forget_password = function () {
            $scope.modal.show();
        }

        $scope.sendPwdVCode = function () {
            payrollSlipSev.sendPwdVCode($scope);
        }

        $scope.payroll_slip_forget_password_reset_password = function () {
            payrollSlipSev.payroll_slip_forget_password_reset_password($scope);
        }

    })
    .controller('payrollResultCtrl', function ($scope, payrollResultSev, $stateParams, $location) {

        var obj = $('#payroll_result_calendar_date');
        var current_date = new Date();
        current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
        current_date = current_date.toJSON().slice(0, 7);
        obj.val(current_date);
        $scope.current_date_str = obj.val().split('-')[0] + '-' + obj.val().split('-')[1];

        payrollResultSev.clearData();
        payrollResultSev.loadPrResultData('', '0');
        $scope.payroll_result_data = payrollResultSev.getPrResultData();
        $scope.search_control = {};
        $scope.search_control.search_val = "";



        $scope.reloadPrData = function (_f) {
            payrollResultSev.loadPrResultData(obj.val(), _f);
            if (_f == '1') {
                document.getElementById("payroll_result_calendar_date").stepUp(1);
            } else if (_f == '-1') {
                document.getElementById("payroll_result_calendar_date").stepDown(1);
            }
            $scope.current_date_str = obj.val().split('-')[0] + '-' + obj.val().split('-')[1];
        }
        $scope.loadResultPaySlip = function (item, empl_no) {
            $location.path('/home_page/payroll_result_slip/' + empl_no + '/' + item.pay_start + '/' + item.pay_end + '/' + item.pay_terms_id);
        }
    })
    .controller('pResultSlipCtrl', function ($scope, pResultSlipSev, $stateParams) {
        $scope.sd = $stateParams.start_date;
        $scope.ed = $stateParams.end_date;
        $scope.pay_terms_id = $stateParams.pay_terms_id;
        pResultSlipSev.clearData();
        pResultSlipSev.loadData($stateParams.empl_no, $scope.sd, $scope.ed, $scope.pay_terms_id);
        $scope.presult_slip_data = pResultSlipSev.getData();

        $scope.mdyPrSlip = function () {
            var v_list = '';
            var _data = $scope.presult_slip_data.dt;
            for (var i = 0; i < _data.length; i++) {
                v_list = v_list + _data[i].f + ':' + _data[i].v + ',';
            }
            pResultSlipSev.mdyPrSlip($stateParams.empl_no, $scope.sd, $scope.ed, v_list.substring(0, v_list.length - 1));
        }
    })

    .controller('settingUdCtrl', function ($scope, settingUdSev, $ionicModal, $ionicPopup, $rootScope, $timeout, $location) {

        /*Sunny改*/
        $scope.web_end_import = local_resource + 'img/icon/web_end_import.png';
        $scope.address_book_import = local_resource + 'img/icon/address_book_import.png';
        $scope.manually_add = local_resource + 'img/icon/manually_add.png';

        /*Sunny改*/
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        $scope.search_control.c_search_val = "";
        $scope.selCt = 0;
        settingUdSev.clearData();
        settingUdSev.loadUserData();
        $scope.user_data = settingUdSev.getUserData();

        $scope.setting_user_admin_delete = function (username, user_id, index) {


            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    settingUdSev.setting_user_admin_delete(username, user_id, index, $scope.search_control.search_val ? true : false);
                }
            });

        }


        $ionicModal.fromTemplateUrl('import-contacts-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.webImport = function () {
            $location.path('home_page/home_menulist/web_import');
        }

        $scope.closeModal = function () {
            $scope.modal.hide();
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
            $scope.add_modal.remove();
        });

        //$scope.contacts_data = [{name:'JACK.ZHENG',phone:'18682168147',ck:false},{name:'JIN',phone:''},{name:'gary',phone:''}];
        //$scope.contacts_data = [{name:'victor1',phone:'18680391411',ck:false},{name:'victor2',phone:'18680391412'},{name:'victor3',phone:'+86 18680391413'},{name:'victor4',phone:'#18680391414'}];
        $scope.contacts_data = [];
        //settingUdSev.loadContactsData();
        $scope.contacts_data = settingUdSev.getContactsData();
        /*
	$scope.contacts_data = [];
    try{
      var options = new ContactFindOptions();
      options.filter = "";
      options.multiple = true;
      options.hasPhoneNumber = true;
      var fields = ['*'];
      navigator.contacts.find(fields, function(contacts){
        $scope.contacts_data = [];
        for(var i=0;i<contacts.length;i++){
          $scope.contacts_data.push({
            name:ionic.Platform.isIOS()?(angular.isDefined(contacts[i].name)?contacts[i].name.formatted:''):(angular.isDefined(contacts[i].displayName)?contacts[i].displayName:''),
            phone:contacts[i].phoneNumbers!=null?(contacts[i].phoneNumbers[0].value).replace(new RegExp(/(-)/g),''):'',
            ck:false
          })
        }
      }, function(contactError){
      }, options);
    }catch(e){}
	*/

        $scope.openModal = function () {
            settingUdSev.clearContactsData();
            settingUdSev.loadContactsData();
            $scope.contacts_data = settingUdSev.getContactsData();

            $scope.modal.show();
        };
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.contacts_data.num_checked = $scope.contacts_data.num_checked + 1;

            } else {
                $scope.contacts_data.num_checked = $scope.contacts_data.num_checked - 1;
            }
        }
        //$scope.select_all_employee = function(){
        //
        //  //$scope.all_selected = true;
        //  document.getElementById('select_all_employee').style.display = "none";
        //  document.getElementById('deselect_all_employee').style.display = "block";
        //  $scope.contacts_data.num_checked = $scope.contacts_data.length;
        //  $scope.contacts_data.show_footer_bar = true;
        //  for (var i=0;i<$scope.contacts_data.length;i++){
        //    $scope.contacts_data[i].checked = true;
        //  }
        //}
        //$scope.cancel = function(){
        //  console.log($scope.contacts_data);
        //  //$scope.all_selected = false;
        //  document.getElementById('select_all_employee').style.display = "block";
        //  document.getElementById('deselect_all_employee').style.display = "none";
        //  $scope.contacts_data.num_checked = 0;
        //  $scope.contacts_data.show_footer_bar = false;
        //  for (var i=0;i<$scope.contacts_data.length;i++){
        //    $scope.contacts_data[i].checked = false;
        //  }
        //}

        $scope.importAction = function () {
            var phone_list = '';
            var name_list = '';
            var data = $scope.contacts_data;
            for (var i = 0; i < data.length; i++) {
                if (data[i].ck && data[i].phone != '') {
                    phone_list = phone_list + data[i].phone + '*,*';
                    name_list = name_list + data[i].name + '*,*';
                }
            }
            if (phone_list == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">没有选中通讯录数据</div>',
                    okText: '确定'
                }).then(function (res) {});
            } else {
                $rootScope.showLoading();
                $.ajax({
                    type: 'POST',
                    url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.importContacts',
                    timeout: 30000000,
                    data: {
                        phone_list: phone_list.substring(0, phone_list.length - 3),
                        name_list: name_list.substring(0, name_list.length - 3),
                        _user_name: window.localStorage['_user_name'],
                        _pass_word: window.localStorage['_pass_word'],
                        _is_login: window.localStorage['_is_login'],
                        _notification_token: window.localStorage['_notification_token'],
                        _device_type: window.localStorage['_device_type']
                    },
                    success: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        var _data = $.parseJSON(data);
                        if (typeof (_data.flag) != 'undefined' && _data.flag == '0') {
                            fufuMobclickAgent('click_phonebook_import');
                            $location.path('home_page/home_menulist/user_import_result/' + _data.operate_date);
                        } else {
                            $ionicPopup.alert({
                                title: '运行结果',
                                template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                                okText: '确定'
                            }).then(function (res) {

                            });
                        }
                    },
                    error: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                            okText: '确定'
                        })
                    }
                });
            }
        }

        $scope.user_contact = {
            user_name: '',
            name: '',
            staff_no: '',
            tel: '',
            email: '',
            _flag: 1,
            _message: ''
        }

        $ionicModal.fromTemplateUrl('add-contact-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.add_modal = modal;
        });

        $scope.closeAddModal = function () {
            $scope.add_modal.hide();
        };
        $scope.addUser = function () {
            $scope.user_contact = {
                user_name: '',
                name: '',
                staff_no: '',
                tel: '',
                email: '',
                _flag: 1,
                _message: ''
            }
            $scope.add_modal.show();
        }

        $scope.saveContact = function () {
            for (var p in $scope.user_contact) {
                if ($scope.user_contact[p] == '' && p != '_flag' && p != '_message' && p != '_is_login' && p != '_notification_token' && p != '_device_type') {
                    $scope.user_contact._flag = 0;
                    $scope.user_contact._message = '用户信息不能为空';
                    $timeout(function () {
                        $scope.user_contact._flag = 1;
                        $scope.user_contact._message = '';
                    }, 1500);
                    return;
                }
            }
            var reg = /^1[3|4|5|7|8]\d{9}$/;
            $scope.user_contact._user_name = window.localStorage['_user_name'];
            $scope.user_contact._pass_word = window.localStorage['_pass_word'];
            $scope.user_contact._is_login = window.localStorage['_is_login'];
            $scope.user_contact._notification_token = window.localStorage['_notification_token'];
            $scope.user_contact._device_type = window.localStorage['_device_type'];
            $rootScope.showLoading();
            $.ajax({
                type: 'POST',
                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveContact',
                data: $scope.user_contact,
                timeout: _var_timeout,
                success: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    var _data = $.parseJSON(data);
                    $ionicPopup.alert({
                        title: '运行结果',
                        template: '<div style="text-align: center;">' + _data.message + '</div>',
                        okText: '确定'
                    }).then(function (res) {
                        if (_data.flag == "0") {
                            fufuMobclickAgent('click_single_import');
                            $scope.closeAddModal();
                            settingUdSev.loadUserData();
                        }
                    });
                },
                error: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                        okText: '确定'
                    })
                }
            });
        }
    })

    .controller('essLvApplyCtrl', function ($scope,$rootScope, essLvApplySev, $ionicModal, $ionicActionSheet, timeSelect, sideSelect, $ionicScrollDelegate, $emplComponentService) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.is_require_upload = false;
        essLvApplySev.clearData();
        essLvApplySev.loadData($scope);

        $scope.lv_app_data = essLvApplySev.getData();

        $scope.imagesObj = essLvApplySev.getImageData();

        
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });

        $scope.essLvPolicy = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.lv_app_data.essLvPolicy_data,
                selectIndex: $scope.lv_app_data.essLvPolicy_data_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("essLvPolicy").innerHTML = $scope.lv_app_data.essLvPolicy_data[index].value;
                        $scope.lv_app_data.essLvPolicy_data_key = $scope.lv_app_data.essLvPolicy_data[index].key;
                        $scope.lv_app_data.essLvPolicy_data_index = index;
                        $scope.lv_app_data.default_lv_code_id = $scope.lv_app_data.essLvPolicy_data_key;
                        essLvApplySev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }

                }
            });
        }
        /*
            $scope.showDate_start_date = function(){
              var current_date = new Date();
              current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
              current_date = current_date.toJSON().slice(0,4);
              var startDate = parseInt(current_date, 10) - 10;
              startDate = startDate + '-01-01';
              var endDate = parseInt(current_date, 10) + 10;
              endDate = endDate + '-12-31';
              timeSelect.show({
                type :  'date' ,
                startDate :  '1900-01-01',
                endDate : '2099-12-31',
                defaultDate: $scope.lv_app_data.start_date,
                returnDateType : 'y-m-d',
                returnTimeType :  '24h'||'AMPM',
                //stepping :10,
                selectedFunc : function (date) {
                  if (typeof(date) != 'undefined'){
                    $scope.lv_app_data.start_date = date;
                    essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                  }
                }
              })
            }
            $scope.showDate_start_time = function(){
              var current_date = new Date();
              current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
              current_date = current_date.toJSON().slice(0,4);
              var startDate = parseInt(current_date, 10) - 10;
              startDate = startDate + '-01-01';
              var endDate = parseInt(current_date, 10) + 10;
              endDate = endDate + '-12-31';
              timeSelect.show({
                type :  'time' ,
                startDate :  '1900-01-01',
                endDate : '2099-12-31',
                defaultDate: $scope.lv_app_data.start_time,
                returnDateType : 'y-m-d',
                returnTimeType :  '24h'||'AMPM',
                //stepping :10,
                selectedFunc : function (date) {
                  if (typeof(date) != 'undefined'){
                    $scope.lv_app_data.start_time = date;
                    essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                  }
                }
              })
            }


            $scope.showDate_end_date = function(){
              var current_date = new Date();
              current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
              current_date = current_date.toJSON().slice(0,4);
              var startDate = parseInt(current_date, 10) - 10;
              startDate = startDate + '-01-01';
              var endDate = parseInt(current_date, 10) + 10;
              endDate = endDate + '-12-31';
              timeSelect.show({
                type :  'date' ,
                startDate :  '1900-01-01',
                endDate : '2099-12-31',
                defaultDate: $scope.lv_app_data.end_date,
                returnDateType : 'y-m-d',
                returnTimeType :  '24h'||'AMPM',
                //stepping :10,
                selectedFunc : function (date) {
                  if (typeof(date) != 'undefined'){
                    $scope.lv_app_data.end_date = date;
                    essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                  }
                }
              })
            }

            $scope.showDate_end_time = function(){
              var current_date = new Date();
              current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
              current_date = current_date.toJSON().slice(0,4);
              var startDate = parseInt(current_date, 10) - 10;
              startDate = startDate + '-01-01';
              var endDate = parseInt(current_date, 10) + 10;
              endDate = endDate + '-12-31';
              timeSelect.show({
                type :  'time' ,
                startDate :  '1900-01-01',
                endDate : '2099-12-31',
                defaultDate: $scope.lv_app_data.end_time,
                returnDateType : 'y-m-d',
                returnTimeType :  '24h'||'AMPM',
                //stepping :10,
                selectedFunc : function (date) {
                  if (typeof(date) != 'undefined'){
                    $scope.lv_app_data.end_time = date;
                    essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                  }
                }
              })
            }

        */

        $scope.show_start_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 1;
            startDate = startDate + '-01-01 18:00';
            var endDate = parseInt(current_date, 10) + 1;
            endDate = endDate + '-12-31 18:00';
            timeSelect.show({
                type: 'dateTime',
                startDate: '1900-01-01 18:00',
                endDate: '2099-12-31 18:00',
                defaultDate: $scope.lv_app_data.start_date + ' ' + $scope.lv_app_data.start_time,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {

                        var formatted_date = date.split(' ');
                        $scope.lv_app_data.start_date = formatted_date[0];
                        $scope.lv_app_data.start_time = formatted_date[1];
                        essLvApplySev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }


        $scope.show_end_date = function () {

            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 1;
            startDate = startDate + '-01-01 18:00';
            var endDate = parseInt(current_date, 10) + 1;
            endDate = endDate + '-12-31 18:00';
            timeSelect.show({
                type: 'dateTime',
                startDate: '1900-01-01 18:00',
                endDate: '2099-12-31 18:00',
                defaultDate: $scope.lv_app_data.end_date + ' ' + $scope.lv_app_data.end_time,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        var formatted_date = date.split(' ');
                        $scope.lv_app_data.end_date = formatted_date[0];
                        $scope.lv_app_data.end_time = formatted_date[1];
                        essLvApplySev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }


        $scope.upload_photo = function () {

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {

						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
									$scope.is_require_upload = true;
									document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
									$('#ess_leave_apply_upload_mini_photo').attr("src", data.uri);
									document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
									$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
									document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
									document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";
									
								});
							} catch(e){
								
							}
							
						}


                        return true;
                    } else if (index == 1) {
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";

									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										//allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", data.uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";

								});
							} catch(e){
								
							}	
							
						}


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */


        }

        $scope.changeEssLvPolicy = function () {
            essLvApplySev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
        }

        $scope.saveApply = function () {
            if ($scope.lv_app_data.is_attachment && 　$scope.imagesObj.data != '') {
                essLvApplySev.saveApplyWithPhoto($scope.select_user_id, $scope.select_notify_id, $scope.approver_list);
            } else {
                essLvApplySev.saveApply($scope.select_user_id, $scope.select_notify_id, $scope.approver_list);
            }
        }
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }


            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.lv_app_data.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.approver_list = _d;
            $scope.search_control.search_val = '';

            $scope.closeModal();
        }


        $scope.delete_notify = function (user_id) {
            $('#essLvApply #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.lv_app_data.notify_list.length; i++) {
                if ($scope.lv_app_data.notify_list[i].user_id == user_id) {
                    $scope.lv_app_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }
        $scope.delete_approver = function (user_id) {
            if (!$scope.lv_app_data.approver_list_flag) {
                return;
            }
            $('#essLvApply #approver_list_div').addClass('approver_list_active');
            $scope.approver_list = [];
            $scope.select_user_id = ''
            $scope.lv_app_data.approver_list = [];
        }


        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.lv_app_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.lv_app_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
            //alert($scope.lv_app_data.notify_list.length);

            $scope.search_control.search_val = '';
            $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
        }


        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            var selectEmplList = '';
            if ($scope.lv_app_data.approver_list.length != 0) {
                selectEmplList = $scope.lv_app_data.approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式

                    $('#essLvApply #approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.lv_app_data.approver_list = [];
                    $scope.lv_app_data.approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    $scope.approver_list = $scope.lv_app_data.approver_list;
                }
            });

        }
        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.lv_app_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.lv_app_data.notify_list.length; i++) {
                    selectEmplList += $scope.lv_app_data.notify_list[i].employee_no;
                    if (i < $scope.lv_app_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式
                    $('#essLvApply #notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.lv_app_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.lv_app_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        }
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
    })
    .controller('essLvApproveCtrl', function ($scope, essLvApproveSev, $ionicPopover, $location) {
        /*Sunny改*/
        $scope.ess_pending_treatment = local_resource + 'img/icon/ess_pending_treatment@2x.png';
        $scope.ess_processed = local_resource + 'img/icon/ess_processed@2x.png';
        $scope.ess_approve_unhide_all = local_resource + 'img/icon/ess_approve_unhide_all@2x.png';
        /*Sunny改*/
        /*chirs改*/
        $scope.icon_filter = local_resource + 'img/icon/icon_filter.png';
        /*chris改*/
        $scope.search_val = "";
        essLvApproveSev.clearData();
        essLvApproveSev.loadEssApproveData();
        $scope.ess_approve_data = essLvApproveSev.getEssApproveData();

        $scope.search_val = "";
        $scope._flag = "待处理";
        $scope.loadLvDetails = function (p_inst, show_type, app_status, task_id) {
            var _status = app_status == '待处理' ? 'UC' : 'C';
            $location.path("home_page/leave_approve_details/" + p_inst + "/" + show_type + "/" + _status + "/" + task_id);
        }

        $scope.filterLvApprove = function (flag) {
            $scope._flag = flag;
            $scope.closePopover();
        }
        $ionicPopover.fromTemplateUrl("ess-leave-approve.html", {
                scope: $scope
            })
            .then(function (popover) {
                $scope.popover = popover;
            })

        $scope.openPopover = function ($event) {
            $scope.popover.show($event);
        };
        $scope.closePopover = function () {
            $scope.popover.hide();
        };
        //销毁事件回调处理：清理popover对象
        $scope.$on("$destroy", function () {
            $scope.popover.remove();
        });
    })
    .controller('essLvApDetailCtrl', function ($scope, essLvApDetailSev, $stateParams, essLvApplySev, $ionicModal) {
        /*Sunny改*/
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        /*Sunny改*/
        essLvApDetailSev.clearData();
        essLvApDetailSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.my_result_status, $stateParams.task_id);
        $scope.ess_app_detail_data = essLvApDetailSev.getData();

        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $ionicModal.fromTemplateUrl('ess-approve-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.ess_empl_data = [];
            essLvApplySev.loadEssEmplData($scope.select_user_id, $scope.ess_app_detail_data.employee_no, $scope.ess_app_detail_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            $scope.select_user_id = user_id;
            _d = $scope.ess_app_detail_data.approver_list;
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    color: "#999",
                    action: '下一层审批人',
                    flag: 1,
                    _flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    color: "#999",
                    action: '下一层审批人',
                    flag: 1,
                    user_id: user_id,
                    _flag: 1
                }
            }
            $scope.closeModal();
        }

        $scope.applyReject = function () {
            essLvApDetailSev.applyReject($scope.select_user_id);
        }
        $scope.applyApprove = function () {
            essLvApDetailSev.applyApprove($scope.select_user_id);
        }
    })
    .controller('essMyApplyCtrl', function ($scope, essMyApplySev, $ionicPopover, $location) {
        /*Sunny改*/
        $scope.ss_not_completed = local_resource + 'img/icon/ess_not_completed@2x.png';
        $scope.ess_has_been_completed = local_resource + 'img/icon/ess_has_been_completed@2x.png';
        $scope.ess_unhide_all = local_resource + 'img/icon/ess_unhide_all@2x.png';
        /*Sunny改*/
        $scope.apply_leave_icon = local_resource + 'img/icon/apply_leave_icon.png';
        $scope.apply_overtime_icon = local_resource + 'img/icon/apply_overtime_iocn.png';
        $scope.apply_field_icon = local_resource + 'img/icon/apply_field_icon.png';
        essMyApplySev.clearData();
        essMyApplySev.loadData();
        //$scope.search_val = "";
        $scope.my_apply_icon = local_resource + 'img/menus/';
        $scope.ess_my_apply_data = essMyApplySev.getData();


        $scope.loadMyApply = function (name, type) {
            if (type == "leave") {
                fufuMobclickAgent('menu_ess_my_apply_details');
                $location.path("home_page/ess_my_apply_details/" + name + "/" + type);
            } else if (type == "fieldwork") {
                fufuMobclickAgent('menu_ess_my_apply_details_fieldwork');
                $location.path("home_page/ess_my_apply_details_fieldwork/" + name + "/" + type);
            } else if (type == 'overtime') {
                fufuMobclickAgent('menu_ess_my_ot_apply_details');
                $location.path("home_page/ess_my_ot_apply_details/" + name + "/" + type);
            } else if (type == 'fieldwork_bill') {
                fufuMobclickAgent('menu_ess_my_out_apply_details');
                $location.path("home_page/ess_my_out_apply_details/" + name + "/" + type);
            } else if (type == 'offic_work_out') {
                fufuMobclickAgent('menu_ess_my_apply_details_offic_work_out');
                $location.path("home_page/ess_my_apply_details_offic_work_out/" + name + "/" + type);
            } else if (type == 'at_daily_adj') {
                //fufuMobclickAgent('menu_ess_my_apply_details_offic_work_out');
                $location.path("home_page/ess_my_card_adj_apply_details/" + name + "/" + type);
            } else if (type == 'business_trip') {
                //fufuMobclickAgent('menu_ess_my_apply_details_offic_work_out');
                $location.path("home_page/business_trip_apply_new/" + name + "/" + type);
            }
        }
    })
    .controller('essMyApplyDCtrl', function ($scope,$rootScope, essMyApplyDSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $ionicHistory, $timeout) {

        if (ionic.Platform.isIOS()) {
            essMyApplyDSev.clearData();
            essMyApplyDSev.loadData($stateParams.type, 'UC');
            $scope.ess_my_applyD_data = essMyApplyDSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyApplyDSev.clearData();
                essMyApplyDSev.loadData($stateParams.type, 'UC');
                $scope.ess_my_applyD_data = essMyApplyDSev.getData();
            });
        }
        //essMyApplyDSev.clearData();
        //essMyApplyDSev.loadData($stateParams.type,'UC');
        ////essMyApplyDSev.loadOtherData($stateParams.type,'C');
        //$scope.ess_my_applyD_data = essMyApplyDSev.getData();
        //$scope.ess_my_applyD_other_data = essMyApplyDSev.getOtherData();
        $scope.search_control = essMyApplyDSev.getSearchValue();

        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }

        $scope._flag = "未完成";
        $scope.noapprove_click = function () {
            $scope._flag = "未完成";
            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);



        }
        $scope.approved_click = function () {
            $scope._flag = "已完成";
            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);


        }
        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, s_t, is_process, app_id) {

            $location.path("home_page/ess_my_apply_details_content/" + p_inst + "/" + show_type + "/" + task_id + "/" + s_t + "/" + is_process + "/" + app_id + "/my_apply");
        }

        $scope.OnDrapUp = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }
        $scope.OnDrapDown = function () {
            $scope.show_search = true;

        }
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
    })

    .controller('essMyApplyDFCtrl', function ($scope, essMyApplyDSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $ionicHistory, $timeout) {
        if (ionic.Platform.isIOS()) {
            essMyApplyDSev.clearData();
            essMyApplyDSev.loadData($stateParams.type, "UC");
            $scope.ess_my_applyD_data = essMyApplyDSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyApplyDSev.clearData();
                essMyApplyDSev.loadData($stateParams.type, "UC");
                $scope.ess_my_applyD_data = essMyApplyDSev.getData();
            });
        }
        //$scope.$on("$ionicView.enter", function () {
        //  //解决 进入明细页面back回来的时候 会再次loaddata
        //  if (typeof($scope.data_loaded) != 'undefined'){
        //    return;
        //  }
        //  else {
        //    $scope.data_loaded = true;
        //  }
        //  essMyApplyDSev.clearData();
        //  essMyApplyDSev.loadData($stateParams.type,"UC");
        //  $scope.ess_my_applyD_data = essMyApplyDSev.getData();
        //});
        $scope.address_icon = local_resource + 'img/icon/address_icon.png'

        $scope.search_control = essMyApplyDSev.getSearchValue();
        //$scope.search_control.search_val = "";
        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }

        // essMyApplyDSev.clearData();
        //essMyApplyDSev.loadData($stateParams.type,"UC");
        ////essMyApplyDSev.loadOtherData($stateParams.type,"C");
        //$scope.ess_my_applyD_data = essMyApplyDSev.getData();
        //$scope.ess_my_applyD_other_data = essMyApplyDSev.getOtherData();
        $scope._flag = "未完成";
        $scope.noapprove_click = function () {
            $scope._flag = "未完成";

            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);




        }
        $scope.approved_click = function () {
            $scope._flag = "已完成";

            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);


        }
        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, s_t, is_process, rec_id) {

            $location.path("home_page/ess_my_apply_details_content_fieldwork/" + p_inst + "/" + show_type + "/" + task_id + "/" + s_t + "/" + is_process + "/" + rec_id + "/my_apply");
        }

    })

    .controller('essMyApplyDetailsContentCtrl', function ($scope, essMyApplyDetailsContentSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $ionicPopup, $timeout, zoomSlider) {

        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.icon_noapprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.notify = local_resource + 'img/icon/notify.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        essMyApplyDetailsContentSev.clearData();
        if ($stateParams.is_process == 1) {
            essMyApplyDetailsContentSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id);
        } else {
            essMyApplyDetailsContentSev.loadNoprocessData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $stateParams.app_id);
        }

        $scope.ess_my_applyDC_data = essMyApplyDetailsContentSev.getData();
        var my_app_result = '';
        if ($stateParams.s_t == "未完成") {
            my_app_result = 'UC'
        } else {
            my_app_result = 'C'
        }
        $scope.fireEvent = function (i, arr) {
            $timeout(function () {
                if (arr[i].action == '拒绝') {
                    document.getElementById("approver_list_img" + i).src = $scope.icon_noapprove;
                } else if (arr[i].action == '批准') {
                    document.getElementById("approver_list_img" + i).src = $scope.icon_confirm;
                }
                if (i == (arr.length - 1)) {
                    document.getElementById("approver_list_img_" + i).style.display = "none";
                }
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 16) + 'px';
                }
                //if(arr[i].flag=='1'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line;
                //}
                //   else if(arr[i].flag=='2'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line_gray;
                //}


            }, 0);
        }
        $scope.show_img = function (index) {
            zoomSlider.show({
                data: $scope.ess_my_applyDC_data.attachment_array,
                index: index
            })
            return;
            /*
      if (ionic.Platform.isIOS()) {
        window.open(url, '_system', 'enableViewportScale=yes');
      } else {
        window.open(url, '_system');
      }
	  	*/
        }


        $('#_ess_my_apply_d1').change(function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        });
        $('#_ess_my_apply_d2').change(function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        });
        $('#_ess_my_apply_t1').change(function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        });
        $('#_ess_my_apply_t2').change(function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        });
        $scope.changeEssLvPolicy = function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        }

        $scope.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_applyDC_data.approver_list;
            } else {
                return;
            }
            var _len = _d.length;
            if (_len == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                }
            }
            $scope.closeModal();
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_applyDC_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_applyDC_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
        }

        $ionicModal.fromTemplateUrl('ess-my-apply-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.click_flag = 0;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_data.approver_list;
            if (_d.length > 0) {
                var len = _d.length;
                $scope.select_user_id = _d[len - 1].user_id;
            }
            essLvApplySev.loadEssEmplData($scope.select_user_id, $scope.ess_my_applyDC_data.employee_no, $scope.ess_my_applyDC_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.openModal2 = function () {
            $scope.search_val = '';
            $scope.click_flag = 1;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_data.notify_list;
            $scope.select_notify_id = '';
            for (var i = 0; i < _d.length; i++) {
                $scope.select_notify_id = $scope.select_notify_id + _d[i].user_id + ',';
            }
            $scope.select_notify_id = $scope.select_notify_id.substring(0, $scope.select_notify_id.length - 1);
            essLvApplySev.loadEssEmplData($scope.select_notify_id, $scope.ess_my_applyDC_data.employee_no, $scope.ess_my_applyDC_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        //$scope.$on('$destroy', function() {
        //  $scope.modal.remove();
        //});

        $scope.submitAction = function (action) {
            essMyApplyDetailsContentSev.submitAction(action);
        }
        $scope.cancel = function () {


            if ($scope.ess_my_applyDC_data.action_text == '更多') {
                var hideSheet = $ionicActionSheet.show({
                    buttons: [

                        {
                            text: '修改'
                        }, {
                            text: '撤销'
                        }
                    ],

                    //titleText: 'Modify your album',
                    //titleText: '选择上传图片方式',
                    cancelText: '取消',
                    //destructiveText: 'Delete',
                    cancel: function () {
                        // add cancel code..
                    },
                    buttonClicked: function (index) {

                        if (index == 0) {
                            if ($scope.ess_my_applyDC_data.modify) {
                                $location.path("home_page/ess_my_apply_details_content_Modify/" + $stateParams.p_inst + "/" + $stateParams.show_type + "/" + $stateParams.task_id);
                            } else {
                                $ionicPopup.alert({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">不能修改</div>',
                                    okText: '确定'
                                })
                            }
                            return true;
                        } else if (index == 1) {
                            if ($scope.ess_my_applyDC_data.cancel) {
                                $ionicPopup.confirm({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">确认要撤销吗</div>',
                                    cancelType: 'button-dark',
                                    cancelText: '取消',
                                    okText: '确认'
                                }).then(function (res) {
                                    if (res) {
                                        essMyApplyDetailsContentSev.submitAction('Cancel', my_app_result);
                                    }
                                });

                            } else {
                                $ionicPopup.alert({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">不能撤销</div>',
                                    okText: '确定'
                                })
                            }
                            return true;
                        }
                        return true;
                    }
                });
            } else if ($scope.ess_my_applyDC_data.action_text == '修改') {
                $location.path("home_page/ess_my_apply_details_content_Modify/" + $stateParams.p_inst + "/" + $stateParams.show_type + "/" + $stateParams.task_id);
            } else if ($scope.ess_my_applyDC_data.action_text == '撤销') {
                $ionicPopup.confirm({
                    title: '提醒',
                    template: '<div style="text-align: center;">确认要撤销吗</div>',
                    cancelType: 'button-dark',
                    cancelText: '取消',
                    okText: '确认'
                }).then(function (res) {
                    if (res) {
                        essMyApplyDetailsContentSev.submitAction('Cancel', my_app_result);
                    }
                });
            } else {
                return;
            }

        }

    })

    .controller('essMyApplyDetailsContentFieldworkCtrl', function ($scope, essMyApplyDetailsContentFieldworkSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $ionicPopup, $timeout, zoomSlider) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.map_icon = local_resource + 'img/icon/map_icon.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        var my_app_result = '';
        if ($stateParams.s_t == '未完成') {
            my_app_result = 'UC';
        } else {
            my_app_result = 'C';
        }
        $scope.fireEvent = function (i, arr) {
            $timeout(function () {
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 19) + 'px';
                }
                //if(arr[i].flag=='1'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line;
                //}
                //else if(arr[i].flag=='2'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line_gray;
                //}
                try {
                    if (i == arr.length - 1) {
                        document.getElementById("approver_list_img_" + i).style.display = "none";
                    }
                } catch (e) {

                }
            }, 0);
        }


        $scope.my_approval_show_map = function (longitude, latitude, location) {
            getLocation.checkCanLocation(
                function (result) {
                    if (result == 1) {
                        try {
                            getLocation.showMapWithCoordinate({
                                latitude: latitude,
                                longitude: longitude,
                                address: location
                            });
                        } catch (e) {
                            console.log(e.message);
                        }
                    }
                }
            );

        }
        $scope.show_img = function (url) {
            var temp_array = [];
            temp_array.push(url);
            zoomSlider.show({
                data: temp_array,
                index: 0
            });
            /*
      if (ionic.Platform.isIOS()) {
        window.open(url, '_system', 'enableViewportScale=yes');
      } else {
        window.open(url, '_system');
      }
	  */
        }
        essMyApplyDetailsContentFieldworkSev.clearData();
        if ($stateParams.is_process == 1) {
            essMyApplyDetailsContentFieldworkSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $scope);
        } else {
            essMyApplyDetailsContentFieldworkSev.loadNoprocessData($stateParams.show_type, $stateParams.rec_id, $scope);
        }

        $scope.ess_my_applyDC_Fieldwork_data = essMyApplyDetailsContentFieldworkSev.getData();



        $scope.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_applyDC_Fieldwork_data.approver_list;
            } else {
                return;
            }
            var _len = _d.length;
            if (_len == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                }
            }
            $scope.closeModal();
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_applyDC_Fieldwork_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_applyDC_Fieldwork_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
        }

        $ionicModal.fromTemplateUrl('ess-my-apply-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.click_flag = 0;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_Fieldwork_data.approver_list;
            if (_d.length > 0) {
                var len = _d.length;
                $scope.select_user_id = _d[len - 1].user_id;
            }
            essLvApplySev.loadEssEmplData($scope.select_user_id, $scope.ess_my_applyDC_Fieldwork_data.employee_no, $scope.ess_my_applyDC_Fieldwork_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.openModal2 = function () {
            $scope.search_val = '';
            $scope.click_flag = 1;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_Fieldwork_data.notify_list;
            $scope.select_notify_id = '';
            for (var i = 0; i < _d.length; i++) {
                $scope.select_notify_id = $scope.select_notify_id + _d[i].user_id + ',';
            }
            $scope.select_notify_id = $scope.select_notify_id.substring(0, $scope.select_notify_id.length - 1);
            essLvApplySev.loadEssEmplData($scope.select_notify_id, $scope.ess_my_applyDC_data.employee_no, $scope.ess_my_applyDC_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        //$scope.$on('$destroy', function() {
        //  $scope.modal.remove();
        //});

        $scope.submitAction = function (action) {
            essMyApplyDetailsContentFieldworkSev.submitAction(action);
        }
        $scope.cancel = function () {

            $ionicPopup.confirm({
                title: '提醒',
                template: '<div style="text-align: center;">确认要撤销吗</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    var obj_id = '';
                    var biz_type_key = '';
                    if (typeof ($scope.ess_my_applyDC_Fieldwork_data.obj_id) != 'undefined') {
                        obj_id = $scope.ess_my_applyDC_Fieldwork_data.obj_id;
                    }
                    if (typeof ($scope.ess_my_applyDC_Fieldwork_data.biz_type_key) != 'undefined') {
                        biz_type_key = $scope.ess_my_applyDC_Fieldwork_data.biz_type_key;
                    }
                    essMyApplyDetailsContentFieldworkSev.submitAction('Cancel', my_app_result, $stateParams.is_process, obj_id, biz_type_key);


                }
            });


        }
    })

    .controller('payrollHomeCtrl', function ($scope, payrollHomeSev) {
        payrollHomeSev.clearData();
        payrollHomeSev.loadData('');
        $scope.payroll_home_data = payrollHomeSev.getData();
        $('#_payroll_empl_date').change(function () {
            payrollHomeSev.loadData($('#_payroll_empl_date').val());
        })
    })
    .controller('atHomeCtrl', function ($scope, atHomeSev, homemessageSev, timeSelect, $ionicScrollDelegate, $ionicPopup, $ionicHistory, $location, $rootScope, $timeout) {
        //homemessageSev.loadMessageCount();

        /*Sunny改*/
        $scope.dot_normal = local_resource + 'img/icon/dot_normal.png';
        $scope.dot_abnormal = local_resource + 'img/icon/dot_abnormal.png';
        $scope.Legal_holiday = local_resource + 'img/icon/Legal_holiday.png';
        $scope.other_holiday = local_resource + 'img/icon/other_holiday.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';

        $scope.img_exit_trial_login = local_resource + 'img/icon/exit_trial_login.png';
        if (window.localStorage["is_free_trial_login"] != null && typeof (window.localStorage["is_free_trial_login"]) != 'undefined' && window.localStorage["is_free_trial_login"] != '') {
            document.getElementById("home_at_is_trial_login").style.display = 'block';
        } else {
            document.getElementById("home_at_is_trial_login").style.display = 'none';
        }


        $scope.free_trial_log_out = function () {
            $ionicPopup.confirm({
                title: '退出登录',
                template: '<div style="text-align: center;">是否退出系统?</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    //$rootScope.showLoading();
                    $.ajax({
                        type: "GET",
                        url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
                        timeout: _var_timeout,
                        success: function (data) {
                            $rootScope.hideLoading();
                        },
                        error: function (data) {
                            $rootScope.hideLoading();
                            /*
                             $ionicPopup.alert({
                             title : '提醒',
                             template : '<div style="text-align: center;">'+fufu_network_error_msg+'</div>',
                             okText : '确定'
                             });
                             */
                        }
                    });
                    $ionicHistory.clearCache();
                    $ionicHistory.clearHistory();
                    setLocalStorageVar('_pass_word', '');
                    setLocalStorageVar('_is_login', '0');
                    if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
                        var model_list = window.localStorage["menu_list"].split(',');
                        for (var i = 0; i < model_list.length; i++) {
                            if (model_list[i] != '') {
                                setLocalStorageVar(model_list[i], '');
                            }
                        }
                    }
                    setLocalStorageVar("menu_list", "");
                    setLocalStorageVar("menu_home", "");
                    setLocalStorageVar("menu_message", "");
                    setLocalStorageVar("menu_organization_management", "");
                    setLocalStorageVar("menu_time", "");
                    setLocalStorageVar("menu_payroll", "");
                    setLocalStorageVar("menu_ess", "");
                    setLocalStorageVar("menu_My_Team", "");
                    setLocalStorageVar("menu_setting", "");
                    setLocalStorageVar("personnal_data", "");
                    setLocalStorageVar("is_free_trial_login", "");
                    login_init_flag = 0;
                    $location.path('/');

                }
            });
        }
        /*Sunny改*/
        atHomeSev.clearData();
        atHomeSev.loadData('', 0);
        var _dateObj = $('#_at_home_date');
        $scope.at_home_data = atHomeSev.getData();
        _dateObj.change(function () {
            atHomeSev.loadData(_dateObj.val(), 0);
        })


        $scope._at_home_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('_at_home_date_1').innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('_at_home_date_1').innerHTML = date;
                        _dateObj.val(date);
                        atHomeSev.loadData(_dateObj.val(), 0);
                    }
                }
            })
        }

        $scope.reAtHomeData = function (_flag) {
            atHomeSev.loadData(_dateObj.val(), _flag);
        }
        $scope.loadByDate = function (_day, curobj) {
            $("._ar_c").removeClass("_ar_c");
            $(curobj.currentTarget).addClass("_ar_c");
            var _day = parseInt(_day);
            var arr = (_dateObj.val()).split('-');
            if (_day < 10) {
                _day = '0' + _day;
            }
            _dateObj.val(arr[0] + '-' + arr[1] + '-' + _day);
            atHomeSev.loadData(_dateObj.val(), 0);
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }


        $scope.time_of_out = function () {
            $("#time_of_out").css({
                "color": "#53afff",
                "borderTop": "1px solid #53afff",
                "backgroundColor": "white"
            });
            $("#times_of_in").css({
                "color": "#333",
                "borderTop": "none",
                "backgroundColor": "#f8f8f8"
            });
            $("#home_at_tab_content").css({
                "-webkit-webkitTransform": "translateX(0)"
            });


            document.getElementById('home_at_tab_content').style.overflow = "visible";
            document.getElementById('home_at_tab1_div').setAttribute("style", "width:50%;");
            document.getElementById('home_at_tab2_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('home_at_tab_content').style.overflow = "hidden";
            }, 200);
        }
        $scope.times_of_in = function () {
            $("#times_of_in").css({
                "color": "#53afff",
                "borderTop": "1px solid #53afff",
                "backgroundColor": "white"
            })
            $("#time_of_out").css({
                "color": "#333",
                "borderTop": "none",
                "backgroundColor": "#f8f8f8"
            })
            $("#home_at_tab_content").css({
                "-webkit-webkitTransform": "translateX(-50%)"
            })

            document.getElementById('home_at_tab_content').style.overflow = "visible";
            document.getElementById('home_at_tab2_div').setAttribute("style", "width:50%;float:right");
            document.getElementById('home_at_tab1_div').setAttribute("style", "width: 50%;position: absolute;left:0;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('home_at_tab_content').style.overflow = "hidden";
            }, 200);
        }

    })
    .controller('modifyPwdCtrl', function ($scope, modifyPwdSev) {
        $scope.show_pwd = local_resource + 'img/icon/show_pwd_icon.png';
        $scope.hide_pwd = local_resource + 'img/icon/hide_pwd_icon.png';
        $scope.old_psw_flag = true;
        $scope.new_psw_flag = true;
        $scope.pwd_obj = {
            old_pwd: '',
            new_pwd: '',
            confirm_pwd: ''
        }
        $scope.modifyPwd = function () {
            if (document.getElementById('modify_pwd_save').style.opacity != '1') {
                return;
            } else {
                modifyPwdSev.modifyPwd($scope.pwd_obj.old_pwd, $scope.pwd_obj.new_pwd, $scope.pwd_obj.new_pwd);
            }

        }
        $scope.old_pwd_click = function (flag) {
            $scope.old_psw_flag = !flag;
            if (flag) {
                $("#modifyPwdold").attr('type', 'text')
            } else {
                $("#modifyPwdold").attr('type', 'password')
            }
        }
        $scope.new_pwd_click = function (flag) {
            $scope.new_psw_flag = !flag;
            if (flag) {
                $("#modifyPwdnew").attr('type', 'text')
            } else {
                $("#modifyPwdnew").attr('type', 'password')
            }
        }

        $("#modifyPwdold").keyup(function () {
            if ($("#modifyPwdold").val() != '' && $("#modifyPwdnew").val() != '') {
                document.getElementById('modify_pwd_save').style.opacity = '1';
            } else {
                document.getElementById('modify_pwd_save').style.opacity = '0.5';
            }
        })
        $("#modifyPwdnew").keyup(function () {
            if ($("#modifyPwdold").val() != '' && $("#modifyPwdnew").val() != '') {
                document.getElementById('modify_pwd_save').style.opacity = '1';
            } else {
                document.getElementById('modify_pwd_save').style.opacity = '0.5';
            }
        })
    })


    .controller('perDetailCtrl', function ($scope, perDetailSev, $location, $timeout, $ionicLoading, $ionicActionSheet, timeSelect, sideSelect, $ionicModal, $ionicHistory, $ionicPopup, perDataDetailSev) {
        /*Sunny改*/
        $scope.edit_data_01 = local_resource + 'img/icon/edit_data_01.png';
        $scope.arrow_right = local_resource + 'img/icon/arrow_right.png';
        /*Sunny改*/
        $scope.show_footer_bar = false;
        //perDetailSev.clearData();
        //perDetailSev.loadStaffMsDetails();
        $scope.staff_master_details = perDataDetailSev.getStaffMsDetails();

        if ($scope.staff_master_details.gender_index === '') {
            $("#personnal_details_gender").html('请选择');
            $("#personnal_details_gender").css({
                "color": "#999"
            })
        } else {
            $("#personnal_details_gender").html($scope.staff_master_details.gender[$scope.staff_master_details.gender_index].value_)
        }
        if ($scope.staff_master_details.id_type_index === '') {
            $("#personnal_details_id_type").html('请选择');
            $("#personnal_details_id_type").css({
                "color": "#999"
            })
        } else {
            $("#personnal_details_id_type").html($scope.staff_master_details.id_type[$scope.staff_master_details.id_type_index].value_);
        }
        if ($scope.staff_master_details.nationality_index === '') {
            $("#nationality").html('请选择');
            $("#nationality").css({
                "color": "#999"
            })
        } else {
            $("#nationality").html($scope.staff_master_details.nationality[$scope.staff_master_details.nationality_index].value_);
        }
        if ($scope.staff_master_details.race_index === '') {
            $("#race").html('请选择');
            $("#race").css({
                "color": "#999"
            })
        } else {
            $("#race").html($scope.staff_master_details.race[$scope.staff_master_details.race_index].value_);
        }


        $scope.id_type_index = $scope.staff_master_details.id_type_index;
        if ($scope.id_type_index === '') {
            $scope.staff_master_details.id_type_data_key = '';
        } else {
            $scope.staff_master_details.id_type_data_key = $scope.staff_master_details.id_type_data[$scope.id_type_index].key;
        }

        $scope.id_type = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.id_type_data,
                selectIndex: $scope.id_type_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("personnal_details_id_type").innerHTML = $scope.staff_master_details.id_type_data[index].value;
                        $scope.staff_master_details.id_type_data_key = $scope.staff_master_details.id_type_data[index].key;
                        $scope.id_type_index = index;
                    }

                }
            });
        }
        $scope.gender_index = $scope.staff_master_details.gender_index;
        if ($scope.gender_index === '') {
            $scope.staff_master_details.gender_data_key = '';
        } else {
            $scope.staff_master_details.gender_data_key = $scope.staff_master_details.gender_data[$scope.gender_index].key;
        }

        $scope.gender = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.gender_data,
                selectIndex: $scope.gender_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        console.log(document.getElementById("personnal_details_gender"));
                        document.getElementById("personnal_details_gender").innerHTML = $scope.staff_master_details.gender_data[index].value;
                        document.getElementById("personnal_details_gender").style.color = "#333";
                        $scope.staff_master_details.gender_data_key = $scope.staff_master_details.gender_data[index].key;
                        $scope.gender_index = index;
                    }
                }
            });
        }
        $scope.nationality_index = $scope.staff_master_details.nationality_index;
        if ($scope.nationality_index === '') {
            $scope.staff_master_details.nationality_data_key = '';
        } else {
            $scope.staff_master_details.nationality_data_key = $scope.staff_master_details.nationality_data[$scope.nationality_index].key;
        }

        $scope.nationality = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.nationality_data,
                selectIndex: $scope.nationality_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("nationality").innerHTML = $scope.staff_master_details.nationality_data[index].value;
                        document.getElementById("nationality").style.color = "#333";
                        $scope.staff_master_details.nationality_data_key = $scope.staff_master_details.nationality_data[index].key;
                        $scope.nationality_index = index;
                    }
                }
            });
        }
        $scope.race_index = $scope.staff_master_details.race_index;
        if ($scope.race_index === '') {
            $scope.staff_master_details.race_data_key = '';
        } else {
            $scope.staff_master_details.race_data_key = $scope.staff_master_details.race_data[$scope.race_index].key;
        }
        $scope.race = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.race_data,
                selectIndex: $scope.race_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("race").innerHTML = $scope.staff_master_details.race_data[index].value;
                        document.getElementById("race").style.color = "#333";
                        $scope.staff_master_details.race_data_key = $scope.staff_master_details.race_data[index].key;
                        $scope.race_index = index;
                    }
                }
            });
        }

        $scope.education_level_index = $scope.staff_master_details.education_level_index;
        if ($scope.education_level_index === '') {
            $scope.staff_master_details.education_level_data_key = '';
        } else {
            $scope.staff_master_details.education_level_data_key = $scope.staff_master_details.education_level_data[$scope.education_level_index].key;
        }

        $scope.education_level = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.staff_master_details.education_level_data,
                selectIndex: $scope.education_level_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("education_level").innerHTML = $scope.staff_master_details.education_level_data[index].value;
                        document.getElementById("education_level").style.color = "#333";
                        $scope.staff_master_details.education_level_data_key = $scope.staff_master_details.education_level_data[index].key;
                        $scope.education_level_index = index;
                    }
                }
            });
        }

        $scope.showDate_join_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.staff_master_details.join_date,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.staff_master_details.join_date = date;

                    }
                }
            })
        }
        $scope.showDate_p_c_d = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.staff_master_details.p_c_d,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.staff_master_details.p_c_d = date;

                    }
                }
            })
        }
        $scope.date_of_birth = function () {
            var current_date = new Date();
            var month = current_date.getMonth() + 1;
            var day = current_date.getDate();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 150;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10);
            //endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: endDate + "-" + month + "-" + day,
                defaultDate: $scope.staff_master_details.date_of_birth,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("date_of_birth").innerHTML = date;

                    }
                }
            })
        }

        $scope.cancel = function () {
            var pannel_arr = [$("#employee_name").val(), $scope.staff_master_details.gender_data_key, document.getElementById("date_of_birth").innerHTML, $scope.staff_master_details.id_type_data_key, $("#id_number").val(), $scope.staff_master_details.nationality_data_key, $("#p_o_b").val(), $scope.staff_master_details.race_data_key, $("#address").val(), $("#mobile_no").val(), $("#email").val(), $("#emergency_contact_name1").val(), $("#emergency_contact_no1").val()];
            var loaddata_arr = [$scope.staff_master_details.employee_name, $scope.staff_master_details._gender_key, $scope.staff_master_details.date_of_birth, $scope.staff_master_details._id_type_key, $scope.staff_master_details.id_number, $scope.staff_master_details._nationality_key, $scope.staff_master_details.p_o_b, $scope.staff_master_details._race_key, $scope.staff_master_details.address, $scope.staff_master_details.home_tel_no, $scope.staff_master_details.email, $scope.staff_master_details.emergency_contact_name1, $scope.staff_master_details.emergency_contact_no1]
            var _i = 0;
            for (var i = 0; i < pannel_arr.length; i++) {
                if (pannel_arr[i] != loaddata_arr[i]) {
                    _i++;
                    break;
                }
            }
            if (_i == 0 && !$scope.is_require_upload) {
                $ionicHistory.goBack()
            } else {
                $ionicPopup.confirm({
                    title: '',
                    template: '<div style="text-align: center;">是否放弃当前编辑</div>',
                    cancelText: '放弃',
                    cancelType: 'button-dark',
                    okText: '继续编辑'
                }).then(function (res) {
                    if (!res) {
                        $ionicHistory.goBack()
                    }
                });
            }
        }
        $scope.picklist_position = function () {
            //$location.path('home_page/home_menulist/personnal_details_position_tree_picklist/' + $("#o_n_i").val() + '/' + $("#dept_name_div").html() + '/' + $("#p_n_i").val() + '/' + $("#position_name_div").html() + '/' + 'personnal_details');
            // use this temporary until apple approve newest app with tree plugin include
            $location.path('home_page/home_menulist/temp_personnal_details_position_picklist/' + $("#o_n_i").val() + '/' + $("#dept_name_div").html() + '/' + $("#p_n_i").val() + '/' + $("#position_name_div").html());
        }
        $scope.is_require_upload = false;
        $scope.change_photo = function () {
            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {


						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$('#personnal_details_employee_photo').attr("src", uri);
										$scope.is_require_upload = true;
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.takePhoto(opt, function(data){
									
									$('#personnal_details_employee_photo').attr("src", data.uri);
									$scope.is_require_upload = true;
								});
							} catch(e){
								
							}
							
						}







                        return true;
                    } else if (index == 1) {
						
						
						if(ionic.Platform.isIOS()){
							try {
								navigator.camera.getPicture(function (uri) {
									$('#personnal_details_employee_photo').attr("src", uri);
									$scope.is_require_upload = true;

								}, function (message) {}, {
									quality: 100,
									destinationType: Camera.DestinationType.FILE_URI,
									// In this app, dynamically set the picture source, Camera or photo gallery
									sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
									encodingType: Camera.EncodingType.JPEG,
									mediaType: Camera.MediaType.PICTURE,
									allowEdit: true,
									targetHeight: 500,
									targetWidth: 500,
									correctOrientation: true
								});
							} catch (e) {
								//alert(e.message);
							}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
									
									$('#personnal_details_employee_photo').attr("src", data.uri);
									$scope.is_require_upload = true;
								});
							} catch(e){
								
							}	
							
						}
						
						


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */

        }

        $scope.saveStaffDetails = function () {
            if ($scope.is_require_upload) {
                perDetailSev.saveStaffDetailsWithUpload($scope);
            } else {
                perDetailSev.saveStaffDetails($scope);
            }

        }
    })



    .controller('findPwdCtrl', function ($scope, findPwdSev, $stateParams) {
        $scope.find_pwd_data = {};
        $scope.find_pwd_data = findPwdSev.getFindPwdData();
        $scope.find_pwd_data.valid_code = $stateParams.valid_code;
        $scope.find_pwd_data.tel_no = $stateParams.tel_no;
        $scope.sendPwdVCode = function () {
            if (document.getElementById("send_vcode").style.opacity == '1') {
                findPwdSev.sendPwdVCode();
            } else {
                return;
            }
        }

        $scope.show_pwd = local_resource + 'img/icon/show_pwd_icon.png';
        $scope.hide_pwd = local_resource + 'img/icon/hide_pwd_icon.png';
        $scope.old_psw_flag = true;
        $scope.new_psw_flag = true;

        $scope.old_pwd_click = function (flag) {
            $scope.old_psw_flag = !flag;
            if (flag) {
                $("#findpwd").attr('type', 'text')
            } else {
                $("#findpwd").attr('type', 'password')
            }
        }
        $scope.new_pwd_click = function (flag) {
            $scope.new_psw_flag = !flag;
            if (flag) {
                $("#findconfirmpwd").attr('type', 'text')
            } else {
                $("#findconfirmpwd").attr('type', 'password')
            }
        }
        document.getElementById("findpwd").oninput = function () {
            if (document.getElementById("findpwd").value != '' && document.getElementById("findconfirmpwd").value != '') {
                document.getElementById("find_pwd_save").style.opacity = '1';
            } else {
                document.getElementById("find_pwd_save").style.opacity = '0.5';
            }
        }
        document.getElementById("findconfirmpwd").oninput = function () {
            if (document.getElementById("findpwd").value != '' && document.getElementById("findconfirmpwd").value != '') {
                document.getElementById("find_pwd_save").style.opacity = '1';
            } else {
                document.getElementById("find_pwd_save").style.opacity = '0.5';
            }
        }

        //var reg = /^1[3|4|5|7|8]\d{9}$/;
        //document.getElementById("forget_tel_no").oninput=function(){
        //  if (!reg.test(document.getElementById("forget_tel_no").value)){
        //    document.getElementById("send_vcode").style.opacity='0.5';
        //  }
        //  else{
        //    document.getElementById("send_vcode").style.opacity='1';
        //  }
        //
        //  if(document.getElementById("forget_valid_code").value!='' && document.getElementById("forget_tel_no").value!=''){
        //    document.getElementById("forget_button").style.opacity='1';
        //  }
        //  else{
        //    document.getElementById("forget_button").style.opacity='0.5';
        //  }
        //
        //}
        //document.getElementById("forget_valid_code").oninput=function(){
        //  if(document.getElementById("forget_valid_code").value!='' && document.getElementById("forget_tel_no").value!=''){
        //    document.getElementById("forget_button").style.opacity='1';
        //  }
        //  else{
        //    document.getElementById("forget_button").style.opacity='0.5';
        //  }
        //}

        $scope.findPwdAction = function () {
            //if(document.getElementById("forget_button").style.opacity=='1'){
            //  findPwdSev.sendPwdVCode();
            //}
            //else{
            //  return;
            //}
			

            if (document.getElementById("find_pwd_save").style.opacity == '1') {

                findPwdSev.findPwdAction();
            } else {
                return;
            }

        }
    })


    .controller('regetPwdCtrl', function ($scope, regetPwdSev) {
        $scope.find_pwd_data = {};
        $scope.find_pwd_data = regetPwdSev.getFindPwdData();
        $scope.is_can_submit = false;

        $scope.valid_img_src = _redis_url + "/UserServer/captcha";
        $scope.changeCaptchaCode = function (event) {
            $(".imgauthcode").attr("src", _redis_url + "/UserServer/captcha?" + new Date().getTime())
        }

        $scope.sendPwdVCode = function () {
            if (document.getElementById("send_vcode").style.opacity == '1') {
                regetPwdSev.sendPwdVCode($scope);
            } else {
                return;
            }
        }

        var reg = /^1[3|4|5|7|8]\d{9}$/;
        //alert(document.getElementById("forget_tel_no").value)


        $scope.$on("$ionicView.enter", function () {
            if (!reg.test(document.getElementById("forget_tel_no").value)) {
                document.getElementById("send_vcode").style.opacity = '0.5';
            } else {
                document.getElementById("send_vcode").style.opacity = '1';
            }
        });

        document.getElementById("forget_tel_no").oninput = function () {
            if (!reg.test(document.getElementById("forget_tel_no").value)) {
                document.getElementById("send_vcode").style.opacity = '0.5';
            } else {
                document.getElementById("send_vcode").style.opacity = '1';
            }

            if (document.getElementById("forget_valid_code").value != '' && document.getElementById("forget_tel_no").value != '') {
                document.getElementById("_find_pwd_action").style.opacity = '1';
            } else {
                document.getElementById("_find_pwd_action").style.opacity = '0.5';
            }

        }
        document.getElementById("forget_valid_code").oninput = function () {
            if (document.getElementById("forget_valid_code").value != '' && document.getElementById("forget_tel_no").value != '') {
                document.getElementById("_find_pwd_action").style.opacity = '1';
            } else {
                document.getElementById("_find_pwd_action").style.opacity = '0.5';
            }


        }
        $scope.findPwdAction = function () {

            if (document.getElementById("_find_pwd_action").style.opacity == '1') {
                regetPwdSev.findPwdAction();
            } else {
                return;
            }
            //findPwdSev.findPwdAction();
        }
    })

    .controller('atZkLocSetCtrl', function ($scope, atZkLocSetSev, $ionicListDelegate, $location) {
        atZkLocSetSev.clearData();
        atZkLocSetSev.loadData();
        $scope.at_loc_data = atZkLocSetSev.getData();
        $scope.atZkLocDetail = function (z_id) {
            $location.path("home_page/at_zk_loc_set_detail/" + z_id);
            $ionicListDelegate.closeOptionButtons();
        }
        $scope.hideOption = function () {
            $ionicListDelegate.closeOptionButtons();
        }
        $scope.deleteAtZkLocInfo = function (z_id, _index) {
            atZkLocSetSev.deleteAtZkLocInfo(z_id, _index);
        }
    })

    .controller('atZkLocSetDetailCtrl', function ($scope, $timeout, $ionicScrollDelegate, atZkLocSetDetailSev, $stateParams, $ionicModal, $ionicPopup, $rootScope, $http, sideSelect) {
        /*Sunnygai*/
        $scope.fufu_delete02 = local_resource + 'img/icon/fufu_delete02.png';
        $scope.zengjia = local_resource + 'img/model/zengjia.png';
        /*Sunnygai*/
        $scope.search_val = ''
        $scope.at_zk_empl_list = [];
        $scope.search_val2 = ''
        $scope.at_zk_dev_list = [];
        $scope.new_dev = atZkLocSetDetailSev.getNewDev();
        if (ionic.Platform.isIOS()) {
            $scope.style_value = 'text-align:center;background-color:#ffffff;padding:0px;margin:63px 0px 0px  0px;height:50px;';
        } else {
            $scope.style_value = 'text-align:center;background-color:#ffffff;padding:0px;margin:45px 0px 0px  0px;height:50px;';
        }
        //$('._at_zk_loc_tab2').hide();
        $('.row .col-50').click(function () {
            if ($(this).attr('id') == '_at_zk_loc_tab1') {

                document.getElementById('_at_zk_loc_tab1').style.color = '#53afff';
                document.getElementById('_at_zk_loc_tab2').style.color = '#808080';
                document.getElementById('_at_zk_loc_tab_animate_div').style.webkitTransform = 'translateX(0)';
                document.getElementById('_at_zk_loc_wrap').style.webkitTransform = 'translateX(0)';
                document.getElementById('_at_zk_loc_wrap').style.overflow = "visible";
                document.getElementById('_at_zk_loc_tab1_div').setAttribute("style", "width:50%;padding-top:20px;");
                document.getElementById('_at_zk_loc_tab2_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
                $timeout(function () {
                    $ionicScrollDelegate.resize();
                    document.getElementById('_at_zk_loc_wrap').style.overflow = "hidden";
                }, 200);
            } else {
                document.getElementById('_at_zk_loc_tab1').style.color = '#808080';
                document.getElementById('_at_zk_loc_tab2').style.color = '#53afff';
                document.getElementById('_at_zk_loc_tab_animate_div').style.webkitTransform = 'translateX(100%)';
                document.getElementById('_at_zk_loc_wrap').style.webkitTransform = 'translateX(-50%)';
                document.getElementById('_at_zk_loc_wrap').style.overflow = "visible";
                document.getElementById('_at_zk_loc_tab1_div').setAttribute("style", "width:50%;padding-top:20px;position: absolute;left:0px;top:0px;");
                document.getElementById('_at_zk_loc_tab2_div').setAttribute("style", "width: 50%;float: right");
                $timeout(function () {
                    $ionicScrollDelegate.resize();
                    document.getElementById('_at_zk_loc_wrap').style.overflow = "hidden";
                }, 200);
            }
        });
        atZkLocSetDetailSev.loadData($stateParams.z_id);
        $scope.at_loc_detail_data = atZkLocSetDetailSev.getData();

        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.at_loc_detail_data.sub_bu_list,
                selectIndex: $scope.at_loc_detail_data.sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.at_loc_detail_data.sub_bu_key = $scope.at_loc_detail_data.sub_bu_list[index].key;
                        $scope.at_loc_detail_data.sub_bu_value = $scope.at_loc_detail_data.sub_bu_list[index].value;
                        $scope.at_loc_detail_data.sub_bu_index = index;
                        atZkLocSetDetailSev.zkLocSetDetailSubBuSave($stateParams.z_id);
                    }
                }
            });
        }

        $scope.device_sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.at_zk_dev_list.device_sub_bu_list,
                selectIndex: $scope.at_zk_dev_list.device_sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.at_zk_dev_list.device_sub_bu_key = $scope.at_zk_dev_list.device_sub_bu_list[index].key;
                        $scope.at_zk_dev_list.device_sub_bu_value = $scope.at_zk_dev_list.device_sub_bu_list[index].value;
                        $scope.at_zk_dev_list.device_sub_bu_index = index;
                    }
                }
            });
        }

        $scope.delZkAtDev = function (_sn, index) {
            atZkLocSetDetailSev.delZkAtDev(_sn, index);
        }
        $scope.addZkAtEmpl = function () {
            var z_id = $stateParams.z_id;
            var empl_list = '';
            var del_list = '';
            for (var i = 0; i < $scope.at_zk_empl_list.length; i++) {
                if ($scope.at_zk_empl_list[i].ck) {
                    empl_list = empl_list + $scope.at_zk_empl_list[i].emp + ',';
                }
                if ($scope.at_zk_empl_list[i].status_ == 1 && !$scope.at_zk_empl_list[i].ck) {
                    del_list = del_list + $scope.at_zk_empl_list[i].emp + ',';
                }
            }
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $rootScope.showLoading();
            $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                timeout: _var_timeout,
                params: {
                    sid: "cpe.att.person.deleteUserInfo",
                    zoneid: z_id,
                    zone_id: z_id,
                    sync_type: 2,
                    employee_list: del_list.substring(0, del_list.length - 1),
                    send_type: 3
                }
            }).
            success(function (data, status, headers, config) {
                if (angular.isDefined(data.flag) && data.flag == "1") {
                    $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                        timeout: 3000000,
                        params: {
                            sid: "cpe.att.person.upload",
                            send_type: "3",
                            zone_id: z_id,
                            zoneid: z_id,
                            employee_list: empl_list.substring(0, empl_list.length - 1),
                            sync_type: 2
                        }
                    }).
                    success(function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        if (angular.isDefined(data.flag)) {
                            $ionicPopup.alert({
                                    title: '运行结果',
                                    template: '<div style="text-align: center;">' + data.message + '</div>',
                                    okText: '确定'
                                })
                                .then(function (res) {
                                    fufuMobclickAgent('click_location_add_employee');
                                    $scope.closeModal();
                                });
                        } else {
                            $ionicPopup.alert({
                                title: '提醒',
                                template: '<div style="text-align: center;">操作执行出错</div>',
                                okText: '确定'
                            })
                        }
                    }).
                    error(function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                            okText: '确定'
                        })
                    });
                } else {
                    $rootScope.hideLoading();
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">操作执行出错</div>',
                        okText: '确定'
                    })
                }
            }).
            error(function (data, status, headers, config) {
                $rootScope.hideLoading();
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                    okText: '确定'
                })
            });
        }

        $scope.delAtZkLocDev = function (d_sn, _index) {
            atZkLocSetDetailSev.delAtZkLocDev($stateParams.z_id, d_sn, _index);
        }

        $scope.addAtZkNewDev = function () {
            if ($scope.new_dev.d_name == '' || $scope.new_dev.d_sn == '') {
                $ionicPopup.alert({
                    title: '运行结果',
                    template: '<div style="text-align: center;">设备信息不能为空</div>',
                    okText: '确定'
                });
                return;
            }
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            var date = new Date();
            var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
            var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
            var inputdate = date.getFullYear() + "-" + month + "-" + day;
            $rootScope.showLoading();
            $.ajax({
                type: "POST",
                timeout: _var_timeout,
                data: {
                    update_data: encodeURIComponent('sn:' + $scope.new_dev.d_sn + '\n' + 'id:' + $scope.at_loc_detail_data._b + '\n' + 'status:0' + '\n' + 'input_date:'),
                    device_sn: $scope.new_dev.d_sn,
                    device_name: $scope.new_dev.d_name,
                    sub_bu: $scope.at_zk_dev_list.device_sub_bu_key
                },
                url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.addsn&data=" + encodeURIComponent('sn:' + $scope.new_dev.d_sn + '\n' + 'id:' + $scope.at_loc_detail_data._b + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate),
                success: function (json) {
                    $rootScope.hideLoading();
                    var data = $.parseJSON(json);
                    $ionicPopup.alert({
                            title: '运行结果',
                            template: '<div style="text-align: center;">' + data.message + '</div>',
                            okText: '确定'
                        })
                        .then(function (res) {
                            if (angular.isDefined(data) && data.flag == '0') {
                                fufuMobclickAgent('click_location_add_device');
                                $scope.at_zk_dev_list.dev_list.push({
                                    d_name: $scope.new_dev.d_name,
                                    d_sn: $scope.new_dev.d_sn
                                });
                                $scope.new_dev.d_name = '';
                                $scope.new_dev.d_sn = '';
                            }
                        });
                },
                error: function () {
                    $rootScope.hideLoading();
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                        okText: '确定'
                    })
                }
            })
        }
        $scope.selectDevList = function () {
            var sn_list = '';
            var dev_list = '';
            for (var i = 0; i < $scope.at_zk_dev_list.dev_list.length; i++) {
                if ($scope.at_zk_dev_list.dev_list[i].ck) {
                    sn_list = sn_list + $scope.at_zk_dev_list.dev_list[i].d_sn + ',';
                    dev_list = dev_list + $scope.at_zk_dev_list.dev_list[i].d_name + ',' + $scope.at_zk_dev_list.dev_list[i].d_sn + '||';
                }
            }
            if (sn_list == '') {
                $ionicPopup.alert({
                    title: '运行结果',
                    template: '<div style="text-align: center;">请选中考勤机设备</div>',
                    okText: '确定'
                });
                return;
            }
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            $rootScope.showLoading();
            $http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
                timeout: 300000,
                params: {
                    sid: "cpe.att.person.upload",
                    send_type: "3",
                    zoneid: $stateParams.z_id,
                    sn: sn_list.substring(0, sn_list.length - 1),
                    device_sn_list: sn_list.substring(0, sn_list.length - 1),
                    zone_id: $stateParams.z_id,
                    sync_type: 3
                }
            }).
            success(function (data, status, headers, config) {
                $rootScope.hideLoading();
                if (angular.isDefined(data.flag)) {
                    $ionicPopup.alert({
                            title: '运行结果',
                            template: '<div style="text-align: center;">' + data.message + '</div>',
                            okText: '确定'
                        })
                        .then(function (res) {
                            $scope.closeModal2();
                        });
                } else {
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">操作执行出错</div>',
                        okText: '确定'
                    })
                }
            }).
            error(function (data, status, headers, config) {
                $rootScope.hideLoading();
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                    okText: '确定'
                })
            });

        }
        $scope.saveZkEmpl = function () {
            var count = 0;
            for (var i = 0; i < $scope.at_zk_empl_list.length; i++) {
                if ($scope.at_zk_empl_list[i].ck) {
                    count = count + 1;
                }
            }
            $('.zk-select-list').text('选中(' + count + ')');
        }

        $scope.saveZkDev = function () {
            var count = 0;
            for (var i = 0; i < $scope.at_zk_dev_list.dev_list.length; i++) {
                if ($scope.at_zk_dev_list.dev_list[i].ck) {
                    count = count + 1;
                }
            }
            $('.zk-select_dev-list').text('选中(' + count + ')');
        }

        $ionicModal.fromTemplateUrl('at-zk-empl-list.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.at_zk_empl_list = [];
            atZkLocSetDetailSev.loadZkEmplList($stateParams.z_id);
            $scope.at_zk_empl_list = atZkLocSetDetailSev.getZkEmplList();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $('.zk-select-list').text('选中(0)');
            $scope.at_zk_empl_list = [];
            $scope.search_val = '';
            atZkLocSetDetailSev.loadData($stateParams.z_id);
        };

        $ionicModal.fromTemplateUrl('at-zk-dev-list.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal2 = modal;
        });

        $scope.openModal2 = function () {
            $scope.search_val2 = '';
            $scope.at_zk_dev_list = [];
            $scope.new_dev.d_name = '';
            $scope.new_dev.d_sn = '';
            atZkLocSetDetailSev.loadZkDevList($stateParams.z_id);
            $scope.at_zk_dev_list = atZkLocSetDetailSev.getZkDevList();
            $scope.modal2.show();
        };
        $scope.closeModal2 = function () {
            $scope.modal2.hide();
            $('.zk-select_dev-list').text('选中(0)');
            $scope.at_zk_dev_list = [];
            $scope.search_val2 = '';
            atZkLocSetDetailSev.loadData($stateParams.z_id);
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
            $scope.modal2.remove();
        });
    })

    .controller('atZkLocAddCtrl', function ($scope, atZkLocAddSev, $ionicPopup, $rootScope, $http, sideSelect) {
        /*Sunny改*/
        $scope.zengjia = local_resource + 'img/model/zengjia.png';
        /*Sunny改*/
        atZkLocAddSev.clearData();
        atZkLocAddSev.loadData();
        $scope.at_loc_add = atZkLocAddSev.getData();
        $scope.new_dev = {
            d_sn: '',
            d_name: ''
        };

        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.at_loc_add.sub_bu_list,
                selectIndex: $scope.at_loc_add.sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.at_loc_add.sub_bu_key = $scope.at_loc_add.sub_bu_list[index].key;
                        $scope.at_loc_add.sub_bu_value = $scope.at_loc_add.sub_bu_list[index].value;
                        $scope.at_loc_add.sub_bu_index = index;
                    }
                }
            });
        }

        $scope.device_sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.at_loc_add.device_sub_bu_list,
                selectIndex: $scope.at_loc_add.device_sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.at_loc_add.device_sub_bu_key = $scope.at_loc_add.device_sub_bu_list[index].key;
                        $scope.at_loc_add.device_sub_bu_value = $scope.at_loc_add.device_sub_bu_list[index].value;
                        $scope.at_loc_add.device_sub_bu_index = index;
                    }
                }
            });
        }

        $scope.addAtLocInfo = function () {
            atZkLocAddSev.addAtLocInfo();
        }
        $scope.addAtZkNewDev = function () {
            if ($scope.new_dev.d_name == '' || $scope.new_dev.d_sn == '') {
                $ionicPopup.alert({
                    title: '运行结果',
                    template: '<div style="text-align: center;">设备信息不能为空</div>',
                    okText: '确定'
                });
                return;
            }
            var _str = '';
            if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
                _str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
            }
            var date = new Date();
            var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
            var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
            var inputdate = date.getFullYear() + "-" + month + "-" + day;
            $rootScope.showLoading();
            $.ajax({
                type: "POST",
                url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.addsn&data=" + encodeURIComponent('sn:' + $scope.new_dev.d_sn + '\n' + 'id:' + $scope.at_loc_add._b + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate),
                timeout: _var_timeout,
                data: {
                    update_data: encodeURIComponent('sn:' + $scope.new_dev.d_sn + '\n' + 'id:' + $scope.at_loc_add._b + '\n' + 'status:0' + '\n' + 'input_date:'),
                    device_sn: $scope.new_dev.d_sn,
                    device_name: $scope.new_dev.d_name,
                    sub_bu: $scope.at_loc_add.device_sub_bu_key
                },
                success: function (json) {
                    $rootScope.hideLoading();
                    var data = $.parseJSON(json);
                    $ionicPopup.alert({
                            title: '运行结果',
                            template: '<div style="text-align: center;">' + data.message + '</div>',
                            okText: '确定'
                        })
                        .then(function (res) {
                            if (angular.isDefined(data.flag) && data.flag == '0') {
                                fufuMobclickAgent('click_location_add_device');
                                $scope.at_loc_add.dev_list.push({
                                    d_name: $scope.new_dev.d_name,
                                    d_sn: $scope.new_dev.d_sn
                                });
                                $scope.new_dev.d_name = '';
                                $scope.new_dev.d_sn = '';
                            }
                        });
                },
                error: function () {
                    $rootScope.hideLoading();
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                        okText: '确定'
                    })
                }
            })
        }
    })

    .controller('aboutFuCtrl', function ($scope) {

        $scope.img_fufu_logo = local_resource + 'img/register/img_fufu_logo@2x.png';
        $scope.current_app_version = angular.isDefined(localStorage._resource_version) ? localStorage._resource_version : '1.0';
        if ($scope.current_app_version < '3.8.001') {
            $scope.current_app_version = '3.8.001';
        }
        /*
        $scope.getPic = function(){
          navigator.camera.getPicture(function(uri) {
            alert(uri);
          }, function(message) {
          }, {
            targetWidth : 100,
            targetHeight : 100,
            mediaType : Camera.MediaType.ALLMEDIA,
            popoverOptions : {
              width : 100,
              height : 200,
              arrowDir : Camera.PopoverArrowDirection.ARROW_DOWN
            },
            destinationType : navigator.camera.DestinationType.FILE_URI,
            sourceType : navigator.camera.PictureSourceType.PHOTOLIBRARY
          });
        }
        $scope.takePic = function(){
          try {
            navigator.camera.getPicture(function(imageData){
              var image = $('#img_src_p');
              image.src = "data:image/jpeg;base64," + imageData;
            }, function(){
              alert('failure');
            }, { quality: 50,
              destinationType: Camera.DestinationType.DATA_URL
            });
          } catch (e) {
            alert(e.message);
          }
        }
        */

        $scope.web_path = function () {
            if (ionic.Platform.isIOS()) {
                window.open('http://zkcserv.com/index.html', '_system', 'enableViewportScale=yes');
            } else {
                window.open('http://zkcserv.com/index.html', '_system');
            }
        }

        $scope.about_us = function () {
            if (ionic.Platform.isIOS()) {
                window.open('http://weixin.qq.com/r/ADuEnIjEgtX9rcz-924S', '_system', 'enableViewportScale=yes');
            } else {
                window.open('http://weixin.qq.com/r/ADuEnIjEgtX9rcz-924S', '_system');
            }
        }
		
		
		$scope.service_and_privacy=function(){
		
            if (ionic.Platform.isIOS()) {
                window.open('http://www.zkcserv.com/app/serve_treaty.html', '_system', 'enableViewportScale=yes');
            } else {
                window.open('http://www.zkcserv.com/app/serve_treaty.html', '_system');
            }
		  
		} 
		$scope.privacy_policy=function(){
		
            if (ionic.Platform.isIOS()) {
                window.open('http://www.zkcserv.com/app/secrecy_treaty.html', '_system', 'enableViewportScale=yes');
            } else {
                window.open('http://www.zkcserv.com/app/secrecy_treaty.html', '_system');
            }
		}
		
		
    })




    .controller('sysUserCtrl', function ($scope, sysUserSev, $location, $ionicPopup, $ionicHistory, $rootScope, homemessageSev, $timeout) {
        $scope.isTap = false;
        if (!$(document.body).hasClass('hide-arrow-left')) {
            $(document.body).addClass('hide-arrow-left');
        }

        $scope.$on('$ionicView.afterEnter', function () {
            //进入之后
            if ($(document.body).hasClass('hide-arrow-left')) {
                $(document.body).removeClass('hide-arrow-left');
            }
        });
        $scope.message_setting = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/message_setting");
        }
        $scope.about_app = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/about_app");
        }

		if($('.tab-nav.tabs').css("display","flex").css("display") == "none"){
				$('.tab-nav.tabs').css("display","-webkit-flex");
			}
		$('#adBlock').css("display","none");
		$rootScope.playStatus=true;
        $scope.icon_my_message = local_resource + 'img/icon/icon_my_message@2x.png';
        $scope.icon_modify_password = local_resource + 'img/icon/icon_modify_password@2x.png';
        $scope.icon_about_us = local_resource + 'img/icon/about_clothes.png';
        $scope.change_user = local_resource + 'img/icon/change_user.png';
        $scope.logoff = local_resource + 'img/icon/logoff.png';
        $scope.arrow_right = local_resource + 'img/icon/arrow_right.png';
        $scope.setting_icon = local_resource + 'img/icon/setting_icon.png';
        $scope.cancellation = local_resource + 'img/icon/cancellation.png';
        $scope.my_business_new_icon = local_resource + 'img/icon/my_business_new_icon.png';
        $scope.accounts_security_icon = local_resource + 'img/icon/accounts_security_icon.png';
        $scope.notify_icon = local_resource + 'img/icon/notify_icon.png';
        $scope.about_icon = local_resource + 'img/icon/about_icon.png';


        $scope.edit_data_icon = local_resource + 'img/icon/edit_data_icon.png';
        $scope.change_user_icon = local_resource + 'img/icon/change_user_icon.png';
        $scope.img_exit_trial_login = local_resource + 'img/icon/exit_trial_login.png';
        if (window.localStorage["is_free_trial_login"] != null && typeof (window.localStorage["is_free_trial_login"]) != 'undefined' && window.localStorage["is_free_trial_login"] != '') {
            document.getElementById("home_person_is_trial_login").style.display = 'block';
        } else {
            document.getElementById("home_person_is_trial_login").style.display = 'none';
        }


        $scope.free_trial_log_out = function () {
            $ionicPopup.confirm({
                title: '退出登录',
                template: '<div style="text-align: center;">是否退出系统?</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    //$rootScope.showLoading();
                    $.ajax({
                        type: "GET",
                        url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
                        timeout: _var_timeout,
                        success: function (data) {
                            $rootScope.hideLoading();
                        },
                        error: function (data) {
                            $rootScope.hideLoading();
                            /*
                             $ionicPopup.alert({
                             title : '提醒',
                             template : '<div style="text-align: center;">'+fufu_network_error_msg+'</div>',
                             okText : '确定'
                             });
                             */
                        }
                    });
                    $ionicHistory.clearCache();
                    $ionicHistory.clearHistory();
                    setLocalStorageVar("_pass_word", "");
                    setLocalStorageVar("_is_login", "0");
                    if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
                        var model_list = window.localStorage["menu_list"].split(',');
                        for (var i = 0; i < model_list.length; i++) {
                            if (model_list[i] != '') {
                                setLocalStorageVar(model_list[i], "");
                            }
                        }
                    }
                    setLocalStorageVar("menu_list", "");
                    setLocalStorageVar("menu_home", "");
                    setLocalStorageVar("menu_message", "");
                    setLocalStorageVar("menu_organization_management", "");
                    setLocalStorageVar("menu_time", "");
                    setLocalStorageVar("menu_payroll", "");
                    setLocalStorageVar("menu_ess", "");
                    setLocalStorageVar("menu_My_Team", "");
                    setLocalStorageVar("menu_setting", "");
                    setLocalStorageVar("personnal_data", "");
                    setLocalStorageVar("is_free_trial_login", "");
                    login_init_flag = 0;
                    $location.path('/');

                }
            });
        }

        fufuMobclickAgent('click_home_person');


        $scope.userLogout = function () {
            $ionicPopup.confirm({
                title: '退出登录',
                template: '<div style="text-align: center;">是否退出系统?</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确定'
            }).then(function (res) {
                if (res) {
                    //$rootScope.showLoading();
                    $.ajax({
                        type: "GET",
                        url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
                        timeout: _var_timeout,
                        success: function (data) {
                            $rootScope.hideLoading();
                        },
                        error: function (data) {
                            $rootScope.hideLoading();
                            /*
                             $ionicPopup.alert({
                             title : '提醒',
                             template : '<div style="text-align: center;">'+fufu_network_error_msg+'</div>',
                             okText : '确定'
                             });
                             */
                        }
                    });
                    $ionicHistory.clearCache();
                    $ionicHistory.clearHistory();
                    setLocalStorageVar("_pass_word", "");
                    setLocalStorageVar("_is_login", "0");
                    if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
                        var model_list = window.localStorage["menu_list"].split(',');
                        for (var i = 0; i < model_list.length; i++) {
                            if (model_list[i] != '') {
                                setLocalStorageVar(model_list[i], "");
                            }
                        }
                    }
                    setLocalStorageVar("menu_list", "");
                    setLocalStorageVar("menu_home", "");
                    setLocalStorageVar("menu_message", "");
                    setLocalStorageVar("menu_organization_management", "");
                    setLocalStorageVar("menu_time", "");
                    setLocalStorageVar("menu_payroll", "");
                    setLocalStorageVar("menu_ess", "");
                    setLocalStorageVar("menu_My_Team", "");
                    setLocalStorageVar("menu_setting", "");
                    setLocalStorageVar("personnal_data", "");
                    setLocalStorageVar("is_free_trial_login", "");
                    login_init_flag = 0;
                    $location.path('/');

                }
            });
        }

        $scope.refreshData = function () {
            sysUserSev.refreshData($scope);
        }

        if (window.localStorage["personnal_data"] != null && angular.isDefined(window.localStorage["personnal_data"]) && window.localStorage["personnal_data"] != '') {

            sysUserSev.clearData();
            $scope.personnal_data = sysUserSev.getData();
            sysUserSev.setData($.parseJSON(window.localStorage["personnal_data"]));
            $rootScope.hideLoading();
        } else {
            sysUserSev.clearData();

            sysUserSev.loadData();
            $scope.personnal_data = sysUserSev.getData();
        }



        $scope.edit_data_path = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/personnal_details");
        }
        $scope.personnal_data_path = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/personnal_data_details");
        }

        $scope.my_business = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/my_business");
        }
        $scope.personnal_setting = function () {
            if (!$scope.isTap) {
                return;
            }
            $location.path("home_page/personnal_setting");
        }

        $timeout(function () {
            $scope.isTap = true;
        }, 1000);
    })







    .controller('shiftPolicyCtrl', function ($scope, shiftPolicySev, $location, $stateParams, $ionicPopup, $ionicHistory) {
        $scope.fufu_delete = local_resource + 'img/icon/fufu_delete.png';
        $scope.img_arrow_down = local_resource + 'img/icon/icon_arrow_down02.png';
        shiftPolicySev.clearData();
        shiftPolicySev.loadData();
        $scope.shiftPolicyData = shiftPolicySev.getData();
        $scope.shift_policy_edit = function (policy_id) {
            $location.path('home_page/home_menulist/shift_policy_edit/' + policy_id);
        }
        $scope.shift_policy_delete = function (policy_id) {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    shiftPolicySev.shiftPolicyDelete(policy_id);
                }
            })
        }

    })

    .controller('shiftPolicyAddCtrl', function ($scope, shiftPolicyAddSev, $stateParams, $location, $ionicPopup, $ionicHistory, timeSelect, sideSelect) {
        shiftPolicyAddSev.clearData();
        shiftPolicyAddSev.loadData();
        $scope.shiftPolicyAddData = shiftPolicyAddSev.getData();
        $scope.first_in = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyAddData.first_in,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyAddData.first_in = date;
                    }
                }
            })
        }

        $scope.first_out = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyAddData.first_out,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyAddData.first_out = date;
                    }
                }
            })
        }
        $scope.second_in = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: startDate,
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyAddData.second_in,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyAddData.second_in = date;
                    }
                }
            })
        }
        $scope.second_out = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyAddData.second_out,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyAddData.second_out = date;
                    }
                }
            })
        }
        $scope.first_in_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.first_in_need_index = 0;
        $scope.first_in_need_clock = function () {
            $scope.shiftPolicyAddData.first_in_need_clock == '1' ? $scope.first_in_need_index = 0 : $scope.first_in_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.first_in_need_data,
                selectIndex: $scope.first_in_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("first_in_need_clock").innerHTML = $scope.first_in_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyAddData.first_in_need_clock = 1 : $scope.shiftPolicyAddData.first_in_need_clock = 0;
                        $scope.first_in_need_index = index;
                    }

                }
            });
        }


        $scope.first_out_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.first_out_need_index = 0;
        $scope.first_out_need_clock = function () {
            $scope.shiftPolicyAddData.first_out_need_clock == '1' ? $scope.first_out_need_index = 0 : $scope.first_out_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.first_out_need_data,
                selectIndex: $scope.first_out_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("first_out_need_clock").innerHTML = $scope.first_out_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyAddData.first_out_need_clock = '1' : $scope.shiftPolicyAddData.first_out_need_clock = '0';
                        $scope.first_out_need_index = index;
                    }

                }
            });
        }

        $scope.second_in_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.second_in_need_index = 0;
        $scope.second_in_need_clock = function () {
            $scope.shiftPolicyAddData.second_in_need_clock == '1' ? $scope.second_in_need_index = 0 : $scope.second_in_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.second_in_need_data,
                selectIndex: $scope.second_in_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("second_in_need_clock").innerHTML = $scope.second_in_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyAddData.second_in_need_clock = '1' : $scope.shiftPolicyAddData.second_in_need_clock = '0';
                        $scope.second_in_need_index = index;
                    }

                }
            });
        }

        $scope.second_out_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.second_out_need_index = 0;
        $scope.second_out_need_clock = function () {
            $scope.shiftPolicyAddData.second_out_need_clock == '1' ? $scope.second_out_need_index = 0 : $scope.second_out_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.second_out_need_data,
                selectIndex: $scope.second_out_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("second_out_need_clock").innerHTML = $scope.second_out_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyAddData.second_out_need_clock = '1' : $scope.shiftPolicyAddData.second_out_need_clock = '0';
                        $scope.second_out_need_index = index;
                    }

                }
            });
        }
        $scope.shift_policy_add_save = function () {
            shiftPolicyAddSev.shift_policy_add_save();
        }
    })

    .controller('shiftPolicyEditCtrl', function ($scope, shiftPolicyEditSev, $stateParams, $location, $ionicPopup, $ionicHistory, timeSelect, sideSelect) {
        shiftPolicyEditSev.clearData();
        shiftPolicyEditSev.loadData($stateParams.shift_policy_id);
        $scope.shiftPolicyEditData = shiftPolicyEditSev.getData();
        $scope.first_in = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyEditData.first_in,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyEditData.first_in = date;
                    }
                }
            })
        }

        $scope.first_out = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyEditData.first_out,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyEditData.first_out = date;
                    }
                }
            })
        }
        $scope.second_in = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: startDate,
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyEditData.second_in,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyEditData.second_in = date;
                    }
                }
            })
        }
        $scope.second_out = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.shiftPolicyEditData.second_out,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.shiftPolicyEditData.second_out = date;
                    }
                }
            })
        }
        $scope.first_in_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.first_in_need_index = 0;
        $scope.first_in_need_clock = function () {
            $scope.shiftPolicyEditData.first_in_need_clock == '1' ? $scope.first_in_need_index = 0 : $scope.first_in_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.first_in_need_data,
                selectIndex: $scope.first_in_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("first_in_need_clock").innerHTML = $scope.first_in_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyEditData.first_in_need_clock = 1 : $scope.shiftPolicyEditData.first_in_need_clock = 0;
                        $scope.first_in_need_index = index;
                    }

                }
            });
        }


        $scope.first_out_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.first_out_need_index = 0;
        $scope.first_out_need_clock = function () {
            $scope.shiftPolicyEditData.first_out_need_clock == '1' ? $scope.first_out_need_index = 0 : $scope.first_out_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.first_out_need_data,
                selectIndex: $scope.first_out_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("first_out_need_clock").innerHTML = $scope.first_out_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyEditData.first_out_need_clock = '1' : $scope.shiftPolicyEditData.first_out_need_clock = '0';
                        $scope.first_out_need_index = index;
                    }

                }
            });
        }

        $scope.second_in_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.second_in_need_index = 0;
        $scope.second_in_need_clock = function () {
            $scope.shiftPolicyEditData.second_in_need_clock == '1' ? $scope.second_in_need_index = 0 : $scope.second_in_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.second_in_need_data,
                selectIndex: $scope.second_in_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("second_in_need_clock").innerHTML = $scope.second_in_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyEditData.second_in_need_clock = '1' : $scope.shiftPolicyEditData.second_in_need_clock = '0';
                        $scope.second_in_need_index = index;
                    }

                }
            });
        }

        $scope.second_out_need_data = [{
            key: '0',
            value: '需打卡'
        }, {
            key: '1',
            value: '已关闭'
        }]
        $scope.second_out_need_index = 0;
        $scope.second_out_need_clock = function () {
            $scope.shiftPolicyEditData.second_out_need_clock == '1' ? $scope.second_out_need_index = 0 : $scope.second_out_need_index = 1;
            sideSelect.show({
                type: 'ios',
                data: $scope.second_out_need_data,
                selectIndex: $scope.second_out_need_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("second_out_need_clock").innerHTML = $scope.second_out_need_data[index].value;
                        index == '0' ? $scope.shiftPolicyEditData.second_out_need_clock = '1' : $scope.shiftPolicyEditData.second_out_need_clock = '0';
                        $scope.second_out_need_index = index;
                    }

                }
            });
        }

        $scope.shift_policy_edit_save = function (policy_id) {
            shiftPolicyEditSev.shift_policy_edit_save(policy_id);
        }
    })

    .controller('shiftGroupCtrl', function ($scope,$rootScope, shiftGroupSev, $location, $stateParams, $ionicPopup, $ionicHistory) {
        shiftGroupSev.clearData();
        shiftGroupSev.loadData();
        $scope.shiftGroupData = shiftGroupSev.getData();
        $scope.img_delete = local_resource + 'img/icon/fufu_delete.png';
        $scope.shift_group_edit = function (shift_group_id) {
            $location.path('home_page/home_menulist/shift_group_edit/' + shift_group_id);
        }
        $scope.shift_group_delete = function (shift_group_id, shift_group_name) {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除吗?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    shiftGroupSev.shiftGroupDelete(shift_group_id, shift_group_name);
                }
            })

        }
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
    })

    .controller('shiftGroupAddCtrl', function ($scope, shiftGroupAddSev, $stateParams, $location, $ionicPopup, $ionicHistory, sideSelect) {
        shiftGroupAddSev.clearData();
        shiftGroupAddSev.loadData();
        $scope.shiftGroupAddData = shiftGroupAddSev.getData();

        $scope.colorStyle = {
            cccc: {
                "color": "#ccc"
            },
            c333: {
                "color": "#333"
            }
        }

        $scope.shift_group_add_save = function () {
            shiftGroupAddSev.shift_group_add_save();
        }

        $scope.set_default_shift = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.shiftGroupAddData.shift_policy,
                selectIndex: $scope.shiftGroupAddData.shift_policy_index,
                selectedFunc: function (index) {
                    if (index == undefined) {
                        $scope.shiftGroupAddData.shift_policy_index = undefined;
                        $scope.shiftGroupAddData.shift_policy_key = "";
                        $scope.shiftGroupAddData.shift_policy_value = "";
                    } else {
                        $scope.shiftGroupAddData.shift_policy_index = index;
                        $scope.shiftGroupAddData.shift_policy_key = $scope.shiftGroupAddData.shift_policy[index].key;
                        $scope.shiftGroupAddData.shift_policy_value = $scope.shiftGroupAddData.shift_policy[index].value;
                    }

                }
            });
        }

        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.shiftGroupAddData.sub_bu_list,
                selectIndex: $scope.shiftGroupAddData.sub_bu_index,
                selectedFunc: function (index) {


                    if (index == undefined) {
                        $scope.shiftGroupAddData.sub_bu_index = undefined;
                        $scope.shiftGroupAddData.sub_bu_key = "";
                        $scope.shiftGroupAddData.sub_bu_value = "";
                    } else {
                        $scope.shiftGroupAddData.sub_bu_key = $scope.shiftGroupAddData.sub_bu_list[index].key;
                        $scope.shiftGroupAddData.sub_bu_value = $scope.shiftGroupAddData.sub_bu_list[index].value;
                        $scope.shiftGroupAddData.sub_bu_index = index;
                    }
                }
            });
        }
    })

    .controller('shiftGroupAddPolicyPickerCtrl', function ($scope, shiftGroupAddPolicyPickerSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        shiftGroupAddPolicyPickerSev.clearData();
        shiftGroupAddPolicyPickerSev.loadData();
        $scope.shiftGroupAddPolicyPickerData = shiftGroupAddPolicyPickerSev.getData();


        $scope.search_val = "";
        var str = $("#policy_id_list").html();

        $scope.selCt = 0;
        if (str != '' && str.length != 0) {
            $scope.selCt = (str.split(',')).length;
        }

        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.selCt = $scope.selCt + 1;
            } else {
                $scope.selCt = $scope.selCt - 1;
            }
        }
        $scope.rtAction = function () {
            var data = $scope.shiftGroupAddPolicyPickerData;
            var policy_name_list = '';
            var policy_id_list = '';
            for (var i = 0; i < data.length; i++) {
                if (data[i].checked == true) {
                    policy_name_list = policy_name_list + data[i].policy_name + ',';
                    policy_id_list = policy_id_list + data[i].policy_id + ',';
                }
            }


            var set_html = policy_name_list.substring(0, policy_name_list.length - 1);
            $("#policy_name_list").css({
                "color": set_html.length ? "#333" : "#CCC"
            });
            $("#policy_name_list").html(set_html.length ? set_html : "未添加班次");


            $("#policy_id_list").html(policy_id_list.substring(0, policy_id_list.length - 1));


            $ionicHistory.goBack();
        }
    })

    .controller('shiftGroupAddEmployeeSelectCtrl', function ($scope, shiftGroupAddEmployeeSelectSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        shiftGroupAddEmployeeSelectSev.clearData();
        shiftGroupAddEmployeeSelectSev.loadData();
        $scope.shiftGroupAddEmployeeSelectData = shiftGroupAddEmployeeSelectSev.getData();
        $scope.img_no_notice = local_resource + 'img/icon/no_notice01.png';
        $scope.img_notice = local_resource + 'img/icon/notice01.png';
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.shiftGroupAddEmployeeSelectData.total_checked++;
            } else {
                $scope.shiftGroupAddEmployeeSelectData.total_checked--;
            }
            $scope.shiftGroupAddEmployeeSelectData.show_footer_bar = true;

            if ($scope.shiftGroupAddEmployeeSelectData.total_checked == $scope.shiftGroupAddEmployeeSelectData.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }




        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            $scope.shiftGroupAddEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.shiftGroupAddEmployeeSelectData.total_checked = $scope.shiftGroupAddEmployeeSelectData.data.length;
            $scope.shiftGroupAddEmployeeSelectData.show_footer_bar = true;
            for (var i = 0; i < $scope.shiftGroupAddEmployeeSelectData.data.length; i++) {
                $scope.shiftGroupAddEmployeeSelectData.data[i].ck = true;
            }
        }
        $scope.select_all_employee_cancel = function () {
            //$scope.all_selected = false;
            $scope.shiftGroupAddEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.shiftGroupAddEmployeeSelectData.total_checked = 0;

            for (var i = 0; i < $scope.shiftGroupAddEmployeeSelectData.data.length; i++) {
                $scope.shiftGroupAddEmployeeSelectData.data[i].ck = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.cancel = function () {
            var temp_total_checked = 0;
            var employee_list = $('#shift_group_add_empl_list_hidden').val();
            var SelectData_data = $scope.shiftGroupAddEmployeeSelectData.data;
            employee_list = employee_list + ",";
            for (var i = 0; i < SelectData_data.length; i++) {
                if (employee_list.indexOf(SelectData_data[i].emp + ",") == -1) {
                    SelectData_data[i].ck = false;
                } else {
                    SelectData_data[i].ck = true;
                    temp_total_checked++;
                }
            }
            $scope.shiftGroupAddEmployeeSelectData.data = SelectData_data;
            $scope.shiftGroupAddEmployeeSelectData.show_footer_bar = false;
            $scope.shiftGroupAddEmployeeSelectData.total_checked = temp_total_checked;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }


        $scope.shift_group_add_employee_select_save = function () {
            var _empl_list = '';
            var _staff_no_list = '';
            for (var i = 0; i < $scope.shiftGroupAddEmployeeSelectData.data.length; i++) {
                if ($scope.shiftGroupAddEmployeeSelectData.data[i].ck == true) {
                    _empl_list = _empl_list + $scope.shiftGroupAddEmployeeSelectData.data[i].en + ',';
                    _staff_no_list = _staff_no_list + $scope.shiftGroupAddEmployeeSelectData.data[i].emp + ',';
                }
            }
            $("#shift_group_add_empl_list").val(_empl_list.substring(0, _empl_list.length - 1));
            $("#shift_group_add_empl_list_hidden").val(_staff_no_list.substring(0, _staff_no_list.length - 1));
            $ionicHistory.goBack();
        }

    })

    .controller('shiftGroupEditCtrl', function ($scope, shiftGroupEditSev, $stateParams, $location, $ionicPopup, $ionicHistory, sideSelect) {
        shiftGroupEditSev.clearData();
        shiftGroupEditSev.loadData($stateParams.shift_group_id);
        $scope.shiftGroupEditData = shiftGroupEditSev.getData();

        $scope.colorStyle = {
            cccc: {
                "color": "#ccc"
            },
            c333: {
                "color": "#333"
            }
        }



        $scope.shift_group_edit_save = function () {
            shiftGroupEditSev.shift_group_edit_save();
        }

        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.shiftGroupEditData.sub_bu_list,
                selectIndex: $scope.shiftGroupEditData.sub_bu_index,
                selectedFunc: function (index) {


                    if (index == undefined) {
                        $scope.shiftGroupEditData.sub_bu_index = undefined;
                        $scope.shiftGroupEditData.sub_bu_key = "";
                        $scope.shiftGroupEditData.sub_bu_value = "";
                    } else {
                        $scope.shiftGroupEditData.sub_bu_key = $scope.shiftGroupEditData.sub_bu_list[index].key;
                        $scope.shiftGroupEditData.sub_bu_value = $scope.shiftGroupEditData.sub_bu_list[index].value;
                        $scope.shiftGroupEditData.sub_bu_index = index;
                    }
                }
            });
        }

        $scope.set_default_shift = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.shiftGroupEditData.shift_policy,
                selectIndex: $scope.shiftGroupEditData.shift_policy_index,
                selectedFunc: function (index) {
                    if (index == undefined) {
                        $scope.shiftGroupEditData.shift_policy_index = undefined;
                        $scope.shiftGroupEditData.shift_policy_key = "";
                        $scope.shiftGroupEditData.shift_policy_value = "";
                    } else {
                        $scope.shiftGroupEditData.shift_policy_key = $scope.shiftGroupEditData.shift_policy[index].key;
                        $scope.shiftGroupEditData.shift_policy_value = $scope.shiftGroupEditData.shift_policy[index].value;
                        $scope.shiftGroupEditData.shift_policy_index = index;

                    }

                }
            });
        }

    })

    .controller('shiftGroupEditEmployeeSelectCtrl', function ($scope, shiftGroupEditEmployeeSelectSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        shiftGroupEditEmployeeSelectSev.clearData();
        shiftGroupEditEmployeeSelectSev.loadData();
        $scope.shiftGroupEditEmployeeSelectData = shiftGroupEditEmployeeSelectSev.getData();
        $scope.img_no_notice = local_resource + 'img/icon/no_notice01.png';
        $scope.img_notice = local_resource + 'img/icon/notice01.png';
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.shiftGroupEditEmployeeSelectData.total_checked++;
            } else {
                $scope.shiftGroupEditEmployeeSelectData.total_checked--;
            }
            $scope.shiftGroupEditEmployeeSelectData.show_footer_bar = true;

            if ($scope.shiftGroupEditEmployeeSelectData.total_checked == $scope.shiftGroupEditEmployeeSelectData.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            $scope.shiftGroupEditEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.shiftGroupEditEmployeeSelectData.total_checked = $scope.shiftGroupEditEmployeeSelectData.data.length;
            $scope.shiftGroupEditEmployeeSelectData.show_footer_bar = true;
            for (var i = 0; i < $scope.shiftGroupEditEmployeeSelectData.data.length; i++) {
                $scope.shiftGroupEditEmployeeSelectData.data[i].ck = true;
            }
        }
        $scope.select_all_employee_cancel = function () {
            //$scope.all_selected = false;
            $scope.shiftGroupEditEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.shiftGroupEditEmployeeSelectData.total_checked = 0;

            for (var i = 0; i < $scope.shiftGroupEditEmployeeSelectData.data.length; i++) {
                $scope.shiftGroupEditEmployeeSelectData.data[i].ck = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.cancel = function () {
            var employee_list = $('#shift_group_edit_empl_list_hidden').val();
            var temp_total_checked = 0;
            //alert(employee_list);
            var SelectData_data = $scope.shiftGroupEditEmployeeSelectData.data;
            employee_list = employee_list + ",";
            for (var i = 0; i < SelectData_data.length; i++) {
                if (employee_list.indexOf(SelectData_data[i].emp + ",") == -1) {
                    SelectData_data[i].ck = false;
                } else {
                    SelectData_data[i].ck = true;
                    temp_total_checked++;
                }
            }
            $scope.shiftGroupEditEmployeeSelectData.data = SelectData_data;
            $scope.shiftGroupEditEmployeeSelectData.show_footer_bar = false;
            $scope.shiftGroupEditEmployeeSelectData.total_checked = temp_total_checked;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.shift_group_edit_employee_select_save = function () {
            var _empl_list = '';
            var _staff_no_list = '';
            for (var i = 0; i < $scope.shiftGroupEditEmployeeSelectData.data.length; i++) {
                if ($scope.shiftGroupEditEmployeeSelectData.data[i].ck == true) {
                    _empl_list = _empl_list + $scope.shiftGroupEditEmployeeSelectData.data[i].en + ',';
                    _staff_no_list = _staff_no_list + $scope.shiftGroupEditEmployeeSelectData.data[i].emp + ',';
                }
            }
            $("#shift_group_edit_empl_list").val(_empl_list.substring(0, _empl_list.length - 1));
            $("#shift_group_edit_empl_list_hidden").val(_staff_no_list.substring(0, _staff_no_list.length - 1));
            $ionicHistory.goBack();
        }

    })

    .controller('holidayPolicyCtrl', function ($scope, holidayPolicySev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        /*Sunny改*/
        $scope.ot_normal = local_resource + 'img/icon/dot_normal.png';
        $scope.dot_abnormal = local_resource + 'img/icon/dot_abnormal.png';
        /*Sunny改*/
        if (ionic.Platform.isIOS()) {
            holidayPolicySev.clearData();
            holidayPolicySev.loadData();
            $scope.holidayPolicyData = holidayPolicySev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                holidayPolicySev.clearData();
                holidayPolicySev.loadData();
                $scope.holidayPolicyData = holidayPolicySev.getData();
            });
        }
        //holidayPolicySev.clearData();
        //holidayPolicySev.loadData();
        //$scope.holidayPolicyData = holidayPolicySev.getData();
        $scope.holiday_policy_delete = function (holiday_policy_id) {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    holidayPolicySev.holiday_policy_delete(holiday_policy_id);
                }
            });

        }
        $scope.holiday_policy_edit = function (holiday_policy_id, holiday_policy_name) {
            $location.path('home_page/home_menulist/holiday_policy_edit/' + holiday_policy_id + '/' + holiday_policy_name);
        }


    })

    .controller('holidayPolicyAddCtrl', function ($scope, holidayPolicyAddSev, $stateParams, $location, $ionicPopup, $ionicHistory, sideSelect) {
        holidayPolicyAddSev.clearData();
        holidayPolicyAddSev.loadData();
        $scope.holidayPolicyAddData = holidayPolicyAddSev.getData();
        $scope.holiday_policy_add_save = function () {
            holidayPolicyAddSev.holiday_policy_add_save();
        }

        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.holidayPolicyAddData.sub_bu_list,
                selectIndex: $scope.holidayPolicyAddData.sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.holidayPolicyAddData.sub_bu_key = $scope.holidayPolicyAddData.sub_bu_list[index].key;
                        $scope.holidayPolicyAddData.sub_bu_value = $scope.holidayPolicyAddData.sub_bu_list[index].value;
                        $scope.holidayPolicyAddData.sub_bu_index = index;
                    }
                }
            });
        }

    })

    .controller('holidayPolicyEditCtrl', function ($scope, holidayPolicyEditSev, $stateParams, $location, $ionicPopup, $ionicHistory, timeSelect, sideSelect, $ionicScrollDelegate) {
        $scope.img_national_holiday = local_resource + 'img/icon/dot_national_holiday.png';
        $scope.img_public_holiday = local_resource + 'img/icon/dot_public_holiday.png';
        $scope.img_other_holiday = local_resource + 'img/icon/dot_other_holiday.png';
        $scope.img_add = local_resource + 'img/icon/fufu_add_to.png';
        $scope.img_edit = local_resource + 'img/icon/fufu_edit.png';
        $scope.img_delete = local_resource + 'img/icon/fufu_delete.png';

        var current_date = new Date();
        var obj = $('#calendar_date_input1');

        current_date = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
        obj.val(current_date);
        document.getElementById('calendar_date_input').innerHTML = current_date;
        $scope.toolbar_title = $stateParams.holiday_policy_name;

        $scope.load_data = function () {
            holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
        }

        $scope.holiday_policy_detail_delete = function () {
            holidayPolicyEditSev.holiday_policy_detail_delete($scope);
        }

        $scope.holiday_policy_detail_edit_mode = function () {
            $scope.holidayPolicyEditData.current_holiday.temp_holiday_name = $scope.holidayPolicyEditData.current_holiday.holiday_name;
            $scope.holidayPolicyEditData.current_holiday.temp_ct_days = $scope.holidayPolicyEditData.current_holiday.ct_days;
            $scope.holidayPolicyEditData.temp_holiday_type_data_key = $scope.holidayPolicyEditData.holiday_type_data_key;
            $scope.holidayPolicyEditData.temp_holiday_type_data_value = $scope.holidayPolicyEditData.holiday_type_data_value;
            holidayPolicyEditSev.setEditMode(true);
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.holiday_policy_detail_cancel_edit_mode = function () {
            $scope.holidayPolicyEditData.current_holiday.holiday_name = $scope.holidayPolicyEditData.current_holiday.temp_holiday_name;
            $scope.holidayPolicyEditData.current_holiday.ct_days = $scope.holidayPolicyEditData.current_holiday.temp_ct_days;
            $scope.holidayPolicyEditData.Holiday_type_key = $scope.holidayPolicyEditData.holiday_type_data_key;
            $scope.holidayPolicyEditData.Holiday_type_index = $scope.holidayPolicyEditData.holiday_type_data_index;
            holidayPolicyEditSev.setEditMode(false);

            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.holiday_type = function () {

            sideSelect.show({
                type: 'ios',
                data: $scope.holidayPolicyEditData.holiday_type_data,
                selectIndex: $scope.holidayPolicyEditData.holiday_type_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("holiday_type").innerHTML = $scope.holidayPolicyEditData.holiday_type_data[index].value;
                        $scope.holidayPolicyEditData.holiday_type_data_key = $scope.holidayPolicyEditData.holiday_type_data[index].key;
                        $scope.holidayPolicyEditData.holiday_type_index = index;
                    }

                }
            });
        }

        holidayPolicyEditSev.clearData();
        holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
        $scope.holidayPolicyEditData = holidayPolicyEditSev.getData();

        obj.change(function () {
            holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
        });

        $scope.loadByMonth = function (_flag) {
            if (_flag == 'c') {} else {
                var arr = (obj.val()).split('-');
                var year = arr[0];
                var month = arr[1];
                var day = arr[2];
                var days = new Date(year, month, 0);
                days = days.getDate();
                var year2 = year;
                if (_flag == 'p') {
                    var month2 = parseInt(month) - 1;
                    if (month2 == 0) {
                        year2 = parseInt(year2) - 1;
                        month2 = 12;
                    }
                } else {
                    var month2 = parseInt(month) + 1;
                    if (month2 == 13) {
                        year2 = parseInt(year2) + 1;
                        month2 = 1;
                    }
                }
                var day2 = day;
                var days2 = new Date(year2, month2, 0);
                days2 = days2.getDate();
                if (day2 > days2) {
                    day2 = days2;
                }
                if (month2 < 10) {
                    month2 = '0' + month2;
                }
                obj.val(year2 + '-' + month2 + '-' + day2);
                document.getElementById('calendar_date_input').innerHTML = year2 + '-' + month2 + '-' + day2;
            }
            holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
        }
        $scope.calendar_date_input = function () {
            var current_date = new Date();

            current_date = current_date.getFullYear();
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("calendar_date_input").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("calendar_date_input").innerHTML = date;
                        obj.val(date);
                        holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
                    }
                }
            })
        }
        $scope.loadDetail = function (_day, curobj) {
            if (_day == '') return;
            $("._ar_c").removeClass("_ar_c");
            $(curobj.currentTarget).addClass("_ar_c");
            var _day = parseInt(_day);
            var arr = (document.getElementById('calendar_date_input').innerHTML).split('-');
            if (_day < 10) {
                _day = '0' + _day;
            }
            obj.val(arr[0] + '-' + arr[1] + '-' + _day);
            document.getElementById('calendar_date_input').innerHTML = arr[0] + '-' + arr[1] + '-' + _day
            holidayPolicyEditSev.loadData($stateParams.holiday_policy_id, obj.val());
        }

        $scope.holiday_policy_detail_save = function () {

            holidayPolicyEditSev.holiday_policy_detail_save($stateParams.holiday_policy_id, $stateParams.holiday_policy_name, $scope);

            //holidayPolicyEditSev.loadData($stateParams.holiday_policy_id,obj.val());
        }

        $scope.holiday_policy_edit_employee_select = function () {
            $location.path('home_page/home_menulist/holiday_policy_edit_employee_select/' + $stateParams.holiday_policy_id);
        }


        $scope.sub_bu_select = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.holidayPolicyEditData.sub_bu_list,
                selectIndex: $scope.holidayPolicyEditData.sub_bu_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        $scope.holidayPolicyEditData.sub_bu_key = $scope.holidayPolicyEditData.sub_bu_list[index].key;
                        $scope.holidayPolicyEditData.sub_bu_value = $scope.holidayPolicyEditData.sub_bu_list[index].value;
                        $scope.holidayPolicyEditData.sub_bu_index = index;
                        holidayPolicyEditSev.holidayPolicySubBuSave($stateParams.holiday_policy_id);
                    }
                }
            });
        }

    })

    .controller('holidayPolicyAddEmployeeSelectCtrl', function ($scope, holidayPolicyAddEmployeeSelectSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        holidayPolicyAddEmployeeSelectSev.clearData();
        holidayPolicyAddEmployeeSelectSev.loadData();
        $scope.holidayPolicyAddEmployeeSelectData = holidayPolicyAddEmployeeSelectSev.getData();
        $scope.img_no_policy = local_resource + 'img/icon/no_announcement_notice01.png';
        $scope.img_has_policy = local_resource + 'img/icon/Announcement_notice01.png';
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.holidayPolicyAddEmployeeSelectData.total_checked++;
            } else {
                $scope.holidayPolicyAddEmployeeSelectData.total_checked--;
            }
            $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = true;

            if ($scope.holidayPolicyAddEmployeeSelectData.total_checked == $scope.holidayPolicyAddEmployeeSelectData.data.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.holidayPolicyAddEmployeeSelectData.total_checked = $scope.holidayPolicyAddEmployeeSelectData.data.length;
            $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = true;
            for (var i = 0; i < $scope.holidayPolicyAddEmployeeSelectData.data.length; i++) {
                $scope.holidayPolicyAddEmployeeSelectData.data[i].ck = true;
            }
        }
        $scope.select_all_employee_cancel = function () {
            //$scope.all_selected = false;
            $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.holidayPolicyAddEmployeeSelectData.total_checked = 0;

            for (var i = 0; i < $scope.holidayPolicyAddEmployeeSelectData.data.length; i++) {
                $scope.holidayPolicyAddEmployeeSelectData.data[i].ck = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.cancel = function () {
            /*   document.getElementById('select_all_employee').style.display = "block";
      document.getElementById('deselect_all_employee').style.display = "none";
      $scope.holidayPolicyAddEmployeeSelectData.total_checked = 0;
      $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = false;
      for (var i=0;i<$scope.holidayPolicyAddEmployeeSelectData.data.length;i++){
        $scope.holidayPolicyAddEmployeeSelectData.data[i].ck = false;
      }
      setTimeout(function(){ $ionicScrollDelegate.resize();}, 200);

	  */



            var temp_total_checked = 0;
            var employee_list = $('#holiday_policy_add_empl_list_hidden').val();
            var SelectData_data = $scope.holidayPolicyAddEmployeeSelectData.data;
            employee_list = employee_list + ",";
            for (var i = 0; i < SelectData_data.length; i++) {
                if (employee_list.indexOf(SelectData_data[i].emp + ",") == -1) {
                    SelectData_data[i].ck = false;
                } else {
                    SelectData_data[i].ck = true;
                    temp_total_checked++;
                }
            }
            $scope.holidayPolicyAddEmployeeSelectData.data = SelectData_data;
            $scope.holidayPolicyAddEmployeeSelectData.show_footer_bar = false;
            $scope.holidayPolicyAddEmployeeSelectData.total_checked = temp_total_checked;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);




        }

        $scope.holiday_policy_add_employee_select_save = function () {
            var _empl_list = '';
            var _staff_no_list = '';
            for (var i = 0; i < $scope.holidayPolicyAddEmployeeSelectData.data.length; i++) {
                if ($scope.holidayPolicyAddEmployeeSelectData.data[i].ck == true) {
                    _empl_list = _empl_list + $scope.holidayPolicyAddEmployeeSelectData.data[i].en + ',';
                    _staff_no_list = _staff_no_list + $scope.holidayPolicyAddEmployeeSelectData.data[i].emp + ',';
                }
            }
            $("#holiday_policy_add_empl_list").val(_empl_list.substring(0, _empl_list.length - 1));
            $("#holiday_policy_add_empl_list_hidden").val(_staff_no_list.substring(0, _staff_no_list.length - 1));
            $ionicHistory.goBack();
        }

    })

    .controller('holidayPolicyEditEmployeeSelectCtrl', function ($scope, holidayPolicyEditEmployeeSelectSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        holidayPolicyEditEmployeeSelectSev.clearData();
        holidayPolicyEditEmployeeSelectSev.loadData($stateParams.holiday_policy_id);
        $scope.holidayPolicyEditEmployeeSelectData = holidayPolicyEditEmployeeSelectSev.getData();
        $scope.img_no_policy = local_resource + 'img/icon/no_announcement_notice01.png';
        $scope.img_has_policy = local_resource + 'img/icon/Announcement_notice01.png';
        $scope.ckItem = function (_flag) {
            if (_flag == true) {
                $scope.holidayPolicyEditEmployeeSelectData.total_checked++;
            } else {
                $scope.holidayPolicyEditEmployeeSelectData.total_checked--;
            }
            $scope.holidayPolicyEditEmployeeSelectData.show_footer_bar = true;

            if ($scope.holidayPolicyEditEmployeeSelectData.total_checked == $scope.holidayPolicyEditEmployeeSelectData.data.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            $scope.holidayPolicyEditEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.holidayPolicyEditEmployeeSelectData.total_checked = $scope.holidayPolicyEditEmployeeSelectData.data.length;
            $scope.holidayPolicyEditEmployeeSelectData.show_footer_bar = true;
            for (var i = 0; i < $scope.holidayPolicyEditEmployeeSelectData.data.length; i++) {
                $scope.holidayPolicyEditEmployeeSelectData.data[i].ck = true;
            }
        }
        $scope.select_all_employee_cancel = function () {
            //$scope.all_selected = false;
            $scope.holidayPolicyEditEmployeeSelectData.show_footer_bar = true;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.holidayPolicyEditEmployeeSelectData.total_checked = 0;

            for (var i = 0; i < $scope.holidayPolicyEditEmployeeSelectData.data.length; i++) {
                $scope.holidayPolicyEditEmployeeSelectData.data[i].ck = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.cancel = function () {
            var employee_list = $scope.holidayPolicyEditEmployeeSelectData.string;
            var SelectData_data = $scope.holidayPolicyEditEmployeeSelectData.data;
            var temp_total_checked = 0;
            for (var i = 0; i < SelectData_data.length; i++) {
                if (employee_list.indexOf(SelectData_data[i].emp + ",") == -1) {
                    SelectData_data[i].ck = false;
                } else {
                    SelectData_data[i].ck = true;
                    temp_total_checked++;
                }
            }
            $scope.holidayPolicyEditEmployeeSelectData.total_checked = temp_total_checked;
            $scope.holidayPolicyEditEmployeeSelectData.data = SelectData_data;
            $scope.holidayPolicyEditEmployeeSelectData.show_footer_bar = false;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.holiday_policy_edit_employee_select_save = function () {
            holidayPolicyEditEmployeeSelectSev.holiday_policy_edit_employee_select_save($stateParams.holiday_policy_id);
        }

    })


    .controller('lvCodeSettingCtrl', function ($scope,$rootScope, lvCodeSettingSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.local_resource = local_resource;
        lvCodeSettingSev.clearData();
        lvCodeSettingSev.loadData();
        $scope.lvCodeSettingData = lvCodeSettingSev.getData();
        $scope.lv_code_setting_detail = function (lv_code_id, lv_code_name, has_balance) {
            $location.path('home_page/home_menulist/lv_code_setting_detail/' + lv_code_id + '/' + lv_code_name + '/' + has_balance);
        }
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
    })

    .controller('lvCodeSettingDetailCtrl', function ($scope, lvCodeSettingDetailSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        lvCodeSettingDetailSev.clearData();
        lvCodeSettingDetailSev.loadData($stateParams.lv_code_id, $stateParams.lv_code_name, $stateParams.has_balance);
        $scope.lvCodeSettingDetailData = lvCodeSettingDetailSev.getData();

        $scope.toolbar_title = $stateParams.lv_code_name + "设置";
        $scope.lv_code_name = $stateParams.lv_code_name;

        if ($stateParams.has_balance == '0') {
            document.getElementById('lv_code_has_balance').style.display = "none";
        }



        $scope.picklist_min_unit = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#min_unit').val();
            var checked_value = $('#min_unit_name').html();
            var picklist_title = '休假最小单位';
            var return_key_field_id = 'min_unit';
            var return_value_field_id = 'min_unit_name'


            for (var i = 0; i < $scope.lvCodeSettingDetailData.min_unit_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.lvCodeSettingDetailData.min_unit_list[i].key;
                picklist_value_list = picklist_value_list + $scope.lvCodeSettingDetailData.min_unit_list[i].name;
                if (i < $scope.lvCodeSettingDetailData.min_unit_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_min_unit/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }

        $scope.picklist_exit_action = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#exit_action').val();
            var checked_value = $('#exit_action_name').html();
            var picklist_title = '未休完年假处理';
            var return_key_field_id = 'exit_action';
            var return_value_field_id = 'exit_action_name'

            for (var i = 0; i < $scope.lvCodeSettingDetailData.exit_action_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.lvCodeSettingDetailData.exit_action_list[i].key;
                picklist_value_list = picklist_value_list + $scope.lvCodeSettingDetailData.exit_action_list[i].name;
                if (i < $scope.lvCodeSettingDetailData.exit_action_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }

        $scope.picklist_cutoff_type = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#cutoff_type').val();
            var checked_value = $('#cutoff_type_name').html();
            var picklist_title = '年结方式';
            var return_key_field_id = 'cutoff_type';
            var return_value_field_id = 'cutoff_type_name'

            for (var i = 0; i < $scope.lvCodeSettingDetailData.cutoff_type_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.lvCodeSettingDetailData.cutoff_type_list[i].key;
                picklist_value_list = picklist_value_list + $scope.lvCodeSettingDetailData.cutoff_type_list[i].name;
                if (i < $scope.lvCodeSettingDetailData.cutoff_type_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }


        $scope.picklist_entitle_begin_date = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#entitle_begin_date').val();
            var checked_value = $('#entitle_begin_date_name').html();
            var picklist_title = '开始日期';
            var return_key_field_id = 'entitle_begin_date';
            var return_value_field_id = 'entitle_begin_date_name'

            for (var i = 0; i < $scope.lvCodeSettingDetailData.entitle_begin_date_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.lvCodeSettingDetailData.entitle_begin_date_list[i].key;
                picklist_value_list = picklist_value_list + $scope.lvCodeSettingDetailData.entitle_begin_date_list[i].name;
                if (i < $scope.lvCodeSettingDetailData.entitle_begin_date_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }

        $scope.picklist_entitle_type = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#entitle_type').val();
            var checked_value = $('#entitle_type_name').html();
            var picklist_title = '享有类型';
            var return_key_field_id = 'entitle_type';
            var return_value_field_id = 'entitle_type_name'

            for (var i = 0; i < $scope.lvCodeSettingDetailData.entitle_type_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.lvCodeSettingDetailData.entitle_type_list[i].key;
                picklist_value_list = picklist_value_list + $scope.lvCodeSettingDetailData.entitle_type_list[i].name;
                if (i < $scope.lvCodeSettingDetailData.entitle_type_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }


        $scope.addEntitleData = function () {
            $scope.lvCodeSettingDetailData.entitle_data.push({
                'from': '',
                'to': '',
                'days': ''
            });
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrollbottom
        }

        $scope.deleteEntitleData = function (item) {
            var idx = $scope.lvCodeSettingDetailData.entitle_data.indexOf(item);
            $scope.lvCodeSettingDetailData.entitle_data.splice(idx, 1);
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrollbottom
        }

        $scope.lv_code_setting_detail_save = function () {
            lvCodeSettingDetailSev.lv_code_setting_detail_save($stateParams.lv_code_name, $scope.lvCodeSettingDetailData, $stateParams.has_balance);
        }

    })


    .controller('picklistTemplateCtrl', function ($scope, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.picklist_key_list = $stateParams.picklist_key_list.split(',');
        $scope.picklist_value_list = $stateParams.picklist_value_list.split(',');
        $scope.picklist_title = $stateParams.picklist_title;
        $scope.checked_key = $stateParams.checked_key;
        $scope.checked_value = $stateParams.checked_value;
        $scope.picklist_submit = function () {
            if (typeof (document.getElementById($stateParams.return_key_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_key_field_id).val($scope.checked_key);
            } else {
                $('#' + $stateParams.return_key_field_id).html($scope.checked_key);
            }

            if (typeof (document.getElementById($stateParams.return_value_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_value_field_id).val($scope.checked_value);
            } else {
                $('#' + $stateParams.return_value_field_id).html($scope.checked_value);
            }
            $ionicHistory.goBack();
        }

        $scope.item_clicked = function (checked_key, checked_value) {
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "none";
            $scope.checked_key = checked_key;
            $scope.checked_value = checked_value;
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "block";
            $scope.picklist_submit();
        }

    })

    .controller('picklistSignInReasonCtrl', function ($scope, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.picklist_key_list = $stateParams.picklist_key_list.split(',');
        $scope.picklist_value_list = $stateParams.picklist_value_list.split(',');
        $scope.picklist_title = $stateParams.picklist_title;
        $scope.checked_key = $stateParams.checked_key;
        $scope.checked_value = $stateParams.checked_value;
        $scope.picklist_submit = function () {
            $('#sign_in_reason_key').val($scope.checked_value);
            $('#sign_in_reason').html($scope.checked_value);
            if ($scope.checked_value == "拜访客户") {
                document.getElementById("sign_in_outdoor_customer_name_div").style.display = "block";
            } else {
                document.getElementById("sign_in_outdoor_customer_name_div").style.display = "none";
            }

            $ionicHistory.goBack();
        }

        $scope.item_clicked = function (checked_key, checked_value) {
            if ($scope.checked_key != '') {
                document.getElementById('picklist_item_' + $scope.checked_key).style.display = "none";
            }
            $scope.checked_key = checked_key;
            $scope.checked_value = checked_value;
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "block";
        }

    })
    .controller('picklistEmployeeContractDetailContractTermCtrl', function ($scope, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.picklist_key_list = $stateParams.picklist_key_list.split(',');
        $scope.picklist_value_list = $stateParams.picklist_value_list.split(',');
        $scope.picklist_title = $stateParams.picklist_title;
        $scope.checked_key = $stateParams.checked_key;
        $scope.checked_value = $stateParams.checked_value;
        $scope.picklist_submit = function () {
            if (typeof (document.getElementById($stateParams.return_key_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_key_field_id).val($scope.checked_key);
            } else {
                $('#' + $stateParams.return_key_field_id).html($scope.checked_key);
            }


            if (typeof (document.getElementById($stateParams.return_value_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_value_field_id).val($scope.checked_value);
            } else {
                $('#' + $stateParams.return_value_field_id).html($scope.checked_value);
            }
            if ($scope.checked_key == 'F') {
                for (var i = 0; i < $stateParams.hidden_fields.split(',').length; i++) {
                    document.getElementById($stateParams.hidden_fields.split(',')[i]).style.display = "block";
                }
                //document.getElementById('contract_end_date_uneditable_div').style.display = "block";
                //document.getElementById('contract_end_date_editable_div').style.display = "block";
            } else if ($scope.checked_key == 'O') {
                for (var i = 0; i < $stateParams.hidden_fields.split(',').length; i++) {
                    document.getElementById($stateParams.hidden_fields.split(',')[i]).style.display = "none";
                }
                //document.getElementById('contract_end_date_uneditable_div').style.display = "none";
                //document.getElementById('contract_end_date_editable_div').style.display = "none";
            }
            $ionicHistory.goBack();
        }

        $scope.item_clicked = function (checked_key, checked_value) {
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "none";
            $scope.checked_key = checked_key;
            $scope.checked_value = checked_value;
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "block";
            $scope.picklist_submit();
        }

    })

    .controller('attendanceSettingCtrl', function ($scope, attendanceSettingSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        attendanceSettingSev.clearData();
        attendanceSettingSev.loadData();
        $scope.attendanceSettingData = attendanceSettingSev.getData();
        $scope.attendance_setting_save = function () {
            attendanceSettingSev.attendance_setting_save($scope.attendanceSettingData);
        }
    })

    .controller('otToLeaveSettingCtrl', function ($scope, otToLeaveSettingSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        otToLeaveSettingSev.clearData();
        otToLeaveSettingSev.loadData();
        $scope.otToLeaveSettingData = otToLeaveSettingSev.getData();

        $scope.picklist_post_date_type = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#post_date_type').val();
            var checked_value = $('#post_date_type_name').html();
            var picklist_title = '调休假有效开始日期';
            var return_key_field_id = 'post_date_type';
            var return_value_field_id = 'post_date_type_name'


            for (var i = 0; i < $scope.otToLeaveSettingData.post_data_type_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.otToLeaveSettingData.post_data_type_list[i].key;
                picklist_value_list = picklist_value_list + $scope.otToLeaveSettingData.post_data_type_list[i].name;
                if (i < $scope.otToLeaveSettingData.post_data_type_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }

        $scope.ot_to_leave_setting_save = function () {
            otToLeaveSettingSev.ot_to_leave_setting_save($scope.otToLeaveSettingData);
        }
    })

    .controller('otToLeaveCtrl', function ($scope,$rootScope, otToLeaveSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate, timeSelect) {
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
        if (ionic.Platform.isIOS()) {
            otToLeaveSev.clearData();
            otToLeaveSev.loadData(current_date);
            $scope.otToLeaveData = otToLeaveSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                otToLeaveSev.clearData();
                otToLeaveSev.loadData(current_date);
                $scope.otToLeaveData = otToLeaveSev.getData();
            });
        }

        $scope.all_selected = false;
        var current_date = new Date();
        var obj = $('#target_date1');

        current_date = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
        obj.val(current_date)
        document.getElementById("target_date").innerHTML = current_date;
        //otToLeaveSev.clearData();
        //otToLeaveSev.loadData(current_date);
        //$scope.otToLeaveData = otToLeaveSev.getData();

        $scope.target_date = function () {
            var current_date = new Date();

            current_date = current_date.getFullYear();
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("target_date").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("target_date").innerHTML = date;
                        obj.val(date);
                        otToLeaveSev.loadData(obj.val());
                    }
                }
            })
        }

        obj.change(function () {
            otToLeaveSev.loadData(obj.val());
        })

        $scope.ckItem = function (_flag) {

            if (_flag == true) {
                $scope.otToLeaveData.num_checked = $scope.otToLeaveData.num_checked + 1;
            } else {
                $scope.otToLeaveData.num_checked = $scope.otToLeaveData.num_checked - 1;
            }

            if ($scope.otToLeaveData.num_checked > 0) {
                $scope.otToLeaveData.show_footer_bar = true;
            } else {
                $scope.otToLeaveData.show_footer_bar = false;
                //$ionicScrollDelegate.resize();
                //setTimeout(function(){ $ionicScrollDelegate.resize(); }, 200);
            }
            if ($scope.otToLeaveData.num_checked == $scope.otToLeaveData.data.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
        }
        $scope.previous_day = function () {
            document.getElementById("target_date1").stepDown(1);
            document.getElementById("target_date").innerHTML = obj.val();
            otToLeaveSev.loadData(obj.val());
        }
        $scope.next_day = function () {

            document.getElementById("target_date1").stepUp(1);
            document.getElementById("target_date").innerHTML = obj.val();
            otToLeaveSev.loadData(obj.val());
        }
        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.otToLeaveData.num_checked = $scope.otToLeaveData.data.length;
            $scope.otToLeaveData.show_footer_bar = true;
            for (var i = 0; i < $scope.otToLeaveData.data.length; i++) {
                $scope.otToLeaveData.data[i].checked = true;
            }
        }
        $scope.cancel = function () {
            //$scope.all_selected = false;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.otToLeaveData.num_checked = 0;
            $scope.otToLeaveData.show_footer_bar = false;
            for (var i = 0; i < $scope.otToLeaveData.data.length; i++) {
                $scope.otToLeaveData.data[i].checked = false;
            }

        }
        $scope.ot_to_leave_save = function () {
            otToLeaveSev.ot_to_leave_save();
        }


    })

    .controller('employeeDeleteCtrl', function ($scope, employeeDeleteSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.employee_resign_terminated = local_resource + 'img/icon/employee_resign_terminated.png';
        $scope.employee_resign_pending = local_resource + 'img/icon/employee_resign_pending.png';
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        employeeDeleteSev.clearData();
        employeeDeleteSev.loadData();
        $scope.employeeDeleteData = employeeDeleteSev.getData();
        $scope.employee_delete = function (employee_no) {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    employeeDeleteSev.employee_delete(employee_no);
                }
            });
        }
    })

    .controller('employeeResignCtrl', function ($scope, employeeResignSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.img_employee_resign_pending = local_resource + 'img/icon/employee_resign_pending.png';
        $scope.img_employee_resign_terminated = local_resource + 'img/icon/employee_resign_terminated.png';
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        employeeResignSev.clearData();
        employeeResignSev.loadData();
        $scope.employeeResignData = employeeResignSev.getData();
        $scope.employee_resign_detail = function (employee_no, flag) {
            $location.path('home_page/home_menulist/employee_resign_detail/' + employee_no + '/' + flag);
        }
    })

    .controller('employeeResignDetailCtrl', function ($scope, employeeResignDetailSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate, timeSelect) {
        employeeResignDetailSev.clearData();
        employeeResignDetailSev.loadData($stateParams.employee_no);
        $scope.employeeResignDetailData = employeeResignDetailSev.getData();
        $scope.termination_effect_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            var _defaultDate = '';
            if ($scope.employeeResignDetailData.termination_effect_date == '') {
                _defaultDate = new Date().getFullYear() + "-" + (new Date().getMonth() + 1) + "-" + new Date().getDate()
            } else {
                _defaultDate = $scope.employeeResignDetailData.termination_effect_date;
            }
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: _defaultDate,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.employeeResignDetailData.termination_effect_date = date;
                    }
                }
            })
        }

        $scope.last_working_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            var _defaultDate = '';
            if ($scope.employeeResignDetailData.last_working_date == '') {
                _defaultDate = new Date().getFullYear() + "-" + (new Date().getMonth() + 1) + "-" + new Date().getDate()
            } else {
                _defaultDate = $scope.employeeResignDetailData.last_working_date;
            }
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: _defaultDate,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.employeeResignDetailData.last_working_date = date;
                    }
                }
            })
        }


        if ($stateParams.flag == '0') {
            $scope.is_can_cancel = '0';
        } else {
            $scope.is_can_cancel = '1';
        }
        $scope.picklist_is_rehire = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#is_rehire').val();
            var checked_value = $('#is_rehire_name').html();
            var picklist_title = '是否重新雇佣';
            var return_key_field_id = 'is_rehire';
            var return_value_field_id = 'is_rehire_name'


            for (var i = 0; i < $scope.employeeResignDetailData.is_rehire_list.length; i++) {
                picklist_key_list = picklist_key_list + $scope.employeeResignDetailData.is_rehire_list[i].key;
                picklist_value_list = picklist_value_list + $scope.employeeResignDetailData.is_rehire_list[i].name;
                if (i < $scope.employeeResignDetailData.is_rehire_list.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';

                }
            }

            $location.path('home_page/home_menulist/picklist_template/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id);
        }

        $scope.employee_resign_detail_save = function () {
            employeeResignDetailSev.employee_resign_detail_save();
        }

        $scope.employee_cancel_resign = function (employee_no) {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认撤销离职?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    employeeResignDetailSev.employee_cancel_resign(employee_no);
                }
            });


        }


    })

    .controller('employeeContractCtrl', function ($scope, employeeContractSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout, $ionicScrollDelegate) {

        $scope.not_data = local_resource + "img/not_data.png";
        $scope.cry = local_resource + "img/cry.png";
        $scope.search_img = local_resource + 'img/search_img.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.search_control = employeeContractSev.getSearchValue();
        $scope.searchState = employeeContractSev.getSearchState();
        $scope.searchNodata = employeeContractSev.getSearchNodata();
        $scope.end_of_list = employeeContractSev.getEndOfList();
        employeeContractSev.clearData();
        //employeeContractSev.loadData();
        //  $scope.employeeContractData = employeeContractSev.getData();

        $scope.$on("$ionicView.enter", function () {
            //解决 进入明细页面back回来的时候 会再次loaddata
            if (typeof ($scope.data_loaded) != 'undefined') {
                return;
            } else {
                $scope.data_loaded = true;
            }
            employeeContractSev.loadData('');
            $scope.employeeContractData = employeeContractSev.getData();
            $scope.search_control = employeeContractSev.getSearchValue();
            $scope.searchState = employeeContractSev.getSearchState();
            $scope.searchNodata = employeeContractSev.getSearchNodata();
            $scope.end_of_list = employeeContractSev.getEndOfList();

        });
		$scope.android_height = android_height;
        if (ionic.Platform.isIOS()) {
            $scope.content_top = '64';
        } else {
            $scope.content_top = '44';
        }

        $scope.search = function () {
            employeeContractSev.loadData($scope.search_control.search_val);
        }

        $scope.employee_contract_detail = function (employee_no, flag) {
            //flag:1 有合同, flag:0 没有合同
            $location.path('home_page/home_menulist/employee_contract_detail/' + employee_no + '/' + flag);
        }
        //$scope.end_of_list=employeeContractSev.getEndOfList();
        $scope.loadMoreEmployeeData = function () {
            employeeContractSev.loadMoreData($scope)
        }

        $scope.employee_contract_search_key_down = function () {
            var e = event || window.event || arguments.callee.caller.arguments[0];
            var keycode = e.KeyCode;

            if (e.keyCode == '13') {
                $timeout(function () {
                    $ionicScrollDelegate.scrollTop();
                    employeeContractSev.loadData($scope.search_control.search_val);
                })
            }


        }
    })

    .controller('employeeContractDetailCtrl', function ($scope, employeeContractDetailSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate, $timeout, $ionicActionSheet, timeSelect) {
        $scope.img_contract_history = local_resource + 'img/icon/icon_contract_history.png';
        $scope.img_delete = local_resource + 'img/icon/fufu_delete.png';
        $scope.img_edit = local_resource + 'img/icon/fufu_edit.png';
        $scope.img_add = local_resource + 'img/icon/fufu_add_to.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';

        $scope.new_contract_is_require_upload = false;
        $scope.current_contract_is_require_upload = false;
        if (ionic.Platform.isIOS()) {
            employeeContractDetailSev.clearData();
            employeeContractDetailSev.loadData($scope, $stateParams.employee_no, current_date);
            $scope.employeeContractDetailData = employeeContractDetailSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                employeeContractDetailSev.clearData();
                employeeContractDetailSev.loadData($scope, $stateParams.employee_no, current_date);
                $scope.employeeContractDetailData = employeeContractDetailSev.getData();
            });
        }

        var current_date = new Date();

        current_date = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
        $scope.current_date_start = current_date;
        $scope.current_date_end = current_date;


        $scope.showDate_new_contract_start_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.current_date_start,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.current_date_start = date;
                        //$scope.employeeContractDetailData.c_c_d[0].contract_start_date=date;
                        //essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }

        $scope.showDate_new_contract_end_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.current_date_end,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.current_date_end = date;
                        //$scope.employeeContractDetailData.c_c_d[0].contract_end_date=date;
                        //essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }
        //flag:1 有合同, flag:0 没有合同
        //$scope.flag = $stateParams.flag;


        $scope.contract_start_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_start_date').innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_start_date').innerHTML = date;
                        //$scope.employeeContractDetailData.c_c_d[0].contract_start_date=date;
                        //essLvApplySev.changeEssLvPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }

        $scope.contract_end_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: startDate,
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_end_date').innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_end_date').innerHTML = date;
                    }
                }
            })
        }

        $scope.contract_start_date_ = function (i) {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_start_date_' + i).innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_start_date_' + i).innerHTML = date;
                    }
                }
            })
        }

        $scope.contract_end_date_ = function (i) {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_end_date_' + i).innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_end_date_' + i).innerHTML = date;
                    }
                }
            })
        }
        $scope.employee_contract_detail_history = function () {
            fufuMobclickAgent('click_view_history_contract');
            $location.path('home_page/home_menulist/employee_contract_detail_history/' + $stateParams.employee_no);
        }

        $scope.picklist_contract_term = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = ($('#contract_term_key').val() == '' ? 'F' : $('#contract_term_key').val());
            var checked_value = ($('#contract_term').html() == '' ? '固定期限劳动合同' : $('#contract_term').html());
            var picklist_title = '合同类型';
            var return_key_field_id = 'contract_term_key';
            var return_value_field_id = 'contract_term';
            var hidden_fields = 'contract_end_date_uneditable_div,contract_end_date_editable_div';

            for (var i = 0; i < $scope.employeeContractDetailData.p_d.length; i++) {
                picklist_key_list = picklist_key_list + $scope.employeeContractDetailData.p_d[i].key;
                picklist_value_list = picklist_value_list + $scope.employeeContractDetailData.p_d[i].name;
                if (i < $scope.employeeContractDetailData.p_d.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }


            $location.path('home_page/home_menulist/picklist_employee_contract_detail_contract_term/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }


        $scope.upload_photo_new = function () {

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {

						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.new_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_new').style.display = "block";
										$('#contract_upload_mini_photo_new').attr("src", uri);
										document.getElementById('contract_upload_text_new').innerText = '更改图片';
										$('#contract_upload_icon1_new').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_new').style.display = "none";
										document.getElementById('contract_upload_text_new').style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
										$scope.new_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_new').style.display = "block";
										$('#contract_upload_mini_photo_new').attr("src", data.uri);
										document.getElementById('contract_upload_text_new').innerText = '更改图片';
										$('#contract_upload_icon1_new').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_new').style.display = "none";
										document.getElementById('contract_upload_text_new').style.marginTop = "1.8em";
									
								});
							} catch(e){
								
							}
							
						}

                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
						
							try {
								navigator.camera.getPicture(function (uri) {
									$scope.new_contract_is_require_upload = true;
									document.getElementById('contract_upload_mini_photo_new').style.display = "block";
									$('#contract_upload_mini_photo_new').attr("src", uri);
									document.getElementById('contract_upload_text_new').innerText = '更改图片';
									$('#contract_upload_icon1_new').attr("src", local_resource + 'img/icon/upload_modify.png');
									document.getElementById('contract_upload_icon2_new').style.display = "none";
									document.getElementById('contract_upload_text_new').style.marginTop = "1.8em";
								}, function (message) {}, {
									quality: 100,
									destinationType: Camera.DestinationType.FILE_URI,
									// In this app, dynamically set the picture source, Camera or photo gallery
									sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
									encodingType: Camera.EncodingType.JPEG,
									mediaType: Camera.MediaType.PICTURE,
									//allowEdit: true,
									targetHeight: 500,
									targetWidth: 500,
									correctOrientation: true
								});
							} catch (e) {
								//alert(e.message);
							}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
									$scope.new_contract_is_require_upload = true;
									document.getElementById('contract_upload_mini_photo_new').style.display = "block";
									$('#contract_upload_mini_photo_new').attr("src", data.uri);
									document.getElementById('contract_upload_text_new').innerText = '更改图片';
									$('#contract_upload_icon1_new').attr("src", local_resource + 'img/icon/upload_modify.png');
									document.getElementById('contract_upload_icon2_new').style.display = "none";
									document.getElementById('contract_upload_text_new').style.marginTop = "1.8em";
								});
							} catch(e){
								
							}	
							
						}


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */


        }


        $scope.upload_photo_current_editable = function () {

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.current_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_current_editable').style.display = "block";
										$('#contract_upload_mini_photo_current_editable').attr("src", uri);
										document.getElementById('contract_upload_text_current_editable').innerText = '更改图片';
										$('#contract_upload_icon1_current_editable').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_current_editable').style.display = "none";
										document.getElementById('contract_upload_text_current_editable').style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_current_uneditable').style.display = "block";
										$('#contract_upload_mini_photo_current_uneditable').attr("src", uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_current_uneditable').attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_current_uneditable').style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
										$scope.current_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_current_editable').style.display = "block";
										$('#contract_upload_mini_photo_current_editable').attr("src", uri);
										document.getElementById('contract_upload_text_current_editable').innerText = '更改图片';
										$('#contract_upload_icon1_current_editable').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_current_editable').style.display = "none";
										document.getElementById('contract_upload_text_current_editable').style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_current_uneditable').style.display = "block";
										$('#contract_upload_mini_photo_current_uneditable').attr("src", data.uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_current_uneditable').attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_current_uneditable').style.marginTop = "1.8em";
									
								});
							} catch(e){
								
							}
							
						}

                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.current_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_current_editable').style.display = "block";
										$('#contract_upload_mini_photo_current_editable').attr("src", uri);
										document.getElementById('contract_upload_text_current_editable').innerText = '更改图片';
										$('#contract_upload_icon1_current_editable').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_current_editable').style.display = "none";
										document.getElementById('contract_upload_text_current_editable').style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_current_uneditable').style.display = "block";
										$('#contract_upload_mini_photo_current_uneditable').attr("src", uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_current_uneditable').attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_current_uneditable').style.marginTop = "1.8em";
									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										//allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
										$scope.current_contract_is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_current_editable').style.display = "block";
										$('#contract_upload_mini_photo_current_editable').attr("src", data.uri);
										document.getElementById('contract_upload_text_current_editable').innerText = '更改图片';
										$('#contract_upload_icon1_current_editable').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_current_editable').style.display = "none";
										document.getElementById('contract_upload_text_current_editable').style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_current_uneditable').style.display = "block";
										$('#contract_upload_mini_photo_current_uneditable').attr("src", data.uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_current_uneditable').attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_current_uneditable').style.marginTop = "1.8em";

								});
							} catch(e){
								
							}	
							
						}
						


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */


        }


        $scope.upload_photo_future = function (current_item) {

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_future_editable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_editable_' + current_item.contract_id).attr("src", uri);
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_future_editable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_future_editable_' + current_item.contract_id).style.display = "none";
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).attr("src", uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_future_uneditable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_future_uneditable_' + current_item.contract_id).style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_future_editable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_editable_' + current_item.contract_id).attr("src", data.uri);
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_future_editable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_future_editable_' + current_item.contract_id).style.display = "none";
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).attr("src", data.uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_future_uneditable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_future_uneditable_' + current_item.contract_id).style.marginTop = "1.8em";


								});
							} catch(e){
								
							}
							
						}

                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_future_editable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_editable_' + current_item.contract_id).attr("src", uri);
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_future_editable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_future_editable_' + current_item.contract_id).style.display = "none";
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).attr("src", uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_future_uneditable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_future_uneditable_' + current_item.contract_id).style.marginTop = "1.8em";
									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										//allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}

						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_future_editable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_editable_' + current_item.contract_id).attr("src", data.uri);
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_future_editable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_future_editable_' + current_item.contract_id).style.display = "none";
										document.getElementById('contract_upload_text_future_editable_' + current_item.contract_id).style.marginTop = "1.8em";

										document.getElementById('contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).style.display = "block";
										$('#contract_upload_mini_photo_future_uneditable_' + current_item.contract_id).attr("src", data.uri);
										//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
										$('#contract_upload_icon1_future_uneditable_' + current_item.contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
										document.getElementById('contract_upload_text_future_uneditable_' + current_item.contract_id).style.marginTop = "1.8em";

								});
							} catch(e){
								
							}	
							
						}
						

                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */


        }


        $scope.employee_contract_detail_edit_mode = function () {
            $scope.edit_mode = true;
            $scope.expand_mode = true;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrollbottom
        }

        $scope.employee_contract_detail_cancel_edit_mode = function () {
            $scope.edit_mode = false;
            $scope.expand_mode = false;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrolltop
        }

        $scope.employee_contract_detail_delete = function () {
            employeeContractDetailSev.employee_contract_detail_delete($stateParams.employee_no);
        }

        $scope.employee_contract_detail_save = function () {

            var num_of_upload = 0;
            var updated_o_attachment = '';
            var updated_o_attachment_array = [];
            var attachment_array = $scope.employeeContractDetailData.c_c_d[0].attachment.split(',');
            var o_attachment_array = $scope.employeeContractDetailData.c_c_d[0].o_attachment.split(',');
            var imagesObj_data_array = $scope.employeeContractDetailData.c_c_d[0].contract_image_data.split(',');

            if ($scope.employeeContractDetailData.c_c_d[0].contract_image_data != '') {
                for (var i = 0; i < imagesObj_data_array.length; i++) {
                    if ($scope.employeeContractDetailData.c_c_d[0].attachment.indexOf(imagesObj_data_array[i]) == -1) {
                        num_of_upload++;
                    }
                }
            }

            if ($scope.employeeContractDetailData.c_c_d[0].o_attachment != '') {
                for (var i = 0; i < o_attachment_array.length; i++) {
                    if ($scope.employeeContractDetailData.c_c_d[0].contract_image_data.indexOf(o_attachment_array[i]) != -1) {
                        updated_o_attachment_array.push(o_attachment_array[i]);
                    }
                }
            }

            updated_o_attachment = updated_o_attachment_array.join(',');

            updated_o_attachment = updated_o_attachment.replace(' ', '');


            if (num_of_upload > 0) {
                employeeContractDetailSev.employee_contract_detail_save_with_upload($stateParams.employee_no, num_of_upload, updated_o_attachment);
            } else {
                employeeContractDetailSev.employee_contract_detail_save($stateParams.employee_no, updated_o_attachment);
            }

        }

        $scope.employee_contract_detail_toggle_expand_mode = function () {
            if ($scope.expand_mode) {
                $scope.expand_mode = false;
                setTimeout(function () {
                    $ionicScrollDelegate.resize();
                }, 200); //scrolltop
            } else {
                $scope.expand_mode = true;
                setTimeout(function () {
                    $ionicScrollDelegate.resize();
                }, 200); //scrollbottom
            }
        }
        //////新合同

        $scope.new_picklist_contract_term = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = ($('#new_contract_term_key').val() == '' ? 'F' : $('#new_contract_term_key').val());
            var checked_value = ($('#new_contract_term').html() == '' ? '固定期限劳动合同' : $('#new_contract_term').html());
            var picklist_title = '合同类型';
            var return_key_field_id = 'new_contract_term_key';
            var return_value_field_id = 'new_contract_term';
            var hidden_fields = 'new_contract_end_date_editable_div';


            for (var i = 0; i < $scope.employeeContractDetailData.p_d.length; i++) {
                picklist_key_list = picklist_key_list + $scope.employeeContractDetailData.p_d[i].key;
                picklist_value_list = picklist_value_list + $scope.employeeContractDetailData.p_d[i].name;
                if (i < $scope.employeeContractDetailData.p_d.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }

            $location.path('home_page/home_menulist/picklist_employee_contract_detail_contract_term/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }

        $scope.new_employee_contract_detail_edit_mode = function () {
            $scope.new_expand_mode = true;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrollbottom
        }

        $scope.new_employee_contract_detail_cancel_edit_mode = function () {
            $scope.new_expand_mode = false;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrolltop
        }

        $scope.new_employee_contract_detail_delete = function () {
            employeeContractDetailSev.employee_contract_detail_delete($stateParams.employee_no);
        }

        $scope.new_employee_contract_detail_save = function () {
            if ($scope.employeeContractDetailData.new_contract_image_data != '') {
                employeeContractDetailSev.new_employee_contract_detail_save_with_upload($stateParams.employee_no);
            } else {
                employeeContractDetailSev.new_employee_contract_detail_save($stateParams.employee_no);
            }
        }

        $scope.new_employee_contract_detail_toggle_expand_mode = function () {
            if ($scope.new_expand_mode) {
                $scope.new_expand_mode = false;
                setTimeout(function () {
                    $ionicScrollDelegate.resize();
                }, 200); //scrolltop
            } else {
                $scope.new_expand_mode = true;
                setTimeout(function () {
                    $ionicScrollDelegate.resize();
                }, 200); //scrollbottom
            }
        }

        ////////将来合同



        $scope.fireEvent = function (i) {
            $timeout(function () {
                var current_contract_id = $scope.employeeContractDetailData.c_f_d[i].contract_id;
                $scope.employeeContractDetailData.c_f_d[i].is_require_upload = false;
                /*
                if ($scope.employeeContractDetailData.c_f_d[i].attachment != ''){
                	document.getElementById('contract_upload_mini_photo_future_editable_' + current_contract_id).style.display = "block";
                	$('#contract_upload_mini_photo_future_editable_' + current_contract_id).attr("src", $scope.employeeContractDetailData.c_f_d[i].attachment);
                	document.getElementById('contract_upload_text_future_editable_' + current_contract_id).innerText='更改图片';
                	$('#contract_upload_icon1_future_editable_' + current_contract_id).attr("src", local_resource+'img/icon/upload_modify.png');
                	document.getElementById('contract_upload_icon2_future_editable_' + current_contract_id).style.display = "none";
                	document.getElementById('contract_upload_text_future_editable_' + current_contract_id).style.marginTop = "1.8em";

                	document.getElementById('contract_upload_mini_photo_future_uneditable_' + current_contract_id).style.display = "block";
                	$('#contract_upload_mini_photo_future_uneditable_' + current_contract_id).attr("src", $scope.employeeContractDetailData.c_f_d[i].attachment);
                	//document.getElementById('contract_upload_text_current_uneditable').innerText='更改图片';
                	$('#contract_upload_icon1_future_uneditable_' + current_contract_id).attr("src", local_resource+'img/icon/upload_modify.png');
                	//document.getElementById('contract_upload_icon2_current_uneditable').style.display = "none";
                	document.getElementById('contract_upload_text_future_uneditable_' + current_contract_id).style.marginTop = "1.8em";
                }
                */

                $scope.employeeContractDetailData.c_f_d[i].edit_mode = false;
                $scope.employeeContractDetailData.c_f_d[i].expand_mode = false;
                document.getElementById('contract_start_date_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).innerHTML = $scope.employeeContractDetailData.c_f_d[i].contract_start_date;
                document.getElementById('contract_end_date_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).innerHTML = $scope.employeeContractDetailData.c_f_d[i].contract_end_date;
                $('#contract_term_key_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).val($scope.employeeContractDetailData.c_f_d[i].contract_term_key);
                $('#contract_term_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].contract_term);
                $('#contract_times_after2008_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html('2008年后第' + $scope.employeeContractDetailData.c_f_d[i].contract_times_after2008 + '次签约');
                $('#remark_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].remark);


                $('#uneditable_contract_start_date_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].contract_start_date);
                $('#uneditable_contract_end_date_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].contract_end_date);
                $('#uneditable_contract_term_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].contract_term);
                $('#uneditable_contract_times_after2008_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html('2008年后第' + $scope.employeeContractDetailData.c_f_d[i].contract_times_after2008 + '次签约');
                $('#uneditable_remark_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).html($scope.employeeContractDetailData.c_f_d[i].remark);

                if ($scope.employeeContractDetailData.c_f_d[i].contract_term_key == 'O') {
                    document.getElementById('contract_end_date_uneditable_div_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).style.display = "none";
                    document.getElementById('contract_end_date_editable_div_' + $scope.employeeContractDetailData.c_f_d[i].contract_id).style.display = "none";
                }
            }, 0);



        }


        $scope.future_picklist_contract_term = function (contract_id) {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = ($('#contract_term_key_' + contract_id).val() == '' ? 'F' : $('#contract_term_key_' + contract_id).val());
            var checked_value = ($('#contract_term_' + contract_id).html() == '' ? '固定期限劳动合同' : $('#contract_term_' + contract_id).html());
            var picklist_title = '合同类型';
            var return_key_field_id = 'contract_term_key_' + contract_id;
            var return_value_field_id = 'contract_term_' + contract_id;
            var hidden_fields = 'contract_end_date_uneditable_div_' + contract_id + ',contract_end_date_editable_div_' + contract_id;

            for (var i = 0; i < $scope.employeeContractDetailData.p_d.length; i++) {
                picklist_key_list = picklist_key_list + $scope.employeeContractDetailData.p_d[i].key;
                picklist_value_list = picklist_value_list + $scope.employeeContractDetailData.p_d[i].name;
                if (i < $scope.employeeContractDetailData.p_d.length - 1) {
                    picklist_key_list = picklist_key_list + ',';
                    picklist_value_list = picklist_value_list + ',';
                }
            }


            $location.path('home_page/home_menulist/picklist_employee_contract_detail_contract_term/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }

        $scope.future_employee_contract_detail_edit_mode = function (contract_id) {
            for (var i = 0; i < $scope.employeeContractDetailData.c_f_d.length; i++) {
                if ($scope.employeeContractDetailData.c_f_d[i].contract_id == contract_id) {
                    $scope.employeeContractDetailData.c_f_d[i].edit_mode = true;
                    $scope.employeeContractDetailData.c_f_d[i].expand_mode = true;
                    setTimeout(function () {
                        $ionicScrollDelegate.resize();
                    }, 200); //scrollbottom
                }
            }
        }

        $scope.future_employee_contract_detail_cancel_edit_mode = function (contract_id) {
            for (var i = 0; i < $scope.employeeContractDetailData.c_f_d.length; i++) {
                if ($scope.employeeContractDetailData.c_f_d[i].contract_id == contract_id) {
                    $scope.employeeContractDetailData.c_f_d[i].edit_mode = false;
                    $scope.employeeContractDetailData.c_f_d[i].expand_mode = false;
                    setTimeout(function () {
                        $ionicScrollDelegate.resize();
                    }, 200); //scrolltop
                }
            }
        }

        $scope.future_employee_contract_detail_delete = function (contract_id) {
            employeeContractDetailSev.future_employee_contract_detail_delete($stateParams.employee_no, contract_id);
        }

        $scope.future_employee_contract_detail_save = function (current_item, contract_id) {
            var num_of_upload = 0;
            var updated_o_attachment = '';
            var updated_o_attachment_array = [];
            var attachment_array = current_item.attachment.split(',');
            var o_attachment_array = current_item.o_attachment.split(',');
            var imagesObj_data_array = current_item.contract_image_data.split(',');

            if (current_item.contract_image_data != '') {
                for (var i = 0; i < imagesObj_data_array.length; i++) {
                    if (current_item.attachment.indexOf(imagesObj_data_array[i]) == -1) {
                        num_of_upload++;
                    }
                }
            }

            if (current_item.o_attachment != '') {
                for (var i = 0; i < o_attachment_array.length; i++) {
                    if (current_item.contract_image_data.indexOf(o_attachment_array[i]) != -1) {
                        updated_o_attachment_array.push(o_attachment_array[i]);
                    }
                }
            }

            updated_o_attachment = updated_o_attachment_array.join(',');


            if (num_of_upload > 0) {
                employeeContractDetailSev.future_employee_contract_detail_save_with_upload($stateParams.employee_no, contract_id, current_item, num_of_upload, updated_o_attachment);
            } else {
                employeeContractDetailSev.future_employee_contract_detail_save($stateParams.employee_no, contract_id, current_item, updated_o_attachment);
            }

        }

        $scope.future_employee_contract_detail_toggle_expand_mode = function (contract_id) {
            for (var i = 0; i < $scope.employeeContractDetailData.c_f_d.length; i++) {
                if ($scope.employeeContractDetailData.c_f_d[i].contract_id == contract_id) {
                    if ($scope.employeeContractDetailData.c_f_d[i].expand_mode) {
                        $scope.employeeContractDetailData.c_f_d[i].expand_mode = false;
                        setTimeout(function () {
                            $ionicScrollDelegate.resize();
                        }, 200); //scrolltop
                    } else {
                        $scope.employeeContractDetailData.c_f_d[i].expand_mode = true;
                        setTimeout(function () {
                            $ionicScrollDelegate.resize();
                        }, 200); //scrollbottom
                    }
                }
            }


        }


    })

    .controller('employeeContractDetailHistoryCtrl', function ($scope, employeeContractDetailHistorySev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout, $ionicActionSheet, timeSelect, $ionicScrollDelegate) {

        $scope.zhiwen = local_resource + 'img/icon/zhiwen.png';
        $scope.renlian = local_resource + 'img/icon/renlian.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';

        $scope.img_delete = local_resource + 'img/icon/fufu_delete.png';
        $scope.img_edit = local_resource + 'img/icon/fufu_edit.png';

        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';

        employeeContractDetailHistorySev.clearData();

        $scope.contract_start_date = function (i) {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_start_date_' + i).innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_start_date_' + i).innerHTML = date;
                    }
                }
            })
        }

        $scope.contract_end_date = function (i) {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('contract_end_date_' + i).innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('contract_end_date_' + i).innerHTML = date;
                    }
                }
            })
        }
        employeeContractDetailHistorySev.loadData($stateParams.employee_no);
        $scope.employeeContractDetailHistoryData = employeeContractDetailHistorySev.getData();

        $scope.employee_contract_detail_history_edit_mode = function (current_item) {
            current_item.expand_mode = true;
            current_item.edit_mode = true;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrolltop
        }

        $scope.employee_contract_detail_cancel_edit_mode = function (current_item) {
            current_item.edit_mode = false;
            current_item.expand_mode = false;
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrolltop
        }

        $scope.employee_contract_detail_history_toggle_expand_mode = function (current_item) {
            if (current_item.expand_mode) {
                current_item.expand_mode = false;
                current_item.edit_mode = false;
            } else {
                current_item.expand_mode = true;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200); //scrolltop
        }


        $scope.employee_contract_detail_history_delete = function (current_item) {
            employeeContractDetailHistorySev.employee_contract_detail_history_delete(current_item);
        }

        $scope.employee_contract_detail_history_save = function (current_item) {
            var num_of_upload = 0;
            var updated_o_attachment = '';
            var updated_o_attachment_array = [];
            var attachment_array = current_item.attachment.split(',');
            var o_attachment_array = current_item.o_attachment.split(',');
            var imagesObj_data_array = current_item.contract_image_data.split(',');

            if (current_item.contract_image_data != '') {
                for (var i = 0; i < imagesObj_data_array.length; i++) {
                    if (current_item.attachment.indexOf(imagesObj_data_array[i]) == -1) {
                        num_of_upload++;
                    }
                }
            }

            if (current_item.o_attachment != '') {
                for (var i = 0; i < o_attachment_array.length; i++) {
                    if (current_item.contract_image_data.indexOf(o_attachment_array[i]) != -1) {
                        updated_o_attachment_array.push(o_attachment_array[i]);
                    }
                }
            }

            updated_o_attachment = updated_o_attachment_array.join(',');




            if (num_of_upload > 0) {
                employeeContractDetailHistorySev.employee_contract_detail_history_save_with_upload(current_item, $scope, num_of_upload, updated_o_attachment);
            } else {
                employeeContractDetailHistorySev.employee_contract_detail_history_save(current_item, $scope, updated_o_attachment);
            }


        }

        $scope.load_data = function () {
            employeeContractDetailHistorySev.clearData();
            employeeContractDetailHistorySev.loadData($stateParams.employee_no);
        }

        $scope.fireEvent = function (i, current_item, contract_id) {
            $timeout(function () {
                document.getElementById('contract_start_date_' + $scope.employeeContractDetailHistoryData[i].contract_id).innerHTML = $scope.employeeContractDetailHistoryData[i].contract_start_date;
                document.getElementById('contract_end_date_' + $scope.employeeContractDetailHistoryData[i].contract_id).innerHTML = $scope.employeeContractDetailHistoryData[i].contract_end_date;

                /*
				if (current_item.attachment != ''){
					document.getElementById('contract_upload_mini_photo_' + contract_id).style.display = "block";
					$('#contract_upload_mini_photo_' + contract_id).attr("src", current_item.attachment);
					document.getElementById('contract_upload_text_' + contract_id).innerText='更改图片';
					$('#contract_upload_icon1_' + contract_id).attr("src", local_resource+'img/icon/upload_modify.png');
					document.getElementById('contract_upload_icon2_' + contract_id).style.display = "none";
					document.getElementById('contract_upload_text_' + contract_id).style.marginTop = "1.8em";
				}
		*/
            }, 0);
        }

        $scope.upload_photo = function (contract_id, current_item) {
            if (current_item.edit_mode == false) {
                return;
            }

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_' + contract_id).style.display = "block";
										$('#contract_upload_mini_photo_' + contract_id).attr("src", uri);
										document.getElementById('contract_upload_text_' + contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_' + contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_' + contract_id).style.display = "none";
										document.getElementById('contract_upload_text_' + contract_id).style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_' + contract_id).style.display = "block";
										$('#contract_upload_mini_photo_' + contract_id).attr("src", data.uri);
										document.getElementById('contract_upload_text_' + contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_' + contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_' + contract_id).style.display = "none";
										document.getElementById('contract_upload_text_' + contract_id).style.marginTop = "1.8em";

									
								});
							} catch(e){
								
							}
							
						}

                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_' + contract_id).style.display = "block";
										$('#contract_upload_mini_photo_' + contract_id).attr("src", uri);
										document.getElementById('contract_upload_text_' + contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_' + contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_' + contract_id).style.display = "none";
										document.getElementById('contract_upload_text_' + contract_id).style.marginTop = "1.8em";
									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										//allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
										current_item.is_require_upload = true;
										document.getElementById('contract_upload_mini_photo_' + contract_id).style.display = "block";
										$('#contract_upload_mini_photo_' + contract_id).attr("src", data.uri);
										document.getElementById('contract_upload_text_' + contract_id).innerText = '更改图片';
										$('#contract_upload_icon1_' + contract_id).attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('contract_upload_icon2_' + contract_id).style.display = "none";
										document.getElementById('contract_upload_text_' + contract_id).style.marginTop = "1.8em";
									
								});
							} catch(e){
								
							}	
							
						}
						


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
            $timeout(function() {
            hideSheet();
            }, 2000);
            */


        }

    })



    .controller('atEmplCardRecCtrl', function ($scope, atEmplCardRecSev, $stateParams, $location, $ionicPopup, $ionicHistory, timeSelect) {
        //$scope.zhiwen = local_resource + 'img/icon/zhiwen.png';
        $scope.renlian = local_resource + 'img/icon/renlian.png';
        //$scope.dingwei = local_resource + 'img/icon/dingwei.png';
        //$scope.qita = local_resource + 'img/icon/qita.png';
        $scope.img_team_attendance_fingerprint = local_resource + 'img/icon/team_attendance_fingerprint.png';
        $scope.img_normal_sign_in = local_resource + 'img/icon/sign_in_normal.png';
        $scope.img_fieldwork_sign_in = local_resource + 'img/icon/sign_in_fieldwork.png';
        $scope.img_other_sign_in = local_resource + 'img/icon/sign_in_other_types.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';


        $scope.search_control = {};
        $scope.search_control.search_val = "";
        var current_date = new Date();
        var obj = $('#card_date1');

        current_date = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
        document.getElementById('card_date').innerHTML = current_date;
        obj.val(current_date);
        //atEmplCardRecSev.clearData();
        //atEmplCardRecSev.loadData(obj.val());
        //$scope.atEmplCardRecData = atEmplCardRecSev.getData();
        if (ionic.Platform.isIOS()) {
            atEmplCardRecSev.clearData();
            atEmplCardRecSev.loadData(obj.val());
            $scope.atEmplCardRecData = atEmplCardRecSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                atEmplCardRecSev.clearData();
                atEmplCardRecSev.loadData(obj.val());
                $scope.atEmplCardRecData = atEmplCardRecSev.getData();
            });
        }
        obj.change(function () {
            atEmplCardRecSev.loadData(obj.val());
        })
        $scope.previous_day = function () {
            document.getElementById("card_date1").stepDown(1);
            document.getElementById('card_date').innerHTML = obj.val();
            atEmplCardRecSev.loadData(obj.val());
        }
        $scope.next_day = function () {
            document.getElementById("card_date1").stepUp(1);
            document.getElementById('card_date').innerHTML = obj.val();
            atEmplCardRecSev.loadData(obj.val());
        }

        $scope.card_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById('card_date').innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById('card_date').innerHTML = date;
                        obj.val(date);
                        atEmplCardRecSev.loadData(obj.val());
                    }
                }
            })
        }


    })




    .controller('webImportCtrl', function ($scope, webImportSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate) {
        $scope.search_control = {};
        $scope.search_control.search_val = "";
        $scope.all_selected = false;
        webImportSev.clearData();
        webImportSev.loadData();
        $scope.webImportData = webImportSev.getData();

        $scope.ckItem = function (_flag) {

            if (_flag == true) {
                $scope.webImportData.num_checked = $scope.webImportData.num_checked + 1;
            } else {
                $scope.webImportData.num_checked = $scope.webImportData.num_checked - 1;
            }

            if ($scope.webImportData.num_checked > 0) {
                $scope.webImportData.show_footer_bar = true;
            } else {
                $scope.webImportData.show_footer_bar = false;
                //$ionicScrollDelegate.resize();
                //setTimeout(function(){ $ionicScrollDelegate.resize(); }, 200);
            }
            if ($scope.webImportData.num_checked == $scope.webImportData.data.length) {
                //$scope.all_selected = true;
                document.getElementById('select_all_employee').style.display = "none";
                document.getElementById('deselect_all_employee').style.display = "block";

            } else {
                //$scope.all_selected = false;
                document.getElementById('select_all_employee').style.display = "block";
                document.getElementById('deselect_all_employee').style.display = "none";
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }

        $scope.select_all_employee = function () {
            //$scope.all_selected = true;
            document.getElementById('select_all_employee').style.display = "none";
            document.getElementById('deselect_all_employee').style.display = "block";
            $scope.webImportData.num_checked = $scope.webImportData.data.length;
            $scope.webImportData.show_footer_bar = true;
            for (var i = 0; i < $scope.webImportData.data.length; i++) {
                $scope.webImportData.data[i].checked = true;
            }
        }
        $scope.cancel = function () {
            //$scope.all_selected = false;
            document.getElementById('select_all_employee').style.display = "block";
            document.getElementById('deselect_all_employee').style.display = "none";
            $scope.webImportData.num_checked = 0;
            $scope.webImportData.show_footer_bar = false;
            for (var i = 0; i < $scope.webImportData.data.length; i++) {
                $scope.webImportData.data[i].checked = false;
            }
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.web_import_save = function () {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确定导入' + $scope.webImportData.num_checked + '人到系统?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    webImportSev.web_import_save($location);
                }
            });


        }


    })



    .controller('webImportResultCtrl', function ($scope, webImportResultSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.failure_employee_no_list = $stateParams.failure_employee_no_list;
        $scope.success_employee_no_list = $stateParams.success_employee_no_list;
        webImportResultSev.clearData();
        webImportResultSev.loadData($scope, $scope.failure_employee_no_list, $scope.success_employee_no_list);
        $scope.webImportResultCtrlData = webImportResultSev.getData();
        $scope.current_datetime = $stateParams.current_datetime;

        if ($scope.failure_employee_no_list == '') {
            $scope.failure_employee_count = 0;
        } else {
            $scope.failure_employee_count = $stateParams.failure_employee_no_list.split(',').length;
        }
        if ($scope.success_employee_no_list == '') {
            $scope.success_employee_count = 0;
        } else {
            $scope.success_employee_count = $stateParams.success_employee_no_list.split(',').length;
        }


        $scope.back_to_user_admin = function () {
            $location.path('home_page/home_menulist/web_import_result_user_admin/' + $stateParams.current_datetime);
        }
        $scope.import_failure_employee = function () {
            webImportResultSev.import_failure_employee($scope);
        }

        $scope.refresh_data = function () {
            webImportResultSev.loadData($scope, $scope.failure_employee_no_list, $scope.success_employee_no_list);
        }

    })

    .controller('webImportResultUserAdminCtrl', function ($scope, $stateParams, settingUdSev, $ionicModal, $ionicPopup, $rootScope, $timeout, $location, $ionicHistory) {
        /*Sunny改*/
        $scope.web_end_import = local_resource + 'img/icon/web_end_import.png';
        $scope.address_book_import = local_resource + 'img/icon/address_book_import.png';
        $scope.manually_add = local_resource + 'img/icon/manually_add.png';

        /*Sunny改*/
        $scope.search_val = "";
        $scope.c_search_val = "";
        $scope.selCt = 0;
        settingUdSev.clearData();
        settingUdSev.loadSortedUserData($stateParams.current_datetime);
        $scope.user_data = settingUdSev.getUserData();

        $scope.custom_back = function () {
            $ionicHistory.goBack(-4);
        }

        $scope.setting_user_admin_delete = function (username, user_id, index) {


            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认删除?' + '</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    settingUdSev.setting_user_admin_delete(username, user_id, index, $scope.search_control.search_val ? true : false);
                }
            });

        }

        $ionicModal.fromTemplateUrl('import-contacts-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.webImport = function () {
            $location.path('home_page/home_menulist/web_import');
        }

        $scope.closeModal = function () {
            $scope.modal.hide();
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
            $scope.add_modal.remove();
        });

        // $scope.contacts_data = [{name:'JACK.ZHENG',phone:'18682168147',ck:false},{name:'JIN',phone:'13528722976'},{name:'gary',phone:'13199092692'}];
        $scope.contacts_data = [];
        try {
            var options = new ContactFindOptions();
            options.filter = "";
            options.multiple = true;
            options.hasPhoneNumber = true;
            var fields = ['*'];
            navigator.contacts.find(fields, function (contacts) {
                $scope.contacts_data = [];
                for (var i = 0; i < contacts.length; i++) {
                    $scope.contacts_data.push({
                        name: ionic.Platform.isIOS() ? (angular.isDefined(contacts[i].name) ? contacts[i].name.formatted : '') : (angular.isDefined(contacts[i].displayName) ? contacts[i].displayName : ''),
                        phone: contacts[i].phoneNumbers != null ? (contacts[i].phoneNumbers[0].value).replace(new RegExp(/(-)/g), '') : '',
                        ck: false
                    })
                }
            }, function (contactError) {}, options);
        } catch (e) {}
        $scope.openModal = function () {
            $scope.modal.show();
        };

        $scope.importAction = function () {
            var phone_list = '';
            var name_list = '';
            var data = $scope.contacts_data;
            for (var i = 0; i < data.length; i++) {
                if (data[i].ck) {
                    phone_list = phone_list + data[i].phone + '*,*';
                    name_list = name_list + data[i].name + '*,*';
                }
            }
            if (phone_list == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">没有选中通讯录数据</div>',
                    okText: '确定'
                }).then(function (res) {});
            } else {
                $rootScope.showLoading();
                $.ajax({
                    type: 'POST',
                    url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.importContacts',
                    timeout: 30000000,
                    data: {
                        phone_list: phone_list.substring(0, phone_list.length - 3),
                        name_list: name_list.substring(0, name_list.length - 3),
                        _user_name: window.localStorage['_user_name'],
                        _pass_word: window.localStorage['_pass_word'],
                        _is_login: window.localStorage['_is_login'],
                        _notification_token: window.localStorage['_notification_token'],
                        _device_type: window.localStorage['_device_type']
                    },
                    success: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        var _data = $.parseJSON(data);
                        if (typeof (_data.flag) != 'undefined' && _data.flag == '0') {
                            fufuMobclickAgent('click_phonebook_import');
                            $location.path('home_page/home_menulist/user_import_result/' + _data.operate_date);
                        } else {
                            $ionicPopup.alert({
                                title: '运行结果',
                                template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                                okText: '确定'
                            }).then(function (res) {

                            });
                        }
                    },
                    error: function (data, status, headers, config) {
                        $rootScope.hideLoading();
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                            okText: '确定'
                        })
                    }
                });
            }
        }

        $scope.user_contact = {
            user_name: '',
            name: '',
            staff_no: '',
            tel: '',
            email: '',
            _flag: 1,
            _message: ''
        }

        $ionicModal.fromTemplateUrl('add-contact-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.add_modal = modal;
        });

        $scope.closeAddModal = function () {
            $scope.add_modal.hide();
        };
        $scope.addUser = function () {
            $scope.user_contact = {
                user_name: '',
                name: '',
                staff_no: '',
                tel: '',
                email: '',
                _flag: 1,
                _message: ''
            }
            $scope.add_modal.show();
        }

        $scope.saveContact = function () {
            for (var p in $scope.user_contact) {
                if ($scope.user_contact[p] == '' && p != '_flag' && p != '_message' && p != '_is_login' && p != '_notification_token' && p != '_device_type') {
                    $scope.user_contact._flag = 0;
                    $scope.user_contact._message = '用户信息不能为空';
                    $timeout(function () {
                        $scope.user_contact._flag = 1;
                        $scope.user_contact._message = '';
                    }, 1500);
                    return;
                }
            }
            $scope.user_contact._user_name = window.localStorage['_user_name'];
            $scope.user_contact._pass_word = window.localStorage['_pass_word'];
            $scope.user_contact._is_login = window.localStorage['_is_login'];
            $scope.user_contact._notification_token = window.localStorage['_notification_token'];
            $scope.user_contact._device_type = window.localStorage['_device_type'];
            $rootScope.showLoading();
            $.ajax({
                type: 'POST',
                url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveContact',
                data: $scope.user_contact,
                timeout: _var_timeout,
                success: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    var _data = $.parseJSON(data);
                    $ionicPopup.alert({
                        title: '运行结果',
                        template: '<div style="text-align: center;">' + _data.message + '</div>',
                        okText: '确定'
                    }).then(function (res) {
                        if (_data.flag == "0") {
                            fufuMobclickAgent('click_single_import');
                            $scope.closeAddModal();
                            settingUdSev.loadUserData();
                        }
                    });
                },
                error: function (data, status, headers, config) {
                    $rootScope.hideLoading();
                    $ionicPopup.alert({
                        title: '提醒',
                        template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                        okText: '确定'
                    })
                }
            });
        }
    })


    .controller('changeUsernameCtrl', function ($scope, changeUsernameSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout) {
        var reg = /^1[3|4|5|7|8]\d{9}$/;
        $('#_change_username_action').attr('disabled', 'disabled');
        $scope.change_user_data = changeUsernameSev.getChangeUserData();
        $scope.changeUsernameSendVCode = function () {
            changeUsernameSev.changeUsernameSendVCode();
        }

        $scope.changeUsernameAction = function () {
            changeUsernameSev.changeUsernameAction();
        }

    })

    .controller('resignUserCtrl', function ($scope, resignUserSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout) {
        $scope.img_cancel = local_resource + "img/icon/cancellatio_of_personal_user.png";
        $scope.resign_user_action = function () {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认注销当前用户?' + '</div><div style="text-align: center;">(注销之后将无法再使用当前用户)</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    resignUserSev.resignUserAction();
                }
            });

        }
    })

    .controller('companyInfoCtrl', function ($scope, companyInfoSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout, sideSelect) {
        companyInfoSev.clearData();
        companyInfoSev.loadData();
        $scope.companyInfoData = companyInfoSev.getData();
        $scope.resignCompany = function () {
            $ionicPopup.confirm({
                title: '提示',
                template: '<div style="text-align: center;">' + '确认注销当前企业?' + '</div><div style="text-align: center;">(注销之后将无法还原,请慎重)</div>',
                cancelText: '取消',
                cancelType: 'button-dark',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    companyInfoSev.resignCompany();
                }
            });

        }
        $scope.saveCompanyInfo = function () {
            companyInfoSev.saveCompanyInfo();
        }


        $scope.side_category = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.companyInfoData.side_category_data,
                selectIndex: $scope.companyInfoData.side_category_data_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("company_info_category").innerHTML = $scope.companyInfoData.side_category_data[index].value;
                        $scope.companyInfoData.side_category_data_index = index;
                        $scope.companyInfoData.cg = $scope.companyInfoData.side_category_data[index].key;
                    }
                }
            });
        }

        $scope.side_empl_num = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.companyInfoData.side_empl_num_data,
                selectIndex: $scope.companyInfoData.side_empl_num_data_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("company_empl_num").innerHTML = $scope.companyInfoData.side_empl_num_data[index].value;
                        $scope.companyInfoData.side_empl_num_data_index = index;
                        $scope.companyInfoData.e_ct = $scope.companyInfoData.side_empl_num_data[index].key;

                        //$scope.regModel._empl_num=document.getElementById("login_empl_num").innerHTML;
                    }
                }
            });
        }

    })

    .controller('staffMasterPositionTreePicklistCtrl', function ($scope, staffMasterPositionTreePicklistSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout) {
        staffMasterPositionTreePicklistSev.clearData();
        staffMasterPositionTreePicklistSev.loadData($stateParams.o_i);
        $scope.staffMasterPositionTreePicklistData = staffMasterPositionTreePicklistSev.getData();
        if ($stateParams.o_i != '') {
            $scope.checked_node = $stateParams.o_i;
            $scope.checked_node_name = $stateParams.o_n;
            //document.getElementById('position_picklist_tree_button').style.display = "block";
        } else {
            $scope.checked_node = '';
            $scope.checked_node_name = '';
        }
        $scope.$on('$ionTreeList:ItemClicked', function (event, item) {

            if ($scope.checked_node != '') {
                document.getElementById('position_node_' + $scope.checked_node).style.backgroundColor = '#fff';
            }
            $scope.checked_node = item.n_i;
            $scope.checked_node_name = item.n_n;
            document.getElementById('position_node_' + $scope.checked_node).style.backgroundColor = '#f5f5f5';
            //document.getElementById('position_picklist_tree_button').style.display = "block";
        });
        $scope.position_picklist = function () {
            if ($scope.checked_node == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">请选择组织架构</div>',
                    okText: '确定'
                }).then(function (res) {});
            } else {
                if ($stateParams.page_name == 'staff_master') {
                    $location.path('home_page/home_menulist/staff_master_position_picklist/' + $scope.checked_node + '/' + $scope.checked_node_name + '/' + $stateParams.p_i + '/' + $stateParams.p_n);
                } else {
                    $location.path('home_page/home_menulist/personnal_details_position_picklist/' + $scope.checked_node + '/' + $scope.checked_node_name + '/' + $stateParams.p_i + '/' + $stateParams.p_n);
                }
            }
        }



        /*
        $scope.temp_tree=[{
            "n_i": "2538",
            "n_n": "施特伟",
            "ch": false,
            "tr": [{
                "n_i": "2539",
                "n_n": "深圳分公司",
                "ch": false,
                "tr": [{
                    "n_i": "2540",
                    "n_n": "开发部",
                    "ch": false,
                    "tr": [{
                        "n_i": "2543",
                        "n_n": "云项目",
                        "ch": false
                    }, {
                        "n_i": "2544",
                        "n_n": "实施项目",
                        "ch": false
                    }]
                }, {
                    "n_i": "2541",
                    "n_n": "行政部",
                    "ch": true
                }, {
                    "n_i": "2542",
                    "n_n": "设计部",
                    "ch": false
                }]
            }]
        }]
        */
    })

    .controller('staffMasterPositionPicklistCtrl', function ($scope, staffMasterPositionPicklistSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout) {
        staffMasterPositionPicklistSev.clearData();
        staffMasterPositionPicklistSev.loadData($stateParams.o_i, $stateParams.p_i);
        $scope.staffMasterPositionPicklistData = staffMasterPositionPicklistSev.getData();
        $scope.position_clicked = function (position_id) {
            document.getElementById('position_picklist_button').style.display = "block";
            for (var i = 0; i < $scope.staffMasterPositionPicklistData.length; i++) {
                if ($scope.staffMasterPositionPicklistData[i].n_i == position_id) {
                    $scope.staffMasterPositionPicklistData[i].ch = true;
                } else {
                    $scope.staffMasterPositionPicklistData[i].ch = false;
                }
            }
            //$ionicHistory.goBack(-2);
        }
        $scope.picklist_complete = function () {
            for (var i = 0; i < $scope.staffMasterPositionPicklistData.length; i++) {
                if ($scope.staffMasterPositionPicklistData[i].ch) {
                    $('#p_n_i').val($scope.staffMasterPositionPicklistData[i].n_i);
                    $('#o_n_i').val($stateParams.o_i);
                    $("#dept_name_div").html($stateParams.o_n)
                    $("#position_name_div").html($scope.staffMasterPositionPicklistData[i].n_n)
                    $ionicHistory.goBack(-2);
                }
            }
        }
    })

    .controller('tempStaffMasterPositionPicklistCtrl', function ($scope, tempStaffMasterPositionPicklistSev, $stateParams, $location, $ionicPopup, $ionicHistory, $timeout) {
        $scope.o_i = $stateParams.o_i;
        $scope.p_i = $stateParams.p_i;
        $scope.o_n = $stateParams.o_n;
        $scope.p_n = $stateParams.p_n;

        tempStaffMasterPositionPicklistSev.clearData();
        tempStaffMasterPositionPicklistSev.loadData($stateParams.node_id);
        $scope.tempStaffMasterPositionPicklistData = tempStaffMasterPositionPicklistSev.getData();
        $scope.position_clicked = function (p_i, p_n, o_i, o_n) {
            $scope.o_i = o_i;
            $scope.p_i = p_i;
            $scope.o_n = o_n;
            $scope.p_n = p_n;
            $scope.picklist_submit();
        }
        $scope.picklist_submit = function () {
            $("#o_n_i").val($scope.o_i);
            $("#dept_name_div").html($scope.o_n);
            $("#p_n_i").val($scope.p_i);
            $("#position_name_div").html($scope.p_n);
            $ionicHistory.goBack();
        }

    })


    .controller('atSignInCtrl', function ($scope, atSignInSev, $stateParams, $location, $ionicPopup, $ionicHistory, $rootScope, $ionicActionSheet, homemessageSev, timeSelect) {

        var current_date = new Date();
        var shake_process_timeout;
        var current_address = '';
        var current_latitude = '';
        var current_longitude = '';
        var address_city = '';
        $scope.shake_original = local_resource + 'img/icon/shake_process1.png';
        $scope.shake_disable = local_resource + 'img/icon/shake_disable.png';
        $scope.press_img = local_resource + 'img/icon/Field_manual_punch.png';
        $scope.press_disable_img = local_resource + 'img/icon/Field_manual_punch_02.png';
        $scope.img_selected = local_resource + 'img/icon/selected.png';
        $scope.wifi_img = local_resource + 'img/icon/wifi.png';
        $scope.img_at_disable_sign_in = local_resource + 'img/icon/at_disable_sign_in.png';
        $scope.signinbgimg = local_resource + 'img/model/sign_in_div_bgimg.png';
        //new imgsrc
        $scope.field_attendance = local_resource + 'img/icon/field_attendance.png';
        $scope.Sign_photos = local_resource + 'img/icon/Sign_photos.png';
        $scope.img_team_attendance_iocation = local_resource + 'img/icon/team_attendance_iocation.png';
        $scope.img_team_attendance_wifi = local_resource + 'img/icon/team_attendance_wifi.png';
        $scope.img_team_attendance_fingerprint = local_resource + 'img/icon/team_attendance_fingerprint.png';
        $scope.img_team_attendance_examination = local_resource + 'img/icon/team_attendance_examination.png';
        $scope.img_circle3 = local_resource + 'img/icon/circle3.png';
        $scope.img_circle4 = local_resource + 'img/icon/circle4.png';
        $scope.img_circle5 = local_resource + 'img/icon/circle5.png';
        $scope.img_circle6 = local_resource + 'img/icon/circle6.png';
        $scope.img_normal_sign_in = local_resource + 'img/icon/sign_in_normal.png';
        $scope.img_fieldwork_sign_in = local_resource + 'img/icon/sign_in_fieldwork.png';
        $scope.img_other_sign_in = local_resource + 'img/icon/sign_in_other_types.png';

        fufuMobclickAgent('click_sign_in_view');

        $scope.outdoor_address = '';

        try {
            getLocation.location(function (msg) {
                current_address = msg.address;
                current_latitude = msg.latitude;
                current_longitude = msg.longitude;
                address_city = msg.city;
                //$scope.outdoor_address=msg.address;
                if (typeof (current_address) != "undefined" && current_address != '') {
                    try {
                        document.getElementById('wifi_sign_in_out').style.display = 'block';
                        document.getElementById('wifi_sign_in_out_address').innerHTML = current_address;
                    } catch (e) {

                    }

                }
            });
        } catch (e) {
            console.log(e.message);
        }



        $scope.details_click = function () {
            document.getElementById('sign_in_tab_1').style.color = 'white';
            document.getElementById('sign_in_tab_1').style.backgroundColor = '#53afff';
            document.getElementById('sign_in_tab_1').style.border = '1px solid #53afff';
            document.getElementById('sign_in_tab_2').style.color = 'black';
            document.getElementById('sign_in_tab_2').style.backgroundColor = 'white';
            document.getElementById('sign_in_tab_2').style.border = '1px solid #eeeeee';
            document.getElementById('sign_in_tab_2').style.borderLeft = 'none';
            document.getElementById('signoutdoor').style.display = "block";
            document.getElementById('signindoor').style.display = "none";
            //OtTeamRecordSev.loadData(_date,$scope);
            //$scope.ot_team_record_data = OtTeamRecordSev.getData();
        }
        $scope.statistics_click = function () {
            document.getElementById('signoutdoor').style.display = "none";
            document.getElementById('signindoor').style.display = "block";
            document.getElementById('sign_in_tab_2').style.border = '1px solid #53afff'
            document.getElementById('sign_in_tab_1').style.color = 'black';
            document.getElementById('sign_in_tab_1').style.backgroundColor = 'white';
            document.getElementById('sign_in_tab_1').style.border = '1px solid #eeeeee';
            document.getElementById('sign_in_tab_1').style.borderRight = 'none';
            document.getElementById('sign_in_tab_2').style.color = 'white';
            document.getElementById('sign_in_tab_2').style.backgroundColor = '#53afff';
            //OtTeamRecordSev.loadStatisticsData(_date,$scope);
            //$scope.ot_team_record_statistics_data=OtTeamRecordSev.getStatisticsData();
        };
        $scope.no_out_door_click = function () {
            $ionicPopup.alert({
                title: '提醒',
                template: '<div style="text-align: center;">今天尚未申请外出</div>',
                okText: '确定'
            }).then(function (res) {

            });
        }

        $scope.redirect_to_approval = function (p_i, t_id, ty, is_process) {
            if (ty == '100') {
                $location.path("home_page/ess_my_apply_details_content_fieldwork_atsignin/" + p_i + "/" + "my_apply" + "/" + t_id + "/" + "未完成" + "/" + is_process + "/at_sign_in");
            } else if (ty == '101') {
                $location.path("home_page/ess_my_apply_details_content_offic_work_out_atsignin/" + p_i + "/" + "my_apply" + "/" + t_id + "/" + "未完成" + "/" + is_process + "/at_sign_in");
            }
        }

        $scope.processing = 0;
        var process_counter = 0;
        //$('._press_at_sign_in').text('按一下打卡');
        clearTimeout(shake_process_timeout);
        //点击图片获得地理位置
        $scope.shake_outer_div_click = function () {
            if ($scope.atSignInData.is_can_in == '0') {

                return;
            }

            if ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '2') {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            sign_in_preset();
                        }
                    });
            } else {
                sign_in_preset();
            }


        }

        function sign_in_preset() {
            if ($scope.processing == 0) {
                $scope.processing = 1;
                current_address = '';
                current_latitude = '';
                current_longitude = '';
                document.getElementById("sign_in_wifi_name").value = '';
                document.getElementById("sign_in_wifi_mac").value = '';
                $rootScope.showLoading();
                shake_process();


                try {
                    getLocation.location(function (msg) {
                        current_address = msg.address;
                        current_latitude = msg.latitude;
                        current_longitude = msg.longitude;
                        address_city = msg.city;
                    });
                } catch (e) {
                    console.log(e.message);
                }



                if ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '1') {
                    try {
                        network.wifiInfo(function (msg) {
                            try {
                                var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
                                var wifi_str = "";
                                for (var v = 0; v < wifi_arr1.length; v++) {
                                    if (wifi_arr1[v] != '"') {
                                        wifi_str = wifi_str + wifi_arr1[v];
                                    }
                                }
                                document.getElementById("sign_in_wifi_name").value = wifi_str;
                                document.getElementById("sign_in_wifi_mac").value = msg.mac;

                                if (typeof ($scope.atSignInData.wifi_mac) != 'undefined') {

                                    if ($scope.atSignInData.wifi_mac == msg.mac && ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '1')) {

                                        document.getElementById("wifi_sign_in").style.display = "block";
                                    } else {
                                        document.getElementById("wifi_sign_in").style.display = "none";
                                    }
                                }
                            } catch (e) {

                            }
                            //  alert(msg.mac);
                        });
                    } catch (e) {
                        console.log(e.message);

                    }
                }



            }

        }


        function shake_process() {


            $('._press_at_sign_in').text('正在打卡，请稍等...');
            shake_process_timeout = setTimeout(shake_process, 100);


            process_counter = process_counter + 1;
            if (process_counter == 100 || ($scope.atSignInData.valid_mode == '1,2' && current_address != '' && document.getElementById("sign_in_wifi_mac").value != '') ||
                ($scope.atSignInData.valid_mode == '1' && document.getElementById("sign_in_wifi_mac").value != '') ||
                ($scope.atSignInData.valid_mode == '2' && current_address != '') ||
                ($scope.atSignInData.valid_mode == '')
            ) {

                $rootScope.hideLoading();
                clearTimeout(shake_process_timeout);
                process_counter = 0;

                if (process_counter == 100) {
                    if (current_address == '') {
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">获取定位信息失败，请重新打卡</div>',
                            okText: '确定'
                        }).then(function (res) {
                            $scope.processing = 0;
                            $rootScope.hideLoading();
                            //$('._press_at_sign_in').text('按一下打卡');
                        });
                    } else if (document.getElementById("sign_in_wifi_mac").value == '' && ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '1')) {
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">获取Wifi信息失败，请重新打卡</div>',
                            okText: '确定'
                        }).then(function (res) {
                            $scope.processing = 0;
                            $rootScope.hideLoading();
                            //$('._press_at_sign_in').text('按一下打卡');
                        });
                    }
                } else {
                    atSignInSev.signInAction($scope, current_address, current_latitude, current_longitude);
                }


            }
        }

        $scope.reddi = function () {
            if ($scope.atSignInData.is_can_out == "1") {
                $ionicPopup.confirm({
                    template: '<div style="text-align: center;">不在允许签到范围内，是否使用异地打卡继续签到?</div>',
                    cancelType: 'button-dark',
                    cancelText: '取消',
                    okText: '继续打卡'
                }).then(function (res) {
                    if (res) {
                        $scope.processing = 0;
                        $location.path('home_page/remote_clock');
                    }

                });
            } else {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">未抵达内勤签到位置范围！</div>',
                    okText: '确定'
                }).then(function (res) {

                });

            }

            $scope.processing = 0;
        }
        current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
        current_date = current_date.toJSON().slice(0, 10);

        atSignInSev.clearData();
        atSignInSev.loadData(current_date);

        $scope.$on("$ionicView.enter", function (event, data) {
            //$('#at_sign_in_current_date').val();
            //console.log(document.getElementById('at_sign_in_current_date'));
            document.getElementById("previous_day").onclick = function () {
                fufuMobclickAgent('click_sign_in_history');
                document.getElementById("at_sign_in_current_date").stepDown(1);
                document.getElementById("at_sign_in_current_date_1").innerHTML = document.getElementById("at_sign_in_current_date").value;
                atSignInSev.loadData($('#at_sign_in_current_date').val());

            }
            document.getElementById("next_day_clickable").onclick = function () {
                fufuMobclickAgent('click_sign_in_history');
                document.getElementById("at_sign_in_current_date").stepUp(1);
                document.getElementById("at_sign_in_current_date_1").innerHTML = document.getElementById("at_sign_in_current_date").value;
                atSignInSev.loadData($('#at_sign_in_current_date').val());

            }

            $('#at_sign_in_current_date').change(function () {
                atSignInSev.loadData($('#at_sign_in_current_date').val());
            })
            $('#at_sign_in_current_date').val(current_date);
            var obj = $('#at_sign_in_current_date');
            $scope.load_card_record = function () {
                atSignInSev.loadData(obj.val());
            }
            document.getElementById("at_sign_in_current_date_2").onclick = function () {
                var current_date = new Date();
                var month = current_date.getMonth() + 1;
                var day = current_date.getDate();
                current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
                current_date = current_date.toJSON().slice(0, 4);
                var startDate = parseInt(current_date, 10) - 10;
                startDate = startDate + '-01-01';
                var endDate = parseInt(current_date, 10)
                timeSelect.show({
                    type: 'date',
                    startDate: '1900-01-01',
                    endDate: endDate + "-" + month + "-" + day,
                    defaultDate: document.getElementById("at_sign_in_current_date_1").innerHTML,
                    returnDateType: 'y-m-d',
                    returnTimeType: '24h' || 'AMPM',
                    //stepping :10,
                    selectedFunc: function (date) {
                        if (typeof (date) != 'undefined') {
                            fufuMobclickAgent('click_sign_in_history');
                            document.getElementById("at_sign_in_current_date_1").innerHTML = date;
                            document.getElementById("at_sign_in_current_date").value = date;
                            atSignInSev.loadData($('#at_sign_in_current_date').val());
                        }
                    }
                })

            }
        });

        $scope.sign_in_outdoor = function () {
            $location.path('home_page/at_sign_in_outdoor');
            //$location.path('home_page/remote_clock');
        }

        $scope.atSignInData = atSignInSev.getData();
        $scope.display_time = atSignInSev.getDisplayTime();

        //obj.change(function () {
        //  alert(obj.val());
        //  atSignInSev.loadData(obj.val());
        //})
        //$scope.previous_day = function () {
        //
        //  document.getElementById("at_sign_in_current_date").stepDown(1);
        //  atSignInSev.loadData(obj.val());
        //}
        //$scope.next_day = function () {
        //  document.getElementById("at_sign_in_current_date").stepUp(1);
        //  atSignInSev.loadData(obj.val());
        //}

        //$scope.load_card_record = function () {
        //  atSignInSev.loadData(obj.val());
        //}

        if ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '1') {
            try {
                network.wifiInfo(function (msg) {
                    try {
                        if (msg.state == '-1' && ionic.Platform.isIOS()) {
                            $ionicPopup.alert({
                                title: '提醒',
                                template: '<div style="text-align: center;">无法获取当前WiFi,请启动WIFI重试</div>',
                                okText: '确定'
                            });
                            return;
                        }
                        var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
                        var wifi_str = "";
                        for (var v = 0; v < wifi_arr1.length; v++) {
                            if (wifi_arr1[v] != '"') {
                                wifi_str = wifi_str + wifi_arr1[v];
                            }
                        }

                        document.getElementById("sign_in_wifi_name").value = wifi_str;
                        document.getElementById("sign_in_wifi_mac").value = msg.mac;

                        if (typeof ($scope.atSignInData.wifi_mac) != 'undefined') {

                            if ($scope.atSignInData.mac == document.getElementById("sign_in_wifi_mac").value && ($scope.atSignInData.valid_mode == '1,2' || $scope.atSignInData.valid_mode == '1')) {

                                document.getElementById("wifi_sign_in").style.display = "block";
                            } else {
                                document.getElementById("wifi_sign_in").style.display = "none";
                            }
                        }
                    } catch (e) {

                    }
                    //  alert(msg.mac);
                });
            } catch (e) {
                console.log(e.message);

            }
        }


    })
    .controller('atSignInOutDoorCtrl', function ($scope, atSignInOutDoorSev, $location, $ionicModal, essLvApplySev, $ionicPopup, $rootScope, $ionicHistory, $ionicScrollDelegate, $emplComponentService) {

        var current_address = '';
        var current_latitude = '';
        var current_longitude = '';
        var location_obj = {
            'latitude': '',
            'longitude': '',
            'address': '',
            'city': ''
        };
        $scope.field_attendance = local_resource + 'img/icon/field_attendance.png';
        $scope.Sign_photos = local_resource + 'img/icon/Sign_photos.png';
        $scope.is_require_upload = '0';
        try {
            document.getElementById("atSignInOutDoorCtrlSpinner").style.display = 'block';
            document.getElementById("atSignInOutDoorCtrlSubmit").style.backgroundColor = '#eeeeee';

            getLocation.checkCanLocation(
                function (result) {
                    if (result == 1) {
                        getLocation.location(function (msg) {
                            try {
                                location_obj = {
                                    'latitude': msg.latitude,
                                    'longitude': msg.longitude,
                                    'address': msg.address,
                                    'city': msg.city
                                };
                                current_address = msg.address;
                                if (typeof (current_address) != 'undefined' && current_address != '') {
                                    document.getElementById("address_now").innerText = current_address;
                                    document.getElementById("atSignInOutDoorCtrlSpinner").style.display = 'none';
                                    document.getElementById("atSignInOutDoorCtrlSubmit").style.backgroundColor = '#53afff';
                                    document.getElementById("message_city").value = msg.city;
                                    current_latitude = msg.latitude;
                                    current_longitude = msg.longitude;
                                    $("#atSignInOutDoor #current_latitude_hidden").val(current_latitude);
                                    $("#atSignInOutDoor #current_longitude_hidden").val(current_longitude);
                                }


                            } catch (e) {}

                        });
                    } else {
                        //$ionicHistory.goBack();
                        document.getElementById("atSignInOutDoorCtrlSpinner").style.display = 'none';
                    }
                }
            );


        } catch (e) {
            console.log(e.message);
        }
        atSignInOutDoorSev.clearData();
        atSignInOutDoorSev.loadData($scope);
        $scope.atSignInOutDoorData = atSignInOutDoorSev.getData();
        $scope.getAddress = function ($scope) {
            if (document.getElementById("atSignInOutDoorCtrlSpinner").style.display == 'block') {
                return;
            }
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.showMap(function (msg) {
                                if (typeof (msg.address) == 'undefined' || msg.address == "" || msg.address == null || msg.address == '(null)') {} else {
                                    try {

                                        location_obj = {
                                            'latitude': msg.latitude,
                                            'longitude': msg.longitude,
                                            'address': msg.address,
                                            'city': msg.detailAddress
                                        };

                                        current_address = msg.address;
                                        document.getElementById("address_now").innerText = current_address;
                                        document.getElementById("message_city").value = msg.city;
                                        current_latitude = msg.latitude;
                                        current_longitude = msg.longitude;
                                        $("#atSignInOutDoor #current_latitude_hidden").val(current_latitude);
                                        $("#atSignInOutDoor #current_longitude_hidden").val(current_longitude);
                                        document.getElementById("message_city").value = msg.city;
                                    } catch (e) {}

                                }
                            }, location_obj);
                        }
                    }
                );
            } catch (e) {
                console.log(e.message);
                alert(e.message);
            }
        }

        $scope.sign_in = function () {
            if ($("#atSignInOutDoor #current_latitude_hidden").val() == '' || $("#atSignInOutDoor #current_latitude_hidden").val() == 'undefined') {
                return;
            }
            $rootScope.showLoading();
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.location(function (msg) {
                                //提交
                                try {
                                    if ($scope.is_require_upload == '0') {
                                        atSignInOutDoorSev.signInOutDoorSave('submit', '', current_latitude, current_longitude, $scope.select_user_id, $scope.select_notify_id, msg.latitude, msg.longitude);
                                    } else {
                                        atSignInOutDoorSev.signInOutDoorSaveWithUpload('submit', '', current_latitude, current_longitude, $scope.select_user_id, $scope.select_notify_id, msg.latitude, msg.longitude);
                                    }
                                } catch (e) {}

                            });
                        }
                    }
                );
            } catch (e) {
                $rootScope.hideLoading();
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                    okText: '确定'
                });
            }

        }

        $scope.sign_change_photos = function () {
			
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.is_require_upload = '1';
										$('#Sign_photos').attr("src", uri);

									}, function () {
										//alert('cancel or failure');
									}, {
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true

									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
										$scope.is_require_upload = '1';
										$('#Sign_photos').attr("src", data.uri);
									
								});
							} catch(e){
								
							}
							
						}
			

        }

        $scope.picklist_sign_in_reason = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#sign_in_reason_key').val();
            var checked_value = $('#sign_in_reason').val();
            var picklist_title = '签到原因';
            var return_key_field_id = 'sign_in_reason_key';
            var return_value_field_id = 'sign_in_reason';
            var hidden_fields = 'new_contract_end_date_editable_div';

            /*
             for (var i=0;i<$scope.employeeContractDetailData.p_d.length;i++){
             picklist_key_list = picklist_key_list + $scope.employeeContractDetailData.p_d[i].key;
             picklist_value_list = picklist_value_list + $scope.employeeContractDetailData.p_d[i].name;
             if (i < $scope.employeeContractDetailData.p_d.length - 1){
             picklist_key_list = picklist_key_list + ',';
             picklist_value_list = picklist_value_list + ',';
             }
             }
             */
            picklist_key_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';
            picklist_value_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';

            $location.path('home_page/home_menulist/picklist_sign_in_reason/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }

        //////////////选择审批人//////////////
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.approver_list = [];
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.atSignInOutDoorData.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.search_control.search_val = '';
            $scope.closeModal();
        }

        $scope.delete_notify = function (user_id) {
            $('#notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.atSignInOutDoorData.notify_list.length; i++) {
                if ($scope.atSignInOutDoorData.notify_list[i].user_id == user_id) {
                    $scope.atSignInOutDoorData.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.atSignInOutDoorData.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }

        $scope.delete_approver = function (user_id) {
            if (!$scope.atSignInOutDoorData.approver_list_flag) {
                return;
            }
            $('#approver_list_div').addClass('approver_list_active');
            $scope.atSignInOutDoorData.approver_list = [];
            $scope.select_user_id = ''
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.atSignInOutDoorData.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.atSignInOutDoorData.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);

                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.atSignInOutDoorData.notify_list.length + 1) * 100 + 20 + 'px';
            $scope.search_control.search_val = '';
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });


        $scope.openModal = function () {

            var selectEmplList = '';
            if ($scope.atSignInOutDoorData.approver_list.length != 0) {
                selectEmplList = $scope.atSignInOutDoorData.approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: 'sign',
                sure: function (rd) { //返回数据，数组格式

                    $('#approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.atSignInOutDoorData.approver_list = [];
                    $scope.atSignInOutDoorData.approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    //$scope.approver_list=$scope.atSignInOutDoorData.approver_list;
                }
            });

        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.atSignInOutDoorData.notify_list.length != 0) {
                for (var i = 0; i < $scope.atSignInOutDoorData.notify_list.length; i++) {
                    selectEmplList += $scope.atSignInOutDoorData.notify_list[i].employee_no;
                    if (i < $scope.atSignInOutDoorData.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: 'sign',
                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.atSignInOutDoorData.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.atSignInOutDoorData.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.atSignInOutDoorData.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }


        /*
            $scope.openModal = function() {
              $('#approver_list_div').removeClass('approver_list_active');
              $scope.search_val = '';
              $scope.click_flag = 0;
              $scope.ess_empl_data = [];
              essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.atSignInOutDoorData.employee_no,'');
              $scope.ess_empl_data = essLvApplySev.getEssEmplData();
              $scope.modal.show();
            };
            $scope.openModal2 = function() {
              $scope.search_val = '';
              $scope.click_flag = 1;
              $scope.ess_empl_data = [];
              essLvApplySev.loadEssEmplData($scope.select_notify_id,$scope.atSignInOutDoorData.employee_no,'');
              $scope.ess_empl_data = essLvApplySev.getEssEmplData();
              $scope.modal.show();
            };
        */
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
        //////////////选择审批人结束//////////////

    })

    .controller('atSignInRemoteCtrl', function ($scope, atSignInRemoteSev, $location, $ionicModal, essLvApplySev, $ionicPopup, $rootScope, $ionicHistory, $ionicScrollDelegate, $emplComponentService) {
        var current_address = '';
        var current_latitude = '';
        var current_longitude = '';
        var location_obj = {
            'latitude': '',
            'longitude': '',
            'address': '',
            'city': ''
        };
        $scope.field_attendance = local_resource + 'img/icon/field_attendance.png';
        $scope.Sign_photos = local_resource + 'img/icon/Sign_photos.png';
        $scope.is_require_upload = '0';
        try {
            document.getElementById('atSignInRemoteCtrlSpinner').style.display = 'block';
            document.getElementById('atSignInRemoteCtrlSubmit').style.backgroundColor = '#eeeeee';
            getLocation.checkCanLocation(
                function (result) {
                    if (result == 1) {
                        getLocation.location(function (msg) {
                            try {
                                if (typeof (msg.address) == 'undefined' || msg.address == "" || msg.address == null || msg.address == '(null)') {} else {
                                    location_obj = {
                                        'latitude': msg.latitude,
                                        'longitude': msg.longitude,
                                        'address': msg.address,
                                        'city': msg.city
                                    };

                                    current_address = msg.address;
                                    document.getElementById("address_now").innerText = current_address;
                                    document.getElementById('atSignInRemoteCtrlSpinner').style.display = 'none';
                                    document.getElementById('atSignInRemoteCtrlSubmit').style.backgroundColor = '#53afff';
                                    document.getElementById("message_city").value = msg.city;
                                    current_latitude = msg.latitude;
                                    current_longitude = msg.longitude;
                                    $("#atSignInRemote #current_latitude_hidden").val(current_latitude);
                                    $("#atSignInRemote #current_longitude_hidden").val(current_longitude);

                                }
                            } catch (e) {}

                        });
                    } else {
                        //$ionicHistory.goBack();
                        document.getElementById('atSignInRemoteCtrlSpinner').style.display = 'none';
                    }
                }
            );

        } catch (e) {
            console.log(e.message);
        }

        atSignInRemoteSev.clearData();
        atSignInRemoteSev.loadData($scope);
        $scope.atSignInRemoteData = atSignInRemoteSev.getData();
        $scope.getAddress = function ($scope) {
            if (document.getElementById('atSignInRemoteCtrlSpinner').style.display == 'block') {
                return;
            }
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.showMap(function (msg) {
                                if (typeof (msg.address) == 'undefined' || msg.address == "" || msg.address == null || msg.address == '(null)') {} else {
                                    try {

                                        location_obj = {
                                            'latitude': msg.latitude,
                                            'longitude': msg.longitude,
                                            'address': msg.address,
                                            'city': msg.detailAddress
                                        };

                                        current_address = msg.address;
                                        document.getElementById("address_now").innerText = current_address;
                                        document.getElementById("message_city").value = msg.city;
                                        current_latitude = msg.latitude;
                                        current_longitude = msg.longitude;
                                        $("#atSignInRemote #current_latitude_hidden").val(current_latitude);
                                        $("#atSignInRemote #current_longitude_hidden").val(current_longitude);
                                    } catch (e) {

                                    }
                                }
                            }, location_obj);
                        }
                    }
                );
            } catch (e) {
                console.log(e.message);
                alert(e.message);
            }
        }

        $scope.sign_in = function () {
            if ($("#atSignInRemote #current_latitude_hidden").val() == 'undefined' || $("#atSignInRemote #current_latitude_hidden").val() == '') {
                return;
            }
            $rootScope.showLoading();
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.location(function (msg) {
                                //提交
                                try {
                                    if ($scope.is_require_upload == '0') {
                                        atSignInRemoteSev.signInOutDoorSave('submit', '', current_latitude, current_longitude, $scope.select_user_id, $scope.select_notify_id, msg.latitude, msg.longitude);
                                    } else {
                                        atSignInRemoteSev.signInOutDoorSaveWithUpload('submit', '', current_latitude, current_longitude, $scope.select_user_id, $scope.select_notify_id, msg.latitude, msg.longitude);
                                    }
                                } catch (e) {

                                }
                            });
                        }
                    }
                );
            } catch (e) {
                $rootScope.hideLoading();
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
                    okText: '确定'
                });
            }

        }

        $scope.sign_change_photos = function () {
			
						if(ionic.Platform.isIOS()){
									try {
										navigator.camera.getPicture(function (uri) {
											$scope.is_require_upload = '1';
											$('#Sign_photos').attr("src", uri);

										}, function () {
											//alert('cancel or failure');
										}, {
											quality: 10,
											//allowEdit: true,
											destinationType: Camera.DestinationType.FILE_URI
										});
									} catch (e) {
										//alert(e.message);
									}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
											$scope.is_require_upload = '1';
											$('#Sign_photos').attr("src", data.uri);
								});
							} catch(e){
								
							}
							
						}
			

            // For example's sake, hide the sheet after two seconds

        }

        $scope.picklist_sign_in_reason = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#sign_in_reason_key').val();
            var checked_value = $('#sign_in_reason').html();
            var picklist_title = '签到原因';
            var return_key_field_id = 'sign_in_reason_key';
            var return_value_field_id = 'sign_in_reason';
            var hidden_fields = 'new_contract_end_date_editable_div';

            /*
             for (var i=0;i<$scope.employeeContractDetailData.p_d.length;i++){
             picklist_key_list = picklist_key_list + $scope.employeeContractDetailData.p_d[i].key;
             picklist_value_list = picklist_value_list + $scope.employeeContractDetailData.p_d[i].name;
             if (i < $scope.employeeContractDetailData.p_d.length - 1){
             picklist_key_list = picklist_key_list + ',';
             picklist_value_list = picklist_value_list + ',';
             }
             }
             */
            picklist_key_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';
            picklist_value_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';

            $location.path('home_page/home_menulist/picklist_sign_in_reason/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }


        //////////////选择审批人//////////////
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.approver_list = [];
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.atSignInRemoteData.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.search_control.search_val = '';
            $scope.closeModal();
        }
        $scope.delete_approver = function (user_id) {
            if (!$scope.atSignInRemoteData.approver_list_flag) {
                return;
            }
            $('#approver_list_div').addClass('approver_list_active');
            $scope.atSignInRemoteData.approver_list = [];
            $scope.select_user_id = ''
        }
        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.atSignInRemoteData.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.atSignInRemoteData.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.atSignInRemoteData.notify_list.length + 1) * 100 + 20 + 'px';
            $scope.search_control.search_val = '';
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });


        $scope.openModal = function () {

            var selectEmplList = '';
            if ($scope.atSignInRemoteData.approver_list.length != 0) {
                selectEmplList = $scope.atSignInRemoteData.approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: 'sign',
                sure: function (rd) { //返回数据，数组格式

                    $('#approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.atSignInRemoteData.approver_list = [];
                    $scope.atSignInRemoteData.approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    //$scope.approver_list=$scope.atSignInRemoteData.approver_list;
                }
            });

        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.atSignInRemoteData.notify_list.length != 0) {
                for (var i = 0; i < $scope.atSignInRemoteData.notify_list.length; i++) {
                    selectEmplList += $scope.atSignInRemoteData.notify_list[i].employee_no;
                    if (i < $scope.atSignInRemoteData.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: 'sign',
                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.atSignInRemoteData.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.atSignInRemoteData.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.atSignInRemoteData.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }
        /*
            $scope.openModal = function() {
              $('#approver_list_div').removeClass('approver_list_active');
              $scope.search_val = '';
              $scope.click_flag = 0;
              $scope.ess_empl_data = [];
              essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.atSignInRemoteData.employee_no,'');
              $scope.ess_empl_data = essLvApplySev.getEssEmplData();
              $scope.modal.show();
            };
            $scope.openModal2 = function() {
        		$('#atSignInRemote #notify_list_div').removeClass('notify_list_active');
              $scope.search_val = '';
              $scope.click_flag = 1;
              $scope.ess_empl_data = [];
              essLvApplySev.loadEssEmplData($scope.select_notify_id,$scope.atSignInRemoteData.employee_no,'');
              $scope.ess_empl_data = essLvApplySev.getEssEmplData();
              $scope.modal.show();
            };
        */
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
        //////////////选择审批人结束//////////////

        $scope.delete_notify = function (user_id) {
            $('#atSignInRemote #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.atSignInRemoteData.notify_list.length; i++) {
                if ($scope.atSignInRemoteData.notify_list[i].user_id == user_id) {
                    $scope.atSignInRemoteData.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.atSignInRemoteData.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }
    })
    .controller('userImportResultCtrl', function ($scope, userImportResultSev, $stateParams, $ionicHistory) {
        $scope.img_import_information_icon = local_resource + 'img/icon/import_information_icon.png';
        userImportResultSev.clearData();
        userImportResultSev.loadData($stateParams.operate_date);
        $scope.userImportResultData = userImportResultSev.getData();
        $scope.import_success_return = function () {
            $ionicHistory.goBack();
        }

    })

    .controller('atMbIndoorSettingCtrl', function (atMbIndoorSettingSev, $scope, $stateParams, $location) {
        atMbIndoorSettingSev.clearData();
        atMbIndoorSettingSev.loadData();
        $scope.atMbIndoorSettingData = atMbIndoorSettingSev.getData();
        $scope.at_mb_indoor_setting_edit = function (id, name) {
            $location.path('home_page/home_menulist/at_mb_indoor_setting_detail/' + id + '/' + name);
        }

    })

    .controller('atMbIndoorSettingDetailCtrl', function ($scope, $location, $timeout, $stateParams, atMbIndoorSettingDetailSev, $ionicPopup, $ionicScrollDelegate) {
        atMbIndoorSettingDetailSev.clearData();
        atMbIndoorSettingDetailSev.loadData($stateParams.shift_group_id, local_resource);
        $scope.atMbIndoorSettingDetailData = atMbIndoorSettingDetailSev.getData();
        $scope.at_mb_indoor_setting_detail_title = $stateParams.shift_group_name;
        $scope.img_edit = local_resource + 'img/icon/small_icon_edit.png';
        $scope.img_delete = local_resource + 'img/icon/small_icon_delete.png';
        $scope.indoor_setting_detail_edit = function (id) {

            $location.path("home_page/home_menulist/at_mb_indoor_setting_detail_edit/" + setting_detail_id);
        }

        $scope.reload_data = function (shift_group_id, local_resource) {
            atMbIndoorSettingDetailSev.loadData(shift_group_id, local_resource);
        }

        $scope.details_click = function () {
            /* document.getElementById('details_div').style.color='white';
      document.getElementById('details_div').style.backgroundColor='#53afff';
      document.getElementById('details_div').style.border='none';
      document.getElementById('statistics_div').style.color='black';
      document.getElementById('statistics_div').style.backgroundColor='white';
      document.getElementById('statistics_div').style.border='1px solid #eeeeee';
        document.getElementById('statistics_div').style.borderLeft='none';
      document.getElementById('indoor_setting_wrap_left').style.display="block";
      document.getElementById('indoor_setting_wrap_right').style.display="none";
	  */

            document.getElementById('details_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.color = '#808080';
            document.getElementById('details_div').style.borderBottom = 'none';
            document.getElementById('statistics_div').style.borderBottom = '1px solid #f5f5f5';
            document.getElementById('indoor_setting_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('indoor_setting_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('indoor_setting_wrap').style.overflow = "visible";
            document.getElementById('indoor_setting_wrap_left').setAttribute("style", "width:50%;padding-top:11px;");
            document.getElementById('indoor_setting_wrap_right').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('indoor_setting_wrap').style.overflow = "hidden";
            }, 200);


        }
        $scope.statistics_click = function () {
            /*document.getElementById('indoor_setting_wrap_left').style.display="none";
      document.getElementById('indoor_setting_wrap_right').style.display="block";
      document.getElementById('statistics_div').style.border='none'
      document.getElementById('details_div').style.color='black';
      document.getElementById('details_div').style.backgroundColor='white';
      document.getElementById('details_div').style.border='1px solid #eeeeee';
      document.getElementById('details_div').style.borderRight='none';
      document.getElementById('statistics_div').style.color='white';
      document.getElementById('statistics_div').style.backgroundColor='#53afff';
	  */





            document.getElementById('details_div').style.color = '#808080';
            document.getElementById('statistics_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.borderBottom = 'none';
            document.getElementById('details_div').style.borderBottom = '1px solid #f5f5f5';
            document.getElementById('indoor_setting_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('indoor_setting_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('indoor_setting_wrap').style.overflow = "visible";
            document.getElementById('indoor_setting_wrap_left').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;padding-top:11px;");
            document.getElementById('indoor_setting_wrap_right').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('indoor_setting_wrap').style.overflow = "hidden";
            }, 200);
        }



        $scope.at_mb_indoor_setting_detail_checkbox = function () {

            if (document.getElementById("at_mb_indoor_setting_detail_checkbox").checked) {
                //document.getElementById("is_active_content").style.display="block";
                $scope.atMbIndoorSettingDetailData.i_a = '1';
            } else {
                //document.getElementById("is_active_content").style.display="none";
                $scope.atMbIndoorSettingDetailData.i_a = '0';
            }

            /*
        $timeout(function(){ $ionicScrollDelegate.resize();
        }, 100);
		*/

            /*
            if ($scope.atMbIndoorSettingDetailData.i_a == $scope.atMbIndoorSettingDetailData.default_i_a){
            	document.getElementById("at_mb_indoor_setting_detail_normal_save_div").style.display="none";
            }
            else {
            	document.getElementById("at_mb_indoor_setting_detail_normal_save_div").style.display="block";
            }
            */




        }

        $scope.is_active = function () {
            if (document.getElementById("is_active").checked) {
                $scope.atMbIndoorSettingDetailData.i_a_o = '1';
                document.getElementById("is_active_content_right").style.display = 'block';
            } else {
                $scope.atMbIndoorSettingDetailData.i_a_o = '0';
                document.getElementById("is_active_content_right").style.display = 'none';
            }
        }
        $scope.is_use_work_flow = function () {
            if (document.getElementById("is_use_work_flow").checked) {
                $scope.atMbIndoorSettingDetailData.i_wf = '1';
            } else {
                $scope.atMbIndoorSettingDetailData.i_wf = '0';
            }
        }
        $scope.is_need_photo = function () {
            if (document.getElementById("is_need_photo").checked) {
                $scope.atMbIndoorSettingDetailData.i_p = '1';
            } else {
                $scope.atMbIndoorSettingDetailData.i_p = '0';
            }
        }
        $scope.is_sent_location = function () {
            if (document.getElementById("is_sent_location").checked) {
                $scope.atMbIndoorSettingDetailData.i_l = '1';
            } else {
                $scope.atMbIndoorSettingDetailData.i_l = '0';
            }
        }

        $scope.at_mb_indoor_setting_detail_normal_save = function () {

            atMbIndoorSettingDetailSev.at_mb_indoor_setting_detail_normal_save($stateParams.shift_group_id, $scope);
        }

        $scope.at_mb_indoor_setting_detail_outdoor_save = function () {

            atMbIndoorSettingDetailSev.at_mb_indoor_setting_detail_outdoor_save($stateParams.shift_group_id);
        }

        $scope.at_mb_indoor_setting_detail_edit = function (setting_detail_id, form_title) {

            $location.path('home_page/home_menulist/at_mb_indoor_setting_detail_edit/' + setting_detail_id + '/' + form_title + '/' + $stateParams.shift_group_id);
        }

        $scope.at_mb_indoor_setting_detail_delete = function (setting_detail_id, detail_str) {
            $ionicPopup.confirm({
                template: '<div style="text-align: center;">确认删除' + detail_str + '?</div>',
                cancelType: 'button-dark',
                cancelText: '取消',
                okText: '确认'
            }).then(function (res) {
                if (res) {
                    atMbIndoorSettingDetailSev.at_mb_indoor_setting_detail_location_delete(setting_detail_id, $scope, $stateParams.shift_group_id, local_resource);
                }
            });



        }

    })


    .controller('atMbIndoorSettingDetailEditCtrl', function ($scope, $location, $timeout, $stateParams, atMbIndoorSettingDetailSev, $ionicPopup, $ionicScrollDelegate) {

        atMbIndoorSettingDetailSev.loadLocationData($stateParams.setting_detail_id);
        $scope.atMbIndoorSettingDetailData = atMbIndoorSettingDetailSev.getLocationData();

        $scope.at_mb_indoor_setting_detail_title = $stateParams.form_title;
        try {
            getLocation.checkCanLocation(
                function (result) {

                }
            );
        } catch (e) {
            console.log(e.message);
        }

        try {
            network.wifiInfo(function (msg) {

                try {
                    if (msg.state == '-1' && ionic.Platform.isIOS()) {
                        $ionicPopup.alert({
                            title: '提醒',
                            template: '<div style="text-align: center;">无法获取当前WiFi,请启动WIFI重试</div>',
                            okText: '确定'
                        });
                        return;
                    }
                    var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
                    var wifi_str = "";
                    for (var v = 0; v < wifi_arr1.length; v++) {
                        if (wifi_arr1[v] != '"') {
                            wifi_str = wifi_str + wifi_arr1[v];
                        }
                    }
                    document.getElementById("wifi_name").innerHTML = wifi_str;
                    document.getElementById("at_mb_indoor_setting_wifi_mac").value = msg.mac;
                } catch (e) {}
            })
        } catch (e) {
            console.log(e.message);
        }

        $scope.at_mb_indoor_setting_detail_location_save = function () {
            if (document.getElementById("atMbIndoorSettingDetailCtrlSpinner").style.display == 'block') {
                return;
            }
            var valid_mode = "";
            if (document.getElementById("w_f_content").style.display == "block" && document.getElementById("loc_content").style.display == "block") {
                valid_mode = "1,2"
            } else if (document.getElementById("w_f_content").style.display == "block") {
                valid_mode = "1"
            } else if (document.getElementById("loc_content").style.display == "block") {
                valid_mode = "2";
            } else {
                valid_mode = "";
            }
            atMbIndoorSettingDetailSev.atMbIndoorSettingDetailLocationSave($stateParams.shift_group_id, valid_mode, $stateParams.setting_detail_id);
        }
        $scope.use_current_wifi = function () {
            if (document.getElementById("wifi_name").innerHTML != '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">已取到当前WiFi</div>',
                    okText: '确定'
                }).then(function (res) {
                    document.getElementById("wifi_name_submit").innerHTML = document.getElementById("wifi_name").innerHTML;
                    document.getElementById("at_mb_indoor_setting_wifi_mac_submit").value = document.getElementById("at_mb_indoor_setting_wifi_mac").value;
                });
            } else {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">不能获取当前WiFi,请检查WiFi是否已经连上然后再重试.</div>',
                    okText: '确定'
                }).then(function (res) {

                });
            }

        }


        $scope.indoor_setting_img_1 = function () {
            var res = $scope.atMbIndoorSettingDetailData.v_m[0].ch;
            res = !res;
            $scope.atMbIndoorSettingDetailData.v_m[0].ch = res;
            if (res) {
                document.getElementById("indoor_setting_img_1").src = local_resource + 'img/icon/selected.png';
                document.getElementById("w_f_content").style.display = "block";
                try {
                    network.wifiInfo(function (msg) {

                        try {
                            if (msg.state == '-1' && ionic.Platform.isIOS()) {
                                $ionicPopup.alert({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">无法获取当前WiFi,请启动WIFI重试</div>',
                                    okText: '确定'
                                });
                                return;
                            }
                            var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
                            var wifi_str = "";
                            for (var v = 0; v < wifi_arr1.length; v++) {
                                if (wifi_arr1[v] != '"') {
                                    wifi_str = wifi_str + wifi_arr1[v];
                                }
                            }

                            document.getElementById("wifi_name").innerHTML = wifi_str;
                            document.getElementById("at_mb_indoor_setting_wifi_mac").value = msg.mac;
                        } catch (e) {}
                    });
                } catch (e) {
                    document.getElementById("indoor_setting_img_1").src = local_resource + 'img/icon/noselect.png';
                    document.getElementById("w_f_content").style.display = "none";
                    console.log(e.message);
                }
            } else {
                document.getElementById("indoor_setting_img_1").src = local_resource + 'img/icon/noselect.png';
                document.getElementById("w_f_content").style.display = "none";
            }
        }
        $scope.indoor_setting_img_2 = function () {
            var res = $scope.atMbIndoorSettingDetailData.v_m[1].ch;
            res = !res;
            $scope.atMbIndoorSettingDetailData.v_m[1].ch = res;
            if (res) {
                document.getElementById("indoor_setting_img_2").src = local_resource + 'img/icon/selected.png';
                document.getElementById("loc_content").style.display = "block";
                if (document.getElementById('sign_in_location').innerHTML == '') {


                    try {
                        document.getElementById("atMbIndoorSettingDetailCtrlSpinner").style.display = 'block';
                        document.getElementById("at_mb_indoor_setting_detail_save").style.backgroundColor = '#eeeeee';

                        getLocation.checkCanLocation(
                            function (result) {
                                if (result == 1) {
                                    getLocation.location(function (msg) {
                                        try {
                                            document.getElementById("sign_in_location").innerHTML = msg.address;
                                            document.getElementById("atMbIndoorSettingDetailCtrlSpinner").style.display = 'none';
                                            document.getElementById("at_mb_indoor_setting_detail_save").style.backgroundColor = '#53afff';

                                            $("#at_mb_indoor_setting_latitude").val(msg.latitude);
                                            $("#at_mb_indoor_setting_longitude").val(msg.longitude);
                                        } catch (e) {

                                        }
                                    });
                                }
                            }
                        );
                    } catch (e) {
                        console.log(e.message);
                        document.getElementById("indoor_setting_img_2").src = local_resource + 'img/icon/noselect.png';
                        document.getElementById("loc_content").style.display = "none";
                    }
                }
            } else {
                document.getElementById("indoor_setting_img_2").src = local_resource + 'img/icon/noselect.png';
                document.getElementById("loc_content").style.display = "none";
            }
        }



        $scope.searchMap = function () {
            if (document.getElementById("atMbIndoorSettingDetailCtrlSpinner").style.display == 'block') {
                return;
            }

            getLocation.checkCanLocation(
                function (result) {
                    if (result == 1) {
                        getLocation.searchMap({
                            latitude: $scope.atMbIndoorSettingDetailData.lat,
                            longitude: $scope.atMbIndoorSettingDetailData.lon,
                            anotherName: $scope.atMbIndoorSettingDetailData.loc
                        }, function (msg) {
                            try {
                                if (msg.latitude != '') {
                                    document.getElementById("sign_in_location").innerHTML = msg.anotherName;
                                    $("#at_mb_indoor_setting_latitude").val(msg.latitude);
                                    $("#at_mb_indoor_setting_longitude").val(msg.longitude);
                                    $scope.atMbIndoorSettingDetailData.lat = msg.latitude;
                                    $scope.atMbIndoorSettingDetailData.lon = msg.longitude;
                                    $scope.atMbIndoorSettingDetailData.loc = msg.anotherName;
                                }
                            } catch (e) {}
                            //alert(msg.latitude);
                            //alert(msg.longitude);
                            //alert(msg.address);
                        });
                    }
                }
            );


        }

    })

    .controller('atMbOutdoorSettingCtrl', function ($scope, $stateParams, atMbOutdoorSettingSev, $timeout, $ionicScrollDelegate) {
        atMbOutdoorSettingSev.clearData();
        atMbOutdoorSettingSev.loadData($stateParams.shift_group_id);
        $scope.atMbOutdoorSettingData = atMbOutdoorSettingSev.getData();

        $scope.at_mb_outdoor_setting_save = function () {
            //console.log($scope.atMbOutdoorSettingData.with_bill_location_deviation)
            atMbOutdoorSettingSev.atMbOutdoorSettingSave()
        }
        $scope.is_active = function () {
            if (document.getElementById("is_active").checked) {
                $scope.atMbOutdoorSettingData.i_a = '1';
                document.getElementById("is_active_content").style.display = 'block';
            } else {
                $scope.atMbOutdoorSettingData.i_a = '0';
                document.getElementById("is_active_content").style.display = 'none';
            }
        }
        $scope.is_use_work_flow = function () {
            if (document.getElementById("is_use_work_flow").checked) {
                $scope.atMbOutdoorSettingData.i_wf = '1';
            } else {
                $scope.atMbOutdoorSettingData.i_wf = '0';
            }
        }
        $scope.is_use_work_flow_left = function () {
            if (document.getElementById("is_use_work_flow_left").checked) {
                $scope.atMbOutdoorSettingData.i_wf_b = '1';
            } else {
                $scope.atMbOutdoorSettingData.i_wf_b = '0';
            }
        }
        $scope.is_need_photo = function () {
            if (document.getElementById("is_need_photo").checked) {
                $scope.atMbOutdoorSettingData.i_p = '1';
            } else {
                $scope.atMbOutdoorSettingData.i_p = '0';
            }
        }
        $scope.is_sent_location = function () {
            if (document.getElementById("is_sent_location").checked) {
                $scope.atMbOutdoorSettingData.i_l = '1';
            } else {
                $scope.atMbOutdoorSettingData.i_l = '0';
            }
        }
        $scope.is_use_bill_location = function () {
            if (document.getElementById("is_use_bill_location").checked) {
                $scope.atMbOutdoorSettingData.is_use_bill_location = '1';
                document.getElementById("is_use_bill_location_div").style.display = 'block';
            } else {
                $scope.atMbOutdoorSettingData.is_use_bill_location = '0';
                document.getElementById("is_use_bill_location_div").style.display = 'none';
            }
        }

        $scope.details_click = function () {
            /*document.getElementById('details_div').style.color='white';
      document.getElementById('details_div').style.backgroundColor='#53afff';
      document.getElementById('details_div').style.border='none';
      document.getElementById('statistics_div').style.color='black';
      document.getElementById('statistics_div').style.backgroundColor='white';
      document.getElementById('statistics_div').style.border='1px solid #eeeeee';
      document.getElementById('statistics_div').style.borderLeft='none';
      document.getElementById('outdoor_setting_wrap_left').style.display="block";
      document.getElementById('outdoor_setting_wrap_right').style.display="none";
	  */

            document.getElementById('details_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.color = '#808080';
            document.getElementById('details_div').style.borderBottom = 'none';
            document.getElementById('statistics_div').style.borderBottom = '1px solid #f5f5f5';
            document.getElementById('outdoor_setting_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('outdoor_setting_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('outdoor_setting_wrap').style.overflow = "visible";
            document.getElementById('outdoor_setting_wrap_left').setAttribute("style", "width:50%;padding-top:10px;");
            document.getElementById('outdoor_setting_wrap_right').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;padding-top:10px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('outdoor_setting_wrap').style.overflow = "hidden";
            }, 200);
        }
        $scope.statistics_click = function () {
            /*document.getElementById('outdoor_setting_wrap_left').style.display="none";
      document.getElementById('outdoor_setting_wrap_right').style.display="block";
      document.getElementById('statistics_div').style.border='none'
      document.getElementById('details_div').style.color='black';
      document.getElementById('details_div').style.backgroundColor='white';
      document.getElementById('details_div').style.border='1px solid #eeeeee';
      document.getElementById('details_div').style.borderRight='none';
      document.getElementById('statistics_div').style.color='white';
      document.getElementById('statistics_div').style.backgroundColor='#53afff';
	  */

            document.getElementById('details_div').style.color = '#808080';
            document.getElementById('statistics_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.borderBottom = 'none';
            document.getElementById('details_div').style.borderBottom = '1px solid #f5f5f5';
            document.getElementById('outdoor_setting_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('outdoor_setting_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('outdoor_setting_wrap').style.overflow = "visible";
            document.getElementById('outdoor_setting_wrap_left').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;padding-top:10px;");
            document.getElementById('outdoor_setting_wrap_right').setAttribute("style", "width: 50%;float: right;padding-top:10px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('outdoor_setting_wrap').style.overflow = "hidden";
            }, 200);
        }

    })

    .controller('picklistMinUnitCtrl', function ($scope, lvCodeSettingDetailSev, $stateParams, $location, $ionicPopup, $ionicHistory) {
        $scope.picklist_key_list = $stateParams.picklist_key_list.split(',');
        $scope.picklist_value_list = $stateParams.picklist_value_list.split(',');
        $scope.picklist_title = $stateParams.picklist_title;
        $scope.checked_key = $stateParams.checked_key;
        $scope.checked_value = $stateParams.checked_value;
        $scope.picklist_submit = function () {
            if (typeof (document.getElementById($stateParams.return_key_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_key_field_id).val($scope.checked_key);
            } else {
                $('#' + $stateParams.return_key_field_id).html($scope.checked_key);
            }


            if (typeof (document.getElementById($stateParams.return_value_field_id).value) != 'undefined') {
                $('#' + $stateParams.return_value_field_id).val($scope.checked_value);
            } else {
                $('#' + $stateParams.return_value_field_id).html($scope.checked_value);
            }

            lvCodeSettingDetailSev.setMinUnit($scope.checked_value);
            $ionicHistory.goBack();
        }

        $scope.item_clicked = function (checked_key, checked_value) {
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "none";
            $scope.checked_key = checked_key;
            $scope.checked_value = checked_value;
            document.getElementById('picklist_item_' + $scope.checked_key).style.display = "block";

            $scope.picklist_submit();
        }

    })

    .controller('atTeamRecordCtrl', function ($scope, $rootScope, atTeamRecordSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate, timeSelect, $timeout, $deptComponentSer) {




        $scope.img_team_attendance_iocation = local_resource + 'img/icon/team_attendance_iocation.png';
        $scope.img_team_attendance_wifi = local_resource + 'img/icon/team_attendance_wifi.png';

        $scope.img_circle3 = local_resource + 'img/icon/circle3.png';
        $scope.img_circle4 = local_resource + 'img/icon/circle4.png';
        $scope.img_circle5 = local_resource + 'img/icon/circle5.png';
        $scope.img_circle6 = local_resource + 'img/icon/circle6.png';
        $scope.not_data = local_resource + "img/not_data.png";
        $scope.cry = local_resource + "img/cry.png";
        $scope.img_circle_arrow_down = local_resource + 'img/icon/circle_arrow_down.png';
        $scope.img_circle_arrow_up = local_resource + 'img/icon/circle_arrow_up.png';
        $scope.img_team_attendance_fingerprint = local_resource + 'img/icon/team_attendance_fingerprint.png';
        $scope.img_normal_sign_in = local_resource + 'img/icon/sign_in_normal.png';
        $scope.img_fieldwork_sign_in = local_resource + 'img/icon/sign_in_fieldwork.png';
        $scope.img_other_sign_in = local_resource + 'img/icon/sign_in_other_types.png';
        $scope.img_at_team_record_icon = local_resource + 'img/icon/at_team_record_icon.png';
        $scope.img_contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.search_img = local_resource + 'img/search_img.png';


        $scope.at_team_record_content = function (name, employee_no) {
            $location.path('home_page/home_menulist/at_team_record_content/' + $scope.current_date_str + "/" + name + "/" + employee_no);
        }
        if (window.localStorage['_role_name'] == 'ess') {
            $scope.is_show_picklist = false;
        } else {
            $scope.is_show_picklist = true;
        }

        var today_date = new Date();
        var current_date = new Date();
        var today_date_str = (today_date.getFullYear() + '-' + (today_date.getMonth() + 1 < 10 ? '0' + (today_date.getMonth() + 1) : (today_date.getMonth() + 1)) + '-' + (today_date.getDate() < 10 ? '0' + (today_date.getDate()) : (today_date.getDate())));

        $scope.current_date_str = '';
        current_date.setFullYear(today_date_str.split('-')[0], (parseInt(today_date_str.split('-')[1], 10) - 1), today_date_str.split('-')[2]);
        $scope.current_date_str = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
        $scope.current_date_text = $scope.current_date_str.split("-")[0] + '年' + $scope.current_date_str.split("-")[1] + '月' + $scope.current_date_str.split("-")[2] + '日';
        $scope.today_date_text = $scope.current_date_str.split("-")[0] + '年' + $scope.current_date_str.split("-")[1] + '月' + $scope.current_date_str.split("-")[2] + '日';
        $scope.current_tab = '1';
        $scope.dept_id = '0';
		$scope.android_height = android_height;
        if (ionic.Platform.isIOS()) {
            $scope.content_top = '104';

        } else {
            $scope.content_top = '84';

        }


        $scope.isSelectDeptBack = false;
        $scope.selectDeptRd = [];


        /*$scope.$on("$ionicView.afterEnter", function(event, data){
		if($scope.isSelectDeptBack){
			$scope.isSelectDeptBack = false;

			if ($scope.selectDeptRd.length == 0){
					document.getElementById('at_team_record_dept_picklist').innerHTML = '请选择部门';
					$scope.dept_id = '0';
				}
				else if ($scope.selectDeptRd.length == 1){
					$timeout(function(){
						document.getElementById('at_team_record_dept_picklist').innerHTML = $scope.selectDeptRd[0].name;
						$scope.dept_id = $scope.selectDeptRd[0].id;
					},0)

				}
				else {

					document.getElementById('at_team_record_dept_picklist').innerHTML = $scope.selectDeptRd.length + '个部门(含子部门)';
					$scope.dept_id = '';
					for (var i=0;i<$scope.selectDeptRd.length;i++){
						$scope.dept_id = $scope.dept_id + $scope.selectDeptRd[i].id;
						if (i < $scope.selectDeptRd.length - 1){
							$scope.dept_id = $scope.dept_id + ',';
						}
					}



				}
				atTeamRecordSev.loadData($scope.current_date_str,$scope.dept_id);
				console.log(document.getElementById('details_div').onclick);



/*
		if (document.getElementById('details_div').onclick != null){
			console.log("have_click");
			$("#details_div").unbind("click");
			$("#statistics_div").unbind("click");
			document.getElementById('details_div').onclick = null;
			document.getElementById('statistics_div').onclick = null;
		}


		if (document.getElementById('details_div').onclick == null){
			console.log("not_cli");
			  document.getElementById('details_div').onclick=function(){
				  details_div_click();
				  $scope.current_tab = '1';
			  }
			  document.getElementById('statistics_div').onclick=function(){
				statistics_div_click();
				$scope.current_tab = '2';
			  }


		}


		if ($scope.current_tab == '2'){
		  reload_statistics_div();
		}

		}
	});
*/
        $scope.at_team_record_dept_picklist = function () {
            $deptComponentSer.open({
                title: '选择部门', //标题
                //barTitle : '施特伟科技有限公司',//导航标题
                barTitle: '组织架构',
                isSingleSelect: false, //是否单选
                isInherit: true, //是否选父带子
                selectNodeList: $scope.dept_id, //默认选中部门节点
                params: { //加载扩展参数
                    "is_permissions": "1",
                    "is_process": "0"
                },
                /*
                params:{ //加载扩展参数
                "param1":"aa",
                "param2":"bb"
                },
                */
                extName: '部门(含子部门)', //多选显示扩展后缀名
                sure: function (rd) { //确认返回接口，数组
                    $rootScope.showLoading();
                    $scope.isSelectDeptBack = true;
                    $scope.selectDeptRd = [];
                    $scope.selectDeptRd = rd;

                    /*	if (rd.length == 0){
                    		document.getElementById('at_team_record_dept_picklist').innerHTML = '请选择部门';
                    		$scope.dept_id = '0';
                    	}
                    	else if (rd.length == 1){
                    		document.getElementById('at_team_record_dept_picklist').innerHTML = rd[0].name;
                    		$scope.dept_id = rd[0].id;
                    	}
                    	else {
                    		document.getElementById('at_team_record_dept_picklist').innerHTML = rd.length + '个部门(含子部门)';
                    		$scope.dept_id = '';
                    		for (var i=0;i<rd.length;i++){
                    			$scope.dept_id = $scope.dept_id + rd[i].id;
                    			if (i < rd.length - 1){
                    				$scope.dept_id = $scope.dept_id + ',';
                    			}
                    		}
                    	}
                    	atTeamRecordSev.loadData(current_date_str,$scope.dept_id);
                    	*/

                }
            });
        };





        $scope.at_team_record_by_type_detail = function (type) {

            $location.path("home_page/home_menulist/at_team_record_by_type_detail/" + type + "/" + $scope.current_date_str + "/" + $scope.dept_id);
        }


        $scope.search = function () {
            atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);
        }


        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.is_pc_icon = local_resource + 'img/icon/is_pc_icon.png';

        $scope.select_date = function () {
            timeSelect.show({
                type: 'date',
                startDate: '2000年01月01日',
                endDate: $scope.today_date_text,
                defaultDate: $scope.current_date_text,
                returnDateType: 'ymd',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {

                    if (typeof (date) == 'undefined') {} else {
                        current_date.setFullYear(parseInt(date.slice(0, 4), 10), (parseInt(date.slice(5, 7), 10) - 1), (parseInt(date.slice(8, 10), 10)));
                        $scope.current_date_str = (current_date.getFullYear() + '-' + (current_date.getMonth() + 1 < 10 ? '0' + (current_date.getMonth() + 1) : (current_date.getMonth() + 1)) + '-' + (current_date.getDate() < 10 ? '0' + (current_date.getDate()) : (current_date.getDate())));
                        $scope.current_date_text = $scope.current_date_str.split("-")[0] + '年' + $scope.current_date_str.split("-")[1] + '月' + $scope.current_date_str.split("-")[2] + '日';
                        atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);
                    }
                }
            });
        }

        function details_div_click() {

            if (document.getElementById('details_div').style.backgroundColor == 'white') {
                return;
            }

            //		$scope.cancel_search();
            $scope.current_tab = '1';

            document.getElementById('atTeamRecordSearch').style.display = 'none';

            document.getElementById('details_div').style.color = '#53afff';
            document.getElementById('details_div').style.backgroundColor = 'white';
            document.getElementById('details_div').style.border = 'none';
            document.getElementById('statistics_div').style.color = 'white';
            document.getElementById('statistics_div').style.backgroundColor = '#53afff';
            document.getElementById('statistics_div').style.border = '1px solid white';
            document.getElementById('statistics_div').style.borderLeft = 'none';

            document.getElementById('at_team_record_wrap').style.webkitTransform = 'translateX(0)';

            for (var i = 0; i < document.getElementsByClassName('details_cls').length; i++) {
                document.getElementsByClassName('details_cls')[i].style.display = 'block';
                document.getElementsByClassName('statistics_cls')[i].style.display = 'none';
            }
            document.getElementById('details_content_div').setAttribute("style", "width:50%;padding-top:16px;");
            document.getElementById('statistics_content_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            document.getElementById('at_team_record_wrap').style.overflow = 'visible';
            $timeout(function () {
                $ionicScrollDelegate.scrollTop();
                document.getElementById('at_team_record_wrap').style.overflow = 'hidden';
            }, 100);
        }

        function statistics_div_click() {


            $scope.current_tab = '2';
            document.getElementById('atTeamRecordSearch').style.display = 'block';




            document.getElementById('statistics_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.backgroundColor = 'white';
            document.getElementById('statistics_div').style.border = 'none';
            document.getElementById('details_div').style.color = 'white';
            document.getElementById('details_div').style.backgroundColor = '#53afff';
            document.getElementById('details_div').style.border = '1px solid white';
            document.getElementById('details_div').style.borderRight = 'none';

            document.getElementById('at_team_record_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('details_content_div').setAttribute("style", "padding-top:16px;width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('statistics_content_div').setAttribute("style", "width: 50%;float: right");
            document.getElementById('at_team_record_wrap').style.overflow = 'visible';
            $timeout(function () {
                $ionicScrollDelegate.scrollTop();
                document.getElementById('at_team_record_wrap').style.overflow = 'hidden';
            }, 100);
        }

        function reload_statistics_div() {

            $scope.current_tab = '2';





            document.getElementById('statistics_div').style.color = '#53afff';
            document.getElementById('statistics_div').style.backgroundColor = 'white';
            document.getElementById('statistics_div').style.border = 'none';
            document.getElementById('details_div').style.color = 'white';
            document.getElementById('details_div').style.backgroundColor = '#53afff';
            document.getElementById('details_div').style.border = '1px solid white';
            document.getElementById('details_div').style.borderRight = 'none';

            document.getElementById('at_team_record_wrap').style.webkitTransform = 'translateX(-50%)';

            document.getElementById('details_content_div').setAttribute("style", "padding-top:10px;width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('statistics_content_div').setAttribute("style", "width: 50%;float: right");
            document.getElementById('at_team_record_wrap').style.overflow = 'visible';
            document.getElementById('at_team_record_wrap').style.overflow = 'hidden';
        }




        $scope.search_control = atTeamRecordSev.getSearchValue();
        $scope.searchState = atTeamRecordSev.getSearchState();
        $scope.searchNodata = atTeamRecordSev.getSearchNodata();
        $scope.end_of_list = atTeamRecordSev.getEndOfList();
        $scope.$on("$ionicView.enter", function () {


            if ($scope.current_tab != '2') {

                $timeout(function () {

                    document.getElementById('details_div').style.color = '#53afff';
                    document.getElementById('details_div').style.backgroundColor = 'white';
                    document.getElementById('details_div').style.border = 'none';
                    document.getElementById('statistics_div').style.color = 'white';
                    document.getElementById('statistics_div').style.backgroundColor = '#53afff';
                    document.getElementById('statistics_div').style.border = '1px solid white';
                    document.getElementById('statistics_div').style.borderLeft = 'none';
                    document.getElementById('atTeamRecordSearch').style.display = 'none';
                }, 200)



            } else {

                $timeout(function () {

                    document.getElementById('statistics_div').style.color = '#53afff';
                    document.getElementById('statistics_div').style.backgroundColor = 'white';
                    document.getElementById('statistics_div').style.border = 'none';
                    document.getElementById('details_div').style.color = 'white';
                    document.getElementById('details_div').style.backgroundColor = '#53afff';
                    document.getElementById('details_div').style.border = '1px solid white';
                    document.getElementById('details_div').style.borderRight = 'none';
                    document.getElementById('atTeamRecordSearch').style.display = 'block';

                }, 200)

            }




            //解决 进入明细页面back回来的时候 会再次loaddata
            if (typeof ($scope.data_loaded) == 'undefined') {
                $scope.data_loaded = true;
                atTeamRecordSev.clearData();
                atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);
                //$scope.at_team_record_data = atTeamRecordSev.getData();
                $scope.by_type_data = atTeamRecordSev.getByTypeData();
                $scope.by_employee_data = atTeamRecordSev.getByEmployeeData();
                $scope.end_of_list = atTeamRecordSev.getEndOfList();
                $scope.search_control = atTeamRecordSev.getSearchValue();
                //$scope.search_control=atTeamRecordSev.getSearchValue();
            }

            $timeout(function () {
                if (document.getElementById('details_div').onclick != null) {

                    $("#details_div").unbind("click");
                    $("#statistics_div").unbind("click");
                    document.getElementById('details_div').onclick = null;
                    document.getElementById('statistics_div').onclick = null;
                }


                if (document.getElementById('details_div').onclick == null) {

                    document.getElementById('details_div').onclick = function () {
                        details_div_click();
                        $scope.current_tab = '1';
                    }
                    document.getElementById('statistics_div').onclick = function () {
                        statistics_div_click();
                        $scope.current_tab = '2';
                    }


                }
            }, 200)



            /*ionic.off('click',nav_bar_tab_func,$('ion-nav-bar')[0])

            ionic.on('click',nav_bar_tab_func,$('ion-nav-bar')[0])
            */

            /*
            	if ($scope.current_tab == '2'){
            	  reload_statistics_div();
            	}
            	*/

            if ($scope.isSelectDeptBack) {
                //$scope.isSelectDeptBack = false;

                if ($scope.selectDeptRd.length == 0) {
                    document.getElementById('at_team_record_dept_picklist').innerHTML = '请选择部门';
                    $scope.dept_id = '0';
                    atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);
                } else if ($scope.selectDeptRd.length == 1) {
                    $timeout(function () {
                        document.getElementById('at_team_record_dept_picklist').innerHTML = $scope.selectDeptRd[0].name;
                        $scope.dept_id = $scope.selectDeptRd[0].id;
                        atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);
                    }, 0)

                } else {

                    document.getElementById('at_team_record_dept_picklist').innerHTML = $scope.selectDeptRd.length + '个部门(含子部门)';
                    $scope.dept_id = '';
                    for (var i = 0; i < $scope.selectDeptRd.length; i++) {
                        $scope.dept_id = $scope.dept_id + $scope.selectDeptRd[i].id;
                        if (i < $scope.selectDeptRd.length - 1) {
                            $scope.dept_id = $scope.dept_id + ',';
                        }
                    }
                    atTeamRecordSev.loadData($scope.current_date_str, $scope.dept_id);


                }

                //console.log(document.getElementById('details_div').onclick);



                /*
                		if (document.getElementById('details_div').onclick != null){
                			console.log("have_click");
                			$("#details_div").unbind("click");
                			$("#statistics_div").unbind("click");
                			document.getElementById('details_div').onclick = null;
                			document.getElementById('statistics_div').onclick = null;
                		}


                		if (document.getElementById('details_div').onclick == null){
                			console.log("not_cli");
                			  document.getElementById('details_div').onclick=function(){
                				  details_div_click();
                				  $scope.current_tab = '1';
                			  }
                			  document.getElementById('statistics_div').onclick=function(){
                				statistics_div_click();
                				$scope.current_tab = '2';
                			  }


                		}


                		if ($scope.current_tab == '2'){
                		  reload_statistics_div();
                		}
                		*/
            }




        });

        $scope.atTeamRecordBack = function () {
            $ionicHistory.goBack();
            atTeamRecordSev.clearStatusBar();
        }

        $scope.loadMoreEmployeeData = function () {
            if (document.getElementById('details_div').style.backgroundColor == 'white') {
                return;
            }
            atTeamRecordSev.loadMoreEmployeeData($scope.current_date_str, $scope.dept_id, $scope);
        }





    })


    .controller('atTeamRecordDetailCtrl', function ($scope, atTeamRecordDetailSev, $stateParams, $location, $ionicPopup, $ionicHistory, $ionicScrollDelegate, timeSelect) {
        atTeamRecordDetailSev.clearData();
        atTeamRecordDetailSev.loadData($stateParams.current_date, $stateParams.employee_no, $scope);
        $scope.atTeamRecordDetailData = atTeamRecordDetailSev.getData();
        $scope._title = $stateParams.user_name + '的考勤';
        var obj = $('#record_detail_target_date');
        obj.val($stateParams.current_date);
        document.getElementById('record_detail_target_date_').innerHTML = $stateParams.current_date;

        $scope.record_detail_target_date_ = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: document.getElementById("record_detail_target_date_").innerHTML,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        document.getElementById("record_detail_target_date_").innerHTML = date;
                        obj.val(date);
                        atTeamRecordDetailSev.loadData(obj.val(), $stateParams.employee_no);
                    }
                }
            })
        }
        obj.change(function () {
            atTeamRecordDetailSev.loadData(obj.val(), $stateParams.employee_no);
        })
        $scope.previous_day = function () {

            document.getElementById("record_detail_target_date").stepDown(7);
            document.getElementById('record_detail_target_date_').innerHTML = obj.val();
            atTeamRecordDetailSev.loadData(obj.val(), $stateParams.employee_no);
        }


        $scope.next_day = function () {
            document.getElementById("record_detail_target_date").stepUp(7);
            document.getElementById('record_detail_target_date_').innerHTML = obj.val();
            atTeamRecordDetailSev.loadData(obj.val(), $stateParams.employee_no);
        }

    })



    .controller('essMyApplyDCMCtrl', function ($scope, essMyApplyDCMSev, $ionicModal, $ionicActionSheet, $stateParams, sideSelect, timeSelect, $ionicScrollDelegate, $emplComponentService) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.is_require_upload = false;
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        essMyApplyDCMSev.clearData();
        essMyApplyDCMSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $scope);
        $scope.lv_app_data = essMyApplyDCMSev.getData();
        $scope.imagesObj = essMyApplyDCMSev.getImageData();



        $scope.essLvPolicy = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.lv_app_data.essLvPolicy_data,
                selectIndex: $scope.lv_app_data.essLvPolicy_data_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("essLvPolicy").innerHTML = $scope.lv_app_data.essLvPolicy_data[index].value;
                        $scope.lv_app_data.essLvPolicy_data_key = $scope.lv_app_data.essLvPolicy_data[index].key;
                        $scope.lv_app_data.essLvPolicy_data_index = index;
                        $scope.lv_app_data.default_lv_code_id = $scope.lv_app_data.essLvPolicy_data_key;
                        essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }

                }
            });
        }

        $scope.showDate_start_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.lv_app_data.start_date,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.lv_app_data.start_date = date;
                        essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }
        $scope.showDate_start_time = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.lv_app_data.start_time,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.lv_app_data.start_time = date;
                        essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }


        $scope.showDate_end_date = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'date',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.lv_app_data.end_date,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.lv_app_data.end_date = date;
                        essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }

        $scope.showDate_end_time = function () {
            var current_date = new Date();
            current_date.setMinutes(current_date.getMinutes() - current_date.getTimezoneOffset());
            current_date = current_date.toJSON().slice(0, 4);
            var startDate = parseInt(current_date, 10) - 10;
            startDate = startDate + '-01-01';
            var endDate = parseInt(current_date, 10) + 10;
            endDate = endDate + '-12-31';
            timeSelect.show({
                type: 'time',
                startDate: '1900-01-01',
                endDate: '2099-12-31',
                defaultDate: $scope.lv_app_data.end_time,
                returnDateType: 'y-m-d',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.lv_app_data.end_time = date;
                        essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
                    }
                }
            })
        }


        $scope.upload_photo = function () {

            // Show the action sheet
            var hideSheet = $ionicActionSheet.show({
                buttons: [

                    {
                        text: '拍照'
                    }, {
                        text: '从手机相册选择'
                    }
                ],

                //titleText: 'Modify your album',
                titleText: '选择上传图片方式',
                cancelText: '取消',
                cancel: function () {
                    // add cancel code..
                },
                buttonClicked: function (index) {

                    if (index == 0) {
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";
									}, function () {
										//alert('cancel or failure');
									}, {
										allowEdit: true,
										destinationType: Camera.DestinationType.FILE_URI,
										quality: 10,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						}
						else{
							
							try{
								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : false};
								Picture.takePhoto(opt, function(data){
									
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", data.uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";

									
								});
							} catch(e){
								
							}
							
						}

                        return true;
                    } else if (index == 1) {
						
						if(ionic.Platform.isIOS()){
								try {
									navigator.camera.getPicture(function (uri) {
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";

									}, function (message) {}, {
										quality: 100,
										destinationType: Camera.DestinationType.FILE_URI,
										// In this app, dynamically set the picture source, Camera or photo gallery
										sourceType: Camera.PictureSourceType.SAVEDPHOTOALBUM,
										encodingType: Camera.EncodingType.JPEG,
										mediaType: Camera.MediaType.PICTURE,
										//allowEdit: true,
										targetHeight: 500,
										targetWidth: 500,
										correctOrientation: true
									});
								} catch (e) {
									//alert(e.message);
								}
						
						}
						else{
							
							try{

								var opt = {'targetHeight' : 500, 'targetWidth' : 500, 'allowEdit' : true};
								Picture.chooseOnePicture(opt, function(data){
										$scope.is_require_upload = true;
										document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
										$('#ess_leave_apply_upload_mini_photo').attr("src", data.uri);
										document.getElementById('ess_leave_apply_upload_text').innerText = '更改图片';
										$('#ess_leave_apply_upload_icon1').attr("src", local_resource + 'img/icon/upload_modify.png');
										document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
										document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";

								});
							} catch(e){
								
							}	
							
						}
						


                        return true;
                    }

                    return true;


                }
            });

            // For example's sake, hide the sheet after two seconds
            /*
             $timeout(function() {
             hideSheet();
             }, 2000);
             */


        }

        $scope.changeEssLvPolicy = function () {
            essMyApplyDCMSev.changeEssLvPolicy($scope, $scope.lv_app_data.default_lv_code_id);
        }

        $scope.saveApply = function () {
            var num_of_upload = 0;
            var updated_o_attachment = '';
            var updated_o_attachment_array = [];
            var lv_app_data_attachment_array = $scope.lv_app_data.attachment.split(',');
            var lv_app_data_o_attachment_array = $scope.lv_app_data.o_attachment.split(',');
            var imagesObj_data_array = $scope.imagesObj.data.split(',');

            if ($scope.imagesObj.data != '') {
                for (var i = 0; i < imagesObj_data_array.length; i++) {
                    if ($scope.lv_app_data.attachment.indexOf(imagesObj_data_array[i]) == -1) {
                        num_of_upload++;
                    }
                }
            }

            if ($scope.lv_app_data.o_attachment != '') {
                for (var i = 0; i < lv_app_data_o_attachment_array.length; i++) {
                    if ($scope.imagesObj.data.indexOf(lv_app_data_o_attachment_array[i]) != -1) {
                        updated_o_attachment_array.push(lv_app_data_o_attachment_array[i]);
                    }
                }
            }

            updated_o_attachment = updated_o_attachment_array.join(',');


            if (num_of_upload > 0) {
                essMyApplyDCMSev.saveApplyWithPhoto($scope.select_user_id, $scope.select_notify_id, num_of_upload, updated_o_attachment);
            } else {
                essMyApplyDCMSev.saveApply($scope.select_user_id, $scope.select_notify_id, updated_o_attachment);
            }

        }
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        //$scope.select_user_id = '';
        //$scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.lv_app_data.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.closeModal();
            $scope.approver_list = _d;
            $scope.search_control.search_val = '';
        }

        $scope.delete_notify = function (user_id) {
            $('#essMyApplyDCM #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.lv_app_data.notify_list.length; i++) {
                if ($scope.lv_app_data.notify_list[i].user_id == user_id) {
                    $scope.lv_app_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }
        $scope.delete_approver = function (user_id) {
            if (!$scope.lv_app_data.approver_list_flag) {
                return;
            }
            $('#essMyApplyDCM #approver_list_div').addClass('approver_list_active');
            $scope.approver_list = [];
            $scope.select_user_id = ''
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.lv_app_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.lv_app_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            $scope.search_control.search_val = '';
            $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.openModal = function () {

            var selectEmplList = '';
            if ($scope.lv_app_data.approver_list.length != 0) {
                selectEmplList = $scope.lv_app_data.approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表

                sure: function (rd) { //返回数据，数组格式

                    $('#approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.lv_app_data.approver_list = [];
                    $scope.lv_app_data.approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    $scope.approver_list = $scope.lv_app_data.approver_list;
                }
            });

        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.lv_app_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.lv_app_data.notify_list.length; i++) {
                    selectEmplList += $scope.lv_app_data.notify_list[i].employee_no;
                    if (i < $scope.lv_app_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表

                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.lv_app_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.lv_app_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }

        /*
            $scope.openModal = function() {
              $('#approver_list_div').removeClass('approver_list_active');
              $scope.search_val = '';
              $scope.click_flag = 0;
              $scope.ess_empl_data = [];
              essMyApplyDCMSev.loadEssEmplData($scope.select_user_id,$scope.lv_app_data.employee_no,$scope.lv_app_data.process_instance);
              $scope.ess_empl_data = essMyApplyDCMSev.getEssEmplData();
              $scope.modal.show();
            };
            $scope.openModal2 = function() {
              $('#notify_list_div').removeClass('notify_list_active');
              $scope.search_val = '';
              $scope.click_flag = 1;
              $scope.ess_empl_data = [];
              essMyApplyDCMSev.loadEssEmplData($scope.select_notify_id,$scope.lv_app_data.employee_no,$scope.lv_app_data.process_instance);
              $scope.ess_empl_data = essMyApplyDCMSev.getEssEmplData();
              $scope.modal.show();
            };
        */
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
    })

    .controller('essMyApprovalCtrl', function ($scope, essMyApprovalSev, $ionicPopover, $location) {
        /*Sunny改*/
        $scope.ss_not_completed = local_resource + 'img/icon/ess_not_completed@2x.png';
        $scope.ess_has_been_completed = local_resource + 'img/icon/ess_has_been_completed@2x.png';
        $scope.ess_unhide_all = local_resource + 'img/icon/ess_unhide_all@2x.png';
        /*Sunny改*/
        $scope.apply_leave_icon = local_resource + 'img/icon/apply_leave_icon.png';
        $scope.apply_overtime_icon = local_resource + 'img/icon/apply_overtime_iocn.png';
        $scope.apply_field_icon = local_resource + 'img/icon/apply_field_icon.png';
        essMyApprovalSev.clearData();
        essMyApprovalSev.loadData();
        //$scope.search_val = "";
        $scope.my_apply_icon = local_resource + 'img/menus/';
        $scope.ess_my_approval_data = essMyApprovalSev.getData();
        $scope.loadMyApply = function (name, type) {
            if (type == "leave") {
                $location.path("home_page/ess_my_approval_details/" + name + "/" + type);
            } else if (type == "fieldwork") {
                $location.path("home_page/ess_my_approval_details_fieldwork/" + name + "/" + type);
            } else if (type == "overtime") {
                $location.path("home_page/ess_my_approval_details_overtime/" + name + "/" + type);
            } else if (type == 'fieldwork_bill') {
                $location.path("home_page/ess_my_approval_details_out/" + name + "/" + type);
            } else if (type == 'offic_work_out') {
                $location.path("home_page/ess_my_approval_details_offic_work_out/" + name + "/" + type);
            } else if (type == 'at_daily_adj') {
                $location.path("home_page/ess_my_approval_details_card_adj/" + name + "/" + type);
            } else if (type == 'at_daily_adj') {
                $location.path("home_page/ess_my_approval_details_card_adj/" + name + "/" + type);
            } else if (type == 'business_trip') {
                $location.path("home_page/business_trip_approve_new/" + name + "/" + type);
            }
        }
    })


    .controller('essMyApprovalDCtrl', function ($scope,$rootScope, essMyApprovalDSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $timeout, $ionicHistory) {
        $scope.vip_modal_img = local_resource + 'img/icon/vip_modal_img.png';
        $scope.diamond_icon = local_resource + 'img/icon/diamond_icon.png';
        $scope.is_vip = getLocalStorageVar("is_vip");
        $scope.modal_show = false;
        $scope.modalHidden = function(){
        $scope.modal_show = false;
        }

        $scope.navigateToPage = function(){
            if($scope.is_vip == 'true'){
                $location.path("home_page/leave_batch_approval/" + $stateParams.name + "/" + $stateParams.type);
            }else{
                $scope.modal_show = true;
            }
        }
        //解决批量审批页面返回后不刷新页面的问题
        $scope.$on('$ionicView.beforeEnter',function(){
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
            essMyApprovalDSev.loadData($stateParams.type, 'UC');
            $scope.showOrHideBtnWrapper();
        });
        
        if (ionic.Platform.isIOS()) {
            essMyApprovalDSev.clearData();
            essMyApprovalDSev.loadData($stateParams.type, 'UC');
            $scope.ess_my_approvalD_data = essMyApprovalDSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyApprovalDSev.clearData();
                essMyApprovalDSev.loadData($stateParams.type, 'UC');
                $scope.ess_my_approvalD_data = essMyApprovalDSev.getData();
            });
        }

        // 动态显示批量审批按钮
        $scope.showOrHideBtnWrapper = function(){
            var timer = setTimeout(function(){
                if($scope.ess_my_approvalD_data && $scope.ess_my_approvalD_data.data1.length){
                    document.getElementById('contentWrapper').style.marginBottom = '45px';
                    document.getElementById('btnWrapper').style.display = "flex";
                }else{
                    document.getElementById('contentWrapper').style.marginBottom = '0';
                    document.getElementById('btnWrapper').style.display = "none";
                }
                clearTimeout(timer);
            },1200);
        }

        $scope.showOrHideBtnWrapper();
        
        
        //    $scope.$on("$ionicView.enter", function () {
        ////解决 进入明细页面back回来的时候 会再次loaddata
        //      if (typeof($scope.data_loaded) != 'undefined'){
        //        return;
        //      }
        //      else {
        //        $scope.data_loaded = true;
        //      }
        //      essMyApprovalDSev.clearData();
        //      essMyApprovalDSev.loadData($stateParams.type,'UC');
        //      $scope.ess_my_approvalD_data = essMyApprovalDSev.getData();
        //    });
        $scope.search_control = essMyApprovalDSev.getSearchValue();
        //$scope.search_control.search_val = "";
        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }
        $scope.ess_my_approval_details_title = $stateParams.name + "审批";
        // essMyApprovalDSev.clearData();
        //essMyApprovalDSev.loadData($stateParams.type,'UC');
        ////essMyApprovalDSev.loadOtherData($stateParams.type,'C');
        //$scope.ess_my_approvalD_data = essMyApprovalDSev.getData();
        //$scope.ess_my_approvalD_other_data = essMyApprovalDSev.getOtherData();
        $scope._flag = '待处理';
        $scope.noapprove_click = function () {
            $scope._flag = '待处理';
            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";

                $scope.showOrHideBtnWrapper();
            }, 200);



        }
        $scope.approved_click = function () {
            $scope._flag = '已处理';
            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";

                document.getElementById('contentWrapper').style.marginBottom = '0';
                document.getElementById('btnWrapper').style.display = "none";
            }, 200);


        }


        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, my_app_result, is_normal_path) {
            //if(my_app_result=="待处理"){
            //  my_app_result="UC";
            //}
            //else{
            //  my_app_result="C";
            //}
            $location.path("home_page/ess_my_approval_details_content/" + p_inst + "/" + show_type + "/" + task_id + "/" + my_app_result + "/" + is_normal_path + "/my_approval");
        }

    })

    .controller('essMyApprovalDetailsContentCtrl', function ($emplComponentService, $scope, essMyApprovalDetailsContentSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $timeout, $ionicPopup, sideSelect, $ionicScrollDelegate, zoomSlider) {
        if ($stateParams.my_app_result == 'c') {
            $scope.app_result = false;
        } else {
            $scope.app_result = true;
        }

        $scope.fireEvent = function (i, arr) {
            $timeout(function () {
                if (i == arr.length - 1 && $scope.ess_my_approvalDC_data.approver_list_flag == false) {
                    document.getElementById("approver_list_img_" + i).style.display = "none";
                }
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 16) + 'px';
                }
            }, 0);
        }

        $scope.view_team_at_exception = function (start_date) {
            fufuMobclickAgent('click_leave_clash_report');
            if ($stateParams.is_normal_path == 'true') {
                $location.path("home_page/home_menulist/team_at_exception/" + start_date + "/" + $stateParams.is_normal_path);
            } else {
                $location.path("home_page/home_menulist/team_at_exception_msg/" + start_date + "/" + $stateParams.is_normal_path);
            }

        }



        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.approve_icon = local_resource + 'img/icon/approve_icon.png';
        $scope.read_leave_icon = local_resource + 'img/icon/read_leave_icon.png';
        $scope.notify = local_resource + 'img/icon/notify.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        $scope.is_expand = true;
        $scope.notify_toggle = function () {
            $scope.is_expand = !$scope.is_expand;
        }
        essMyApprovalDetailsContentSev.clearData();
        essMyApprovalDetailsContentSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $stateParams.my_app_result, $scope);
        $scope.ess_my_approvalDC_data = essMyApprovalDetailsContentSev.getData();

        $scope.show_img = function (index) {
            zoomSlider.show({
                data: $scope.ess_my_approvalDC_data.attachment_array,
                index: index
            })
            return;
            /*
      if (ionic.Platform.isIOS()) {
        window.open(url, '_system', 'enableViewportScale=yes');
      } else {
        window.open(url, '_system');
      }
	  	*/
        }


        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;

        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_approvalDC_data.approver_list;
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                        flag = 1;
                        break;
                    }
                }

                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        action: '下一层审批人',
                        flag: 1,
                        _flag: 1,
                        attachment: '',
                        approval_remark: '',
                        color: "#999"
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        action: '下一层审批人',
                        flag: 1,
                        user_id: user_id,
                        _flag: 1,
                        attachment: '',
                        approval_remark: '',
                        color: "#999"
                    }
                }

                $scope.closeModal();
            } else {
                var _d = [];
                if ($scope.click_flag == 0) {
                    $scope.select_user_id = user_id;
                    _d = $scope.ess_my_approvalDC_data.approver_list;
                } else {
                    return;
                }
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                        flag = 1;
                        break;
                    }
                }
                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    }
                }
                $scope.approver_list = _d;
                $scope.search_control.search_val = '';
                $scope.closeModal();
            }
        }
        $scope.delete_notify = function (user_id) {
            $('#essMyApprovalDetailsContent #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                if ($scope.ess_my_approvalDC_data.notify_list[i].user_id == user_id) {
                    $scope.ess_my_approvalDC_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)

        }
        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_approvalDC_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
            //alert($scope.lv_app_data.notify_list.length);
            $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            $scope.search_control.search_val = '';
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        /*
            $scope.openModal = function() {

              $scope.search_val = '';
              $scope.click_flag = 0;
              $scope.ess_empl_data = [];
              essMyApprovalDetailsContentSev.loadEssEmplData($scope.select_user_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
              $scope.ess_empl_data = essMyApprovalDetailsContentSev.getEssEmplData();
              $scope.modal.show();
            };


            $scope.openModal2 = function() {
              $('#essMyApprovalDetailsContent #notify_list_div').removeClass('notify_list_active');
              $scope.search_val = '';
              $scope.click_flag = 1;
              $scope.ess_empl_data = [];
              essMyApprovalDetailsContentSev.loadEssEmplData($scope.select_notify_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
              $scope.ess_empl_data = essMyApprovalDetailsContentSev.getEssEmplData();

              $scope.modal.show();
            };
        	*/

        var routerName = '';
        if (typeof ($stateParams.from_source) != 'undefined') {
            if ($stateParams.from_source == 'at_team_record') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'my_approval') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'home_message') {
                routerName = 'message';
            } else if ($stateParams.from_source == 'at_team_record') {
                routerName = 'default';
            }
        }

        $scope.openModal = function () {

            var _d = [];
            _d = $scope.ess_my_approvalDC_data.approver_list;
            var flag = 0;
            var _len = _d.length;

            var flag = 0;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                    flag = 1;
                    break;
                }
            }

            var selectEmplList = '';
            if (flag == 1) {
                selectEmplList = _d[_len - 1].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                sure: function (rd) { //返回数据，数组格式
                    $scope.select_user_id = rd[0].user_id;

                    if (flag == 0) {
                        _d.push({
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            user_id: rd[0].user_id,
                            action: '下一层审批人',
                            flag: 1,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        })
                    } else {
                        _d[_len - 1] = {
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            action: '下一层审批人',
                            flag: 1,
                            user_id: rd[0].user_id,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        }
                    }

                }
            });


        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.ess_my_approvalDC_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                    selectEmplList += $scope.ess_my_approvalDC_data.notify_list[i].employee_no;
                    if (i < $scope.ess_my_approvalDC_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.ess_my_approvalDC_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }

        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });


        $scope.submitAction = function (action) {
            essMyApprovalDetailsContentSev.submitAction(action);
        }
        $scope.approval_date = [{
            key: '0',
            value: '批准'
        }, {
            key: '1',
            value: '驳回'
        }]
        $scope.remark_flag = true;
        $scope.approval_index = 0;
        $scope.approval_or_noapproval = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.approval_date,
                selectIndex: $scope.approval_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("approval_answer").innerHTML = $scope.approval_date[index].value;
                        index == '0' ? $scope.remark_flag = true : $scope.remark_flag = false;
                        $scope.approval_index = index;
                    }

                }
            });
        }

        $scope.save = function () {
            if ($scope.remark_flag == false && document.getElementById('leave_approval_remark_textarea').value == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">请填写备注</div>',
                    okText: '确定'
                })
            } else {
                if ($scope.remark_flag) {
                    essMyApprovalDetailsContentSev.applyApprove($scope.select_user_id, $stateParams.my_app_result, $scope.select_notify_id, $stateParams.from_source);
                } else {
                    essMyApprovalDetailsContentSev.applyReject($scope.select_user_id, $stateParams.my_app_result, $scope.select_notify_id, $stateParams.from_source);
                }
            }
        }





    })

    .controller('essMyApprovalDFCtrl', function ($scope, essMyApprovalDFSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $ionicHistory, $timeout) {
        $scope.vip_modal_img = local_resource + 'img/icon/vip_modal_img.png';
        $scope.diamond_icon = local_resource + 'img/icon/diamond_icon.png';
        $scope.is_vip = getLocalStorageVar("is_vip");
        $scope.modal_show = false;
        $scope.modalHidden = function(){
        $scope.modal_show = false;
        }

        $scope.navigateToPage = function(){
        if($scope.is_vip == 'true'){
            $location.path("home_page/fieldwork_batch_approval/" + $stateParams.name + "/" + $stateParams.type);
        }else{
            $scope.modal_show = true;
        }
        }

        //解决批量审批页面返回后不刷新页面的问题
        $scope.$on('$ionicView.beforeEnter',function(){
            essMyApprovalDFSev.loadData($stateParams.type, 'UC');
            $scope.showOrHideBtnWrapper();
        });

        if (ionic.Platform.isIOS()) {
            essMyApprovalDFSev.clearData();
            essMyApprovalDFSev.loadData($stateParams.type, "UC");
            $scope.ess_my_approvalD_data = essMyApprovalDFSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyApprovalDFSev.clearData();
                essMyApprovalDFSev.loadData($stateParams.type, "UC");
                $scope.ess_my_approvalD_data = essMyApprovalDFSev.getData();
            });
        }

        // 动态显示批量审批按钮
        $scope.showOrHideBtnWrapper = function(){
            var timer = setTimeout(function(){
                if($scope.ess_my_approvalD_data && $scope.ess_my_approvalD_data.data1.length){
                    document.getElementById('contentWrapper').style.marginBottom = '45px';
                    document.getElementById('btnWrapper').style.display = "flex";
                }else{
                    document.getElementById('contentWrapper').style.marginBottom = '0';
                    document.getElementById('btnWrapper').style.display = "none";
                }
                clearTimeout(timer);
            },1200);
        }

        $scope.showOrHideBtnWrapper();

        //$scope.$on("$ionicView.enter", function () {
        //  //解决 进入明细页面back回来的时候 会再次loaddata
        //  if (typeof($scope.data_loaded) != 'undefined'){
        //    return;
        //  }
        //  else {
        //    $scope.data_loaded = true;
        //  }
        //  essMyApprovalDFSev.clearData();
        //  essMyApprovalDFSev.loadData($stateParams.type,"UC");
        //  $scope.ess_my_approvalD_data = essMyApprovalDFSev.getData();
        //});
        $scope.search_control = essMyApprovalDFSev.getSearchValue();
        //$scope.search_control.search_val = "";
        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }
        $scope.address_icon = local_resource + 'img/icon/address_icon.png';
        $scope.ess_my_approval_details_title = $stateParams.name + "审批";
        // essMyApprovalDFSev.clearData();
        //essMyApprovalDFSev.loadData($stateParams.type,"UC");
        //essMyApprovalDFSev.loadOtherData($stateParams.type,"C");
        //$scope.ess_my_approvalD_data = essMyApprovalDFSev.getData();
        //$scope.ess_my_approvalD_other_data = essMyApprovalDFSev.getOtherData();
        $scope._flag = "待处理";
        $scope.noapprove_click = function () {
            $scope._flag = "待处理";
            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            //essMyApprovalDFSev.loadData($stateParams.type,"UC");
            //setTimeout(function(){ $ionicScrollDelegate.resize(); }, 200);
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";

                $scope.showOrHideBtnWrapper();
            }, 200);



        }
        $scope.approved_click = function () {
            $scope._flag = "已处理";
            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            //essMyApprovalDFSev.loadData($stateParams.type,"C");
            //setTimeout(function(){ $ionicScrollDelegate.resize(); }, 200);
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";

                document.getElementById('contentWrapper').style.marginBottom = '0';
                document.getElementById('btnWrapper').style.display = "none";
            }, 200);


        }
        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, my_app_result, is_normal_path) {
            if (my_app_result == "待处理") {
                my_app_result = "UC";
            } else {
                my_app_result = "C";
            }

            $location.path("home_page/ess_my_approval_details_content_fieldwork/" + p_inst + "/" + show_type + "/" + task_id + "/" + my_app_result + "/" + is_normal_path + "/my_approval");
        }

    })



    .controller('atSignInOutDoorModifyCtrl', function (atSignInOutDoorModifySev, $scope, atSignInOutDoorSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location) {
        atSignInOutDoorModifySev.clearData();
        atSignInOutDoorModifySev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $scope);
        $scope.ess_my_applyDC_Fieldwork_data = atSignInOutDoorModifySev.getData();
        atSignInOutDoorSev.loadData();
        $scope.atSignInOutDoorData = atSignInOutDoorSev.getData();
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        var current_address = '';
        var current_latitude = '';
        var current_longitude = '';
        $scope.is_require_upload = '0';
        $scope.field_attendance = local_resource + 'img/icon/field_attendance.png';
        $scope.Sign_photos = local_resource + 'img/icon/Sign_photos.png';

        var location_obj = {
            'latitude': '',
            'longitude': '',
            'address': '',
            'city': ''
        };

        $scope.getAddress = function ($scope) {
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.showMap(function (msg) {
                                try {
                                    if (msg.address == "" || msg.address == null || msg.address == '(null)') {} else {

                                        location_obj = {
                                            'latitude': msg.latitude,
                                            'longitude': msg.longitude,
                                            'address': msg.address,
                                            'city': msg.detailAddress
                                        };

                                        current_address = msg.address;
                                        document.getElementById("address_now").innerText = current_address;
                                        current_latitude = msg.latitude;
                                        current_longitude = msg.longitude;
                                        $("#current_latitude_hidden").val(current_latitude);
                                        $("#current_longitude_hidden").val(current_longitude);
                                        document.getElementById("message_city").value = msg.city;
                                    }
                                } catch (e) {

                                }


                            }, location_obj);
                        }
                    }
                );
            } catch (e) {
                console.log(e.message);
                alert(e.message);
            }
        }

        $scope.sign_in = function () {
            if ($scope.is_require_upload == '0') {
                atSignInOutDoorModifySev.signInOutDoorSave($scope, 'modify', $scope.ess_my_applyDC_Fieldwork_data.o_photo, $("#current_latitude_hidden").val(), $("#current_longitude_hidden").val(), $scope.select_user_id, $scope.ess_my_applyDC_Fieldwork_data.process_instance, $scope.ess_my_applyDC_Fieldwork_data.task_id);
            } else {
                atSignInOutDoorModifySev.signInOutDoorSaveWithUpload($scope, 'modify', $scope.ess_my_applyDC_Fieldwork_data.o_photo, $("#current_latitude_hidden").val(), $("#current_longitude_hidden").val(), $scope.select_user_id, $scope.ess_my_applyDC_Fieldwork_data.process_instance, $scope.ess_my_applyDC_Fieldwork_data.task_id);
            }
        }

        $scope.sign_change_photos = function () {
            try {
                navigator.camera.getPicture(function (uri) {
                    $('#Sign_photos').attr("src", uri);
                    $scope.is_require_upload = '1';
                }, function () {
                    //alert('cancel or failure');
                }, {
                    destinationType: Camera.DestinationType.FILE_URI,
                    quality: 10,
                    targetHeight: 500,
                    targetWidth: 500,
                    correctOrientation: true
                });
            } catch (e) {
                //alert(e.message);
            }
        }
        $scope.search_val = '';
        $scope.ess_empl_data = [];
        // $scope.select_user_id = '';
        //$scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_applyDC_Fieldwork_data.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.closeModal();
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.lv_app_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_applyDC_Fieldwork_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.click_flag = 0;
            $scope.ess_empl_data = [];
            atSignInOutDoorModifySev.loadEssEmplData($scope.select_user_id, $scope.ess_my_applyDC_Fieldwork_data.employee_no, $scope.ess_my_applyDC_Fieldwork_data.process_instance);
            $scope.ess_empl_data = atSignInOutDoorModifySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });

        $scope.picklist_sign_in_reason = function () {
            var picklist_key_list = "";
            var picklist_value_list = "";
            var checked_key = $('#sign_in_reason_key').val();
            var checked_value = $('#sign_in_reason').val();
            var picklist_title = '签到原因';
            var return_key_field_id = 'sign_in_reason_key';
            var return_value_field_id = 'sign_in_reason';
            var hidden_fields = 'new_contract_end_date_editable_div';

            picklist_key_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';
            picklist_value_list = '拜访客户,会议,发布会,培训,巡查,采购,公务办理,其他';

            $location.path('home_page/home_menulist/modify_picklist_sign_in_reason/' + picklist_key_list + '/' + picklist_value_list + '/' + checked_key + '/' + checked_value + '/' + picklist_title + '/' + return_key_field_id + '/' + return_value_field_id + '/' + hidden_fields);
        }

    })

    .controller('essMyApprovalDFCCtrl', function ($emplComponentService, $scope, essMyApprovalDFCSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $timeout, $ionicPopup, sideSelect, $ionicScrollDelegate, zoomSlider) {

        $scope.approval_content_fieldwork_title = '上报位置单审批';

        $scope.fireEvent = function (i, arr, flag) {
            $timeout(function () {
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 16) + 'px';
                }

                if (i == arr.length - 1 && flag == false) {
                    document.getElementById("approver_list_img_" + i).style.display = "none";
                }
            }, 0);
        }
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.approve_icon = local_resource + 'img/icon/approve_icon.png';
        $scope.map_icon = local_resource + 'img/icon/map_icon.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        $scope.notify = local_resource + 'img/icon/notify.png';
        essMyApprovalDFCSev.clearData();
        essMyApprovalDFCSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $stateParams.my_app_result, $scope);
        if ($stateParams.my_app_result == 'C') {
            $scope.app_result = false;
        } else {
            $scope.app_result = true;
        }

        $scope.my_approval_show_map = function (longitude, latitude, location) {
            try {
                getLocation.checkCanLocation(
                    function (result) {
                        if (result == 1) {
                            getLocation.showMapWithCoordinate({
                                latitude: latitude,
                                longitude: longitude,
                                address: location
                            });
                        }
                    }
                );
            } catch (e) {
                console.log(e.message);
            }
        }
        $scope.show_img = function (url) {
            var temp_array = [];
            temp_array.push(url);
            zoomSlider.show({
                data: temp_array,
                index: 0
            });
            /*
      if (ionic.Platform.isIOS()) {
        window.open(url, '_system', 'enableViewportScale=yes');
      } else {
        window.open(url, '_system');
      }
	  */
        }
        $scope.ess_my_approvalDC_data = essMyApprovalDFCSev.getData();
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        //$scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;

        $scope.delete_notify = function (user_id) {
            $('#essMyApprovalDFC #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                if ($scope.ess_my_approvalDC_data.notify_list[i].user_id == user_id) {
                    $scope.ess_my_approvalDC_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }


        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_approvalDC_data.approver_list;
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                        flag = 1;
                        break;
                    }
                }
                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        color: "#999",
                        action: '下一层审批人',
                        flag: 1,
                        _flag: 1,
                        attachment: '',
                        approval_remark: ''
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        color: "#999",
                        action: '下一层审批人',
                        flag: 1,
                        user_id: user_id,
                        _flag: 1,
                        attachment: '',
                        approval_remark: ''
                    }
                }
                $scope.approver_list = _d;
            } else {
                var _d = [];
                if ($scope.click_flag == 0) {
                    $scope.select_user_id = user_id;
                    _d = $scope.ess_my_approvalDC_data.approver_list;
                } else {
                    return;
                }
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                        flag = 1;
                        break;
                    }
                }
                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    }
                }

            }
            $scope.search_control.search_val = '';
            $scope.closeModal();
        }




        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_approvalDC_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                $scope.closeModal();
            }

        }

        $scope.select_user_id = '';
        $ionicModal.fromTemplateUrl('ess-my-apply-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        /*
    $scope.openModal = function() {
      $scope.search_val = '';
      $scope.click_flag = 0;
      $scope.ess_empl_data = [];
      essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
      $scope.ess_empl_data = essLvApplySev.getEssEmplData();
      $scope.modal.show();
    };
    $scope.openModal2 = function() {
      $('#essMyApprovalDFC #notify_list_div').removeClass('notify_list_active');
      $scope.search_val = '';
      $scope.click_flag = 1;
      $scope.ess_empl_data = [];
      essLvApplySev.loadEssEmplData($scope.select_notify_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
      $scope.ess_empl_data = essLvApplySev.getEssEmplData();

      $scope.modal.show();
    };
	*/

        var routerName = '';
        if (typeof ($stateParams.from_source) != 'undefined') {
            if ($stateParams.from_source == 'at_team_record') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'my_approval') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'home_message') {
                routerName = 'message';
            } else if ($stateParams.from_source == 'at_team_record') {
                routerName = 'default';
            }
        }

        $scope.openModal = function () {

            var _d = [];
            _d = $scope.ess_my_approvalDC_data.approver_list;
            var flag = 0;
            var _len = _d.length;

            var flag = 0;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                    flag = 1;
                    break;
                }
            }

            var selectEmplList = '';
            if (flag == 1) {
                selectEmplList = _d[_len - 1].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                sure: function (rd) { //返回数据，数组格式
                    $scope.select_user_id = rd[0].user_id;

                    if (flag == 0) {
                        _d.push({
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            user_id: rd[0].user_id,
                            action: '下一层审批人',
                            flag: 1,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        })
                    } else {
                        _d[_len - 1] = {
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            action: '下一层审批人',
                            flag: 1,
                            user_id: rd[0].user_id,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        }
                    }

                }
            });


        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.ess_my_approvalDC_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                    selectEmplList += $scope.ess_my_approvalDC_data.notify_list[i].employee_no;
                    if (i < $scope.ess_my_approvalDC_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.ess_my_approvalDC_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }

        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        //$scope.$on('$destroy', function() {
        //  $scope.modal.remove();
        //});
        //$scope.essItemCk = function(user_id,img,en){
        //  var _d = [];
        //  $scope.select_user_id = user_id;
        //  _d = $scope.ess_my_approvalDC_data.approver_list;
        //  var flag = 0;
        //  var _len = _d.length;
        //  for(var i=0;i<_len;i++){
        //    if(angular.isDefined(_d[i]._flag)&&_d[i]._flag==1){
        //      flag = 1;
        //      break;
        //    }
        //  }
        //  if(flag == 0){
        //    _d.push({
        //      img:img,
        //      name:en,
        //      user_id:user_id,
        //      color:"#999",
        //      action:'下一层审批人',
        //      flag:1,
        //      _flag:1,
        //      attachment:'',
        //      approval_remark:''
        //    })
        //  }else{
        //    _d[_len-1] = {
        //      img:img,
        //      name:en,
        //      color:"#999",
        //      action:'下一层审批人',
        //      flag:1,
        //      user_id:user_id,
        //      _flag:1,
        //      attachment:'',
        //      approval_remark:''
        //    }
        //  }
        //  $scope.closeModal();
        //}

        //$scope.applyReject = function(){
        //  essLvApDetailSev.applyReject($scope.select_user_id);
        //}
        //$scope.applyApprove = function(){
        //  essLvApDetailSev.applyApprove($scope.select_user_id);
        //}


        $scope.submitAction = function (action) {
            essMyApprovalDFCSev.submitAction(action);
        }

        $scope.approval_date = [{
            "key": "0",
            "value": "批准"
        }, {
            "key": "1",
            "value": "驳回"
        }]
        $scope.remark_flag = true;
        $scope.approval_index = 0;
        $scope.approval_or_noapproval = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.approval_date,
                selectIndex: $scope.approval_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("approval_answer").innerHTML = $scope.approval_date[index].value;
                        index == '0' ? $scope.remark_flag = true : $scope.remark_flag = false;
                        $scope.approval_index = index;
                    }

                }
            });
        }

        $scope.save = function () {
            if ($scope.remark_flag == false && document.getElementById('remark_textarea').value == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">请填写备注</div>',
                    okText: '确定'
                })
            } else {
                if ($scope.remark_flag) {
                    essMyApprovalDFCSev.applyApprove($scope.select_user_id, $scope.select_notify_id, $stateParams.from_source);
                } else {
                    essMyApprovalDFCSev.applyReject($scope.select_user_id, $scope.select_notify_id, $stateParams.from_source);
                }
            }
        }
    })

    .controller('essOtApplyCtrl', function ($scope,$rootScope, essOtApplySev, $ionicModal, $ionicActionSheet, $location, essLvApplySev, timeSelect, sideSelect, $stateParams, $ionicScrollDelegate, $emplComponentService) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.start_ot_icon = local_resource + 'img/icon/start_ot_icon.png';
        $scope.end_ot_icon = local_resource + 'img/icon/end_ot_icon.png';
        $scope.start_rest_icon = local_resource + 'img/icon/start_rest_icon.png';
        $scope.end_rest_icon = local_resource + 'img/icon/end_rest_icon.png';
        $scope.ot_hours_icon = local_resource + 'img/icon/ot_hours_icon.png';
        essOtApplySev.clearData();
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
        if (typeof ($stateParams.task_id) != 'undefined') {
            //essOtApplyModifySev.loadData($stateParams.p_inst,$stateParams.show_type,$stateParams.task_id,$scope);
            essOtApplySev.loadModifyData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $scope);
            $scope.ot_apply_title = '修改加班单'
        } else {
            $scope.ot_apply_title = '加班申请'
            essOtApplySev.loadData($scope);
        }

        $scope.ot_app_data = essOtApplySev.getData();
        //$scope.add_time_list=[{name:'',in:$scope.ot_app_data.first_in,in_need_clock:$scope.ot_app_data.first_in_need_clock,out:$scope.ot_app_data.first_out,out_need_clock:$scope.ot_app_data.first_out_need_clock,is_need:$scope.ot_app_data.is_need_first},{name:'',in:$scope.ot_app_data.second_in,in_need_clock:$scope.ot_app_data.second_in_need_clock,out:$scope.ot_app_data.second_out,out_need_clock:$scope.ot_app_data.second_out_need_clock,is_need:$scope.ot_app_data.is_need_second},{name:'',in:$scope.ot_app_data.ot_in,in_need_clock:$scope.ot_app_data.ot_in_need_clock,out:$scope.ot_app_data.ot_out,out_need_clock:$scope.ot_app_data.ot_out_need_clock,is_need:$scope.ot_app_data.is_need_ot}];

        $scope.essOtPolicy = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.ot_app_data.essOtPolicy_data,
                selectIndex: $scope.ot_app_data.essOtPolicy_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("essOtPolicy").innerHTML = $scope.ot_app_data.essOtPolicy_data[index].value;
                        $scope.ot_app_data.essOtPolicy_data_key = $scope.ot_app_data.essOtPolicy_data[index].key;
                        $scope.ot_app_data.essOtPolicy_index = index;
                        $scope.ot_app_data.ot_code_key = $scope.ot_app_data.essOtPolicy_data_key;
                        for (var i = 0; i < $scope.ot_app_data.ot_code.length; i++) {
                            $scope.ot_app_data.ot_code[i].check = false;
                        }
                        $scope.ot_app_data.ot_code[index].check = true;
                        if ($scope.time_list_ot_apply.length == 0) {
                            card_times = $scope.ot_app_data.card_times;
                        } else {
                            card_times = $scope.time_list_ot_apply.length + 1;
                        }

                        essOtApplySev.add_time_save($scope.time_list_ot_apply, $scope, false, '1', card_times)
                    }

                }
            });
        }
        $scope.showDate_date = function () {
            timeSelect.show({
                type: 'date',
                startDate: '1900年01月01日',
                endDate: '2099年12月31日',
                defaultDate: $scope.ot_app_data.ot_date,
                returnDateType: 'ymd',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        var formatted_date = date.replace('年', '-');
                        formatted_date = formatted_date.replace('月', '-');
                        formatted_date = formatted_date.replace('日', '');
                        $scope.ot_app_data.ot_date = formatted_date;
                    }
                }
            })
        }
        $scope.showTime_ot_in = function () {
            timeSelect.show({
                type: 'time',
                startDate: '1900年01月01日',
                endDate: '2099年12月31日',
                defaultDate: $scope.ot_app_data.ot_in,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.ot_in = date;
                        var s_t = $scope.ot_app_data.ot_in;
                        var e_t = $scope.ot_app_data.ot_out;
                        s_t = s_t.split(":");
                        e_t = e_t.split(":");
                        var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                        if (_hours > 0) {} else {
                            _hours = parseInt(_hours) + (24 * 60);
                        }
                        var min = _hours;
                        essOtApplySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);
                    }
                }
            })
        }
        $scope.showTime_ot_out = function () {
            timeSelect.show({
                type: 'time',
                startDate: '1900年01月01日',
                endDate: '2099年12月31日',
                defaultDate: $scope.ot_app_data.ot_out,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.ot_out = date;
                        var s_t = $scope.ot_app_data.ot_in;
                        var e_t = $scope.ot_app_data.ot_out;
                        s_t = s_t.split(":");
                        e_t = e_t.split(":");
                        var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                        if (_hours > 0) {
                            //$scope.ot_app_data.ot_hours=_hours;
                            //    document.getElementById('ot_hours').innerHTML=_hours+'小时'
                        } else {
                            _hours = parseInt(_hours) + (24 * 60);
                            //$scope.ot_app_data.ot_hours=_hours;
                            //document.getElementById('ot_hours').innerHTML=_hours+'小时'
                        }
                        var min = _hours;
                        essOtApplySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);
                    }
                }
            })
        }


        $scope.time_list_ot_apply = essOtApplySev.getTimeList();




        var card_times = ''
        $scope.saveApply = function () {

            if ($scope.time_list_ot_apply.length == 0) {
                card_times = $scope.ot_app_data.card_times;
            } else {
                card_times = $scope.time_list_ot_apply.length + 1;
            }
            if (typeof ($stateParams.task_id) != 'undefined') {

                //essOtApplyModifySev.saveApply($scope.select_user_id, $scope.select_notify_id);
                essOtApplySev.saveModifyApply($scope.select_user_id, $scope.select_notify_id, card_times, '2');
            } else {
                essOtApplySev.saveApply($scope.select_user_id, $scope.select_notify_id, card_times, '2');
            }

        }

        $scope.add_time = function () {

            $location.path('home_page/home_menulist/add_time');
        }
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ot_app_data.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.closeModal();
            $scope.ot_app_data._approver_list = _d;
            $scope.search_control.search_val = '';
        }
        $scope.delete_notify = function (user_id) {
            $('#essOtApply #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.ot_app_data.notify_list.length; i++) {
                if ($scope.ot_app_data.notify_list[i].user_id == user_id) {
                    $scope.ot_app_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.ot_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }
        $scope.delete_approver = function (user_id) {
            if (!$scope.ot_app_data.approver_list_flag) {
                return;
            }
            $('#essOtApply #approver_list_div').addClass('approver_list_active');
            $scope.ot_app_data._approver_list = [];
            $scope.select_user_id = ''
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ot_app_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ot_app_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.ot_app_data.notify_list.length + 1) * 100 + 20 + 'px';
            //alert($scope.lv_app_data.notify_list.length);
            $scope.search_control.search_val = '';
            $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        /*
    $scope.openModal = function() {
      $('#essOtApply #approver_list_div').removeClass('approver_list_active');
      $scope.search_val = '';
      $scope.click_flag = 0;
      $scope.ess_empl_data = [];
      essOtApplySev.loadEssEmplData($scope.select_user_id,$scope.ot_app_data.employee_no,'');
      $scope.ess_empl_data = essOtApplySev.getEssEmplData();
      $scope.modal.show();
    };
    $scope.openModal2 = function() {
      $('#essOtApply #notify_list_div').removeClass('notify_list_active');
      $scope.search_val = '';
      $scope.click_flag = 1;
      $scope.ess_empl_data = [];
      essOtApplySev.loadEssEmplData($scope.select_notify_id,$scope.ot_app_data.employee_no,'');
      $scope.ess_empl_data = essOtApplySev.getEssEmplData();
      $scope.modal.show();
    };
	*/

        $scope.openModal = function () {

            var selectEmplList = '';
            if ($scope.ot_app_data._approver_list.length != 0) {
                selectEmplList = $scope.ot_app_data._approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式

                    $('#essOtApply #approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.ot_app_data._approver_list = [];
                    $scope.ot_app_data._approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    //$scope.approver_list=$scope.ot_app_data.approver_list;
                }
            });

        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.ot_app_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.ot_app_data.notify_list.length; i++) {
                    selectEmplList += $scope.ot_app_data.notify_list[i].employee_no;
                    if (i < $scope.ot_app_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式
                    $('#essOtApply #notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.ot_app_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.ot_app_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.ot_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }


        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });

        $scope.first_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.first_in_need_clock = flag;
        };
        $scope.first_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.first_out_need_clock = flag;
        };
        $scope.second_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.second_in_need_clock = flag;
        };
        $scope.second_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.second_out_need_clock = flag;
        };
        $scope.ot_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.ot_in_need_clock = flag;
        };
        $scope.ot_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.ot_out_need_clock = flag;
        };
    })



    .controller('addTimeCtrl', function ($scope, essOtApplySev, $ionicModal, $ionicActionSheet, $location, timeSelect, $ionicScrollDelegate, $ionicPopup) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.delete_icon = local_resource + 'img/icon/delete_icon.png';
        $scope.add_icon = local_resource + 'img/icon/add_icon.png';

        $scope.start_ot_icon = local_resource + 'img/icon/start_ot_icon.png';
        $scope.end_ot_icon = local_resource + 'img/icon/end_ot_icon.png';
        $scope.start_rest_icon = local_resource + 'img/icon/start_rest_icon.png';
        $scope.end_rest_icon = local_resource + 'img/icon/end_rest_icon.png';
        $scope.ot_hours_icon = local_resource + 'img/icon/ot_hours_icon.png';


        //essOtApplySev.loadData();
        $scope.ot_app_data = essOtApplySev.getData();

        //初始化add_time页面用到的first_in, last_out参数
        $scope.ot_app_data.add_time_first_in = $scope.ot_app_data.first_in;
        if ($scope.ot_app_data.fifth_in != '') {
            $scope.ot_app_data.add_time_last_out = $scope.ot_app_data.fifth_out;
            $scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.fifth_out_need_clock;
        } else if ($scope.ot_app_data.forth_in != '') {
            $scope.ot_app_data.add_time_last_out = $scope.ot_app_data.forth_out;
            $scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.forth_out_need_clock;
        } else if ($scope.ot_app_data.third_in != '') {
            $scope.ot_app_data.add_time_last_out = $scope.ot_app_data.third_out;
            $scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.third_out_need_clock;
        } else if ($scope.ot_app_data.second_in != '') {
            $scope.ot_app_data.add_time_last_out = $scope.ot_app_data.second_out;
            $scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.second_out_need_clock;
        } else {
            $scope.ot_app_data.add_time_last_out = $scope.ot_app_data.first_out;
            $scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.first_out_need_clock;
        }

        $scope.add_time_list = [];
        //初始化休息段的数组
        if ($scope.ot_app_data.second_in != '') {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.first_out,
                in_need_clock: $scope.ot_app_data.first_out_need_clock,
                out: $scope.ot_app_data.second_in,
                out_need_clock: $scope.ot_app_data.second_in_need_clock,
                is_need: true
            })
        }
        if ($scope.ot_app_data.third_in != '') {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.second_out,
                in_need_clock: $scope.ot_app_data.second_out_need_clock,
                out: $scope.ot_app_data.third_in,
                out_need_clock: $scope.ot_app_data.third_in_need_clock,
                is_need: true
            })
        }
        if ($scope.ot_app_data.forth_in != '') {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.third_out,
                in_need_clock: $scope.ot_app_data.third_out_need_clock,
                out: $scope.ot_app_data.forth_in,
                out_need_clock: $scope.ot_app_data.forth_in_need_clock,
                is_need: true
            })
        }
        if ($scope.ot_app_data.fifth_in != '') {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.forth_out,
                in_need_clock: $scope.ot_app_data.forth_out_need_clock,
                out: $scope.ot_app_data.fifth_in,
                out_need_clock: $scope.ot_app_data.fifth_in_need_clock,
                is_need: true
            })
        }

        if ($scope.ot_app_data.second_in != '') {
            document.getElementById('add_time_check').checked = true;
        } else {
            document.getElementById('add_time_check').checked = false;
        }

        var card_times = $scope.ot_app_data.card_times;


        $scope.delete = function (item) {
            var idx = $scope.add_time_list.indexOf(item);
            $scope.add_time_list.splice(idx, 1);
            if ($scope.add_time_list.length == '0') {
                card_times = $scope.ot_app_data.card_times;
            } else {
                card_times = $scope.add_time_list.length + 1;
            }

            var v = 0;
            for (var j = 0; j < $scope.add_time_list.length; j++) {
                if ($scope.add_time_list[j].in == '请选择' || $scope.add_time_list[j].out == '请选择') {
                    v++;
                }
            }
            if (v == 0) {
                essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
            }




        }
        $scope.add = function (item) {
            if ($scope.add_time_list.length == 0) {
                $scope.add_time_list.push({
                    name: '',
                    in: '请选择',
                    in_need_clock: $scope.ot_app_data.first_out_need_clock,
                    out: '请选择',
                    out_need_clock: $scope.ot_app_data.second_in_need_clock,
                    is_need: ''
                })
                $scope.ot_app_data.last_out_need_clock = $scope.ot_app_data.second_out_need_clock;
            } else if ($scope.add_time_list.length == 1) {
                $scope.add_time_list.push({
                    name: '',
                    in: '请选择',
                    in_need_clock: $scope.ot_app_data.second_out_need_clock,
                    out: '请选择',
                    out_need_clock: $scope.ot_app_data.third_in_need_clock,
                    is_need: ''
                })
                $scope.ot_app_data.last_out_need_clock = $scope.ot_app_data.third_out_need_clock;
            } else if ($scope.add_time_list.length == 2) {
                $scope.add_time_list.push({
                    name: '',
                    in: '请选择',
                    in_need_clock: $scope.ot_app_data.third_out_need_clock,
                    out: '请选择',
                    out_need_clock: $scope.ot_app_data.forth_in_need_clock,
                    is_need: ''
                })
                $scope.ot_app_data.last_out_need_clock = $scope.ot_app_data.forth_out_need_clock;
            } else if ($scope.add_time_list.length == 3) {
                $scope.add_time_list.push({
                    name: '',
                    in: '请选择',
                    in_need_clock: $scope.ot_app_data.forth_out_need_clock,
                    out: '请选择',
                    out_need_clock: $scope.ot_app_data.fifth_in_need_clock,
                    is_need: ''
                })
                $scope.ot_app_data.last_out_need_clock = $scope.ot_app_data.fifth_out_need_clock;
            }

            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
            if ($scope.add_time_list.length == '0') {
                card_times = $scope.ot_app_data.card_times;
            } else {
                card_times = $scope.add_time_list.length + 1;
            }
        }

        $scope.showTime_in = function (i) {

            if ($scope.add_time_list[i].in == '请选择') {
                $scope.add_time_list[i].defaultDate = '00:00';
            } else {
                $scope.add_time_list[i].defaultDate = $scope.add_time_list[i].in
            }
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.add_time_list[i].defaultDate,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.add_time_list[i].in = date;
                        var v = 0;
                        for (var j = 0; j < $scope.add_time_list.length; j++) {
                            if ($scope.add_time_list[j].in == '请选择' || $scope.add_time_list[j].out == '请选择') {
                                v++;
                            }
                        }
                        if (v == 0) {
                            essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                        }

                    }
                }
            })
        }
        $scope.showTime_out = function (i) {
            if ($scope.add_time_list[i].out == '请选择') {
                $scope.add_time_list[i].defaultDate = '00:00';
            } else {
                $scope.add_time_list[i].defaultDate = $scope.add_time_list[i].out
            }
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.add_time_list[i].defaultDate,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.add_time_list[i].out = date;
                        var v = 0;
                        for (var j = 0; j < $scope.add_time_list.length; j++) {
                            if ($scope.add_time_list[j].in == '请选择' || $scope.add_time_list[j].out == '请选择') {
                                v++;
                            }
                        }
                        if (v == 0) {
                            essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                        }
                    }
                }
            })
        }
        $scope.show_time_first_in = function () {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.ot_app_data.add_time_first_in,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.add_time_first_in = date;
                        var v = 0;
                        for (var i = 0; i < $scope.add_time_list.length; i++) {
                            if ($scope.add_time_list[i].in == '请选择' || $scope.add_time_list[i].out == '请选择') {
                                v++;
                            }
                        }
                        if (v == 0) {
                            essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                        }
                    }
                }
            })
        }
        $scope.show_time_last_out = function (i) {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.ot_app_data.add_time_last_out,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.add_time_last_out = date;
                        var v = 0;
                        for (var i = 0; i < $scope.add_time_list.length; i++) {
                            if ($scope.add_time_list[i].in == '请选择' || $scope.add_time_list[i].out == '请选择') {
                                v++;
                            }
                        }
                        if (v == 0) {
                            essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                        }
                    }
                }
            })
        }
        //
        var new_arr_add_time_list = [];
        $scope.add_time_check = function () {

            if (document.getElementById('add_time_check').checked) {
                document.getElementById('add_time_check').checked = false;
                document.getElementById('add_time_repeat_content').style.display = 'none';
                new_arr_add_time_list = $scope.add_time_list;
                $scope.add_time_list = [];
                card_times = $scope.add_time_list.length + 1;

                var v = 0;
                for (var i = 0; i < $scope.add_time_list.length; i++) {
                    if ($scope.add_time_list[i].in == '请选择' || $scope.add_time_list[i].out == '请选择') {
                        v++;
                    }
                }
                if (v != 0) {} else {
                    essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                }

            } else {
                document.getElementById('add_time_check').checked = true;
                document.getElementById('add_time_repeat_content').style.display = 'block';
                if (new_arr_add_time_list.length != 0) {
                    $scope.add_time_list = new_arr_add_time_list;
                    card_times = $scope.add_time_list.length + 1;
                    var v = 0;
                    for (var i = 0; i < $scope.add_time_list.length; i++) {
                        if ($scope.add_time_list[i].in == '请选择' || $scope.add_time_list[i].out == '请选择') {
                            v++;
                        }
                    }
                    if (v != 0) {
                        //alert('非法!');
                    } else {
                        essOtApplySev.add_time_save($scope.add_time_list, $scope, false, '3', card_times);
                    }
                } else {
                    $scope.add();
                }
            }
        }
        $scope.add_time_save = function () {
            if (document.getElementById("add_time_submit").style.opacity != 1) {
                return;
            }
            var v = 0;
            for (var i = 0; i < $scope.add_time_list.length; i++) {
                if ($scope.add_time_list[i].in == '请选择' || $scope.add_time_list[i].out == '请选择') {
                    v++;
                }
            }
            if (v != 0) {
                $ionicPopup.alert({
                    title: '运行结果',
                    template: '<div style="text-align: center;">请选择休息时间</div>',
                    okText: '确定'
                })
            } else {
                essOtApplySev.add_time_save($scope.add_time_list, $scope, true, '1', card_times);
            }
        }
    })

    .controller('essMyOtApplyDCtrl', function ($scope,$rootScope, essMyOtApplyDSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $ionicNavBarDelegate, $ionicHistory, $timeout) {

        //$scope.$on("$ionicView.enter", function () {
        //  //解决 进入明细页面back回来的时候 会再次loaddata
        //  if (typeof($scope.data_loaded) != 'undefined'){
        //    return;
        //  }
        //  else {
        //    $scope.data_loaded = true;
        //  }
        //  essMyOtApplyDSev.clearData();
        //  essMyOtApplyDSev.loadData($stateParams.type,'UC');
        //  //essMyOtApplyDSev.loadOtherData($stateParams.type,'C');
        //  $scope.ess_my_applyD_data = essMyOtApplyDSev.getData();
        //
        //
        //});
        $scope.$on("$ionicView.beforeEnter", function (event, data) {
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
        });
        if (ionic.Platform.isIOS()) {
            essMyOtApplyDSev.clearData();
            essMyOtApplyDSev.loadData($stateParams.type, 'UC');
            $scope.ess_my_applyD_data = essMyOtApplyDSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyOtApplyDSev.clearData();
                essMyOtApplyDSev.loadData($stateParams.type, 'UC');
                $scope.ess_my_applyD_data = essMyOtApplyDSev.getData();
            });
        }
        // essMyOtApplyDSev.clearData();
        //essMyOtApplyDSev.loadData($stateParams.type,'UC');
        //$scope.ess_my_applyD_data = essMyOtApplyDSev.getData();

        $scope.search_control = essMyOtApplyDSev.getSearchValue();

        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }

        //$scope._flag = "未完成";
        //
        $scope.noapprove_click = function () {
            //$scope._flag = "未完成";

            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';

            //essMyOtApplyDSev.loadData($stateParams.type,'UC');
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);



        }
        $scope.approved_click = function () {
            //$scope._flag = "已完成";

            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";
            }, 200);



            //essMyOtApplyDSev.loadData($stateParams.type,'C');
        }
        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, ot_code_n, s_t, is_process, it_date) {
            var ot_date = it_date.split("/");
            ot_date = ot_date.toString();
            ot_date = ot_date.replace(/,/g, '-');
            $location.path("home_page/ess_my_ot_apply_details_content/" + p_inst + "/" + show_type + "/" + task_id + "/" + ot_code_n + "/" + s_t + "/" + is_process + "/" + ot_date + "/my_apply");
        }


    })


    .controller('essMyOtApprovalDCtrl', function ($scope, essMyApprovalDSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate) {
        $scope.ess_my_approval_details_title = $stateParams.name + "审批";
        //essMyApprovalDSev.loadData($stateParams.type,$scope);
        //$scope.ess_my_approvalD_data = essMyApprovalDSev.getData();
        //$scope._flag='待处理';
        $scope.noapprove_click = function () {
            //$scope._flag='待处理';
            document.getElementById("my_apply_details_noapprove").style.color = "#3ba5ff";
            document.getElementById("my_apply_details_noapprove").style.borderBottom = "1px solid #3ba5ff";
            document.getElementById("my_apply_details_approved").style.color = "black";
            document.getElementById("my_apply_details_approved").style.borderBottom = "1px solid #f5f5f5";
            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        $scope.approved_click = function () {
            //$scope._flag='已处理';
            document.getElementById("my_apply_details_approved").style.color = "#3ba5ff";
            document.getElementById("my_apply_details_approved").style.borderBottom = "1px solid #3ba5ff";
            document.getElementById("my_apply_details_noapprove").style.color = "black";
            document.getElementById("my_apply_details_noapprove").style.borderBottom = "1px solid #f5f5f5";

            setTimeout(function () {
                $ionicScrollDelegate.resize();
            }, 200);
        }
        //
        //
        //$scope.loadMyApplyContent=function(p_inst,show_type,task_id,my_app_result){
        //
        //  if(my_app_result=="待处理"){
        //    my_app_result="UC";
        //  }
        //  else{
        //    my_app_result="C";
        //  }
        //  $location.path("home_page/ess_my_approval_details_content/"+p_inst+"/"+show_type+"/"+task_id+"/"+my_app_result);
        //}

    })



    .controller('essMyOtApplyDetailsContentCtrl', function ($scope, essMyOtApplyDetailsContentSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $ionicPopup, $timeout) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.icon_noapprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.notify = local_resource + 'img/icon/notify.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.start_ot_icon = local_resource + 'img/icon/start_ot_icon.png';
        $scope.end_ot_icon = local_resource + 'img/icon/end_ot_icon.png';
        $scope.start_rest_icon = local_resource + 'img/icon/start_rest_icon.png';
        $scope.end_rest_icon = local_resource + 'img/icon/end_rest_icon.png';
        $scope.ot_hours_icon = local_resource + 'img/icon/ot_hours_icon.png';
        $scope.ot_code_n = $stateParams.ot_code_n;
        essMyOtApplyDetailsContentSev.clearData();

        if ($stateParams.is_process == 1) {
            essMyOtApplyDetailsContentSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id);
        } else {
            essMyOtApplyDetailsContentSev.loadNoprocessData($stateParams.show_type, $stateParams.p_inst);
        }

        $scope.ess_my_applyDC_data = essMyOtApplyDetailsContentSev.getData();
        var my_app_result = '';
        if ($stateParams.s_t == '未完成') {
            my_app_result = 'UC';
        } else {
            my_app_result = 'C';
        }


        $scope.time_list_ot_apply = essMyOtApplyDetailsContentSev.getTimeList();


        $scope.fireEvent = function (i, arr) {
            $timeout(function () {
                if (arr[i].action == '拒绝') {
                    document.getElementById("approver_list_img" + i).src = $scope.icon_noapprove;
                } else if (arr[i].action == '批准') {
                    document.getElementById("approver_list_img" + i).src = $scope.icon_confirm;
                }
                if (i == (arr.length - 1)) {
                    document.getElementById("approver_list_img_" + i).style.display = "none";
                }
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 16) + 'px';
                }

            }, 0);
        }
        $scope.show_img = function (url) {
            if (ionic.Platform.isIOS()) {
                window.open(url, '_system', 'enableViewportScale=yes');
            } else {
                window.open(url, '_system');
            }
        }


        $scope.changeEssLvPolicy = function () {
            essMyApplyDetailsContentSev.changeEssLvPolicy($scope.ess_my_applyDC_data.default_lv_code_id);
        }

        $scope.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_applyDC_data.approver_list;
            } else {
                return;
            }
            var _len = _d.length;
            if (_len == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 2
                }
            }
            $scope.closeModal();
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_applyDC_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_applyDC_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
        }

        $ionicModal.fromTemplateUrl('ess-my-apply-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        $scope.openModal = function () {
            $scope.search_val = '';
            $scope.click_flag = 0;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_data.approver_list;
            if (_d.length > 0) {
                var len = _d.length;
                $scope.select_user_id = _d[len - 1].user_id;
            }
            essLvApplySev.loadEssEmplData($scope.select_user_id, $scope.ess_my_applyDC_data.employee_no, $scope.ess_my_applyDC_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.openModal2 = function () {
            $scope.search_val = '';
            $scope.click_flag = 1;
            $scope.ess_empl_data = [];
            var _d = $scope.ess_my_applyDC_data.notify_list;
            $scope.select_notify_id = '';
            for (var i = 0; i < _d.length; i++) {
                $scope.select_notify_id = $scope.select_notify_id + _d[i].user_id + ',';
            }
            $scope.select_notify_id = $scope.select_notify_id.substring(0, $scope.select_notify_id.length - 1);
            essLvApplySev.loadEssEmplData($scope.select_notify_id, $scope.ess_my_applyDC_data.employee_no, $scope.ess_my_applyDC_data.process_instance);
            $scope.ess_empl_data = essLvApplySev.getEssEmplData();
            $scope.modal.show();
        };
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
        };
        //$scope.$on('$destroy', function() {
        //  $scope.modal.remove();
        //});

        $scope.submitAction = function (action) {
            essMyOtApplyDetailsContentSev.submitAction(action);
        }
        $scope.cancel = function () {
            if ($scope.ess_my_applyDC_data.action_text == '更多') {
                var hideSheet = $ionicActionSheet.show({
                    buttons: [

                        {
                            text: '修改'
                        }, {
                            text: '撤销'
                        }
                    ],

                    //titleText: 'Modify your album',
                    //titleText: '选择上传图片方式',
                    cancelText: '取消',
                    cancel: function () {
                        // add cancel code..
                    },
                    buttonClicked: function (index) {

                        if (index == 0) {
                            if ($scope.ess_my_applyDC_data.modify) {
                                $location.path("home_page/ess_my_ot_apply_details_content_modify/" + $stateParams.p_inst + "/" + $stateParams.show_type + "/" + $stateParams.task_id);
                            } else {
                                $ionicPopup.alert({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">不能修改</div>',
                                    okText: '确定'
                                })
                            }
                            return true;
                        } else if (index == 1) {
                            if ($scope.ess_my_applyDC_data.cancel) {
                                $ionicPopup.confirm({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">确认要撤销吗</div>',
                                    cancelType: 'button-dark',
                                    cancelText: '取消',
                                    okText: '确认'
                                }).then(function (res) {
                                    if (res) {
                                        essMyOtApplyDetailsContentSev.submitAction('Cancel', my_app_result);
                                    }
                                });

                            } else {
                                $ionicPopup.alert({
                                    title: '提醒',
                                    template: '<div style="text-align: center;">不能撤销</div>',
                                    okText: '确定'
                                })
                            }
                            return true;
                        }

                        return true;


                    }
                });
            } else if ($scope.ess_my_applyDC_data.action_text == '修改') {
                $location.path("home_page/ess_my_ot_apply_details_content_modify/" + $stateParams.p_inst + "/" + $stateParams.show_type + "/" + $stateParams.task_id);
            } else if ($scope.ess_my_applyDC_data.action_text == '撤销') {
                $ionicPopup.confirm({
                    title: '提醒',
                    template: '<div style="text-align: center;">确认要撤销吗</div>',
                    cancelType: 'button-dark',
                    cancelText: '取消',
                    okText: '确认'
                }).then(function (res) {
                    if (res) {
                        essMyOtApplyDetailsContentSev.submitAction('Cancel', my_app_result);
                    }
                });
            } else {
                return;
            }

        }

    })



    .controller('essOtApplyModifyCtrl', function ($scope, essOtApplySev, essOtApplyModifySev, $ionicModal, $ionicActionSheet, $location, essLvApplySev, $stateParams, timeSelect, sideSelect, $emplComponentService) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';;
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.ot_hours_icon = local_resource + 'img/icon/ot_hours_icon.png';
        essOtApplyModifySev.clearData();
        essOtApplyModifySev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, $scope);
        $scope.ot_app_data = essOtApplyModifySev.getData();
        $scope.add_time_list = [{
            name: '',
            in: $scope.ot_app_data.first_in,
            in_need_clock: $scope.ot_app_data.first_in_need_clock,
            out: $scope.ot_app_data.first_out,
            out_need_clock: $scope.ot_app_data.first_out_need_clock,
            is_need: $scope.ot_app_data.is_need_first
        }, {
            name: '',
            in: $scope.ot_app_data.second_in,
            in_need_clock: $scope.ot_app_data.second_in_need_clock,
            out: $scope.ot_app_data.second_out,
            out_need_clock: $scope.ot_app_data.second_out_need_clock,
            is_need: $scope.ot_app_data.is_need_second
        }, {
            name: '',
            in: $scope.ot_app_data.ot_in,
            in_need_clock: $scope.ot_app_data.ot_in_need_clock,
            out: $scope.ot_app_data.ot_out,
            out_need_clock: $scope.ot_app_data.ot_out_need_clock,
            is_need: $scope.ot_app_data.is_need_ot
        }];
        $scope.essOtPolicy = function () {

            sideSelect.show({
                type: 'ios',
                data: $scope.ot_app_data.essOtPolicy_data,
                selectIndex: $scope.ot_app_data.essOtPolicy_data_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("essOtPolicy").innerHTML = $scope.ot_app_data.essOtPolicy_data[index].value;
                        $scope.ot_app_data.essOtPolicy_data_key = $scope.ot_app_data.essOtPolicy_data[index].key;
                        $scope.ot_app_data.essOtPolicy_data_index = index;
                        $scope.ot_app_data.ot_code_key = $scope.ot_app_data.essOtPolicy_data_key;
                        //essLvApplySev.changeessOtPolicy($scope,$scope.lv_app_data.default_lv_code_id);
                        if (document.getElementById('essOtPolicy').innerHTML != '日常加班') {
                            document.getElementById("time_div").style.display = 'none';
                            document.getElementById("add_time_div").style.display = 'block';
                            document.getElementById("div_time").style.display = 'block'
                            essOtApplyModifySev.get_ot_hours($scope);
                        } else {
                            document.getElementById("time_div").style.display = 'block';
                            document.getElementById("add_time_div").style.display = 'none';
                            document.getElementById("div_time").style.display = 'none';

                            var s_t = $scope.ot_app_data.ot_in;
                            var e_t = $scope.ot_app_data.ot_out;
                            s_t = s_t.split(":");
                            e_t = e_t.split(":");
                            var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                            if (_hours > 0) {

                            } else {
                                _hours = parseInt(_hours) + (24 * 60);
                            }
                            var min = _hours;

                            essOtApplyModifySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);

                        }
                    }

                }
            });
        }

        $scope.showDate_date = function () {
            timeSelect.show({
                type: 'date',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.ot_app_data.ot_date,
                returnDateType: 'ymd',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        var formatted_date = date.replace('年', '-');
                        formatted_date = formatted_date.replace('月', '-');
                        formatted_date = formatted_date.replace('日', '');
                        $scope.ot_app_data.ot_date = formatted_date;
                    }
                }
            })
        }

        $scope.showTime_ot_in = function () {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.ot_app_data.ot_in,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.ot_in = date;
                        var s_t = $scope.ot_app_data.ot_in;
                        var e_t = $scope.ot_app_data.ot_out;
                        s_t = s_t.split(":");
                        e_t = e_t.split(":");
                        var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                        if (_hours > 0) {} else {
                            _hours = parseInt(_hours) + (24 * 60);
                        }
                        var min = _hours;
                        essOtApplySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);
                    }
                }
            })
        }

        $scope.showTime_ot_out = function () {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.ot_app_data.ot_out,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.ot_app_data.ot_out = date;
                        var s_t = $scope.ot_app_data.ot_in;
                        var e_t = $scope.ot_app_data.ot_out;
                        s_t = s_t.split(":");
                        e_t = e_t.split(":");
                        var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                        if (_hours > 0) {} else {
                            _hours = parseInt(_hours) + (24 * 60);
                        }
                        var min = _hours;
                        essOtApplySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);
                    }
                }
            })
        }

        $scope.changeEssLvPolicy = function () {
            //alert($scope.ot_app_data.ot_code_key);
            if (document.getElementById('ot_apply_select').value != 'post_ot') {
                document.getElementById("time_div").style.display = 'none';
                document.getElementById("add_time_div").style.display = 'block';
                document.getElementById("div_time").style.display = 'block';
                $scope.ot_app_data.is_need_first = true;
                essOtApplyModifySev.get_ot_hours($scope);
            } else {
                document.getElementById("time_div").style.display = 'block';
                document.getElementById("add_time_div").style.display = 'none';
                document.getElementById("div_time").style.display = 'none';

                var s_t = $scope.ot_app_data.ot_in;
                var e_t = $scope.ot_app_data.ot_out;
                s_t = s_t.split(":");
                e_t = e_t.split(":");
                var _hours = ((e_t[0] - s_t[0]) * 60 + (e_t[1] - s_t[1]));
                if (_hours > 0) {

                } else {
                    _hours = parseInt(_hours) + 24 * 60;
                }
                var min = _hours;
                essOtApplyModifySev.get_ot_hours_normal(min, $scope.ot_app_data.ot_valid_min, $scope.ot_app_data.ot_min_unit, $scope);

            }
        }


        $scope.saveApply = function () {

            essOtApplyModifySev.saveApply($scope.select_user_id, $scope.select_notify_id);

        }

        $scope.add_time = function () {
            $location.path('home_page/home_menulist/add_time_modify');

        }
        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;
        $scope.essItemCk = function (user_id, img, en) {
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ot_app_data.approver_list;
            } else {
                return;
            }
            var flag = 0;
            var _len = _d.length;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                    flag = 1;
                    break;
                }
            }
            if (flag == 0) {
                _d.push({
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                })
            } else {
                _d[_len - 1] = {
                    img: img,
                    name: en,
                    user_id: user_id,
                    flag: 1
                }
            }
            $scope.closeModal();
            $scope.search_control.search_val = '';
        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ot_app_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ot_app_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                //$scope.select_notify_id = ($scope.select_notify_id).substring(0,$scope.select_notify_id.length-1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.ot_app_data.notify_list.length + 1) * 100 + 20 + 'px';
            //alert($scope.lv_app_data.notify_list.length);
            $scope.search_control.search_val = '';
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });

        $scope.openModal = function () {

            var selectEmplList = '';
            if ($scope.ot_app_data.approver_list.length != 0) {
                selectEmplList = $scope.ot_app_data.approver_list[0].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表

                sure: function (rd) { //返回数据，数组格式

                    $('#approver_list_div').removeClass('approver_list_active');
                    $scope.select_user_id = rd[0].user_id;
                    $scope.ot_app_data.approver_list = [];
                    $scope.ot_app_data.approver_list.push({
                        img: rd[0].img_src,
                        name: rd[0].empl_name,
                        user_id: rd[0].user_id,
                        employee_no: rd[0].empl_no,
                        flag: 1
                    });
                    $scope.approver_list = $scope.ot_app_data.approver_list;
                }
            });

        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.ot_app_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.ot_app_data.notify_list.length; i++) {
                    selectEmplList += $scope.ot_app_data.notify_list[i].employee_no;
                    if (i < $scope.ot_app_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表

                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.ot_app_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.ot_app_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.ot_app_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }
        /*
    $scope.openModal = function() {
      $scope.search_val = '';
      $scope.click_flag = 0;
      $scope.ess_empl_data = [];
      essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.ot_app_data.employee_no,'');
      $scope.ess_empl_data = essLvApplySev.getEssEmplData();
      $scope.modal.show();
    };
    $scope.openModal2 = function() {
      $scope.search_val = '';
      $scope.click_flag = 1;
      $scope.ess_empl_data = [];
      essOtApplySev.loadEssEmplData($scope.select_notify_id,$scope.ot_app_data.employee_no,'');
      $scope.ess_empl_data = essOtApplySev.getEssEmplData();
      $scope.modal.show();
    };
	*/
        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });

        $scope.first_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.first_in_need_clock = flag;
        };
        $scope.first_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.first_out_need_clock = flag;
        };
        $scope.second_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.second_in_need_clock = flag;
        };
        $scope.second_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.second_out_need_clock = flag;
        };
        $scope.ot_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.ot_in_need_clock = flag;
        };
        $scope.ot_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ot_app_data.ot_out_need_clock = flag;
        };
    })



    .controller('essMyApprovalDOTCtrl', function ($scope,$rootScope, essMyApprovalDOTSev, essLvApplySev, $stateParams, $ionicModal, $location, $ionicScrollDelegate, $ionicNavBarDelegate, $ionicHistory, $timeout) {
        $scope.vip_modal_img = local_resource + 'img/icon/vip_modal_img.png';
        $scope.diamond_icon = local_resource + 'img/icon/diamond_icon.png';
        $scope.is_vip = getLocalStorageVar("is_vip");
        $scope.modal_show = false;
        $scope.modalHidden = function(){
        $scope.modal_show = false;
        }

        $scope.navigateToPage = function(){
        if($scope.is_vip == 'true'){        
            $location.path("home_page/overtime_batch_approval/" + $stateParams.name + "/" + $stateParams.type);
        }else{
        $scope.modal_show = true;
        }
        }

        //解决批量审批页面返回后不刷新页面的问题
        $scope.$on('$ionicView.beforeEnter',function(){
            if(localStorage.is_vip=="false"){
                $rootScope.showPayConfirm();
            }
            essMyApprovalDOTSev.loadData($stateParams.type, 'UC');
            $scope.showOrHideBtnWrapper();
        });
        if (ionic.Platform.isIOS()) {
            essMyApprovalDOTSev.clearData();
            essMyApprovalDOTSev.loadData($stateParams.type, 'UC');
            $scope.essMyApprovalDOTData = essMyApprovalDOTSev.getData();
        } else {
            $scope.$on("$ionicView.enter", function () {
                //解决 进入明细页面back回来的时候 会再次loaddata
                if (typeof ($scope.data_loaded) != 'undefined') {
                    return;
                } else {
                    $scope.data_loaded = true;
                }
                essMyApprovalDOTSev.clearData();
                essMyApprovalDOTSev.loadData($stateParams.type, 'UC');
                $scope.essMyApprovalDOTData = essMyApprovalDOTSev.getData();
            });
        }

        // 动态显示批量审批按钮
        $scope.showOrHideBtnWrapper = function(){
            var timer = setTimeout(function(){
                if($scope.essMyApprovalDOTData && $scope.essMyApprovalDOTData.data1.length){
                    document.getElementById('contentWrapper').style.marginBottom = '45px';
                    document.getElementById('btnWrapper').style.display = "flex";
                }else{
                    document.getElementById('contentWrapper').style.marginBottom = '0';
                    document.getElementById('btnWrapper').style.display = "none";
                }
                clearTimeout(timer);
            },1200);
        }

        $scope.showOrHideBtnWrapper();

        //$scope.$on("$ionicView.enter", function () {
        //  //解决 进入明细页面back回来的时候 会再次loaddata
        //  if (typeof($scope.data_loaded) != 'undefined'){
        //    return;
        //  }
        //  else {
        //    $scope.data_loaded = true;
        //  }
        //  essMyApprovalDOTSev.clearData();
        //  essMyApprovalDOTSev.loadData($stateParams.type,'UC');
        //  $scope.essMyApprovalDOTData = essMyApprovalDOTSev.getData();
        //});
        $scope.search_control = essMyApprovalDOTSev.getSearchValue();
        //$scope.search_control.search_val = "";
        $scope.show_search = false;
        $scope.toggle_search = function () {
            $scope.show_search = true;
            $ionicScrollDelegate.scrollTop();
        }
        $scope.cancel_search = function () {
            $scope.show_search = false;
            $scope.search_control.search_val = '';
        }
        $scope.address_icon = local_resource + 'img/icon/address_icon.png';
        $scope.ess_my_approval_details_title = $stateParams.name + "审批";
        // essMyApprovalDOTSev.clearData();
        //essMyApprovalDOTSev.loadData($stateParams.type,'UC');
        ////essMyApprovalDOTSev.loadOtherData($stateParams.type,'C');
        //$scope.essMyApprovalDOTData = essMyApprovalDOTSev.getData();
        //$scope.essMyApprovalDOTOtherData = essMyApprovalDOTSev.getOtherData();
        $scope._flag = "待处理";
        $scope.noapprove_click = function () {
            //essMyApprovalDOTSev.loadData($stateParams.type,'UC');
            $scope._flag = "待处理";
            document.getElementById('my_apply_details_noapprove').style.color = '#53afff';
            document.getElementById('my_apply_details_approved').style.color = '#808080';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(0)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;position: absolute;left:50%;top:0px;");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";

                $scope.showOrHideBtnWrapper();
            }, 200);





        }
        $scope.approved_click = function () {
            //essMyApprovalDOTSev.loadData($stateParams.type,'C');
            $scope._flag = "已处理";
            document.getElementById('my_apply_details_noapprove').style.color = '#808080';
            document.getElementById('my_apply_details_approved').style.color = '#53afff';
            document.getElementById('ess_my_apply_details_tab_animate_div').style.webkitTransform = 'translateX(100%)';
            document.getElementById('ess_my_apply_details_wrap').style.webkitTransform = 'translateX(-50%)';
            document.getElementById('ess_my_apply_details_wrap').style.overflow = "visible";
            document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style", "width:50%;position: absolute;left:0px;top:0px;");
            document.getElementById('ess_my_apply_details_approved_div').setAttribute("style", "width: 50%;float: right");
            $timeout(function () {
                $ionicScrollDelegate.resize();
                document.getElementById('ess_my_apply_details_wrap').style.overflow = "hidden";

                document.getElementById('contentWrapper').style.marginBottom = '0';
                document.getElementById('btnWrapper').style.display = "none";
            }, 200);


        }
        $scope.loadMyApplyContent = function (p_inst, show_type, task_id, app_status, ot_code_n, is_normal_path) {



            $location.path("home_page/ess_my_approval_details_content_overtime/" + p_inst + "/" + show_type + "/" + task_id + "/" + app_status + "/" + ot_code_n + "/" + is_normal_path + "/my_approval");
        }

    })

    .controller('essMyApprovalDOTCCtrl', function ($emplComponentService, $scope, essMyApprovalDOTCSev, essLvApplySev, $stateParams, $ionicModal, $ionicActionSheet, $location, $timeout, $ionicPopup, sideSelect, $ionicScrollDelegate) {
        $scope.ot_code_n = $stateParams.ot_code_n;

        $scope.approval_content_overtime_title = '加班单审批';
        $scope.fireEvent = function (i, arr, flag) {
            $timeout(function () {
                if (document.getElementById("approver_list_img_" + i) != null) {
                    document.getElementById("approver_list_img_" + i).style.height = document.getElementById("approver_list_div" + i).offsetHeight + 'px';
                    document.getElementById("approver_list_div_" + i).style.height = (document.getElementById("approver_list_div" + i).offsetHeight - 16) + 'px';
                }
                //if(arr[i].flag=='1'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line;
                //}
                //else if(arr[i].flag=='2'){
                //  document.getElementById("approver_list_img_"+(i-1)).src=$scope.approval_line_gray;
                //}
                if (i == arr.length - 1 && flag == false) {
                    document.getElementById("approver_list_img_" + i).style.display = "none";
                }
            }, 0);
        }
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.icon_apply = local_resource + 'img/model/icon-apply@2x.png';
        $scope.approval_line = local_resource + 'img/model/approval-line@2x.png';
        $scope.icon_confirm = local_resource + 'img/model/icon-confirm@2x.png';
        $scope.icon_noappprove = local_resource + 'img/model/icon-noapprove.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.icon_waiting = local_resource + 'img/model/wait_approval.png';
        $scope.icon_wait = local_resource + 'img/model/icon-waiting@2x.png';
        $scope.approval_line_gray = local_resource + 'img/model/approval-line-gray@2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.approve_icon = local_resource + 'img/icon/approve_icon.png';
        $scope.map_icon = local_resource + 'img/icon/map_icon.png';
        $scope.content_left_icon = local_resource + 'img/icon/content-left-icon.png';
        $scope.notify = local_resource + 'img/icon/notify.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.start_ot_icon = local_resource + 'img/icon/start_ot_icon.png';
        $scope.end_ot_icon = local_resource + 'img/icon/end_ot_icon.png';
        $scope.start_rest_icon = local_resource + 'img/icon/start_rest_icon.png';
        $scope.end_rest_icon = local_resource + 'img/icon/end_rest_icon.png';
        $scope.ot_hours_icon = local_resource + 'img/icon/ot_hours_icon.png';

        var my_app_result = '';
        if ($stateParams.app_status == '待处理') {
            $scope.app_result = true;
            my_app_result = 'UC';
        } else {
            $scope.app_result = false;
            my_app_result = 'C';
        }
        essMyApprovalDOTCSev.clearData();
        $scope.time_list_ot_apply = essMyApprovalDOTCSev.getTimeList();
        essMyApprovalDOTCSev.loadData($stateParams.p_inst, $stateParams.show_type, $stateParams.task_id, my_app_result, $scope);

        $scope.ess_my_approvalDC_data = essMyApprovalDOTCSev.getData();

        //$scope.search_val = '';
        //$scope.ess_empl_data = [];
        //$scope.select_notify_id = '';
        //$scope.click_flag = 0;
        //
        //$scope.selectList = function(){
        //  if($scope.click_flag==1){
        //    var _d = [];
        //    $scope.select_notify_id = '';
        //    $scope.ess_my_applyDC_data.notify_list = [];
        //    for(var i=0;i<$scope.ess_empl_data.length;i++){
        //      if($scope.ess_empl_data[i].ck){
        //        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id+',';
        //        $scope.ess_my_applyDC_data.notify_list.push({
        //          img:($scope.ess_empl_data)[i].img,
        //          name:($scope.ess_empl_data)[i].en,
        //          user_id:($scope.ess_empl_data)[i].user_id,
        //          flag:1
        //        });
        //      }
        //    }
        //    $scope.select_notify_id = ($scope.select_notify_id).substring(0,$scope.select_notify_id.length-1);
        //    $scope.closeModal();
        //  }
        //}
        //
        //$scope.select_user_id='';
        //$ionicModal.fromTemplateUrl('ess-my-apply-empl-modal.html', {
        //  scope: $scope,
        //  animation: 'slide-in-up'
        //}).then(function(modal) {
        //  $scope.modal = modal;
        //});
        //$scope.openModal = function() {
        //  $scope.search_val = '';
        //  $scope.ess_empl_data = [];
        //  essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
        //  $scope.ess_empl_data = essLvApplySev.getEssEmplData();
        //  $scope.modal.show();
        //};
        //$scope.closeModal = function() {
        //  $scope.modal.hide();
        //  $scope.ess_empl_data = [];
        //};
        ////$scope.$on('$destroy', function() {
        ////  $scope.modal.remove();
        ////});
        //$scope.essItemCk = function(user_id,img,en){
        //  var _d = [];
        //  $scope.select_user_id = user_id;
        //  _d = $scope.ess_my_approvalDC_data.approver_list;
        //  var flag = 0;
        //  var _len = _d.length;
        //  for(var i=0;i<_len;i++){
        //    if(angular.isDefined(_d[i]._flag)&&_d[i]._flag==1){
        //      flag = 1;
        //      break;
        //    }
        //  }
        //  if(flag == 0){
        //    _d.push({
        //      img:img,
        //      name:en,
        //      user_id:user_id,
        //      color:"#999",
        //      action:'下一层审批人',
        //      flag:1,
        //      _flag:1,
        //      approval_remark:'',
        //      apply_remark:''
        //    })
        //  }else{
        //    _d[_len-1] = {
        //      img:img,
        //      name:en,
        //      color:"#999",
        //      action:'下一层审批人',
        //      flag:1,
        //      user_id:user_id,
        //      _flag:1,
        //      approval_remark:'',
        //      apply_remark:''
        //    }
        //  }
        //  $scope.closeModal();
        //}


        $scope.search_control = {};
        $scope.search_control.search_val = '';
        $scope.ess_empl_data = [];
        $scope.select_user_id = '';
        $scope.select_notify_id = '';
        $scope.click_flag = 0;

        $scope.essItemCk = function (user_id, img, en, _flag) {
            if (_flag == true) {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked + 1;
            } else {
                $scope.ess_empl_data.num_checked = $scope.ess_empl_data.num_checked - 1;
            }
            var _d = [];
            if ($scope.click_flag == 0) {
                $scope.select_user_id = user_id;
                _d = $scope.ess_my_approvalDC_data.approver_list;
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                        flag = 1;
                        break;
                    }
                }

                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        action: '下一层审批人',
                        flag: 1,
                        _flag: 1,
                        attachment: '',
                        approval_remark: '',
                        color: "#999"
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        action: '下一层审批人',
                        flag: 1,
                        user_id: user_id,
                        _flag: 1,
                        attachment: '',
                        approval_remark: '',
                        color: "#999"
                    }
                }

                $scope.closeModal();
            } else {
                var _d = [];
                if ($scope.click_flag == 0) {
                    $scope.select_user_id = user_id;
                    _d = $scope.lv_app_data.approver_list;
                } else {
                    return;
                }
                var flag = 0;
                var _len = _d.length;
                for (var i = 0; i < _len; i++) {
                    if (angular.isDefined(_d[i].flag) && _d[i].flag == 1) {
                        flag = 1;
                        break;
                    }
                }
                if (flag == 0) {
                    _d.push({
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    })
                } else {
                    _d[_len - 1] = {
                        img: img,
                        name: en,
                        user_id: user_id,
                        flag: 1
                    }
                }
                $scope.approver_list = _d;
                $scope.search_control.search_val = '';
                $scope.closeModal();
            }

        }
        $scope.delete_notify = function (user_id) {
            $('#essMyApprovalDOTC #notify_list_div').addClass('notify_list_active');
            if ($scope.select_notify_id.indexOf(',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id, '');
            } else if ($scope.select_notify_id.indexOf(user_id + ',') == -1) {
                $scope.select_notify_id = $scope.select_notify_id.replace(',' + user_id, '');
            } else {
                $scope.select_notify_id = $scope.select_notify_id.replace(user_id + ',', '');
            }
            for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                if ($scope.ess_my_approvalDC_data.notify_list[i].user_id == user_id) {
                    $scope.ess_my_approvalDC_data.notify_list.splice(i, 1);
                }
            }
            setTimeout(function () {
                document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
            }, 350)


        }

        $scope.selectList = function () {
            if ($scope.click_flag == 1) {
                var _d = [];
                $scope.select_notify_id = '';
                $scope.ess_my_approvalDC_data.notify_list = [];
                for (var i = 0; i < $scope.ess_empl_data.length; i++) {
                    if ($scope.ess_empl_data[i].ck) {
                        $scope.select_notify_id = $scope.select_notify_id + ($scope.ess_empl_data)[i].user_id + ',';
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: ($scope.ess_empl_data)[i].img,
                            name: ($scope.ess_empl_data)[i].en,
                            user_id: ($scope.ess_empl_data)[i].user_id,
                            flag: 1
                        });
                    }
                }
                $scope.select_notify_id = ($scope.select_notify_id).substring(0, $scope.select_notify_id.length - 1);
                $scope.closeModal();
            }
            document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
            //alert($scope.lv_app_data.notify_list.length);

            $scope.search_control.search_val = '';
            $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
        }

        $ionicModal.fromTemplateUrl('ess-empl-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal;
        });
        /*
    $scope.openModal = function() {
      $scope.search_val = '';
      $scope.click_flag = 0;
      $scope.ess_empl_data = [];
      essLvApplySev.loadEssEmplData($scope.select_user_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
      $scope.ess_empl_data = essLvApplySev.getEssEmplData();
      $scope.modal.show();
    };
    $scope.openModal2 = function() {
      $('#essMyApprovalDOTC #notify_list_div').removeClass('notify_list_active');
      $scope.search_val = '';
      $scope.click_flag = 1;
      $scope.ess_empl_data = [];
      essLvApplySev.loadEssEmplData($scope.select_notify_id,$scope.ess_my_approvalDC_data.employee_no,$scope.ess_my_approvalDC_data.process_instance);
      $scope.ess_empl_data = essLvApplySev.getEssEmplData();
      $scope.modal.show();
    };
	*/

        var routerName = '';
        if (typeof ($stateParams.from_source) != 'undefined') {
            if ($stateParams.from_source == 'at_team_record') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'my_approval') {
                routerName = 'default';
            } else if ($stateParams.from_source == 'home_message') {
                routerName = 'message';
            }
        }

        $scope.openModal = function () {

            var _d = [];
            _d = $scope.ess_my_approvalDC_data.approver_list;
            var flag = 0;
            var _len = _d.length;

            var flag = 0;
            for (var i = 0; i < _len; i++) {
                if (angular.isDefined(_d[i]._flag) && _d[i]._flag == 1) {
                    flag = 1;
                    break;
                }
            }

            var selectEmplList = '';
            if (flag == 1) {
                selectEmplList = _d[_len - 1].employee_no;
            }

            $emplComponentService.open({
                title: '选择审批人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: true, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                sure: function (rd) { //返回数据，数组格式
                    $scope.select_user_id = rd[0].user_id;

                    if (flag == 0) {
                        _d.push({
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            user_id: rd[0].user_id,
                            action: '下一层审批人',
                            flag: 1,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        })
                    } else {
                        _d[_len - 1] = {
                            employee_no: rd[0].empl_no,
                            img: rd[0].img_src,
                            name: rd[0].empl_name,
                            action: '下一层审批人',
                            flag: 1,
                            user_id: rd[0].user_id,
                            _flag: 1,
                            attachment: '',
                            approval_remark: '',
                            color: "#999"
                        }
                    }

                }
            });


        }

        $scope.openModal2 = function () {
            var selectEmplList = '';
            if ($scope.ess_my_approvalDC_data.notify_list.length != 0) {
                for (var i = 0; i < $scope.ess_my_approvalDC_data.notify_list.length; i++) {
                    selectEmplList += $scope.ess_my_approvalDC_data.notify_list[i].employee_no;
                    if (i < $scope.ess_my_approvalDC_data.notify_list.length - 1) {
                        selectEmplList += ',';
                    }
                }

            }

            $emplComponentService.open({
                title: '选择知会人', //弹开窗口标题
                barTitle: window.localStorage["org_top_level"], //导航开头
                isSingleSelect: false, //是否单选
                isShowContact: true, //是否展示常用联系人
                isNeedSaveContact: true, //是否保存常用联系人
                extName: '员工', //多选时提示后缀名
                selectEmplList: selectEmplList, //打开窗口默认选中员工列表
                routerName: routerName,
                /*
                params:{ //支持可用扩展参数
                	"is_permissions":"0",
                	"is_process":"0",
                	"process_instance":'0',
                	"ext_param":"aa"
                },
                */
                sure: function (rd) { //返回数据，数组格式
                    $('#notify_list_div').removeClass('notify_list_active');
                    $scope.select_notify_id = '';
                    $scope.ess_my_approvalDC_data.notify_list = [];
                    for (var i = 0; i < rd.length; i++) {

                        $scope.select_notify_id = $scope.select_notify_id + rd[i].user_id;
                        $scope.ess_my_approvalDC_data.notify_list.push({
                            img: rd[i].img_src,
                            name: rd[i].empl_name,
                            user_id: rd[i].user_id,
                            employee_no: rd[i].empl_no,
                            flag: 1
                        });
                        if (i < rd.length - 1) {
                            $scope.select_notify_id += ',';
                        }
                    }

                    document.getElementById('notify_list_div').style.width = ($scope.ess_my_approvalDC_data.notify_list.length + 1) * 100 + 20 + 'px';
                    $ionicScrollDelegate.$getByHandle("notify_list_scroll").resize();
                }
            });

        }

        $scope.closeModal = function () {
            $scope.modal.hide();
            $scope.ess_empl_data = [];
            $scope.search_control.search_val = '';
        };
        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
        //$scope.applyReject = function(){
        //  essLvApDetailSev.applyReject($scope.select_user_id);
        //}
        //$scope.applyApprove = function(){
        //  essLvApDetailSev.applyApprove($scope.select_user_id);
        //}
        $scope.add_time = function () {
            if ($stateParams.is_normal_path == 'true') {
                $location.path('home_page/home_menulist/add_time_my_approval');
            } else {
                $location.path('home_page/add_time_my_approval_home_message');
            }


        }

        $scope.submitAction = function (action) {
            essMyApprovalDOTCSev.submitAction(action);
        }
        $scope.approval_date = [{
            key: '0',
            value: '批准'
        }, {
            key: '1',
            value: '驳回'
        }]
        $scope.remark_flag = true;
        $scope.approval_index = 0;
        $scope.approval_or_noapproval = function () {
            sideSelect.show({
                type: 'ios',
                data: $scope.approval_date,
                selectIndex: $scope.approval_index,
                selectedFunc: function (index) {
                    if (typeof (index) != 'undefined') {
                        document.getElementById("approval_answer").innerHTML = $scope.approval_date[index].value;
                        index == '0' ? $scope.remark_flag = true : $scope.remark_flag = false;
                        $scope.approval_index = index;
                    }

                }
            });
        }

        $scope.save = function () {
            if ($scope.remark_flag == false && document.getElementById('remark_textarea').value == '') {
                $ionicPopup.alert({
                    title: '提醒',
                    template: '<div style="text-align: center;">请填写备注</div>',
                    okText: '确定'
                })
            } else {
                if ($scope.remark_flag) {
                    essMyApprovalDOTCSev.applyApprove($scope.select_user_id, $scope.select_notify_id, my_app_result, $stateParams.from_source);
                } else {
                    essMyApprovalDOTCSev.applyReject($scope.select_user_id, $scope.select_notify_id, my_app_result, $stateParams.from_source);
                }
            }
        }
        $scope.first_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.first_in_need_clock = flag;
        };
        $scope.first_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.first_out_need_clock = flag;
        };
        $scope.second_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.second_in_need_clock = flag;
        };
        $scope.second_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.second_out_need_clock = flag;
        };
        $scope.ot_in_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.ot_in_need_clock = flag;
        };
        $scope.ot_out_need_clock_click = function (flag) {
            flag = !flag;
            $scope.ess_my_approvalDC_data.ot_out_need_clock = flag;
        };



    })

    .controller('addTimeModifyCtrl', function ($scope, essOtApplyModifySev, $ionicModal, $ionicActionSheet, $location, timeSelect) {
        $scope.dates_line2x = local_resource + 'img/model/dates-line2x.png';
        $scope.dates_line3x = local_resource + 'img/model/dates-line2x.png';
        $scope.add_approver = local_resource + 'img/model/add_approver.png';
        $scope.add_approver_ = local_resource + 'img/model/add_approver_.png';
        $scope.dates_line4x = local_resource + 'img/model/dates-line2x.png';
        $scope.img_upload_file_part1 = local_resource + 'img/icon/add.png';
        $scope.img_upload_file_part2 = local_resource + 'img/icon/new_2.png';
        $scope.contract_management_directory1 = local_resource + 'img/icon/contract_management_directory1.png';
        $scope.delete_icon = local_resource + 'img/icon/delete_icon.png';
        $scope.add_icon = local_resource + 'img/icon/add_icon.png';
        //essOtApplySev.loadData();
        $scope.ot_app_data = essOtApplyModifySev.getData();
        $scope.in_need_clock = function (flag, i) {
            flag = !flag;
            $scope.add_time_list[i].in_need_clock = flag;
        }
        $scope.out_need_clock = function (flag, i) {
            flag = !flag;
            $scope.add_time_list[i].out_need_clock = flag;
        }
        $scope.delete = function (item) {
            var idx = $scope.add_time_list.indexOf(item);
            $scope.add_time_list.splice(idx, 1);
        }
        $scope.add = function (item) {
            $scope.add_time_list.push({
                name: '',
                in: '00:00',
                in_need_clock: '',
                out: '00:00',
                out_need_clock: '',
                is_need: ''
            })
        }
        $scope.add_time_list = [];
        if ($scope.ot_app_data.is_need_first) {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.first_in,
                in_need_clock: $scope.ot_app_data.first_in_need_clock,
                out: $scope.ot_app_data.first_out,
                out_need_clock: $scope.ot_app_data.first_out_need_clock,
                is_need: $scope.ot_app_data.is_need_first
            })
        }
        if ($scope.ot_app_data.is_need_second) {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.second_in,
                in_need_clock: $scope.ot_app_data.second_in_need_clock,
                out: $scope.ot_app_data.second_out,
                out_need_clock: $scope.ot_app_data.second_out_need_clock,
                is_need: $scope.ot_app_data.is_need_second
            })
        }
        if ($scope.ot_app_data.is_need_ot) {
            $scope.add_time_list.push({
                name: '',
                in: $scope.ot_app_data.ot_in,
                in_need_clock: $scope.ot_app_data.ot_in_need_clock,
                out: $scope.ot_app_data.ot_out,
                out_need_clock: $scope.ot_app_data.ot_out_need_clock,
                is_need: $scope.ot_app_data.is_need_ot
            })
        }
        $scope.showTime_in = function (i) {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate: $scope.add_time_list[i].in,
                returnDateType: 'hm',
                returnTimeType: '24h' || 'AMPM',
                //stepping :10,
                selectedFunc: function (date) {
                    if (typeof (date) != 'undefined') {
                        $scope.add_time_list[i].in = date;
                    }
                }
            })
        }
        $scope.showTime_out = function (i) {
            timeSelect.show({
                type: 'time',
                startDate: '1993年12月01日',
                endDate: '',
                defaultDate