﻿angular.module('citymobi.services', [])

	.factory('$exceptionHandler', function () {
		return function (exception) {
			var _error_msg = '';

			_error_msg = exception.stack;
			//alert(_error_msg);
			$('.backdrop').removeClass('visible').removeClass('active').removeClass('backdrop-loading');
			$('.loading-container').removeClass('visible').removeClass('active');
			fufu_processing = false;
			fufu_show_loading = false;
			try {
				var device_cordova = '';
				var device_model = '';
				var device_platform = '';
				var device_uuid = '';
				var device_version = '';
				if (typeof (device) != 'undefined') {
					device_cordova = device.cordova;
					device_model = device.model;
					device_platform = device.cordova;
					device_uuid = device.platform;
					device_version = device.version;
				}
				$.ajax({
					type: "POST",
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveErrorLog',
					timeout: _var_timeout,
					data: {
						device_cordova: device_cordova,
						device_model: device_model,
						device_platform: device_platform,
						device_uuid: device_uuid,
						device_version: device_version,
						error_msg_key: 'angular_error',
						error_detail: _error_msg, //message + ' /// ' + url + ' /// ' + lineNumber,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					},
					success: function (data) {},
					error: function (data) {}
				});
			} catch (e) {}
		}
	})

	.factory('$deptComponentSer', [
		'$rootScope',
		'$timeout',
		'$location',
		'$q',
		'$stateParams',
		'$ionicHistory',
		function ($rootScope, $timeout, $location, $q, $stateParams, $ionicHistory) {
			var extend = angular.extend,
				forEach = angular.forEach;

			var activePersonnelObj = {
				length: 0
			}
			var historyBarArray = [];
			var historyBarObj = {};
			var opt = {};
			var o_data = [];
			var data = [];
			var routerPageConfig = {
				'default': 'deptComponentCtrlDefault',
				'message': 'deptComponentCtrlMessage',
				'at': 'deptComponentCtrlAt',
				'sign': 'deptComponentCtrlSign',
				'person': 'deptComponentCtrlPerson'
			}

			function postData() {
				var select_node_list = '';
				if (angular.isDefined(opt.selectNodeList) && opt.selectNodeList != '') {
					select_node_list = opt.selectNodeList + ',';
				}

				if (select_node_list != '') select_node_list = select_node_list.substring(0, select_node_list.length - 1);
				var param_data = angular.isDefined(opt.params) ? angular.copy(opt.params) : {};
				param_data.select_node_list = select_node_list;
				param_data._user_name = window.localStorage['_user_name'];
				param_data._pass_word = window.localStorage['_pass_word'];
				param_data._is_login = window.localStorage['_is_login'];
				param_data._notification_token = window.localStorage['_notification_token'];
				param_data._device_type = window.localStorage['_device_type'];
				var deferred = $q.defer();
				$.ajax({
					type: "GET",
					url: window.localStorage['_remote_server_addr'] + '?event=' + opt.url + '&_dc=' + new Date().getTime(),
					timeout: _var_timeout,
					data: param_data,
					success: function (_data) {

						o_data = $.parseJSON(_data);
						$timeout(function () {

							calsSelectNum(o_data);
							data[0] = angular.copy(o_data);
							deferred.resolve();
						}, 1000);
					},
					error: function (data) {

						deferred.reject();
					}
				});
				return deferred.promise;
			}


			function calsSelectNum(d) {
				for (var i = 0, len = d.length; i < len; i++) {
					d[i].iIndex = i;

					if (d[i].checked) {
						activePersonnelObj[d[i].id] = d[i];
						activePersonnelObj.length += 1;
					}
					if (d[i].children && d[i].children.length) {
						calsSelectNum(d[i].children)
					}
				}
			}

			return {
				open: function (options) {
					opt = extend({
						title: '选择部门',
						barTitle: '公司',
						isSingleSelect: false, //是否单选
						extName: '',
						isInherit: true, //是否选父带子
						isAllSelect: true,
						routerName: 'default',
						url: 'ionicAction.ionicAction.deptComponentData',
						// isSearch : true,
						// isAll : false,
						sure: function () {}
					}, options);
					historyBarArray = [];
					historyBarArray.push({
						title: opt.barTitle,
						id: -1,
						i: 0
					});

					$ionicHistory.clearCache().then(function () {
						$location.path('home_page/' + routerPageConfig[opt.routerName] + '/0');
					});

				},
				callback: function (item) {

					if (opt.isSingleSelect) {
						var a = [];
						a[0] = item;
						opt.sure(a);
					} else {
						var a = [],
							o = angular.copy(activePersonnelObj);
						delete o.length;
						angular.forEach(o, function (d, i, arr) {
							a.push(d)
						});

						opt.sure(a);
						$timeout(function () {
							activePersonnelObj = {
								length: 0
							}
						}, 100);
					}
				},
				clearActivePersonnel: function () {
					$timeout(function () {
						activePersonnelObj = {
							length: 0
						}
					}, 100);
				},
				addBar: function (t, id) {

				},
				pushBar: function (t, id) {

					var lastBar = historyBarArray[historyBarArray.length - 1];
					if (lastBar.id != id) {
						$timeout(function () {
							historyBarArray.push({
								title: t,
								id: id,
								i: historyBarArray.length
							});
						}, 200);
					}

				},
				popBar: function () {
					$timeout(function () {
						historyBarArray.pop();
					}, 20);
				},
				goBackBar: function (num) {
					historyBarArray = historyBarArray.slice(0, num);
				},
				getData: function () {
					return data
				},
				getOpt: function () {
					return opt
				},
				getHistoryBar: function () {
					return historyBarArray
				},
				getActiveNumber: function () {
					return activePersonnelObj
				},
				updateActive: function (id, state, item) {
					if (state && !activePersonnelObj[id]) {
						activePersonnelObj[id] = item;
						activePersonnelObj.length += 1;
					} else {
						delete activePersonnelObj[id]
						activePersonnelObj.length -= 1;
					}
				},
				postData: postData,
				getOData: function () {
					return o_data
				}
			}
		}
	])
	.factory('$emplComponentService', [
		'$rootScope',
		'$timeout',
		'$location',
		'$q',
		'$ionicHistory',
		function ($rootScope, $timeout, $location, $q, $ionicHistory) {
			var extend = angular.extend,
				forEach = angular.forEach;

			var activePersonnelObj = {
				length: 0
			}

			var historyBarArray = [];

			var historyBarObj = {};

			var opt = {};

			var data = {};

			var routerPageConfig = {
				'default': 'emplComponentCtrlDefault',
				'message': 'emplComponentCtrlMessage',
				'at': 'emplComponentCtrlAt',
				'sign': 'emplComponentCtrlSign',
				'person': 'emplComponentCtrlPerson'
			}

			function postData() {
				var deferred = $q.defer();

				var select_empl_list = '';
				if (angular.isDefined(opt.selectEmplList) && opt.selectEmplList != '') {
					select_empl_list = opt.selectEmplList + ',';
				}
				for (var p in activePersonnelObj) {
					if (p != 'length') {
						select_empl_list += p + ',';
					}
				}
				if (select_empl_list != '') select_empl_list = select_empl_list.substring(0, select_empl_list.length - 1);
				var param_data = angular.isDefined(opt.params) ? angular.copy(opt.params) : {};
				param_data.dept_id = historyBarArray[historyBarArray.length - 1].id;
				param_data.empl_no_list = select_empl_list;
				param_data._user_name = window.localStorage['_user_name'];
				param_data._pass_word = window.localStorage['_pass_word'];
				param_data._is_login = window.localStorage['_is_login'];
				param_data._notification_token = window.localStorage['_notification_token'];
				param_data._device_type = window.localStorage['_device_type'];
				$.ajax({
					type: "POST",
					url: window.localStorage['_remote_server_addr'] + '?event=' + opt.url + '&_dc=' + new Date().getTime(),
					data: param_data,
					timeout: _var_timeout,
					success: function (_data) {
						var json_data = $.parseJSON(_data);

						$timeout(function () {
							data = angular.copy(json_data);
							if ((param_data.dept_id == -1) && data.select_empl_list && data.select_empl_list.length) {
								forEach(data.select_empl_list, function (idata, index, array) {
									if (!activePersonnelObj[idata.empl_no]) {
										activePersonnelObj[idata.empl_no] = idata;
										activePersonnelObj.length += 1;
									}
								});
							}
							deferred.resolve();
						}, 500);
					},
					error: function (data) {
						deferred.reject();
					}
				});
				return deferred.promise;
			}

			return {
				open: function (options) {
					opt = extend({
						title: '选择员工',
						barTitle: '员工',
						isSingleSelect: false, //是否单选
						extName: '',
						isNeedSaveContact: false, //是否保存常用联系人
						isShowContact: false, //是否展示常用联系人
						routerName: 'default',
						url: 'ionicAction.ionicAction.emplComponentData',
						searUrl: 'ionicAction.ionicAction.searEmplComponentData',
						isSearch: true,
						sure: function () {}
					}, options);
					historyBarArray = [];
					historyBarArray.push({
						title: opt.barTitle,
						id: -1,
						i: 0
					});

					historyBarObj['-1'] = [{
						title: opt.barTitle,
						id: -1,
						i: 0
					}];
					$ionicHistory.clearCache().then(function () {
						$location.path('home_page/' + routerPageConfig[opt.routerName] + '/-1');
					});


				},
				callback: function (item) {
					if (opt.isNeedSaveContact && opt.isShowContact) {
						var select_employee_no_list = '';
						if (opt.isSingleSelect) {
							select_employee_no_list = item.empl_no;
						} else {
							angular.forEach(activePersonnelObj, function (d, i, arr) {
								if (angular.isDefined(d.empl_no)) {
									select_employee_no_list += d.empl_no + ',';
								}
							});
							if (select_employee_no_list != '') {
								select_employee_no_list = select_employee_no_list.substring(0, select_employee_no_list.length - 1);
							}
						}
						$.ajax({
							type: "POST",
							url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEmplCompContact&_dc=' + new Date().getTime(),
							timeout: _var_timeout,
							data: {
								select_employee_no_list: select_employee_no_list,
								_user_name: window.localStorage['_user_name'],
								_pass_word: window.localStorage['_pass_word'],
								_is_login: window.localStorage['_is_login'],
								_notification_token: window.localStorage['_notification_token'],
								_device_type: window.localStorage['_device_type']
							},
							success: function (_data) {},
							error: function (data) {}
						});
					}
					if (opt.isSingleSelect) {
						var a = [];
						a[0] = item;
						opt.sure(a);
					} else {
						var a = [],
							o = angular.copy(activePersonnelObj);
						delete o.length;
						angular.forEach(o, function (d, i, arr) {
							a.push(d)
						});
						opt.sure(a);
					};
					$timeout(function () {
						activePersonnelObj = {
							length: 0
						}
					}, 100);
				},
				clearActivePersonnel: function () {
					$timeout(function () {
						activePersonnelObj = {
							length: 0
						}
					}, 100);
				},
				addBar: function (t, id) {

				},
				pushBar: function (t, id) {
					var lastBar = historyBarArray[historyBarArray.length - 1];
					if (lastBar.id != id) {
						$timeout(function () {
							historyBarArray.push({
								title: t,
								id: id,
								i: historyBarArray.length
							});
						}, 200);
					}

				},
				popBar: function () {
					$timeout(function () {
						historyBarArray.pop();
					}, 20);
				},
				goBackBar: function (num) {
					historyBarArray = historyBarArray.slice(0, num);
				},
				getData: function () {
					return data
				},
				getOpt: function () {
					return opt
				},
				getHistoryBar: function () {
					return historyBarArray
				},
				getActiveNumber: function () {
					return activePersonnelObj
				},
				updateActive: function (id, state, item) {
					if (state && !activePersonnelObj[id]) {
						activePersonnelObj[id] = item;
						activePersonnelObj.length += 1;
					} else {
						delete activePersonnelObj[id]
						activePersonnelObj.length -= 1;
					}
				},
				postData: postData
			}
		}
	])

	.factory('$emplSearchComponent', [
		'$rootScope',
		'$ionicBody',
		'$compile',
		'$timeout',
		'$ionicPlatform',
		'$ionicTemplateLoader',
		'$$q',
		'$log',
		'$ionicClickBlock',
		'$window',
		'IONIC_BACK_PRIORITY',
		'$ionicScrollDelegate',
		'$emplComponentService',
		'$ionicHistory',
		function ($rootScope, $ionicBody, $compile, $timeout, $ionicPlatform, $ionicTemplateLoader, $$q, $log, $ionicClickBlock, $window, IONIC_BACK_PRIORITY, $ionicScrollDelegate, $emplComponentService, $ionicHistory) {

			var extend = angular.extend,
				forEach = angular.forEach,
				isDefined = angular.isDefined,
				isNumber = angular.isNumber,
				isString = angular.isString,
				jqLite = angular.element,
				noop = angular.noop;

			var ModalView = ionic.views.Modal.inherit({
				initialize: function (opts) {
					ionic.views.Modal.prototype.initialize.call(this, opts);
					this.animation = opts.animation || 'slide-in-up';
				},
				show: function (target) {
					var self = this;

					if (self.scope.$$destroyed) {
						$log.error('Cannot call ' + self.viewType + '.show() after remove(). Please create a new ' + self.viewType + ' instance.');
						return $$q.when();
					}

					$ionicClickBlock.show(600);
					stack.add(self);

					var modalEl = jqLite(self.modalEl);

					self.el.classList.remove('hide');
					$timeout(function () {
						if (!self._isShown) return;
						$ionicBody.addClass(self.viewType + '-open');
					}, 400, false);

					if (!self.el.parentElement) {
						modalEl.addClass(self.animation);
						$ionicBody.append(self.el);
					}

					var scrollCtrl = modalEl.data('$$ionicScrollController');
					scrollCtrl && scrollCtrl.resize();

					if (target && self.positionView) {
						self.positionView(target, modalEl);
						self._onWindowResize = function () {
							if (self._isShown) self.positionView(target, modalEl);
						};
						ionic.on('resize', self._onWindowResize, window);
					}

					modalEl.addClass('ng-enter active')
						.removeClass('ng-leave ng-leave-active');

					self._isShown = true;
					self._deregisterBackButton = $ionicPlatform.registerBackButtonAction(
						self.hardwareBackButtonClose ? angular.bind(self, self.hide) : noop,
						IONIC_BACK_PRIORITY.modal
					);

					ionic.views.Modal.prototype.show.call(self);

					$timeout(function () {
						if (!self._isShown) return;
						modalEl.addClass('ng-enter-active');
						ionic.trigger('resize');
						self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.shown', self);
						self.el.classList.add('active');
						self.scope.$broadcast('$ionicHeader.align');
						self.scope.$broadcast('$ionicFooter.align');
						self.scope.$broadcast('$ionic.modalPresented');
					}, 20);

					return $timeout(function () {
						if (!self._isShown) return;
						self.$el.on('touchmove', function (e) {
							//Don't allow scrolling while open by dragging on backdrop
							var isInScroll = ionic.DomUtil.getParentOrSelfWithClass(e.target, 'scroll');
							if (!isInScroll) {
								e.preventDefault();
							}
						});
						self.$el.on('click', function (e) {
							if (self.backdropClickToClose && e.target === self.el && stack.isHighest(self)) {
								self.hide();
							}
						});
						$(self.el).find('input').focus();
					}, 400);
				},
				hide: function (isHideCallBack) {
					var self = this;
					var modalEl = jqLite(self.modalEl);

					$ionicClickBlock.show(600);
					stack.remove(self);

					self.el.classList.remove('active');
					modalEl.addClass('ng-leave');

					$timeout(function () {
						if (self._isShown) return;
						modalEl.addClass('ng-leave-active')
							.removeClass('ng-enter ng-enter-active active');

						self.scope.$broadcast('$ionic.modalRemoved');
					}, 20, false);

					self.$el.off('click');
					self._isShown = false;
					self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.hidden', self);
					self._deregisterBackButton && self._deregisterBackButton();

					ionic.views.Modal.prototype.hide.call(self);

					// clean up event listeners
					if (self.positionView) {
						ionic.off('resize', self._onWindowResize, window);
					}

					return $timeout(function () {
						if (!modalStack.length) {
							$ionicBody.removeClass(self.viewType + '-open');
						}
						self.el.classList.add('hide');
						if (!isHideCallBack || (isHideCallBack && isHideCallBack != 'NotHideCallBack')) {
							self.hideCallback();
						}

						self.remove();
					}, self.hideDelay || 320);
				},

				remove: function () {
					var self = this,
						deferred, promise;
					self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.removed', self);

					if (self._isShown) {
						promise = self.hide();
					} else {
						deferred = $$q.defer();
						deferred.resolve();
						promise = deferred.promise;
					}

					return promise.then(function () {
						self.scope.$destroy();
						self.$el.remove();
					});
				},
				isShown: function () {
					return !!this._isShown;
				},
				setAnimation: function (className) {
					var self = this;
					var modalEl = jqLite(self.modalEl);

					var aniStr = self.animation;

					if ($(modalEl).hasClass(aniStr)) {
						$(modalEl).addClass(className).removeClass(aniStr);
						self.animation = className;
					} else {

					}
				}
			});

			var createModal = function (options) {
				// Create a new scope for the modal
				var scope = $rootScope.$new(true);


				options.viewType = options.viewType || 'modal';

				extend(scope, {
					$hasHeader: false,
					$hasSubheader: false,
					$hasFooter: false,
					$hasSubfooter: false,
					$hasTabs: false,
					$hasTabsTop: false
				});

				//创建 ion content 唯一 id 用来刷新

				scope.iconId = 's' + new Date().getTime();

				scope.iconEl = null;

				scope.contentStyle = {
					"margin-top": "70px"
				}

				scope.resizeIonContent = function () {
					if (scope.iconEl) {
						scope.iconEl.scrollTop();
					} else {
						for (var i in $ionicScrollDelegate._instances) {
							if ($ionicScrollDelegate._instances[i].$$delegateHandle == scope.iconId) {
								scope.iconEl = $ionicScrollDelegate._instances[i];
							}
						}

						if (scope.iconEl) {
							scope.iconEl.scrollTop();
						}
					}
				};

				var element = null;
				var isSearchStr = '';

				element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view style="background:#f8f8f8">' +
					'<div mobile-tree-box>' +
					'<ion-header-bar style="background: #53afff">' +
					'<div class="diyheaderBar selectDepartmentsTitle1" >' +
					'<button class="button button-clear" ng-click="closeModal()" style="color: white; font-size: 14px; position: absolute; right: 9px;line-height: 35px;">取消</button>' +
					'<h1 class="title" style="left: 5px;right: 44px;"><div style="background: white; height: 30px; border-radius: 3px;padding: 2px 8px; margin-top: 8px; position: relative" clear-value-box><i class="icon ion-ios-search-strong placeholder-icon" style="position: absolute; left: 9px; top: -7px"></i><input type="text" id="empl_search_i" clear-value-input ng-model="search_control.search_val" ng-keydown="empl_search_i_f($event)" placeholder="搜索姓名、工号、职位..." style="height: 26px;margin-left: 20px;width: 85%; padding: 0;line-height: 26px;"><div clear-value-btn ng-click="iconGoTop()" style="position: absolute; right: 1px; width:25px; font-size: 16px; margin-right: 2px; top: 3px;  height:24px;line-height: 24px; color: #cccccc;" id="loginUserBtn"></div></div></h1>' +
					'</div>' +
					'</ion-header-bar>' +
					'<div class="fixed_search_column empl_search_prompt ng-hide" ng-show="search_control.search_val" ng-click="search()" style="position:absolute;left:0;z-index:99999;">' +
					'<div><img ng-src="' + local_resource + 'img/search_img.png">' +
					'<div style="font-size: 17px;height: 30px;line-height: 30px; padding-left: 12px;position: relative;"><span style="padding-right: 8px">搜索</span><span style="color: #53afff;position: absolute;top: 0;bottom: 0;left: 53px;right: 59px;text-overflow: ellipsis;overflow: hidden;white-space: nowrap;" ng-bind="search_control.search_val"></span></div><div style="font-size: 14px;color: #999999;padding-left: 12px">姓名、工号、职位等</div></div>' +
					'</div>' +
					'<ion-content class="checkbox_mobile_content empl_search" ng-style="search_control.search_val?contentStyle:{}" delegate-handle="' +
					scope.iconId +
					'" has-bouncing="true">' +
					//on-scroll="ParallaxScroll()"
					//搜索结果为空
					'<div class="empl_search_void ng-hide" style="margin-top: 10px;" ng-show="searchState && (emplData && !emplData.length)" >' +
					'<div style="margin: 0 auto;display: table;"><img style="width: 16px;position: relative; top: 3px" ng-src="' + local_resource + 'img/cry.png" ><span style="padding-left: 5px; color: #a7a7a7; font-size: 15px">该员工不存在,您可换个关键词哦~</span></div>' +
					'</div>' +
					//default状态
					'<div class="empl_search_default ng-hide" ng-show="search_control.search_val==\'\' && ((emplData && !emplData.length) || !emplData)">' +
					'<img style="width: 143px; margin: 0 auto;display: block; padding-top: 70px" ng-src="' + local_resource + 'img/not_data.png" >' +
					'</div>' +
					//搜索结果有值
					'<ion-list style="padding-top: 10px;" class="mobile_tree_contact empl_search_list ng-hide" ng-show="searchState && (emplData && emplData.length)">' +
					'<ion-item collection-repeat="item in emplData" item-width="100%" class="item-avatar-left repair-flicker" href="javascript:;" ng-click="selectOption(item, true, true)">' +
					'<img ng-src="{{item.img_src}}" >' +
					'<label class="checkbox" style="padding: 24px 13px;" ng-click="stopPropagation($event)"><input type="checkbox" ng-model="item.checked" ng-checked="item.checked" ng-change="selectOption(item, true)" ng-click="stopPropagation($event)" class="ng-pristine ng-untouched ng-valid"></label>' +
					'<div style="color: #333333;font-size: 16px; line-height: 26px; line-height: 26px;padding-top: 10px;" > <span ng-bind="item.empl_name"></span> <span style="font-size: 12px; color: #666666; padding-left: 8px;">工号:{{item.staff_no}}</span></div>' +
					'<div class="b_l" style="color: #666666;font-size: 12px; padding-bottom: 13px;" ng-bind="item.pos_name"></div>' +
					'</ion-item>' +
					'</ion-list>' +
					'</div>' +
					'</ion-content>' +
					(!options.isSingleSelect ? ('<ion-footer-bar keyboard-attach class="bar-assertive mobile_tree_bottom_column" >' +
						'<span>已选择：<span ng-bind="actObj.length"></span>个' + (options.extName ? options.extName : '') + '</span>' +
						'<button on-tap="closeModal()" style="float: right">确定</button>' +
						'</ion-footer-bar>') : '') +
					'</div>' +
					'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);

				options.$el = element;
				options.el = element[0];
				options.modalEl = options.el.querySelector('.' + options.viewType);
				var modal = new ModalView(options);

				modal.scope = scope;

				// If this wasn't a defined scope, we can assign the viewType to the isolated scope
				// we created
				if (!options.scope) {
					scope[options.viewType] = modal;
				}



				scope.empl_search_i_f = function (ev) {
					if (ev.keyCode == 13 && scope.search_control.search_val && scope.search_control.search_val.length) {
						$(ev.target).blur();
						scope.search();
					}
				}



				scope.s_opt = $emplComponentService.getOpt();
				scope.historyBar = $emplComponentService.getHistoryBar();
				scope.searchState = false;
				scope.topSearchState = false;

				scope.iconGoTop = function () {
					if (scope.iconEl) {
						$timeout(function () {
							scope.iconEl.scrollTop();
						}, 150);
					} else {
						for (var i in $ionicScrollDelegate._instances) {
							if ($ionicScrollDelegate._instances[i].$$delegateHandle == scope.iconId) {
								scope.iconEl = $ionicScrollDelegate._instances[i];
							}
						}

						if (scope.iconEl) {
							$timeout(function () {
								scope.iconEl.scrollTop();
							}, 150);
						}
					}
				}

				// scope.ParallaxScroll = function(){
				//     if (scope.iconEl) {
				//         var iconElTop = scope.iconEl.getScrollPosition().top;
				//         if(iconElTop <= 0 && scope.topSearchState){
				//             $timeout(function () {
				//                 scope.topSearchState = false;
				//             },0);

				//         }else if(iconElTop > 0 && !scope.topSearchState){
				//             $timeout(function () {
				//                 scope.topSearchState = true;
				//             },0);
				//         }
				//     } else {
				//         for (var i in $ionicScrollDelegate._instances) {
				//             if ($ionicScrollDelegate._instances[i].$$delegateHandle == scope.iconId) {
				//                 scope.iconEl = $ionicScrollDelegate._instances[i];
				//             }
				//         }

				//         if (scope.iconEl) {
				//             var iconElTop = scope.iconEl.getScrollPosition().top;
				//             if(iconElTop <= 0 && scope.topSearchState){
				//                 $timeout(function () {
				//                     scope.topSearchState = false;
				//                 },0);

				//             }else if(iconElTop > 0 && !scope.topSearchState){
				//                 $timeout(function () {
				//                     scope.topSearchState = true;
				//                 },0);
				//             }
				//         }
				//     }
				// }

				scope.stopPropagation = function (ev) {
					ev.stopPropagation();
				}

				scope.selectOption = function (item, isContact, isA) {
					if (isA) {
						item.checked = !item.checked;
					}

					if (options.isSingleSelect) {
						//单选

						if (item.checked) {

							$emplComponentService.callback(item);
							$emplComponentService.goBackBar(0);
							$ionicHistory.goBack(-scope.historyBar.length);
							modal.setAnimation('slide-in-right');
							$timeout(function () {

								modal.hide('NotHideCallBack');
							}, 100);
						}

					} else {
						//多选

						var id = item.empl_no,
							state = item.checked;
						$emplComponentService.updateActive(id, state, item);
					}
				};


				scope.actObj = $emplComponentService.getActiveNumber();

				scope.emplData = [];

				scope.search = function () {

					var select_employee_no_list = '';
					var activePersonnelObj = angular.copy(scope.actObj);

					angular.forEach(activePersonnelObj, function (d, i, arr) {

						if (angular.isDefined(d.empl_no)) {
							select_employee_no_list += d.empl_no + ',';
						}
					});
					if (select_employee_no_list != '') {
						select_employee_no_list = select_employee_no_list.substring(0, select_employee_no_list.length - 1);
					}
					$rootScope.showLoading();

					var postData = {
						select_employee_no_list: select_employee_no_list,
						filter_str: scope.search_control.search_val,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					};
					if (options.params) {
						for (var key in options.params) {
							postData[key] = options.params[key];
						}
					}

					$.ajax({
						type: "GET",
						url: window.localStorage['_remote_server_addr'] + '?event=' + scope.s_opt.searUrl + '&_dc=' + new Date().getTime(),
						data: postData,
						timeout: _var_timeout,
						success: function (_data) {
							$rootScope.hideLoading();
							var json_data = $.parseJSON(_data);
							$timeout(function () {

								scope.emplData = angular.copy(json_data);
								scope.searchState = true;
								//重新计算content高度
								if (scope.iconEl) {
									$timeout(function () {
										scope.iconEl.resize();
									}, 300);
								} else {
									for (var i in $ionicScrollDelegate._instances) {
										if ($ionicScrollDelegate._instances[i].$$delegateHandle == scope.iconId) {
											scope.iconEl = $ionicScrollDelegate._instances[i];
										}
									}
									if (scope.iconEl) {
										$timeout(function () {
											scope.iconEl.resize();
										}, 300);
									}
								}
							}, 300);
						},
						error: function (data) {
							$rootScope.hideLoading();
						}
					});
				};

				scope.search_control = {
					search_val: ''
				};

				scope.$watch('search_control.search_val', function (newValue, oldValue, scope) {
					if (newValue != '') {

					} else {
						scope.searchState = false;
						scope.emplData = [];
						scope.iconGoTop();
					}
				})


				scope.closeModal = function () {
					modal.hide();


					options.sure && options.sure([1]);
				};

				return modal;
			};

			var modalStack = [];
			var stack = {
				add: function (modal) {
					modalStack.push(modal);
				},
				remove: function (modal) {
					var index = modalStack.indexOf(modal);
					if (index > -1 && index < modalStack.length) {
						modalStack.splice(index, 1);
					}
				},
				isHighest: function (modal) {
					var index = modalStack.indexOf(modal);
					return (index > -1 && index === modalStack.length - 1);
				}
			};

			return {
				/**
				 * @ngdoc method
				 * @name $ionicModal#fromTemplate
				 * @param {string} templateString The template string to use as the modal's
				 * content.
				 * @param {object} options Options to be passed {@link ionic.controller:ionicModal#initialize ionicModal#initialize} method.
				 * @returns {object} An instance of an {@link ionic.controller:ionicModal}
				 * controller.
				 */
				init: function (options) {
					var modal = createModal(options);
					return modal
				},
				stack: stack
			};
		}
	])
	.factory('httpRequestInterceptor', function ($rootScope) {
		return {
			request: function (config) {
				if (config.url.indexOf('templates/') != -1 && config.url.indexOf('.html') != -1) {
					if (config.url.indexOf('www/') != -1) {
						config.url = config.url + '?dt=' + new Date().getTime();
					} else {
						config.url = local_resource + config.url + '?dt=' + new Date().getTime();
					}
				}
				return config;
			}
		};
	})


	.factory('$selectDepartments', [
		'$rootScope',
		'$ionicBody',
		'$compile',
		'$timeout',
		'$ionicPlatform',
		'$ionicTemplateLoader',
		'$$q',
		'$log',
		'$ionicClickBlock',
		'$window',
		'IONIC_BACK_PRIORITY',
		'$ionicScrollDelegate',
		function ($rootScope, $ionicBody, $compile, $timeout, $ionicPlatform, $ionicTemplateLoader, $$q, $log, $ionicClickBlock, $window, IONIC_BACK_PRIORITY, $ionicScrollDelegate) {

			var extend = angular.extend,
				forEach = angular.forEach,
				isDefined = angular.isDefined,
				isNumber = angular.isNumber,
				isString = angular.isString,
				jqLite = angular.element,
				noop = angular.noop;

			var ModalView = ionic.views.Modal.inherit({
				/**
				 * @ngdoc method
				 * @name ionicModal#initialize
				 * @description Creates a new modal controller instance.
				 * @param {object} options An options object with the following properties:
				 *  - `{object=}` `scope` The scope to be a child of.
				 *    Default: creates a child of $rootScope.
				 *  - `{string=}` `animation` The animation to show & hide with.
				 *    Default: 'slide-in-up'
				 *  - `{boolean=}` `focusFirstInput` Whether to autofocus the first input of
				 *    the modal when shown. Will only show the keyboard on iOS, to force the keyboard to show
				 *    on Android, please use the [Ionic keyboard plugin](https://github.com/driftyco/ionic-plugin-keyboard#keyboardshow).
				 *    Default: false.
				 *  - `{boolean=}` `backdropClickToClose` Whether to close the modal on clicking the backdrop.
				 *    Default: true.
				 *  - `{boolean=}` `hardwareBackButtonClose` Whether the modal can be closed using the hardware
				 *    back button on Android and similar devices.  Default: true.
				 */
				initialize: function (opts) {
					ionic.views.Modal.prototype.initialize.call(this, opts);
					this.animation = opts.animation || 'slide-in-up';
				},

				/**
				 * @ngdoc method
				 * @name ionicModal#show
				 * @description Show this modal instance.
				 * @returns {promise} A promise which is resolved when the modal is finished animating in.
				 */
				show: function (target) {
					var self = this;

					if (self.scope.$$destroyed) {
						$log.error('Cannot call ' + self.viewType + '.show() after remove(). Please create a new ' + self.viewType + ' instance.');
						return $$q.when();
					}

					// on iOS, clicks will sometimes bleed through/ghost click on underlying
					// elements
					$ionicClickBlock.show(600);
					stack.add(self);

					var modalEl = jqLite(self.modalEl);

					self.el.classList.remove('hide');
					$timeout(function () {
						if (!self._isShown) return;
						$ionicBody.addClass(self.viewType + '-open');
					}, 400, false);

					if (!self.el.parentElement) {
						modalEl.addClass(self.animation);
						$ionicBody.append(self.el);
					}

					// if modal was closed while the keyboard was up, reset scroll view on
					// next show since we can only resize it once it's visible
					var scrollCtrl = modalEl.data('$$ionicScrollController');
					scrollCtrl && scrollCtrl.resize();

					if (target && self.positionView) {
						self.positionView(target, modalEl);
						// set up a listener for in case the window size changes

						self._onWindowResize = function () {
							if (self._isShown) self.positionView(target, modalEl);
						};
						ionic.on('resize', self._onWindowResize, window);
					}

					modalEl.addClass('ng-enter active')
						.removeClass('ng-leave ng-leave-active');

					self._isShown = true;
					self._deregisterBackButton = $ionicPlatform.registerBackButtonAction(
						self.hardwareBackButtonClose ? angular.bind(self, self.hide) : noop,
						IONIC_BACK_PRIORITY.modal
					);

					ionic.views.Modal.prototype.show.call(self);

					$timeout(function () {
						if (!self._isShown) return;
						modalEl.addClass('ng-enter-active');
						ionic.trigger('resize');
						self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.shown', self);
						self.el.classList.add('active');
						self.scope.$broadcast('$ionicHeader.align');
						self.scope.$broadcast('$ionicFooter.align');
						self.scope.$broadcast('$ionic.modalPresented');
					}, 20);

					return $timeout(function () {
						if (!self._isShown) return;
						self.$el.on('touchmove', function (e) {
							//Don't allow scrolling while open by dragging on backdrop
							var isInScroll = ionic.DomUtil.getParentOrSelfWithClass(e.target, 'scroll');
							if (!isInScroll) {
								e.preventDefault();
							}
						});
						//After animating in, allow hide on backdrop click
						self.$el.on('click', function (e) {
							if (self.backdropClickToClose && e.target === self.el && stack.isHighest(self)) {
								self.hide();
							}
						});

						// self.scope.resetConfig();
					}, 400);
				},

				/**
				 * @ngdoc method
				 * @name ionicModal#hide
				 * @description Hide this modal instance.
				 * @returns {promise} A promise which is resolved when the modal is finished animating out.
				 */
				hide: function () {
					var self = this;
					var modalEl = jqLite(self.modalEl);

					// on iOS, clicks will sometimes bleed through/ghost click on underlying
					// elements
					$ionicClickBlock.show(600);
					stack.remove(self);

					self.el.classList.remove('active');
					modalEl.addClass('ng-leave');

					$timeout(function () {
						if (self._isShown) return;
						modalEl.addClass('ng-leave-active')
							.removeClass('ng-enter ng-enter-active active');

						self.scope.$broadcast('$ionic.modalRemoved');
					}, 20, false);

					self.$el.off('click');
					self._isShown = false;
					self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.hidden', self);
					self._deregisterBackButton && self._deregisterBackButton();

					ionic.views.Modal.prototype.hide.call(self);

					// clean up event listeners
					if (self.positionView) {
						ionic.off('resize', self._onWindowResize, window);
					}

					return $timeout(function () {
						if (!modalStack.length) {
							$ionicBody.removeClass(self.viewType + '-open');
						}
						self.el.classList.add('hide');
						self.scope.resetConfig();
						self.scope.resizeIonContent();

					}, self.hideDelay || 320);
				},

				/**
				 * @ngdoc method
				 * @name ionicModal#remove
				 * @description Remove this modal instance from the DOM and clean up.
				 * @returns {promise} A promise which is resolved when the modal is finished animating out.
				 */
				remove: function () {
					var self = this,
						deferred, promise;
					self.scope.$parent && self.scope.$parent.$broadcast(self.viewType + '.removed', self);

					// Only hide modal, when it is actually shown!
					// The hide function shows a click-block-div for a split second, because on iOS,
					// clicks will sometimes bleed through/ghost click on underlying elements.
					// However, this will make the app unresponsive for short amount of time.
					// We don't want that, if the modal window is already hidden.
					if (self._isShown) {
						promise = self.hide();
					} else {
						deferred = $$q.defer();
						deferred.resolve();
						promise = deferred.promise;
					}

					return promise.then(function () {
						self.scope.$destroy();
						self.$el.remove();
					});
				},

				/**
				 * @ngdoc method
				 * @name ionicModal#isShown
				 * @returns boolean Whether this modal is currently shown.
				 */
				isShown: function () {
					return !!this._isShown;
				}
			});

			var createModal = function (options) {
				// Create a new scope for the modal
				var scope = $rootScope.$new(true);


				options.viewType = options.viewType || 'modal';

				extend(scope, {
					$hasHeader: false,
					$hasSubheader: false,
					$hasFooter: false,
					$hasSubfooter: false,
					$hasTabs: false,
					$hasTabsTop: false
				});

				// Compile the template
				scope.treeData = options.data;

				scope.allSelectTreeData = angular.copy(options.data);

				scope.emptySelect = angular.copy(options.data);

				scope.selectedTotal = 0;

				scope.treeTotalNum = 0;


				for (var i = 0, len = scope.treeData.length; i < len; i++) {
					if (scope.treeData[i].is_checked) {
						scope.selectedTotal += 1;
					}
					scope.treeTotalNum += 1;
					scope.treeData[i].is_show = true;
					scope.allSelectTreeData[i].is_checked = true;
					scope.allSelectTreeData[i].is_show = true;
					scope.emptySelect[i].is_show = true;
					scope.emptySelect[i].is_checked = false;


					if (scope.treeData[i].children && scope.treeData[i].children.length) {
						scope.treeData[i].is_show_children = true;
						scope.allSelectTreeData[i].is_show_children = true;
						scope.emptySelect[i].is_show_children = true;

						for (var ii = 0, len2 = scope.treeData[i].children.length; ii < len2; ii++) {
							if (scope.treeData[i].children[ii].is_checked) {
								scope.selectedTotal += 1;
							}
							scope.allSelectTreeData[i].children[ii].is_checked = true;
							scope.emptySelect[i].children[ii].is_checked = false;
							scope.treeTotalNum += 1;

							scope.treeData[i].children[ii].is_show = true;
							scope.allSelectTreeData[i].children[ii].is_show = true;
							scope.emptySelect[i].children[ii].is_show = true;
						}

					}
				}

				//是否隐藏搜索
				scope.isSearchState = false;

				scope.toggleSearchState = function () {
					$timeout(function () {
						scope.isSearchState = !scope.isSearchState;
					}, 300);
				};

				//创建 ion content 唯一 id 用来刷新

				scope.iconId = 's' + new Date().getTime();

				scope.iconEl = null;

				scope.resizeIonContent = function () {
					if (scope.iconEl) {
						scope.iconEl.scrollTop();
					} else {
						for (var i in $ionicScrollDelegate._instances) {
							if ($ionicScrollDelegate._instances[i].$$delegateHandle == scope.iconId) {
								scope.iconEl = $ionicScrollDelegate._instances[i];
							}
						}

						if (scope.iconEl) {
							scope.iconEl.scrollTop();
						}
					}
				};

				//全选不全选触发修改
				scope.isAllSelect = true;

				// scope.isSearchStyle = {
				//     true : {
				//         'font-size': '20px !important',
				//         'position' : 'absolute',
				//         'right' : '33px'
				//     },
				//     false : {
				//         'font-size': '20px !important',
				//         'position' : 'absolute',
				//         'right' : '50px'
				//     }
				// }

				scope.allSelectState = function (state) {
					//console.log(state);
					if (state) {
						scope.isAllSelect = !scope.isAllSelect;
						scope.$apply();
					} else {
						$timeout(function () {
							scope.isAllSelect = !scope.isAllSelect;
						}, 0)
					}

				};




				//单选模式 还是 多选模式

				var element = null;

				if (options.isSingleSelect === undefined || options.isSingleSelect == false) {
					//多选模式


					//是否显示全选
					var isAllSelectStr = '',
						isSearchStr = '';

					if (options.isAllSelect == false &&
						options.isSearch == false) {
						//没有圈选 也没有搜索

						element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view>' +
							'<div mobile-tree-box>' +
							'<ion-header-bar style="background: #53afff">' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="!isSearchState">' +
							'<button class="button button-clear" ng-click="closeModal2()" style="color: white; font-size: 14px">关闭</button>' +
							'<h1 class="title" style="color: white; font-size: 14px">' +
							options.barTitle +
							'</h1>' +
							'</div>' +
							'</ion-header-bar>' +
							'<ion-content class="checkbox_mobile_content" delegate-handle="' +
							scope.iconId +
							'">' +
							'<div class="mobile_tree_second_level_title">' +
							options.title +
							'</div>' +
							'<mobile-tree></mobile-tree>' +
							'</ion-content>' +
							'<div class="mobile_tree_bottom_column">' +
							'<span>已选择：<mobile-tree-select-total></mobile-tree-select-total>&nbsp;个' + (options.extName ? options.extName : '') + '</span>' +
							'<button on-tap="closeModal()" style="float: right">确定</button>' +
							'</div>' +
							'</div>' +
							'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);
					}

					if ((options.isAllSelect === undefined || options.isAllSelect == true) &&
						(options.isSearch === undefined || options.isSearch == true)) {
						element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view>' +
							'<div mobile-tree-box>' +
							'<ion-header-bar style="background: #53afff">' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="!isSearchState">' +
							'<button class="button button-clear" ng-click="closeModal2()" style="color: white; font-size: 14px">关闭</button>' +
							'<h1 class="title" style="color: white; font-size: 14px">' +
							options.barTitle +
							'</h1>' +
							'<i class="ion-ios-search-strong button back-button buttons button-clear button-light ion-ios-arrow-left header-item" ng-click="toggleSearchState()" style="font-size:20px !important; position: absolute; right: 50px; padding-left: 10px"></i>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-select-tree ng-show="isAllSelect" ng-click="isAllSelect = !isAllSelect">全选</button>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-not-select-tree ng-show="!isAllSelect" ng-click="isAllSelect = !isAllSelect">全不选</button>' +
							'</div>' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="isSearchState">' +
							'<button class="button button-clear" ng-click="toggleSearchState()" style="color: white; font-size: 14px; position: absolute; left: 5px">取消</button>' +
							'<h1 class="title" style="left: 44px;right: 44px;"><div style="background: white; height: 28px; border-radius: 3px;padding: 0 8px; margin-top: 9px; position: relative"><i class="icon ion-ios-search-strong placeholder-icon" style="position: absolute; left: 9px; top: -6px"></i><mobile-search></mobile-search></div></h1>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-select-tree ng-show="isAllSelect" ng-click="isAllSelect = !isAllSelect">全选</button>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-not-select-tree ng-show="!isAllSelect" ng-click="isAllSelect = !isAllSelect">全不选</button>' +
							'</div>' +
							'</ion-header-bar>' +
							'<ion-content class="checkbox_mobile_content" delegate-handle="' +
							scope.iconId +
							'">' +
							'<div class="mobile_tree_second_level_title">' +
							options.title +
							'</div>' +
							'<mobile-tree></mobile-tree>' +
							'</ion-content>' +
							'<div class="mobile_tree_bottom_column">' +
							'<span>已选择：<mobile-tree-select-total></mobile-tree-select-total>&nbsp;个' + (options.extName ? options.extName : '') + '</span>' +
							'<button on-tap="closeModal()" style="float: right">确定</button>' +
							'</div>' +
							'</div>' +
							'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);
					}

					if ((options.isAllSelect === undefined || options.isAllSelect == true) &&
						options.isSearch == false) {
						element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view>' +
							'<div mobile-tree-box>' +
							'<ion-header-bar style="background: #53afff">' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="!isSearchState">' +
							'<button class="button button-clear" ng-click="closeModal2()" style="color: white; font-size: 14px">关闭</button>' +
							'<h1 class="title" style="color: white; font-size: 14px">' +
							options.barTitle +
							'</h1>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-select-tree ng-show="isAllSelect" ng-click="isAllSelect = !isAllSelect">全选</button>' +
							'<button class="button button-clear" style="color: white; font-size: 14px; position: absolute; right: 5px;" all-not-select-tree ng-show="!isAllSelect" ng-click="isAllSelect = !isAllSelect">全不选</button>' +
							'</div>' +
							'</ion-header-bar>' +
							'<ion-content class="checkbox_mobile_content" delegate-handle="' +
							scope.iconId +
							'">' +
							'<div class="mobile_tree_second_level_title">' +
							options.title +
							'</div>' +
							'<mobile-tree></mobile-tree>' +
							'</ion-content>' +
							'<div class="mobile_tree_bottom_column">' +
							'<span>已选择：<mobile-tree-select-total></mobile-tree-select-total>&nbsp;个' + (options.extName ? options.extName : '') + '</span>' +
							'<button on-tap="closeModal()" style="float: right">确定</button>' +
							'</div>' +
							'</div>' +
							'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);
					}

					if ((options.isSearch === undefined || options.isSearch == true) &&
						options.isAllSelect == false) {
						element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view>' +
							'<div mobile-tree-box>' +
							'<ion-header-bar style="background: #53afff">' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="!isSearchState">' +
							'<button class="button button-clear" ng-click="closeModal2()" style="color: white; font-size: 14px">关闭</button>' +
							'<h1 class="title" style="color: white; font-size: 14px">' +
							options.barTitle +
							'</h1>' +
							'<i class="ion-ios-search-strong button back-button buttons button-clear button-light ion-ios-arrow-left header-item" ng-click="toggleSearchState()" style="font-size:20px !important; position: absolute; right: 5px; padding-left: 10px"></i>' +
							'</div>' +
							'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="isSearchState">' +
							'<button class="button button-clear" ng-click="toggleSearchState()" style="color: white; font-size: 14px; position: absolute; right: 5px">取消</button>' +
							'<h1 class="title" style="left: 5px;right: 44px;"><div style="background: white; height: 28px; border-radius: 3px;padding: 0 8px; margin-top: 9px; position: relative"><i class="icon ion-ios-search-strong placeholder-icon" style="position: absolute; left: 9px; top: -6px"></i><mobile-search></mobile-search></div></h1>' +
							'</div>' +
							'</ion-header-bar>' +
							'<ion-content class="checkbox_mobile_content" delegate-handle="' +
							scope.iconId +
							'">' +
							'<div class="mobile_tree_second_level_title">' +
							options.title +
							'</div>' +
							'<mobile-tree></mobile-tree>' +
							'</ion-content>' +
							'<div class="mobile_tree_bottom_column">' +
							'<span>已选择：<mobile-tree-select-total></mobile-tree-select-total>&nbsp;个' + (options.extName ? options.extName : '') + '</span>' +
							'<button on-tap="closeModal()" style="float: right">确定</button>' +
							'</div>' +
							'</div>' +
							'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);
					}



				} else if (options.isSingleSelect == true) {
					//单选模式

					scope.mode = 'single';

					element = $compile('<ion-' + options.viewType + '>' + '<ion-modal-view>' +
						'<div mobile-tree-box>' +
						'<ion-header-bar style="background: #53afff">' +
						'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="!isSearchState">' +
						'<button class="button button-clear" style="color: white; font-size: 14px" on-tap="closeModal()">关闭</button>' +
						'<h1 class="title" style="color: white; font-size: 14px">' +
						options.barTitle +
						'</h1>' +
						((options.isSearch == false) ? '' : '<i class="ion-ios-search-strong button back-button buttons button-clear button-light ion-ios-arrow-left header-item" ng-click="toggleSearchState()" style="font-size:20px !important; position: absolute; right: 5px"></i>') +
						'</div>' +
						'<div class="diyheaderBar selectDepartmentsTitle1" ng-show="isSearchState">' +

						'<h1 class="title" style="left: 5px;right: 44px;"><div style="background: white; height: 28px; border-radius: 3px;padding: 0 8px; margin-top: 9px; position: relative"><i class="icon ion-ios-search-strong placeholder-icon" style="position: absolute; left: 9px; top: -6px"></i><mobile-search></mobile-search></div></h1>' +
						'<button class="button button-clear" style="color: white; font-size: 14px" ng-click="toggleSearchState()">取消</button>' +
						'</div>' +
						'</ion-header-bar>' +
						'<ion-content delegate-handle="' +
						scope.iconId +
						'">' +
						'<div class="mobile_tree_second_level_title">' +
						options.title +
						'</div>' +
						'<mobile-tree mode="single"></mobile-tree>' +
						'</ion-content>' +
						'</div>' +
						'</ion-modal-view>' + '</ion-' + options.viewType + '>')(scope);


				}


				options.$el = element;
				options.el = element[0];
				options.modalEl = options.el.querySelector('.' + options.viewType);
				var modal = new ModalView(options);

				modal.scope = scope;

				// If this wasn't a defined scope, we can assign the viewType to the isolated scope
				// we created
				if (!options.scope) {
					scope[options.viewType] = modal;
				}

				scope.resetConfig = function () {

					scope.isSearchState = false;
					scope.$$childTail.$$childTail.$$childTail.clearTreeFilterStr();
					scope.$$childTail.$$childTail.clearSearchStr && scope.$$childTail.$$childTail.clearSearchStr();
				};

				scope.closeModal2 = function () {

					modal.hide();
				};

				scope.closeModal = function () {
					modal.hide();
					// var selectTreeData = selectDepartmentsScope.$$childTail.$$childTail.data;
					// console.log(scope);
					var returnArray = [];
					var curData = scope.$$childTail.$$childTail.$$childTail.data;
					for (var i = 0, len = curData.length; i < len; i++) {
						if (curData[i].is_checked) {
							returnArray.push(curData[i]);
						}
						if (curData[i].children && curData[i].children.length) {
							for (var ii = 0, lens = curData[i].children.length; ii < lens; ii++) {
								if (curData[i].children[ii].is_checked) {
									returnArray.push(curData[i].children[ii]);
								}
							}
						}
					}


					options.sure && options.sure(returnArray);
				};

				return modal;
			};

			var modalStack = [];
			var stack = {
				add: function (modal) {
					modalStack.push(modal);
				},
				remove: function (modal) {
					var index = modalStack.indexOf(modal);
					if (index > -1 && index < modalStack.length) {
						modalStack.splice(index, 1);
					}
				},
				isHighest: function (modal) {
					var index = modalStack.indexOf(modal);
					return (index > -1 && index === modalStack.length - 1);
				}
			};

			return {
				/**
				 * @ngdoc method
				 * @name $ionicModal#fromTemplate
				 * @param {string} templateString The template string to use as the modal's
				 * content.
				 * @param {object} options Options to be passed {@link ionic.controller:ionicModal#initialize ionicModal#initialize} method.
				 * @returns {object} An instance of an {@link ionic.controller:ionicModal}
				 * controller.
				 */
				init: function (options) {
					var modal = createModal(options);
					return modal
				},

				stack: stack
			};
		}
	])


	.factory('Slide', ['$rootScope', '$ionicBackdrop', '$timeout', function ($rootScope, $ionicBackdrop, $timeout) {

		function Slide(elementId, dataList, index) {
			this.elementId = elementId;
			this.dataList = dataList;
			this.activeIndex = index;
			this.oldActiveIndex = null;
			this.isToNewPage = false;
			this.slideItemPageWidth = window.screen.availWidth;
			// this.slideItemPageHeight = window.screen.availHeight;
			this.slideItemPageHeight = document.body.scrollHeight;
			this.slideBoxPos = -(this.activeIndex * this.slideItemPageWidth);
			this.limit = this.slideItemPageWidth * 0.005;
			this.slideState = true;
			this.slideItemAttr = [];
			this.fingers = true;
			this.state = false;
			this.loadingState = false;
			this.loadingMaskPos = 0;

			// this.testIndex =0;

			this.init();
		}


		Slide.prototype.init = function () {

			var that = this;
			that.slide = document.getElementById(that.elementId);
			that.slideBox = that.slide.getElementsByTagName('div')[0];
			this.slideIndicator = $('.fufu-slider-indicator');
			this.loadingMask = $('.zoomSliderLoadingMask');

			that.setSlideBoxTranfrom();

			//创建touch事件
			that.cretaTouchEvent();

			//创建Loading事件
			that.createImageLoadingEvent();

			//绑定事件
			that.bindTouchEvent();

			//先展示要的图片
			that.imageLoadState(1);
			that.showImage();

			//展示Slide
			that.show();
		}

		Slide.prototype.show = function () {
			var that = this;
			document.getElementsByClassName('backdrop')[0].style.backgroundColor = 'rgba(0,0,0,1)';
			$ionicBackdrop.retain();

			$(that.slide).addClass('active');

			that.state = true;
		}

		//展示 或者 隐藏 Load 效果, 参数 true || false

		Slide.prototype.imageLoadState = function (state) {
			var that = this;
			if (state) {
				$(that.slide).addClass('loadImage');
			} else {
				$(that.slide).removeClass("loadImage");
			}

			if (state && !that.loadingState) {

				that.loadingState = true;
			} else if (!state && that.loadingState) {

				that.loadingState = false;
				that.loadingMaskPos = 0;
				// that.loadingMask[0].style.webkitTransform = 'translate('+ that.loadingMaskPos +'px,0)';
			}
		}


		Slide.prototype.restoreImage = function () {
			var that = this;

			//修复滑动之前的旧图片的位置，没有数据即不修复

			var activeindex = that.oldActiveIndex;

			//计算位置
			if (that.slideItemAttr[activeindex]) {
				var ratioResult = that.imageWHRatio(activeindex);

				//设置大小
				that.slideItemAttr[activeindex].target.style.width = that.slideItemAttr[activeindex].baseWidth + 'px';
				that.slideItemAttr[activeindex].target.style.height = that.slideItemAttr[activeindex].baseHeight + 'px';

				that.slideItemAttr[activeindex].nowWidth = that.slideItemAttr[activeindex].baseWidth;
				that.slideItemAttr[activeindex].nowHeight = that.slideItemAttr[activeindex].baseHeight;

				var x,
					y;

				if (ratioResult.direction == 'width') {
					x = 0;
					y = (that.slideItemPageHeight - that.slideItemAttr[activeindex].baseHeight) / 2;
				} else {
					x = (that.slideItemPageWidth - that.slideItemAttr[activeindex].baseWidth) / 2;
					y = 0;
				}

				that.slideItemAttr[activeindex].sPosX = x;
				that.slideItemAttr[activeindex].sPosY = y;

				that.slideItemAttr[activeindex].posX = x;
				that.slideItemAttr[activeindex].posY = y;

				//设置位置
				that.setImagePos(x, y, activeindex);
			}


		}


		Slide.prototype.showImage = function () {
			var that = this;

			that.slideIndicator.find('.fufu-slider-indicator-active').removeClass('fufu-slider-indicator-active');

			that.slideIndicator.find('li').eq(that.activeIndex).addClass('fufu-slider-indicator-active');

			if (that.slideItemAttr[that.activeIndex]) {
				//console.log('缓存的图片数据');


				that.imageLoadState();
			} else {
				//console.log('第一次加载图片');
				//展示Load效果

				// that.imageLoadState(1);

				//Load图片
				// if(that.testIndex){
				//       that.loadImage(that.activeIndex);
				// }else{
				//     setTimeout(function(){
				//         console.log('ccccc');
				//         that.loadImage(that.activeIndex);
				//     },5000);
				// }
				that.loadImage(that.activeIndex);

			}
		}

		//Load Image, 参数1 图片索引, 参数2 回调函数

		Slide.prototype.loadImage = function (activeindex, callback) {
			var that = this;

			var img = that.slideBox.getElementsByTagName('img')[activeindex];


			//异步
			img.addEventListener('load', that.LoadEvent.img(activeindex, function (loadFunc) {

				that.imageLoadState();

				//隐藏
				img.removeEventListener('load', loadFunc);

				//展示动作


				//计算位置

				var ratioResult = that.imageWHRatio(activeindex);

				//设置大小

				that.slideItemAttr[activeindex].target.style[ratioResult.direction] = (ratioResult.direction == 'width') ? that.slideItemPageWidth + 'px' : that.slideItemPageHeight + 'px';

				that.slideItemAttr[activeindex].nowWidth = that.slideItemAttr[activeindex].target.offsetWidth;
				that.slideItemAttr[activeindex].nowHeight = that.slideItemAttr[activeindex].target.offsetHeight;
				that.slideItemAttr[activeindex].baseWidth = that.slideItemAttr[activeindex].target.offsetWidth;
				that.slideItemAttr[activeindex].baseHeight = that.slideItemAttr[activeindex].target.offsetHeight;
				var x,
					y;

				if (ratioResult.direction == 'width') {
					x = 0;
					y = (that.slideItemPageHeight - that.slideItemAttr[activeindex].baseHeight) / 2;
				} else {
					x = (that.slideItemPageWidth - that.slideItemAttr[activeindex].baseWidth) / 2;
					y = 0;
				}

				that.slideItemAttr[activeindex].sPosX = x;
				that.slideItemAttr[activeindex].sPosY = y;

				that.slideItemAttr[activeindex].posX = x;
				that.slideItemAttr[activeindex].posY = y;

				//设置位置
				that.setImagePos(x, y, activeindex);
			}), false);

			var loadEventError = function () {
				img.removeEventListener('error', loadEventError);
				img.src = 'img/fail.png'
			};

			img.addEventListener('error', loadEventError, false);

			img.src = img.getAttribute('delay-src');
		}



		Slide.prototype.setImagePos = function (x, y, activeindex, time) {
			var that = this;

			that.slideItemAttr[activeindex].posX = x;
			that.slideItemAttr[activeindex].posY = y;


			that.slideItemAttr[activeindex].target.style.webkitTransition = (time) ? 'all ' + time : 'all 0s';
			that.slideItemAttr[activeindex].target.style.webkitTransform = 'translate(' + x + 'px,' + y + 'px)';
			// that.slideItemAttr[that.activeIndex].sPosX = that.slideItemAttr[that.activeIndex].posX;
			// that.slideItemAttr[that.activeIndex].sPosY = that.slideItemAttr[that.activeIndex].posY;
		}


		Slide.prototype.imageWHRatio = function (activeindex) {
			var that = this;
			var imageAttrObj = that.slideItemAttr[activeindex];
			var attrObj = {
				direction: null,
				centerVal: null
			};

			if (imageAttrObj.width > imageAttrObj.height) {
				attrObj.direction = 'width';

			} else if (imageAttrObj.width < imageAttrObj.height) {
				attrObj.direction = 'height';
			} else {
				//正方形,以手机屏幕宽高计算
				attrObj.direction = 'width';
			}
			return attrObj
		}

		Slide.prototype.createImageLoadingEvent = function () {
			var that = this;
			that.LoadEvent = {
				img: function (activeindex, callback) {

					//为了防止切换slide,没load完毕,activeIndex获取错

					function load(ev) {
						// alert(ev.target.naturalHeight + ' ' + ev.target.naturalWidth + ' ' + activeindex);
						that.slideItemAttr[activeindex] = {
							width: ev.target.naturalWidth,
							height: ev.target.naturalHeight,
							target: ev.target
						}

						if (typeof callback == 'function') callback(load);
					}

					return load
				}
			}
		}


		Slide.prototype.cretaTouchEvent = function () {
			var that = this;

			var startTime = 0;
			var endTime = 0;
			var startY = 0;
			var startX = 0;
			var endY = 0;
			var endX = 0;
			var oldX = 0;
			var oldY = 0;
			var newX = 0;
			var newY = 0;

			var newX1 = 0,
				newY1 = 0,
				newX2 = 0,
				newY2 = 0;

			var oldX1 = 0,
				oldY1 = 0,
				oldX2 = 0,
				oldY2 = 0;

			var startFingerDist = 0,
				startFingerX = 0,
				startFingerY = 0;

			var imgNewX = 0,
				imgNewY = 0;


			var activeSlideBoxPos = 0;


			that.touchEvent = {
				start: function (e) {
					e.preventDefault();

					if (that.slideState) {
						var touchTarget = e.targetTouches.length; //获得触控点数


						activeSlideBoxPos = that.slideBoxPos;

						if (touchTarget == 2 && that.fingers) {

							startFingerDist = that.getTouchDist(e).dist;
							startFingerX = that.getTouchDist(e).x;

							startFingerY = that.getTouchDist(e).y;

						} else {

							startTime = new Date().getTime();
							var pageX = e.pageX || e.touches[0].pageX;
							var pageY = e.pageY || e.touches[0].pageY;

							oldX = endX = startX = pageX;
							oldY = endY = startY = pageY;


							//绑定Touch move & end
							that.bindTouchEvent2();
						}


					}
				},
				move: function (e) {
					e.preventDefault();
					var touchTarget = e.targetTouches.length;


					if (that.slideItemAttr[that.activeIndex]) {
						if (touchTarget == 1) {


							var pageX = e.pageX || e.touches[0].pageX;
							var pageY = e.pageY || e.touches[0].pageY;

							newX = endX = pageX;
							newY = endY = pageY;

							// that.fingers = false;

							// if(newX != oldX) {
							//     that.fingers = false;
							// }

							if (activeSlideBoxPos == 0) {
								if ((activeSlideBoxPos - that.slideBoxPos) <= -10) {
									that.fingers = false;
								}
								if ((activeSlideBoxPos - that.slideBoxPos) >= 10) {
									that.fingers = false;
								}
							} else if (activeSlideBoxPos < 0) {
								if ((activeSlideBoxPos - that.slideBoxPos) <= -10) {

									that.fingers = false;
								}
								if ((activeSlideBoxPos - that.slideBoxPos) >= 10) {

									that.fingers = false;
								}
							}

							//console.log(that.slideBoxPos);
							//执行位置计算

							if (that.slideItemAttr[that.activeIndex].target.offsetWidth > that.slideItemPageWidth && that.slideItemAttr[that.activeIndex].target.offsetHeight <= that.slideItemPageHeight) {

								if (that.slideItemAttr[that.activeIndex].posX >= 0 && (newX - oldX) > 0) {
									that.setSlideBoxPos(newX - oldX);
								} else if ((that.slideItemAttr[that.activeIndex].target.offsetWidth + that.slideItemAttr[that.activeIndex].posX) <= that.slideItemPageWidth && (newX - oldX) < 0) {

									that.setSlideBoxPos(newX - oldX);

								} else {
									var x = that.slideItemAttr[that.activeIndex].posX + (newX - oldX);
									var y = that.slideItemAttr[that.activeIndex].posY;

									that.setImagePos(x, y, that.activeIndex);
								}

							} else if (that.slideItemAttr[that.activeIndex].target.offsetHeight > that.slideItemPageHeight && that.slideItemAttr[that.activeIndex].target.offsetWidth <= that.slideItemPageWidth) {

								var x = that.slideItemAttr[that.activeIndex].posX;
								var y = that.slideItemAttr[that.activeIndex].posY + (newY - oldY);
								if (y < that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight) y = that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight;
								if (y > 0) y = 0;
								that.setSlideBoxPos(newX - oldX);
								that.setImagePos(x, y, that.activeIndex);

							} else if (that.slideItemAttr[that.activeIndex].target.offsetWidth > that.slideItemPageWidth && that.slideItemAttr[that.activeIndex].target.offsetHeight > that.slideItemPageHeight) {


								var x = that.slideItemAttr[that.activeIndex].posX + (newX - oldX);
								var y = that.slideItemAttr[that.activeIndex].posY + (newY - oldY);

								if (that.slideItemAttr[that.activeIndex].posX >= 0 && (newX - oldX) > 0) {
									x = that.slideItemAttr[that.activeIndex].posX;
									if (y < that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight) y = that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight;
									if (y > 0) y = 0;
									that.setSlideBoxPos(newX - oldX);

									that.setImagePos(x, y, that.activeIndex);
								} else if ((that.slideItemAttr[that.activeIndex].target.offsetWidth + that.slideItemAttr[that.activeIndex].posX) <= that.slideItemPageWidth && (newX - oldX) < 0) {
									x = that.slideItemAttr[that.activeIndex].posX;
									if (y < that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight) y = that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight;
									if (y > 0) y = 0;
									that.setSlideBoxPos(newX - oldX);

									that.setImagePos(x, y, that.activeIndex);
								} else {
									if (y < that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight) y = that.slideItemPageHeight - that.slideItemAttr[that.activeIndex].target.offsetHeight;
									if (y > 0) y = 0;

									that.setImagePos(x, y, that.activeIndex);
								}

							} else {
								//设置位置

								that.setSlideBoxPos(newX - oldX);
							}


							oldX = newX;
							oldY = newY;
						}

						if (touchTarget >= 2 && that.fingers) {
							//console.log('双指移动');


							var nowFingerDist = that.getTouchDist(e).dist, //获得当前长度
								ratio = nowFingerDist / startFingerDist, //计算缩放比
								imgWidth = Math.round(that.slideItemAttr[that.activeIndex].nowWidth * ratio), //计算图片宽度
								imgHeight = Math.round(that.slideItemAttr[that.activeIndex].nowHeight * ratio); //计算图片高度


							// 计算图片新的坐标

							imgNewX = Math.round(startFingerX * ratio - startFingerX - that.slideItemAttr[that.activeIndex].sPosX * ratio);
							imgNewY = Math.round(startFingerY * ratio - startFingerY - that.slideItemAttr[that.activeIndex].sPosY * ratio);

							if (imgWidth >= that.slideItemAttr[that.activeIndex].baseWidth || imgHeight >= that.slideItemAttr[that.activeIndex].baseHeight) {
								//(imgWidth >= that.slideItemAttr[that.activeIndex].nowWidth) || (imgHeight >= that.slideItemAttr[that.activeIndex].nowHeight)

								that.slideItemAttr[that.activeIndex].target.style.width = imgWidth + 'px';
								that.slideItemAttr[that.activeIndex].target.style.height = imgHeight + 'px';


								that.setImagePos(-imgNewX, -imgNewY, that.activeIndex);
								// self.refresh(-self.imgNewX, -self.imgNewY, "0s", "ease");
								// self.finger = true;
							} else {
								if (imgWidth < that.slideItemAttr[that.activeIndex].baseWidth || imgHeight < that.slideItemAttr[that.activeIndex].baseHeight) {
									//console.log('不能在缩小');
									that.slideItemAttr[that.activeIndex].target.style.width = that.slideItemAttr[that.activeIndex].baseWidth + "px";
									that.slideItemAttr[that.activeIndex].target.style.height = that.slideItemAttr[that.activeIndex].baseHeight + 'px';
								}
							}

						}


					} else {
						var pageX = e.pageX || e.touches[0].pageX;
						var pageY = e.pageY || e.touches[0].pageY;

						newX = endX = pageX;
						newY = endY = pageY;

						that.setSlideBoxPos(newX - oldX);

						oldX = newX;
						oldY = newY;
					}


				},
				end: function (e) {

					e.preventDefault();

					that.slideState = false;

					endTime = new Date().getTime();
					// console.log((endTime - startTime) <= 100);
					// console.log(isRange(startX,endX,3));
					// console.log(isRange(startY,endY,3));

					if ((endTime - startTime) <= 200 && isRange(startX, endX, 3) && isRange(startY, endY, 3)) {
						that.slideState = true;
						that.fingers = true;
						that.tap();
					} else {

						if (that.slideItemAttr[that.activeIndex]) {
							if (that.fingers) {
								that.slideItemAttr[that.activeIndex].sPosX = that.slideItemAttr[that.activeIndex].posX;
								that.slideItemAttr[that.activeIndex].sPosY = that.slideItemAttr[that.activeIndex].posY;
								that.slideItemAttr[that.activeIndex].nowWidth = that.slideItemAttr[that.activeIndex].target.offsetWidth;
								that.slideItemAttr[that.activeIndex].nowHeight = that.slideItemAttr[that.activeIndex].target.offsetHeight;

								//console.log('修正图片位置');
								that.modifiedImagePos();
								that.setSlideBoxTranfrom(true);

								//修正图片位置


							} else {
								//复位
								that.modifiedImagePos();
								that.setSlideBoxTranfrom(true);
							}
						} else {
							if (that.fingers) {
								that.setSlideBoxTranfrom(true);
							} else {
								that.setSlideBoxTranfrom(true);
							}
						}


					}

					//解绑 touch move & end
					that.unbindTouchEvent();
					return true
				}
			}
		}

		function isRange(v1, v2, range) {
			var state = true;
			var _range = range ? range : 3;

			if (v1 > v2 && v1 - v2 > _range) {
				state = false
			}

			if (v2 > v1 && v2 - v1 > _range) {
				state = false
			}

			return state
		}


		Slide.prototype.modifiedImagePos = function () {
			var that = this;

			var activeindex = that.activeIndex;

			var time = '.2s';

			var x = 0,
				y = 0;


			//计算位置
			if (that.slideItemAttr[activeindex]) {
				if (that.slideItemPageWidth == that.slideItemAttr[activeindex].target.offsetWidth) {
					x = 0;
				}

				if (that.slideItemPageWidth > that.slideItemAttr[activeindex].target.offsetWidth) {
					x = (that.slideItemPageWidth - that.slideItemAttr[activeindex].target.offsetWidth) / 2;
				}

				if (that.slideItemPageWidth < that.slideItemAttr[activeindex].target.offsetWidth) {

					if (that.slideItemAttr[activeindex].posX > 0) {
						x = 0;
					}
					if (that.slideItemAttr[activeindex].posX < 0) {
						if (that.slideItemAttr[activeindex].posX < that.slideItemPageWidth - that.slideItemAttr[activeindex].target.offsetWidth) {
							x = that.slideItemPageWidth - that.slideItemAttr[activeindex].target.offsetWidth;
						} else {
							x = that.slideItemAttr[activeindex].posX;
						}
					}
				}

				if (that.slideItemPageHeight == that.slideItemAttr[activeindex].target.offsetHeight) {
					y = 0;
				}

				if (that.slideItemPageHeight > that.slideItemAttr[activeindex].target.offsetHeight) {
					y = (that.slideItemPageHeight - that.slideItemAttr[activeindex].target.offsetHeight) / 2;
				}

				if (that.slideItemPageHeight < that.slideItemAttr[activeindex].target.offsetHeight) {

					if (that.slideItemAttr[activeindex].posY > 0) {
						y = 0;
					}

					if (that.slideItemAttr[activeindex].posY < 0) {
						if (that.slideItemAttr[activeindex].posY < that.slideItemPageHeight - that.slideItemAttr[activeindex].target.offsetHeight) {
							y = that.slideItemPageHeight - that.slideItemAttr[activeindex].target.offsetHeight;
						} else {
							y = that.slideItemAttr[activeindex].posY;
						}
					}

				}
				that.slideItemAttr[that.activeIndex].sPosX = x;
				that.slideItemAttr[that.activeIndex].sPosY = y;
			}


			that.setImagePos(x, y, activeindex, time);

			// that.slideState = true;
		}


		Slide.prototype.getTouchDist = function (e) {
			var x1 = 0,
				y1 = 0,
				x2 = 0,
				y2 = 0,
				x3 = 0,
				y3 = 0,
				result = {};
			x1 = e.touches[0].pageX;
			x2 = e.touches[1].pageX;
			y1 = e.touches[0].pageY - document.body.scrollTop;
			y2 = e.touches[1].pageY - document.body.scrollTop;

			if (!x1 || !x2) return;

			if (x1 <= x2) {
				x3 = (x2 - x1) / 2 + x1;
			} else {
				x3 = (x1 - x2) / 2 + x2;
			}
			if (y1 <= y2) {
				y3 = (y2 - y1) / 2 + y1;
			} else {
				y3 = (y1 - y2) / 2 + y2;
			}

			result = {
				dist: Math.round(Math.sqrt(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2))),
				x: Math.round(x3),
				y: Math.round(y3)
			};
			return result;
		}



		Slide.prototype.setSlideBoxPos = function (addVal) {
			var that = this;

			if (typeof addVal == 'number') {

				// console.log(addVal);


				if (that.activeIndex == 0 && addVal > 0 && that.slideBoxPos >= that.limit) {
					// console.log('触发开始边界');
					// that.slideBoxPos += 1;
					// that.loadingMaskPos += 1;
					that.slideBoxPos += 0;
					that.loadingMaskPos += 0;
					that.setSlideBoxTranfrom();
					return
				}

				if (that.activeIndex == 0 && addVal > 0 && (that.slideBoxPos + addVal) > that.limit) {
					// that.slideBoxPos += (that.limit - that.slideBoxPos);
					// that.loadingMaskPos -= 1;
					that.slideBoxPos += 0;
					that.loadingMaskPos -= 0;
					that.setSlideBoxTranfrom();
					return
				}

				// console.log(that.slideBoxPos - (-(that.activeIndex * that.slideItemPageWidth)) <= -that.limit);
				if (that.activeIndex == (that.dataList.length - 1) && addVal < 0 && (that.slideBoxPos - (-(that.activeIndex * that.slideItemPageWidth)) <= -that.limit)) {
					// console.log('触发结尾边界');
					// that.slideBoxPos -= 1;
					// that.loadingMaskPos -= 1;
					that.slideBoxPos -= 0;
					that.loadingMaskPos -= 0;
					that.setSlideBoxTranfrom();
					return
				}


				if (that.activeIndex == (that.dataList.length - 1) && addVal < 0 && (that.slideBoxPos + addVal) < (that.slideBoxPos - that.limit)) {
					// that.slideBoxPos = (-(that.activeIndex * that.slideItemPageWidth) - that.limit);
					// that.loadingMaskPos += 1;
					//   that.slideBoxPos = (-(that.activeIndex * that.slideItemPageWidth) - that.limit);
					//   that.loadingMaskPos += 1;
					// that.setSlideBoxTranfrom();
					return
				}

				that.slideBoxPos += addVal;
				that.loadingMaskPos += addVal;

				that.setSlideBoxTranfrom();
			} else {

			}
		}

		Slide.prototype.setSlideBoxTranfrom = function (isAlign) {
			var that = this;
			var maskGotoPos = 0;

			if (isAlign) {

				var deviation = parseFloat((that.slideBoxPos / that.slideItemPageWidth).toFixed(2)) + that.activeIndex;
				if (deviation < 0) {

					if (deviation <= -0.2) {

						// console.log('划过去');
						that.isToNewPage = true;

						that.oldActiveIndex = that.activeIndex;

						that.activeIndex += 1;
						that.testIndex = that.activeIndex;

						//展示图片资源
						that.showImage();

						//mask pos
						maskGotoPos = -that.slide.offsetWidth;

					} else {
						that.isToNewPage = false;
						// console.log('复位');
					}
				} else {
					if (deviation >= 0.2) {
						// console.log('滚回去');
						that.isToNewPage = true;
						that.oldActiveIndex = that.activeIndex;

						that.activeIndex -= 1;

						that.testIndex = that.activeIndex;

						//展示图片资源
						that.showImage();

						//mask pos
						maskGotoPos = that.slide.offsetWidth;
					} else {
						that.isToNewPage = false;
						// console.log('复位2');
					}
				}

				that.slideBoxPos = -(that.activeIndex * that.slideItemPageWidth);

				$(that.slideBox).addClass('transitionAction');

				that.slideBox.style.webkitTransform = 'translate(' + that.slideBoxPos + 'px,0)';

				//loading打开状态，拖动屏幕跟着拖动
				if (that.loadingState) {
					$(that.loadingMask).addClass('transitionAction');

					that.loadingMask[0].style.webkitTransform = 'translate(' + maskGotoPos + 'px,0)';
				}


				$timeout(function () {
					$(that.slideBox).removeClass('transitionAction');
					$(that.loadingMask).removeClass('transitionAction');
					//还原图片状态

					if (that.isToNewPage) {
						//console.log('还原之前的图片状态');
						that.restoreImage();
						that.loadingMaskPos = 0;
						that.loadingMask[0].style.webkitTransform = 'translate(0px,0)';

						if (!that.slideItemAttr[that.activeIndex]) {
							that.imageLoadState(1);
						}

					} else {
						if (that.loadingState) {
							that.loadingMaskPos = 0;
							that.loadingMask[0].style.webkitTransform = 'translate(0px,0)';
						}
						//console.log('不还原之前的图片');
					}
					that.slideState = true;
					that.fingers = true;
				}, 300)
			} else {
				that.slideBox.style.webkitTransform = 'translate(' + that.slideBoxPos + 'px,0)';
				if (that.loadingState) {
					that.loadingMask[0].style.webkitTransform = 'translate(' + that.loadingMaskPos + 'px,0)';
				}
			}
		}



		Slide.prototype.tap = function () {
			var that = this;
			that.removeSlide();
		}


		Slide.prototype.removeSlide = function () {
			var that = this;

			that.slide.removeEventListener('touchstart', that.touchEvent.start);
			that.slide.className = '';
			$ionicBackdrop.release();
			document.getElementsByClassName('backdrop')[0].style.backgroundColor = 'rgba(0,0,0,0.4)';
			$timeout(function () {
				that.slide.parentNode.removeChild(that.slide);

				that.state = false;
			}, 300)
		}

		Slide.prototype.bindTouchEvent = function () {
			var that = this;
			that.slide.addEventListener('touchstart', that.touchEvent.start, false);
		}

		Slide.prototype.bindTouchEvent2 = function () {
			var that = this;
			that.slide.addEventListener('touchmove', that.touchEvent.move, false);
			that.slide.addEventListener('touchend', that.touchEvent.end, false);
		}


		Slide.prototype.unbindTouchEvent = function () {
			var that = this;
			that.slide.removeEventListener('touchmove', that.touchEvent.move);
			that.slide.removeEventListener('touchend', that.touchEvent.end);
		}



		return function (elementId, dataList, index) {

			return new Slide(elementId, dataList, index)

		}
	}])


	.factory('albumLayer', ['$rootScope', '$ionicBackdrop', 'Slide', function ($rootScope, $ionicBackdrop, Slide) {

		function albumLayer(dataList, eid, dataIndex) {

			var screenWidth = window.screen.availWidth;
			var screenHeight = window.screen.availHeight;
			var albumLayerBox = document.createElement('div');
			albumLayerBox.setAttribute('id', eid ? eid : 'Side');
			albumLayerBox.style.width = screenWidth;
			albumLayerBox.style.height = screenHeight;

			var loadingStr =
				'<div class="spinner">' +
				'<div class="spinner-container container1">' +
				'<div class="circle1"></div>' +
				'<div class="circle2"></div>' +
				'<div class="circle3"></div>' +
				'<div class="circle4"></div>' +
				'</div>' +
				'<div class="spinner-container container2">' +
				'<div class="circle1"></div>' +
				'<div class="circle2"></div>' +
				'<div class="circle3"></div>' +
				'<div class="circle4"></div>' +
				'</div>' +
				'<div class="spinner-container container3">' +
				'<div class="circle1"></div>' +
				'<div class="circle2"></div>' +
				'<div class="circle3"></div>' +
				'<div class="circle4"></div>' +
				'</div>' +
				'</div>';

			var albumListStr = '<div style="width: ' + (screenWidth * dataList.length) + 'px">';
			for (var i = 0, len = dataList.length; i < len; i++) {
				albumListStr += ('<div style="width:' + screenWidth + 'px">' + '<img delay-src="' + dataList[i] + '" />' + '<div></div>' + '</div>')
			}
			albumListStr += '</div><div class="zoomSliderLoadingMask">' + loadingStr + '</div>';

			albumListStr += '<div  class="fufu-slider-indicator"><ul>';

			for (var i = 0, len = dataList.length; i < len; i++) {
				if (i == dataIndex) {
					albumListStr += '<li class="fufu-slider-indicator-active"></li>';
				} else {
					albumListStr += '<li></li>';
				}
			}

			albumListStr += '</ul></div>';

			albumLayerBox.innerHTML = albumListStr;
			document.body.appendChild(albumLayerBox);
		}


		return {
			create: albumLayer
		}
	}])




	.service('zoomSlider', ['$rootScope', '$ionicBackdrop', 'Slide', 'albumLayer', function ($rootScope, $ionicBackdrop, Slide, albumLayer) {

		var slide = null;


		function zoomSlider(option) {

			albumLayer.create(option.data, option.id ? option.id : 'zoomSlider', option.index);

			slide = Slide(option.id ? option.id : 'zoomSlider', option.data, option.index);
		}



		return {
			show: zoomSlider,
			isOpen: function () {
				if (slide && slide.state) {
					return true
				} else {
					return false
				}
			},
			close: function () {
				slide && slide.state && slide.removeSlide();
			}
		}
	}])
	.factory('DateDefaultArray', function () {

		return {
			month: [{
					key: 1,
					value: '01月'
				},
				{
					key: 2,
					value: '02月'
				},
				{
					key: 3,
					value: '03月'
				},
				{
					key: 4,
					value: '04月'
				},
				{
					key: 5,
					value: '05月'
				},
				{
					key: 6,
					value: '06月'
				},
				{
					key: 7,
					value: '07月'
				},
				{
					key: 8,
					value: '08月'
				},
				{
					key: 9,
					value: '09月'
				},
				{
					key: 10,
					value: '10月'
				},
				{
					key: 11,
					value: '11月'
				},
				{
					key: 12,
					value: '12月'
				}
			],
			day: [{
					key: 1,
					value: '01日'
				},
				{
					key: 2,
					value: '02日'
				},
				{
					key: 3,
					value: '03日'
				},
				{
					key: 4,
					value: '04日'
				},
				{
					key: 5,
					value: '05日'
				},
				{
					key: 6,
					value: '06日'
				},
				{
					key: 7,
					value: '07日'
				},
				{
					key: 8,
					value: '08日'
				},
				{
					key: 9,
					value: '09日'
				},
				{
					key: 10,
					value: '10日'
				},
				{
					key: 11,
					value: '11日'
				},
				{
					key: 12,
					value: '12日'
				},
				{
					key: 13,
					value: '13日'
				},
				{
					key: 14,
					value: '14日'
				},
				{
					key: 15,
					value: '15日'
				},
				{
					key: 16,
					value: '16日'
				},
				{
					key: 17,
					value: '17日'
				},
				{
					key: 18,
					value: '18日'
				},
				{
					key: 19,
					value: '19日'
				},
				{
					key: 20,
					value: '20日'
				},
				{
					key: 21,
					value: '21日'
				},
				{
					key: 22,
					value: '22日'
				},
				{
					key: 23,
					value: '23日'
				},
				{
					key: 24,
					value: '24日'
				},
				{
					key: 25,
					value: '25日'
				},
				{
					key: 26,
					value: '26日'
				},
				{
					key: 27,
					value: '27日'
				},
				{
					key: 28,
					value: '28日'
				},
				{
					key: 29,
					value: '29日'
				},
				{
					key: 30,
					value: '30日'
				},
				{
					key: 31,
					value: '31日'
				}
			],
			hours: [{
					key: 0,
					value: '00'
				},
				{
					key: 1,
					value: '01'
				},
				{
					key: 2,
					value: '02'
				},
				{
					key: 3,
					value: '03'
				},
				{
					key: 4,
					value: '04'
				},
				{
					key: 5,
					value: '05'
				},
				{
					key: 6,
					value: '06'
				},
				{
					key: 7,
					value: '07'
				},
				{
					key: 8,
					value: '08'
				},
				{
					key: 9,
					value: '09'
				},
				{
					key: 10,
					value: '10'
				},
				{
					key: 11,
					value: '11'
				},
				{
					key: 12,
					value: '12'
				},
				{
					key: 13,
					value: '13'
				},
				{
					key: 14,
					value: '14'
				},
				{
					key: 15,
					value: '15'
				},
				{
					key: 16,
					value: '16'
				},
				{
					key: 17,
					value: '17'
				},
				{
					key: 18,
					value: '18'
				},
				{
					key: 19,
					value: '19'
				},
				{
					key: 20,
					value: '20'
				},
				{
					key: 21,
					value: '21'
				},
				{
					key: 22,
					value: '22'
				},
				{
					key: 23,
					value: '23'
				}
			],
			minutes: [{
					key: 0,
					value: '00'
				},
				{
					key: 1,
					value: '01'
				},
				{
					key: 2,
					value: '02'
				},
				{
					key: 3,
					value: '03'
				},
				{
					key: 4,
					value: '04'
				},
				{
					key: 5,
					value: '05'
				},
				{
					key: 6,
					value: '06'
				},
				{
					key: 7,
					value: '07'
				},
				{
					key: 8,
					value: '08'
				},
				{
					key: 9,
					value: '09'
				},
				{
					key: 10,
					value: '10'
				},
				{
					key: 11,
					value: '11'
				},
				{
					key: 12,
					value: '12'
				},
				{
					key: 13,
					value: '13'
				},
				{
					key: 14,
					value: '14'
				},
				{
					key: 15,
					value: '15'
				},
				{
					key: 16,
					value: '16'
				},
				{
					key: 17,
					value: '17'
				},
				{
					key: 18,
					value: '18'
				},
				{
					key: 19,
					value: '19'
				},
				{
					key: 20,
					value: '20'
				},
				{
					key: 21,
					value: '21'
				},
				{
					key: 22,
					value: '22'
				},
				{
					key: 23,
					value: '23'
				},
				{
					key: 24,
					value: '24'
				},
				{
					key: 25,
					value: '25'
				},
				{
					key: 26,
					value: '26'
				},
				{
					key: 27,
					value: '27'
				},
				{
					key: 28,
					value: '28'
				},
				{
					key: 29,
					value: '29'
				},
				{
					key: 30,
					value: '30'
				},
				{
					key: 31,
					value: '31'
				},
				{
					key: 32,
					value: '32'
				},
				{
					key: 33,
					value: '33'
				},
				{
					key: 34,
					value: '34'
				},
				{
					key: 35,
					value: '35'
				},
				{
					key: 36,
					value: '36'
				},
				{
					key: 37,
					value: '37'
				},
				{
					key: 38,
					value: '38'
				},
				{
					key: 39,
					value: '39'
				},
				{
					key: 40,
					value: '40'
				},
				{
					key: 41,
					value: '41'
				},
				{
					key: 42,
					value: '42'
				},
				{
					key: 43,
					value: '43'
				},
				{
					key: 44,
					value: '44'
				},
				{
					key: 45,
					value: '45'
				},
				{
					key: 46,
					value: '46'
				},
				{
					key: 47,
					value: '47'
				},
				{
					key: 48,
					value: '48'
				},
				{
					key: 49,
					value: '49'
				},
				{
					key: 50,
					value: '50'
				},
				{
					key: 51,
					value: '51'
				},
				{
					key: 52,
					value: '52'
				},
				{
					key: 53,
					value: '53'
				},
				{
					key: 54,
					value: '54'
				},
				{
					key: 55,
					value: '55'
				},
				{
					key: 56,
					value: '56'
				},
				{
					key: 57,
					value: '57'
				},
				{
					key: 58,
					value: '58'
				},
				{
					key: 59,
					value: '59'
				}
			],
			minutes3: [{
					key: 0,
					value: '00'
				},
				{
					key: 3,
					value: '03'
				},
				{
					key: 6,
					value: '06'
				},
				{
					key: 9,
					value: '09'
				},
				{
					key: 12,
					value: '12'
				},
				{
					key: 15,
					value: '15'
				},
				{
					key: 18,
					value: '18'
				},
				{
					key: 21,
					value: '21'
				},
				{
					key: 24,
					value: '24'
				},
				{
					key: 27,
					value: '27'
				},
				{
					key: 30,
					value: '30'
				},
				{
					key: 33,
					value: '33'
				},
				{
					key: 36,
					value: '36'
				},
				{
					key: 39,
					value: '39'
				},
				{
					key: 42,
					value: '42'
				},
				{
					key: 45,
					value: '45'
				},
				{
					key: 48,
					value: '48'
				},
				{
					key: 51,
					value: '51'
				},
				{
					key: 54,
					value: '54'
				},
				{
					key: 57,
					value: '57'
				}
			],
			minutes5: [{
					key: 0,
					value: '00'
				},
				{
					key: 5,
					value: '05'
				},
				{
					key: 10,
					value: '10'
				},
				{
					key: 15,
					value: '15'
				},
				{
					key: 20,
					value: '20'
				},
				{
					key: 25,
					value: '25'
				},
				{
					key: 30,
					value: '30'
				},
				{
					key: 35,
					value: '35'
				},
				{
					key: 40,
					value: '40'
				},
				{
					key: 45,
					value: '45'
				},
				{
					key: 50,
					value: '50'
				},
				{
					key: 55,
					value: '55'
				}
			],
			minutes10: [{
					key: 0,
					value: '00'
				},
				{
					key: 10,
					value: '10'
				},
				{
					key: 20,
					value: '20'
				},
				{
					key: 30,
					value: '30'
				},
				{
					key: 40,
					value: '40'
				},
				{
					key: 50,
					value: '50'
				}
			]
		}

	})
	.factory('IScroll', function () {

		var rAF = window.requestAnimationFrame ||
			window.webkitRequestAnimationFrame ||
			window.mozRequestAnimationFrame ||
			window.oRequestAnimationFrame ||
			window.msRequestAnimationFrame ||
			function (callback) {
				window.setTimeout(callback, 1000 / 60);
			};

		var utils = (function () {
			var me = {};

			var _elementStyle = document.createElement('div').style;
			var _vendor = (function () {
				var vendors = ['t', 'webkitT', 'MozT', 'msT', 'OT'],
					transform,
					i = 0,
					l = vendors.length;

				for (; i < l; i++) {
					transform = vendors[i] + 'ransform';
					if (transform in _elementStyle) return vendors[i].substr(0, vendors[i].length - 1);
				}

				return false;
			})();

			function _prefixStyle(style) {
				if (_vendor === false) return false;
				if (_vendor === '') return style;
				return _vendor + style.charAt(0).toUpperCase() + style.substr(1);
			}

			me.getTime = Date.now || function getTime() {
				return new Date().getTime();
			};

			me.extend = function (target, obj) {
				for (var i in obj) {
					target[i] = obj[i];
				}
			};

			me.addEvent = function (el, type, fn, capture) {
				el.addEventListener(type, fn, !!capture);
			};

			me.removeEvent = function (el, type, fn, capture) {
				el.removeEventListener(type, fn, !!capture);
			};

			me.prefixPointerEvent = function (pointerEvent) {
				return window.MSPointerEvent ?
					'MSPointer' + pointerEvent.charAt(9).toUpperCase() + pointerEvent.substr(10) :
					pointerEvent;
			};

			me.momentum = function (current, start, time, lowerMargin, wrapperSize, deceleration) {
				var distance = current - start,
					speed = Math.abs(distance) / time,
					destination,
					duration;

				deceleration = deceleration === undefined ? 0.0006 : deceleration;

				destination = current + (speed * speed) / (2 * deceleration) * (distance < 0 ? -1 : 1);
				duration = speed / deceleration;

				if (destination < lowerMargin) {
					destination = wrapperSize ? lowerMargin - (wrapperSize / 2.5 * (speed / 8)) : lowerMargin;
					distance = Math.abs(destination - current);
					duration = distance / speed;
				} else if (destination > 0) {
					destination = wrapperSize ? wrapperSize / 2.5 * (speed / 8) : 0;
					distance = Math.abs(current) + destination;
					duration = distance / speed;
				}

				return {
					destination: Math.round(destination),
					duration: duration
				};
			};

			var _transform = _prefixStyle('transform');

			me.extend(me, {
				hasTransform: _transform !== false,
				hasPerspective: _prefixStyle('perspective') in _elementStyle,
				hasTouch: 'ontouchstart' in window,
				hasPointer: window.PointerEvent || window.MSPointerEvent, // IE10 is prefixed
				hasTransition: _prefixStyle('transition') in _elementStyle
			});

			// This should find all Android browsers lower than build 535.19 (both stock browser and webview)
			me.isBadAndroid = /Android /.test(window.navigator.appVersion) && !(/Chrome\/\d/.test(window.navigator.appVersion));

			me.extend(me.style = {}, {
				transform: _transform,
				transitionTimingFunction: _prefixStyle('transitionTimingFunction'),
				transitionDuration: _prefixStyle('transitionDuration'),
				transitionDelay: _prefixStyle('transitionDelay'),
				transformOrigin: _prefixStyle('transformOrigin')
			});

			me.hasClass = function (e, c) {
				var re = new RegExp("(^|\\s)" + c + "(\\s|$)");
				return re.test(e.className);
			};

			me.addClass = function (e, c) {
				if (me.hasClass(e, c)) {
					return;
				}

				var newclass = e.className.split(' ');
				newclass.push(c);
				e.className = newclass.join(' ');
			};

			me.removeClass = function (e, c) {
				if (!me.hasClass(e, c)) {
					return;
				}

				var re = new RegExp("(^|\\s)" + c + "(\\s|$)", 'g');
				e.className = e.className.replace(re, ' ');
			};

			me.offset = function (el) {
				var left = -el.offsetLeft,
					top = -el.offsetTop;

				// jshint -W084
				while (el = el.offsetParent) {
					left -= el.offsetLeft;
					top -= el.offsetTop;
				}
				// jshint +W084

				return {
					left: left,
					top: top
				};
			};

			me.preventDefaultException = function (el, exceptions) {
				for (var i in exceptions) {
					if (exceptions[i].test(el[i])) {
						return true;
					}
				}

				return false;
			};

			me.extend(me.eventType = {}, {
				touchstart: 1,
				touchmove: 1,
				touchend: 1,

				mousedown: 2,
				mousemove: 2,
				mouseup: 2,

				pointerdown: 3,
				pointermove: 3,
				pointerup: 3,

				MSPointerDown: 3,
				MSPointerMove: 3,
				MSPointerUp: 3
			});

			me.extend(me.ease = {}, {
				quadratic: {
					style: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
					fn: function (k) {
						return k * (2 - k);
					}
				},
				circular: {
					style: 'cubic-bezier(0.1, 0.57, 0.1, 1)', // Not properly "circular" but this looks better, it should be (0.075, 0.82, 0.165, 1)
					fn: function (k) {
						return Math.sqrt(1 - (--k * k));
					}
				},
				back: {
					style: 'cubic-bezier(0.175, 0.885, 0.32, 1.275)',
					fn: function (k) {
						var b = 4;
						return (k = k - 1) * k * ((b + 1) * k + b) + 1;
					}
				},
				bounce: {
					style: '',
					fn: function (k) {
						if ((k /= 1) < (1 / 2.75)) {
							return 7.5625 * k * k;
						} else if (k < (2 / 2.75)) {
							return 7.5625 * (k -= (1.5 / 2.75)) * k + 0.75;
						} else if (k < (2.5 / 2.75)) {
							return 7.5625 * (k -= (2.25 / 2.75)) * k + 0.9375;
						} else {
							return 7.5625 * (k -= (2.625 / 2.75)) * k + 0.984375;
						}
					}
				},
				elastic: {
					style: '',
					fn: function (k) {
						var f = 0.22,
							e = 0.4;

						if (k === 0) {
							return 0;
						}
						if (k == 1) {
							return 1;
						}

						return (e * Math.pow(2, -10 * k) * Math.sin((k - f / 4) * (2 * Math.PI) / f) + 1);
					}
				}
			});

			me.tap = function (e, eventName) {
				var ev = document.createEvent('Event');
				ev.initEvent(eventName, true, true);
				ev.pageX = e.pageX;
				ev.pageY = e.pageY;
				e.target.dispatchEvent(ev);
			};

			me.click = function (e) {
				var target = e.target,
					ev;

				if (!(/(SELECT|INPUT|TEXTAREA)/i).test(target.tagName)) {
					ev = document.createEvent('MouseEvents');
					ev.initMouseEvent('click', true, true, e.view, 1,
						target.screenX, target.screenY, target.clientX, target.clientY,
						e.ctrlKey, e.altKey, e.shiftKey, e.metaKey,
						0, null);

					ev._constructed = true;
					target.dispatchEvent(ev);
				}
			};

			return me;
		})();



		function IScroll(el, options) {
			this.wrapper = typeof el == 'string' ? document.querySelector(el) : el;
			this.scroller = this.wrapper.children[0];
			this.scrollerStyle = this.scroller.style; // cache style for better performance

			this.options = {

				resizeScrollbars: true,

				mouseWheelSpeed: 20,

				snapThreshold: 0.334,

				// INSERT POINT: OPTIONS

				startX: 0,
				startY: 0,
				scrollY: true,
				directionLockThreshold: 5,
				momentum: true,

				bounce: true,
				bounceTime: 600,
				bounceEasing: '',

				preventDefault: true,
				preventDefaultException: {
					tagName: /^(INPUT|TEXTAREA|BUTTON|SELECT)$/
				},

				HWCompositing: true,
				useTransition: true,
				useTransform: true
			};

			for (var i in options) {
				this.options[i] = options[i];
			}

			// Normalize options
			this.translateZ = this.options.HWCompositing && utils.hasPerspective ? ' translateZ(0)' : '';

			this.options.useTransition = utils.hasTransition && this.options.useTransition;
			this.options.useTransform = utils.hasTransform && this.options.useTransform;

			this.options.eventPassthrough = this.options.eventPassthrough === true ? 'vertical' : this.options.eventPassthrough;
			this.options.preventDefault = !this.options.eventPassthrough && this.options.preventDefault;

			// If you want eventPassthrough I have to lock one of the axes
			this.options.scrollY = this.options.eventPassthrough == 'vertical' ? false : this.options.scrollY;
			this.options.scrollX = this.options.eventPassthrough == 'horizontal' ? false : this.options.scrollX;

			// With eventPassthrough we also need lockDirection mechanism
			this.options.freeScroll = this.options.freeScroll && !this.options.eventPassthrough;
			this.options.directionLockThreshold = this.options.eventPassthrough ? 0 : this.options.directionLockThreshold;

			this.options.bounceEasing = typeof this.options.bounceEasing == 'string' ? utils.ease[this.options.bounceEasing] || utils.ease.circular : this.options.bounceEasing;

			this.options.resizePolling = this.options.resizePolling === undefined ? 60 : this.options.resizePolling;

			if (this.options.tap === true) {
				this.options.tap = 'tap';
			}

			if (this.options.shrinkScrollbars == 'scale') {
				this.options.useTransition = false;
			}

			this.options.invertWheelDirection = this.options.invertWheelDirection ? -1 : 1;

			if (this.options.probeType == 3) {
				this.options.useTransition = false;
			}

			// INSERT POINT: NORMALIZATION

			// Some defaults
			this.x = 0;
			this.y = 0;
			this.directionX = 0;
			this.directionY = 0;
			this._events = {};

			// INSERT POINT: DEFAULTS

			this._init();
			this.refresh();

			this.scrollTo(this.options.startX, this.options.startY);
			this.enable();
		}

		IScroll.prototype = {
			version: '5.1.3',

			_init: function () {
				this._initEvents();

				if (this.options.scrollbars || this.options.indicators) {
					this._initIndicators();
				}

				if (this.options.mouseWheel) {
					this._initWheel();
				}

				if (this.options.snap) {
					this._initSnap();
				}

				if (this.options.keyBindings) {
					this._initKeys();
				}

				// INSERT POINT: _init

			},

			destroy: function () {
				this._initEvents(true);

				this._execEvent('destroy');
			},

			_transitionEnd: function (e) {
				if (e.target != this.scroller || !this.isInTransition) {
					return;
				}

				this._transitionTime();
				if (!this.resetPosition(this.options.bounceTime)) {
					this.isInTransition = false;
					this._execEvent('scrollEnd');
				}
			},

			_start: function (e) {
				// React to left mouse button only
				if (utils.eventType[e.type] != 1) {
					if (e.button !== 0) {
						return;
					}
				}

				if (!this.enabled || (this.initiated && utils.eventType[e.type] !== this.initiated)) {
					return;
				}

				if (this.options.preventDefault && !utils.isBadAndroid && !utils.preventDefaultException(e.target, this.options.preventDefaultException)) {
					e.preventDefault();
				}

				var point = e.touches ? e.touches[0] : e,
					pos;

				this.initiated = utils.eventType[e.type];
				this.moved = false;
				this.distX = 0;
				this.distY = 0;
				this.directionX = 0;
				this.directionY = 0;
				this.directionLocked = 0;

				this._transitionTime();

				this.startTime = utils.getTime();

				if (this.options.useTransition && this.isInTransition) {
					this.isInTransition = false;
					pos = this.getComputedPosition();
					this._translate(Math.round(pos.x), Math.round(pos.y));
					this._execEvent('scrollEnd');
				} else if (!this.options.useTransition && this.isAnimating) {
					this.isAnimating = false;
					this._execEvent('scrollEnd');
				}

				this.startX = this.x;
				this.startY = this.y;
				this.absStartX = this.x;
				this.absStartY = this.y;
				this.pointX = point.pageX;
				this.pointY = point.pageY;

				this._execEvent('beforeScrollStart');
			},

			_move: function (e) {
				if (!this.enabled || utils.eventType[e.type] !== this.initiated) {
					return;
				}

				if (this.options.preventDefault) { // increases performance on Android? TODO: check!
					e.preventDefault();
				}

				var point = e.touches ? e.touches[0] : e,
					deltaX = point.pageX - this.pointX,
					deltaY = point.pageY - this.pointY,
					timestamp = utils.getTime(),
					newX, newY,
					absDistX, absDistY;

				this.pointX = point.pageX;
				this.pointY = point.pageY;

				this.distX += deltaX;
				this.distY += deltaY;
				absDistX = Math.abs(this.distX);
				absDistY = Math.abs(this.distY);

				// We need to move at least 10 pixels for the scrolling to initiate
				if (timestamp - this.endTime > 300 && (absDistX < 10 && absDistY < 10)) {
					return;
				}

				// If you are scrolling in one direction lock the other
				if (!this.directionLocked && !this.options.freeScroll) {
					if (absDistX > absDistY + this.options.directionLockThreshold) {
						this.directionLocked = 'h'; // lock horizontally
					} else if (absDistY >= absDistX + this.options.directionLockThreshold) {
						this.directionLocked = 'v'; // lock vertically
					} else {
						this.directionLocked = 'n'; // no lock
					}
				}

				if (this.directionLocked == 'h') {
					if (this.options.eventPassthrough == 'vertical') {
						e.preventDefault();
					} else if (this.options.eventPassthrough == 'horizontal') {
						this.initiated = false;
						return;
					}

					deltaY = 0;
				} else if (this.directionLocked == 'v') {
					if (this.options.eventPassthrough == 'horizontal') {
						e.preventDefault();
					} else if (this.options.eventPassthrough == 'vertical') {
						this.initiated = false;
						return;
					}

					deltaX = 0;
				}

				deltaX = this.hasHorizontalScroll ? deltaX : 0;
				deltaY = this.hasVerticalScroll ? deltaY : 0;

				newX = this.x + deltaX;
				newY = this.y + deltaY;

				// Slow down if outside of the boundaries
				if (newX > 0 || newX < this.maxScrollX) {
					newX = this.options.bounce ? this.x + deltaX / 3 : newX > 0 ? 0 : this.maxScrollX;
				}
				if (newY > 0 || newY < this.maxScrollY) {
					newY = this.options.bounce ? this.y + deltaY / 3 : newY > 0 ? 0 : this.maxScrollY;
				}

				this.directionX = deltaX > 0 ? -1 : deltaX < 0 ? 1 : 0;
				this.directionY = deltaY > 0 ? -1 : deltaY < 0 ? 1 : 0;

				if (!this.moved) {
					this._execEvent('scrollStart');
				}

				this.moved = true;

				this._translate(newX, newY);

				/* REPLACE START: _move */
				if (timestamp - this.startTime > 300) {
					this.startTime = timestamp;
					this.startX = this.x;
					this.startY = this.y;

					if (this.options.probeType == 1) {
						this._execEvent('scroll');
					}
				}

				if (this.options.probeType > 1) {
					this._execEvent('scroll');
				}
				/* REPLACE END: _move */

			},

			_end: function (e) {
				if (!this.enabled || utils.eventType[e.type] !== this.initiated) {
					return;
				}

				if (this.options.preventDefault && !utils.preventDefaultException(e.target, this.options.preventDefaultException)) {
					e.preventDefault();
				}

				var point = e.changedTouches ? e.changedTouches[0] : e,
					momentumX,
					momentumY,
					duration = utils.getTime() - this.startTime,
					newX = Math.round(this.x),
					newY = Math.round(this.y),
					distanceX = Math.abs(newX - this.startX),
					distanceY = Math.abs(newY - this.startY),
					time = 0,
					easing = '';

				this.isInTransition = 0;
				this.initiated = 0;
				this.endTime = utils.getTime();

				// reset if we are outside of the boundaries
				// if (this.resetPosition(this.options.bounceTime)) {
				//   return;
				// }
				this.scrollTo(newX, newY); // ensures that the last position is rounded

				// we scrolled less than 10 pixels
				if (!this.moved) {
					if (this.options.tap) {
						utils.tap(e, this.options.tap);
					}

					if (this.options.click) {
						utils.click(e);
					}

					this._execEvent('scrollCancel');
					return;
				}

				if (this._events.flick && duration < 200 && distanceX < 100 && distanceY < 100) {
					this._execEvent('flick');
					return;
				}

				// start momentum animation if needed
				if (this.options.momentum && duration < 300) {
					momentumX = this.hasHorizontalScroll ? utils.momentum(this.x, this.startX, duration, this.maxScrollX, this.options.bounce ? this.wrapperWidth : 0, this.options.deceleration) : {
						destination: newX,
						duration: 0
					};
					momentumY = this.hasVerticalScroll ? utils.momentum(this.y, this.startY, duration, this.maxScrollY, this.options.bounce ? this.wrapperHeight : 0, this.options.deceleration) : {
						destination: newY,
						duration: 0
					};
					newX = momentumX.destination;
					newY = momentumY.destination;
					time = Math.max(momentumX.duration, momentumY.duration);
					this.isInTransition = 1;
				}


				if (this.options.snap) {
					var snap = this._nearestSnap(newX, newY);
					this.currentPage = snap;
					time = this.options.snapSpeed || Math.max(
						Math.max(
							Math.min(Math.abs(newX - snap.x), 1000),
							Math.min(Math.abs(newY - snap.y), 1000)
						), 300);
					newX = snap.x;
					newY = snap.y;

					this.directionX = 0;
					this.directionY = 0;
					easing = this.options.bounceEasing;
				}

				// INSERT POINT: _end

				if (newX != this.x || newY != this.y) {
					// change easing function when scroller goes out of the boundaries
					if (newX > 0 || newX < this.maxScrollX || newY > 0 || newY < this.maxScrollY) {
						easing = utils.ease.quadratic;
					}

					this.scrollTo(newX, newY, time, easing);
					return;
				}

				this._execEvent('scrollEnd');
			},

			_resize: function () {
				var that = this;

				clearTimeout(this.resizeTimeout);

				this.resizeTimeout = setTimeout(function () {
					that.refresh();
				}, this.options.resizePolling);
			},

			resetPosition: function (time) {
				var x = this.x,
					y = this.y;

				time = time || 0;

				if (!this.hasHorizontalScroll || this.x > 0) {
					x = 0;
				} else if (this.x < this.maxScrollX) {
					x = this.maxScrollX;
				}

				if (!this.hasVerticalScroll || this.y > 0) {
					y = 0;
				} else if (this.y < this.maxScrollY) {
					y = this.maxScrollY;
				}

				if (x == this.x && y == this.y) {
					return false;
				}

				this.scrollTo(x, y, time, this.options.bounceEasing);

				return true;
			},

			disable: function () {
				this.enabled = false;
			},

			enable: function () {
				this.enabled = true;
			},

			refresh: function () {

				var rf = this.wrapper.offsetHeight; // Force reflow

				this.wrapperWidth = this.wrapper.clientWidth;
				this.wrapperHeight = this.wrapper.clientHeight;

				/* REPLACE START: refresh */

				this.scrollerWidth = this.scroller.offsetWidth;
				this.scrollerHeight = this.scroller.offsetHeight;

				this.maxScrollX = this.wrapperWidth - this.scrollerWidth;

				if (this.notUpScrollY) {
					this.notUpScrollY = false;
					this.maxScrollY = this.wrapperHeight - this.scrollerHeight - 12;
				} else {
					this.maxScrollY = this.wrapperHeight - this.scrollerHeight;
				}

				/* REPLACE END: refresh */

				this.hasHorizontalScroll = this.options.scrollX && this.maxScrollX < 0;
				this.hasVerticalScroll = this.options.scrollY && this.maxScrollY < 0;

				if (!this.hasHorizontalScroll) {
					this.maxScrollX = 0;
					this.scrollerWidth = this.wrapperWidth;
				}

				if (!this.hasVerticalScroll) {
					this.maxScrollY = 0;
					this.scrollerHeight = this.wrapperHeight;
				}

				this.endTime = 0;
				this.directionX = 0;
				this.directionY = 0;

				this.wrapperOffset = utils.offset(this.wrapper);

				this._execEvent('refresh');

				this.resetPosition();

				// INSERT POINT: _refresh

			},

			on: function (type, fn) {
				if (!this._events[type]) {
					this._events[type] = [];
				}

				this._events[type].push(fn);
			},

			off: function (type, fn) {
				if (!this._events[type]) {
					return;
				}

				var index = this._events[type].indexOf(fn);

				if (index > -1) {
					this._events[type].splice(index, 1);
				}
			},

			_execEvent: function (type) {
				if (!this._events[type]) {
					return;
				}

				var i = 0,
					l = this._events[type].length;

				if (!l) {
					return;
				}

				for (; i < l; i++) {
					this._events[type][i].apply(this, [].slice.call(arguments, 1));
				}
			},

			scrollBy: function (x, y, time, easing) {
				x = this.x + x;
				y = this.y + y;
				time = time || 0;

				this.scrollTo(x, y, time, easing);
			},

			scrollTo: function (x, y, time, easing) {
				easing = easing || utils.ease.circular;

				this.isInTransition = this.options.useTransition && time > 0;

				if (!time || (this.options.useTransition && easing.style)) {
					this._transitionTimingFunction(easing.style);
					this._transitionTime(time);
					this._translate(x, y);
				} else {
					this._animate(x, y, time, easing.fn);
				}
			},

			scrollToElement: function (el, time, offsetX, offsetY, easing) {
				el = el.nodeType ? el : this.scroller.querySelector(el);

				if (!el) {
					return;
				}

				var pos = utils.offset(el);

				pos.left -= this.wrapperOffset.left;
				pos.top -= this.wrapperOffset.top;

				// if offsetX/Y are true we center the element to the screen
				if (offsetX === true) {
					offsetX = Math.round(el.offsetWidth / 2 - this.wrapper.offsetWidth / 2);
				}
				if (offsetY === true) {
					offsetY = Math.round(el.offsetHeight / 2 - this.wrapper.offsetHeight / 2);
				}

				pos.left -= offsetX || 0;
				pos.top -= offsetY || 0;

				pos.left = pos.left > 0 ? 0 : pos.left < this.maxScrollX ? this.maxScrollX : pos.left;
				pos.top = pos.top > 0 ? 0 : pos.top < this.maxScrollY ? this.maxScrollY : pos.top;

				time = time === undefined || time === null || time === 'auto' ? Math.max(Math.abs(this.x - pos.left), Math.abs(this.y - pos.top)) : time;

				this.scrollTo(pos.left, pos.top, time, easing);
			},

			_transitionTime: function (time) {
				time = time || 0;

				this.scrollerStyle[utils.style.transitionDuration] = time + 'ms';

				if (!time && utils.isBadAndroid) {
					this.scrollerStyle[utils.style.transitionDuration] = '0.001s';
				}


				if (this.indicators) {
					for (var i = this.indicators.length; i--;) {
						this.indicators[i].transitionTime(time);
					}
				}


				// INSERT POINT: _transitionTime

			},

			_transitionTimingFunction: function (easing) {
				this.scrollerStyle[utils.style.transitionTimingFunction] = easing;


				if (this.indicators) {
					for (var i = this.indicators.length; i--;) {
						this.indicators[i].transitionTimingFunction(easing);
					}
				}


				// INSERT POINT: _transitionTimingFunction

			},

			_translate: function (x, y) {
				if (this.options.useTransform) {

					/* REPLACE START: _translate */

					this.scrollerStyle[utils.style.transform] = 'translate(' + x + 'px,' + y + 'px)' + this.translateZ;

					/* REPLACE END: _translate */

				} else {
					x = Math.round(x);
					y = Math.round(y);
					this.scrollerStyle.left = x + 'px';
					this.scrollerStyle.top = y + 'px';
				}

				this.x = x;
				this.y = y;


				if (this.indicators) {
					for (var i = this.indicators.length; i--;) {
						this.indicators[i].updatePosition();
					}
				}


				// INSERT POINT: _translate

			},

			_initEvents: function (remove) {
				var eventType = remove ? utils.removeEvent : utils.addEvent,
					target = this.options.bindToWrapper ? this.wrapper : window;

				eventType(window, 'orientationchange', this);
				eventType(window, 'resize', this);

				if (this.options.click) {
					eventType(this.wrapper, 'click', this, true);
				}

				if (!this.options.disableMouse) {
					eventType(this.wrapper, 'mousedown', this);
					eventType(target, 'mousemove', this);
					eventType(target, 'mousecancel', this);
					eventType(target, 'mouseup', this);
				}

				if (utils.hasPointer && !this.options.disablePointer) {
					eventType(this.wrapper, utils.prefixPointerEvent('pointerdown'), this);
					eventType(target, utils.prefixPointerEvent('pointermove'), this);
					eventType(target, utils.prefixPointerEvent('pointercancel'), this);
					eventType(target, utils.prefixPointerEvent('pointerup'), this);
				}

				if (utils.hasTouch && !this.options.disableTouch) {
					eventType(this.wrapper, 'touchstart', this);
					eventType(target, 'touchmove', this);
					eventType(target, 'touchcancel', this);
					eventType(target, 'touchend', this);
				}

				eventType(this.scroller, 'transitionend', this);
				eventType(this.scroller, 'webkitTransitionEnd', this);
				eventType(this.scroller, 'oTransitionEnd', this);
				eventType(this.scroller, 'MSTransitionEnd', this);
			},

			getComputedPosition: function () {
				var matrix = window.getComputedStyle(this.scroller, null),
					x, y;

				if (this.options.useTransform) {
					matrix = matrix[utils.style.transform].split(')')[0].split(', ');
					x = +(matrix[12] || matrix[4]);
					y = +(matrix[13] || matrix[5]);
				} else {
					x = +matrix.left.replace(/[^-\d.]/g, '');
					y = +matrix.top.replace(/[^-\d.]/g, '');
				}

				return {
					x: x,
					y: y
				};
			},

			_initIndicators: function () {
				var interactive = this.options.interactiveScrollbars,
					customStyle = typeof this.options.scrollbars != 'string',
					indicators = [],
					indicator;

				var that = this;

				this.indicators = [];

				if (this.options.scrollbars) {
					// Vertical scrollbar
					if (this.options.scrollY) {
						indicator = {
							el: createDefaultScrollbar('v', interactive, this.options.scrollbars),
							interactive: interactive,
							defaultScrollbars: true,
							customStyle: customStyle,
							resize: this.options.resizeScrollbars,
							shrink: this.options.shrinkScrollbars,
							fade: this.options.fadeScrollbars,
							listenX: false
						};

						this.wrapper.appendChild(indicator.el);
						indicators.push(indicator);
					}

					// Horizontal scrollbar
					if (this.options.scrollX) {
						indicator = {
							el: createDefaultScrollbar('h', interactive, this.options.scrollbars),
							interactive: interactive,
							defaultScrollbars: true,
							customStyle: customStyle,
							resize: this.options.resizeScrollbars,
							shrink: this.options.shrinkScrollbars,
							fade: this.options.fadeScrollbars,
							listenY: false
						};

						this.wrapper.appendChild(indicator.el);
						indicators.push(indicator);
					}
				}

				if (this.options.indicators) {
					// TODO: check concat compatibility
					indicators = indicators.concat(this.options.indicators);
				}

				for (var i = indicators.length; i--;) {
					this.indicators.push(new Indicator(this, indicators[i]));
				}

				// TODO: check if we can use array.map (wide compatibility and performance issues)
				function _indicatorsMap(fn) {
					for (var i = that.indicators.length; i--;) {
						fn.call(that.indicators[i]);
					}
				}

				if (this.options.fadeScrollbars) {
					this.on('scrollEnd', function () {
						_indicatorsMap(function () {
							this.fade();
						});
					});

					this.on('scrollCancel', function () {
						_indicatorsMap(function () {
							this.fade();
						});
					});

					this.on('scrollStart', function () {
						_indicatorsMap(function () {
							this.fade(1);
						});
					});

					this.on('beforeScrollStart', function () {
						_indicatorsMap(function () {
							this.fade(1, true);
						});
					});
				}


				this.on('refresh', function () {
					_indicatorsMap(function () {
						this.refresh();
					});
				});

				this.on('destroy', function () {
					_indicatorsMap(function () {
						this.destroy();
					});

					delete this.indicators;
				});
			},

			_initWheel: function () {
				utils.addEvent(this.wrapper, 'wheel', this);
				utils.addEvent(this.wrapper, 'mousewheel', this);
				utils.addEvent(this.wrapper, 'DOMMouseScroll', this);

				this.on('destroy', function () {
					utils.removeEvent(this.wrapper, 'wheel', this);
					utils.removeEvent(this.wrapper, 'mousewheel', this);
					utils.removeEvent(this.wrapper, 'DOMMouseScroll', this);
				});
			},

			_wheel: function (e) {
				if (!this.enabled) {
					return;
				}

				e.preventDefault();
				e.stopPropagation();

				var wheelDeltaX, wheelDeltaY,
					newX, newY,
					that = this;

				if (this.wheelTimeout === undefined) {
					that._execEvent('scrollStart');
				}

				// Execute the scrollEnd event after 400ms the wheel stopped scrolling
				clearTimeout(this.wheelTimeout);
				this.wheelTimeout = setTimeout(function () {
					that._execEvent('scrollEnd');
					that.wheelTimeout = undefined;
				}, 400);

				if ('deltaX' in e) {
					if (e.deltaMode === 1) {
						wheelDeltaX = -e.deltaX * this.options.mouseWheelSpeed;
						wheelDeltaY = -e.deltaY * this.options.mouseWheelSpeed;
					} else {
						wheelDeltaX = -e.deltaX;
						wheelDeltaY = -e.deltaY;
					}
				} else if ('wheelDeltaX' in e) {
					wheelDeltaX = e.wheelDeltaX / 120 * this.options.mouseWheelSpeed;
					wheelDeltaY = e.wheelDeltaY / 120 * this.options.mouseWheelSpeed;
				} else if ('wheelDelta' in e) {
					wheelDeltaX = wheelDeltaY = e.wheelDelta / 120 * this.options.mouseWheelSpeed;
				} else if ('detail' in e) {
					wheelDeltaX = wheelDeltaY = -e.detail / 3 * this.options.mouseWheelSpeed;
				} else {
					return;
				}

				wheelDeltaX *= this.options.invertWheelDirection;
				wheelDeltaY *= this.options.invertWheelDirection;

				if (!this.hasVerticalScroll) {
					wheelDeltaX = wheelDeltaY;
					wheelDeltaY = 0;
				}

				if (this.options.snap) {
					newX = this.currentPage.pageX;
					newY = this.currentPage.pageY;

					if (wheelDeltaX > 0) {
						newX--;
					} else if (wheelDeltaX < 0) {
						newX++;
					}

					if (wheelDeltaY > 0) {
						newY--;
					} else if (wheelDeltaY < 0) {
						newY++;
					}

					this.goToPage(newX, newY);

					return;
				}

				newX = this.x + Math.round(this.hasHorizontalScroll ? wheelDeltaX : 0);
				newY = this.y + Math.round(this.hasVerticalScroll ? wheelDeltaY : 0);

				if (newX > 0) {
					newX = 0;
				} else if (newX < this.maxScrollX) {
					newX = this.maxScrollX;
				}

				if (newY > 0) {
					newY = 0;
				} else if (newY < this.maxScrollY) {
					newY = this.maxScrollY;
				}

				this.scrollTo(newX, newY, 0);

				if (this.options.probeType > 1) {
					this._execEvent('scroll');
				}

				// INSERT POINT: _wheel
			},

			_initSnap: function () {
				this.currentPage = {};

				if (typeof this.options.snap == 'string') {
					this.options.snap = this.scroller.querySelectorAll(this.options.snap);
				}

				this.on('refresh', function () {
					var i = 0,
						l,
						m = 0,
						n,
						cx, cy,
						x = 0,
						y,
						stepX = this.options.snapStepX || this.wrapperWidth,
						stepY = this.options.snapStepY || this.wrapperHeight,
						el;

					this.pages = [];

					if (!this.wrapperWidth || !this.wrapperHeight || !this.scrollerWidth || !this.scrollerHeight) {
						return;
					}

					if (this.options.snap === true) {
						cx = Math.round(stepX / 2);
						cy = Math.round(stepY / 2);

						while (x > -this.scrollerWidth) {
							this.pages[i] = [];
							l = 0;
							y = 0;

							while (y > -this.scrollerHeight) {
								this.pages[i][l] = {
									x: Math.max(x, this.maxScrollX),
									y: Math.max(y, this.maxScrollY),
									width: stepX,
									height: stepY,
									cx: x - cx,
									cy: y - cy
								};

								y -= stepY;
								l++;
							}

							x -= stepX;
							i++;
						}
					} else {
						el = this.options.snap;
						l = el.length;
						n = -1;

						for (; i < l; i++) {
							if (i === 0 || el[i].offsetLeft <= el[i - 1].offsetLeft) {
								m = 0;
								n++;
							}

							if (!this.pages[m]) {
								this.pages[m] = [];
							}

							x = Math.max(-el[i].offsetLeft, this.maxScrollX);
							y = Math.max(-el[i].offsetTop, this.maxScrollY);
							cx = x - Math.round(el[i].offsetWidth / 2);
							cy = y - Math.round(el[i].offsetHeight / 2);

							this.pages[m][n] = {
								x: x,
								y: y,
								width: el[i].offsetWidth,
								height: el[i].offsetHeight,
								cx: cx,
								cy: cy
							};

							if (x > this.maxScrollX) {
								m++;
							}
						}
					}

					this.goToPage(this.currentPage.pageX || 0, this.currentPage.pageY || 0, 0);

					// Update snap threshold if needed
					if (this.options.snapThreshold % 1 === 0) {
						this.snapThresholdX = this.options.snapThreshold;
						this.snapThresholdY = this.options.snapThreshold;
					} else {
						this.snapThresholdX = Math.round(this.pages[this.currentPage.pageX][this.currentPage.pageY].width * this.options.snapThreshold);
						this.snapThresholdY = Math.round(this.pages[this.currentPage.pageX][this.currentPage.pageY].height * this.options.snapThreshold);
					}
				});

				this.on('flick', function () {
					var time = this.options.snapSpeed || Math.max(
						Math.max(
							Math.min(Math.abs(this.x - this.startX), 1000),
							Math.min(Math.abs(this.y - this.startY), 1000)
						), 300);

					this.goToPage(
						this.currentPage.pageX + this.directionX,
						this.currentPage.pageY + this.directionY,
						time
					);
				});
			},

			_nearestSnap: function (x, y) {
				if (!this.pages.length) {
					return {
						x: 0,
						y: 0,
						pageX: 0,
						pageY: 0
					};
				}

				var i = 0,
					l = this.pages.length,
					m = 0;

				// Check if we exceeded the snap threshold
				if (Math.abs(x - this.absStartX) < this.snapThresholdX &&
					Math.abs(y - this.absStartY) < this.snapThresholdY) {
					return this.currentPage;
				}

				if (x > 0) {
					x = 0;
				} else if (x < this.maxScrollX) {
					x = this.maxScrollX;
				}

				if (y > 0) {
					y = 0;
				} else if (y < this.maxScrollY) {
					y = this.maxScrollY;
				}

				for (; i < l; i++) {
					if (x >= this.pages[i][0].cx) {
						x = this.pages[i][0].x;
						break;
					}
				}

				l = this.pages[i].length;

				for (; m < l; m++) {
					if (y >= this.pages[0][m].cy) {
						y = this.pages[0][m].y;
						break;
					}
				}

				if (i == this.currentPage.pageX) {
					i += this.directionX;

					if (i < 0) {
						i = 0;
					} else if (i >= this.pages.length) {
						i = this.pages.length - 1;
					}

					x = this.pages[i][0].x;
				}

				if (m == this.currentPage.pageY) {
					m += this.directionY;

					if (m < 0) {
						m = 0;
					} else if (m >= this.pages[0].length) {
						m = this.pages[0].length - 1;
					}

					y = this.pages[0][m].y;
				}

				return {
					x: x,
					y: y,
					pageX: i,
					pageY: m
				};
			},

			goToPage: function (x, y, time, easing) {
				easing = easing || this.options.bounceEasing;

				if (x >= this.pages.length) {
					x = this.pages.length - 1;
				} else if (x < 0) {
					x = 0;
				}

				if (y >= this.pages[x].length) {
					y = this.pages[x].length - 1;
				} else if (y < 0) {
					y = 0;
				}

				var posX = this.pages[x][y].x,
					posY = this.pages[x][y].y;

				time = time === undefined ? this.options.snapSpeed || Math.max(
					Math.max(
						Math.min(Math.abs(posX - this.x), 1000),
						Math.min(Math.abs(posY - this.y), 1000)
					), 300) : time;

				this.currentPage = {
					x: posX,
					y: posY,
					pageX: x,
					pageY: y
				};

				this.scrollTo(posX, posY, time, easing);
			},

			next: function (time, easing) {
				var x = this.currentPage.pageX,
					y = this.currentPage.pageY;

				x++;

				if (x >= this.pages.length && this.hasVerticalScroll) {
					x = 0;
					y++;
				}

				this.goToPage(x, y, time, easing);
			},

			prev: function (time, easing) {
				var x = this.currentPage.pageX,
					y = this.currentPage.pageY;

				x--;

				if (x < 0 && this.hasVerticalScroll) {
					x = 0;
					y--;
				}

				this.goToPage(x, y, time, easing);
			},

			_initKeys: function (e) {
				// default key bindings
				var keys = {
					pageUp: 33,
					pageDown: 34,
					end: 35,
					home: 36,
					left: 37,
					up: 38,
					right: 39,
					down: 40
				};
				var i;

				// if you give me characters I give you keycode
				if (typeof this.options.keyBindings == 'object') {
					for (i in this.options.keyBindings) {
						if (typeof this.options.keyBindings[i] == 'string') {
							this.options.keyBindings[i] = this.options.keyBindings[i].toUpperCase().charCodeAt(0);
						}
					}
				} else {
					this.options.keyBindings = {};
				}

				for (i in keys) {
					this.options.keyBindings[i] = this.options.keyBindings[i] || keys[i];
				}

				utils.addEvent(window, 'keydown', this);

				this.on('destroy', function () {
					utils.removeEvent(window, 'keydown', this);
				});
			},

			_key: function (e) {
				if (!this.enabled) {
					return;
				}

				var snap = this.options.snap, // we are using this alot, better to cache it
					newX = snap ? this.currentPage.pageX : this.x,
					newY = snap ? this.currentPage.pageY : this.y,
					now = utils.getTime(),
					prevTime = this.keyTime || 0,
					acceleration = 0.250,
					pos;

				if (this.options.useTransition && this.isInTransition) {
					pos = this.getComputedPosition();

					this._translate(Math.round(pos.x), Math.round(pos.y));
					this.isInTransition = false;
				}

				this.keyAcceleration = now - prevTime < 200 ? Math.min(this.keyAcceleration + acceleration, 50) : 0;

				switch (e.keyCode) {
					case this.options.keyBindings.pageUp:
						if (this.hasHorizontalScroll && !this.hasVerticalScroll) {
							newX += snap ? 1 : this.wrapperWidth;
						} else {
							newY += snap ? 1 : this.wrapperHeight;
						}
						break;
					case this.options.keyBindings.pageDown:
						if (this.hasHorizontalScroll && !this.hasVerticalScroll) {
							newX -= snap ? 1 : this.wrapperWidth;
						} else {
							newY -= snap ? 1 : this.wrapperHeight;
						}
						break;
					case this.options.keyBindings.end:
						newX = snap ? this.pages.length - 1 : this.maxScrollX;
						newY = snap ? this.pages[0].length - 1 : this.maxScrollY;
						break;
					case this.options.keyBindings.home:
						newX = 0;
						newY = 0;
						break;
					case this.options.keyBindings.left:
						newX += snap ? -1 : 5 + this.keyAcceleration >> 0;
						break;
					case this.options.keyBindings.up:
						newY += snap ? 1 : 5 + this.keyAcceleration >> 0;
						break;
					case this.options.keyBindings.right:
						newX -= snap ? -1 : 5 + this.keyAcceleration >> 0;
						break;
					case this.options.keyBindings.down:
						newY -= snap ? 1 : 5 + this.keyAcceleration >> 0;
						break;
					default:
						return;
				}

				if (snap) {
					this.goToPage(newX, newY);
					return;
				}

				if (newX > 0) {
					newX = 0;
					this.keyAcceleration = 0;
				} else if (newX < this.maxScrollX) {
					newX = this.maxScrollX;
					this.keyAcceleration = 0;
				}

				if (newY > 0) {
					newY = 0;
					this.keyAcceleration = 0;
				} else if (newY < this.maxScrollY) {
					newY = this.maxScrollY;
					this.keyAcceleration = 0;
				}

				this.scrollTo(newX, newY, 0);

				this.keyTime = now;
			},

			_animate: function (destX, destY, duration, easingFn) {
				var that = this,
					startX = this.x,
					startY = this.y,
					startTime = utils.getTime(),
					destTime = startTime + duration;

				function step() {
					var now = utils.getTime(),
						newX, newY,
						easing;

					if (now >= destTime) {
						that.isAnimating = false;
						that._translate(destX, destY);

						if (!that.resetPosition(that.options.bounceTime)) {
							that._execEvent('scrollEnd');
						}

						return;
					}

					now = (now - startTime) / duration;
					easing = easingFn(now);
					newX = (destX - startX) * easing + startX;
					newY = (destY - startY) * easing + startY;
					that._translate(newX, newY);

					if (that.isAnimating) {
						rAF(step);
					}

					if (that.options.probeType == 3) {
						that._execEvent('scroll');
					}
				}

				this.isAnimating = true;
				step();
			},

			handleEvent: function (e) {
				switch (e.type) {
					case 'touchstart':
					case 'pointerdown':
					case 'MSPointerDown':
					case 'mousedown':
						this._start(e);
						break;
					case 'touchmove':
					case 'pointermove':
					case 'MSPointerMove':
					case 'mousemove':
						this._move(e);
						break;
					case 'touchend':
					case 'pointerup':
					case 'MSPointerUp':
					case 'mouseup':
					case 'touchcancel':
					case 'pointercancel':
					case 'MSPointerCancel':
					case 'mousecancel':
						this._end(e);
						break;
					case 'orientationchange':
					case 'resize':
						this._resize();
						break;
					case 'transitionend':
					case 'webkitTransitionEnd':
					case 'oTransitionEnd':
					case 'MSTransitionEnd':
						this._transitionEnd(e);
						break;
					case 'wheel':
					case 'DOMMouseScroll':
					case 'mousewheel':
						this._wheel(e);
						break;
					case 'keydown':
						this._key(e);
						break;
					case 'click':
						if (!e._constructed) {
							e.preventDefault();
							e.stopPropagation();
						}
						break;
				}
			}
		};

		function createDefaultScrollbar(direction, interactive, type) {
			var scrollbar = document.createElement('div'),
				indicator = document.createElement('div');

			if (type === true) {
				scrollbar.style.cssText = 'position:absolute;z-index:9999';
				indicator.style.cssText = '-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;position:absolute;background:rgba(0,0,0,0.5);border:1px solid rgba(255,255,255,0.9);border-radius:3px';
			}

			indicator.className = 'iScrollIndicator';

			if (direction == 'h') {
				if (type === true) {
					scrollbar.style.cssText += ';height:7px;left:2px;right:2px;bottom:0';
					indicator.style.height = '100%';
				}
				scrollbar.className = 'iScrollHorizontalScrollbar';
			} else {
				if (type === true) {
					scrollbar.style.cssText += ';width:7px;bottom:2px;top:2px;right:1px';
					indicator.style.width = '100%';
				}
				scrollbar.className = 'iScrollVerticalScrollbar';
			}

			scrollbar.style.cssText += ';overflow:hidden';

			if (!interactive) {
				scrollbar.style.pointerEvents = 'none';
			}

			scrollbar.appendChild(indicator);

			return scrollbar;
		}

		function Indicator(scroller, options) {
			this.wrapper = typeof options.el == 'string' ? document.querySelector(options.el) : options.el;
			this.wrapperStyle = this.wrapper.style;
			this.indicator = this.wrapper.children[0];
			this.indicatorStyle = this.indicator.style;
			this.scroller = scroller;

			this.options = {
				listenX: true,
				listenY: true,
				interactive: false,
				resize: true,
				defaultScrollbars: false,
				shrink: false,
				fade: false,
				speedRatioX: 0,
				speedRatioY: 0
			};

			for (var i in options) {
				this.options[i] = options[i];
			}

			this.sizeRatioX = 1;
			this.sizeRatioY = 1;
			this.maxPosX = 0;
			this.maxPosY = 0;

			if (this.options.interactive) {
				if (!this.options.disableTouch) {
					utils.addEvent(this.indicator, 'touchstart', this);
					utils.addEvent(window, 'touchend', this);
				}
				if (!this.options.disablePointer) {
					utils.addEvent(this.indicator, utils.prefixPointerEvent('pointerdown'), this);
					utils.addEvent(window, utils.prefixPointerEvent('pointerup'), this);
				}
				if (!this.options.disableMouse) {
					utils.addEvent(this.indicator, 'mousedown', this);
					utils.addEvent(window, 'mouseup', this);
				}
			}

			if (this.options.fade) {
				this.wrapperStyle[utils.style.transform] = this.scroller.translateZ;
				this.wrapperStyle[utils.style.transitionDuration] = utils.isBadAndroid ? '0.001s' : '0ms';
				this.wrapperStyle.opacity = '0';
			}
		}

		Indicator.prototype = {
			handleEvent: function (e) {
				switch (e.type) {
					case 'touchstart':
					case 'pointerdown':
					case 'MSPointerDown':
					case 'mousedown':
						this._start(e);
						break;
					case 'touchmove':
					case 'pointermove':
					case 'MSPointerMove':
					case 'mousemove':
						this._move(e);
						break;
					case 'touchend':
					case 'pointerup':
					case 'MSPointerUp':
					case 'mouseup':
					case 'touchcancel':
					case 'pointercancel':
					case 'MSPointerCancel':
					case 'mousecancel':
						this._end(e);
						break;
				}
			},

			destroy: function () {
				if (this.options.interactive) {
					utils.removeEvent(this.indicator, 'touchstart', this);
					utils.removeEvent(this.indicator, utils.prefixPointerEvent('pointerdown'), this);
					utils.removeEvent(this.indicator, 'mousedown', this);

					utils.removeEvent(window, 'touchmove', this);
					utils.removeEvent(window, utils.prefixPointerEvent('pointermove'), this);
					utils.removeEvent(window, 'mousemove', this);

					utils.removeEvent(window, 'touchend', this);
					utils.removeEvent(window, utils.prefixPointerEvent('pointerup'), this);
					utils.removeEvent(window, 'mouseup', this);
				}

				if (this.options.defaultScrollbars) {
					this.wrapper.parentNode.removeChild(this.wrapper);
				}
			},

			_start: function (e) {
				var point = e.touches ? e.touches[0] : e;

				e.preventDefault();
				e.stopPropagation();

				this.transitionTime();

				this.initiated = true;
				this.moved = false;
				this.lastPointX = point.pageX;
				this.lastPointY = point.pageY;

				this.startTime = utils.getTime();

				if (!this.options.disableTouch) {
					utils.addEvent(window, 'touchmove', this);
				}
				if (!this.options.disablePointer) {
					utils.addEvent(window, utils.prefixPointerEvent('pointermove'), this);
				}
				if (!this.options.disableMouse) {
					utils.addEvent(window, 'mousemove', this);
				}

				this.scroller._execEvent('beforeScrollStart');
			},

			_move: function (e) {
				var point = e.touches ? e.touches[0] : e,
					deltaX, deltaY,
					newX, newY,
					timestamp = utils.getTime();

				if (!this.moved) {
					this.scroller._execEvent('scrollStart');
				}

				this.moved = true;

				deltaX = point.pageX - this.lastPointX;
				this.lastPointX = point.pageX;

				deltaY = point.pageY - this.lastPointY;
				this.lastPointY = point.pageY;

				newX = this.x + deltaX;
				newY = this.y + deltaY;

				this._pos(newX, newY);


				if (this.scroller.options.probeType == 1 && timestamp - this.startTime > 300) {
					this.startTime = timestamp;
					this.scroller._execEvent('scroll');
				} else if (this.scroller.options.probeType > 1) {
					this.scroller._execEvent('scroll');
				}


				// INSERT POINT: indicator._move

				e.preventDefault();
				e.stopPropagation();
			},

			_end: function (e) {
				if (!this.initiated) {
					return;
				}

				this.initiated = false;

				e.preventDefault();
				e.stopPropagation();

				utils.removeEvent(window, 'touchmove', this);
				utils.removeEvent(window, utils.prefixPointerEvent('pointermove'), this);
				utils.removeEvent(window, 'mousemove', this);

				if (this.scroller.options.snap) {
					var snap = this.scroller._nearestSnap(this.scroller.x, this.scroller.y);

					var time = this.options.snapSpeed || Math.max(
						Math.max(
							Math.min(Math.abs(this.scroller.x - snap.x), 1000),
							Math.min(Math.abs(this.scroller.y - snap.y), 1000)
						), 300);

					if (this.scroller.x != snap.x || this.scroller.y != snap.y) {
						this.scroller.directionX = 0;
						this.scroller.directionY = 0;
						this.scroller.currentPage = snap;
						this.scroller.scrollTo(snap.x, snap.y, time, this.scroller.options.bounceEasing);
					}
				}

				if (this.moved) {
					this.scroller._execEvent('scrollEnd');
				}
			},

			transitionTime: function (time) {
				time = time || 0;
				this.indicatorStyle[utils.style.transitionDuration] = time + 'ms';

				if (!time && utils.isBadAndroid) {
					this.indicatorStyle[utils.style.transitionDuration] = '0.001s';
				}
			},

			transitionTimingFunction: function (easing) {
				this.indicatorStyle[utils.style.transitionTimingFunction] = easing;
			},

			refresh: function () {
				this.transitionTime();

				if (this.options.listenX && !this.options.listenY) {
					this.indicatorStyle.display = this.scroller.hasHorizontalScroll ? 'block' : 'none';
				} else if (this.options.listenY && !this.options.listenX) {
					this.indicatorStyle.display = this.scroller.hasVerticalScroll ? 'block' : 'none';
				} else {
					this.indicatorStyle.display = this.scroller.hasHorizontalScroll || this.scroller.hasVerticalScroll ? 'block' : 'none';
				}

				if (this.scroller.hasHorizontalScroll && this.scroller.hasVerticalScroll) {
					utils.addClass(this.wrapper, 'iScrollBothScrollbars');
					utils.removeClass(this.wrapper, 'iScrollLoneScrollbar');

					if (this.options.defaultScrollbars && this.options.customStyle) {
						if (this.options.listenX) {
							this.wrapper.style.right = '8px';
						} else {
							this.wrapper.style.bottom = '8px';
						}
					}
				} else {
					utils.removeClass(this.wrapper, 'iScrollBothScrollbars');
					utils.addClass(this.wrapper, 'iScrollLoneScrollbar');

					if (this.options.defaultScrollbars && this.options.customStyle) {
						if (this.options.listenX) {
							this.wrapper.style.right = '2px';
						} else {
							this.wrapper.style.bottom = '2px';
						}
					}
				}

				var r = this.wrapper.offsetHeight; // force refresh

				if (this.options.listenX) {
					this.wrapperWidth = this.wrapper.clientWidth;
					if (this.options.resize) {
						this.indicatorWidth = Math.max(Math.round(this.wrapperWidth * this.wrapperWidth / (this.scroller.scrollerWidth || this.wrapperWidth || 1)), 8);
						this.indicatorStyle.width = this.indicatorWidth + 'px';
					} else {
						this.indicatorWidth = this.indicator.clientWidth;
					}

					this.maxPosX = this.wrapperWidth - this.indicatorWidth;

					if (this.options.shrink == 'clip') {
						this.minBoundaryX = -this.indicatorWidth + 8;
						this.maxBoundaryX = this.wrapperWidth - 8;
					} else {
						this.minBoundaryX = 0;
						this.maxBoundaryX = this.maxPosX;
					}

					this.sizeRatioX = this.options.speedRatioX || (this.scroller.maxScrollX && (this.maxPosX / this.scroller.maxScrollX));
				}

				if (this.options.listenY) {
					this.wrapperHeight = this.wrapper.clientHeight;
					if (this.options.resize) {
						this.indicatorHeight = Math.max(Math.round(this.wrapperHeight * this.wrapperHeight / (this.scroller.scrollerHeight || this.wrapperHeight || 1)), 8);
						this.indicatorStyle.height = this.indicatorHeight + 'px';
					} else {
						this.indicatorHeight = this.indicator.clientHeight;
					}

					this.maxPosY = this.wrapperHeight - this.indicatorHeight;

					if (this.options.shrink == 'clip') {
						this.minBoundaryY = -this.indicatorHeight + 8;
						this.maxBoundaryY = this.wrapperHeight - 8;
					} else {
						this.minBoundaryY = 0;
						this.maxBoundaryY = this.maxPosY;
					}

					this.maxPosY = this.wrapperHeight - this.indicatorHeight;
					this.sizeRatioY = this.options.speedRatioY || (this.scroller.maxScrollY && (this.maxPosY / this.scroller.maxScrollY));
				}

				this.updatePosition();
			},

			updatePosition: function () {
				var x = this.options.listenX && Math.round(this.sizeRatioX * this.scroller.x) || 0,
					y = this.options.listenY && Math.round(this.sizeRatioY * this.scroller.y) || 0;

				if (!this.options.ignoreBoundaries) {
					if (x < this.minBoundaryX) {
						if (this.options.shrink == 'scale') {
							this.width = Math.max(this.indicatorWidth + x, 8);
							this.indicatorStyle.width = this.width + 'px';
						}
						x = this.minBoundaryX;
					} else if (x > this.maxBoundaryX) {
						if (this.options.shrink == 'scale') {
							this.width = Math.max(this.indicatorWidth - (x - this.maxPosX), 8);
							this.indicatorStyle.width = this.width + 'px';
							x = this.maxPosX + this.indicatorWidth - this.width;
						} else {
							x = this.maxBoundaryX;
						}
					} else if (this.options.shrink == 'scale' && this.width != this.indicatorWidth) {
						this.width = this.indicatorWidth;
						this.indicatorStyle.width = this.width + 'px';
					}

					if (y < this.minBoundaryY) {
						if (this.options.shrink == 'scale') {
							this.height = Math.max(this.indicatorHeight + y * 3, 8);
							this.indicatorStyle.height = this.height + 'px';
						}
						y = this.minBoundaryY;
					} else if (y > this.maxBoundaryY) {
						if (this.options.shrink == 'scale') {
							this.height = Math.max(this.indicatorHeight - (y - this.maxPosY) * 3, 8);
							this.indicatorStyle.height = this.height + 'px';
							y = this.maxPosY + this.indicatorHeight - this.height;
						} else {
							y = this.maxBoundaryY;
						}
					} else if (this.options.shrink == 'scale' && this.height != this.indicatorHeight) {
						this.height = this.indicatorHeight;
						this.indicatorStyle.height = this.height + 'px';
					}
				}

				this.x = x;
				this.y = y;

				if (this.scroller.options.useTransform) {
					this.indicatorStyle[utils.style.transform] = 'translate(' + x + 'px,' + y + 'px)' + this.scroller.translateZ;
				} else {
					this.indicatorStyle.left = x + 'px';
					this.indicatorStyle.top = y + 'px';
				}
			},

			_pos: function (x, y) {
				if (x < 0) {
					x = 0;
				} else if (x > this.maxPosX) {
					x = this.maxPosX;
				}

				if (y < 0) {
					y = 0;
				} else if (y > this.maxPosY) {
					y = this.maxPosY;
				}

				x = this.options.listenX ? Math.round(x / this.sizeRatioX) : this.scroller.x;
				y = this.options.listenY ? Math.round(y / this.sizeRatioY) : this.scroller.y;

				this.scroller.scrollTo(x, y);
			},

			fade: function (val, hold) {
				if (hold && !this.visible) {
					return;
				}

				clearTimeout(this.fadeTimeout);
				this.fadeTimeout = null;

				var time = val ? 250 : 500,
					delay = val ? 0 : 300;

				val = val ? '1' : '0';

				this.wrapperStyle[utils.style.transitionDuration] = time + 'ms';

				this.fadeTimeout = setTimeout((function (val) {
					this.wrapperStyle.opacity = val;
					this.visible = +val;
				}).bind(this, val), delay);
			}
		};

		IScroll.utils = utils;

		return function (el, options) {
			return new IScroll(el, options)
		}
	})
	.factory('Layer', function () {

		function Layer(html, opts) {
			if (!(this instanceof Layer)) {
				return new Layer(html, opts);
			}
			this.html = html;
			this.opts = opts;
			var el = document.createElement('div');
			var layer_el = document.createElement('div');
			layer_el.className = 'ios-select-layer';
			this.el = el;
			this.layer_el = layer_el;
			this.layer_el.innerHTML = this.html;
			document.body.appendChild(this.el);
			this.el.appendChild(this.layer_el);
			this.el.style.height = Math.max(document.documentElement.getBoundingClientRect().height, window.innerHeight);
			if (this.opts.className) {
				this.el.className += ' ' + this.opts.className;
			}

		}


		return function (html, opts) {
			return new Layer(html, opts)
		}
	})
	.factory('Tool', ['$log', function ($log) {
		return {
			attrToData: function (dom, index) {

				var obj = {};
				for (var p in dom.dataset) {
					obj[p] = dom.dataset[p];
				}
				obj['dom'] = dom;
				obj['atindex'] = index;
				obj['index'] = parseInt(dom.getAttribute('i'));
				return obj;
			},
			attrToHtml: function (obj) {
				var html = '';
				for (var p in obj) {
					html += 'data-' + p + '="' + obj[p] + '"';
				}
				return html;
			},
			isLeapYear: function (year) {
				year = parseInt(year);
				return (year % 4 == 0) && (year % 100 != 0 || year % 400 == 0);
			},
			dateSplit: function (date, len) {

				if (!date) {
					return date;
				}

				var arr;

				if (len != 5) {
					arr = date.split('-');

					if (arr.length != len) {
						arr = date.split('/');
					}

					if (arr.length != len) {
						if (len == 3) {
							arr = date.split('年');
							var month = arr[1].split('月');
							arr[1] = month[0];
							var day = month[1].split('日');
							arr[2] = day[0];
						} else if (len == 2) {
							arr = date.split('年');
							var month = arr[1].split('月');
							arr[1] = month[0];
						}
					}
				} else {
					arr = date.split('-');

					if (arr.length == 3) {
						var timeSplit = arr[2].split(' ');
						arr[2] = timeSplit[0];
						var timeSplit2 = timeSplit[1].split(':');
						arr[3] = timeSplit2[0];
						arr[4] = timeSplit2[1];
					}

					if (arr.length != 5) {
						arr = date.split('/');

						if (arr.length == 3) {
							var timeSplit = arr[2].split(' ');
							arr[2] = timeSplit[0];
							var timeSplit2 = timeSplit[1].split(':');
							arr[3] = timeSplit2[0];
							arr[4] = timeSplit2[1];

						}
					}


					if (arr.length != 5) {
						arr = date.split('年');
						var month = arr[1].split('月');
						arr[1] = month[0];
						var day = month[1].split('日');
						arr[2] = day[0];
						var time = day[1].split(' ')[1];
						arr[3] = time.split(':')[0];
						arr[4] = time.split(':')[1];
					}


				}

				angular.forEach(arr, function (data, index) {
					arr[index] = parseInt(data);
				});


				return arr
			},
			timeSplit: function (time) {
				if (!time) {
					return time;
				}

				var arr;
				arr = time.split(':');

				if (arr[1].split(' ').length == 2) {
					var ampm = arr[1].split(' ');
					arr[1] = ampm[0];
					arr[2] = ampm[1];
				}

				angular.forEach(arr, function (data, index) {
					arr[index] = parseInt(data) ? parseInt(data) : data;
				});

				return arr
			},
			removeChinese: function () {},
			crateReturnDate: function (type, one, two, three, four, five) {

				var argumentsLen = arguments.length;

				var dateStr = '';

				function removeChinese(str) {
					var chinesePos = str.search(/[\u4e00-\u9fa5]/);

					return str.slice(0, chinesePos);
				}

				if (type == 'y-m-d') {
					angular.forEach(arguments, function (data, index) {
						if (index == 0) {
							return;
						}
						if (index == argumentsLen - 1) {
							dateStr += removeChinese(data.value);
							return;
						}
						dateStr += (removeChinese(data.value) + '-')
					})

				} else if (type == 'y/m/d') {
					angular.forEach(arguments, function (data, index) {
						if (index == 0) {
							return;
						}
						if (index == argumentsLen - 1) {
							dateStr += removeChinese(data.value);
							return;
						}
						dateStr += (removeChinese(data.value) + '/')
					})
				} else if (type == 'ymd') {
					var timeNameArr = ['', '', '', '', '时', '分', '秒'];

					angular.forEach(arguments, function (data, index) {
						if (index == 0) {
							return;
						}
						dateStr += (data.value + timeNameArr[index])
					})
				} else {
					$log.error('returnType no this type')
				}

				return dateStr;
			},
			crateReturnDateTime: function (type, one, two, three, four, five) {

				var dateStr = '';

				function removeChinese(str) {
					var chinesePos = str.search(/[\u4e00-\u9fa5]/);
					if (chinesePos < 0) {
						return str
					} else {
						return str.slice(0, chinesePos);
					}
				}

				var timeNameArr;

				if (type == 'y-m-d') {
					timeNameArr = ['', '-', '-', ' ', ':', ''];

				} else if (type == 'y/m/d') {
					timeNameArr = ['', '/', '/', ' ', ':', ''];
				} else if (type == 'ymd') {
					timeNameArr = ['', '', '', ' ', ':', ''];

				} else {
					$log.error('returnType no this type')
				}

				angular.forEach(arguments, function (data, index) {
					if (index == 0) {
						return;
					}
					var value = data.value;
					if (type == 'y/m/d' || type == 'y-m-d') {
						value = removeChinese(value);
					}
					dateStr += (value + timeNameArr[index])
				});

				return dateStr;
			},
			crateReturnTime: function (type, one, two, three) {
				if (type == 'AMPM') {
					return one.value + ':' + two.value + ' ' + three.value;
				} else {
					return one.value + ':' + two.value;
				}
			},
			isIos7: function () {
				return (window.navigator.userAgent.search(/7_1_1/) != -1) ? true : false
			}
		}

	}])
	.factory('IosSelect', ['Layer', 'IScroll', 'Tool', function (Layer, IScroll, Tool) {


		function IosSelect(level, data, scope, options) {
			if (!angular.isArray(data) || data.length === 0 || !angular.isArray(data[0])) {
				return;
			}
			this.data = data;
			this.level = level || 1;
			this.options = options;
			switch (this.level) {
				case 1:
					this.typeBox = 'one-level-box';
					break;
				case 2:
					this.typeBox = 'two-level-box';
					break;
				case 3:
					this.typeBox = 'three-level-box';
					break;
				case 4:
					this.typeBox = 'four-level-box';
					break;
				case 5:
					this.typeBox = 'five-level-box';
					break;
			}

			this.callback = options.callback;
			this.title = options.title || '';
			this.itemHeight = options.itemHeight || 50;
			this.headerHeight = options.headerHeight || 44;
			this.scope = scope;
			this.init();
		};

		IosSelect.prototype = {
			init: function () {
				this.initLayer();

				this.selectOneObj = {};
				this.selectTwoObj = {};
				this.selectThreeObj = {};
				this.selectFourObj = {};
				this.selectFiveObj = {};
				this.setOneLevel(this.options.oneLevelId, this.options.twoLevelId, this.options.threeLevelId, this.options.fourLevelId, this.options.fiveLevelId);
			},
			initLayer: function () {
				var self = this;

				var dateAttrNameArray;


				if (self.options.attrNameType) {

					switch (self.options.attrNameType) {
						case 'y/m/d':
							dateAttrNameArray = ['/', '/', '', ':', ''];
							break;
						case 'ymd':
							dateAttrNameArray = ['年', '月', '日', ':', ''];
							break;
						case 'y-m-d':
							dateAttrNameArray = ['─', '─', '', ':', ''];
							break;
					}

				} else {
					dateAttrNameArray = ['', '', '', '', ''];
				}

				var all_html = [
					'<header class="iosselect-header">',
					'<h2 id="iosSelectTitle"></h2>',
					'<a href="javascript:void(0)" class="close">' + (self.scope.isCancel ? '取消' : '清除') + '</a>',
					'<a href="javascript:void(0)" class="sure">确定</a>',
					'</header>',
					'<hr class="cover-area1"/>',
					'<hr class="cover-area2"/>',
					'<div class="attr-name" style="display:none"><div class="year">' + dateAttrNameArray[0] + '</div><div class="month">' + dateAttrNameArray[1] + '</div><div class="day">' + dateAttrNameArray[2] + '</div><div class="colon">' + dateAttrNameArray[3] + '</div><div>' + dateAttrNameArray[4] + '</div></div>',
					'<section class="iosselect-box">',

					'<div class="one-level-contain" id="oneLevelContain">',
					'<ul class="select-one-level" attr="One">',
					'</ul>',
					'</div>',

					'<div class="two-level-contain" id="twoLevelContain">',
					'<ul class="select-two-level" attr="Two">',
					'</ul>',
					'</div>',

					'<div class="three-level-contain" id="threeLevelContain">',
					'<ul class="select-three-level" attr="Three">',
					'</ul>',
					'</div>',

					'<div class="four-level-contain" id="fourLevelContain">',
					'<ul class="select-four-level" attr="Four">',
					'</ul>',
					'</div>',

					'<div class="five-level-contain" id="fiveLevelContain">',
					'<ul class="select-five-level" attr="Five">',
					'</ul>',
					'</div>',
					'</section>',
				].join('\r\n');

				this.iosSelectLayer = Layer(all_html, {
					className: this.typeBox + (this.options.addClassName ? ' ' + this.options.addClassName : '')
				});

				this.iosSelectTitleDom = document.querySelector('#iosSelectTitle');


				this.iosSelectLayer.el.getElementsByClassName('iosselect-box')[0].addEventListener('touchstart', function (ev) {
					ev.preventDefault();
					ev.stopPropagation();
				}, false)


				if (this.options.title) {
					this.iosSelectTitleDom.innerHTML = this.options.title;
				}

				var customPadding = lib.flexible.rem2px(0.266);

				if (this.options.headerHeight && this.options.itemHeight) {
					this.coverArea1Dom = document.querySelector('.cover-area1');
					this.coverArea1Dom.style.top = this.headerHeight + this.itemHeight * 2 + customPadding + 'px';

					this.coverArea2Dom = document.querySelector('.cover-area2');
					var shimHeight = lib.flexible.rem2px(0.314);
					this.coverArea2Dom.style.top = this.headerHeight + this.itemHeight * 3 + customPadding + shimHeight + 'px';
				}

				this.oneLevelContainDom = document.querySelector('#oneLevelContain');
				this.twoLevelContainDom = document.querySelector('#twoLevelContain');
				this.threeLevelContainDom = document.querySelector('#threeLevelContain');
				this.fourLevelContainDom = document.querySelector('#fourLevelContain');
				this.fiveLevelContainDom = document.querySelector('#fiveLevelContain');

				this.oneLevelUlContainDom = document.querySelector('.select-one-level');
				this.twoLevelUlContainDom = document.querySelector('.select-two-level');
				this.threeLevelUlContainDom = document.querySelector('.select-three-level');
				this.fourLevelUlContainDom = document.querySelector('.select-four-level');
				this.fiveLevelUlContainDom = document.querySelector('.select-five-level');

				var tapSpeed = 100;

				var tapStartTime = 0,
					tapEndTime = 0,
					tapStartX = 0,
					tapStartY = 0,
					tapEndX = undefined,
					tapEndY = undefined;

				function getTimes() {

					return new Date().getTime();
				}


				function tapStartFunc(ev) {
					ev.preventDefault();
					if (!ev.target.getAttribute('i')) {

					} else {
						tapStartTime = getTimes();
						tapStartX = ev.pageX || ev.touches[0].pageX;
						tapStartY = ev.pageY || ev.touches[0].pageY;
						this.addEventListener('touchmove', tapMoveFunc, false);
						this.addEventListener('touchend', tapEndFunc, false);
					}
				}

				function tapMoveFunc(ev) {
					ev.preventDefault();
					tapEndX = ev.pageX || ev.touches[0].pageX;
					tapEndY = ev.pageY || ev.touches[0].pageY;
				}

				function tapEndFunc(ev) {
					ev.preventDefault();
					tapEndTime = getTimes();
					if ((tapEndTime - tapStartTime) <= 100 && (tapStartX == tapEndX || tapEndX == undefined) && (tapStartY == tapEndY || tapEndY == undefined)) {

						var attr = this.getAttribute('attr');
						var dataValue = ev.target.getAttribute('data-key');
						var isFreshen = false;

						if (self['select' + attr + 'Obj'].key == dataValue) {

						} else {
							var oneValue = (attr == 'One') ? dataValue : self['selectOneObj'].key,
								twoValue = (attr == 'Two') ? dataValue : self['selectTwoObj'].key,
								threeValue = (attr == 'Three') ? dataValue : self['selectThreeObj'].key,
								fourValue = (attr == 'Four') ? dataValue : self['selectFourObj'].key,
								fiveValue = (attr == 'Five') ? dataValue : self['selectFiveObj'].key;

							if (oneValue == self.options.startYear && self.options.openDate) {
								isFreshen = true;
								if (twoValue < self.options.startMonth) {
									twoValue = self.options.startMonth;
									threeValue = self.options.startDay;
								} else if (twoValue == self.options.startMonth && threeValue < self.options.startDay) {
									twoValue = self.options.startMonth;
									threeValue = self.options.startDay;
								}
							} else if (oneValue == self.options.endYear && self.options.openDate) {
								isFreshen = true;
								if (twoValue > self.options.endMonth) {
									twoValue = self.options.endMonth;
									threeValue = self.options.endDay;
								} else if (twoValue == self.options.endMonth && threeValue > self.options.endDay) {
									twoValue = self.options.endMonth;
									threeValue = self.options.endDay;
								}
							}
							var srollToPos = ((parseInt(ev.target.getAttribute('i'))) * self.itemHeight);
							self['scroll' + attr].scrollTo(0, -srollToPos, 300);

							isFreshen && self['set' + this.getAttribute('attr') + 'Level'](oneValue, twoValue, threeValue, fourValue, fiveValue);

						}


					} else {

					}
					tapEndX = undefined,
						tapEndY = undefined;
					this.removeEventListener('touchmove', tapMoveFunc);
					this.removeEventListener('touchend', tapEndFunc);

				}


				this.oneLevelUlContainDom.addEventListener('touchstart', tapStartFunc, false);
				this.twoLevelUlContainDom.addEventListener('touchstart', tapStartFunc, false);
				this.threeLevelUlContainDom.addEventListener('touchstart', tapStartFunc, false);
				this.fourLevelUlContainDom.addEventListener('touchstart', tapStartFunc, false);
				this.fiveLevelUlContainDom.addEventListener('touchstart', tapStartFunc, false);


				var atHeight = lib.flexible.rem2px(1.306);
				// this.iosSelectLayer.el.querySelector('.ios-select-layer').style.height = this.itemHeight * 5 + this.headerHeight + customPadding * 2 + 'px';
				this.iosSelectLayer.el.querySelector('.ios-select-layer').style.height = this.itemHeight * 4 + atHeight + this.headerHeight + customPadding * 2 + 'px';
				// this.oneLevelContainDom.style.height = this.itemHeight * 5 + 'px';
				this.oneLevelContainDom.style.height = this.itemHeight * 4 + atHeight + 'px';
				this.scrollOne = IScroll('#oneLevelContain', {
					probeType: 3,
					bounce: false,
					disableMouse: true
				});
				this.scrollOne.on('scrollStart', function () {
					Array.prototype.slice.call(self.oneLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
						if (v.classList.contains('at')) {
							v.classList.remove('at');
						} else if (v.classList.contains('side1')) {
							v.classList.remove('side1');
						} else if (v.classList.contains('side2')) {
							v.classList.remove('side2');
						}
					});
				});
				this.scrollOne.on('scroll', function () {
					var pa = Math.abs(this.y) / self.itemHeight;
					var plast = 1;

					plast = Math.round(pa) + 1;
					Array.prototype.slice.call(self.oneLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
						if (v.classList.contains('at')) {
							v.classList.remove('at');
						} else if (v.classList.contains('side1')) {
							v.classList.remove('side1');
						} else if (v.classList.contains('side2')) {
							v.classList.remove('side2');
						}
					});

					var pdom = self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');
					pdom.classList.add('at');

					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');
				});
				this.scrollOne.on('scrollEnd', function () {

					var pa = Math.abs(this.y) / self.itemHeight;
					var plast = 1;
					var to = 0;
					if (Math.ceil(pa) === Math.round(pa)) {
						to = (Math.ceil(pa) * self.itemHeight).toFixed(2);
						plast = Math.ceil(pa) + 1;
					} else {
						to = (Math.floor(pa) * self.itemHeight).toFixed(2);
						plast = Math.floor(pa) + 1;
					}
					self.scrollOne.scrollTo(0, -to, 0);

					var pdom = self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

					Array.prototype.slice.call(self.oneLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
						if (v.classList.contains('at')) {
							v.classList.remove('at');
						} else if (v.classList.contains('side1')) {
							v.classList.remove('side1');
						} else if (v.classList.contains('side2')) {
							v.classList.remove('side2');
						}
					});

					pdom.classList.add('at');

					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
					self.oneLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');

					self.selectOneObj = Tool.attrToData(pdom, plast);

					if (self.level > 1 && self.options.oneTwoRelation === 1) {
						self.setTwoLevel(self.selectOneObj.key);
					}

					if (self.options.openDate) {
						self.dateLimit();
					}
				});
				if (this.level >= 2) {
					// this.twoLevelContainDom.style.height = this.itemHeight * 5 + 'px';
					this.twoLevelContainDom.style.height = this.itemHeight * 4 + atHeight + 'px';
					this.scrollTwo = IScroll('#twoLevelContain', {
						probeType: 3,
						bounce: false,
						disableMouse: true
					});
					this.scrollTwo.on('scrollStart', function () {
						Array.prototype.slice.call(self.twoLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});
					});
					this.scrollTwo.on('scroll', function () {
						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 0;
						plast = Math.round(pa) + 1;

						var cdom = self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.twoLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						cdom.classList.add('at');

						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');
					});
					this.scrollTwo.on('scrollEnd', function () {

						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 1;
						var to = 0;
						if (Math.ceil(pa) === Math.round(pa)) {
							to = Math.ceil(pa) * self.itemHeight;
							plast = Math.ceil(pa) + 1;
						} else {
							to = Math.floor(pa) * self.itemHeight;
							plast = Math.floor(pa) + 1;
						}
						self.scrollTwo.scrollTo(0, -to, 0);

						var cdom = self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.twoLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						cdom.classList.add('at');

						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.twoLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');

						self.selectTwoObj = Tool.attrToData(cdom, plast);


						if (self.level > 2 && self.options.twoThreeRelation === 1) {

							self.setThreeLevel(self.selectOneObj.key, self.selectTwoObj.id);
						}


						if (self.options.openDate) {
							self.dateLimit();
						}
					});
				}
				if (this.level >= 3) {
					// this.threeLevelContainDom.style.height = this.itemHeight * 5 + 'px';
					this.threeLevelContainDom.style.height = this.itemHeight * 4 + atHeight + 'px';
					this.scrollThree = IScroll('#threeLevelContain', {
						probeType: 3,
						bounce: false,
						disableMouse: true
					});
					this.scrollThree.on('scrollStart', function () {
						Array.prototype.slice.call(self.threeLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});
					});
					this.scrollThree.on('scroll', function () {
						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 0;
						plast = Math.round(pa) + 1;

						var ddom = self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.threeLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						ddom.classList.add('at');

						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');
					});
					this.scrollThree.on('scrollEnd', function () {

						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 1;
						var to = 0;
						if (Math.ceil(pa) === Math.round(pa)) {
							to = Math.ceil(pa) * self.itemHeight;
							plast = Math.ceil(pa) + 1;
						} else {
							to = Math.floor(pa) * self.itemHeight;
							plast = Math.floor(pa) + 1;
						}
						self.scrollThree.scrollTo(0, -to, 0);

						var ddom = self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.threeLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						ddom.classList.add('at');

						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')') && self.threeLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');

						self.selectThreeObj = Tool.attrToData(ddom, plast);

						if (self.level > 3 && self.options.threeFourRelation === 1) {
							self.setFourLevel(self.selectOneObj.key, self.selectTwoObj.id);
						}

						if (self.options.openDate) {
							self.dateLimit();
						}
					});
				}
				if (this.level >= 4) {
					// this.fourLevelContainDom.style.height = this.itemHeight * 5 + 'px';
					this.fourLevelContainDom.style.height = this.itemHeight * 4 + atHeight + 'px';
					this.scrollFour = IScroll('#fourLevelContain', {
						probeType: 3,
						bounce: false,
						disableMouse: true
					});

					this.scrollFour.on('scrollStart', function () {
						Array.prototype.slice.call(self.fourLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});
					});

					this.scrollFour.on('scroll', function () {
						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 0;
						plast = Math.round(pa) + 1;

						var ddom = self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.fourLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						ddom.classList.add('at');

						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');
					});

					this.scrollFour.on('scrollEnd', function () {

						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 1;
						var to = 0;
						if (Math.ceil(pa) === Math.round(pa)) {
							to = Math.ceil(pa) * self.itemHeight;
							plast = Math.ceil(pa) + 1;
						} else {
							to = Math.floor(pa) * self.itemHeight;
							plast = Math.floor(pa) + 1;
						}
						self.scrollFour.scrollTo(0, -to, 0);

						var cdom = self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.fourLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						cdom.classList.add('at');

						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.fourLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');

						self.selectFourObj = Tool.attrToData(cdom, plast);


						if (self.level >= 5 && self.options.fourFiveRelation === 1) {
							self.setFourLevel(self.selectOneObj.key, self.selectTwoObj.id);
						}


						// if(self.options.openDate){
						//   self.dateLimit();
						// }
					});
				}
				if (this.level >= 5) {
					// this.fiveLevelContainDom.style.height = this.itemHeight * 5 + 'px';
					this.fiveLevelContainDom.style.height = this.itemHeight * 4 + atHeight + 'px';
					this.scrollFive = IScroll('#fiveLevelContain', {
						probeType: 3,
						bounce: false,
						disableMouse: true
					});

					this.scrollFive.on('scrollStart', function () {
						Array.prototype.slice.call(self.fiveLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});
					});

					this.scrollFive.on('scroll', function () {
						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 0;
						plast = Math.round(pa) + 1;

						var ddom = self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.fiveLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						ddom.classList.add('at');

						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');
					});

					this.scrollFive.on('scrollEnd', function () {

						var pa = Math.abs(this.y) / self.itemHeight;
						var plast = 1;
						var to = 0;
						if (Math.ceil(pa) === Math.round(pa)) {
							to = Math.ceil(pa) * self.itemHeight;
							plast = Math.ceil(pa) + 1;
						} else {
							to = Math.floor(pa) * self.itemHeight;
							plast = Math.floor(pa) + 1;
						}
						self.scrollFive.scrollTo(0, -to, 0);

						var cdom = self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 2) + ')');

						Array.prototype.slice.call(self.fiveLevelContainDom.querySelectorAll('li')).forEach(function (v, i, o) {
							if (v.classList.contains('at')) {
								v.classList.remove('at');
							} else if (v.classList.contains('side1')) {
								v.classList.remove('side1');
							} else if (v.classList.contains('side2')) {
								v.classList.remove('side2');
							}
						});

						cdom.classList.add('at');

						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 1) + ')').classList.add('side1');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 0) + ')').classList.add('side2');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 3) + ')').classList.add('side1');
						self.fiveLevelContainDom.querySelector('li:nth-child(' + (plast + 4) + ')').classList.add('side2');

						self.selectFiveObj = Tool.attrToData(cdom, plast);


						// if(self.options.openDate){
						//   self.dateLimit();
						// }
					});
				}
				this.selectBtnDom = this.iosSelectLayer.el.querySelector('.sure');
				this.closeBtnDom = this.iosSelectLayer.el.querySelector('.close');

				this.selectBtnDom.addEventListener('touchstart', function (e) {
					e.stopPropagation();
					setTimeout(function () {
						self.callback && self.callback(self.selectOneObj, self.selectTwoObj, self.selectThreeObj, self.selectFourObj, self.selectFiveObj);
					}, 300);
				}, false);

				this.closeBtnDom.addEventListener('touchstart', function (e) {
					e.stopPropagation();

					if (self.scope.isCancel) {
						self.scope.removeSelect(true);
					} else {
						setTimeout(function () {
							self.callback && self.callback(undefined, undefined, undefined);
						}, 300);
					}

				}, false);


				this.iosSelectLayer.el.addEventListener('touchstart', function (e) {

					setTimeout(function () {
						self.scope.removeSelect(true);
					}, 300);


				})


				this.iosSelectLayer.layer_el.addEventListener('click', function (e) {
					e.stopPropagation();

				}, false);
				return this.iosSelectLayer.el;
			},
			getOneLevel: function () {
				return this.data[0];
			},
			setOneLevel: function (oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId) {

				var oneLevelData = this.getOneLevel();
				if (!oneLevelId) {
					oneLevelId = oneLevelData[0]['key'];
				}
				var oneHtml = '';
				var self = this;
				var atIndex = 0;
				//oneHtml += '<li></li>';
				oneHtml += '<li></li>';
				oneHtml += '<li></li>';
				oneLevelData.forEach(function (v, i, o) {
					if (v.key == oneLevelId) {
						oneHtml += '<li ' + Tool.attrToHtml(v) + 'i="' + i + '" class="at">' + v.value + '</li>';
						atIndex = i + 1 + 2;
					} else {
						oneHtml += '<li ' + Tool.attrToHtml(v) + ' i="' + i + '">' + v.value + '</li>';
					}
				});
				//oneHtml += '<li></li>';
				oneHtml += '<li></li>';
				oneHtml += '<li></li>';
				this.oneLevelUlContainDom.innerHTML = oneHtml;

				this.scrollOne.refresh();
				this.scrollOne.scrollToElement('li:nth-child(' + (atIndex - 2) + ')', 0);
				if (this.level >= 2) {
					this.setTwoLevel(oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId);
				}

				var pdom = this.oneLevelContainDom.querySelector('.at');
				this.oneLevelContainDom.querySelector('li:nth-child(' + (atIndex - 1) + ')').classList.add('side1');
				this.oneLevelContainDom.querySelector('li:nth-child(' + (atIndex - 2) + ')').classList.add('side2');
				this.oneLevelContainDom.querySelector('li:nth-child(' + (atIndex + 1) + ')').classList.add('side1');
				this.oneLevelContainDom.querySelector('li:nth-child(' + (atIndex + 2) + ')').classList.add('side2');

				this.selectOneObj = Tool.attrToData(pdom, atIndex);
			},
			getTwoLevel: function (oneLevelId) {

				if (!angular.isArray(this.data[1])) {
					throw new Error('data format error');
				}
				var twoLevelData = [];
				if (this.options.oneTwoRelation === 1) {
					this.data[1].forEach(function (v, i, o) {
						if (v['parentId'] === oneLevelId) {
							twoLevelData.push(v);
						}
					});
				} else {
					twoLevelData = this.data[1];
				}
				return twoLevelData;
			},
			setTwoLevel: function (oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId) {
				var twoLevelData = this.getTwoLevel(oneLevelId);
				var atIndex = 0;
				if (!twoLevelId) {
					twoLevelId = twoLevelData[0]['key'];
				}

				var twoHtml = '';
				var self = this;
				//twoHtml += '<li></li>';
				twoHtml += '<li></li>';
				twoHtml += '<li></li>';
				twoLevelData.forEach(function (v, i, o) {
					if (v.key == twoLevelId) {
						twoHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + ' class="at">' + v.value + '</li>';
						atIndex = i + 1 + 2;
					} else {
						twoHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + '>' + v.value + '</li>';
					}
				});
				//twoHtml += '<li></li>';
				twoHtml += '<li></li>';
				twoHtml += '<li></li>';
				this.twoLevelUlContainDom.innerHTML = twoHtml;
				this.scrollTwo.refresh();
				this.scrollTwo.scrollToElement(':nth-child(' + (atIndex - 2) + ')', 0);
				if (this.level >= 3) {
					this.setThreeLevel(oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId);
				}

				var cdom = self.twoLevelContainDom.querySelector('li:nth-child(' + atIndex + ')');
				cdom.classList.add('at');
				self.twoLevelContainDom.querySelector('li:nth-child(' + (atIndex - 1) + ')').classList.add('side1');
				self.twoLevelContainDom.querySelector('li:nth-child(' + (atIndex - 2) + ')').classList.add('side2');
				self.twoLevelContainDom.querySelector('li:nth-child(' + (atIndex + 1) + ')').classList.add('side1');
				self.twoLevelContainDom.querySelector('li:nth-child(' + (atIndex + 2) + ')').classList.add('side2');

				self.selectTwoObj = Tool.attrToData(cdom, atIndex);
			},
			getThreeLevel: function (twoLevelId) {

				if (!angular.isArray(this.data[2])) {
					//throw new Error('data format error');
				}
				var threeLevelData = [];
				if (this.options.twoThreeRelation === 1) {
					this.data[2].forEach(function (v, i, o) {
						if (v['parentId'] === twoLevelId) {
							threeLevelData.push(v);
						}
					});
				} else {
					threeLevelData = this.data[2];
				}
				return threeLevelData;
			},
			setThreeLevel: function (oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId) {

				var leapYear = Tool.isLeapYear(oneLevelId);
				var maxDay = (twoLevelId == 2) ? (leapYear) ? 29 : 28 : (twoLevelId == 4 || twoLevelId == 6 || twoLevelId == 9 || twoLevelId == 11) ? 30 : 31;

				var threeLevelData = this.getThreeLevel(twoLevelId);
				var atIndex = 0;
				if (!threeLevelId) {
					threeLevelId = threeLevelData[0]['key'];
				}
				if (threeLevelId > maxDay) threeLevelId = maxDay;

				var threeHtml = '';
				var self = this;

				if ($(".select-three-level li").length > 31) {

					atIndex = parseInt(threeLevelId) + 2;
					var _len = $(".select-three-level li").length - 4;
					if (_len > maxDay) {
						var _looper = _len - maxDay;
						for (var i = 0; i < _looper; i++) {
							self.threeLevelContainDom.querySelector('li:nth-child(' + (_len + 2 - i) + ')').remove();
						}
						this.scrollThree.notUpScrollY = true;
					} else if (_len < maxDay) {
						var _looper = maxDay - _len;
						for (var i = 0; i < _looper; i++) {
							$('<li ' + Tool.attrToHtml({
								key: _len + 1 + i,
								value: "" + (_len + 1 + i) + '日'
							}) + 'i=' + '"' + (_len + i) + '"' + '>' + (_len + 1 + i) + '日</li>').insertAfter(self.threeLevelContainDom.querySelector('li:nth-child(' + (_len + i + 2) + ')'));
						}
					} else {

					}
				} else {
					//threeHtml += '<li></li>';
					threeHtml += '<li></li>';
					threeHtml += '<li></li>';
					threeLevelData = threeLevelData.slice(0, maxDay);
					threeLevelData.forEach(function (v, i, o) {
						if (v.key == threeLevelId) {
							threeHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + ' class="at">' + v.value + '</li>';
							atIndex = i + 1 + 2;
						} else {
							threeHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + '>' + v.value + '</li>';
						}
					});
					//threeHtml += '<li></li>';
					threeHtml += '<li></li>';
					threeHtml += '<li></li>';
					this.threeLevelUlContainDom.innerHTML = threeHtml;
				}

				this.scrollThree.refresh();
				this.scrollThree.scrollToElement(':nth-child(' + (atIndex - 2) + ')', 0);
				if (this.level >= 4) {
					this.setFourLevel(oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId);
				}
				var ddom = self.threeLevelContainDom.querySelector('li:nth-child(' + atIndex + ')');
				$(ddom).removeClass('at');
				$(self.threeLevelContainDom).find('.side1').removeClass("side1");
				$(self.threeLevelContainDom).find('.side2').removeClass("side2");
				ddom.classList.add('at');
				self.threeLevelContainDom.querySelector('li:nth-child(' + (atIndex - 1) + ')').classList.add('side1');
				self.threeLevelContainDom.querySelector('li:nth-child(' + (atIndex - 2) + ')').classList.add('side2');
				self.threeLevelContainDom.querySelector('li:nth-child(' + (atIndex + 1) + ')').classList.add('side1');
				self.threeLevelContainDom.querySelector('li:nth-child(' + (atIndex + 2) + ')').classList.add('side2');

				self.selectThreeObj = Tool.attrToData(ddom, atIndex);
			},
			getFourLevel: function (threeLevelId) {

				if (!angular.isArray(this.data[3])) {
					throw new Error('data format error');
				}
				var fourLevelData = [];
				if (this.options.threeFourRelation === 1) {
					this.data[3].forEach(function (v, i, o) {
						if (v['parentId'] === threeLevelId) {
							fourLevelData.push(v);
						}
					});
				} else {
					fourLevelData = this.data[3];
				}
				return fourLevelData;
			},
			setFourLevel: function (oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId) {

				var fourLevelData = this.getFourLevel(threeLevelId);
				var atIndex = 0;
				if (!fourLevelId) {
					fourLevelId = fourLevelData[0]['key'];
				}
				var fourHtml = '';
				var self = this;
				//fourHtml += '<li></li>';
				fourHtml += '<li></li>';
				fourHtml += '<li></li>';
				fourLevelData.forEach(function (v, i, o) {

					if (v.key == fourLevelId) {
						fourHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + ' class="at">' + v.value + '</li>';
						atIndex = i + 1 + 2;
					} else {
						fourHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + '>' + v.value + '</li>';
					}
				});
				//fourHtml += '<li></li>';
				fourHtml += '<li></li>';
				fourHtml += '<li></li>';
				this.fourLevelUlContainDom.innerHTML = fourHtml;
				this.scrollFour.refresh();
				this.scrollFour.scrollToElement(':nth-child(' + (atIndex - 2) + ')', 0);
				if (this.level >= 5) {
					this.setFiveLevel(oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId);
				}
				var ddom = self.fourLevelContainDom.querySelector('li:nth-child(' + atIndex + ')');
				ddom.classList.add('at');
				self.fourLevelContainDom.querySelector('li:nth-child(' + (atIndex - 1) + ')').classList.add('side1');
				self.fourLevelContainDom.querySelector('li:nth-child(' + (atIndex - 2) + ')').classList.add('side2');
				self.fourLevelContainDom.querySelector('li:nth-child(' + (atIndex + 1) + ')').classList.add('side1');
				self.fourLevelContainDom.querySelector('li:nth-child(' + (atIndex + 2) + ')').classList.add('side2');

				self.selectFourObj = Tool.attrToData(ddom, atIndex);
			},
			getFiveLevel: function (fourLevelId) {

				if (!angular.isArray(this.data[4])) {
					throw new Error('data format error');
				}
				var fiveLevelData = [];
				if (this.options.fourFiveRelation === 1) {
					this.data[4].forEach(function (v, i, o) {
						if (v['parentId'] === fourLevelId) {
							fiveLevelData.push(v);
						}
					});
				} else {
					fiveLevelData = this.data[4];
				}
				return fiveLevelData;
			},
			setFiveLevel: function (oneLevelId, twoLevelId, threeLevelId, fourLevelId, fiveLevelId) {

				var fiveLevelData = this.getFiveLevel(fourLevelId);
				var atIndex = 0;
				if (!fiveLevelId) {
					fiveLevelId = fiveLevelData[0]['key'];
				}
				var fiveHtml = '';
				var self = this;
				//fiveHtml += '<li></li>';
				fiveHtml += '<li></li>';
				fiveHtml += '<li></li>';
				fiveLevelData.forEach(function (v, i, o) {

					if (v.key == fiveLevelId) {
						fiveHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + ' class="at">' + v.value + '</li>';
						atIndex = i + 1 + 2;
					} else {
						fiveHtml += '<li ' + Tool.attrToHtml(v) + 'i=' + '"' + i + '"' + '>' + v.value + '</li>';
					}
				});
				//fiveHtml += '<li></li>';
				fiveHtml += '<li></li>';
				fiveHtml += '<li></li>';
				this.fiveLevelUlContainDom.innerHTML = fiveHtml;
				this.scrollFive.refresh();
				this.scrollFive.scrollToElement(':nth-child(' + (atIndex - 2) + ')', 0);

				var ddom = self.fiveLevelContainDom.querySelector('li:nth-child(' + atIndex + ')');
				ddom.classList.add('at');
				self.fiveLevelContainDom.querySelector('li:nth-child(' + (atIndex - 1) + ')').classList.add('side1');
				self.fiveLevelContainDom.querySelector('li:nth-child(' + (atIndex - 2) + ')').classList.add('side2');
				self.fiveLevelContainDom.querySelector('li:nth-child(' + (atIndex + 1) + ')').classList.add('side1');
				self.fiveLevelContainDom.querySelector('li:nth-child(' + (atIndex + 2) + ')').classList.add('side2');

				self.selectFiveObj = Tool.attrToData(ddom, atIndex);
			},
			dateLimit: function () {

				var leapYear = Tool.isLeapYear(this.selectOneObj.value);
				var year = this.selectOneObj.key;
				var month = this.selectTwoObj.key;
				var day = this.selectThreeObj.key;

				var dayNum = (month == 2) ? (leapYear) ? 29 : 28 : (month == 4 || month == 6 || month == 9 || month == 11) ? 30 : 31;

				var updateYear,
					updateMonth,
					updateDay;
				//日期上下限制
				if (year == this.options.startYear) {
					if (month < this.options.startMonth) {
						updateMonth = this.options.startMonth;
						updateDay = this.options.startDay;
					} else if (month == this.options.startMonth && day < this.options.startDay) {
						updateMonth = this.options.startMonth;
						updateDay = this.options.startDay;
					}
				} else if (year == this.options.endYear) {

					if (month > this.options.endMonth) {
						updateMonth = this.options.endMonth;
						updateDay = this.options.endDay;
					} else if (month == this.options.endMonth && day > this.options.endDay) {
						updateMonth = this.options.endMonth;
						updateDay = this.options.endDay;
					}
				}
				//月份天数限制
				/*if(day > dayNum){
				 updateDay = dayNum;
				 }*/

				if (updateMonth) {
					this.setTwoLevel(0, updateMonth, updateDay, this.selectFourObj.value, this.selectFiveObj.value);
				} else {
					if (day)
						this.setThreeLevel(year, month, day, this.selectFourObj.value, this.selectFiveObj.value);
				}
			}
		}

		return function (level, data, scope, options) {
			return new IosSelect(level, data, scope, options)
		}
	}])

	.factory('sideSelect', ['$rootScope', '$compile', '$window', '$document', '$timeout', '$animate', 'IosSelect', 'Tool', function ($rootScope, $compile, $window, $document, $timeout, $animate, IosSelect, Tool) {

		var scope = null;


		return {
			show: sideSelect,
			close: function () {
				scope.removeSelect(true);
			},
			isOpen: function () {
				if (scope && scope.isOpen) {

					return true
				}

				return false
			}
		};


		function sideSelect(opt) {

			// Create Scope
			scope = $rootScope.$new(true);

			scope.isOpen = false;

			angular.extend(scope, {

			}, opt || {});

			if (scope.isCancel == undefined) {
				scope.isCancel = false;
			}

			// Select DOM Template
			var selectDomTemplate,
				element,
				sideSelect,
				sideSelectShowClass,
				sideSelectRemoveClass;


			if (scope.type && scope.type == 'ios') {
				selectDomTemplate = IosSelect(1, [scope.data], scope, {
					// title: scope.title,
					title: '',
					headerHeight: Tool.isIos7() ? parseInt(lib.flexible.rem2px(1.306)) : lib.flexible.rem2px(1.306),
					itemHeight: Tool.isIos7() ? parseInt(lib.flexible.rem2px(0.986)) : lib.flexible.rem2px(0.986),
					oneLevelId: (scope.selectIndex && scope.data && scope.data[scope.selectIndex] && scope.data[scope.selectIndex].key) ? scope.data[scope.selectIndex].key : undefined,
					callback: function (selectOneObj) {
						scope.selected(undefined, (selectOneObj && (selectOneObj.index == 0 || selectOneObj.index)) ? selectOneObj.index : selectOneObj)
					}
				});
				element = selectDomTemplate.iosSelectLayer.el;
				sideSelect = angular.element(element.getElementsByClassName('ios-select-layer')[0]);
				sideSelectShowClass = 'ios-select-layer ios-select-layer-up';
				sideSelectRemoveClass = 'ios-select-layer';
			} else {
				var templ = '<div class="side-select list"><header> <div ng-bind="title" class="l"></div><div class="r" ng-click="selected($event,undefined)">清除</div> </header><ion-scroll direction="y" style="height: ' + ($window.outerHeight - 44) + 'px; width:100%"><div ng-repeat="i in data" ng-click="selected($event,$index)" class="item item-icon-right">{{i.value}} <i ng-if="$index == selectIndex" class="icon calm ion-android-done"></i> </div></ion-scroll> </div>';
				selectDomTemplate = '<div class="backdrops" ng-click="backdropAction($event)">' + templ + '</div>';
				element = scope.element = $compile(selectDomTemplate)(scope);
				sideSelect = angular.element(element[0].getElementsByTagName('div')[0]);
				sideSelectShowClass = 'side-select side-select-left';
				sideSelectRemoveClass = 'side-select';
			}

			var elementActiveClassName = element.className + ' active';
			var elementClassName = element.className;

			scope.showSelect = function () {
				scope.isOpen = true;

				(scope.type && scope.type == 'ios') ? angular.noop: $document[0].body.appendChild(element[0]);

				element.className = elementActiveClassName;

				$timeout(function () {
					sideSelect[0].className = sideSelectShowClass;
				}, 0)
			};

			scope.removeSelect = function (state) {
				scope.isOpen = false;

				sideSelect[0].className = sideSelectRemoveClass;
				if (state) {
					scope.$apply(function () {
						element.className = elementClassName;
						$timeout(function () {
							element.remove();
						}, 150);
					})
				} else {
					element.className = elementClassName;
					$timeout(function () {
						element.remove();
					}, 150);
				}

			};

			scope.backdropAction = function (ev) {
				ev.stopPropagation();
				scope.removeSelect();
			};

			scope.selected = function (ev, index) {

				ev && ev.stopPropagation && ev.stopPropagation();
				scope.removeSelect();
				(scope.selectedFunc) ? (scope.type == 'ios') ? scope.$apply(scope.selectedFunc(index)): scope.selectedFunc(index): angular.noop;
			};

			scope.showSelect();

		}
	}])
	.factory('timeSelect', ['$rootScope', '$compile', '$window', '$document', '$timeout', '$animate', '$log', 'IosSelect', 'Tool', 'DateDefaultArray', function ($rootScope, $compile, $window, $document, $timeout, $animate, $log, IosSelect, Tool, DateDefaultArray) {

		var scope = null;

		return {
			show: timeSelect,
			close: function () {
				scope.removeSelect(true);
			},
			isOpen: function () {
				if (scope && scope.isOpen) {

					return true
				}

				return false
			}
		};


		function timeSelect(opt) {

			// Create Scope
			scope = $rootScope.$new(true);

			scope.isOpen = false;

			angular.extend(scope, {

			}, opt || {});

			if (scope.isCancel == undefined) {
				scope.isCancel = false;
			}

			var selectNum;
			var selectData = [];
			var iosSelectConfig = {
				title: '',
				headerHeight: Tool.isIos7() ? parseInt(lib.flexible.rem2px(1.306)) : lib.flexible.rem2px(1.306),
				itemHeight: Tool.isIos7() ? parseInt(lib.flexible.rem2px(0.986)) : lib.flexible.rem2px(0.986)
			};

			switch (scope.type) {
				case 'date':
					selectNum = 3;

					//转换开始时间、默认时间
					scope.startDate = Tool.dateSplit(scope.startDate, selectNum);
					scope.endDate = Tool.dateSplit(scope.endDate, selectNum);
					scope.defaultDate = Tool.dateSplit(scope.defaultDate, selectNum);
					//判断是否有开始时间：是必须的
					(scope.startDate.length == 3) ? angular.noop: $log.error('startDate is not Date');
					//默认 EndDate
					scope.endDate = (scope.endDate && scope.endDate.length && scope.endDate.length == 3) ? scope.endDate : [new Date().getFullYear(), 12, 31];
					//默认 defaultDate

					scope.defaultDate = (scope.defaultDate && scope.defaultDate.length && scope.defaultDate.length == 3) ? scope.defaultDate : scope.startDate;

					var startYear = scope.startDate[0],
						startMonth = scope.startDate[1],
						startDay = scope.startDate[2],
						endYear = scope.endDate[0],
						endMonth = scope.endDate[1],
						endDay = scope.endDate[2],
						defaultYear = scope.defaultDate[0],
						defaultMonth = scope.defaultDate[1],
						defaultDay = scope.defaultDate[2],
						yearArray = [],
						monthArray = DateDefaultArray.month,
						dayArray = DateDefaultArray.day;

					for (var i = startYear; i <= endYear; i++) {
						yearArray.push({
							key: i,
							value: i + '年'
						})
					}

					selectData.push(yearArray);
					selectData.push(monthArray);
					selectData.push(dayArray);

					angular.extend(iosSelectConfig, {}, {
						oneLevelId: defaultYear,
						twoLevelId: defaultMonth,
						threeLevelId: defaultDay,
						callback: function (selectOneObj, selectTwoObj, selectThreeObj) {
							if (selectOneObj && selectTwoObj && selectThreeObj) {
								var retrunDate = Tool.crateReturnDate(scope.returnDateType, selectOneObj, selectTwoObj, selectThreeObj);
								scope.selected(angular.noop, retrunDate);
							} else {
								scope.selected(angular.noop, undefined);
							}
						},
						//开启是 日期时间
						openDate: 1,
						startYear: startYear,
						startMonth: startMonth,
						startDay: startDay,
						endYear: endYear,
						endMonth: endMonth,
						endDay: endDay,
						addClassName: scope.returnDateType == 'ymd' ? 'dateAttrName3' : 'dateAttrName2',
						attrNameType: scope.returnDateType
					});

					break;
				case 'time':

					selectNum = 2;

					var defaultHours,
						defaultMinutes,
						defaultAmPm;

					if (scope.returnTimeType == 'AMPM') {
						selectNum = 3;

						scope.defaultDate = Tool.timeSplit(scope.defaultDate);

						scope.defaultDate = (scope.defaultDate && scope.defaultDate.length && scope.defaultDate.length == 3) ? scope.defaultDate : [0, 0, 'am'];

						var hoursArray = DateDefaultArray.hours,
							minutesArray = (scope.stepping) ? DateDefaultArray['minutes' + scope.stepping] : DateDefaultArray.minutes,
							amPmArray = [{
									key: 'AM',
									value: 'AM'
								},
								{
									key: 'PM',
									value: 'PM'
								}
							],
							defaultHours = scope.defaultDate[0],
							defaultMinutes = scope.defaultDate[1],
							defaultAmPm = scope.defaultDate[2];


						selectData.push(hoursArray);
						selectData.push(minutesArray);
						selectData.push(amPmArray);

						angular.extend(iosSelectConfig, {}, {
							oneLevelId: defaultHours,
							twoLevelId: defaultMinutes,
							threeLevelId: defaultAmPm,
							callback: function (selectOneObj, selectTwoObj, selectThreeObj) {

								if (selectOneObj && selectTwoObj) {
									var retrunTime = Tool.crateReturnTime(scope.returnTimeType, selectOneObj, selectTwoObj, selectThreeObj);

									scope.selected(angular.noop, retrunTime);
								} else {
									scope.selected(angular.noop, undefined);
								}
							}
						});

					} else {
						scope.defaultDate = Tool.timeSplit(scope.defaultDate);

						scope.defaultDate = (scope.defaultDate && scope.defaultDate.length && scope.defaultDate.length == 2) ? scope.defaultDate : [0, 0];

						var hoursArray = DateDefaultArray.hours,
							minutesArray = (scope.stepping) ? DateDefaultArray['minutes' + scope.stepping] : DateDefaultArray.minutes,
							defaultHours = scope.defaultDate[0],
							defaultMinutes = scope.defaultDate[1];

						selectData.push(hoursArray);
						selectData.push(minutesArray);

						angular.extend(iosSelectConfig, {}, {
							oneLevelId: defaultHours,
							twoLevelId: defaultMinutes,
							callback: function (selectOneObj, selectTwoObj) {

								if (selectOneObj && selectTwoObj) {
									var retrunTime = Tool.crateReturnTime(scope.returnTimeType, selectOneObj, selectTwoObj);
									scope.selected(angular.noop, retrunTime);
								} else {
									scope.selected(angular.noop, undefined);
								}
							}
						});
					}


					break;
				case 'dateTime':
					selectNum = 5;

					//转换开始时间、默认时间
					scope.startDate = Tool.dateSplit(scope.startDate, selectNum);
					scope.endDate = Tool.dateSplit(scope.endDate, selectNum);
					scope.defaultDateTime = Tool.dateSplit(scope.defaultDate, selectNum);
					//判断是否有开始时间：是必须的
					(scope.startDate.length == 5) ? angular.noop: $log.error('startDate is not Date');
					//默认 EndDate
					scope.endDate = (scope.endDate && scope.endDate.length && scope.endDate.length == 5) ? scope.endDate : [new Date().getFullYear(), 12, 31, 0, 0];
					//默认 defaultDate

					scope.defaultDateTime = (scope.defaultDateTime && scope.defaultDateTime.length && scope.defaultDateTime.length == 5) ? scope.defaultDateTime : scope.startDate;

					var startYear = scope.startDate[0],
						startMonth = scope.startDate[1],
						startDay = scope.startDate[2],
						endYear = scope.endDate[0],
						endMonth = scope.endDate[1],
						endDay = scope.endDate[2],
						defaultYear = scope.defaultDateTime[0],
						defaultMonth = scope.defaultDateTime[1],
						defaultDay = scope.defaultDateTime[2],
						defaultHour = scope.defaultDateTime[3],
						defaultMinute = scope.defaultDateTime[4],
						yearArray = [],
						monthArray = DateDefaultArray.month,
						dayArray = DateDefaultArray.day,
						hoursArray = DateDefaultArray.hours,
						minutesArray = (scope.stepping) ? DateDefaultArray['minutes' + scope.stepping] : DateDefaultArray.minutes;


					for (var i = startYear; i <= endYear; i++) {
						yearArray.push({
							key: i,
							value: i + '年'
						})
					}

					selectData.push(yearArray);
					selectData.push(monthArray);
					selectData.push(dayArray);
					selectData.push(hoursArray);
					selectData.push(minutesArray);

					angular.extend(iosSelectConfig, {}, {
						oneLevelId: defaultYear,
						twoLevelId: defaultMonth,
						threeLevelId: defaultDay,
						fourLevelId: defaultHour,
						fiveLevelId: defaultMinute,
						callback: function (selectOneObj, selectTwoObj, selectThreeObj, selectFourObj, selectFiveObj) {
							if (selectOneObj && selectTwoObj && selectThreeObj && selectFourObj && selectFiveObj) {
								var retrunDate = Tool.crateReturnDateTime(scope.returnDateType, selectOneObj, selectTwoObj, selectThreeObj, selectFourObj, selectFiveObj);
								scope.selected(angular.noop, retrunDate);
							} else {
								scope.selected(angular.noop, undefined);
							}

						},
						//开启是 日期时间
						openDate: 1,
						startYear: startYear,
						startMonth: startMonth,
						startDay: startDay,
						endYear: endYear,
						endMonth: endMonth,
						endDay: endDay,
						addClassName: scope.returnDateType == 'ymd' ? 'dateAttrName6' : 'dateAttrName5',
						attrNameType: scope.returnDateType
					});


					break;
				case 'yearsMonth':
					selectNum = 2;

					scope.startDate = Tool.dateSplit(scope.startDate, selectNum);
					scope.endDate = Tool.dateSplit(scope.endDate, selectNum);
					scope.defaultDate = Tool.dateSplit(scope.defaultDate, selectNum);
					//判断是否有开始时间：是必须的
					(scope.startDate.length == 2) ? angular.noop: $log.error('startDate is not Date');
					//默认 EndDate
					scope.endDate = (scope.endDate && scope.endDate.length && scope.endDate.length == 2) ? scope.endDate : [new Date().getFullYear(), 12];
					//默认 defaultDate

					scope.defaultDate = (scope.defaultDate && scope.defaultDate.length && scope.defaultDate.length == 2) ? scope.defaultDate : scope.startDate;

					var startYear = scope.startDate[0],
						startMonth = scope.startDate[1],
						endYear = scope.endDate[0],
						endMonth = scope.endDate[1],
						defaultYear = scope.defaultDate[0],
						defaultMonth = scope.defaultDate[1],
						yearArray = [],
						monthArray = DateDefaultArray.month;

					for (var i = startYear; i <= endYear; i++) {
						yearArray.push({
							key: i,
							value: i + '年'
						})
					}

					selectData.push(yearArray);
					selectData.push(monthArray);

					angular.extend(iosSelectConfig, {}, {
						oneLevelId: defaultYear,
						twoLevelId: defaultMonth,
						callback: function (selectOneObj, selectTwoObj) {
							if (selectOneObj && selectTwoObj) {
								var retrunDate = Tool.crateReturnDate(scope.returnDateType, selectOneObj, selectTwoObj);
								scope.selected(angular.noop, retrunDate);
							} else {
								scope.selected(angular.noop, undefined);
							}

						},
						//开启是 日期时间
						openDate: 1,
						startYear: startYear,
						startMonth: startMonth,
						endYear: endYear,
						endMonth: endMonth
					});

					break;

				default:
					$log.error('DateType is not');
			}


			// Select DOM Template
			var selectDomTemplate,
				element,
				timeSelect,
				timeSelectShowClass,
				timeSelectRemoveClass;

			selectDomTemplate = IosSelect(
				selectNum,
				selectData,
				scope,
				iosSelectConfig);


			element = selectDomTemplate.iosSelectLayer.el;
			timeSelect = angular.element(element.getElementsByClassName('ios-select-layer')[0]);
			timeSelectShowClass = 'ios-select-layer ios-select-layer-up';
			timeSelectRemoveClass = 'ios-select-layer';

			var elementActiveClassName = element.className + ' active';
			var elementClassName = element.className;

			scope.showSelect = function () {
				scope.isOpen = true;
				element.className = elementActiveClassName;

				$timeout(function () {
					timeSelect[0].className = timeSelectShowClass;
				}, 0)
			};

			scope.removeSelect = function (state) {
				scope.isOpen = false;

				timeSelect[0].className = timeSelectRemoveClass;
				if (state) {
					scope.$apply(function () {
						element.className = elementClassName;
						$timeout(function () {
							element.remove();
						}, 150);
					})
				} else {
					element.className = elementClassName;
					$timeout(function () {
						element.remove();
					}, 150);
				}
			};




			scope.backdropAction = function (ev) {
				ev.stopPropagation();
				scope.removeSelect();
			};

			scope.selected = function (ev, index) {

				ev && ev.stopPropagation && ev.stopPropagation();
				scope.removeSelect();
				scope.$apply(scope.selectedFunc(index));

			};

			scope.showSelect();

		}
	}])


	.factory('regIdxService', function ($http, $rootScope, $location, $ionicPopup, $ionicHistory) {
		$rootScope.showLoading();
		var reg_index_ck = [{
			cls: 'organization_and_personnel',
			clsTil: 'OP',
			text: "组织人事",
			disabled: true,
			checked: true
		}, {
			cls: 'time_management',
			clsTil: 'TM',
			text: "时间管理",
			disabled: false,
			checked: false
		}, {
			cls: 'compensation_management',
			clsTil: 'CM',
			text: "薪酬管理",
			disabled: false,
			checked: false
		}];
		return {
			regIndexAll: function () {
				return reg_index_ck;
			},
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getRegIndex&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					for (var i = 0; i < data.length; i++) {
						reg_index_ck[i].checked = data[i] == 0 ? false : true
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveIndex: function () {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveRegIndex', {}, {
					timeout: _var_timeout,
					params: {
						time: reg_index_ck[1].checked == true ? 1 : 0,
						payroll: reg_index_ck[2].checked == true ? 1 : 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (reg_index_ck[1].checked || reg_index_ck[2].checked) {
						if (data.flag == '0') {
							if (data.menu_key == "") {
								$rootScope.showLoading();
								$.ajax({
									type: 'POST',
									url: window.localStorage['_remote_server_addr'] + '?event=dynamicGenerateScript.dynamicGenerateScript.initSystemData&_is_mobile=1&dt_=' + new Date().getTime(),
									timeout: _var_timeout,
									success: function (data, status, headers, config) {
										$rootScope.hideLoading();

										var _data = $.parseJSON(data);
										if (_data.flag == 'S') {
											$ionicPopup.alert({
													title: '注册成功',
													template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
													okText: '确定'
												})
												.then(function (res) {
													$ionicHistory.clearCache();
													$ionicHistory.clearHistory();
													$location.path('/');
												});
										} else {
											$ionicPopup.alert({
												title: '运行结果',
												template: '<div style="text-align: center;">' + _data.success_msg + '</div>',
												okText: '确定'
											}).then(function (res) {

											});
										}
									},
									error: function (data, status, headers, config) {
										$rootScope.hideLoading();
										window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
									}
								});
							} else {
								$location.path(data.menu_key);
							}
						} else {
							$ionicPopup.alert({
								title: '运行结果',
								template: '<div style="text-align: center;">' + data.message + '</div>',
								okText: '确定'
							})
						}
					} else {
						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=dynamicGenerateScript.dynamicGenerateScript.initSystemData&_is_mobile=1&dt_=' + new Date().getTime(),
							timeout: _var_timeout,
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();

								var _data = $.parseJSON(data);
								if (_data.flag == 'S') {
									$ionicPopup.alert({
											title: '注册成功',
											template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
											okText: '确定'
										})
										.then(function (res) {
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											$location.path('/');
										});
								} else {
									$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + _data.success_msg + '</div>',
										okText: '确定'
									}).then(function (res) {

									});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {

								});
							}
						});
					}
				}).
				error(function (data, status, headers, config) {
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})
	.factory('regAlService', function ($http, $rootScope, $location, $ionicPopup, $ionicHistory) {
		var al_setting_data = {
			reg_al_group1: [{
				text: '按年享有',
				value: '1'
			}, {
				text: '按月享有',
				value: '2'
			}],
			reg_al_group2: [{
				text: '补薪',
				text_ch: 'X1',
				value: '1'
			}, {
				text: '补薪',
				text_ch: 'X2',
				value: '2'
			}, {
				text: '补薪',
				text_ch: 'X3',
				value: '3'
			}, {
				text: '不处理',
				text_ch: '',
				value: '0'
			}],
			al_rule_setting: [],
			has_al_balance: true,
			al_entitle_type: '0',
			balance_action_on_exit: '0',
			is_can_apply_at_probation: true
		}
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getRegAl&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					al_setting_data.has_al_balance = data.has_al_balance == '1' ? true : false;
					al_setting_data.al_entitle_type = data.al_entitle_type;
					al_setting_data.balance_action_on_exit = data.balance_action_on_exit;
					al_setting_data.is_can_apply_at_probation = data.is_can_apply_at_probation == '1' ? true : false;
					al_setting_data.al_rule_setting = data.entitle_formula;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveRegAl: function () {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveRegAl', {}, {
					timeout: _var_timeout,
					params: {
						has_al_balance: al_setting_data.has_al_balance == true ? 1 : 0,
						al_entitle_type: al_setting_data.al_entitle_type,
						balance_action_on_exit: al_setting_data.balance_action_on_exit,
						is_can_apply_at_probation: al_setting_data.is_can_apply_at_probation == true ? 1 : 0,
						entitle_formula: al_setting_data.al_rule_setting,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.menu_key != '') {
						if (data.flag == '0') {
							$location.path(data.menu_key);
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}
					} else {
						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=dynamicGenerateScript.dynamicGenerateScript.initSystemData&_is_mobile=1&dt_=' + new Date().getTime(),
							timeout: _var_timeout,
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == 'S') {
									$ionicPopup.alert({
											title: '注册成功',
											template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
											okText: '确定'
										})
										.then(function (res) {
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											$location.path('/');
										});
								} else {
									$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + _data.success_msg + '</div>',
										okText: '确定'
									}).then(function (res) {

									});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAlSettingData: function () {
				return al_setting_data;
			}
		}
	})
	.factory('regAt1Service', function ($http, $rootScope, $location, $ionicPopup, $ionicHistory) {
		var reg_at1_data = {
			"in_allow_before_minutes": "",
			"in_alow_after_minutes": "",
			"out_allow_before_minutes": "",
			"out_allow_after_minutes": "",
			"allow_early_leave_minutes": "",
			"allow_late_minutes": "",
			"absent_minutes": ""
		}

		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getRegAt1&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, reg_at1_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveRegAt1: function () {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveRegAt1', {}, {
					timeout: _var_timeout,
					params: {
						in_allow_before_minutes: reg_at1_data.in_allow_before_minutes,
						in_alow_after_minutes: reg_at1_data.in_alow_after_minutes,
						out_allow_before_minutes: reg_at1_data.out_allow_before_minutes,
						out_allow_after_minutes: reg_at1_data.out_allow_after_minutes,
						allow_early_leave_minutes: reg_at1_data.allow_early_leave_minutes,
						allow_late_minutes: reg_at1_data.allow_late_minutes,
						absent_minutes: reg_at1_data.absent_minutes,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.menu_key != '') {
						if (data.flag == '0') {
							$location.path(data.menu_key);
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}
					} else {

						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=dynamicGenerateScript.dynamicGenerateScript.initSystemData&_is_mobile=1&dt_=' + new Date().getTime(),
							timeout: _var_timeout,
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == 'S') {
									$ionicPopup.alert({
											title: '注册成功',
											template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
											okText: '确定'
										})
										.then(function (res) {
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											$location.path('/');
										});
								} else {
									$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + _data.success_msg + '</div>',
										okText: '确定'
									}).then(function (res) {

									});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAt1SettingData: function () {
				return reg_at1_data;
			}
		};
	})
	.factory('regAt2Service', function ($http, $rootScope, $location, $ionicPopup, $ionicHistory) {
		var reg_at2_data = {
			"ot1_need_card": false,
			"ot2_need_card": false,
			"ot3_need_card": false,
			"is_single_policy": "2",
			"first_in_need_card": false,
			"first_out_need_card": false,
			"second_in_need_card": false,
			"second_out_need_card": false,
			"first_in": "09:00",
			"first_out": "12:00",
			"second_in": "13:00",
			"second_out": "18:00",
			reg_at2_g2: [{
				text: "单一班次",
				value: '1'
			}, {
				text: "多个班值政策",
				value: '0'
			}]
		}
		return {
			loadData: function () {
				$rootScope.showLoading();
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getRegAt2&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					reg_at2_data.ot1_need_card = data.ot1_need_card == '1' ? true : false;
					reg_at2_data.ot2_need_card = data.ot2_need_card == '1' ? true : false;
					reg_at2_data.ot3_need_card = data.ot3_need_card == '1' ? true : false;
					reg_at2_data.is_single_policy = data.is_single_policy;
					reg_at2_data.first_in_need_card = data.first_in_need_card == '1' ? true : false;
					reg_at2_data.first_out_need_card = data.first_out_need_card == '1' ? true : false;
					reg_at2_data.second_in_need_card = data.second_in_need_card == '1' ? true : false;
					reg_at2_data.second_out_need_card = data.second_out_need_card == '1' ? true : false;
					reg_at2_data.first_in = data.first_in;
					reg_at2_data.first_out = data.first_out;
					reg_at2_data.second_in = data.second_in;
					reg_at2_data.second_out = data.second_out;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveRegAt2: function () {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveRegAt2', {}, {
					timeout: _var_timeout,
					params: {
						ot1_need_card: reg_at2_data.ot1_need_card == true ? '1' : '0',
						ot2_need_card: reg_at2_data.ot2_need_card == true ? '1' : '0',
						ot3_need_card: reg_at2_data.ot3_need_card == true ? '1' : '0',
						is_single_policy: reg_at2_data.is_single_policy,
						first_in_need_card: reg_at2_data.first_in_need_card == true ? '1' : '0',
						first_out_need_card: reg_at2_data.first_out_need_card == true ? '1' : '0',
						second_in_need_card: reg_at2_data.second_in_need_card == true ? '1' : '0',
						second_out_need_card: reg_at2_data.second_out_need_card == true ? '1' : '0',
						first_in: reg_at2_data.first_in,
						first_out: reg_at2_data.first_out,
						second_in: reg_at2_data.second_in,
						second_out: reg_at2_data.second_out,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.menu_key != '') {
						if (data.flag == '0') {
							$location.path(data.menu_key);
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}
					} else {

						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=dynamicGenerateScript.dynamicGenerateScript.initSystemData&_is_mobile=1&dt_=' + new Date().getTime(),
							timeout: _var_timeout,
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == 'S') {
									$ionicPopup.alert({
											title: '注册成功',
											template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
											okText: '确定'
										})
										.then(function (res) {
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											$location.path('/');
										});
								} else {
									$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + _data.success_msg + '</div>',
										okText: '确定'
									}).then(function (res) {

									});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}

					/*
					$rootScope.hideLoading();
					$ionicPopup.alert({
					title: '注册成功',
					template: '<div style="text-align: center;">初始化完成,请重新登录系统</div>',
					okText: '确定'
					})
					.then(function(res) {
					$location.path('/');
					});
					*/

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAt2SettingData: function () {
				return reg_at2_data;
			}
		};
	})
	.factory('userLoginService', function ($http, $rootScope, $location, $timeout, $ionicPopup, $ionicHistory, $ionicLoading, MsgSettingSev) {

		var loginMsg = {
			flag: 1,
			message: ''
		}
		var regModel = {
			_phone_num: '',
			_pwd1: '',
			_pwd2: '',
			_comp_name: '',
			_category: '请选择您所属的行业',
			_empl_num: '请选择企业规模',
			valid_code: '',
			_sn_list: '',
			_flag: 1,
			_message: ''
		}
		var freeExpr = {
			flag: 1,
			cmp_name: '',
			cmp_contact: '',
			message: '',
			tel_no: '',
			valid_code: ''
		}
		return {
			demoLogin: function (free_modal) {
				if (freeExpr.tel_no == '' || freeExpr.valid_code == '') {
					freeExpr.flag = 0;
					freeExpr.message = '手机号码及验证码不能为空!';
					$timeout(function () {
						freeExpr.flag = 1;
						freeExpr.message = '';
					}, 1500);
					return;
				} else {
					var reg = /^1[3|4|5|7|8]\d{9}$/;
					if (!reg.test(freeExpr.tel_no)) {
						freeExpr.flag = 0;
						freeExpr.message = '手机号码格式不正确!';
						$timeout(function () {
							freeExpr.flag = 1;
							freeExpr.message = '';
						}, 1500);
						return;
					}
				}

				$.ajax({
					type: "GET",
					url: 'https://s0.zkcserv.com/demo/cb_hrms/index.cfm?event=ionicAction.ionicAction.userDemoLogin&cmp_name=' + freeExpr.cmp_name + '&cmp_contact=' + freeExpr.cmp_contact + '&_user_name=' + freeExpr.tel_no + '&_pass_word=' + freeExpr.valid_code + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'] + '&is_mobile=1&_is_login=0&_dc=' + new Date().getTime(),
					dataType: "jsonp",
					timeout: _var_timeout,
					jsonp: "callback",
					jsonpCallback: "jsonpCallBack",
					success: function (data) {
						$rootScope.hideLoading();
						if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
							$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {

							});
							return;
						}
						if (angular.isDefined(data.flag) && data.flag == '0') {
							freeExpr.flag = 0;
							freeExpr.message = data.message;
							$timeout(function () {
								freeExpr.flag = 1;
								freeExpr.message = '';
							}, 1500);
						} else {
							setLocalStorageVar("free_trial_cmp_name", freeExpr.cmp_name);
							setLocalStorageVar("free_trial_cmp_contact", freeExpr.cmp_contact);
							setLocalStorageVar("free_trial_tel_no", freeExpr.tel_no);
							setLocalStorageVar("free_trial_valid_code", freeExpr.valid_code);
							setLocalStorageVar("is_free_trial_login", '1');
							//freeExpr.tel_no='';
							//freeExpr.valid_code='';
							//freeExpr.flag = 1;
							//freeExpr.message = '';
							//freeExpr.cmp_name = '';
							//freeExpr.cmp_contact = '';
							setLocalStorageVar("_remote_server_addr", 'https://s0.zkcserv.com/demo/cb_hrms/index.cfm');
							setLocalStorageVar("_user_name", data._user_name);
							setLocalStorageVar("_pass_word", data._pass_word);
							setLocalStorageVar("_is_login", '1');
							fufuMobclickAgent('click_experience_fufu');

							free_modal.hide();
							$location.path('home_page/home_default');

						}

					},
					error: function () {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getFreeData: function () {
				return freeExpr;
			},
			sendPwdVCode: function () {
				var reg = /^1[3|4|5|7|8]\d{9}$/;
				if (!reg.test(freeExpr.tel_no)) {
					freeExpr.flag = 0;
					freeExpr.message = '手机号码格式不正确!';
					$timeout(function () {
						freeExpr.flag = 1;
						freeExpr.message = '';
					}, 1500);
				} else {
					$("#free_send_vcode").attr("disabled", 'disabled');
					$http.post('https://s0.zkcserv.com/demo/cb_hrms/index.cfm?event=ionicAction.ionicAction.demoSendPwdVCode', {}, {
						params: {
							tel_no: freeExpr.tel_no
						},
						timeout: _var_timeout
					}).
					success(function (data, status, headers, config) {
						if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
							$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {

							});
							return;
						}
						if (data.flag == 0) {
							var countdown = 120;
							fufu_register_timeout = setInterval(function () {
								countdown--;
								$("#free_send_vcode").text(countdown + ' S');
							}, 1000);
							setTimeout(function () {
								clearInterval(fufu_register_timeout);
								$("#free_send_vcode").removeAttr("disabled");
								$("#free_send_vcode").text('获取验证码');
							}, 120000);
						} else {
							$("#free_send_vcode").removeAttr("disabled");
							$("#free_send_vcode").text('获取验证码');
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});

						}
					}).
					error(function (data, status, headers, config) {
						$("#free_send_vcode").removeAttr("disabled");
						$("#free_send_vcode").text('获取验证码');
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					});
				}
			},
			getValidCode: function () {

				var reg = /^1[3|4|5|7|8]\d{9}$/;
				if (!reg.test(regModel._phone_num)) {
					regModel._flag = 0;
					regModel._message = '手机号码格式不正确!';
					$timeout(function () {
						regModel._flag = 1;
						regModel._message = '';
					}, 1500);
				} else {
					$("#reg_valid_vcode").attr("disabled", 'disabled');
					$.ajax({
						type: "GET",
						url: _redis_url + '/UserServer/user?action=sendCheckCode&jsonp=true&callback=jsonpCallBack&tagmobile=' + regModel._phone_num,
						dataType: "jsonp",
						timeout: _var_timeout,
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
								$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {

								});
								return;
							}
							if (data.success && data.success == true) {
								var countdown = 120;
								fufu_register_timeout = setInterval(function () {
									countdown--;
									$("#reg_valid_vcode").text(countdown + ' S');
								}, 1000);
								setTimeout(function () {
									clearInterval(fufu_register_timeout);
									$("#reg_valid_vcode").removeAttr("disabled");
									$("#reg_valid_vcode").text('获取验证码');
								}, 120000);
							} else {
								$("#reg_valid_vcode").removeAttr("disabled");
								$("#reg_valid_vcode").text('获取验证码');
								var message = "获取验证码失败";
								if (data.message && data.message == "mobile_in_use") {
									message = "手机号已注册";
								}
								$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + message + '</div>',
										okText: '确定'
									})
									.then(function (res) {});
							}
						},
						error: function () {
							$("#reg_valid_vcode").removeAttr("disabled");
							$("#reg_valid_vcode").text('获取验证码');
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					});
				}
			},
			loginMsg: function () {
				return loginMsg;
			},
			getRegModel: function () {
				return regModel;
			},
			userLogin: function (loginObj) {
				if (loginObj._user_name == '' || loginObj._pass_word == '') {
					loginMsg.flag = 0;
					loginMsg.message = '用户名或密码不能为空!';
					$timeout(function () {
						loginMsg.flag = 1;
						loginMsg.message = '';
					}, 1500);
					return;
				}
				try {
					if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
						window.plugins.jPushPlugin.getRegistrationID(function (data) {
							setLocalStorageVar("_notification_token", data);
						});
					}
				} catch (e) {}
				$rootScope.showLoading();
				$.ajax({
					type: "POST",
					url: _redis_url + '/UserServer/login',
					dataType: "jsonp",
					data: {
						username: loginObj._user_name,
						password: loginObj._pass_word,
						is_mobile: 1,
						_is_login: 0
					},
					timeout: _var_timeout,
					jsonp: "callback",
					jsonpCallback: "jsonpCallBack",
					success: function (data) {

						if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
							$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
								$rootScope.hideLoading();
							});
							return;
						}
						if (angular.isDefined(data) && data.success) {
							if (!angular.isDefined(_login_debug_url) || _login_debug_url == '') {
								setLocalStorageVar("_remote_server_addr", data.url);
							} else {
								setLocalStorageVar("_remote_server_addr", _login_debug_url);
							}

							$.ajax({
								type: "GET",
								url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.userLogin&_user_name=' + loginObj._user_name + '&_pass_word=' + loginObj._pass_word + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'] + '&is_mobile=1&_is_login=0&_dc=' + new Date().getTime(),
								dataType: "jsonp",
								timeout: _var_timeout,
								jsonp: "callback",
								jsonpCallback: "jsonpCallBack",
								success: function (data) {
									$rootScope.hideLoading();
									if (angular.isDefined(data.flag) && data.flag == '0') {
										loginMsg.flag = 0;
										loginMsg.message = data.message;
										$timeout(function () {
											loginMsg.flag = 1; 
											loginMsg.message = '';
										}, 1500);
									} else {
										$("#_user_pwd").val('');
										loginMsg.flag = 1;
										loginMsg.message = '';
										if (data.pageurl == "home_page") {
											try {
												autosignin.loginSuccess();
											} catch (e) {

											}
											setLocalStorageVar("_user_name", data._user_name);
											setLocalStorageVar("_pass_word", data._pass_word);
											setLocalStorageVar("_role_name", data._role_name);
											setLocalStorageVar("org_top_level", data.org_top_level);
											setLocalStorageVar("_vip_bu", data.bu);
											setLocalStorageVar("vip_status", data.vip_status);
                                            setLocalStorageVar("_is_login", "1");
                                            setLocalStorageVar("is_vip", data.is_vip);
											fufuMobclickAgent('click_login');
											//checkMbAppVersion(window.localStorage['_remote_server_addr'],$ionicPopup,$ionicLoading,$rootScope,$location);

											reSendJpushData();
											$location.path('home_page/home_default');

											MsgSettingSev.notData();
										} else {
											$location.path(data.pageurl);
										}
									}
								},
								error: function () {
									$rootScope.hideLoading();
									window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
								}
							});
						} else {
							$rootScope.hideLoading();
							loginMsg.flag = 0;
							loginMsg.message = '用户名或密码错误';
							$timeout(function () {
								loginMsg.flag = 1;
								loginMsg.message = '';
							}, 1500);
						}
					},
					error: function () {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
	})


	.factory('compRegSev', function ($http, $rootScope, $location, $timeout, $ionicPopup) {
		var regModel = {
			_phone_num: '',
			_pwd1: '',
			_pwd2: '',
			_comp_name: '',
			_category: '请选择您所属的行业',
			_empl_num: '请选择企业规模',
			valid_code: '',
			_sn_list: '',
			_contact_name: '',
			_contact_position: '',
			_flag: 1,
			_message: '',
			img_valid_code: '',
		}
		var freeExpr = {
			flag: 1,
			cmp_name: '',
			cmp_contact: '',
			message: '',
			tel_no: '',
			valid_code: ''
		}
		return {
			getFreeData: function () {
				return freeExpr;
			},
			getValidCode: function () {
				var reg = /^1[3|4|5|7|8]\d{9}$/;
				if (!reg.test(regModel._phone_num)) {
					regModel._flag = 0;
					regModel._message = '手机号码格式不正确!';
					$timeout(function () {
						regModel._flag = 1;
						regModel._message = '';
					}, 1500);
				} else if (angular.isDefined(regModel.img_valid_code) && regModel.img_valid_code.length != 5) {
					regModel._flag = 0;
					regModel._message = '图形验证码不正确!';
					$timeout(function () {
						regModel._flag = 1;
						regModel._message = '';
					}, 1500);
				} else {
					$("#reg_valid_vcode").attr("disabled", 'disabled');
					$.ajax({
						type: "GET",
						url: _redis_url + '/UserServer/user?action=sendCheckCode&is_img_valid=1&jsonp=true&callback=jsonpCallBack&tagmobile=' + regModel._phone_num + "&img_valid_code=" + regModel.img_valid_code,
						dataType: "jsonp",
						timeout: _var_timeout,
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
								$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {

								});
								return;
							}
							if (angular.isDefined(data) && data.message == "valid_code") {
								$timeout(function () {
									regModel._flag = 0;
									regModel._message = '图形验证码不正确!';
								}, 0)

								$timeout(function () {
									regModel._flag = 1;
									regModel._message = '';
									$("#reg_valid_vcode").removeAttr("disabled");
									$("#reg_valid_vcode").text('获取验证码');
								}, 1500);
								return;
							}
							if (data.success && data.success == true) {
								var countdown = 120;
								fufu_register_timeout = setInterval(function () {
									countdown--;
									$("#reg_valid_vcode").text(countdown + ' S');
								}, 1000);
								setTimeout(function () {
									clearInterval(fufu_register_timeout);
									$("#reg_valid_vcode").removeAttr("disabled");
									$("#reg_valid_vcode").text('获取验证码');
								}, 120000);
							} else {
								$("#reg_valid_vcode").removeAttr("disabled");
								$("#reg_valid_vcode").text('获取验证码');
								var message = "获取验证码失败";
								if (data.message && data.message == "mobile_in_use") {
									message = "手机号已注册";
								}
								$ionicPopup.alert({
										title: '运行结果',
										template: '<div style="text-align: center;">' + message + '</div>',
										okText: '确定'
									})
									.then(function (res) {});
							}
						},
						error: function () {
							$("#reg_valid_vcode").removeAttr("disabled");
							$("#reg_valid_vcode").text('获取验证码');
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					});
				}
			},
			getRegModel: function () {
				return regModel;
			},


		}
	})

	.factory('userHomeService', function ($http, $rootScope, $location, $ionicPopup, $ionicLoading, $ionicHistory, $timeout) {
		var menuList = [];
		var wifi_obj = {};
		wifi_obj.is_connected = true;

		return {
			addScanCodeDevice:function(sn){
				var _str = '';
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				var date = new Date();
				var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
				var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
				var inputdate = date.getFullYear() + "-" + month + "-" + day;
				$rootScope.showLoading();
				$.ajax({
					type: "POST",
					url: window.localStorage['_remote_server_addr'] + "?event=zkat.general.addsn&"+_str,
					timeout: 300000,
					data: {
						'update_data': 'sn:' + sn + '\nid:\nstatus:0\ninput_date:',
						'data': 'sn:' +sn + '\nstatus:1\ninput_date:' + inputdate,
						'device_sn': sn,
						'device_name':sn
					},
					success: function (json) {
						var data = $.parseJSON(json);
						$rootScope.hideLoading();
						if (angular.isDefined(data.flag) && data.flag == '0') {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {
							});
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function () {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				})
			},
			loadMenuList: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: "GET",
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMenuList&' + _str,
					success: function (_data) {

						$rootScope.hideLoading();
						try {
							var data = $.parseJSON(_data);
							if (data == '') {
								$ionicPopup.alert({
									title: '提醒',
									template: '<div style="text-align: center;">数据加载异常,请重新登录</div>',
									okText: '确定'
								}).then(function () {
									$ionicHistory.clearCache();
									$ionicHistory.clearHistory();
									setLocalStorageVar("_pass_word", "");
									setLocalStorageVar("_is_login", "0");
									$location.path('/');
								});
								return;
							}


							angular.copy(data, menuList);



							//alert('主页面菜单缓存刷新');
							if (data.length > 0 && typeof (data[0].menu_key) != 'undefined') {
								setLocalStorageVar("menu_home", _data);
							}
						} catch (e) {
							$ionicPopup.alert({
								title: '提醒',
								template: '<div style="text-align: center;">系统执行异常,请重新登录</div>',
								okText: '确定'
							}).then(function () {
								$ionicHistory.clearCache();
								$ionicHistory.clearHistory();
								setLocalStorageVar("_pass_word", "");
								setLocalStorageVar("_is_login", "0");
								$location.path('/');
							});
							return;
						}
					},
					error: function () {
						$rootScope.hideLoading();
						$ionicPopup.alert({
							title: '提醒',
							template: '<div style="text-align: center;">' + fufu_network_error_msg + '</div>',
							okText: '确定'
						}).then(function () {
							$ionicHistory.clearCache();
							$ionicHistory.clearHistory();
							setLocalStorageVar("_pass_word", "");
							setLocalStorageVar("_is_login", "0");
							$location.path('/');
						});
					}
				});
			},
			clearData: function () {
				menuList = [];
			},
			getMenuList: function () {

				return menuList;
			},
			setMenuList: function (tempList) {
				angular.copy(tempList, menuList);
			},
			getWifiObj: function () {
				return wifi_obj;
			},
			setWifiObj: function (connected) {
				wifi_obj.is_connected = connected;
			}
		}
	})
	.factory('menulistService', function ($http, $rootScope, $location, $ionicPopup) {
		var modelList = [];
		return {
			loadModelList: function (model_key) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadModelList&model_key=' + model_key + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, modelList);
					if (data.length > 0 && typeof (data[0].menu_key) != 'undefined') {
						setLocalStorageVar("menu_" + model_key, JSON.stringify(modelList));
						if (window.localStorage["menu_list"] == null || typeof (window.localStorage["menu_list"]) == 'undefined' || window.localStorage["menu_list"] == '') {
							setLocalStorageVar("menu_list", "");
						}

						if (window.localStorage["menu_list"].indexOf("menu_" + model_key) == -1) {
							setLocalStorageVar("menu_list", window.localStorage["menu_list"] + "menu_" + model_key + ',');
							//alert('子菜单' + model_key + '缓存刷新');
						}
					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			refreshData: function (model_key, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadModelList&model_key=' + model_key + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					angular.copy(data, modelList);
					$scope.$broadcast('scroll.refreshComplete');
					if (data.length > 0 && typeof (data[0].menu_key) != 'undefined') {
						setLocalStorageVar("menu_" + model_key, JSON.stringify(modelList));
						if (window.localStorage["menu_list"] == null || typeof (window.localStorage["menu_list"]) == 'undefined' || window.localStorage["menu_list"] == '') {
							setLocalStorageVar("menu_list", "");
						}
						if (window.localStorage["menu_list"].indexOf("menu_" + model_key) == -1) {
							setLocalStorageVar("menu_list", window.localStorage["menu_list"] + "menu_" + model_key + ',');
							//alert('子菜单' + model_key + '缓存刷新');
						}
					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.refreshComplete');
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				modelList = [];
			},
			getModelList: function () {
				return modelList;
			},
			setModelList: function (data) {
				angular.copy(data, modelList);
			}
		}
	})

	.factory('staffService', function ($http, $rootScope, $location, $ionicPopup, $timeout) {
		var staff_data = {
			'e_d': [],
			'e_c': [],
			'title': '在职员工'
		};
		return {
			loadStaffMasterList: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadStaffMasterList&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, staff_data);
					staff_data.e_action = {
						'f0': '在职员工',
						'f1': '本月入职工',
						'f2': '本月离职工',
						'f3': '离职员工',
						'f4': '全部员工'
					};
					for (var i = 0; i < data.e_c.length; i++) {
						staff_data.e_action['f' + i] = staff_data.e_action['f' + i] + '(' + staff_data.e_c[i] + ')';
					}
					staff_data.title = staff_data.e_action['f0'];
					staff_data.data_ready = true;

					//staff_data.title = staff_data.e_action['f0'];
					//console.log(staff_data.e_action['f0']);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				staff_data = {
					'e_d': [],
					'e_c': [],
					'title': '在职员工'
				};
			},
			getStaffMasterList: function () {
				return staff_data;
			}
		}
	})

	.factory('staffMsDetailSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, staffService) {
		var master_details_data = {};
		var departmentTreeData = [];
		var positionTreeData = [];
		return {
			loadStaffMsDetails: function (emloyee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadStaffMsDetails&employee_no=' + emloyee_no + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var id_type_data = [];
					data.id_type_index = '';
					document.getElementById('id_type').innerHTML = '请选择';
					data.id_type_data_key = '';
					for (var i = 0; i < data.id_type.length; i++) {
						id_type_data[i] = data.id_type[i];
						id_type_data[i].key = data.id_type[i].key_;
						id_type_data[i].value = data.id_type[i].value_;
						if (id_type_data[i].ch) {
							data.id_type_index = i;
							document.getElementById('id_type').innerHTML = id_type_data[i].value;
							data.id_type_data_key = id_type_data[i].key;
						}
					}
					data.id_type_data = id_type_data;
					//data.id_type_data_key=id_type_data[data.id_type_index].key;

					var gender_data = [];
					data.gender_index = '';
					data.gender_data_key = '';
					document.getElementById('gender').innerHTML = '请选择';
					for (var i = 0; i < data.gender.length; i++) {
						gender_data[i] = data.gender[i];
						gender_data[i].key = data.gender[i].key_;
						gender_data[i].value = data.gender[i].value_;
						if (gender_data[i].ch) {
							data.gender_index = i;
							document.getElementById('gender').innerHTML = gender_data[i].value;
							data.gender_data_key = gender_data[i].key;
						}
					}
					data.gender_data = gender_data;


					var nationality_data = [];
					data.nationality_index = '';
					data.nationality_data_key = '';
					document.getElementById('nationality').innerHTML = '请选择';
					for (var i = 0; i < data.nationality.length; i++) {
						nationality_data[i] = data.nationality[i];
						nationality_data[i].key = data.nationality[i].key_;
						nationality_data[i].value = data.nationality[i].value_;
						if (nationality_data[i].ch) {
							data.nationality_index = i;
							document.getElementById('nationality').innerHTML = nationality_data[i].value;
							data.nationality_data_key = nationality_data[i].key;
						}
					}
					data.nationality_data = nationality_data;


					var race_data = [];
					data.race_index = '';
					data.race_data_key = '';
					document.getElementById('race').innerHTML = '请选择';
					for (var i = 0; i < data.race.length; i++) {
						race_data[i] = data.race[i];
						race_data[i].key = data.race[i].key_;
						race_data[i].value = data.race[i].value_;
						if (race_data[i].ch) {
							data.race_index = i;
							document.getElementById('race').innerHTML = race_data[i].value;
							data.race_data_key = race_data[i].key;
						}
					}
					data.race_data = race_data;

					var education_level_data = [];
					data.education_level_index = '';
					data.education_level_data_key = '';
					document.getElementById('education_level').innerHTML = '请选择';
					for (var i = 0; i < data.education_level.length; i++) {
						education_level_data[i] = data.education_level[i];
						education_level_data[i].key = data.education_level[i].key_;
						education_level_data[i].value = data.education_level[i].value_;
						if (education_level_data[i].ch) {
							data.education_level_index = i;
							document.getElementById('education_level').innerHTML = education_level_data[i].value;
							data.education_level_data_key = education_level_data[i].key;
						}
					}
					data.education_level_data = education_level_data;
					angular.copy(data, master_details_data);
					//$("#date_of_birth").val('');
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				master_details_data = {};
			},
			getStaffMsDetails: function () {
				return master_details_data;
			},
			saveStaffDetails: function () {
				/*
				var reg=/^[1-9]{1}[0-9]{14}$|^[1-9]{1}[0-9]{16}([0-9]|[xX])$/;
				if(!reg.test($('#id_number').val())){
				$ionicPopup.alert({
				title: '运行结果',
				template: '<div style="text-align: center;">身份证号码格式不正确</div>',
				okText: '确定'
				}) .then(function(res) {
				});
				return;
				}
				*/

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}


				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveStaffDetails&' + _str, {}, {
					params: {
						employee_no: master_details_data.employee_no,
						employee_name: $("#employee_name_input").val(),
						p_n_i: $("#p_n_i").val(),
						o_n_i: $("#o_n_i").val(),
						join_date: master_details_data.join_date,
						p_c_d: master_details_data.p_c_d,
						id_type: master_details_data.id_type_data_key,
						id_number: $("#id_number").val(),
						date_of_birth: document.getElementById("date_of_birth").innerHTML,
						gender: master_details_data.gender_data_key,
						home_tel_no: $("#mobile_no").val(),
						email: $("#email").val(),
						address: $("#address").val(),
						nationality: master_details_data.nationality_data_key,
						p_o_b: $("#p_o_b").val(),
						race: master_details_data.race_data_key,
						education_level: master_details_data.education_level_data_key,
						emergency_contact_name1: $("#emergency_contact_name1").val(),
						emergency_contact_no1: $("#emergency_contact_no1").val(),
						is_need_valid: '1'
						//is_require_upload: '0',
						//data_type:"1",
						//file_name:master_details_data.staff_photo_file_name


					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_edit_staff_master');
							staffService.loadStaffMasterList();
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveStaffPhoto: function (staff_employee_no) {

				var options = new FileUploadOptions();
				options.fileKey = 'personnal_details_employee_photo';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				//alert(staff_employee_no)
				params.employee_no = staff_employee_no;


				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();
				ft.upload(
					document.getElementById('staff_master_details_employee_photo').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveStaffPhoto',
					function (data) {
						/*
						 var _data = $.parseJSON(data);

						 $rootScope.hideLoading();
						 $ionicPopup.alert({
						 title: '运行结果',
						 template: '<div style="text-align: center;">' + data.response.message + '</div>',
						 okText: '确定'
						 })
						 .then(function(res) {

						 });
						 */
						staffService.loadStaffMasterList();
					},
					function (error) {

						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);

			},

			loadDepartmentTreeData: function () {
				var c = null;

				function callback(callback) {
					c = callback;
				}

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadStaffMsDetails&employee_no=123' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					data = [{
						"_id": "111", //这四个字段，是约定必须要有的，请数据源的时候定义好
						"text": "北京公司",
						"is_checked": false,
						"is_expand": true,
						"children": [{
							"_id": "222",
							"text": "深圳研发部",
							"is_checked": false,
							"is_expand": true,
						}, {
							"_id": "111",
							"text": "深圳设计部",
							"is_checked": false,
							"is_expand": true,
						}]
					}];
					angular.copy(data, departmentTreeData);
					typeof c == 'function' && c();
				});

				return {

					then: callback
				}
			},
			getDepartmentTreeData: function () {
				return departmentTreeData;
			},

			loadPositionTreeData: function () {
				var c = null;

				function callback(callback) {
					c = callback;
				}

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadStaffMsDetails&employee_no=123' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					data = [{
						"_id": "111", //这四个字段，是约定必须要有的，请数据源的时候定义好
						"text": "开发部主管",
						"is_checked": false,
						"is_expand": true,
						"children": [{
							"_id": "222",
							"text": "开发部程序员",
							"is_checked": false,
							"is_expand": true,
						}, {
							"_id": "111",
							"text": "开发部测试员",
							"is_checked": false,
							"is_expand": true,
						}]
					}];
					angular.copy(data, positionTreeData);
					typeof c == 'function' && c();
				});

				return {

					then: callback
				}
			},
			getPositionTreeData: function () {
				return positionTreeData;
			}

		}
	})

	.factory('emplArSev', function ($http, $rootScope, $ionicPopup, atRosSev, $timeout) {
		var empl_ar_data = {};
		var _c = this;
		return {
			loadArData: function (_date, employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadArData&employee_no=' + employee_no + "&_date=" + _date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var roster_policy_data = [];
					data.roster_policy_index = '';
					document.getElementById('roster_policy').innerHTML = '请选择';
					data.roster_policy_data_key = '';

					for (var i = 0; i < data.current_roster.roster_data.length; i++) {
						roster_policy_data.push({
							"key": data.current_roster.roster_data[i].key,
							"value": data.current_roster.roster_data[i].key
						});
						if (data.current_roster.roster_data[i].checked == "true") {
							data.roster_policy_index = i;
							document.getElementById('roster_policy').innerHTML = data.current_roster.roster_data[i].key;
						}
					}

					data.roster_policy_data = roster_policy_data;

					angular.copy(data, empl_ar_data);
					empl_ar_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getArData: function () {
				return empl_ar_data;
			},
			clearData: function () {
				empl_ar_data = {};
			},
			lArByDate: function (_date, employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.lArByDate&employee_no=' + employee_no + "&_date=" + _date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					var roster_policy_data = [];
					empl_ar_data.roster_policy_index = '';
					document.getElementById('roster_policy').innerHTML = '请选择';
					empl_ar_data.roster_policy_data_key = '';

					for (var i = 0; i < data.current_roster.roster_data.length; i++) {
						roster_policy_data.push({
							"key": data.current_roster.roster_data[i].key,
							"value": data.current_roster.roster_data[i].key
						});
						if (data.current_roster.roster_data[i].checked == "true") {
							empl_ar_data.roster_policy_index = i;
							document.getElementById('roster_policy').innerHTML = data.current_roster.roster_data[i].key;
						}
					}

					$timeout(function () {
						empl_ar_data.roster_policy_data = roster_policy_data;
						angular.copy(data.current_roster, empl_ar_data.current_roster);
					}, 100);
				}).
				error(function (data, status) {
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			lArByPolicy: function (policy_name) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.lArByPolicy&policy_name=' + policy_name + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					empl_ar_data.current_roster.roster_from = data.roster_from;
					empl_ar_data.current_roster.roster_to = data.roster_to;
				}).
				error(function (data, status) {
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveEmplAr: function (_date, employee_no, roster_policy, curr_date) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEmplAr', {}, {
					timeout: _var_timeout,
					params: {
						_date: _date,
						employee_no: employee_no,
						roster_policy: roster_policy,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							$("._ar_c").removeClass("_ar_e").addClass("_ar_n");
							$("._ar_c p").removeClass("_ar_e").addClass("_ar_n");
							atRosSev.loadAtRosData(curr_date, '0');
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			deleteEmplAr: function (_date, employee_no) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.deleteEmplAr', {}, {
					timeout: _var_timeout,
					params: {
						_date: _date,
						employee_no: employee_no,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							$("._ar_c").removeClass("_ar_e").removeClass("_ar_n");
							$("._ar_c p").removeClass("_ar_e").removeClass("_ar_n");
							empl_ar_data.current_roster.roster_from = '';
							empl_ar_data.current_roster.roster_to = '';
							empl_ar_data.current_roster.roster_policy = '';
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})

	.factory('padjSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var padj_data = {};
		return {
			loadPadjData: function (employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPadjData&employee_no=' + employee_no + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, padj_data);
					$("#padj_eff_date").val(padj_data.eff_date);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				padj_data = {};
			},
			getPadjData: function () {
				return padj_data;
			},
			savePadjData: function (employee_no) {
				var save_ps = {
					employee_no: employee_no,
					old_value: padj_data.base_salary,
					new_value: $("#padj_new_value").val(),
					eff_date: document.getElementById("padj_eff_date").innerHTML,
					mv_reason: padj_data.mv_reason,
					_user_name: window.localStorage['_user_name'],
					_pass_word: window.localStorage['_pass_word'],
					_is_login: window.localStorage['_is_login'],
					_notification_token: window.localStorage['_notification_token'],
					_device_type: window.localStorage['_device_type']
				};
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePadjData', {}, {
					params: save_ps,
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})
	.factory('pMsSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var pms_data = {};
		return {
			loadPmsData: function (employee_no) {
				var _str = '';
				pms_data = {};
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPmsData&employee_no=' + employee_no + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, pms_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				pms_data = {};
			},
			getPmsData: function () {
				return pms_data;
			},
			savePmsData: function (employee_no) {
				var pay_list = "";
				var payListObj = pms_data.pay_list;
				if (angular.isArray(payListObj)) {
					for (var i = 0; i < payListObj.length; i++) {
						pay_list = pay_list + payListObj[i].p + ":" + payListObj[i].v + ",";
					}
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePmsData', {}, {
					params: {
						employee_no: employee_no,
						pay_list: pay_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})
	.factory('modalEmplSev', function ($http, $rootScope, $location, $ionicPopup) {
		var staff_data = [];
		return {
			loadEmplList: function (hidden_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMdEmplList&employee_list=' + $("#" + hidden_id).val() + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, staff_data);
					staff_data.total_checked = 0;
					for (var i = 0; i < staff_data.length; i++) {
						if (staff_data[i].ck) {
							staff_data.total_checked++;
						}
					}
					staff_data.data_ready = true;
					staff_data.show_footer_bar = false;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				staff_data = [];
			},
			getEmplList: function () {
				return staff_data;
			}
		}
	})
	.factory('autoRosSev', function ($http, $rootScope, $location, $ionicPopup, $timeout) {
		var process_data = {};
		process_data.process_status = '0';
		return {
			runRoster: function (ee_list, start, end, flag, ck_all) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.runRoster', {}, {
					timeout: 30000000,
					params: {
						ee_list: ee_list,
						start: start,
						end: end,
						flag: flag,
						ck_all: ck_all,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						fufuMobclickAgent('click_auto_roster');
						setLocalStorageVar("process_auto_roster_status" + window.localStorage['_user_name'], "1");
						process_data.process_status = '1';
					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getProcessStatus: function () {
				if (window.localStorage["process_auto_roster_status" + window.localStorage['_user_name']] != null && typeof (window.localStorage["process_auto_roster_status" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["process_auto_roster_status" + window.localStorage['_user_name']] != '') {
					process_data.process_status = window.localStorage["process_auto_roster_status" + window.localStorage['_user_name']];
				} else {
					process_data.process_status = '0';
				}
				return process_data;
			},

			setProcessStatus: function (payroll_status) {
				$timeout(function () {
					setLocalStorageVar("process_auto_roster_status" + window.localStorage['_user_name'], payroll_status.toString());
					process_data.process_status = payroll_status;

				});
			}
		}
	})
	.factory('atRosSev', function ($http, $rootScope, $ionicPopup) {
		var at_ros_data = {};
		return {
			loadAtRosData: function (c_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtRosData&curr_date=' + c_date + "&flag=" + flag + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_ros_data);
					$("#at_roster_1").val(at_ros_data.dt);
					document.getElementById('at_roster_').innerHTML = at_ros_data.dt;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAtRosData: function () {
				return at_ros_data;
			},
			clearData: function () {
				at_ros_data = {};
			}
		}
	})
	.factory('atAnalySev', function ($http, $rootScope, $ionicPopup, $location, $timeout) {
		var process_data = {};
		process_data.process_status = '0';
		return {
			runAnalysis: function (ee_list, start, end, ck_all) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.runAnalysis', {}, {
					timeout: 30000000,
					params: {
						ee_list: ee_list,
						start: start,
						end: end,
						ck_all: ck_all,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();

					if (data.flag == '0') {
						fufuMobclickAgent('click_at_analysis');
						setLocalStorageVar("process_at_status" + window.localStorage['_user_name'], "1");
						process_data.process_status = '1';

					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getProcessStatus: function () {
				if (window.localStorage["process_at_status" + window.localStorage['_user_name']] != null && typeof (window.localStorage["process_at_status" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["process_at_status" + window.localStorage['_user_name']] != '') {
					process_data.process_status = window.localStorage["process_at_status" + window.localStorage['_user_name']];
				} else {
					process_data.process_status = '0';
				}
				return process_data;
			},

			setProcessStatus: function (at_status) {
				$timeout(function () {
					setLocalStorageVar("process_at_status" + window.localStorage['_user_name'], at_status.toString());
					process_data.process_status = at_status;

				});
			}
		}
	})
	.factory('atResultSev', function ($http, $rootScope, $ionicPopup) {
		var at_result_data = {};
		return {
			loadAtResultData: function (c_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtResultData&curr_date=' + c_date + "&flag=" + flag + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$("#at_result_1").val(data.dt);

					angular.copy(data, at_result_data);
					at_result_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAtResultData: function () {
				return at_result_data;
			},
			clearData: function () {
				at_result_data = {};
			}
		}
	})
	.factory('atEmplDetailSev', function ($http, $rootScope, $ionicPopup) {
		var at_empl_detail_data = {};
		var close_flag = 0;
		return {
			loadAtDetailData: function (empl_no, curr_date, _flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtDetailData&curr_date=' + curr_date + "&_flag=" + _flag + "&empl_no=" + empl_no + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_empl_detail_data);
					$("#at_empl_detail_1").val(data.date_);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			reAtAnalysis: function (empl_no, curr_date) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.reAtAnalysis', {}, {
					timeout: 30000000,
					params: {
						empl_no: empl_no,
						curr_date: curr_date,
						first_in: $("#at_from_0").val(),
						first_out: $("#at_to_0").val(),
						second_in: $("#at_from_1").val(),
						second_out: $("#at_to_1").val(),
						ot_in: $("#at_from_2").val(),
						ot_out: $("#at_to_2").val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == "0") {
						angular.copy(data.message, at_empl_detail_data);
						$ionicPopup.alert({
							title: '运行结果',
							template: '<div style="text-align: center;">保存&重新分析考勤成功</div>',
							okText: '确定'
						}).then(function (res) {

						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getAtDetailData: function () {
				return at_empl_detail_data;
			},
			clearData: function () {
				at_empl_detail_data = {};
			}
		}
	})
	.factory('payrollCalSev', function ($http, $rootScope, $ionicPopup, $location, $ionicHistory, $timeout) {
		var process_data = {};
		process_data.process_status = '0';
		var payroll_cal_data = {};
		var payroll_cal_employee_select_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPayrollData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (typeof (data.pay_start) != 'undefined') {
						//data.pay_start_str = data.pay_start.split('-')[0] + '-' + data.pay_start.split('-')[1];
						data.pay_terms_picklist = [];
						data.pay_date_picklist = [];
						data.pay_date_picklist_index = 0;
						for (var i = 0; i < data.pay_terms_str.length; i++) {
							data.pay_terms_picklist.push({
								"key": data.pay_terms_str[i].pay_terms_id,
								"value": data.pay_terms_str[i].pay_terms
							});
							if (data.pay_terms_str[i].check) {
								data.pay_pay_terms_picklist_index = i;
								data.pay_date_key = data.pay_terms_str[i].pay_date[0].pay_start + '///' + data.pay_terms_str[i].pay_date[0].pay_end;
								data.pay_date_value = data.pay_terms_str[i].pay_date[0].pay_start.split('-')[0] + '-' + data.pay_terms_str[i].pay_date[0].pay_start.split('-')[1];
								data.pay_date_picklist.push({
									"key": data.pay_terms_str[i].pay_date[0].pay_start + '///' + data.pay_terms_str[i].pay_date[0].pay_end,
									"value": data.pay_terms_str[i].pay_date[0].pay_start.split('-')[0] + '-' + data.pay_terms_str[i].pay_date[0].pay_start.split('-')[1]
								});
								data.pay_date_picklist.push({
									"key": data.pay_terms_str[i].pay_date[1].pay_start + '///' + data.pay_terms_str[i].pay_date[1].pay_end,
									"value": data.pay_terms_str[i].pay_date[1].pay_start.split('-')[0] + '-' + data.pay_terms_str[i].pay_date[1].pay_start.split('-')[1]
								});
							}
						}

					}

					angular.copy(data, payroll_cal_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			getData: function () {
				return payroll_cal_data;
			},

			runPayrollCal: function (ee_list, ck_all) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.runPayrollCal', {}, {
					timeout: 30000000,
					params: {
						pay_terms_id: payroll_cal_data.pay_terms_id,
						ee_list: ee_list,
						start: payroll_cal_data.pay_date_key.split('///')[0],
						end: payroll_cal_data.pay_date_key.split('///')[1],
						ck_all: ck_all,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						fufuMobclickAgent('click_payroll_cal');
						setLocalStorageVar("process_payroll_status" + window.localStorage['_user_name'], "1");
						process_data.process_status = '1';

					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			getProcessStatus: function () {
				if (window.localStorage["process_payroll_status" + window.localStorage['_user_name']] != null && typeof (window.localStorage["process_payroll_status" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["process_payroll_status" + window.localStorage['_user_name']] != '') {
					process_data.process_status = window.localStorage["process_payroll_status" + window.localStorage['_user_name']];
				} else {
					process_data.process_status = '0';
				}
				return process_data;
			},

			setProcessStatus: function (payroll_status) {
				$timeout(function () {
					setLocalStorageVar("process_payroll_status" + window.localStorage['_user_name'], payroll_status.toString());
					process_data.process_status = payroll_status;

				});
			},

			loadEmployeeData: function () {
				var _str = '';
				var employee_list = $('#payroll_cal_empl_list_hidden').val();
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getPayrollCalEmployeeSelectData&' + _str + '&employee_list=' + employee_list + '&pay_terms_id=' + payroll_cal_data.pay_terms_id, {
					timeout: _var_timeout
				}).
				//$http.get(window.localStorage['_remote_server_addr']+'?event=ionicAction.ionicAction.loadMdEmplList&employee_list='+$("#shift_group_edit_empl_list_hidden").val()+'&'+_str,{
				//            timeout:_var_timeout
				//          }).
				success(function (data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					temp_obj.total_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck == true) {
							temp_obj.total_checked++;
						}
					}
					temp_obj.data = data;
					angular.copy(temp_obj, payroll_cal_employee_select_data);
					payroll_cal_employee_select_data.data_ready = true;

					payroll_cal_employee_select_data.show_footer_bar = false;


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEmployeeData: function () {
				return payroll_cal_employee_select_data;
			},
			clearEmployeeData: function () {
				payroll_cal_employee_select_data = [];
			}

		}
	})
	.factory('payrollSendSev', function ($http, $rootScope, $ionicPopup, $location) {
		var pay_send_data = {};
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPrSendData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, pay_send_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return pay_send_data;
			},
			clearData: function () {
				pay_send_data = {};
			},
			sendPayroll: function (start, end) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.sendPayroll', {}, {
					timeout: _var_timeout,
					params: {
						start: start,
						end: end,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							pay_send_data.fg = '1';
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})

	.factory('payrollSlipSev', function ($http, $rootScope, $ionicPopup, $timeout, $ionicScrollDelegate) {
		var pay_slip_data = {};
		return {
			loadData: function (_flag, curr_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPaySlipData&flag=' + _flag + '&curr_date=' + curr_date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (_flag == 0) {
						if (data.data2 == 1) {
							//data.stage = 'password_setup';
							document.getElementById('payslip_password_setting_text').innerHTML = '设置密码';
						} else if (data.data2 == 2) {
							//data.stage = 'input_password';
							document.getElementById('payslip_password_setting_text').innerHTML = '输入密码';
							document.getElementById('payslip_password_setting_forgetpwd').style.display = "block";
						}
						document.getElementById('payslip_password_setting_div').style.display = 'block';
						$timeout(function () {
							$ionicScrollDelegate.resize();
						}, 100);

					}
					angular.copy(data, pay_slip_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			payslipVerifyPassword: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.payslipVerifyPassword&current_password=' + $scope.current_password + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						//密码正确
						if (data.message == "3") {
							document.getElementById('payroll_slip_reset_password_div').style.display = "block";
							document.getElementById('payslip_password_setting_div').style.display = 'none';
							document.getElementById('payslip_view_div').style.display = 'block';
							$timeout(function () {
								$ionicScrollDelegate.resize();
							}, 100);
						}
						//密码不正确
						else if (data.message == "2") {
							window.fufuMessageBox("密码不正确", fufu_message_box_duration, function () {});
							var reset_function = setInterval(function () {
								if (fufu_message_box_counter > 10 || ((fufu_show_loading_counter > 7 || fufu_show_loading_counter == 0) && !fufu_show_loading)) {
									//alert("123");
									$scope.current_password = "";
									document.getElementById('password_char1').style.display = "none";
									document.getElementById('password_char2').style.display = "none";
									document.getElementById('password_char3').style.display = "none";
									document.getElementById('password_char4').style.display = "none";
									clearTimeout(reset_function);
								}
							}, 100);

						}
						//不存在密码，正常不会出现这种状态
						else if (data.message == "3") {

						}
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					var reset_function = setInterval(function () {
						if (fufu_message_box_counter > 10 || (fufu_show_loading_counter > 7 && !fufu_show_loading)) {
							$scope.current_password = "";
							document.getElementById('password_char1').style.display = "none";
							document.getElementById('password_char2').style.display = "none";
							document.getElementById('password_char3').style.display = "none";
							document.getElementById('password_char4').style.display = "none";
							clearTimeout(reset_function);
						}
					}, 100);
				});
			},

			payslipSetPassword: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.payslipSetPassword&current_password=' + $scope.current_password + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						document.getElementById('payroll_slip_reset_password_div').style.display = "block";
						document.getElementById('payslip_password_setting_div').style.display = 'none';
						document.getElementById('payslip_view_div').style.display = 'block';
						$timeout(function () {
							$ionicScrollDelegate.resize();
						}, 100);
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					var reset_function = setInterval(function () {
						if (fufu_message_box_counter > 10 || (fufu_show_loading_counter > 7 && !fufu_show_loading)) {
							$scope.current_password = "";

							document.getElementById('password_char1').style.display = "none";
							document.getElementById('password_char2').style.display = "none";
							document.getElementById('password_char3').style.display = "none";
							document.getElementById('password_char4').style.display = "none";
							clearTimeout(reset_function);
						}
					}, 100);
				});
			},

			sendPwdVCode: function ($scope) {
				$.ajax({
					type: "GET",
					timeout: _var_timeout,
					url: _redis_url + '/UserServer/login?username=' + window.localStorage['_user_name'] + '&password=&is_mobile=1&_is_login=0',
					dataType: "jsonp",
					jsonp: "callback",
					jsonpCallback: "jsonpCallBack",
					success: function (data) {
						if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
							$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
								$("#send_vcode").removeAttr("disabled");
								$("#send_vcode").text('获取验证码');
							});
							return;
						}
						if (angular.isDefined(data) && data.success) {
							$http.post(data.url + '?event=ionicAction.ionicAction.sendPaySlipPwdVCode', {}, {
								params: {
									tel_no: window.localStorage['_user_name'],
									_user_name: window.localStorage['_user_name'],
									_pass_word: window.localStorage['_pass_word'],
									_is_login: window.localStorage['_is_login'],
									_notification_token: window.localStorage['_notification_token'],
									_device_type: window.localStorage['_device_type']
								},
								timeout: _var_timeout
							}).
							success(function (data, status, headers, config) {
								if (data.flag == 0) {
									$ionicPopup.alert({
											title: '运行结果',
											template: '<div style="text-align: center;">' + data.message + '</div>',
											okText: '确定'
										})
										.then(function (res) {});
								}
							}).
							error(function (data, status, headers, config) {
								$("#send_vcode").removeAttr("disabled");
								$("#send_vcode").text('获取验证码');
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							});
						} else {
							$("#send_vcode").removeAttr("disabled");
							$("#send_vcode").text('获取验证码');
							window.fufuMessageBox("网络超时或用户不存在", fufu_message_box_duration, function () {});
						}
					},
					error: function () {
						$("#send_vcode").removeAttr("disabled");
						$("#send_vcode").text('获取验证码');
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			payroll_slip_forget_password_reset_password: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.payslipVerifyPwdVCode&security_code=' + $(".active.ng-enter-active #payroll_slip_forget_password_valid_code").val() + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						$scope.current_password = '';
						$scope.retype_password = '';
						document.getElementById('payroll_slip_reset_password_div').style.display = "none";
						document.getElementById('payslip_password_setting_forgetpwd').style.display = "none";
						document.getElementById('payslip_password_setting_text').innerHTML = '设置密码';
						document.getElementById('password_char1').style.display = "none";
						document.getElementById('password_char2').style.display = "none";
						document.getElementById('password_char3').style.display = "none";
						document.getElementById('password_char4').style.display = "none";
						document.getElementById('payslip_password_setting_div').style.display = 'block';
						document.getElementById('payslip_view_div').style.display = 'none';
						$scope.modal.hide();
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					var reset_function = setInterval(function () {
						if (fufu_message_box_counter > 10 || (fufu_show_loading_counter > 7 && !fufu_show_loading)) {
							$scope.current_password = "";
							document.getElementById('password_char1').style.display = "none";
							document.getElementById('password_char2').style.display = "none";
							document.getElementById('password_char3').style.display = "none";
							document.getElementById('password_char4').style.display = "none";
							clearTimeout(reset_function);
						}
					}, 100);
				});
			},

			getData: function () {
				return pay_slip_data;
			},
			clearData: function () {
				pay_slip_data = {};
			}
		}
	})
	.factory('payrollResultSev', function ($http, $rootScope, $ionicPopup) {
		var payroll_result_data = {
			start_date: '',
			end_date: ''
		};
		return {
			loadPrResultData: function (start_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPrResultData&start_date=' + start_date + "&flag=" + flag + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, payroll_result_data);
					payroll_result_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getPrResultData: function () {
				return payroll_result_data;
			},
			clearData: function () {
				payroll_result_data = {
					start_date: '',
					end_date: ''
				};
			}
		}
	})
	.factory('pResultSlipSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var presult_slip_data = {};
		return {
			loadData: function (empl_no, start_date, end_date, pay_terms_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPrResultSlip&start_date=' + start_date + "&end_date=" + end_date + "&empl_no=" + empl_no + "&pay_terms_id=" + pay_terms_id + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, presult_slip_data);
					presult_slip_data.s_d_text = presult_slip_data.pay_start.substring(0, 7)

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				presult_slip_data = {};
			},
			getData: function () {
				return presult_slip_data;
			},
			mdyPrSlip: function (empl_no, start, end, v_list) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.mdyPayrollSlip', {}, {
					timeout: _var_timeout,
					params: {
						start_date: start,
						end_date: end,
						empl_no: empl_no,
						v_list: v_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})
	.factory('settingUdSev', function ($http, $rootScope, $ionicPopup, $timeout) {
		var user_data = [];
		var contacts_data = [];
		return {
			loadUserData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getSettingUdData&' + _str, {
					timeout: 60000
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, user_data);
					user_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadSortedUserData: function (current_datetime) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getWebImportResultUserAdminData&' + _str + '&current_datetime=' + current_datetime, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, user_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getUserData: function () {
				return user_data;
			},
			clearData: function () {
				user_data = [];
				contacts_data = [];
			},
			setting_user_admin_delete: function (username, user_id, index, isSearch) {

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.deleteuser',
					timeout: _var_timeout,
					data: {
						data: 'user_name:' + username,
						d_user_name: username,
						d_user_id: user_id
					},
					success: function (data, status, headers, config) {

						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {

								if (isSearch) {

									$timeout(function () {
										try {

											for (var i = 0, len = user_data.length; i < len; i++) {
												if (user_data[i].user_id == user_id) {
													var el = $("#user_" + user_id + " .item-content")[0];
													(el.style.webkitTransitionDuration != undefined) && (el.style.webkitTransitionDuration = "0ms");
													(el.style.transitionDuration != undefined) && (el.style.transitionDuration = "0ms");
													el.style.transform = "";
													(el.style.webkitTransitionDuration != undefined) && (el.style.webkitTransitionDuration = "");
													(el.style.transitionDuration != undefined) && (el.style.transitionDuration = "");
													$timeout(function () {
														user_data.splice(i, 1);
													}, 0);
													break;
												}
											}

										} catch (e) {
											alert(e);
										}

										$rootScope.hideLoading();
									}, 0);

								} else {
									$timeout(function () {


										try {
											var el = $("#user_" + user_id + " .item-content")[0];
											(el.style.webkitTransitionDuration != undefined) && (el.style.webkitTransitionDuration = "0ms");
											(el.style.transitionDuration != undefined) && (el.style.transitionDuration = "0ms");
											el.style.transform = "";
											(el.style.webkitTransitionDuration != undefined) && (el.style.webkitTransitionDuration = "");
											(el.style.transitionDuration != undefined) && (el.style.transitionDuration = "");
											user_data.splice(index, 1);
										} catch (e) {
											alert(e);
										}

										$rootScope.hideLoading();
									}, 0);

								}


								// document.getElementById('user_' + user_id).style.display = "none";
							});
						} else {
							$rootScope.hideLoading();
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			loadContactsData: function () {
				try {
					var options = new ContactFindOptions();
					options.filter = "";
					options.multiple = true;
					options.hasPhoneNumber = true;
					var fields = ['*'];
					navigator.contacts.find(fields, function (contacts) {
						$timeout(function () {
							//contacts_data = [];
							for (var i = 0; i < contacts.length; i++) {
								contacts_data.push({
									name: ionic.Platform.isIOS() ? (angular.isDefined(contacts[i].name) ? contacts[i].name.formatted : '') : (angular.isDefined(contacts[i].displayName) ? contacts[i].displayName : ''),
									phone: contacts[i].phoneNumbers != null ? (contacts[i].phoneNumbers[0].value).replace(new RegExp(/(-)/g), '') : '',
									ck: false
								})
							}
						}, 10);

					}, function (contactError) {
						contacts_data = [];
					}, options);
				} catch (e) {
					console.log(e.message);
				}
			},
			getContactsData: function () {
				return contacts_data;
			},
			clearContactsData: function () {
				contacts_data = [];
			}


		}
	})
	.factory('essLvApplySev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout) {
		var lv_app_data = {};
		var ess_empl_data = [];
		var imagesObj = {};
		imagesObj.data = '';

		return {
			loadData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEssLvApyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var essLvPolicy_data = [];
					data.essLvPolicy_index = '';
					document.getElementById('essLvPolicy').innerHTML = '请选择';
					data.essLvPolicy_data_key = '';
					for (var i = 0; i < data.lv_code_id.length; i++) {
						essLvPolicy_data[i] = data.lv_code_id[i];
						if (essLvPolicy_data[i].ck) {
							data.essLvPolicy_index = i;
							document.getElementById('essLvPolicy').innerHTML = essLvPolicy_data[i].value;
						}
					}
					data.essLvPolicy_data = essLvPolicy_data;
					if (data.error_message != '') {
						$ionicPopup.alert({
							title: '提示',
							template: '<div style="text-align: center;">' + data.error_message + '</div>',
							okText: '确定'
						}).then(function (res) {
							$ionicHistory.goBack();
						});
					} else {
						document.getElementById('approver_list_div').style.width = (data.approver_list.length + 1) * 100 + 20 + 'px';
						if (data.is_attachment) {
							document.getElementById('ess_leave_apply_upload_div').style.display = "block";
						}

						if (data.approver_list_flag) {
							if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
								data.approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < data.approver_list.length; i++) {
									$scope.select_user_id += data.approver_list[i].user_id;
									if (i <= data.approver_list.length - 2) {
										$scope.select_user_id += ',';
									}
								}
							}
						}

						if (data.notify_list_flag) {
							if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {
								data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < data.notify_list.length; i++) {
									$scope.select_notify_id += data.notify_list[i].user_id;
									if (i <= data.notify_list.length - 2) {
										$scope.select_notify_id += ',';
									}
								}
							}
						}
						document.getElementById('approver_list_div').style.width = (data.approver_list.length + 1) * 100 + 20 + 'px';
						document.getElementById('notify_list_div').style.width = (data.notify_list.length + 1) * 100 + 20 + 'px';

						$scope.approver_list = data.approver_list;
						angular.copy(data, lv_app_data);


					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_app_data = {};
				imagesObj = {};
				imagesObj.data = '';
			},
			getData: function () {
				return lv_app_data;
			},
			getImageData: function () {
				return imagesObj;
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				ess_empl_data.data_ready = false;
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);

					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}
					if (ess_empl_data.num_checked > 0) {
						ess_empl_data.show_footer_bar = true;
					} else {
						ess_empl_data.show_footer_bar = false;
					}
					try {
						if (ess_empl_data.num_checked != data.length) {
							document.getElementById('select_all_employee').style.display = "block";
							document.getElementById('deselect_all_employee').style.display = "none";
						} else {
							document.getElementById('select_all_employee').style.display = "none";
							document.getElementById('deselect_all_employee').style.display = "block";
						}
					} catch (e) {

					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
			changeEssLvPolicy: function ($scope, lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: lv_app_data.start_date,
						s_time: lv_app_data.start_time,
						e_date: lv_app_data.end_date,
						e_time: lv_app_data.end_time,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(lv_app_data, data);
					if (lv_app_data.is_attachment) {
						document.getElementById('ess_leave_apply_upload_div').style.display = "block";
						//$scope.is_require_upload = true;
					} else {
						document.getElementById('ess_leave_apply_upload_div').style.display = "none";
						//$scope.is_require_upload = false;
					}
					if (lv_app_data.approver_list_flag) {} else {
						$scope.approver_list = lv_app_data.approver_list
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveApply: function (approve_list, notify_list, scope_approver_list) {

				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						is_standard_wf: lv_app_data.is_standard_wf,
						approver_id_list: lv_app_data.approver_id_list,
						employee_no: lv_app_data.employee_no,
						lv_code_key: lv_app_data.lv_code_key,
						lv_code_id: lv_app_data.default_lv_code_id,
						task_id: lv_app_data.task_id,
						process_id: lv_app_data.process_id,
						start_date: lv_app_data.start_date,
						start_time: lv_app_data.start_time,
						end_date: lv_app_data.end_date,
						end_time: lv_app_data.end_time,
						duration: lv_app_data.duration,
						lv_unit: lv_app_data.lv_unit,
						apply_remark: lv_app_data.apply_remark,
						approve_remark: lv_app_data.approve_remark,
						notify_list: notify_list,
						actor: approve_list,
						attachment: '',
						old_lv_code_id: lv_app_data.old_lv_code_id,
						old_lv_code_key: lv_app_data.old_lv_code_key,
						old_duration: lv_app_data.old_duration,
						show_type: lv_app_data.show_type,
						biz_type_key: lv_app_data.biz_type_key,
						wf_app_table: lv_app_data.wf_app_table,
						action: 'submit',
						process_instance: lv_app_data.process_instance,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							if (lv_app_data.approver_list_flag && scope_approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + window.localStorage['_user_name'], JSON.stringify(scope_approver_list));
							}
							if (lv_app_data.notify_list_flag && lv_app_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + window.localStorage['_user_name'], JSON.stringify(lv_app_data.notify_list));
							}

							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_leave_apply');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			saveApplyWithPhoto: function (approve_list, notify_list, scope_approver_list) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				params.is_standard_wf = lv_app_data.is_standard_wf;
				params.approver_id_list = lv_app_data.approver_id_list;
				params.employee_no = lv_app_data.employee_no;
				params.lv_code_key = lv_app_data.lv_code_key;
				params.lv_code_id = lv_app_data.default_lv_code_id;
				params.task_id = lv_app_data.task_id;
				params.process_id = lv_app_data.process_id;
				params.start_date = lv_app_data.start_date;
				params.start_time = lv_app_data.start_time;
				params.end_date = lv_app_data.end_date;
				params.end_time = lv_app_data.end_time;
				params.duration = lv_app_data.duration;
				params.lv_unit = lv_app_data.lv_unit;
				params.apply_remark = lv_app_data.apply_remark;
				params.approve_remark = lv_app_data.approve_remark;
				params.notify_list = notify_list;
				params.actor = approve_list;
				params.attachment = '';
				params.old_lv_code_id = lv_app_data.old_lv_code_id;
				params.old_lv_code_key = lv_app_data.old_lv_code_key;
				params.old_duration = lv_app_data.old_duration;
				params.show_type = lv_app_data.show_type;
				params.biz_type_key = lv_app_data.biz_type_key;
				params.wf_app_table = lv_app_data.wf_app_table;
				params.action = 'submit';
				params.process_instance = lv_app_data.process_instance;
				params.is_require_upload = '1';
				params.time_zone = $rootScope.get_utc_time_zone();
				params.attachment_num = imagesObj.data.split(',').length;
				options.params = params;
				var ft = new FileTransfer();


				$timeout(function () {
					ft.uploadMore(
						imagesObj.data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
						function (data) {
							try {
								$rootScope.hideLoading();
								fufu_processing = false;
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									if (lv_app_data.approver_list_flag && scope_approver_list.length != 0) {
										setLocalStorageVar("ess_approver_list" + window.localStorage['_user_name'], JSON.stringify(scope_approver_list));
									}
									if (lv_app_data.notify_list_flag && lv_app_data.notify_list.length != 0) {
										setLocalStorageVar("ess_notify_list" + window.localStorage['_user_name'], JSON.stringify(lv_app_data.notify_list));
									}

									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_leave_apply');
										ft.clearCacheImage();
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}

							} catch (e) {
								fufu_processing = false;
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							fufu_processing = false;
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);
			}

		}
	})
	.factory('essLvApproveSev', function ($http, $rootScope, $ionicPopup) {
		var ess_leave_approve_data = [];
		return {
			loadEssApproveData: function (c_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssApproveData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_leave_approve_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_leave_approve_data = [];
			},
			getEssApproveData: function () {
				return ess_leave_approve_data;
			}
		}
	})
	.factory('essLvApDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var ess_app_detail_data = {};
		return {
			loadData: function (p_instance, show_type, my_result_status, task_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssAppDetail&' + _str + '&p_instance=' + p_instance + "&show_type=" + show_type + "&my_result_status=" + my_result_status + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_app_detail_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_app_detail_data = {};
			},
			getData: function () {
				return ess_app_detail_data;
			},
			applyReject: function (actor) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					timeout: _var_timeout,
					data: {
						employee_no: ess_app_detail_data.employee_no,
						operate_date: ess_app_detail_data.operate_date,
						lv_code_id: ess_app_detail_data.lv_code_id,
						lv_code_key: ess_app_detail_data.lv_code_key,
						task_id: ess_app_detail_data.task_id,
						start_date: ess_app_detail_data.start_date,
						start_time: ess_app_detail_data.start_time,
						end_date: ess_app_detail_data.end_date,
						end_time: ess_app_detail_data.end_time,
						duration: ess_app_detail_data.duration,
						lv_unit: ess_app_detail_data.lv_unit,
						approve_remark: ess_app_detail_data.approve_remark,
						apply_remark: ess_app_detail_data.apply_remark,
						notify_list: '',
						actor: actor,
						show_type: ess_app_detail_data.show_type,
						biz_type_key: ess_app_detail_data.biz_type_key,
						wf_app_table: ess_app_detail_data.wf_app_table,
						action: 'Reject',
						process_instance: ess_app_detail_data.process_instance,
						process_id: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (actor) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						employee_no: ess_app_detail_data.employee_no,
						operate_date: ess_app_detail_data.operate_date,
						lv_code_id: ess_app_detail_data.lv_code_id,
						lv_code_key: ess_app_detail_data.lv_code_key,
						task_id: ess_app_detail_data.task_id,
						start_date: ess_app_detail_data.start_date,
						start_time: ess_app_detail_data.start_time,
						notify_list: '',
						end_date: ess_app_detail_data.end_date,
						end_time: ess_app_detail_data.end_time,
						duration: ess_app_detail_data.duration,
						lv_unit: ess_app_detail_data.lv_unit,
						approve_remark: ess_app_detail_data.approve_remark,
						apply_remark: ess_app_detail_data.apply_remark,
						actor: actor,
						show_type: ess_app_detail_data.show_type,
						biz_type_key: ess_app_detail_data.biz_type_key,
						wf_app_table: ess_app_detail_data.wf_app_table,
						action: 'Approve',
						process_instance: ess_app_detail_data.process_instance,
						process_id: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})
	.factory('essMyApplySev', function ($http, $rootScope, $ionicPopup) {
		var ess_my_apply_data = [];
		return {
			loadData: function (c_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_apply_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_apply_data = [];
			},
			getData: function () {
				return ess_my_apply_data;
			}
		}
	})
	.factory('essMyApplyDSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_data = [];
		var ess_my_applyD_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, process_result) {
				//console.log(type)
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_other_data);
					ess_my_applyD_other_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			getOtherData: function () {
				return ess_my_applyD_other_data;
			},
			clearData: function () {
				ess_my_applyD_data = [];
				ess_my_applyD_other_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyApplyDSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApplyDSearchDiv").style.display = 'none';
					document.getElementById("essMyApplyDBack").style.display = 'block';
					return false;
				}
			},
			clearFieldworkStatusBar: function () {
				if (document.getElementById("essMyApplyDFSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApplyDFSearchDiv").style.display = 'none';
					document.getElementById("essMyApplyDFBack").style.display = 'block';
					return false;
				}
			},
			clearFieldworkOutStatusBar: function () {
				if (document.getElementById("essMyApplyDOSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApplyDOSearchDiv").style.display = 'none';
					document.getElementById("essMyApplyDOBack").style.display = 'block';
					return false;
				}
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(ess_my_applyD_data, data);
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			submitAction: function (action) {
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				_d = ess_my_applyD_data.notify_list;
				for (var i = 0; i < _d.length; i++) {
					notify_list = notify_list + _d[i].user_id + ',';
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						lv_code_id: ess_my_applyD_data.default_lv_code_id,
						lv_code_key: ess_my_applyD_data.lv_code_key,
						task_id: ess_my_applyD_data.task_id,
						start_date: $('#_ess_my_apply_d1').val(),
						start_time: $('#_ess_my_apply_t1').val(),
						notify_list: notify_list,
						end_date: $('#_ess_my_apply_d2').val(),
						end_time: $('#_ess_my_apply_t2').val(),
						duration: ess_my_applyD_data.duration,
						lv_unit: ess_my_applyD_data.lv_unit,
						apply_remark: ess_my_applyD_data.apply_remark,
						actor: actor,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('essMyApplyDetailsContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApplyDSev) {
		var ess_my_applyD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContent&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					document.getElementById('_ess_my_apply_d1').innerHTML = ess_my_applyD_data.start_date;
					document.getElementById('_ess_my_apply_d2').innerHTML = ess_my_applyD_data.end_date;
					document.getElementById('_ess_my_apply_t1').innerHTML = ess_my_applyD_data.start_time;
					document.getElementById('_ess_my_apply_t2').innerHTML = ess_my_applyD_data.end_time;
					ess_my_applyD_data.notify_text = [];
					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_applyD_data.notify_text;
					if (ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '更多';
					} else if (ess_my_applyD_data.modify && !ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '修改';
					} else if (!ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '撤销';
					} else {
						ess_my_applyD_data.action_text = '';
					}
					if (ess_my_applyD_data.attachment != '') {
						ess_my_applyD_data.attachment_array = ess_my_applyD_data.attachment.split(',');
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadNoprocessData: function (p_inst, show_type, task_id, app_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContentNoprocess&' + _str + '&app_id=' + app_id + '&show_type=' + show_type, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					document.getElementById('_ess_my_apply_d1').innerHTML = ess_my_applyD_data.start_date;
					document.getElementById('_ess_my_apply_d2').innerHTML = ess_my_applyD_data.end_date;
					document.getElementById('_ess_my_apply_t1').innerHTML = ess_my_applyD_data.start_time;
					document.getElementById('_ess_my_apply_t2').innerHTML = ess_my_applyD_data.end_time;
					//ess_my_applyD_data.notify_text=[];
					//for(var i=0;i<ess_my_applyD_data.notify_list.length;i++){
					//  ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					//}
					//document.getElementById('notify_text').innerText=ess_my_applyD_data.notify_text;
					if (ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '更多';
					} else if (ess_my_applyD_data.modify && !ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '修改';
					} else if (!ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '撤销';
					} else {
						ess_my_applyD_data.action_text = '';
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				ess_my_applyD_data = {};
			},
			getData: function () {
				return ess_my_applyD_data;
			},

			submitAction: function (action, my_app_result) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				_d = ess_my_applyD_data.notify_list;
				for (var i = 0; i < _d.length; i++) {
					notify_list = notify_list + _d[i].user_id + ',';
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						approver_id_list: ess_my_applyD_data.approver_id_list,
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						lv_code_key: ess_my_applyD_data.lv_code_key,
						lv_code_id: ess_my_applyD_data.default_lv_code_id,
						task_id: ess_my_applyD_data.task_id,
						//process_id: ess_my_applyD_data.process_id,
						start_date: ess_my_applyD_data.start_date,
						start_time: ess_my_applyD_data.start_time,
						end_date: ess_my_applyD_data.end_date,
						end_time: ess_my_applyD_data.end_time,
						duration: ess_my_applyD_data.duration,
						lv_unit: ess_my_applyD_data.lv_unit,
						apply_remark: '',
						approve_remark: '',
						notify_list: notify_list,
						actor: actor,
						attachment: '',
						old_lv_code_id: ess_my_applyD_data.old_lv_code_id,
						old_lv_code_key: ess_my_applyD_data.old_lv_code_key,
						old_duration: ess_my_applyD_data.old_duration,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								if (action == 'Cancel') {
									fufuMobclickAgent('click_leave_cancel');
								}
								essMyApplyDSev.loadData('leave', my_app_result);
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('essMyApplyDetailsContentFieldworkSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApplyDSev) {
		var ess_my_applyD_Fieldwork_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContentFieldwork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_Fieldwork_data);


					//if (ess_my_applyD_Fieldwork_data.approver_list.length > 0){
					//  $scope.select_user_id = ess_my_applyD_Fieldwork_data.approver_list[ess_my_applyD_Fieldwork_data.approver_list.length-1].user_id;
					//  ess_my_applyD_Fieldwork_data.approver_list.splice(0, ess_my_applyD_Fieldwork_data.approver_list.length-1);
					//  ess_my_applyD_Fieldwork_data.approver_list[0].flag = 1;
					//}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadNoprocessData: function (show_type, rec_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadNoprocessMyApplyDetailContentFieldwork&' + _str + '&show_type=' + show_type + '&rec_id=' + rec_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_Fieldwork_data);


					//if (ess_my_applyD_Fieldwork_data.approver_list.length > 0){
					//  $scope.select_user_id = ess_my_applyD_Fieldwork_data.approver_list[ess_my_applyD_Fieldwork_data.approver_list.length-1].user_id;
					//  ess_my_applyD_Fieldwork_data.approver_list.splice(0, ess_my_applyD_Fieldwork_data.approver_list.length-1);
					//  ess_my_applyD_Fieldwork_data.approver_list[0].flag = 1;
					//}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				ess_my_applyD_Fieldwork_data = {};
			},
			getData: function () {
				return ess_my_applyD_Fieldwork_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(ess_my_applyD_data, data);
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			submitAction: function (action, my_app_result, is_process, obj_id, biz_type_key) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_Fieldwork_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				if (typeof (ess_my_applyD_Fieldwork_data.notify_list) != 'undefined') {
					_d = ess_my_applyD_Fieldwork_data.notify_list;
					for (var i = 0; i < _d.length; i++) {
						notify_list = notify_list + _d[i].user_id + ',';
					}
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					data: {
						biz_type_key: biz_type_key,
						obj_id: obj_id,
						is_process: is_process,
						employee_no: ess_my_applyD_Fieldwork_data.employee_no,
						operate_date: ess_my_applyD_Fieldwork_data.operate_date,
						location: ess_my_applyD_Fieldwork_data.location,
						longitude: ess_my_applyD_Fieldwork_data.longitude,
						latitude: ess_my_applyD_Fieldwork_data.latitude,
						photo: ess_my_applyD_Fieldwork_data.photo,
						reason: ess_my_applyD_Fieldwork_data.reason,
						//apply_remark:'',
						//is_fieldwork:"1",
						i_wf: ess_my_applyD_Fieldwork_data.i_wf,
						i_l: ess_my_applyD_Fieldwork_data.i_l,
						i_p: ess_my_applyD_Fieldwork_data.i_p,
						customer: ess_my_applyD_Fieldwork_data.customer,
						location_detail: ess_my_applyD_Fieldwork_data.location_detail,
						actor: actor,
						show_type: ess_my_applyD_Fieldwork_data.show_type,
						wf_app_table: ess_my_applyD_Fieldwork_data.wf_app_table,
						is_require_upload: '0',
						o_photo: ess_my_applyD_Fieldwork_data.o_photo,
						action: action,
						process_instance: ess_my_applyD_Fieldwork_data.process_instance,
						task_id: ess_my_applyD_Fieldwork_data.task_id,
						notify_list: notify_list,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								if (action == 'Cancel') {
									fufuMobclickAgent('click_fieldwork_cancel');
								}
								essMyApplyDSev.loadData("fieldwork", my_app_result);
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})



	.factory('atSignInOutDoorModifySev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_Fieldwork_data = {};
		var ess_empl_data = [];
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContentFieldwork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_Fieldwork_data);
					document.getElementById('current_latitude_hidden').value = ess_my_applyD_Fieldwork_data.latitude;
					document.getElementById('current_longitude_hidden').value = ess_my_applyD_Fieldwork_data.longitude;
					if (ess_my_applyD_Fieldwork_data.approver_list.length > 0) {
						$scope.select_user_id = ess_my_applyD_Fieldwork_data.approver_list[ess_my_applyD_Fieldwork_data.approver_list.length - 1].user_id;
						ess_my_applyD_Fieldwork_data.approver_list.splice(0, ess_my_applyD_Fieldwork_data.approver_list.length - 1);
						ess_my_applyD_Fieldwork_data.approver_list[0].flag = 1;
					}
					if (ess_my_applyD_Fieldwork_data.reason == '拜访客户') {
						document.getElementById("sign_in_outdoor_customer_name_div").style.display = "block";
					} else {
						document.getElementById("sign_in_outdoor_customer_name_div").style.display = "none";
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_applyD_Fieldwork_data = {};
			},
			getData: function () {
				return ess_my_applyD_Fieldwork_data;
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(ess_my_applyD_data, data);
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			signInOutDoorSaveWithUpload: function ($scope, action, o_photo, latitude, longitude, select_user_id, process_instance, task_id) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.fileKey = 'at_sign_in_upload';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}

				params.location = document.getElementById("address_now").innerHTML;
				params.longitude = longitude;
				params.latitude = latitude;
				params.photo = document.getElementById("Sign_photos").src;
				params.reason = document.getElementById("sign_in_reason").innerHTML;
				params.apply_remark = document.getElementById("new_remark").value;
				params.is_fieldwork = "1";
				params.i_wf = $scope.atSignInOutDoorData.i_wf;
				params.i_l = $scope.atSignInOutDoorData.i_l;
				params.i_p = $scope.atSignInOutDoorData.i_p;
				params.customer = document.getElementById("sign_in_outdoor_customer_name").value;
				params.location_detail = document.getElementById("message_city").value;
				params.actor = select_user_id;
				params.show_type = $scope.atSignInOutDoorData.show_type;
				params.biz_type_key = $scope.atSignInOutDoorData.biz_type_key;
				params.wf_app_table = $scope.atSignInOutDoorData.wf_app_table;
				params.employee_no = $scope.atSignInOutDoorData.employee_no;
				params.is_require_upload = '1';
				params.process_instance = process_instance;
				params.task_id = task_id;
				params.o_photo = o_photo;
				params.action = action;
				params.time_zone = $rootScope.get_utc_time_zone();
				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();
				ft.upload(
					document.getElementById('Sign_photos').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					function (data) {
						try {
							$rootScope.hideLoading();
							fufu_processing = false;
							var response = $.parseJSON(data.response);
							if (response.flag == '0') {
								window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
									$ionicHistory.goBack();
								});
							} else {
								window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
							}

						} catch (e) {
							fufu_processing = false;
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					},
					function (error) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);

			},

			signInOutDoorSave: function ($scope, action, o_photo, latitude, longitude, select_user_id, process_instance, task_id) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					timeout: _var_timeout,
					data: {
						employee_no: ess_my_applyD_Fieldwork_data.employee_no,
						location: document.getElementById("address_now").innerHTML,
						longitude: longitude,
						latitude: latitude,
						photo: document.getElementById("Sign_photos").src,
						reason: document.getElementById("sign_in_reason").innerHTML,
						apply_remark: document.getElementById("new_remark").value,
						is_fieldwork: "1",
						i_wf: $scope.atSignInOutDoorData.i_wf,
						i_l: $scope.atSignInOutDoorData.i_l,
						i_p: $scope.atSignInOutDoorData.i_p,
						customer: document.getElementById("sign_in_outdoor_customer_name").value,
						location_detail: document.getElementById("message_city").value,
						actor: select_user_id,
						show_type: $scope.atSignInOutDoorData.show_type,
						biz_type_key: $scope.atSignInOutDoorData.biz_type_key,
						wf_app_table: $scope.atSignInOutDoorData.wf_app_table,
						is_require_upload: '0',
						o_photo: o_photo,
						action: action,
						process_instance: process_instance,
						task_id: task_id,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack(-2);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}
		}
	})
	.factory('payrollHomeSev', function ($http, $rootScope, $ionicPopup) {
		var payroll_home_data = {};
		return {
			loadData: function (curr_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPayrollHome&' + _str + '&curr_date=' + curr_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, payroll_home_data);
					if (payroll_home_data.data == '') {
						$('#chart_container .highcharts-container').remove();
					} else {
						$('#chart_container').highcharts({
							title: {
								text: '数据统计(单位:元)',
								align: 'left',
								style: {
									"color": "#333333",
									"fontSize": "16px"
								}
							},
							plotOptions: {
								pie: {
									allowPointSelect: true,
									dataLabels: {
										enabled: true,
										format: '{point.name} <br/> {point.y}'
									},
									showInLegend: false
								}
							},
							colors: ['#f15c80', '#e4d354', '#8085e8', '#8d4653', '#91e8e1', '#7cb5ec', '#434348', '#90ed7d', '#f7a35c', '#8085e9'],
							series: [{
								type: 'pie',
								name: '￥',
								data: payroll_home_data.data
							}]
						});
					}
					$("#_payroll_empl_date").val(payroll_home_data.date);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return payroll_home_data;
			},
			clearData: function () {
				payroll_home_data = {};
			}
		}
	})
	.factory('atHomeSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout) {
		var at_home_data = [];
		var at_home_result_data = [];
		var at_cache_calendar_data = [];
		return {
			loadData: function (curr_date, $scope, mode) {

				var _str = '';
				if (at_cache_calendar_data.length == 0 && (mode != 'initialize_minimize')) {

					$scope.paging_in_progress = false;
					return;
				}
				if (mode == 'maximize' || mode == 'minimize') {

					angular.copy(at_cache_calendar_data, at_home_data);
					for (var j = 0; j < 6; j++) {
						for (var k = 0; k < 7; k++) {
							document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).innerHTML = '&nbsp';
						}
					}


					var i = 0;
					for (var j = 0; j < 6; j++) {
						for (var k = 0; k < 7; k++, i++) {
							document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).innerHTML = at_cache_calendar_data[i].day_mesg;
							if (at_cache_calendar_data[i].is_abnormal == '1') {
								//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
								document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#ff3b30';
							} else {
								//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
								document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#333';
							}
							if (at_cache_calendar_data[i].process_type == '0') {
								document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
								document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
								//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'none';
							} else if (at_cache_calendar_data[i].process_type == '1') {
								document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
								document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
								//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
							} else {
								document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
								document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
								//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
							}
						}
					}

					if (mode == 'maximize') {
						$scope.fill_maximize_mode_calendar('initialize');

						for (var i = 0, j = 0; j < 6; j++) {
							for (var k = 0; k < 7; k++, i++) {
								if (at_cache_calendar_data[i].day_mesg == '休' || at_cache_calendar_data[i].day_mesg == '休假' || at_cache_calendar_data[i].day_mesg == '出差' || at_cache_calendar_data[i].day_mesg == '外出') {
									if (at_cache_calendar_data[i].date != curr_date) {
										document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
									}
								}

							}
						}
					} else if (mode == 'minimize') {

						$scope.fill_minimize_mode_calendar('initialize');
						for (var i = 0; i < 42; i++) {
							if (document.getElementById('at_calendar_2_1_1').getAttribute('date') == at_cache_calendar_data[i].date) {
								document.getElementById('at_calendar_text_2_1_1').innerHTML = at_cache_calendar_data[i].day_mesg;
								document.getElementById('at_calendar_text_2_1_2').innerHTML = at_cache_calendar_data[i + 1].day_mesg;
								document.getElementById('at_calendar_text_2_1_3').innerHTML = at_cache_calendar_data[i + 2].day_mesg;
								document.getElementById('at_calendar_text_2_1_4').innerHTML = at_cache_calendar_data[i + 3].day_mesg;
								document.getElementById('at_calendar_text_2_1_5').innerHTML = at_cache_calendar_data[i + 4].day_mesg;
								document.getElementById('at_calendar_text_2_1_6').innerHTML = at_cache_calendar_data[i + 5].day_mesg;
								document.getElementById('at_calendar_text_2_1_7').innerHTML = at_cache_calendar_data[i + 6].day_mesg;

								for (var v = 0; v < 7; v++) {

									if (document.getElementById('at_calendar_2_1_' + (v + 1)).parentNode.style.backgroundColor != "rgb(255, 59, 48)") {
										if (at_cache_calendar_data[v + i].day_mesg == '休' || at_cache_calendar_data[v + i].day_mesg == '休假' || at_cache_calendar_data[v + i].day_mesg == '出差' || at_cache_calendar_data[v + i].day_mesg == '外出') {
											document.getElementById('at_calendar_text_2_1_' + (v + 1)).style.color = '#f4a44e';
										}

										if (at_cache_calendar_data[v + i].is_abnormal == '1') {
											//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'block';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#ff3b30';
										} else {
											//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#333';
										}
										if (at_cache_calendar_data[v + i].process_type == '0') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
										} else if (at_cache_calendar_data[v + i].process_type == '1') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
										} else {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
										}
									} else {

										document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
										if (at_cache_calendar_data[v + i].process_type == '0') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
										} else if (at_cache_calendar_data[v + i].process_type == '1') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
										} else {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
										}
										//document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
									}
								}
								break;
							}
						}


					}
					setTimeout(function () {
						$scope.paging_in_progress = false;
					}, 700);

					return;

				} else if (mode == 'date_select_minimize' || mode == 'date_select_maximize') {

					if (at_cache_calendar_data.length == 0) {
						return;
					}


					if (mode == 'date_select_minimize') {

						$scope.fill_minimize_mode_calendar('initialize');

						for (var i = 0; i < 42; i++) {
							if (document.getElementById('at_calendar_2_1_1').getAttribute('date') == at_cache_calendar_data[i].date) {
								document.getElementById('at_calendar_text_2_1_1').innerHTML = at_cache_calendar_data[i].day_mesg;
								document.getElementById('at_calendar_text_2_1_2').innerHTML = at_cache_calendar_data[i + 1].day_mesg;
								document.getElementById('at_calendar_text_2_1_3').innerHTML = at_cache_calendar_data[i + 2].day_mesg;
								document.getElementById('at_calendar_text_2_1_4').innerHTML = at_cache_calendar_data[i + 3].day_mesg;
								document.getElementById('at_calendar_text_2_1_5').innerHTML = at_cache_calendar_data[i + 4].day_mesg;
								document.getElementById('at_calendar_text_2_1_6').innerHTML = at_cache_calendar_data[i + 5].day_mesg;
								document.getElementById('at_calendar_text_2_1_7').innerHTML = at_cache_calendar_data[i + 6].day_mesg;

								for (var v = 0; v < 7; v++) {
									if (document.getElementById('at_calendar_2_1_' + (v + 1)).parentNode.style.background != "rgb(255, 59, 48)") {


										if (at_cache_calendar_data[v + i].day_mesg == '休' || at_cache_calendar_data[v + i].day_mesg == '休假' || at_cache_calendar_data[v + i].day_mesg == '出差' || at_cache_calendar_data[v + i].day_mesg == '外出') {
											document.getElementById('at_calendar_text_2_1_' + (v + 1)).style.color = '#f4a44e';

										}

										if (at_cache_calendar_data[v + i].is_abnormal == '1') {
											//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'block';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#ff3b30';
										} else {
											//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#333';
										}
										if (at_cache_calendar_data[v + i].process_type == '0') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
										} else if (at_cache_calendar_data[v + i].process_type == '1') {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url("' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + '")';

										} else {
											document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
											document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
											//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url("' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + '")';

										}
									} else {
										document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
									}
								}
								break;
							}
						}
						if (at_cache_calendar_data[6].date.split('-')[1] == curr_date.split('-')[1]) {
							setTimeout(function () {
								$scope.paging_in_progress = false;
							}, 700);
							return;
						}
					}





					if (mode == 'date_select_maximize') {
						angular.copy(at_home_data, at_cache_calendar_data);
						var i = 0;
						for (var j = 0; j < 6; j++) {
							for (var k = 0; k < 7; k++, i++) {
								document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).innerHTML = at_cache_calendar_data[i].day_mesg;

								if (at_cache_calendar_data[i].is_abnormal == '1') {
									//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#ff3b30';
								} else {
									//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#333';
								}
								if (at_cache_calendar_data[i].process_type == '0') {
									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'none';
								} else if (at_cache_calendar_data[i].process_type == '1') {
									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
								} else {

									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
								}
								if (at_cache_calendar_data[i].day_mesg == '休' || at_cache_calendar_data[i].day_mesg == '休假' || at_cache_calendar_data[i].day_mesg == '出差' || at_cache_calendar_data[i].day_mesg == '外出') {
									document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
								}

							}
						}
						$scope.fill_maximize_mode_calendar('initialize');
						for (var i = 0, j = 0; j < 6; j++) {
							for (var k = 0; k < 7; k++, i++) {
								if (at_cache_calendar_data[i].day_mesg == '休' || at_cache_calendar_data[i].day_mesg == '休假' || at_cache_calendar_data[i].day_mesg == '出差' || at_cache_calendar_data[i].day_mesg == '外出') {
									document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
								}

							}
						}
						$scope.calendar_week_minimize();

						setTimeout(function () {
							$scope.paging_in_progress = false;
						}, 700);

						return;

					}





				}


				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtHomeData&mode=' + mode + '&' + _str + '&curr_date=' + curr_date + '&flag=0', {
					timeout: _var_timeout
				}).
				success(function (data, status) {

					$rootScope.hideLoading();
					angular.copy(data.calendar_data, at_home_data);

					/*data[25].process_type='1';
					data[22].process_type='2';
					at_home_data[25].process_type='1';
					at_home_data[22].process_type='2';
					at_home_data[18].is_abnormal='1';
					at_home_data[20].is_abnormal='1';
					data[18].is_abnormal='1';
					data[20].is_abnormal='1
					*/
					var ran_num;
					if (typeof (data.calendar_data) != 'undefined' && data.calendar_data.length > 1) {

						if (mode == 'initialize_minimize') {

							angular.copy(data.calendar_result_data, at_home_result_data);

							var week_arr = ['日', '一', '二', '三', '四', '五', '六'];
							at_home_result_data.week_str = '星期' + week_arr[at_home_result_data.date_dw - 1]



							for (var i = 0; i < at_home_result_data.result_data.length; i++) {
								if (at_home_result_data.result_data[i].name == '应勤工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/regulations_times_icon.png';
								} else if (at_home_result_data.result_data[i].name == '实际工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/actual_times_icon.png';
								} else if (at_home_result_data.result_data[i].name == '迟到分钟') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/late_icon.png';
								} else if (at_home_result_data.result_data[i].name == '早退分钟') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/Leave_early_times_icon.png';
								} else if (at_home_result_data.result_data[i].name == '加班工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/overtimes_icon.png';
								} else if (at_home_result_data.result_data[i].name == '旷工工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/absenteeism_icon.png';
								} else if (at_home_result_data.result_data[i].name == '休假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '迟到早退扣款') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report13.png';


								} else if (at_home_result_data.result_data[i].name == '缺卡次数') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report6.png';
								} else if (at_home_result_data.result_data[i].name == '平加工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
								} else if (at_home_result_data.result_data[i].name == '周加工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
								} else if (at_home_result_data.result_data[i].name == '法加工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
								} else if (at_home_result_data.result_data[i].name == '年假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '病假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '事假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '其他无薪假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '其他有薪假工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
								} else if (at_home_result_data.result_data[i].name == '外出工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report11.png';
								} else if (at_home_result_data.result_data[i].name == '出差工时') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report12.png';
								} else if (at_home_result_data.result_data[i].name == '夜班津贴') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report10.png';
								} else if (at_home_result_data.result_data[i].name == '补签次数') {
									at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report9.png';
								}
							}


							at_home_result_data.is_future = false;
							var dt = new Date();
							if (parseInt(curr_date.split('-')[0]) - parseInt(dt.getFullYear()) > 0) {

								at_home_result_data.is_future = true;
							} else if (parseInt(curr_date.split('-')[0]) - parseInt(dt.getFullYear()) < 0) {
								at_home_result_data.is_future = false;
							} else {
								if ((parseInt(curr_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) > 0) {
									at_home_result_data.is_future = true;
								} else if ((parseInt(curr_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) < 0) {
									at_home_result_data.is_future = false;
								} else {
									if (parseInt(curr_date.split('-')[2]) - parseInt(dt.getDate()) > 0) {
										at_home_result_data.is_future = true;
									} else if (parseInt(curr_date.split('-')[2]) - parseInt(dt.getDate()) < 0) {
										at_home_result_data.is_future = false;
									}
								}
							}



						}

						if (mode == 'date_select_minimize') {
							angular.copy(at_home_data, at_cache_calendar_data);
							setTimeout(function () {
								$scope.paging_in_progress = false;
							}, 700);
							return;
						}

						if (mode == 'initialize_minimize' || mode == 'date_select_maximize' || mode == 'date_select_minimize') {

							angular.copy(at_home_data, at_cache_calendar_data);
						}
						for (var j = 0; j < 6; j++) {
							for (var k = 0; k < 7; k++) {
								document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).innerHTML = '&nbsp';
							}
						}


						var i = 0;
						for (var j = 0; j < 6; j++) {
							for (var k = 0; k < 7; k++, i++) {
								document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).innerHTML = at_home_data[i].day_mesg;

								if (at_home_data[i].day_mesg == '休' || at_home_data[i].day_mesg == '休假' || at_home_data[i].day_mesg == '出差' || at_home_data[i].day_mesg == '外出') {
									document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';

								}
								if (at_home_data[i].is_abnormal == '1') {
									//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#ff3b30';
								} else {
									//document.getElementById('at_calendar_dot_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#333';
								}
								if (at_home_data[i].process_type == '0') {
									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'none';
								} else if (at_home_data[i].process_type == '1') {
									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
								} else {
									document.getElementById('at_calendar_img_icon_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'none';
									document.getElementById('at_calendar_img_icon2_2' + '_' + (j + 1) + '_' + (k + 1)).style.display = 'block';
									//document.getElementById('at_calendar_2' + '_' + (j + 1) + '_' + (k + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
								}

							}
						}

						if (mode == 'initialize_minimize') {
							$scope.fill_minimize_mode_calendar('initialize');
							for (var i = 0; i < 42; i++) {
								if (document.getElementById('at_calendar_2_1_1').getAttribute('date') == at_home_data[i].date) {
									document.getElementById('at_calendar_text_2_1_1').innerHTML = at_home_data[i].day_mesg;
									document.getElementById('at_calendar_text_2_1_2').innerHTML = at_home_data[i + 1].day_mesg;
									document.getElementById('at_calendar_text_2_1_3').innerHTML = at_home_data[i + 2].day_mesg;
									document.getElementById('at_calendar_text_2_1_4').innerHTML = at_home_data[i + 3].day_mesg;
									document.getElementById('at_calendar_text_2_1_5').innerHTML = at_home_data[i + 4].day_mesg;
									document.getElementById('at_calendar_text_2_1_6').innerHTML = at_home_data[i + 5].day_mesg;
									document.getElementById('at_calendar_text_2_1_7').innerHTML = at_home_data[i + 6].day_mesg;

									for (var v = 0; v < 7; v++) {
										if (document.getElementById('at_calendar_2_1_' + (v + 1)).parentNode.style.background != "rgb(255, 59, 48)") {
											if (at_cache_calendar_data[v + i].day_mesg == '休' || at_cache_calendar_data[v + i].day_mesg == '休假' || at_cache_calendar_data[v + i].day_mesg == '出差' || at_cache_calendar_data[v + i].day_mesg == '外出') {
												document.getElementById('at_calendar_text_2_1_' + (v + 1)).style.color = '#f4a44e';

											}
											if (at_home_data[v + i].is_abnormal == '1') {
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'block';

												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#ff3b30';

											} else {
												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#333';
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'none';
											}
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										} else {
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										}
									}



									break;
								}
							}



						} else if (mode == 'maximize_previous_page') {

							$scope.fill_maximize_mode_calendar('previous');
							for (var i = 0, j = 0; j < 6; j++) {
								for (var k = 0; k < 7; k++, i++) {
									if (at_home_data[i].day_mesg == '休' || at_home_data[i].day_mesg == '休假' || at_home_data[i].day_mesg == '出差' || at_home_data[i].day_mesg == '外出') {
										document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
									}

								}
							}
						} else if (mode == 'maximize_next_page') {
							$scope.fill_maximize_mode_calendar('next');
							for (var i = 0, j = 0; j < 6; j++) {
								for (var k = 0; k < 7; k++, i++) {
									if (at_home_data[i].day_mesg == '休' || at_home_data[i].day_mesg == '休假' || at_home_data[i].day_mesg == '出差' || at_home_data[i].day_mesg == '外出') {
										document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
									}

								}
							}
						} else if (mode == 'minimize_previous_page') {

							$scope.fill_minimize_mode_calendar('previous');
							for (var i = 0; i < 42; i++) {
								if (document.getElementById('at_calendar_2_1_1').getAttribute('date') == at_home_data[i].date) {
									document.getElementById('at_calendar_text_2_1_1').innerHTML = at_home_data[i].day_mesg;
									document.getElementById('at_calendar_text_2_1_2').innerHTML = at_home_data[i + 1].day_mesg;
									document.getElementById('at_calendar_text_2_1_3').innerHTML = at_home_data[i + 2].day_mesg;
									document.getElementById('at_calendar_text_2_1_4').innerHTML = at_home_data[i + 3].day_mesg;
									document.getElementById('at_calendar_text_2_1_5').innerHTML = at_home_data[i + 4].day_mesg;
									document.getElementById('at_calendar_text_2_1_6').innerHTML = at_home_data[i + 5].day_mesg;
									document.getElementById('at_calendar_text_2_1_7').innerHTML = at_home_data[i + 6].day_mesg;
									for (var v = 0; v < 7; v++) {
										if (document.getElementById('at_calendar_2_1_' + (v + 1)).parentNode.style.backgroundColor != "rgb(255, 59, 48)") {
											if (at_home_data[v + i].day_mesg == '休' || at_home_data[v + i].day_mesg == '休假' || at_home_data[v + i].day_mesg == '出差' || at_home_data[v + i].day_mesg == '外出') {
												document.getElementById('at_calendar_text_2_1_' + (v + 1)).style.color = '#f4a44e';
											}
											if (at_home_data[v + i].is_abnormal == '1') {
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#ff3b30';
											} else {
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#333';
											}
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										} else {
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										}
									}
									break;
								}
							}
						} else if (mode == 'minimize_next_page') {
							$scope.fill_minimize_mode_calendar('next');
							for (var i = 0; i < 42; i++) {
								if (document.getElementById('at_calendar_2_1_1').getAttribute('date') == at_home_data[i].date) {
									document.getElementById('at_calendar_text_2_1_1').innerHTML = at_home_data[i].day_mesg;
									document.getElementById('at_calendar_text_2_1_2').innerHTML = at_home_data[i + 1].day_mesg;
									document.getElementById('at_calendar_text_2_1_3').innerHTML = at_home_data[i + 2].day_mesg;
									document.getElementById('at_calendar_text_2_1_4').innerHTML = at_home_data[i + 3].day_mesg;
									document.getElementById('at_calendar_text_2_1_5').innerHTML = at_home_data[i + 4].day_mesg;
									document.getElementById('at_calendar_text_2_1_6').innerHTML = at_home_data[i + 5].day_mesg;
									document.getElementById('at_calendar_text_2_1_7').innerHTML = at_home_data[i + 6].day_mesg;
									for (var v = 0; v < 7; v++) {
										if (document.getElementById('at_calendar_2_1_' + (v + 1)).parentNode.style.backgroundColor != "rgb(255, 59, 48)") {
											if (at_home_data[v + i].day_mesg == '休' || at_home_data[v + i].day_mesg == '休假' || at_home_data[v + i].day_mesg == '出差' || at_home_data[v + i].day_mesg == '外出') {
												document.getElementById('at_calendar_text_2_1_' + (v + 1)).style.color = '#f4a44e';
											}
											if (at_home_data[v + i].is_abnormal == '1') {
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#ff3b30';
											} else {
												//document.getElementById('at_calendar_dot_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = '#333';
											}
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										} else {
											document.getElementById('at_calendar_2_1_' + (v + 1)).style.color = 'white';
											if (at_home_data[v + i].process_type == '0') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'none';
											} else if (at_home_data[v + i].process_type == '1') {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'block';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'none';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											} else {
												document.getElementById('at_calendar_img_icon_2_1_' + (v + 1)).style.display = 'none';
												document.getElementById('at_calendar_img_icon2_2_1_' + (v + 1)).style.display = 'block';
												//document.getElementById('at_calendar_2_1_' + (v + 1)).style.backgroundImage = 'url(' + local_resource + 'img/icon/home_at_wait_approv_bg.png' + ')';
											}
										}
									}
									break;
								}
							}
						} else if (mode == 'date_select_maximize') {
							$scope.fill_maximize_mode_calendar('initialize');
							for (var i = 0, j = 0; j < 6; j++) {
								for (var k = 0; k < 7; k++, i++) {
									if (at_home_data[i].day_mesg == '休' || at_home_data[i].day_mesg == '休假' || at_home_data[i].day_mesg == '出差' || at_home_data[i].day_mesg == '外出') {
										document.getElementById('at_calendar_text_2' + '_' + (j + 1) + '_' + (k + 1)).style.color = '#f4a44e';
									}

								}
							}
							$scope.calendar_week_minimize();
						} else if (mode == 'date_select_minimize') {
							$scope.fill_minimize_mode_calendar('initialize');
						}

						$scope.data_ready = true;
					} else {
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						$ionicHistory.goBack();
					}

					setTimeout(function () {
						$scope.paging_in_progress = false;
					}, 700);


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					setTimeout(function () {
						$scope.paging_in_progress = false;
					}, 700);
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			loadResultData: function (curr_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtHomeResultData&' + _str + '&curr_date=' + curr_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_home_result_data);
					var week_arr = ['日', '一', '二', '三', '四', '五', '六'];
					at_home_result_data.week_str = '星期' + week_arr[at_home_result_data.date_dw - 1]
					for (var i = 0; i < at_home_result_data.result_data.length; i++) {
						if (at_home_result_data.result_data[i].name == '应勤工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/regulations_times_icon.png';
						} else if (at_home_result_data.result_data[i].name == '实际工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/actual_times_icon.png';
						} else if (at_home_result_data.result_data[i].name == '迟到分钟') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/late_icon.png';
						} else if (at_home_result_data.result_data[i].name == '早退分钟') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/Leave_early_times_icon.png';
						} else if (at_home_result_data.result_data[i].name == '加班工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/overtimes_icon.png';
						} else if (at_home_result_data.result_data[i].name == '旷工工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/absenteeism_icon.png';
						} else if (at_home_result_data.result_data[i].name == '休假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '迟到早退扣款') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report13.png';


						} else if (at_home_result_data.result_data[i].name == '缺卡次数') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report6.png';
						} else if (at_home_result_data.result_data[i].name == '平加工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
						} else if (at_home_result_data.result_data[i].name == '周加工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
						} else if (at_home_result_data.result_data[i].name == '法加工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report8.png';
						} else if (at_home_result_data.result_data[i].name == '年假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '病假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '事假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '其他无薪假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '其他有薪假工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report7.png';
						} else if (at_home_result_data.result_data[i].name == '外出工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report11.png';
						} else if (at_home_result_data.result_data[i].name == '出差工时') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report12.png';
						} else if (at_home_result_data.result_data[i].name == '夜班津贴') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report10.png';
						} else if (at_home_result_data.result_data[i].name == '补签次数') {
							at_home_result_data.result_data[i].src = local_resource + 'img/icon/month_report9.png';
						}
					}

					at_home_result_data.is_future = false;
					var dt = new Date();
					if (parseInt(curr_date.split('-')[0]) - parseInt(dt.getFullYear()) > 0) {

						at_home_result_data.is_future = true;
					} else if (parseInt(curr_date.split('-')[0]) - parseInt(dt.getFullYear()) < 0) {
						at_home_result_data.is_future = false;
					} else {
						if ((parseInt(curr_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) > 0) {
							at_home_result_data.is_future = true;
						} else if ((parseInt(curr_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) < 0) {
							at_home_result_data.is_future = false;
						} else {
							if (parseInt(curr_date.split('-')[2]) - parseInt(dt.getDate()) > 0) {
								at_home_result_data.is_future = true;
							} else if (parseInt(curr_date.split('-')[2]) - parseInt(dt.getDate()) < 0) {
								at_home_result_data.is_future = false;
							}
						}
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return at_home_data;
			},
			getResultData: function () {
				return at_home_result_data;
			},
			clearData: function () {
				at_home_data = {};
				at_home_result_data = {};
			}
		}
	})
	.factory('modifyPwdSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $location) {
		return {
			modifyPwd: function (_old, _new, _confirm) {
				
				var re = /^(?=.*[0-9])(?=.*[a-zA-Z])(.{8,20})$/;
				if (_old == '' || _new == '' || _confirm == '') {
					window.fufuMessageBox("密码信息内容不能为空", fufu_message_box_duration, function () {});
					return;
				} else {
					if (!angular.equals(_new, _confirm)) {
						window.fufuMessageBox("新密码与确认密码不一致", fufu_message_box_duration, function () {});
						return;
					} else if (angular.equals(_old, _new) || angular.equals(_old, _confirm)) {
						window.fufuMessageBox("旧密码与新密码不能相同", fufu_message_box_duration, function () {});
						return;
					}
					else if(_new.length<8 || _new.length>20 || !re.test(_new)){
						window.fufuMessageBox("新密码长度8-20位，必须包含字母与数字!", fufu_message_box_duration, function () {});
						
						return;
					}

					$rootScope.showLoading();
					$.ajax({
						type: 'POST',
						timeout: _var_timeout,
						url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveModifyPwd',
						data: {
							old_pwd: _old,
							new_pwd: _new,
							_user_name: window.localStorage['_user_name'],
							_pass_word: window.localStorage['_pass_word'],
							_is_login: window.localStorage['_is_login'],
							_notification_token: window.localStorage['_notification_token'],
							_device_type: window.localStorage['_device_type']
						},
						success: function (data, status, headers, config) {
							$rootScope.hideLoading();
							var _data = $.parseJSON(data);
							if (_data.flag == '0') {
								window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
									fufuMobclickAgent('click_password_modify');
									$ionicHistory.clearCache();
									$ionicHistory.clearHistory();
									setLocalStorageVar('_pass_word', '');
									setLocalStorageVar('_is_login', '0');
									$location.path('/');
								});
							} else {
								window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
							}

						},
						error: function (data, status, headers, config) {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					});
				}
			}
		}
	})


	.factory('perDetailSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, perDataDetailSev) {
		var master_details_data = {};
		return {
			saveStaffDetailsWithUpload: function ($scope) {
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.fileKey = 'personnal_details_employee_photo';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}

				params.employee_no = $scope.staff_master_details.employee_no;

				params.employee_name = $("#employee_name").val();
				params.p_n_i = $("#p_n_i").val();
				params.o_n_i = $("#o_n_i").val();
				params.join_date = $scope.staff_master_details.join_date;
				params.p_c_d = $scope.staff_master_details.p_c_d;
				params.id_type = $scope.staff_master_details.id_type_data_key;
				params.id_number = $("#id_number").val();
				params.date_of_birth = document.getElementById("date_of_birth").innerHTML;
				params.gender = $scope.staff_master_details.gender_data_key;
				params.home_tel_no = $("#mobile_no").val();
				params.email = $("#email").val();
				params.address = $("#address").val();
				params.nationality = $scope.staff_master_details.nationality_data_key;
				params.p_o_b = $("#p_o_b").val();
				params.race = $scope.staff_master_details.race_data_key;
				params.education_level = $scope.staff_master_details.education_level_data_key;
				params.emergency_contact_name1 = $("#emergency_contact_name1").val();
				params.emergency_contact_no1 = $("#emergency_contact_no1").val();
				params.is_require_upload = '1';
				params.is_need_valid = '0';
				params.data_type = '1';
				params.file_name = $scope.staff_master_details.staff_photo_file_name;


				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();

				ft.upload(
					document.getElementById('personnal_details_employee_photo').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePerDataDetail',
					function (data) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data.response);
						if (typeof (_data.message) != 'undefined') {
							if (_data.flag == '0') {
								window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
									fufuMobclickAgent('click_personnal_save');
									perDataDetailSev.loadStaffMsDetails()
									$ionicHistory.goBack();
								});
							} else {
								window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
							}

						} else {
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}

					},
					function (error) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);
			},
			saveStaffDetails: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}


				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePerDataDetail&' + _str, {}, {
					params: {
						employee_no: $scope.staff_master_details.employee_no,
						employee_name: $("#employee_name").val(),
						p_n_i: $("#p_n_i").val(),
						o_n_i: $("#o_n_i").val(),
						join_date: $scope.staff_master_details.join_date,
						p_c_d: $scope.staff_master_details.p_c_d,
						id_type: $scope.staff_master_details.id_type_data_key,
						id_number: $("#id_number").val(),
						date_of_birth: document.getElementById("date_of_birth").innerHTML,
						gender: $scope.staff_master_details.gender_data_key,
						home_tel_no: $("#mobile_no").val(),
						email: $("#email").val(),
						address: $("#address").val(),
						nationality: $scope.staff_master_details.nationality_data_key,
						p_o_b: $("#p_o_b").val(),
						race: $scope.staff_master_details.race_data_key,
						education_level: $scope.staff_master_details.education_level_data_key,
						emergency_contact_name1: $("#emergency_contact_name1").val(),
						emergency_contact_no1: $("#emergency_contact_no1").val(),
						is_require_upload: '0',
						is_need_valid: '0',
						data_type: '1',
						file_name: $scope.staff_master_details.staff_photo_file_name

					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_personnal_save');
							perDataDetailSev.loadStaffMsDetails()
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});



			}

		}
	})



	.factory('findPwdSev', function ($http, $rootScope, $timeout, $ionicPopup, $location, $ionicHistory) {
		var find_pwd_data = {
			tel_no: '',
			valid_code: '',
			new_pwd: '',
			confirm_pwd: '',
			_flag: 1,
			_message: '',
			button_text: '获取验证码'
		}
		var reg = /^1[3|4|5|7|8]\d{9}$/;
		var re = /^(?=.*[0-9])(?=.*[a-zA-Z])(.{8,20})$/;
			
		//var myTime;
		return {
			getFindPwdData: function () {
				return find_pwd_data;
			},
			findPwdAction: function () {
				if (find_pwd_data.tel_no == '' || find_pwd_data.valid_code == '' || find_pwd_data.new_pwd == '' || find_pwd_data.confirm_pwd == '') {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '表单信息不允许为空';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else if (!angular.equals(find_pwd_data.new_pwd, find_pwd_data.confirm_pwd)) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '新密码与确认密码不一致';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else if (!reg.test(find_pwd_data.tel_no)) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '手机号码格式不正确!';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				}
				else if(find_pwd_data.confirm_pwd.length<8 || find_pwd_data.confirm_pwd.length>20 || !re.test(find_pwd_data.confirm_pwd)){
					
					find_pwd_data._flag = 0;
					find_pwd_data._message = '密码长度8-20位，必须包含字母与数字。';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
						
					
				}				
				else {
					$rootScope.showLoading();
					$.ajax({
						type: "GET",
						timeout: _var_timeout,
						url: _redis_url + '/UserServer/login?username=' + find_pwd_data.tel_no + '&password=&is_mobile=1&_is_login=0',
						dataType: "jsonp",
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && data.success) {
								$http.post(data.url + '?event=ionicAction.ionicAction.findPwdAction', {}, {
									params: {
										tel_no: find_pwd_data.tel_no,
										valid_code: find_pwd_data.valid_code,
										new_pwd: find_pwd_data.new_pwd,
										step: '2'
									},
									timeout: _var_timeout
								}).
								success(function (data, status, headers, config) {
									$rootScope.hideLoading();
									if (data.flag == '0') {
										window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
											fufuMobclickAgent('click_forget_password');
											$timeout(function () {
												find_pwd_data.tel_no = '';
												find_pwd_data.valid_code = '';
												find_pwd_data.new_pwd = '';
												find_pwd_data.confirm_pwd = '';
											}, 100);
											clearInterval(fufu_register_timeout);
											$("#send_vcode").removeAttr("disabled");
											$("#send_vcode").text('获取验证码');
											$('#_find_pwd_action').attr('disabled', 'disabled');
											$ionicHistory.goBack(-2);
										});
									} else {
										window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
									}

								}).
								error(function (data, status, headers, config) {
									$rootScope.hideLoading();
									window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
								});
							}
						},
						error: function () {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					});
				}
			},
			sendPwdVCode: function () {
				if (!reg.test(find_pwd_data.tel_no)) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '手机号码格式不正确!';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else {
					$("#send_vcode").attr("disabled", 'disabled');
					$.ajax({
						type: "GET",
						timeout: _var_timeout,
						url: _redis_url + '/UserServer/login?username=' + find_pwd_data.tel_no + '&password=&is_mobile=1&_is_login=0',
						dataType: "jsonp",
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
								$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
									$("#send_vcode").removeAttr("disabled");
									$("#send_vcode").text('获取验证码');
								});
								return;
							}
							if (angular.isDefined(data) && data.success) {
								$http.post(data.url + '?event=ionicAction.ionicAction.sendPwdVCode', {}, {
									params: {
										tel_no: find_pwd_data.tel_no
									},
									timeout: _var_timeout
								}).
								success(function (data, status, headers, config) {
									if (data.flag == 0) {
										$('#_find_pwd_action').removeAttr('disabled');
										var countdown = 120;
										fufu_register_timeout = setInterval(function () {
											countdown--;
											$("#send_vcode").text(countdown + ' S');
										}, 1000);
										setTimeout(function () {
											clearInterval(fufu_register_timeout);
											$("#send_vcode").removeAttr("disabled");
											$("#send_vcode").text('获取验证码');
											$('#_find_pwd_action').attr('disabled', 'disabled');
										}, 120000);
									} else {
										$("#send_vcode").removeAttr("disabled");
										$("#send_vcode").text('获取验证码');
										$ionicPopup.alert({
												title: '运行结果',
												template: '<div style="text-align: center;">' + data.message + '</div>',
												okText: '确定'
											})
											.then(function (res) {});
									}
								}).
								error(function (data, status, headers, config) {
									$("#send_vcode").removeAttr("disabled");
									$("#send_vcode").text('获取验证码');
									window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
								});
							} else {
								$("#send_vcode").removeAttr("disabled");
								$("#send_vcode").text('获取验证码');
								window.fufuMessageBox("网络超时或用户不存在", fufu_message_box_duration, function () {});
							}
						},
						error: function () {
							$("#send_vcode").removeAttr("disabled");
							$("#send_vcode").text('获取验证码');
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					})
				}
			}
		}
	})


	.factory('regetPwdSev', function ($http, $rootScope, $timeout, $ionicPopup, $location, $ionicHistory) {
		var find_pwd_data = {
			tel_no: '',
			valid_code: '',
			img_valid_code: '',
			new_pwd: '',
			confirm_pwd: '',
			_flag: 1,
			_message: '',
			button_text: '获取验证码'
		}
		var reg = /^1[3|4|5|7|8]\d{9}$/;
		//var myTime;
		return {
			getFindPwdData: function () {
				return find_pwd_data;
			},
			findPwdAction: function () {

				if (find_pwd_data.tel_no == '') {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '表单信息不允许为空';

					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);

				} else if (!reg.test(find_pwd_data.tel_no)) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '手机号码格式不正确!';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else {
					$rootScope.showLoading();

					$.ajax({
						type: "GET",
						timeout: _var_timeout,
						url: _redis_url + '/UserServer/login?username=' + find_pwd_data.tel_no + '&password=&is_mobile=1&_is_login=0',
						dataType: "jsonp",
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && data.success) {
								$http.post(data.url + '?event=ionicAction.ionicAction.findPwdAction', {}, {
									params: {
										tel_no: find_pwd_data.tel_no,
										valid_code: find_pwd_data.valid_code,
										new_pwd: find_pwd_data.new_pwd,
										step: '1'
									},
									timeout: _var_timeout
								}).
								success(function (data, status, headers, config) {
									$rootScope.hideLoading();
									if (data.flag == '0') {
										//window.fufuSuccessBox(data.message,fufu_success_message_box_duration, function(){
										//fufuMobclickAgent('click_forget_password');
										$timeout(function () {
											find_pwd_data.tel_no = '';
											find_pwd_data.valid_code = '';
											find_pwd_data.new_pwd = '';
											find_pwd_data.confirm_pwd = '';
										}, 100);
										clearInterval(fufu_register_timeout);
										$("#send_vcode").removeAttr("disabled");
										$("#send_vcode").text('获取验证码');
										$('#_find_pwd_action').attr('disabled', 'disabled');
										$location.path('forget_pwd/' + find_pwd_data.tel_no + '/' + find_pwd_data.valid_code);
										//});
									} else {
										window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
									}

								}).
								error(function (data, status, headers, config) {
									$rootScope.hideLoading();
									window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
								});
							}
						},
						error: function () {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					});
				}
			},
			sendPwdVCode: function ($scope) {

				if (!reg.test(find_pwd_data.tel_no)) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '手机号码格式不正确!';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else if (angular.isDefined(find_pwd_data.img_valid_code) && find_pwd_data.img_valid_code.length != 5) {
					find_pwd_data._flag = 0;
					find_pwd_data._message = '图形验证码不正确!';
					$timeout(function () {
						find_pwd_data._flag = 1;
						find_pwd_data._message = '';
					}, 1500);
				} else {
					$("#send_vcode").attr("disabled", 'disabled');
					$.ajax({
						type: "GET",
						timeout: _var_timeout,
						url: _redis_url + '/UserServer/login?username=' + find_pwd_data.tel_no + '&is_img_valid=1&password=&is_mobile=1&_is_login=0&img_valid_code=' + find_pwd_data.img_valid_code,
						dataType: "jsonp",
						jsonp: "callback",
						jsonpCallback: "jsonpCallBack",
						success: function (data) {
							if (angular.isDefined(data) && angular.isDefined(data.patch_version)) {
								$rootScope.showSystemMaintPopup(data.message.message).then(function (res) {
									$("#send_vcode").removeAttr("disabled");
									$("#send_vcode").text('获取验证码');
								});
								return;
							}
							if (angular.isDefined(data) && data.message == "valid_code") {
								$timeout(function () {
									find_pwd_data._flag = 0;
									find_pwd_data._message = '图形验证码不正确!';
								}, 0)

								$timeout(function () {
									find_pwd_data._flag = 1;
									find_pwd_data._message = '';
									$("#send_vcode").removeAttr("disabled");
									$("#send_vcode").text('获取验证码');
								}, 1500);
								return;
							}
							if (angular.isDefined(data) && data.success) {
								$http.post(data.url + '?event=ionicAction.ionicAction.sendPwdVCode', {}, {
									params: {
										tel_no: find_pwd_data.tel_no
									},
									timeout: _var_timeout
								}).
								success(function (data, status, headers, config) {
									window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
									if (data.flag == 0) {
										$scope.is_can_submit = true;

										var countdown = 120;
										fufu_register_timeout = setInterval(function () {
											countdown--;
											$("#send_vcode").text(countdown + ' S');
										}, 1000);
										setTimeout(function () {
											clearInterval(fufu_register_timeout);
											$("#send_vcode").removeAttr("disabled");
											$("#send_vcode").text('获取验证码');
											$scope.is_can_submit = false;
										}, 120000);
									} else {
										$("#send_vcode").removeAttr("disabled");
										$("#send_vcode").text('获取验证码');
										$ionicPopup.alert({
												title: '运行结果',
												template: '<div style="text-align: center;">' + data.message + '</div>',
												okText: '确定'
											})
											.then(function (res) {});
									}
								}).
								error(function (data, status, headers, config) {
									$("#send_vcode").removeAttr("disabled");
									$("#send_vcode").text('获取验证码');
									window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
								});
							} else {
								$("#send_vcode").removeAttr("disabled");
								$("#send_vcode").text('获取验证码');
								window.fufuMessageBox("网络超时或用户不存在", fufu_message_box_duration, function () {});
							}
						},
						error: function () {
							$("#send_vcode").removeAttr("disabled");
							$("#send_vcode").text('获取验证码');
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					})
				}
			}
		}
	})



	.factory('atZkLocSetSev', function ($http, $rootScope, $ionicPopup) {
		var at_loc_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtLocData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_loc_data);
					at_loc_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				at_loc_data = [];
			},
			getData: function () {
				return at_loc_data;
			},
			deleteAtZkLocInfo: function (z_id, _index) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
					params: {
						sid: "cpe.att.person.deleteUserInfo",
						zoneid: z_id,
						sync_type: 0,
						send_type: 3,
						zone_id: z_id
					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (angular.isDefined(data.flag)) {
						if (data.flag == '1') {
							window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
								at_loc_data.splice(_index, 1);
							});
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}

					} else {
						window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})

	.factory('atZkLocSetDetailSev', function ($http, $rootScope, $ionicPopup, $timeout) {
		var at_loc_detail_data = {
			"empl_list": [],
			"dev_list": {
				"dev_list": []
			},
			"_b": ''
		};
		var at_zk_empl_list = [];
		var at_zk_dev_list = [];
		var new_dev = {
			d_sn: '',
			d_name: ''
		};
		return {
			delZkAtDev: function (d_sn, _index) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				var date = new Date();
				var month = (date.getMonth() + 1) <= 9 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
				var day = (date.getDate()) <= 9 ? '0' + (date.getDate()) : (date.getDate());
				var inputdate = date.getFullYear() + "-" + month + "-" + day;
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.deletesn&' + _str, {}, {
					params: {
						add_data: 'sn:' + d_sn + '\n' + 'status:1' + '\n' + 'input_date:' + inputdate,
						data: 'sn:' + d_sn + '\n' + 'status:0\n' + 'input_date:\n',
						device_sn: d_sn
					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (angular.isDefined(data.flag)) {
						if (data.flag == '0') {
							window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
								$timeout(function () {
									at_zk_dev_list.dev_list.splice(_index, 1);
								}, 0);
							});
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}

					} else {
						window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getNewDev: function () {
				return new_dev;
			},
			delAtZkLocDev: function (z_id, d_sn, _index) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
					params: {
						sid: "cpe.att.person.deleteUserInfo",
						send_type: "3",
						zoneid: z_id,
						sn: d_sn,
						sync_type: 3,
						device_sn_list: d_sn,
						zone_id: z_id
					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (angular.isDefined(data.flag)) {
						if (data.flag == '1') {
							window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
								at_loc_detail_data.dev_list.dev_list.splice(_index, 1);
							});
						} else {
							window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						}

					} else {
						window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadData: function (z_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtLocDetailData&' + _str + '&z_id=' + z_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					//data.is_show_sub_bu = '1';
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}
					angular.copy(data, at_loc_detail_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				at_loc_detail_data = {
					"empl_list": [],
					"dev_list": {
						"dev_list": []
					},
					"_b": ''
				};
				at_zk_empl_list = [];
				at_zk_dev_list = [];
				new_dev = {
					d_sn: '',
					d_name: ''
				};
			},
			getData: function () {
				return at_loc_detail_data;
			},
			loadZkEmplList: function (z_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadZkEmplList&' + _str + '&z_id=' + z_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_zk_empl_list);
					var count = 0;
					for (var i = 0; i < at_zk_empl_list.length; i++) {
						if (at_zk_empl_list[i].ck) {
							count = count + 1;
						}
					}
					$('.zk-select-list').text('选中(' + count + ')');
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getZkEmplList: function () {
				return at_zk_empl_list;
			},
			loadZkDevList: function (z_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadZkDevList&' + _str + '&z_id=' + z_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					//data.device_is_show_sub_bu = '1';
					data.device_sub_bu_key = '';
					data.device_sub_bu_value = '添加';
					data.device_sub_bu_index = 0;
					for (var i = 0; i < data.device_sub_bu_list.length; i++) {
						if (data.device_sub_bu_list[i].check) {
							data.device_sub_bu_key = data.device_sub_bu_list[i].key;
							data.device_sub_bu_value = data.device_sub_bu_list[i].value;
							data.device_sub_bu_index = i;
						}
					}

					angular.copy(data, at_zk_dev_list);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getZkDevList: function () {
				return at_zk_dev_list;
			},

			zkLocSetDetailSubBuSave: function (z_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.zkLocSetDetailSubBuSave',
					timeout: _var_timeout,
					data: {
						z_id: z_id,
						select_sub_bu: at_loc_detail_data.sub_bu_key
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox("所属单位已更新", fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});


			}

		}
	})

	.factory('atZkLocAddSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_loc_add = {
			"dev_list": [],
			"_b": ''
		};
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadZkAddLocData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					data.device_sub_bu_key = '';
					data.device_sub_bu_value = '添加';
					data.device_sub_bu_index = 0;

					//data.is_show_sub_bu = '1';
					//data.device_is_show_sub_bu = '1';
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}

					for (var i = 0; i < data.device_sub_bu_list.length; i++) {
						if (data.device_sub_bu_list[i].check) {
							data.device_sub_bu_key = data.device_sub_bu_list[i].key;
							data.device_sub_bu_value = data.device_sub_bu_list[i].value;
							data.device_sub_bu_index = i;
						}
					}
					angular.copy(data, at_loc_add);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				at_loc_add = {
					"dev_list": [],
					"_b": ''
				};
			},
			getData: function () {
				return at_loc_add;
			},
			addAtLocInfo: function () {
				var _str = '';
				var _zone_name = $('#_at_zk_loc_name').val();
				if (_zone_name == '') {
					window.fufuMessageBox("区域名称不能为空", fufu_message_box_duration, function () {});
					return;
				}
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				var sn_list = '';
				var dev_list = '';
				for (var i = 0; i < at_loc_add.dev_list.length; i++) {
					if (at_loc_add.dev_list[i].ck) {
						sn_list = sn_list + at_loc_add.dev_list[i].d_sn + ',';
						dev_list = dev_list + at_loc_add.dev_list[i].d_name + ',' + at_loc_add.dev_list[i].d_sn + '||';
					}
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=zkat.general.execCmd&' + _str, {}, {
					params: {
						sid: "cpe.att.person.upload",
						send_type: "3",
						sn: sn_list.substring(0, sn_list.length - 1),
						sync_type: 0,
						employee_list: $('#at_zk_add_loc_list_hidden').val(),
						zone_name: _zone_name,
						device_sn_list: sn_list.substring(0, sn_list.length - 1),
						select_sub_bu: at_loc_add.sub_bu_key
					},
					timeout: 300000
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();

					if (angular.isDefined(data.flag)) {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_location_save');
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox("操作执行出错", fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})



	.factory('sysUserSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var personnal_data = {};
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getPersonnalInfo&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, personnal_data);
					if (typeof (data.employee_name) != 'undefined') {
						setLocalStorageVar("personnal_data", JSON.stringify(personnal_data));
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
				});
			},
			refreshData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getPersonnalInfo&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.refreshComplete');
					angular.copy(data, personnal_data);
					if (typeof (data.employee_name) != 'undefined') {
						setLocalStorageVar("personnal_data", JSON.stringify(personnal_data));
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.refreshComplete');
				});

			},
			clearData: function () {
				personnal_data = {};
			},
			getData: function () {
				return personnal_data;
			},
			setData: function (tempList) {
				angular.copy(tempList, personnal_data);
			}
		}
	})


	.factory('shiftPolicySev', function ($http, $rootScope, $ionicPopup) {
		var shift_policy_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftPolicyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, shift_policy_data);
					shift_policy_data.data_ready = true;
				}).
				error(function (data, status) {
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_policy_data = [];
			},
			getData: function () {
				return shift_policy_data;
			},
			shiftPolicyDelete: function (shift_policy_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftPolicyDelete',
					timeout: _var_timeout,
					data: {
						shift_policy_id: shift_policy_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								document.getElementById('shift_policy_' + shift_policy_id).style.display = "none";
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('shiftPolicyAddSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var shift_policy_add_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftPolicyAddData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.first_in_need_clock == '1') {
						document.getElementById('first_in_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('first_in_need_clock').innerHTML = '已关闭';
					}
					if (data.first_out_need_clock == '1') {
						document.getElementById('first_out_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('first_out_need_clock').innerHTML = '已关闭';
					}
					if (data.second_in_need_clock == '1') {
						document.getElementById('second_in_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('second_in_need_clock').innerHTML = '已关闭';
					}
					if (data.second_out_need_clock == '1') {
						document.getElementById('second_out_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('second_out_need_clock').innerHTML = '已关闭';
					}
					angular.copy(data, shift_policy_add_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_policy_add_data = [];
			},
			getData: function () {
				return shift_policy_add_data;
			},
			shift_policy_add_save: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftPolicyAddSave',
					timeout: _var_timeout,
					data: {
						policy_name: $('#policy_name').val(),
						first_in_need_clock: shift_policy_add_data.first_in_need_clock,
						first_out_need_clock: shift_policy_add_data.first_out_need_clock,
						second_in_need_clock: shift_policy_add_data.second_in_need_clock,
						second_out_need_clock: shift_policy_add_data.second_out_need_clock,
						first_in: shift_policy_add_data.first_in,
						first_out: shift_policy_add_data.first_out,
						second_in: shift_policy_add_data.second_in,
						second_out: shift_policy_add_data.second_out
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})

	.factory('shiftPolicyEditSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var shift_policy_edit_data = [];
		return {
			loadData: function (shift_policy_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftPolicyEditData&' + _str + '&shift_policy_id=' + shift_policy_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.first_in_need_clock == '1') {
						document.getElementById('first_in_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('first_in_need_clock').innerHTML = '已关闭';
					}
					if (data.first_out_need_clock == '1') {
						document.getElementById('first_out_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('first_out_need_clock').innerHTML = '已关闭';
					}
					if (data.second_in_need_clock == '1') {
						document.getElementById('second_in_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('second_in_need_clock').innerHTML = '已关闭';
					}
					if (data.second_out_need_clock == '1') {
						document.getElementById('second_out_need_clock').innerHTML = '需打卡';
					} else {
						document.getElementById('second_out_need_clock').innerHTML = '已关闭';
					}

					angular.copy(data, shift_policy_edit_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_policy_edit_data = [];
			},
			getData: function () {
				return shift_policy_edit_data;
			},
			shift_policy_edit_save: function (policy_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftPolicyEditSave',
					timeout: _var_timeout,
					data: {
						policy_id: policy_id,
						policy_name: $('#policy_name').val(),
						first_in_need_clock: shift_policy_edit_data.first_in_need_clock,
						first_out_need_clock: shift_policy_edit_data.first_out_need_clock,
						second_in_need_clock: shift_policy_edit_data.second_in_need_clock,
						second_out_need_clock: shift_policy_edit_data.second_out_need_clock,
						first_in: shift_policy_edit_data.first_in,
						first_out: shift_policy_edit_data.first_out,
						second_in: shift_policy_edit_data.second_in,
						second_out: shift_policy_edit_data.second_out
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
	})


	.factory('shiftGroupSev', function ($http, $rootScope, $ionicPopup) {
		var shift_group_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					/*
					for (var i=0; i<data.length;i++){
					//data[i].policy_name_list = data[i].policy_name_list.replace(',',"<span class='shift_group_indent_div'></span>");
					data[i].policy_name_list = data[i].policy_name_list.split(',').join("<span class='shift_group_indent_div'></span>");
					}
					*/
					$rootScope.hideLoading();
					angular.copy(data, shift_group_data);
					shift_group_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_group_data = [];
			},
			getData: function () {
				return shift_group_data;
			},
			shiftGroupDelete: function (shift_group_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftGroupDelete',
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id
					},
					success: function (data, status, headers, config) {

						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								document.getElementById('shift_group_' + shift_group_id).style.display = "none";
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('shiftGroupAddSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var shift_group_add_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupEditData&shift_group_id=-1&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}
					if (data.shift_policy && data.shift_policy.length) {

					} else {
						//模拟数据
						data.shift_policy = [];
					}

					data.shift_policy_key = '';
					data.shift_policy_value = '';
					data.shift_policy_index = 0;

					for (var i = 0; i < data.shift_policy.length; i++) {
						if (data.shift_policy[i].checked) {
							data.shift_policy_key = data.shift_policy[i].key;
							data.shift_policy_value = data.shift_policy[i].value;
							data.shift_policy_index = i;
						}
					}

					data.cal_at = data.cal_at ? true : false;
					data.bluetooth_sign = data.bluetooth_sign ? true : false;
					data.allow_retroactive = data.allow_retroactive ? true : false;

					angular.copy(data, shift_group_add_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_group_add_data = [];
			},
			getData: function () {
				return shift_group_add_data;
			},
			shift_group_add_save: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftGroupAddSave',
					timeout: _var_timeout,
					data: {
						shift_group_name: $('#shift_group_name').val(),
						policy_id_list: $('#policy_id_list').val(),
						employee_no_list: $('#shift_group_add_empl_list_hidden').val(),
						select_sub_bu: shift_group_add_data.sub_bu_key,
						cal_at: shift_group_add_data.cal_at ? 1 : 0,
						bluetooth_sign: shift_group_add_data.bluetooth_sign ? 1 : 0,
						allow_retroactive: shift_group_add_data.allow_retroactive ? 1 : 0,
						select_shift_policy: shift_group_add_data.shift_policy_key
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})


	.factory('shiftGroupAddEmployeeSelectSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var shift_group_add_employee_select_data = [];
		return {
			loadData: function () {
				var _str = '';
				var employee_list = $('#shift_group_add_empl_list_hidden').val();
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();

				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupEditEmployeeSelectData',
					data: {
						employee_list: employee_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
					},
					success: function (_data, status, headers, config) {
						$rootScope.hideLoading();
						var data = $.parseJSON(_data);
						var temp_obj = new Object();
						temp_obj.total_checked = 0;
						for (var i = 0; i < data.length; i++) {
							if (data[i].ck == true) {
								temp_obj.total_checked++;
							}
						}
						temp_obj.data = data;
						angular.copy(temp_obj, shift_group_add_employee_select_data);
						shift_group_add_employee_select_data.show_footer_bar = false;
						shift_group_add_employee_select_data.data_ready = true;
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},
			clearData: function () {
				shift_group_add_employee_select_data = [];
			},
			getData: function () {
				return shift_group_add_employee_select_data;
			}
		}
	})

	.factory('shiftGroupEditSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var shift_group_edit_data = [];
		return {
			loadData: function (shift_group_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupEditData&' + _str + '&shift_group_id=' + shift_group_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}

					if (data.shift_policy && data.shift_policy.length) {

					} else {
						//模拟数据
						data.shift_policy = [];
					};

					data.shift_policy_index = 0;
					data.shift_policy_key = "";
					data.shift_policy_value = "";

					for (var i = 0; i < data.shift_policy.length; i++) {

						if (data.shift_policy[i].checked) {

							data.shift_policy_key = data.shift_policy[i].key;
							data.shift_policy_value = data.shift_policy[i].value;
							data.shift_policy_index = i;

						}
					}

					data.cal_at = data.cal_at ? true : false;
					data.bluetooth_sign = data.bluetooth_sign ? true : false;
					data.allow_retroactive = data.allow_retroactive ? true : false;


					angular.copy(data, shift_group_edit_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_group_edit_data = [];
			},
			getData: function () {
				return shift_group_edit_data;
			},
			shift_group_edit_save: function () {
				$rootScope.showLoading();

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.shiftGroupEditSave',
					timeout: _var_timeout,
					data: {
						shift_group_id: $('#shift_group_id').html(),
						shift_group_name: $('#shift_group_name').val(),
						policy_id_list: $('#policy_id_list').val(),
						employee_no_list: $('#shift_group_edit_empl_list_hidden').val(),
						select_sub_bu: shift_group_edit_data.sub_bu_key,
						cal_at: shift_group_edit_data.cal_at ? 1 : 0,
						bluetooth_sign: shift_group_edit_data.bluetooth_sign ? 1 : 0,
						allow_retroactive: shift_group_edit_data.allow_retroactive ? 1 : 0,
						select_shift_policy: shift_group_edit_data.shift_policy_key
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);

						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {

							});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})

	.factory('shiftGroupEditEmployeeSelectSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var shift_group_edit_employee_select_data = [];
		return {
			loadData: function () {
				var _str = '';
				var employee_list = $('#shift_group_edit_empl_list_hidden').val();
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();

				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupEditEmployeeSelectData',
					data: {
						employee_list: employee_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
					},
					success: function (_data, status, headers, config) {
						$rootScope.hideLoading();
						var data = $.parseJSON(_data);
						var temp_obj = new Object();
						temp_obj.total_checked = 0;
						for (var i = 0; i < data.length; i++) {
							if (data[i].ck == true) {
								temp_obj.total_checked++;
							}
						}
						temp_obj.data = data;
						angular.copy(temp_obj, shift_group_edit_employee_select_data);
						shift_group_edit_employee_select_data.data_ready = true;
						shift_group_edit_employee_select_data.show_footer_bar = false;
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},
			clearData: function () {
				shift_group_edit_employee_select_data = [];
			},
			getData: function () {
				return shift_group_edit_employee_select_data;
			}
		}
	})

	.factory('shiftGroupAddPolicyPickerSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var shift_group_add_policy_picker_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getShiftGroupAddPolicyPickerData&' + _str + '&policy_id_list=' + $("#policy_id_list").val(), {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, shift_group_add_policy_picker_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				shift_group_add_policy_picker_data = [];
			},
			getData: function () {
				return shift_group_add_policy_picker_data;
			}

		}
	})

	.factory('holidayPolicySev', function ($http, $rootScope, $ionicPopup) {
		var holiday_policy_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHolidayPolicyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, holiday_policy_data);
					holiday_policy_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				holiday_policy_data = [];
			},
			getData: function () {
				return holiday_policy_data;
			},
			holiday_policy_delete: function (holiday_policy_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyDelete',
					timeout: _var_timeout,
					data: {
						holiday_policy_id: holiday_policy_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								document.getElementById('holiday_policy_' + holiday_policy_id).style.display = "none";
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('holidayPolicyAddSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var holiday_policy_add_data = {};
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyAddLoad&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					//sub bu logic
					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					//data.is_show_sub_bu = 1;
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}
					angular.copy(data, holiday_policy_add_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			getData: function () {
				return holiday_policy_add_data;
			},
			clearData: function () {
				holiday_policy_add_data = {};
			},

			holiday_policy_add_save: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyAddSave',
					timeout: _var_timeout,
					data: {
						holiday_policy_name: $('#holiday_policy_name').val(),
						employee_no_list: $('#holiday_policy_add_empl_list_hidden').val(),
						select_sub_bu: holiday_policy_add_data.sub_bu_key
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('holidayPolicyEditSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var holiday_policy_edit_data = [];
		return {
			loadData: function (holiday_policy_id, calendar_date_input) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHolidayPolicyEditData&' + _str + '&holiday_policy_id=' + holiday_policy_id + '&calendar_date_input=' + calendar_date_input, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					//sub bu logic
					data.sub_bu_key = '';
					data.sub_bu_value = '添加';
					data.sub_bu_index = 0;
					//data.is_show_sub_bu = 1;
					for (var i = 0; i < data.sub_bu_list.length; i++) {
						if (data.sub_bu_list[i].check) {
							data.sub_bu_key = data.sub_bu_list[i].key;
							data.sub_bu_value = data.sub_bu_list[i].value;
							data.sub_bu_index = i;
						}
					}

					data.edit_mode = false;
					data.current_date_text = document.getElementById('calendar_date_input').innerHTML;
					if (data.current_holiday.holiday_id == '-1') {
						data.is_new = true;
						data.current_holiday.holiday_name = '无';
					} else {
						data.is_new = false;
					}

					var holiday_type_data = [];
					data.holiday_type_index = '';

					data.holiday_type_data_key = '';
					document.getElementById('holiday_type').innerHTML = '请选择';
					for (var i = 0; i < data.current_holiday.holiday_data.length; i++) {
						holiday_type_data[i] = data.current_holiday.holiday_data[i];
						holiday_type_data[i].key = data.current_holiday.holiday_data[i].key;
						holiday_type_data[i].value = data.current_holiday.holiday_data[i].name;
						if (holiday_type_data[i].checked) {
							data.holiday_type_index = i;
							document.getElementById('holiday_type').innerHTML = holiday_type_data[i].value;
							data.holiday_type_data_key = holiday_type_data[i].key;
							data.holiday_type_data_value = holiday_type_data[i].value;
							data.holiday_type_data_index = i;
							document.getElementById('holiday_type').innerHTML = holiday_type_data[i].name;
						}
					}

					data.holiday_type_data = holiday_type_data;

					//data.holiday_type_data_key=holiday_type_data[data.holiday_type_index].key;
					data.current_holiday.ct_days = parseFloat(data.current_holiday.ct_days);
					angular.copy(data, holiday_policy_edit_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return holiday_policy_edit_data;
			},
			clearData: function () {
				holiday_policy_edit_data = [];
			},
			setEditMode: function (edit_mode) {
				holiday_policy_edit_data.edit_mode = edit_mode;
			},
			holiday_policy_detail_delete: function ($scope) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyDetailDelete',
					timeout: _var_timeout,
					data: {
						holiday_id: $('#holiday_id').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$scope.load_data();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});


			},
			holiday_policy_detail_save: function (holiday_policy_id, holiday_policy_name, $scope) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyDetailSave',
					timeout: _var_timeout,
					data: {
						holiday_id: holiday_policy_edit_data.current_holiday.holiday_id,
						holiday_policy_id: holiday_policy_id,
						holiday_policy_name: holiday_policy_name,
						holiday_type: holiday_policy_edit_data.holiday_type_data_key,
						holiday_name: $('#holiday_name').val(),
						target_date: $('#calendar_date_input1').val(),
						count_days: $('#ct_days').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$scope.load_data();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});


			},
			holidayPolicySubBuSave: function (holiday_policy_id) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicySubBuSave',
					timeout: _var_timeout,
					data: {
						holiday_policy_id: holiday_policy_id,
						select_sub_bu: holiday_policy_edit_data.sub_bu_key
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox("所属单位已更新", fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});


			}


		}
	})

	.factory('holidayPolicyAddEmployeeSelectSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var holiday_policy_add_employee_select_data = [];
		return {
			loadData: function () {
				var _str = '';
				var employee_list = $('#holiday_policy_add_empl_list_hidden').val();
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();

				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHolidayPolicyAddEmployeeSelectData',
					data: {
						employee_list: employee_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
					},
					success: function (_data, status, headers, config) {
						$rootScope.hideLoading();
						var data = $.parseJSON(_data);
						var temp_obj = new Object();
						temp_obj.total_checked = 0;
						for (var i = 0; i < data.length; i++) {
							if (data[i].ck == true) {
								temp_obj.total_checked++;
							}
						}
						temp_obj.data = data;
						temp_obj.data_ready = true;
						angular.copy(temp_obj, holiday_policy_add_employee_select_data);
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
				/*
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHolidayPolicyAddEmployeeSelectData&' + _str + '&employee_list=' + employee_list, {
					timeout: _var_timeout
				}).
				//        $http.get(window.localStorage['_remote_server_addr']+'?event=ionicAction.ionicAction.loadMdEmplList&employee_list='+$("#holiday_policy_add_empl_list_hidden").val()+'&'+_str,{
				//            timeout:_var_timeout
				//          }).
				success(function(data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					temp_obj.total_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck == true) {
							temp_obj.total_checked++;
						}
					}
					temp_obj.data = data;
					temp_obj.data_ready = true;
					angular.copy(temp_obj, holiday_policy_add_employee_select_data);
				}).
				error(function(data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function() {});
				});
				*/
			},
			clearData: function () {
				holiday_policy_add_employee_select_data = [];
			},
			getData: function () {
				return holiday_policy_add_employee_select_data;
			}

		}
	})


	.factory('holidayPolicyEditEmployeeSelectSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var holiday_policy_edit_employee_select_data = [];
		return {
			loadData: function (holiday_policy_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHolidayPolicyEditEmployeeSelectData&' + _str + '&holiday_policy_id=' + holiday_policy_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					temp_obj.total_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck == true) {
							temp_obj.total_checked++;
						}
					}
					temp_obj.data = data;
					holiday_policy_edit_employee_select_data.string = '';
					holiday_policy_edit_employee_select_data.show_footer_bar = false;
					holiday_policy_edit_employee_select_data.data_ready = true;
					angular.copy(temp_obj, holiday_policy_edit_employee_select_data);
					for (var i = 0; i < holiday_policy_edit_employee_select_data.data.length; i++) {
						if (holiday_policy_edit_employee_select_data.data[i].ck) {
							holiday_policy_edit_employee_select_data.string += holiday_policy_edit_employee_select_data.data[i].emp + ",";
						}
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				holiday_policy_edit_employee_select_data = [];
			},
			getData: function () {
				return holiday_policy_edit_employee_select_data;
			},

			holiday_policy_edit_employee_select_save: function (holiday_policy_id) {
				$rootScope.showLoading();
				var employee_no_list = "";
				for (var i = 0; i < holiday_policy_edit_employee_select_data.data.length; i++) {
					if (holiday_policy_edit_employee_select_data.data[i].ck) {
						employee_no_list += holiday_policy_edit_employee_select_data.data[i].emp + ',';
					}
				}
				if (employee_no_list != '') {
					employee_no_list = employee_no_list.substring(0, employee_no_list.length - 1);
				}

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.holidayPolicyEditEmployeeSelectSave',
					timeout: _var_timeout,
					data: {
						holiday_policy_id: holiday_policy_id,
						employee_no_list: employee_no_list
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})


	.factory('lvCodeSettingSev', function ($http, $rootScope, $ionicPopup) {
		var lv_code_setting_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvCodeSettingData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, lv_code_setting_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_code_setting_data = [];
			},
			getData: function () {
				return lv_code_setting_data;
			}
		}
	})

	.factory('lvCodeSettingDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var lv_code_setting_detail_data = [];
		return {
			loadData: function (lv_code_id, lv_code_name, has_balance) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvCodeSettingDetailData&' + _str + '&lv_code_id=' + lv_code_id + '&lv_code_name=' + lv_code_name + '&has_balance=' + has_balance, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.lv_code_id == '-1') {
						data.is_active = false;
					} else {
						data.is_active = true;
					}
					angular.copy(data, lv_code_setting_detail_data);
					if (data.lv_code_name == '补休假') {
						document.getElementById('lv_code_setting_detail_picklist_min_unit').style.display = "none";
					} else {
						document.getElementById('lv_code_setting_detail_picklist_min_unit').style.display = "block";
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_code_setting_detail_data = [];
			},
			getData: function () {
				return lv_code_setting_detail_data;
			},

			setMinUnit: function (min_unit) {
				lv_code_setting_detail_data.min_unit_name = min_unit;
			},

			lv_code_setting_detail_save: function (lv_code_name, lvCodeSettingDetailData, has_balance) {
				var temp_entitle_data = new Array();
				var temp_obj;
				if (has_balance == '1') {
					for (var i = 0; i < lvCodeSettingDetailData.entitle_data.length; i++) {
						temp_obj = new Object();
						temp_obj.from = lvCodeSettingDetailData.entitle_data[i].from;
						temp_obj.to = lvCodeSettingDetailData.entitle_data[i].to;
						temp_obj.days = lvCodeSettingDetailData.entitle_data[i].days;
						temp_entitle_data.push(temp_obj);
					}
				}
				var entitle_data_string = JSON.stringify(temp_entitle_data);
				entitle_data_string = entitle_data_string.substring(1, entitle_data_string.length - 1);
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.lvCodeSettingDetailSave',
					timeout: _var_timeout,
					data: {
						lv_code_id: $('#lv_code_id').val(),
						lv_code_name: lv_code_name,
						is_need_attachement: lvCodeSettingDetailData.is_need_attachement == true ? 1 : 0,
						count_exclude_holiday: lvCodeSettingDetailData.count_exclude_holiday == true ? 1 : 0,
						min_unit: $('#min_unit').val(),
						pay_type: lvCodeSettingDetailData.pay_type == true ? 1 : 0,
						exit_action: $('#exit_action').val(),
						entitle_begin_date: $('#entitle_begin_date').val(),
						cutoff_type: $('#cutoff_type').val(),
						entitle_type: $('#entitle_type').val(),
						lastyear_balance_type_name: lvCodeSettingDetailData.lastyear_balance_type_name == true ? 1 : 0,
						entitle_formula: entitle_data_string,
						is_active: lvCodeSettingDetailData.is_active == true ? 1 : 0
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});


			}

		}
	})

	.factory('attendanceSettingSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var attendance_setting_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAttendanceSettingData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, attendance_setting_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				attendance_setting_data = [];
			},
			getData: function () {
				return attendance_setting_data;
			},
			attendance_setting_save: function (attendanceSettingData) {
				var parameter_list = '';
				parameter_list += (attendanceSettingData.row_1 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_2 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_3 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_4 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_5 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_6 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_7 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_8 == true ? 1 : 0) + ',';
				parameter_list += $('#row_9').val() + ',';
				parameter_list += $('#row_10').val() + ',';
				parameter_list += $('#row_11').val() + ',';
				parameter_list += $('#row_12').val() + ',';
				parameter_list += (attendanceSettingData.row_13 == true ? 1 : 0) + ',';
				parameter_list += (attendanceSettingData.row_14 == true ? 1 : 0) + ',';
				parameter_list += $('#row_15').val() + ',';
				parameter_list += $('#row_16').val() + ',';
				parameter_list += $('#row_17').val() + ',';
				parameter_list += $('#row_18').val() + ',';
				parameter_list += $('#row_19').val() + ',';
				parameter_list += $('#row_20').val() + ',';
				parameter_list += $('#row_21').val() + ',';
				parameter_list += $('#row_22').val() + ',';
				parameter_list += attendanceSettingData.row_23 == true ? 1 : 0;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.attendanceSettingSave',
					timeout: _var_timeout,
					data: {
						parameter_list: parameter_list
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})


	.factory('otToLeaveSettingSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var ot_to_leave_setting_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOtToLeaveSettingData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ot_to_leave_setting_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ot_to_leave_setting_data = [];
			},
			getData: function () {
				return ot_to_leave_setting_data;
			},
			ot_to_leave_setting_save: function (otToLeaveSettingData) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otToLeaveSettingSave',
					timeout: _var_timeout,
					data: {
						is_active: (otToLeaveSettingData.is_active == true ? 1 : 0),
						ot1: (otToLeaveSettingData.ot1 == true ? 1 : 0),
						ot2: (otToLeaveSettingData.ot2 == true ? 1 : 0),
						ot3: (otToLeaveSettingData.ot3 == true ? 1 : 0),
						post_date_type: $('#post_date_type').val(),
						post_date_size: $('#post_date_size').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})


	.factory('otToLeaveSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var ot_to_leave_data = [];
		return {
			loadData: function (target_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOtToLeaveData&' + _str + '&target_date=' + target_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					for (var i = 0; i < data.length; i++) {
						data[i].checked = false;
					}
					temp_obj.data = data;
					temp_obj.show_footer_bar = false;
					temp_obj.num_checked = 0;
					angular.copy(temp_obj, ot_to_leave_data);
					ot_to_leave_data.data_ready = true;
					if (temp_obj.data.length == 0) {
						document.getElementById('select_all_employee').style.display = 'none';
						document.getElementById('deselect_all_employee').style.display = 'none';
					} else {
						document.getElementById('select_all_employee').style.display = 'block';
						document.getElementById('deselect_all_employee').style.display = 'none';
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return ot_to_leave_data;
			},
			clearData: function () {
				ot_to_leave_data = [];
			},
			ot_to_leave_save: function (otToLeaveData) {
				var employee_list = '';
				$rootScope.showLoading();

				for (var i = 0; i < ot_to_leave_data.data.length; i++) {
					if (ot_to_leave_data.data[i].checked) {
						employee_list += ot_to_leave_data.data[i].em;
						employee_list += ',';
					}
				}
				if (employee_list != '') {
					employee_list = employee_list.substring(0, employee_list.length - 1);
				}

				if (employee_list == '') {
					$rootScope.hideLoading();
					return;
				}

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otToLeaveSave',
					timeout: _var_timeout,
					data: {
						employee_list: employee_list,
						target_date: document.getElementById('target_date').innerHTML
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_to_leave');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('employeeDeleteSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var employee_delete_data = [];
		return {
			loadData: function (target_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeDeleteData&' + _str + '&target_date=' + target_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, employee_delete_data);
					employee_delete_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				employee_delete_data = [];
			},
			getData: function () {
				return employee_delete_data;
			},
			employee_delete: function (employee_no) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeDelete',
					timeout: _var_timeout,
					data: {
						employee_no: employee_no
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_employee_delete');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}
		}
	})

	.factory('employeeResignSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var employee_resign_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeResignData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, employee_resign_data);
					employee_resign_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				employee_resign_data = [];
			},
			getData: function () {
				return employee_resign_data;
			}
		}
	})

	.factory('employeeResignDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var employee_resign_detail_data = [];
		return {
			loadData: function (employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeResignDetailData&' + _str + '&employee_no=' + employee_no, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$("#termination_effect_date").val(data.termination_effect_date);
					$("#last_working_date").val(data.last_working_date);
					angular.copy(data, employee_resign_detail_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				employee_resign_detail_data = [];
			},
			getData: function () {
				return employee_resign_detail_data;
			},
			employee_resign_detail_save: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeResignDetailSave',
					timeout: _var_timeout,
					data: {
						employee_no: employee_resign_detail_data.em,
						termination_effect_date: employee_resign_detail_data.termination_effect_date,
						last_working_date: employee_resign_detail_data.last_working_date,
						is_rehire: $('#is_rehire').val(),
						exit_reason: $('#exit_reason').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_employee_resign_save');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},
			employee_cancel_resign: function (employee_no) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeCancelResign',
					timeout: _var_timeout,
					data: {
						employee_no: employee_no
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {

						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}
		}
	})

	.factory('employeeContractSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout, $ionicScrollDelegate) {
		var employee_contract_data = [];
		var employee_contract_cache_data = [];
		var end_of_list = {};
		end_of_list.status = false;
		var search_control = {};
		search_control.search_val = '';
		var searchState = {};
		searchState.flag = false;
		searchState.is_show_wrap = true;
		var searchNodata = {};
		searchNodata.is_search = false;
		var employee_contract_num = 0;
		var employee_contract_number = 0;
		return {
			loadData: function (search_val) {

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeContractData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$ionicScrollDelegate.scrollTop();
					end_of_list.status = false;
					searchState.flag = true;
					searchState.is_show_wrap = true;
					employee_contract_num = 0;
					employee_contract_number = 0;
					employee_contract_cache_data = [];
					var temp_employee_contract_data = [];
					//employee_contract_data
					search_val = search_val.toLowerCase();
					for (var i = 0; i < data.length; i++) {
						if (search_val == '') {
							employee_contract_cache_data.push(data[i]);
						} else {
							if (data[i].en.toLowerCase().indexOf(search_val) != -1 || data[i].pn.toLowerCase().indexOf(search_val) != -1 || data[i].st.toLowerCase().indexOf(search_val) != -1) {
								employee_contract_cache_data.push(data[i]);
							}
						}
					}


					for (var i = 0; i < employee_contract_cache_data.length; i++) {
						temp_employee_contract_data.push(employee_contract_cache_data[i]);
						employee_contract_num++;
						if (i == 19) {
							employee_contract_number = employee_contract_num;
							break;
						}
					}
					if (temp_employee_contract_data.length < 20) {
						end_of_list.status = true;
					}

					angular.copy(temp_employee_contract_data, employee_contract_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			loadMoreData: function ($scope) {
				end_of_list.status = false;
				if (employee_contract_data.length == employee_contract_cache_data.length) {
					end_of_list.status = true;
					return;
				}
				for (var i = 0; i < employee_contract_cache_data.length - employee_contract_number; i++) {
					employee_contract_data.push(employee_contract_cache_data[i + employee_contract_number]);
					employee_contract_num++;
					if (i == 19) {
						employee_contract_number = employee_contract_num;
						break;
					}

					$scope.$broadcast('scroll.infiniteScrollComplete');
				}
			},

			clearData: function () {
				employee_contract_data = [];
			},
			getData: function () {
				return employee_contract_data;
			},
			getEndOfList: function () {
				return end_of_list;
			},


			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_value) {
				$timeout(function () {
					search_control.search_val = search_value;
				})
			},
			setSearchState: function (flag) {
				searchState.flag = flag;
			},
			getSearchValue: function () {
				return search_control;
			},
			getSearchNodata: function () {
				return searchNodata;
			},
			setSearchNodata: function (flag) {
				searchNodata.is_search = flag;
			},
			getSearchState: function () {
				return searchState;
			},
			setIsShowWrap: function (flag) {
				searchState.is_show_wrap = flag;
			}



		}
	})

	.factory('employeeContractDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout) {
		var employee_contract_detail_data = [];
		return {
			loadData: function ($scope, employee_no, current_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeContractDetailData&' + _str + '&employee_no=' + employee_no, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$scope.edit_mode = false;
					$scope.expand_mode = false;

					$scope.new_expand_mode = false;

					$('#new_contract_start_date').val(current_date);
					$('#new_contract_end_date').val(current_date);

					if (data.c_c_d.length == 0) {
						document.getElementById('contract_start_date').innerHTML = current_date;
						document.getElementById('contract_end_date').innerHTML = current_date;

						$scope.flag = 0;
					} else {
						document.getElementById('contract_start_date').innerHTML = data.c_c_d[0].contract_start_date;
						document.getElementById('contract_end_date').innerHTML = data.c_c_d[0].contract_end_date;
						$('#contract_term_key').val(data.c_c_d[0].contract_term_key);
						$('#contract_term').html(data.c_c_d[0].contract_term);
						$('#contract_times_after2008').html('2008年后第' + data.c_c_d[0].contract_times_after2008 + '次签约');
						$('#remark').html(data.c_c_d[0].remark);


						$('#uneditable_contract_start_date').html(data.c_c_d[0].contract_start_date);
						$('#uneditable_contract_end_date').html(data.c_c_d[0].contract_end_date);
						$('#uneditable_contract_term').html(data.c_c_d[0].contract_term);
						$('#uneditable_contract_times_after2008').html('2008年后第' + data.c_c_d[0].contract_times_after2008 + '次签约');
						$('#uneditable_remark').html(data.c_c_d[0].remark);
						$scope.flag = 1;

						data.c_c_d[0].contract_image_data = data.c_c_d[0].attachment;

						data.c_c_d[0].attachment_array = [];
						if (data.c_c_d[0].attachment != '') {
							data.c_c_d[0].attachment_array = data.c_c_d[0].attachment.split(",");
						}

						if (data.c_c_d[0].contract_term_key == 'O') {
							document.getElementById('contract_end_date_uneditable_div').style.display = "none";
							document.getElementById('contract_end_date_editable_div').style.display = "none";
						}
					}


					if (data.has_his == '1') {
						document.getElementById('employee_contract_detail_history_button').style.display = "block";
					} else {
						document.getElementById('employee_contract_detail_history_button').style.display = "none";
					}

					/*
              for (var i = 0; i < data.c_f_d.length; i++){
              data.c_f_d[i].edit_mode = false;
              data.c_f_d[i].expand_mode = false;
              $('#contract_start_date_' + data.c_f_d[i].contract_id).val(data.c_f_d[i].contract_start_date);
              $('#contract_end_date_' + data.c_f_d[i].contract_id).val(data.c_f_d[i].contract_end_date);
              $('#contract_term_key_' + data.c_f_d[i].contract_id).val(data.c_f_d[i].contract_term_key);
              $('#contract_term_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].contract_term);
              $('#contract_times_after2008_' + data.c_f_d[i].contract_id).html('2008年后第' + data.c_f_d[i].contract_times_after2008 + '次签约');
              $('#remark_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].remark);


				$('#uneditable_contract_start_date_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].contract_start_date);
              $('#uneditable_contract_end_date_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].contract_end_date);
              $('#uneditable_contract_term_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].contract_term);
              $('#uneditable_contract_times_after2008_' + data.c_f_d[i].contract_id).html('2008年后第' + data.c_f_d[i].contract_times_after2008 + '次签约');
              $('#uneditable_remark_' + data.c_f_d[i].contract_id).html(data.c_f_d[i].remark);
              }
              */

					data.new_contract_image_data = '';

					for (var i = 0; i < data.c_f_d.length; i++) {
						data.c_f_d[i].contract_image_data = data.c_f_d[i].attachment;
						data.c_f_d[i].attachment_array = [];
						if (data.c_f_d[i].attachment != '') {
							data.c_f_d[i].attachment_array = data.c_f_d[i].attachment.split(",");
						}
					}

					angular.copy(data, employee_contract_detail_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				employee_contract_detail_data = [];
			},
			getData: function () {
				return employee_contract_detail_data;
			},

			new_employee_contract_detail_save_with_upload: function (employee_no) {
				var attachment_num = 0;
				if (employee_contract_detail_data.new_contract_image_data != '') {
					attachment_num = employee_contract_detail_data.new_contract_image_data.split(',').length;
				}
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				params.employee_no = employee_no;
				params.contract_id = '0';
				params.contract_start_date = document.getElementById('new_contract_start_date').innerHTML;
				params.contract_end_date = document.getElementById('new_contract_end_date').innerHTML;
				params.contract_term = $('#new_contract_term_key').val();
				params.remark = $('#new_remark').val();
				params.is_require_upload = '1';
				params.attachment_num = attachment_num;
				params.o_attachment = '';

				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();

				$timeout(function () {
					ft.uploadMore(
						employee_contract_detail_data.new_contract_image_data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
						function (data) {
							try {
								$rootScope.hideLoading();
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_add_contract');
										ft.clearCacheImage();
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}
							} catch (e) {
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);


			},

			new_employee_contract_detail_save: function (employee_no) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
					timeout: _var_timeout,
					data: {
						employee_no: employee_no,
						contract_id: '0',
						contract_start_date: document.getElementById('new_contract_start_date').innerHTML,
						contract_end_date: document.getElementById('new_contract_end_date').innerHTML,
						contract_term: $('#new_contract_term_key').val(),
						attachement: 'attachement',
						remark: $('#new_remark').val(),
						is_require_upload: '0',
						o_attachment: ''
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_add_contract');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},

			employee_contract_detail_save_with_upload: function (employee_no, num_of_upload, updated_o_attachment) {

				$rootScope.showLoading();


				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				params.employee_no = employee_no;
				params.contract_id = employee_contract_detail_data.c_c_d.length == 0 ? '0' : employee_contract_detail_data.c_c_d[0].contract_id;
				params.contract_start_date = document.getElementById('contract_start_date').innerHTML;
				params.contract_end_date = document.getElementById('contract_end_date').innerHTML;
				params.contract_term = $('#contract_term_key').val();
				params.remark = $('#remark').val();
				params.is_require_upload = '1';
				params.attachment_num = num_of_upload;
				params.o_attachment = updated_o_attachment;
				options.params = params;
				var ft = new FileTransfer();

				$timeout(function () {
					ft.uploadMore(
						employee_contract_detail_data.c_c_d[0].contract_image_data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
						function (data) {
							try {
								$rootScope.hideLoading();
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_edit_contract');
										ft.clearCacheImage();
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}
							} catch (e) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);

			},

			employee_contract_detail_save: function (employee_no, updated_o_attachment) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
					timeout: _var_timeout,
					data: {
						employee_no: employee_no,
						contract_id: employee_contract_detail_data.c_c_d.length == 0 ? '0' : employee_contract_detail_data.c_c_d[0].contract_id,
						contract_start_date: document.getElementById('contract_start_date').innerHTML,
						contract_end_date: document.getElementById('contract_end_date').innerHTML,
						contract_term: $('#contract_term_key').val(),
						attachement: '',
						o_attachment: updated_o_attachment,
						is_require_upload: '0',
						remark: $('#remark').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_edit_contract');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},

			employee_contract_detail_delete: function (employee_no) {
				$ionicPopup.confirm({
					title: '提示',
					template: '<div style="text-align: center;">' + '确认删除合约?' + '</div>',
					cancelText: '取消',
					cancelType: 'button-dark',
					okText: '确认'
				}).then(function (res) {
					if (res) {
						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailDelete',
							timeout: _var_timeout,
							data: {
								employee_no: employee_no,
								contract_id: employee_contract_detail_data.c_c_d[0].contract_id
							},
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == '0') {
									window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_delete_contract');
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}
				});



			},


			future_employee_contract_detail_save_with_upload: function (employee_no, contract_id, current_item, num_of_upload, updated_o_attachment) {

				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				params.employee_no = employee_no;
				params.contract_id = contract_id;
				params.contract_start_date = document.getElementById('contract_start_date_' + contract_id).innerHTML;
				params.contract_end_date = document.getElementById('contract_end_date_' + contract_id).innerHTML;
				params.contract_term = $('#contract_term_key_' + contract_id).val();
				params.remark = $('#remark_' + contract_id).val();
				params.is_require_upload = '1';
				params.attachment_num = num_of_upload;
				params.o_attachment = updated_o_attachment;

				options.params = params;
				var ft = new FileTransfer();

				$timeout(function () {
					ft.uploadMore(
						current_item.contract_image_data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
						function (data) {
							try {
								$rootScope.hideLoading();
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_edit_contract');
										ft.clearCacheImage();
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}
							} catch (e) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);

			},


			future_employee_contract_detail_save: function (employee_no, contract_id, current_item, updated_o_attachment) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
					timeout: _var_timeout,
					data: {
						employee_no: employee_no,
						contract_id: contract_id,
						contract_start_date: document.getElementById('contract_start_date_' + contract_id).innerHTML,
						contract_end_date: document.getElementById('contract_end_date_' + contract_id).innerHTML,
						contract_term: $('#contract_term_key_' + contract_id).val(),
						attachement: '',
						is_require_upload: '0',
						o_attachment: updated_o_attachment,
						remark: $('#remark_' + contract_id).val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_edit_contract');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			},

			future_employee_contract_detail_delete: function (employee_no, contract_id) {
				$ionicPopup.confirm({
					title: '提示',
					template: '<div style="text-align: center;">' + '确认删除合约?' + '</div>',
					cancelText: '取消',
					cancelType: 'button-dark',
					okText: '确认'
				}).then(function (res) {
					if (res) {
						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailDelete',
							timeout: _var_timeout,
							data: {
								employee_no: employee_no,
								contract_id: contract_id
							},
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == '0') {
									window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_delete_contract');
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}
				});



			}


		}
	})


	.factory('employeeContractDetailHistorySev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout) {
		var employee_contract_detail_history_data = [];
		return {
			loadData: function (employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEmployeeContractDetailHistoryData&' + _str + '&employee_no=' + employee_no, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					for (var i = 0; i < data.length; i++) {
						data[i].edit_mode = false;
						data[i].expand_mode = false;
						data[i].is_require_upload = false;
						data[i].contract_image_data = data[i].attachment;

						/*
						if (data[i].contract_term_key == 'O'){
						document.getElementById('contract_' + data.contract_id + '_end_date_uneditable_div').style.display = "none";
						document.getElementById('contract_' + data.contract_id + '_end_date_editable_div').style.display = "none";
						}*/
						//$('#contract_start_date_' + data.contract_id).val(data[i].contract_start_date);
						//$('#contract_end_date_' + data.contract_id).val(data[i].contract_end_date);


						data[i].date_string = '(' + data[i].contract_start_date.split('-')[0] + '.' + data[i].contract_start_date.split('-')[1] + '-' + data[i].contract_end_date.split('-')[0] + '.' + data[i].contract_end_date.split('-')[1] + ')';
					}
					angular.copy(data, employee_contract_detail_history_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return employee_contract_detail_history_data;
			},
			clearData: function () {
				employee_contract_detail_history_data = [];
			},

			employee_contract_detail_history_save_with_upload: function (current_item, $scope, num_of_upload, updated_o_attachment) {
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				params.employee_no = current_item.em;
				params.contract_id = current_item.contract_id;
				params.contract_start_date = document.getElementById('contract_start_date_' + current_item.contract_id).innerHTML;
				params.contract_end_date = document.getElementById('contract_end_date_' + current_item.contract_id).innerHTML;
				params.contract_term = 'F';
				params.remark = $('#remark_' + current_item.contract_id).val();
				params.is_require_upload = '1';
				params.o_attachment = updated_o_attachment;
				params.attachment_num = num_of_upload;


				options.params = params;
				var ft = new FileTransfer();
				$timeout(function () {
					ft.uploadMore(
						current_item.contract_image_data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
						function (data) {
							try {
								$rootScope.hideLoading();
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										ft.clearCacheImage();
										$ionicHistory.goBack();
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}
							} catch (e) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);

			},

			employee_contract_detail_history_save: function (current_item, $scope, updated_o_attachment) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailSave',
					timeout: _var_timeout,
					data: {
						employee_no: current_item.em,
						contract_id: current_item.contract_id,
						contract_start_date: document.getElementById('contract_start_date_' + current_item.contract_id).innerHTML,
						contract_end_date: document.getElementById('contract_end_date_' + current_item.contract_id).innerHTML,
						//contract_term: current_item.contract_item,
						contract_term: 'F',
						attachement: 'attachement',
						remark: $('#remark_' + current_item.contract_id).val(),
						is_require_upload: '0',
						o_attachment: updated_o_attachment
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			employee_contract_detail_history_delete: function (current_item) {
				$ionicPopup.confirm({
					title: '提示',
					template: '<div style="text-align: center;">' + '确认删除合约?' + '</div>',
					cancelText: '取消',
					cancelType: 'button-dark',
					okText: '确认'
				}).then(function (res) {
					if (res) {
						$rootScope.showLoading();
						$.ajax({
							type: 'POST',
							url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.employeeContractDetailDelete',
							timeout: _var_timeout,
							data: {
								employee_no: current_item.em,
								contract_id: current_item.contract_id
							},
							success: function (data, status, headers, config) {
								$rootScope.hideLoading();
								var _data = $.parseJSON(data);
								if (_data.flag == '0') {
									window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
										document.getElementById('contract_' + current_item.contract_id).style.display = 'none';
									});
								} else {
									window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
								}
							},
							error: function (data, status, headers, config) {
								$rootScope.hideLoading();
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						});
					}
				});
			}


		}
	})


	.factory('atEmplCardRecSev', function ($http, $rootScope, $ionicPopup) {
		var at_empl_card_rec_data = [];
		return {
			loadData: function (current_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtEmplCardRecData&' + _str + '&card_date=' + current_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, at_empl_card_rec_data);
					at_empl_card_rec_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return at_empl_card_rec_data;
			},
			clearData: function () {
				at_empl_card_rec_data = [];
			}
		}
	})


	.factory('webImportSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var web_import_data = [];
		return {
			loadData: function (target_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getWebImportData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					for (var i = 0; i < data.length; i++) {
						data[i].checked = false;
					}
					temp_obj.data = data;
					temp_obj.show_footer_bar = false;
					temp_obj.num_checked = 0;
					angular.copy(temp_obj, web_import_data);
					web_import_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				web_import_data = [];
			},
			getData: function () {
				return web_import_data;
			},
			web_import_save: function ($location) {
				var employee_no_list = '';
				var user_name_list = '';
				var employee_name_list = '';
				$rootScope.showLoading();

				for (var i = 0; i < web_import_data.data.length; i++) {
					if (web_import_data.data[i].checked) {
						if (web_import_data.data[i].employee_no != '') {
							employee_no_list += web_import_data.data[i].employee_no;
						} else {
							employee_no_list += ' ';
						}
						if (web_import_data.data[i].user_name != '') {
							user_name_list += web_import_data.data[i].user_name;
						} else {
							user_name_list += ' ';
						}
						if (web_import_data.data[i].employee_name != '') {
							employee_name_list += web_import_data.data[i].employee_name;
						} else {
							employee_name_list += ' ';
						}
						employee_no_list += ',';
						user_name_list += ',';
						employee_name_list += ',';
					}
				}
				if (employee_no_list != '') {
					employee_no_list = employee_no_list.substring(0, employee_no_list.length - 1);
					user_name_list = user_name_list.substring(0, user_name_list.length - 1);
					employee_name_list = employee_name_list.substring(0, employee_name_list.length - 1);
				}

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.webImportSave',
					timeout: 30000000,
					data: {
						employee_no_list: employee_no_list,
						user_name_list: user_name_list,
						employee_name_list: employee_name_list,
						current_datetime: 'none'
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							fufuMobclickAgent('click_web_import');
							$location.path('home_page/home_menulist/web_import_result/' + _data.success_employee_no_list + '/' + _data.failure_employee_no_list + '/' + _data.current_datetime);
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})


	.factory('webImportResultSev', function ($http, $rootScope, $ionicPopup) {
		var web_import_result_data = [];
		return {
			loadData: function ($scope, failure_employee_no_list, success_employee_no_list) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getWebImportResultData&' + _str,
					timeout: _var_timeout,
					data: {
						failure_employee_no_list: failure_employee_no_list,
						success_employee_no_list: success_employee_no_list
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						var item_success_div_string = '';
						var item_failure_div_string = '';
						angular.copy(_data, web_import_result_data);

						for (var i = 0; i < _data.success_data.length; i++) {
							item_success_div_string += '<a class="col col-33" align="center" style="text-decoration: none; display: inline-block; float: left; padding: 0px;max-width:25%; padding:12px 0;"><img style="width:50px;height:50px; border-radius:50px" src="' + _data.success_data[i].img_src + '"><span style="display:block; font-size:14px;color:#434343;" class="ng-binding">' + _data.success_data[i].employee_name + '</span></a>';
						}

						for (var i = 0; i < _data.failure_data.length; i++) {
							item_failure_div_string += '<a class="col col-33" align="center" style="text-decoration: none; display: inline-block; float: left; padding: 0px;max-width:25%; padding:12px 0;"><img style="width:50px;height:50px; border-radius:50px" src="' + _data.failure_data[i].img_src + '"><span style="display:block; font-size:14px;color:#434343;" class="ng-binding">' + _data.failure_data[i].employee_name + '</span></a>';
						}


						$('#item_failure_div').html(item_failure_div_string);
						$('#item_success_div').html(item_success_div_string);

						$scope.$apply();
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			getData: function () {

				return web_import_result_data;
			},
			clearData: function () {
				web_import_result_data = [];
			},

			import_failure_employee: function ($scope) {
				var employee_no_list = '';
				var user_name_list = '';
				var employee_name_list = '';
				$rootScope.showLoading();

				for (var i = 0; i < web_import_result_data.failure_data.length; i++) {

					if (web_import_result_data.failure_data[i].employee_no != '') {
						employee_no_list += web_import_result_data.failure_data[i].employee_no;
					} else {
						employee_no_list += ' ';
					}
					if (web_import_result_data.failure_data[i].user_name != '') {
						user_name_list += web_import_result_data.failure_data[i].user_name;
					} else {
						user_name_list += ' ';
					}
					if (web_import_result_data.failure_data[i].employee_name != '') {
						employee_name_list += web_import_result_data.failure_data[i].employee_name;
					} else {
						employee_name_list += ' ';
					}
					employee_no_list += ',';
					user_name_list += ',';
					employee_name_list += ',';

				}
				if (employee_no_list != '') {
					employee_no_list = employee_no_list.substring(0, employee_no_list.length - 1);
					user_name_list = user_name_list.substring(0, user_name_list.length - 1);
					employee_name_list = employee_name_list.substring(0, employee_name_list.length - 1);
				}

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.webImportSave',
					timeout: _var_timeout,
					data: {
						employee_no_list: employee_no_list,
						user_name_list: user_name_list,
						employee_name_list: employee_name_list,
						current_datetime: $scope.current_datetime
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							//$location.path('home_page/home_menulist/web_import_result/' + _data.success_employee_no_list + '/' + _data.failure_employee_no_list + '/' + _data.current_datetime);
							$scope.failure_employee_no_list = _data.failure_employee_no_list;
							if (_data.success_employee_no_list != '') {
								if ($scope.success_employee_no_list == '') {
									$scope.success_employee_no_list = _data.success_employee_no_list;
								} else {
									$scope.success_employee_no_list += ',' + _data.success_employee_no_list;
								}
							}
							if ($scope.failure_employee_no_list == '') {
								$scope.failure_employee_count = 0;
							} else {
								$scope.failure_employee_count = $scope.failure_employee_no_list.split(',').length;
							}
							if ($scope.success_employee_no_list == '') {
								$scope.success_employee_count = 0;
							} else {
								$scope.success_employee_count = $scope.success_employee_no_list.split(',').length;
							}
							web_import_result_data = [];
							$scope.refresh_data();
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}


		}
	})


	.factory('changeUsernameSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $location) {
		var change_user_data = {
			tel_no: '',
			valid_code: '',
			old_pwd: '',
			_flag: 1,
			_message: '',
			button_text: '获取验证码'
		}
		//var myTime;
		var changeUsernameTimeout;
		return {
			changeUsernameSendVCode: function () {

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.updateUserVCode&' + _str,
					timeout: _var_timeout,
					data: {
						tel_no: $('#change_username_tel_no').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == 0) {
							$('#_change_username_action').removeAttr('disabled');
							document.getElementById('change_username_send_vcode_message').style.display = "block";
							var countdown = 120;
							clearTimeout(changeUsernameTimeout);
							changeUsernameTimeout = setInterval(function () {
								if ($ionicHistory.currentView().stateName != 'home_page.change_username') {
									clearTimeout(changeUsernameTimeout);
									return;
								}
								countdown--;
								$("#change_username_send_vcode_button").text(countdown + ' S');
								if (countdown == 0) {
									$("#change_username_send_vcode_button").removeAttr("disabled");
									$("#change_username_send_vcode_button").text('获取验证码');
									$('#_change_username_action').attr('disabled', 'disabled');
									document.getElementById('change_username_send_vcode_message').style.display = "none";
									clearTimeout(changeUsernameTimeout);
								}
							}, 1000);
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}


					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getChangeUserData: function () {
				return change_user_data;
			},
			changeUsernameAction: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeUsernameAction',
					timeout: _var_timeout,
					data: {
						change_username_password: $('#change_username_password').val(),
						new_user_name: $('#change_username_tel_no').val(),
						valid_code: $('#change_username_valid_code').val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						$ionicPopup.alert({
							title: '运行结果',
							template: '<div style="text-align: center;">' + _data.message + '</div>',
							okText: '确定'
						}).then(function (res) {
							if (_data.flag == '0') {
								$.ajax({
									type: "GET",
									url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
									timeout: _var_timeout,
									success: function (data) {
										$rootScope.hideLoading();
										$ionicPopup.alert({
											title: '提醒',
											template: '<div style="text-align: center;">' + '请使用新用户名重登' + '</div>',
											okText: '确定'
										}).then(function (res) {
											fufuMobclickAgent('click_change_username');
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											setLocalStorageVar("_pass_word", "");
											setLocalStorageVar("vip_status", "");
											setLocalStorageVar("_is_login", "0");
											if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
												var model_list = window.localStorage["menu_list"].split(',');
												for (var i = 0; i < model_list.length; i++) {
													if (model_list[i] != '') {
														setLocalStorageVar(model_list[i], "");
													}
												}
											}
											setLocalStorageVar("menu_list", "");
											setLocalStorageVar("menu_home", "");
											setLocalStorageVar("menu_message", "");
											setLocalStorageVar("menu_organization_management", "");
											setLocalStorageVar("menu_time", "");
											setLocalStorageVar("menu_payroll", "");
											setLocalStorageVar("menu_ess", "");
											setLocalStorageVar("menu_My_Team", "");
											setLocalStorageVar("menu_setting", "");
											setLocalStorageVar("personnal_data", "");
											setLocalStorageVar("is_free_trial_login", "");
											login_init_flag = 0;
											$location.path('/');
										});
									},
									error: function (data) {
										$rootScope.hideLoading();
										window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
									}
								});
							}
						});

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
	})

	.factory('resignUserSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $location) {
		return {
			resignUserAction: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.resignUserAction&' + _str,
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						$ionicPopup.alert({
							title: '运行结果',
							template: '<div style="text-align: center;">' + _data.message + '</div>',
							okText: '确定'
						}).then(function (res) {
							if (_data.flag == '0') {
								fufuMobclickAgent('click_user_resign');
								$.ajax({
									type: "GET",
									url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
									timeout: _var_timeout,
									success: function (data) {
										$rootScope.hideLoading();
										$ionicPopup.alert({
											title: '提醒',
											template: '<div style="text-align: center;">' + '请再次使用本应用' + '</div>',
											okText: '确定'
										}).then(function (res) {
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											setLocalStorageVar("_pass_word", "");
											setLocalStorageVar("_is_login", "0");
											if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
												var model_list = window.localStorage["menu_list"].split(',');
												for (var i = 0; i < model_list.length; i++) {
													if (model_list[i] != '') {
														setLocalStorageVar(model_list[i], '');
													}
												}
											}
											setLocalStorageVar("menu_list", "");
											setLocalStorageVar("menu_home", "");
											setLocalStorageVar("menu_message", "");
											setLocalStorageVar("menu_organization_management", "");
											setLocalStorageVar("menu_time", "");
											setLocalStorageVar("menu_payroll", "");
											setLocalStorageVar("menu_ess", "");
											setLocalStorageVar("menu_My_Team", "");
											setLocalStorageVar("menu_setting", "");
											setLocalStorageVar("personnal_data", "");
											setLocalStorageVar("is_free_trial_login", "");
											login_init_flag = 0;
											$location.path('/');
										});
									},
									error: function (data) {
										$rootScope.hideLoading();
										window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
									}
								});
							}
						});
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('companyInfoSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $location) {
		var company_info_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getVipUserDetails&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, company_info_data);
					//console.log(company_info_data);
					for (var i = 0; i < data.c_ct_l.length; i++) {
						if (data.c_ct_l[i].key_ == data.e_ct) {
							data.c_ct_l[i].ch = true;
							document.getElementById("company_empl_num").innerHTML = data.c_ct_l[i].value_;
							break;
						} else {
							if ((i + 1) == data.c_ct_l.length) {
								document.getElementById("company_empl_num").innerHTML = '请选择企业规模';
							}
						}
					}
					for (var i = 0; i < data.cg_l.length; i++) {
						if (data.cg_l[i].key_ == data.cg) {
							data.cg_l[i].ch = true;
							break;
						}
					}

					company_info_data.side_category_data = data.cg_l;
					company_info_data.side_category_data_index = 0;
					for (var i = 0; i < company_info_data.side_category_data.length; i++) {
						company_info_data.side_category_data[i].key = data.cg_l[i].key_;
						company_info_data.side_category_data[i].value = data.cg_l[i].value_;
						if (data.cg_l[i].ch) {
							company_info_data.side_category_data_index = i;
						}
					}
					company_info_data.side_empl_num_data = data.c_ct_l;
					company_info_data.side_empl_num_data_index = 0;
					for (var i = 0; i < company_info_data.side_empl_num_data.length; i++) {
						company_info_data.side_empl_num_data[i].key = data.c_ct_l[i].key_;
						company_info_data.side_empl_num_data[i].value = data.c_ct_l[i].value_;
						if (data.c_ct_l[i].ch) {
							company_info_data.side_empl_num_data_index = i;
						}
					}
					console.log(company_info_data.side_empl_num_data);


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				company_info_data = [];
			},
			getData: function () {
				return company_info_data;
			},
			resignCompany: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=zkat.general.delCompAll&' + _str,
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						$ionicPopup.alert({
							title: '运行结果',
							template: '<div style="text-align: center;">' + _data.message + '</div>',
							okText: '确定'
						}).then(function (res) {
							if (_data.flag == '1') {
								$.ajax({
									type: "GET",
									url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.doLogout',
									timeout: _var_timeout,
									success: function (data) {
										$rootScope.hideLoading();
										$ionicPopup.alert({
											title: '提醒',
											template: '<div style="text-align: center;">' + '欢迎再次使用本应用' + '</div>',
											okText: '确定'
										}).then(function (res) {
											fufuMobclickAgent('click_company_resign');
											$ionicHistory.clearCache();
											$ionicHistory.clearHistory();
											setLocalStorageVar("_pass_word", "");
											setLocalStorageVar("_is_login", "0");
											if (window.localStorage["menu_list"] != null && typeof (window.localStorage["menu_list"]) != 'undefined' && window.localStorage["menu_list"] != '') {
												var model_list = window.localStorage["menu_list"].split(',');
												for (var i = 0; i < model_list.length; i++) {
													if (model_list[i] != '') {
														setLocalStorageVar(model_list[i], "");
													}
												}
											}
											setLocalStorageVar("menu_list", "");
											setLocalStorageVar("menu_home", "");
											setLocalStorageVar("menu_message", "");
											setLocalStorageVar("menu_organization_management", "");
											setLocalStorageVar("menu_time", "");
											setLocalStorageVar("menu_payroll", "");
											setLocalStorageVar("menu_ess", "");
											setLocalStorageVar("menu_My_Team", "");
											setLocalStorageVar("menu_setting", "");
											setLocalStorageVar("personnal_data", "");
											setLocalStorageVar("is_free_trial_login", "");
											login_init_flag = 0;
											$location.path('/');
										});
									},
									error: function (data) {
										$rootScope.hideLoading();
										window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
									}
								});
							}
						});
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			saveCompanyInfo: function () {
				var _str = '';
				var data = "company_name:" + $('#company').val() + "\nemployee_ct:" + company_info_data.e_ct + "\ncategory:" + company_info_data.cg;
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveVipUserMsg&' + _str,
					timeout: _var_timeout,
					data: {
						item_key: 'web',
						item_val: 'customer_name'+String.fromCharCode(10) + $('#company').val() + String.fromCharCode(13)+'category'+String.fromCharCode(10) + company_info_data.cg +String.fromCharCode(13) +'employee_ct'+String.fromCharCode(10) + company_info_data.e_ct + String.fromCharCode(13),
						company_name: $('#company').val(),
						employee_ct: company_info_data.e_ct,
						category: company_info_data.cg,
						phone: $('#company_phone_no').html(),
						data: data
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('staffMasterPositionTreePicklistSev', function ($http, $rootScope, $ionicPopup) {
		var position_tree_picklist_data = [];
		return {
			loadData: function (o_i) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getstaffMasterPositionTreePicklistData&' + _str,
					timeout: _var_timeout,
					data: {
						o_i: o_i
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, position_tree_picklist_data);
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				position_tree_picklist_data = [];
			},
			getData: function () {
				return position_tree_picklist_data;
			}
		}
	})

	.factory('staffMasterPositionPicklistSev', function ($http, $rootScope, $ionicPopup) {
		var position_picklist_data = [];
		return {
			loadData: function (node_id, position_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getstaffMasterPositionPicklistData&' + _str,
					data: {
						node_id: node_id,
						position_id: position_id
					},
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, position_picklist_data);
						for (var i = 0; i < _data.length; i++) {
							if (_data[i].ch == true) {
								document.getElementById('position_picklist_button').style.display = "block";
								break;
							}
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				position_picklist_data = [];
			},
			getData: function () {
				return position_picklist_data;
			}
		}
	})

	.factory('tempStaffMasterPositionPicklistSev', function ($http, $rootScope, $ionicPopup) {
		var temp_position_picklist_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getTempStaffMasterPositionPicklistData&' + _str,

					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, temp_position_picklist_data);
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				temp_position_picklist_data = [];
			},
			getData: function () {
				return temp_position_picklist_data;
			}
		}
	})

	.factory('atSignInSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_sign_in_data = [];
		var display_time = '';
		var clock_timeout;
		var service_obj = {
			loadData: function (current_date) {
				//alert(current_date);
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtSignInData&' + _str,
					timeout: _var_timeout,
					data: {
						current_date: '',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var hour;
						var minute;
						var second;
						var hour_diff = 0;
						var minute_diff = 0;
						var second_diff = 0;
						var today;

						var _data = $.parseJSON(data);
						angular.copy(_data, at_sign_in_data);
						document.getElementById("at_sign_in_current_date").setAttribute("max", _data.c_d);

						if (_data.can_fieldwork == '1') {
							document.getElementById('signoutdoor').style.display = "block";
							document.getElementById('signindoor').style.display = "none";
							document.getElementById('sign_in_tab_1').style.color = 'white';
							document.getElementById('sign_in_tab_1').style.backgroundColor = '#53afff';
							document.getElementById('sign_in_tab_1').style.border = '1px solid #53afff';
							document.getElementById('sign_in_tab_2').style.color = 'black';
							document.getElementById('sign_in_tab_2').style.backgroundColor = 'white';
							document.getElementById('sign_in_tab_2').style.border = '1px solid #eeeeee';
							document.getElementById('sign_in_tab_2').style.borderLeft = 'none';
							document.getElementById('sign_in_tab_1').style.display = "block";
							document.getElementById('sign_in_tab_2').style.display = "block";
							document.getElementById('sign_in_tab_3').style.display = "none";
							document.getElementById('sign_in_tab_4').style.display = "none";
						} else {
							document.getElementById('signindoor').style.display = "block";
							document.getElementById('signoutdoor').style.display = "none";
							document.getElementById('sign_in_tab_3').style.display = "block";
							document.getElementById('sign_in_tab_4').style.display = "block";
							document.getElementById('sign_in_tab_1').style.display = "none";
							document.getElementById('sign_in_tab_2').style.display = "none";
						}


						if (_data.is_c_d == '0') {
							//document.getElementById('next_day_not_clickable').style.display = "none";
							document.getElementById('next_day_clickable').style.display = "block";
							document.getElementById('previous_day').style.display = "block";
							document.getElementById('shake_outer_div').style.display = "none";
							document.getElementById('shake_outer_div_disable').style.display = "block";
							document.getElementById("sign_in_wrap").style.display = "none";
							document.getElementById("sign_in_wrap_outdoor").style.display = "none";
							document.getElementById("wifi_sign_in").style.display = "none";
							document.getElementById("sign_in_tab").style.display = "none";
						} else {
							//document.getElementById('next_day_not_clickable').style.display = "block";
							document.getElementById('next_day_clickable').style.display = "none";
							document.getElementById('previous_day').style.display = "block";
							document.getElementById('shake_outer_div').style.display = "block";
							document.getElementById('shake_outer_div_disable').style.display = "none";
							document.getElementById("sign_in_wrap").style.display = "block";
							document.getElementById("sign_in_wrap_outdoor").style.display = "block";
							document.getElementById("sign_in_tab").style.display = "block";
							document.getElementById("wifi_sign_in").style.display = "none";
							document.getElementById("at_sign_in_current_date_1").innerHTML = _data.c_d;
							if (_data.is_can_in == '0') {
								document.getElementById("wifi_sign_in_disable").style.display = "block";
							}
							if (_data.valid_mode == '1' || _data.valid_mode == '1,2') {
								//if(document.getElementById("sign_in_wifi_mac").value == _data.wifi_mac) {
								//    document.getElementById("wifi_sign_in").style.display = "block";
								//}
								//else {
								//
								//    document.getElementById("wifi_sign_in").style.display="none";
								//}
								try {
									network.wifiInfo(function (msg) {
										try {
											if (msg.state == '-1' && ionic.Platform.isIOS()) {
												window.fufuMessageBox("无法获取当前WiFi,请启动WIFI重试", fufu_message_box_duration, function () {});
												return;
											}


											var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
											var wifi_str = "";
											for (var v = 0; v < wifi_arr1.length; v++) {
												if (wifi_arr1[v] != '"') {
													wifi_str = wifi_str + wifi_arr1[v];
												}
											}
											document.getElementById("sign_in_wifi_name").value = wifi_str;
											document.getElementById("sign_in_wifi_mac").value = msg.mac;

											//if (typeof($scope.atSignInData.wifi_mac) != 'undefined'){

											if (_data.wifi_mac == msg.mac && (_data.valid_mode == '1,2' || _data.valid_mode == '1')) {
												if (_data.is_can_in == '1') {
													document.getElementById("wifi_sign_in").style.display = "block";
												}
											} else {
												document.getElementById("wifi_sign_in").style.display = "none";
											}
										} catch (e) {

										}
										//}
										//  alert(msg.mac);
									});
								} catch (e) {
									console.log(e.message);

								}

							} else {
								document.getElementById("wifi_sign_in").style.display = "none";
							}
						}

						//是否可以内勤
						if (_data.is_can_in == '0') {

							document.getElementById('shake_outer_div').style.backgroundColor = '#eeeeee';
						}



						if (_data.ca_r.length > 0) {
							document.getElementById('no_record_message').style.display = "none";
						} else {
							document.getElementById('no_record_message').style.display = "block";
						}
						if (_data.is_c_d == 0) {
							return
						}
						//
						//
						////是否可以外勤
						//if(_data.can_fieldwork=="0"){
						//    document.getElementById("signindoor").style.display="block";
						//  document.getElementById("signoutdoor").style.display="none";
						//}
						//else{
						//  document.getElementById("signindoor").style.display="none";
						//  document.getElementById("signoutdoor").style.display="block";
						//}

						hour = _data.c_t.split(':')[0];
						hour = parseInt(hour, '10');
						minute = _data.c_t.split(':')[1];
						minute = parseInt(minute, '10');
						second = _data.c_t.split(':')[2];
						second = parseInt(second, '10');

						today = new Date();
						hour_diff = hour - today.getHours();
						minute_diff = minute - today.getMinutes();
						second_diff = second - today.getSeconds();

						clearTimeout(clock_timeout);

						function run_clock() {

							if ($ionicHistory.currentView().stateName != 'home_page.at_sign_in') {
								clearTimeout(clock_timeout);
								return;
							}
							clock_timeout = setTimeout(run_clock, 1000);
							display_time = '';

							today = new Date();
							hour = today.getHours() + hour_diff;
							minute = today.getMinutes() + minute_diff;
							second = today.getSeconds() + second_diff;

							/*
							 today.setMinutes(today.getMinutes() - today.getTimezoneOffset());
							 if (_data.c_d != today.toJSON().slice(0, 10)) {
							 $scope.load_card_record();
							 clearTimeout(clock_timeout);
							 return;
							 }
							 */

							if (second >= 60) {
								second = second - 60;
								minute++;
							} else if (second < 0) {
								second = second + 60;
								minute--;
							}
							if (minute >= 60) {
								minute = minute - 60;
								hour++;
							} else if (minute < 0) {
								minute = minute + 60;
								hour--;
							}
							if (hour >= 24) {
								hour = hour - 24;
								//$scope.load_card_record();
								service_obj.loadData($('#at_sign_in_current_date').val());
								clearTimeout(clock_timeout);
								return;
							} else if (hour < 0) {
								hour = hour + 24;
							}
							display_time = '';
							if (hour <= 9)
								display_time = '0' + hour;
							else
								display_time = hour;
							if (minute <= 9)
								display_time += ':' + '0' + minute;
							else
								display_time += ':' + minute;
							if (second <= 9)
								display_time += ':' + '0' + second;
							else
								display_time += ':' + second;


							$('#sign_in_clock_div').html(display_time);

						}
						run_clock();
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getData: function () {
				return at_sign_in_data;
			},
			clearData: function () {
				at_sign_in_data = [];
			},
			getDisplayTime: function () {
				return display_time;
			},

			refreshCurrentWifi: function () {
				try {
					network.wifiInfo(function (msg) {

						try {
							var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
							var wifi_str = "";
							for (var v = 0; v < wifi_arr1.length; v++) {
								if (wifi_arr1[v] != '"') {
									wifi_str = wifi_str + wifi_arr1[v];
								}
							}

							document.getElementById("sign_in_wifi_name").value = wifi_str;
							document.getElementById("sign_in_wifi_mac").value = msg.mac;

							if (typeof (at_sign_in_data.wifi_mac) != 'undefined') {

								if (at_sign_in_data.mac == document.getElementById("sign_in_wifi_mac").value && (at_sign_in_data.valid_mode == '1,2' || at_sign_in_data.valid_mode == '1')) {

									document.getElementById("wifi_sign_in").style.display = "block";
								} else {
									document.getElementById("wifi_sign_in").style.display = "none";
								}
							}
						} catch (e) {

						}
						//  alert(msg.mac);
					});
				} catch (e) {
					console.log(e.message);
				}
			},

			signInAction: function ($scope, current_address, current_latitude, current_longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//alert(device.uuid);
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.signInAction&' + _str,
					timeout: _var_timeout,
					data: {
						latitude: current_latitude,
						longitude: current_longitude,
						address: current_address,
						wifi_value: document.getElementById("sign_in_wifi_name").value,
						card_rec_time: $('#sign_in_clock_div').html(),
						wifi_mac: document.getElementById("sign_in_wifi_mac").value,
						mobile_token: device.uuid,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {

						$rootScope.hideLoading();
						fufu_processing = false;
						$scope.processing = 0;
						var _data = $.parseJSON(data);
						if (_data.flag == '2') {
							$scope.reddi();
						} else {
							if (_data.flag == '0') {
								window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
									fufuMobclickAgent('click_sign_in_submit');
									$scope.load_card_record();
								});
							} else {
								window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
							}
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						$('._press_at_sign_in').text('按一下打卡');
						$scope.processing = 0;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
		return service_obj;
	})
	.factory('atSignInOutDoorSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_sign_in_outdoor_data = [];
		return {
			loadData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();

				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtSignInOutDoorData&' + _str,
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);

						if (_data.approver_list_flag) {
							if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
								_data.approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < _data.approver_list.length; i++) {
									$scope.select_user_id += _data.approver_list[i].user_id;
									if (i <= _data.approver_list.length - 2) {
										$scope.select_user_id += ',';
									}
								}
							}
						}

						if (_data.notify_list_flag) {
							if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {
								_data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < _data.notify_list.length; i++) {
									$scope.select_notify_id += _data.notify_list[i].user_id;
									if (i <= _data.notify_list.length - 2) {
										$scope.select_notify_id += ',';
									}
								}
							}
						}
						document.getElementById('approver_list_div').style.width = (_data.approver_list.length + 1) * 100 + 20 + 'px';
						document.getElementById('notify_list_div').style.width = (_data.notify_list.length + 1) * 100 + 20 + 'px';

						angular.copy(_data, at_sign_in_outdoor_data);

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				at_sign_in_outdoor_data = [];
			},
			getData: function () {
				return at_sign_in_outdoor_data;
			},
			signInOutDoorSaveWithUpload: function (action, o_photo, latitude, longitude, select_user_id, notify_id, new_latitude, new_longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.fileKey = 'at_sign_in_upload';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}

				params.location = document.getElementById("address_now").innerHTML;
				params.longitude = longitude;
				params.latitude = latitude;
				params.photo = document.getElementById("Sign_photos").src;
				params.reason = "";
				//params.reason=document.getElementById("sign_in_reason").innerHTML;
				params.apply_remark = document.getElementById("new_remark").value;
				params.is_fieldwork = "1";
				params.i_wf = at_sign_in_outdoor_data.i_wf;
				params.i_l = at_sign_in_outdoor_data.i_l;
				params.i_p = at_sign_in_outdoor_data.i_p;
				params.customer = document.getElementById("sign_in_outdoor_customer_name").value;
				params.location_detail = document.getElementById("message_city").value;
				params.actor = select_user_id;
				params.show_type = at_sign_in_outdoor_data.show_type;
				params.biz_type_key = at_sign_in_outdoor_data.biz_type_key;
				params.wf_app_table = at_sign_in_outdoor_data.wf_app_table;
				params.approver_id_list = at_sign_in_outdoor_data.approver_id_list;
				params.is_standard_wf = at_sign_in_outdoor_data.is_standard_wf;
				params.employee_no = at_sign_in_outdoor_data.employee_no;
				params.is_require_upload = '1';
				params.o_photo = o_photo;
				params.action = action;
				params.notify_list = notify_id;
				params.new_latitude = new_latitude;
				params.new_longitude = new_longitude;
				params.mobile_token = device.uuid;
				params.time_zone = $rootScope.get_utc_time_zone();
				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();
				ft.upload(
					document.getElementById('Sign_photos').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					function (data) {
						try {
							$rootScope.hideLoading();
							fufu_processing = false;
							var response = $.parseJSON(data.response);
							if (response.flag == '0') {

								if (at_sign_in_outdoor_data.approver_list_flag && at_sign_in_outdoor_data.approver_list.length != 0) {
									setLocalStorageVar("ess_approver_list" + window.localStorage['_user_name'], JSON.stringify(at_sign_in_outdoor_data.approver_list));
								}
								if (at_sign_in_outdoor_data.notify_list_flag && at_sign_in_outdoor_data.notify_list.length != 0) {
									setLocalStorageVar("ess_notify_list" + window.localStorage['_user_name'], JSON.stringify(at_sign_in_outdoor_data.notify_list));
								}

								window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
									fufuMobclickAgent('click_fieldwork_submit');
									if ($ionicHistory.currentView().stateName == 'home_page.at_sign_in_outdoor_modify') {
										$ionicHistory.goBack(-2);
									} else {
										$ionicHistory.goBack();
									}
								});
							} else {
								window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
							}
						} catch (e) {
							fufu_processing = false;
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					},
					function (error) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);

			},

			signInOutDoorSave: function (action, o_photo, latitude, longitude, select_user_id, notify_id, new_latitude, new_longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					timeout: _var_timeout,
					data: {
						location: document.getElementById("address_now").innerHTML,
						//location:'address',
						longitude: longitude,
						latitude: latitude,
						photo: document.getElementById("Sign_photos").src,
						//reason:document.getElementById("sign_in_reason").innerHTML,
						reason: '',
						apply_remark: document.getElementById("new_remark").value,
						is_fieldwork: "1",
						i_wf: at_sign_in_outdoor_data.i_wf,
						i_l: at_sign_in_outdoor_data.i_l,
						i_p: at_sign_in_outdoor_data.i_p,
						customer: document.getElementById("sign_in_outdoor_customer_name").value,
						location_detail: document.getElementById("message_city").value,
						//location_detail:"address1",
						actor: select_user_id,
						show_type: at_sign_in_outdoor_data.show_type,
						biz_type_key: at_sign_in_outdoor_data.biz_type_key,
						wf_app_table: at_sign_in_outdoor_data.wf_app_table,
						is_standard_wf: at_sign_in_outdoor_data.is_standard_wf,
						approver_id_list: at_sign_in_outdoor_data.approver_id_list,
						is_require_upload: '0',
						o_photo: o_photo,
						action: action,
						notify_list: notify_id,
						new_latitude: new_latitude,
						new_longitude: new_longitude,
						mobile_token: device.uuid,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {

							if (at_sign_in_outdoor_data.approver_list_flag && at_sign_in_outdoor_data.approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_outdoor_data.approver_list));
							}
							if (at_sign_in_outdoor_data.notify_list_flag && at_sign_in_outdoor_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_outdoor_data.notify_list));
							}

							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_fieldwork_submit');
								if ($ionicHistory.currentView().stateName == 'home_page.at_sign_in_outdoor_modify') {
									$ionicHistory.goBack(-2);
								} else {
									$ionicHistory.goBack();
								}
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}
		}
	})

	.factory('atSignInRemoteSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_sign_in_remote_data = [];
		return {
			loadData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtSignInRemoteDoorData&' + _str,
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);

						if (_data.approver_list_flag) {
							if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
								_data.approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < _data.approver_list.length; i++) {
									$scope.select_user_id += _data.approver_list[i].user_id;
									if (i <= _data.approver_list.length - 2) {
										$scope.select_user_id += ',';
									}
								}
							}
						}

						if (_data.notify_list_flag) {
							if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {
								_data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);
								for (var i = 0; i < _data.notify_list.length; i++) {
									$scope.select_notify_id += _data.notify_list[i].user_id;
									if (i <= _data.notify_list.length - 2) {
										$scope.select_notify_id += ',';
									}
								}
							}
						}

						document.getElementById('approver_list_div').style.width = (_data.approver_list.length + 1) * 100 + 20 + 'px';
						document.getElementById('notify_list_div').style.width = (_data.notify_list.length + 1) * 100 + 20 + 'px';

						angular.copy(_data, at_sign_in_remote_data);
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				at_sign_in_remote_data = [];
			},
			getData: function () {
				return at_sign_in_remote_data;
			},
			signInOutDoorSaveWithUpload: function (action, o_photo, latitude, longitude, select_user_id, notify_id, new_latitude, new_longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.fileKey = 'at_sign_in_upload';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}

				params.location = document.getElementById("address_now").innerHTML;
				params.longitude = longitude;
				params.latitude = latitude;
				params.photo = document.getElementById("Sign_photos").src;
				params.reason = document.getElementById("sign_in_reason").innerHTML;
				params.apply_remark = document.getElementById("new_remark").value;
				params.is_fieldwork = "0";
				params.i_wf = at_sign_in_remote_data.i_wf;
				params.i_l = at_sign_in_remote_data.i_l;
				params.i_p = at_sign_in_remote_data.i_p;
				params.customer = document.getElementById("sign_in_outdoor_customer_name").value;
				params.location_detail = document.getElementById("message_city").value;
				params.employee_no = at_sign_in_remote_data.employee_no;
				params.actor = select_user_id;
				params.show_type = at_sign_in_remote_data.show_type;
				params.biz_type_key = at_sign_in_remote_data.biz_type_key;
				params.wf_app_table = at_sign_in_remote_data.wf_app_table;
				params.approver_id_list = at_sign_in_remote_data.approver_id_list;
				params.is_standard_wf = at_sign_in_remote_data.is_standard_wf;
				params.is_require_upload = '1';
				params.o_photo = o_photo;
				params.action = action;
				params.notify_list = notify_id;
				params.new_latitude = new_latitude;
				params.mobile_token = device.uuid;
				params.time_zone = $rootScope.get_utc_time_zone();
				params.new_longitude = new_longitude;
				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				//$rootScope.showLoading();
				ft.upload(
					document.getElementById('Sign_photos').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInRemoteSave',
					function (data) {
						try {
							$rootScope.hideLoading();
							fufu_processing = false;
							var response = $.parseJSON(data.response);
							if (response.flag == '0') {

								if (at_sign_in_remote_data.approver_list_flag && at_sign_in_remote_data.approver_list.length != 0) {
									setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_remote_data.approver_list));
								}
								if (at_sign_in_remote_data.notify_list_flag && at_sign_in_remote_data.notify_list.length != 0) {
									setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_remote_data.notify_list));
								}

								window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
									fufuMobclickAgent('click_remote_submit');
									$ionicHistory.goBack();
								});
							} else {
								window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
							}
						} catch (e) {
							fufu_processing = false;
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}
					},
					function (error) {

						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);

			},

			signInOutDoorSave: function (action, o_photo, latitude, longitude, select_user_id, notify_id, new_latitude, new_longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInRemoteSave',
					timeout: _var_timeout,
					data: {
						location: document.getElementById("address_now").innerHTML,
						longitude: longitude,
						latitude: latitude,
						photo: document.getElementById("Sign_photos").src,
						reason: document.getElementById("sign_in_reason").innerHTML,
						apply_remark: document.getElementById("new_remark").value,
						is_fieldwork: "0",
						i_wf: at_sign_in_remote_data.i_wf,
						i_l: at_sign_in_remote_data.i_l,
						i_p: at_sign_in_remote_data.i_p,
						employee_no: at_sign_in_remote_data.employee_no,
						customer: document.getElementById("sign_in_outdoor_customer_name").value,
						location_detail: document.getElementById("message_city").value,
						actor: select_user_id,
						show_type: at_sign_in_remote_data.show_type,
						biz_type_key: at_sign_in_remote_data.biz_type_key,
						wf_app_table: at_sign_in_remote_data.wf_app_table,
						is_require_upload: '0',
						is_standard_wf: at_sign_in_remote_data.is_standard_wf,
						approver_id_list: at_sign_in_remote_data.approver_id_list,
						o_photo: o_photo,
						action: action,
						notify_list: notify_id,
						new_latitude: new_latitude,
						new_longitude: new_longitude,
						mobile_token: device.uuid,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {

							if (at_sign_in_remote_data.approver_list_flag && at_sign_in_remote_data.approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_remote_data.approver_list));
							}
							if (at_sign_in_remote_data.notify_list_flag && at_sign_in_remote_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(at_sign_in_remote_data.notify_list));
							}

							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_remote_submit');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});

			}
		}
	})


	.factory('atMbIndoorSettingSev', function ($http, $rootScope, $ionicPopup) {
		var at_mb_Indoor_setting_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtMbIndoorSettingData&' + _str,
					timeout: _var_timeout,
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, at_mb_Indoor_setting_data);
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				at_mb_Indoor_setting_data = [];
			},
			getData: function () {
				return at_mb_Indoor_setting_data;
			}
		}
	})

	.factory('atMbIndoorSettingDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $ionicScrollDelegate, $timeout) {
		var at_mb_indoor_setting_detail_data = [];
		var location_data = {};
		return {
			loadData: function (shift_group_id, local_resource) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtMbIndoorSettingDetailData&' + _str,
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);


						_data.default_i_a = _data.i_a;



						if (_data.i_a == "1") {
							document.getElementById("at_mb_indoor_setting_detail_checkbox").checked = true;
							document.getElementById("is_active_content").style.display = "block";
						} else if (_data.i_a == "0") {
							document.getElementById("at_mb_indoor_setting_detail_checkbox").checked = false;
							document.getElementById("is_active_content").style.display = "none";
						}

						if (_data.i_a_o == "1") {
							document.getElementById("is_active").checked = true;
						} else if (_data.i_a_o == "0") {
							document.getElementById("is_active").checked = false;
							document.getElementById("is_active_content_right").style.display = 'none';
						}
						if (_data.i_wf == "1") {
							document.getElementById("is_use_work_flow").checked = true;
						} else if (_data.i_wf == "0") {
							document.getElementById("is_use_work_flow").checked = false;
						}

						if (_data.i_p == "1") {
							document.getElementById("is_need_photo").checked = true;
						} else if (_data.i_p == "0") {
							document.getElementById("is_need_photo").checked = false;
						}

						for (var i = 0; i < _data.setting_detail.length; i++) {
							if (_data.setting_detail[i].valid_mode == '1' || _data.setting_detail[i].valid_mode == '') {
								_data.setting_detail[i].location = '无指定地点';
							}
							if (_data.setting_detail[i].valid_mode == '2' || _data.setting_detail[i].valid_mode == '') {
								_data.setting_detail[i].wifi_value = '无指定WiFi';
							}
						}


						angular.copy(_data, at_mb_indoor_setting_detail_data);

						$timeout(function () {
							$ionicScrollDelegate.scrollTop();
						}, 100);

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				at_mb_indoor_setting_detail_data = [];
			},
			getData: function () {
				return at_mb_indoor_setting_detail_data;
			},

			loadLocationData: function (setting_detail_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtMbIndoorSettingDetailLocationData&' + _str,
					timeout: _var_timeout,
					data: {
						setting_detail_id: setting_detail_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, location_data);






						if (_data.v_m[0].ch) {
							document.getElementById("indoor_setting_img_1").src = local_resource + 'img/icon/selected.png';
							document.getElementById("w_f_content").style.display = "block";
						} else {
							document.getElementById("indoor_setting_img_1").src = local_resource + 'img/icon/noselect.png';
							document.getElementById("w_f_content").style.display = "none";
						}

						if (_data.v_m[1].ch) {
							document.getElementById("indoor_setting_img_2").src = local_resource + 'img/icon/selected.png';
							document.getElementById("loc_content").style.display = "block";
						} else {
							document.getElementById("indoor_setting_img_2").src = local_resource + 'img/icon/noselect.png';
							document.getElementById("loc_content").style.display = "none";
						}



					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			getLocationData: function () {
				return location_data;

			},
			refreshCurrentWifi: function () {
				try {
					network.wifiInfo(function (msg) {

						try {
							if (msg.state == '-1' && ionic.Platform.isIOS()) {
								window.fufuMessageBox("无法获取当前WiFi,请启动WIFI重试", fufu_message_box_duration, function () {});
								return;
							}

							var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
							var wifi_str = "";
							for (var v = 0; v < wifi_arr1.length; v++) {
								if (wifi_arr1[v] != '"') {
									wifi_str = wifi_str + wifi_arr1[v];
								}
							}

							document.getElementById("wifi_name").innerHTML = wifi_str;
							document.getElementById("at_mb_indoor_setting_wifi_mac").value = msg.mac;
						} catch (e) {

						}

					});
				} catch (e) {
					console.log(e.message);
				}
			},
			atMbIndoorSettingDetailSave: function (shift_group_id, valid_mode) {

				if (!(/^[0-9]+$/.test($("#location_deviation").val()))) {
					window.fufuMessageBox("请输入有效的误差范围", fufu_message_box_duration, function () {});
					return;
				}

				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbIndoorSettingDetailSave',
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id,
						is_allow_app_card: at_mb_indoor_setting_detail_data.i_a,
						valid_mode: valid_mode,
						wifi_value: document.getElementById("wifi_name_submit").innerHTML,
						longitude: $("#at_mb_indoor_setting_longitude").val(),
						latitude: $("#at_mb_indoor_setting_latitude").val(),
						location: document.getElementById("sign_in_location").innerHTML,
						location_deviation: $("#location_deviation").val(),
						wifi_mac: document.getElementById("at_mb_indoor_setting_wifi_mac_submit").value,
						is_allow_out_side: at_mb_indoor_setting_detail_data.i_a_o,
						is_use_work_flow: at_mb_indoor_setting_detail_data.i_wf,
						is_sent_location: at_mb_indoor_setting_detail_data.i_l,
						is_need_photo: at_mb_indoor_setting_detail_data.i_p
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			atMbIndoorSettingDetailLocationSave: function (shift_group_id, valid_mode, setting_detail_id) {
				if (valid_mode!="1"&&!(/^[0-9]+$/.test($("#location_deviation").val()))) {
					window.fufuMessageBox("请输入有效的误差范围", fufu_message_box_duration, function () {});
					return;
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbIndoorSettingDetailLocationSave',
					timeout: _var_timeout,
					data: {
						setting_detail_id: setting_detail_id,
						shift_group_id: shift_group_id,
						valid_mode: valid_mode,
						wifi_value: document.getElementById("wifi_name_submit").innerHTML,
						wifi_mac: document.getElementById("at_mb_indoor_setting_wifi_mac_submit").value,
						longitude: $("#at_mb_indoor_setting_longitude").val(),
						latitude: $("#at_mb_indoor_setting_latitude").val(),
						location: document.getElementById("sign_in_location").innerHTML,
						location_deviation: $("#location_deviation").val()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			at_mb_indoor_setting_detail_normal_save: function (shift_group_id, $scope) {

				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbIndoorSettingDetailNormalSave',
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id,
						is_allow_app_card: at_mb_indoor_setting_detail_data.i_a
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								//$ionicHistory.goBack();
								$scope.reload_data(shift_group_id, local_resource);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			at_mb_indoor_setting_detail_outdoor_save: function (shift_group_id) {

				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbIndoorSettingDetailOutdoorSave',
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id,
						is_allow_out_side: at_mb_indoor_setting_detail_data.i_a_o,
						is_use_work_flow: at_mb_indoor_setting_detail_data.i_wf,
						is_sent_location: at_mb_indoor_setting_detail_data.i_l,
						is_need_photo: at_mb_indoor_setting_detail_data.i_p
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			at_mb_indoor_setting_detail_location_delete: function (setting_detail_id, $scope, shift_group_id, local_resource) {

				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbIndoorSettingDetailLocationDelete',
					timeout: _var_timeout,
					data: {
						setting_detail_id: setting_detail_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$scope.reload_data(shift_group_id, local_resource);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
	})


	.factory('atMbOutdoorSettingSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_mb_outdoor_setting_data = [];
		return {
			loadData: function (shift_group_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtMbOutdoorSettingData&' + _str,
					timeout: _var_timeout,
					data: {
						shift_group_id: shift_group_id
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, at_mb_outdoor_setting_data);
						if (at_mb_outdoor_setting_data.i_a == "1") {
							document.getElementById("is_active").checked = true;
						} else if (at_mb_outdoor_setting_data.i_a == "0") {
							document.getElementById("is_active").checked = false;
							document.getElementById("is_active_content").style.display = 'none';
						}
						if (at_mb_outdoor_setting_data.i_wf == "1") {
							document.getElementById("is_use_work_flow").checked = true;
						} else if (at_mb_outdoor_setting_data.i_wf == "0") {
							document.getElementById("is_use_work_flow").checked = false;
						}
						//if(at_mb_outdoor_setting_data.i_l=="1"){
						//    document.getElementById("is_sent_location").checked=true;
						//}else if(at_mb_outdoor_setting_data.i_l=="0"){
						//    document.getElementById("is_sent_location").checked=false;
						//}
						if (at_mb_outdoor_setting_data.i_p == "1") {
							document.getElementById("is_need_photo").checked = true;
						} else if (at_mb_outdoor_setting_data.i_p == "0") {
							document.getElementById("is_need_photo").checked = false;
						}
						if (at_mb_outdoor_setting_data.i_wf_b == "1") {
							document.getElementById("is_use_work_flow_left").checked = true;
						} else if (at_mb_outdoor_setting_data.i_wf_b == "0") {
							document.getElementById("is_use_work_flow_left").checked = false;
						}
						if (at_mb_outdoor_setting_data.is_use_bill_location == "1") {
							document.getElementById("is_use_bill_location").checked = true;
							document.getElementById("is_use_bill_location_div").style.display = 'block';
						} else if (at_mb_outdoor_setting_data.is_use_bill_location == "0") {
							document.getElementById("is_use_bill_location").checked = false;
							document.getElementById("is_use_bill_location_div").style.display = 'none';
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			clearData: function () {
				at_mb_outdoor_setting_data = [];
			},
			getData: function () {
				return at_mb_outdoor_setting_data;
			},
			atMbOutdoorSettingSave: function () {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atMbOutdoorSettingSave',
					timeout: _var_timeout,
					data: {
						setting_id: at_mb_outdoor_setting_data.id,
						is_use_work_flow: at_mb_outdoor_setting_data.i_wf,
						is_sent_location: at_mb_outdoor_setting_data.i_l,
						is_need_photo: at_mb_outdoor_setting_data.i_p,
						is_allow_out_side: at_mb_outdoor_setting_data.i_a,
						is_use_work_flow_bill: at_mb_outdoor_setting_data.i_wf_b,
						is_use_bill_location: at_mb_outdoor_setting_data.is_use_bill_location,
						with_bill_location_deviation: at_mb_outdoor_setting_data.with_bill_location_deviation,
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}

				});
			}
		}
	})


	.factory('atTeamRecordSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout, $ionicScrollDelegate) {
		var at_team_record_data = [];
		var by_type_data = {};
		var by_employee_data = [];
		//var current_page = 1;
		//var end_of_list = {};
		//end_of_list.status = false;
		//var search_control = {};
		//search_control.search_val = '';
		var current_page = 1;
		var end_of_list = {};
		end_of_list.status = false;
		var search_control = {};
		search_control.search_val = '';
		var searchState = {};
		searchState.flag = false;
		searchState.is_show_wrap = true;
		var searchNodata = {};
		searchNodata.is_search = false;

		return {
			loadData: function (current_date, dept_id_list) {
				var _str = '';
				current_page = 1;
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtTeamRecordData&' + _str,
					timeout: _var_timeout,
					data: {
						target_date: current_date,
						dept_id_list: dept_id_list,
						current_page: current_page,
						filter_str: search_control.search_val
					},
					success: function (data, status, headers, config) {

						$rootScope.hideLoading();
						$ionicScrollDelegate.scrollTop();

						var _data = $.parseJSON(data);
						document.getElementById('at_team_record_statistics_content_div').style.display = 'block';
						_data.data1.date_string = current_date.split('-')[1] + '.' + current_date.split('-')[2] + ' ' + _data.data1.dw;

						if (parseInt(_data.data1.early) >= 10) {
							_data.data1.early_class = "adj_10";
						} else {
							_data.data1.early_class = "adj_" + _data.data1.early;
						}
						if (parseInt(_data.data1.late) >= 10) {
							_data.data1.late_class = "adj_10";
						} else {
							_data.data1.late_class = "adj_" + _data.data1.late;
						}
						if (parseInt(_data.data1.lv) >= 10) {
							_data.data1.lv_class = "adj_10";
						} else {
							_data.data1.lv_class = "adj_" + _data.data1.lv;
						}
						if (parseInt(_data.data1.miss) >= 10) {
							_data.data1.miss_class = "adj_10";
						} else {
							_data.data1.miss_class = "adj_" + _data.data1.miss;
						}
						if (parseInt(_data.data1.normal) >= 10) {
							_data.data1.normal_class = "adj_10";
						} else {
							_data.data1.normal_class = "adj_" + _data.data1.normal;
						}
						if (parseInt(_data.data1.ot) >= 10) {
							_data.data1.ot_class = "adj_10";
						} else {
							_data.data1.ot_class = "adj_" + _data.data1.ot;
						}
						if (parseInt(_data.data1.out) >= 10) {
							_data.data1.out_class = "adj_10";
						} else {
							_data.data1.out_class = "adj_" + _data.data1.out;
						}


						/*	if (_data.data2.length < 20) {
								end_of_list.status = true;
							}
							else{
								end_of_list.status = false;
							}
							*/
						current_page++;

						if (typeof (_data.data2.length) == 'undefined') {
							end_of_list.status = true;
						} else {
							if (_data.data2.length < 20) {

								end_of_list.status = true;
							} else {

								end_of_list.status = false;
							}
						}
						angular.copy(_data.data1, by_type_data);
						angular.copy(_data.data2, by_employee_data);
						by_type_data.data_ready = true;
						searchState.flag = true;
						searchState.is_show_wrap = true;



						if (by_type_data.actual / by_type_data.attendance >= 0.5) {
							by_type_data.left_deg = (by_type_data.actual / by_type_data.attendance * 360) - 360;
							by_type_data.right_deg = 0;
						} else {

							if (isNaN(by_type_data.actual / by_type_data.attendance)) {
								by_type_data.left_deg = 180;
								by_type_data.right_deg = 180;
							} else {
								by_type_data.left_deg = 180;
								by_type_data.right_deg = (by_type_data.actual / by_type_data.attendance * 360) + 180;
							}
						}



						$timeout(function () {
							document.getElementById('at_team_record_miss_class_div').style.display = "block";
							document.getElementById('at_team_record_late_class_div').style.display = "block";
							document.getElementById('at_team_record_early_class_div').style.display = "block";
							document.getElementById('at_team_record_ot_class_div').style.display = "block";
							document.getElementById('at_team_record_lv_class_div').style.display = "block";
							document.getElementById('at_team_record_out_class_div').style.display = "block";
							document.getElementById('at_team_record_normal_class_div').style.display = "block";
							document.getElementById('at_team_record_note_div').style.display = "block";

							$ionicScrollDelegate.resize();
						}, 200);

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			loadMoreEmployeeData: function (current_date, dept_id_list, $scope) {
				var _str = '';

				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtTeamRecordChart2Data&' + _str,
					timeout: _var_timeout,
					data: {
						target_date: current_date,
						dept_id_list: dept_id_list,
						current_page: current_page,
						filter_str: search_control.search_val
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);


						if (by_employee_data.length == 0) {
							$timeout(function () {
								angular.copy(_data, by_employee_data);
							}, 0);
						} else {
							if (_data.length != 0) {
								for (var i = 0; i < _data.length; i++) {
									by_employee_data.push(_data[i]);
								}
							}
						}
						current_page++;
						if (_data.length < 20) {
							end_of_list.status = true;
						}
						$scope.$broadcast('scroll.infiniteScrollComplete');
						by_type_data.data_ready = true;

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						$scope.$broadcast('scroll.infiniteScrollComplete');
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			loadSearchEmployeeData: function (current_date, dept_id_list, $scope) {
				var _str = '';
				current_page = 1;


				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtTeamRecordChart2Data&' + _str,
					timeout: _var_timeout,
					data: {
						target_date: current_date,
						dept_id_list: dept_id_list,
						current_page: current_page,
						filter_str: search_control.search_val
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);

						$timeout(function () {
							angular.copy(_data, by_employee_data);
						}, 0);

						current_page++;
						if (_data.length < 20) {
							end_of_list.status = true;
						} else {
							end_of_list.status = false;
						}
						$scope.$broadcast('scroll.infiniteScrollComplete');
						by_type_data.data_ready = true;

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						$scope.$broadcast('scroll.infiniteScrollComplete');
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getData: function () {
				return at_team_record_data;
			},
			getByTypeData: function () {
				return by_type_data;
			},
			getByEmployeeData: function () {
				return by_employee_data;
			},
			clearData: function () {
				at_team_record_data = [];
				by_type_data = {};
				by_employee_data = [];
				current_page = 1;
				end_of_list = {};
				end_of_list.status = false;
				search_control = {};
				search_control.search_val = '';


				/*
				at_team_record_data = [];
				search_control = {};
				search_control.search_val = '';

				current_page = 1;
				end_of_list.status = false;
				*/
			},

			setAtStatus: function (at_status) {
				search_control.at_status = at_status;
			},
			setAtStatusFlag: function (at_status_1, at_status_2, at_status_3, at_status_4, at_status_5, at_status_6, is_show_all) {
				search_control.is_show_leakage_card = at_status_1;
				search_control.is_show_overtime = at_status_2;
				search_control.is_show_leave = at_status_3;
				search_control.is_show_outdoor = at_status_4;
				search_control.is_show_late = at_status_5;
				search_control.is_show_leave_early = at_status_6;
				search_control.is_show_all = is_show_all;
			},
			setSearchVal: function (search_val) {
				search_control.search_val = search_val;
			},

			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("statistics_div").style.display == 'none') {
					return true;
				} else {
					document.getElementById('details_div').style.color = '#53afff';
					document.getElementById('details_div').style.backgroundColor = 'white';
					document.getElementById('details_div').style.border = 'none';
					document.getElementById('statistics_div').style.color = 'white';
					document.getElementById('statistics_div').style.backgroundColor = '#53afff';
					document.getElementById('statistics_div').style.border = '1px solid white';
					document.getElementById('statistics_div').style.borderLeft = 'none';
					document.getElementById('details_content_div').style.display = "block";
					document.getElementById('statistics_content_div').style.display = "none";
					return false;
				}
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_value) {
				$timeout(function () {
					search_control.search_val = search_value;
				})

			},
			setSearchState: function (flag) {
				searchState.flag = flag;
			},
			getSearchValue: function () {
				return search_control;
			},
			getSearchNodata: function () {
				return searchNodata;
			},
			setSearchNodata: function (flag) {
				searchNodata.is_search = flag;
			},
			getEndOfList: function () {
				return end_of_list;
			},
			getSearchState: function () {
				return searchState;
			},
			setIsShowWrap: function (flag) {
				searchState.is_show_wrap = flag;
			}




		}
	})

	.factory('atTeamRecordDetailSev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var at_team_record_detail_data = [];
		return {
			loadData: function (current_date, employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtTeamRecordDetailData&' + _str,
					timeout: _var_timeout,
					data: {
						target_date: current_date,
						employee_no: employee_no
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						angular.copy(_data, at_team_record_detail_data);

					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getData: function () {
				return at_team_record_detail_data;
			},
			clearData: function () {
				at_team_record_detail_data = [];
			}
		}
	})

	.factory('essMyApplyDCMSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, essMyApplyDSev, $timeout) {
		var lv_app_data = {};
		var ess_empl_data = [];
		var imagesObj = {};
		imagesObj.data = '';
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContent&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var essLvPolicy_data = [];
					data.essLvPolicy_index = '';
					document.getElementById('essLvPolicy').innerHTML = '请选择';
					data.essLvPolicy_data_key = '';
					for (var i = 0; i < data.lv_code_id.length; i++) {
						essLvPolicy_data[i] = data.lv_code_id[i];
						if (essLvPolicy_data[i].ck) {
							data.essLvPolicy_index = i;
							document.getElementById('essLvPolicy').innerHTML = essLvPolicy_data[i].value;
						}
					}
					data.essLvPolicy_data = essLvPolicy_data;
					angular.copy(data, lv_app_data);
					if (lv_app_data.is_attachment) {
						document.getElementById('ess_leave_apply_upload_div').style.display = "block";
					}
					/*
			if (lv_app_data.attachment != ''){
                document.getElementById('ess_leave_apply_upload_mini_photo').style.display = "block";
                $('#ess_leave_apply_upload_mini_photo').attr("src", lv_app_data.attachment);
                document.getElementById('ess_leave_apply_upload_text').innerText='更改图片';
                $('#ess_leave_apply_upload_icon1').attr("src", local_resource+'img/icon/upload_modify.png');
                document.getElementById('ess_leave_apply_upload_icon2').style.display = "none";
                document.getElementById('ess_leave_apply_upload_text').style.marginTop = "1.8em";
			}
			*/
					for (var i = 0; i < lv_app_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + lv_app_data.notify_list[i].user_id;
						lv_app_data.notify_list[i].flag = 1;
						if (i < lv_app_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}
					if (lv_app_data.is_standard_wf == '1') {
						var approver_list = [];
						for (var i = 0; i < lv_app_data.approver_list.length; i++) {
							approver_list.push(lv_app_data.approver_list[i + 1])
							if (i == lv_app_data.approver_list.length - 2) {
								break;
							}
						}
						$scope.approver_list = approver_list;
						document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
					} else {
						if (lv_app_data.approver_list.length > 0) {
							$scope.select_user_id = lv_app_data.approver_list[lv_app_data.approver_list.length - 1].user_id;
							lv_app_data.approver_list.splice(0, lv_app_data.approver_list.length - 1);
							lv_app_data.approver_list[0].flag = 1;
						}

						$scope.approver_list = lv_app_data.approver_list;
						document.getElementById('approver_list_div').style.width = (lv_app_data.approver_list.length + 1) * 100 + 20 + 'px';
					}
					document.getElementById('notify_list_div').style.width = (lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';

					if (lv_app_data.attachment != '') {
						imagesObj.data = lv_app_data.attachment;
						//alert(imagesObj.data);
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_app_data = {};
				imagesObj = {};
				imagesObj.data = '';
			},

			getData: function () {
				return lv_app_data;
			},
			getImageData: function () {
				return imagesObj;
			},

			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);
					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
			changeEssLvPolicy: function ($scope, lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: lv_app_data.start_date,
						s_time: lv_app_data.start_time,
						e_date: lv_app_data.end_date,
						e_time: lv_app_data.end_time,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(lv_app_data, data);
					if (lv_app_data.is_attachment) {
						document.getElementById('ess_leave_apply_upload_div').style.display = "block";
						$scope.is_require_upload = true;
					} else {
						document.getElementById('ess_leave_apply_upload_div').style.display = "none";
						$scope.is_require_upload = false;
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			saveApply: function (approve_list, notify_list, updated_o_attachment) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				if (approve_list == '') {
					approve_list = lv_app_data.approver_list[lv_app_data.approver_list.length - 1].user_id;
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						is_standard_wf: lv_app_data.is_standard_wf,
						approver_id_list: lv_app_data.approver_id_list,
						operate_date: lv_app_data.operate_date,
						employee_no: lv_app_data.employee_no,
						lv_code_key: lv_app_data.lv_code_key,
						lv_code_id: lv_app_data.default_lv_code_id,
						task_id: lv_app_data.task_id,
						process_id: '0',
						start_date: lv_app_data.start_date,
						start_time: lv_app_data.start_time,
						end_date: lv_app_data.end_date,
						end_time: lv_app_data.end_time,
						duration: lv_app_data.duration,
						lv_unit: lv_app_data.lv_unit,
						apply_remark: lv_app_data.apply_remark,
						approve_remark: lv_app_data.approve_remark,
						notify_list: notify_list,
						actor: approve_list,
						attachment: '',
						o_attachment: updated_o_attachment,
						old_lv_code_id: lv_app_data.old_lv_code_id,
						old_lv_code_key: lv_app_data.old_lv_code_key,
						old_duration: lv_app_data.old_duration,
						show_type: lv_app_data.show_type,
						biz_type_key: lv_app_data.biz_type_key,
						wf_app_table: lv_app_data.wf_app_table,
						action: 'modify',
						process_instance: lv_app_data.process_instance,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_leave_modify');
								essMyApplyDSev.loadData('leave', 'UC');
								$ionicHistory.goBack(-2);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			saveApplyWithPhoto: function (approve_list, notify_list, num_of_upload, updated_o_attachment) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				if (approve_list == '') {
					approve_list = lv_app_data.approver_list[lv_app_data.approver_list.length - 1].user_id;
				}
				$rootScope.showLoading();
				var options = new FileUploadOptions();
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}


				params.is_standard_wf = lv_app_data.is_standard_wf;
				params.approver_id_list = lv_app_data.approver_id_list;
				params.employee_no = lv_app_data.employee_no;
				params.lv_code_key = lv_app_data.lv_code_key;
				params.lv_code_id = lv_app_data.default_lv_code_id;
				params.task_id = lv_app_data.task_id;
				params.process_id = '0';
				params.start_date = lv_app_data.start_date;
				params.start_time = lv_app_data.start_time;
				params.end_date = lv_app_data.end_date;
				params.end_time = lv_app_data.end_time;
				params.duration = lv_app_data.duration;
				params.lv_unit = lv_app_data.lv_unit;
				params.apply_remark = lv_app_data.apply_remark;
				params.approve_remark = lv_app_data.approve_remark;
				params.notify_list = notify_list;
				params.actor = approve_list;
				params.attachment = '';
				params.o_attachment = updated_o_attachment;
				params.old_lv_code_id = lv_app_data.old_lv_code_id;
				params.old_lv_code_key = lv_app_data.old_lv_code_key;
				params.old_duration = lv_app_data.old_duration;
				params.show_type = lv_app_data.show_type;
				params.biz_type_key = lv_app_data.biz_type_key;
				params.wf_app_table = lv_app_data.wf_app_table;
				params.action = 'modify';
				params.process_instance = lv_app_data.process_instance;
				params.is_require_upload = '1'
				params.attachment_num = num_of_upload;
				params.time_zone = $rootScope.get_utc_time_zone();
				options.params = params;
				var ft = new FileTransfer();

				$timeout(function () {
					ft.uploadMore(
						imagesObj.data,
						window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
						function (data) {
							try {
								$rootScope.hideLoading();
								fufu_processing = false;
								var response = $.parseJSON(data);
								if (response.flag == '0') {
									window.fufuSuccessBox(response.message, fufu_success_message_box_duration, function () {
										fufuMobclickAgent('click_leave_modify');
										ft.clearCacheImage();
										$ionicHistory.goBack(-2);
									});
								} else {
									window.fufuMessageBox(response.message, fufu_message_box_duration, function () {});
								}
							} catch (e) {
								fufu_processing = false;
								window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
							}
						},
						function (error) {
							$rootScope.hideLoading();
							fufu_processing = false;
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}, options);
				}, 0);

			}

		}
	})



	.factory('essMyApprovalSev', function ($http, $rootScope, $ionicPopup) {
		var ess_my_approval_data = [];
		return {
			loadData: function (c_date, flag) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					angular.copy(data, ess_my_approval_data);
					$rootScope.hideLoading();
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approval_data = [];
			},
			getData: function () {
				return ess_my_approval_data;
			}
		}
	})



	.factory('essMyApprovalDSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_approvalD_data = [];
		var ess_my_approvalD_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_data);
					ess_my_approvalD_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_other_data);
					ess_my_approvalD_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_approvalD_data;
			},
			getOtherData: function () {
				return ess_my_approvalD_other_data;
			},
			clearData: function () {
				ess_my_approvalD_data = [];
				ess_my_approvalD_other_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyApprovalDSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDBack").style.display = 'block';
					return false;
				}
			},

		}
	})


	.factory('essMyApprovalDetailsContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApprovalDSev, homeMessageContentSev) {
		var ess_my_approvalD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, my_app_result, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContent&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					angular.copy(data, ess_my_approvalD_data);
					document.getElementById('_ess_my_apply_d1').innerHTML = ess_my_approvalD_data.start_date;
					document.getElementById('_ess_my_apply_d2').innerHTML = ess_my_approvalD_data.end_date;
					document.getElementById('_ess_my_apply_t1').innerHTML = ess_my_approvalD_data.start_time;
					document.getElementById('_ess_my_apply_t2').innerHTML = ess_my_approvalD_data.end_time;
					ess_my_approvalD_data.notify_text = [];
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						ess_my_approvalD_data.notify_text.push(ess_my_approvalD_data.notify_list[i].name)
					}
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_approvalD_data.notify_list[i].user_id;
						ess_my_approvalD_data.notify_list[i].flag = 1;
						if (i < ess_my_approvalD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}

					document.getElementById('notify_text').innerText = ess_my_approvalD_data.notify_text;
					document.getElementById('notify_list_div').style.width = (ess_my_approvalD_data.notify_list.length + 1) * 100 + 20 + 'px';
					if (ess_my_approvalD_data.attachment != '') {
						ess_my_approvalD_data.attachment_array = ess_my_approvalD_data.attachment.split(",");
					}
					$rootScope.hideLoading();
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approvalD_data = {};
			},
			getData: function () {
				return ess_my_approvalD_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					angular.extend(ess_my_applyD_data, data);
					$rootScope.hideLoading();
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					angular.copy(data, ess_empl_data);
					$rootScope.hideLoading();
					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
			applyReject: function (actor, my_app_result, notify_list, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					timeout: _var_timeout,
					data: {
						employee_no: ess_my_approvalD_data.employee_no,
						operate_date: ess_my_approvalD_data.operate_date,
						lv_code_id: ess_my_approvalD_data.lv_code_id,
						lv_code_key: ess_my_approvalD_data.lv_code_key,
						task_id: ess_my_approvalD_data.task_id,
						start_date: ess_my_approvalD_data.start_date,
						start_time: ess_my_approvalD_data.start_time,
						end_date: ess_my_approvalD_data.end_date,
						end_time: ess_my_approvalD_data.end_time,
						duration: ess_my_approvalD_data.duration,
						lv_unit: ess_my_approvalD_data.lv_unit,
						approve_remark: $("#leave_approval_remark_textarea").val(),
						apply_remark: ess_my_approvalD_data.apply_remark,
						notify_list: notify_list,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						actor: actor,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Reject',
						process_instance: ess_my_approvalD_data.process_instance,
						process_id: 0,
						is_require_upload: 0,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()


					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_leave_approve');
								if (from_source == "my_approval") {
									essMyApprovalDSev.loadData("leave", my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}


								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (actor, my_app_result, notify_list, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						employee_no: ess_my_approvalD_data.employee_no,
						operate_date: ess_my_approvalD_data.operate_date,
						lv_code_id: ess_my_approvalD_data.lv_code_id,
						lv_code_key: ess_my_approvalD_data.lv_code_key,
						task_id: ess_my_approvalD_data.task_id,
						start_date: ess_my_approvalD_data.start_date,
						start_time: ess_my_approvalD_data.start_time,
						notify_list: notify_list,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						end_date: ess_my_approvalD_data.end_date,
						end_time: ess_my_approvalD_data.end_time,
						duration: ess_my_approvalD_data.duration,
						lv_unit: ess_my_approvalD_data.lv_unit,
						approve_remark: $("#leave_approval_remark_textarea").val(),
						apply_remark: ess_my_approvalD_data.apply_remark,
						actor: actor,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Approve',
						process_instance: ess_my_approvalD_data.process_instance,
						process_id: 0,
						is_require_upload: 0,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_leave_approve');
								if (from_source == "my_approval") {
									essMyApprovalDSev.loadData("leave", my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}


		}
	})

	.factory('essMyApprovalDFSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_approvalDF_data = [];
		var ess_my_approvalDF_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailFieldwork&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDF_data);
					ess_my_approvalDF_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return ess_my_approvalDF_data;
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailFieldwork&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDF_other_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getOtherData: function () {
				return ess_my_approvalDF_other_data;
			},
			clearData: function () {
				ess_my_approvalDF_data = [];
				ess_my_approvalDF_other_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false
				if (document.getElementById("essMyApprovalDFSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDFSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDFBack").style.display = 'block';
					return false;
				}
			},
			clearWorkOutStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false
				if (document.getElementById("essMyApprovalDOFSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDOFSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDOFBack").style.display = 'block';
					return false;
				}
			},

		}
	})



	.factory('essMyApprovalDFCSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApprovalDFSev, homeMessageContentSev) {
		var ess_my_approvalD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, my_app_result, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContentfieldwork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_data);
					ess_my_approvalD_data.notify_text = [];
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						ess_my_approvalD_data.notify_text.push(ess_my_approvalD_data.notify_list[i].name)
					}
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_approvalD_data.notify_list[i].user_id;
						ess_my_approvalD_data.notify_list[i].flag = 1;
						if (i < ess_my_approvalD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}

					document.getElementById('notify_text').innerText = ess_my_approvalD_data.notify_text;
					document.getElementById('notify_list_div').style.width = (ess_my_approvalD_data.notify_list.length + 1) * 100 + 20 + 'px';

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approvalD_data = {};
			},
			getData: function () {
				return ess_my_approvalD_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					angular.extend(ess_my_applyD_data, data);
					$rootScope.hideLoading();

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			applyReject: function (actor, notify_id, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					timeout: _var_timeout,
					data: {
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						operate_date: ess_my_approvalD_data.operate_date,
						location: ess_my_approvalD_data.location,
						longitude: ess_my_approvalD_data.longitude,
						latitude: ess_my_approvalD_data.latitude,
						photo: ess_my_approvalD_data.photo,
						reason: ess_my_approvalD_data.reason,
						apply_remark: '',
						approval_remark: $("#remark_textarea").val(),
						is_fieldwork: "1",
						i_wf: '1',
						//i_l: ess_my_approvalD_data.i_l,
						//i_p: ess_my_approvalD_data.i_p,
						customer: ess_my_approvalD_data.customer,
						location_detail: ess_my_approvalD_data.location_detail,
						actor: actor,
						employee_no: ess_my_approvalD_data.employee_no,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						is_require_upload: '0',
						o_photo: '',
						action: 'Reject',
						notify_list: notify_id,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						process_instance: ess_my_approvalD_data.process_instance,
						task_id: ess_my_approvalD_data.task_id,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_fieldwork_approve');
								if (from_source == "my_approval") {
									essMyApprovalDFSev.loadData('fieldwork', 'UC');
								} else {
									homeMessageContentSev.loadData("process_approval");
								}

								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (actor, notify_id, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInOurDoorSave',
					data: {
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						operate_date: ess_my_approvalD_data.operate_date,
						location: ess_my_approvalD_data.location,
						longitude: ess_my_approvalD_data.longitude,
						latitude: ess_my_approvalD_data.latitude,
						photo: ess_my_approvalD_data.photo,
						reason: ess_my_approvalD_data.reason,
						apply_remark: '',
						approval_remark: $("#remark_textarea").val(),
						is_fieldwork: "1",
						i_wf: '1',
						notify_list: notify_id,
						//i_l: ess_my_approvalD_data.i_l,
						//i_p: ess_my_approvalD_data.i_p,
						employee_no: ess_my_approvalD_data.employee_no,
						customer: ess_my_approvalD_data.customer,
						location_detail: ess_my_approvalD_data.location_detail,
						actor: actor,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						is_require_upload: '0',
						o_photo: '',
						action: 'Approve',
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						process_instance: ess_my_approvalD_data.process_instance,
						task_id: ess_my_approvalD_data.task_id,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_fieldwork_approve');
								if (from_source == "my_approval") {
									essMyApprovalDFSev.loadData('fieldwork', 'UC');
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})
	.factory('essOtApplySev', function ($http, $rootScope, $ionicPopup, $ionicHistory, essMyOtApplyDSev) {
		var lv_app_data = {};
		var ess_empl_data = [];
		var time_list_ot_apply = [];
		return {
			loadData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getEssOtApyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var essOtPolicy_data = [];
					data.essOtPolicy_index = '';
					document.getElementById('essOtPolicy').innerHTML = '请选择';
					data.essOtPolicy_data_key = '';
					for (var i = 0; i < data.ot_code.length; i++) {
						essOtPolicy_data[i] = data.ot_code[i];
						essOtPolicy_data[i].key = data.ot_code[i].key_;
						essOtPolicy_data[i].value = data.ot_code[i].value_;
						if (essOtPolicy_data[i].check) {
							data.essOtPolicy_index = i;
							document.getElementById('essOtPolicy').innerHTML = essOtPolicy_data[i].value;
						}
					}
					data.essOtPolicy_data = essOtPolicy_data;

					data._ot_hours = data.ot_hours;
					document.getElementById("ot_hours").innerHTML = data.ot_hours + '小时';
					//document.getElementById("add_ot_hours").innerHTML=data.ot_hours+'小时';
					data._approver_list = data.approver_list;
					if (data.approver_list_flag) {

					} else {
						data._approver_list = data.approver_list;
						ess_empl_data.approver_id_list = data.approver_id_list;
					}

					if (data.approver_list_flag) {
						if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
							data._approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
							for (var i = 0; i < data._approver_list.length; i++) {
								$scope.select_user_id += data._approver_list[i].user_id;
								if (i <= data._approver_list.length - 2) {
									$scope.select_user_id += ',';
								}
							}
						}
					}

					if (data.notify_list_flag) {
						if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {
							data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);
							for (var i = 0; i < data.notify_list.length; i++) {
								$scope.select_notify_id += data.notify_list[i].user_id;
								if (i <= data.notify_list.length - 2) {
									$scope.select_notify_id += ',';
								}
							}
						}
					}
					document.getElementById('approver_list_div').style.width = (data._approver_list.length + 1) * 100 + 20 + 'px';
					document.getElementById('notify_list_div').style.width = (data.notify_list.length + 1) * 100 + 20 + 'px';


					if (data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: data.first_out,
							in_need_clock: data.first_out_need_clock,
							out: data.second_in,
							out_need_clock: data.second_in_need_clock,
							is_need: true
						})
					}
					if (data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: data.second_out,
							in_need_clock: data.second_out_need_clock,
							out: data.third_in,
							out_need_clock: data.third_in_need_clock,
							is_need: true
						})
					}
					if (data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: data.third_out,
							in_need_clock: data.third_out_need_clock,
							out: data.forth_in,
							out_need_clock: data.forth_in_need_clock,
							is_need: true
						})
					}
					if (data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: data.forth_out,
							in_need_clock: data.forth_out_need_clock,
							out: data.fifth_in,
							out_need_clock: data.fifth_in_need_clock,
							is_need: true
						})
					}
					if (data.ot_need_clock == '1') {
						data._ot_need_clock = true;
					} else {
						data._ot_need_clock = false;
					}
					if (data.ot_break_need_clock == '1') {
						data._ot_break_need_clock = true;
					} else {
						data._ot_break_need_clock = false;
					}

					data.add_time_first_in = data.first_in;
					data.add_time_last_out = data.first_out;
					data.time_first_in = data.first_in;
					data.time_last_out = data.first_out;

					if (data.fifth_in != '') {
						data.time_last_out = data.fifth_out;
						data.add_time_last_out = data.fifth_out;
						data.add_time_last_out_need_clock = data.fifth_out_need_clock;
					} else if (data.forth_in != '') {
						data.time_last_out = data.forth_out;
						data.add_time_last_out = data.forth_out;
						data.add_time_last_out_need_clock = data.forth_out_need_clock;
					} else if (data.third_in != '') {
						data.time_last_out = data.third_out;
						data.add_time_last_out = data.third_out;
						data.add_time_last_out_need_clock = data.third_out_need_clock;
					} else if (data.second_in != '') {
						data.time_last_out = data.second_out;
						data.add_time_last_out = data.second_out;
						data.add_time_last_out_need_clock = data.second_out_need_clock;
					} else {
						data.time_last_out = data.first_out;
						data.add_time_last_out = data.first_out;
						data.add_time_last_out_need_clock = data.first_out_need_clock;
					}

					angular.copy(data, lv_app_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			loadModifyData: function (p_inst, show_type, task_id, $scope) {
				//alert("1");
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOtApplyDetailContent&' + _str + '&process_instance=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var essOtPolicy_data = [];
					data.essOtPolicy_index = '';
					document.getElementById('essOtPolicy').innerHTML = '请选择';
					data.essOtPolicy_data_key = '';
					for (var i = 0; i < data.ot_code.length; i++) {
						essOtPolicy_data[i] = data.ot_code[i];
						essOtPolicy_data[i].key = data.ot_code[i].key_;
						essOtPolicy_data[i].value = data.ot_code[i].value_;
						if (essOtPolicy_data[i].check) {
							data.essOtPolicy_index = i;
							document.getElementById('essOtPolicy').innerHTML = essOtPolicy_data[i].value;
						}
					}
					data.essOtPolicy_data = essOtPolicy_data;

					angular.copy(data, lv_app_data);
					lv_app_data._ot_hours = lv_app_data.ot_hours;
					document.getElementById("ot_hours").innerHTML = lv_app_data.ot_hours + '小时';


					for (var i = 0; i < lv_app_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + lv_app_data.notify_list[i].user_id;
						lv_app_data.notify_list[i].flag = 1;
						if (i < lv_app_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}
					if (lv_app_data.is_standard_wf == '1') {

						var approver_list = [];
						for (var i = 0; i < lv_app_data.approver_list.length; i++) {
							approver_list.push(lv_app_data.approver_list[i + 1])
							if (i == lv_app_data.approver_list.length - 2) {
								break;
							}
						}
						lv_app_data._approver_list = approver_list;
						document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
					} else {
						if (lv_app_data.approver_list.length > 0) {
							$scope.select_user_id = lv_app_data.approver_list[lv_app_data.approver_list.length - 1].user_id;
							lv_app_data.approver_list.splice(0, lv_app_data.approver_list.length - 1);
							lv_app_data.approver_list[0].flag = 1;
						}
						lv_app_data._approver_list = lv_app_data.approver_list;
						document.getElementById('approver_list_div').style.width = (lv_app_data.approver_list.length + 1) * 100 + 20 + 'px';
					}

					document.getElementById('notify_list_div').style.width = (lv_app_data.notify_list.length + 1) * 100 + 20 + 'px';

					if (lv_app_data.ot_need_clock == '1') {
						lv_app_data._ot_need_clock = true;
					} else {
						lv_app_data._ot_need_clock = false;
					}
					if (lv_app_data.ot_break_need_clock == '1') {
						lv_app_data._ot_break_need_clock = true;
					} else {
						lv_app_data._ot_break_need_clock = false;
					}

					lv_app_data.add_time_first_in = lv_app_data.first_in;
					lv_app_data.add_time_last_out = lv_app_data.first_out;
					lv_app_data.time_first_in = lv_app_data.first_in;
					lv_app_data.time_last_out = lv_app_data.first_out;
					if (lv_app_data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: lv_app_data.first_out,
							in_need_clock: lv_app_data.first_out_need_clock,
							out: lv_app_data.second_in,
							out_need_clock: lv_app_data.second_in_need_clock,
							is_need: true
						})
					}
					if (lv_app_data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: lv_app_data.second_out,
							in_need_clock: lv_app_data.second_out_need_clock,
							out: lv_app_data.third_in,
							out_need_clock: lv_app_data.third_in_need_clock,
							is_need: true
						})
					}
					if (lv_app_data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: lv_app_data.third_out,
							in_need_clock: lv_app_data.third_out_need_clock,
							out: lv_app_data.forth_in,
							out_need_clock: lv_app_data.forth_in_need_clock,
							is_need: true
						})
					}
					if (lv_app_data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: lv_app_data.forth_out,
							in_need_clock: lv_app_data.forth_out_need_clock,
							out: lv_app_data.fifth_in,
							out_need_clock: lv_app_data.fifth_in_need_clock,
							is_need: true
						})
					}

					if (lv_app_data.fifth_in != '') {
						lv_app_data.time_last_out = lv_app_data.fifth_out;
						lv_app_data.add_time_last_out = lv_app_data.fifth_out;
						lv_app_data.add_time_last_out_need_clock = lv_app_data.fifth_out_need_clock;
					} else if (lv_app_data.forth_in != '') {
						lv_app_data.time_last_out = lv_app_data.forth_out;
						lv_app_data.add_time_last_out = lv_app_data.forth_out;
						lv_app_data.add_time_last_out_need_clock = lv_app_data.forth_out_need_clock;
					} else if (lv_app_data.third_in != '') {
						lv_app_data.time_last_out = lv_app_data.third_out;
						lv_app_data.add_time_last_out = lv_app_data.third_out;
						lv_app_data.add_time_last_out_need_clock = lv_app_data.third_out_need_clock;
					} else if (lv_app_data.second_in != '') {
						lv_app_data.time_last_out = lv_app_data.second_out;
						lv_app_data.add_time_last_out = lv_app_data.second_out;
						lv_app_data.add_time_last_out_need_clock = lv_app_data.second_out_need_clock;
					} else {
						lv_app_data.time_last_out = lv_app_data.first_out;
						lv_app_data.add_time_last_out = lv_app_data.first_out;
						lv_app_data.add_time_last_out_need_clock = lv_app_data.first_out_need_clock;
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_app_data = {};
				time_list_ot_apply = [];
			},
			getData: function () {
				return lv_app_data;
			},
			getTimeList: function () {
				return time_list_ot_apply;
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);
					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},

			saveApply: function (approve_list, notify_list, card_times, submit_flag) {

				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					data: {
						first_in: lv_app_data.first_in,
						first_in_need_clock: lv_app_data.first_in_need_clock ? '1' : '0',
						first_out: lv_app_data.first_out,
						first_out_need_clock: lv_app_data.first_out_need_clock ? '1' : '0',
						second_in: lv_app_data.second_in,
						second_in_need_clock: lv_app_data.second_in_need_clock ? '1' : '0',
						second_out: lv_app_data.second_out,
						second_out_need_clock: lv_app_data.second_out_need_clock ? '1' : '0',
						third_in: lv_app_data.third_in,
						third_in_need_clock: lv_app_data.third_in_need_clock ? '1' : '0',
						third_out: lv_app_data.third_out,
						third_out_need_clock: lv_app_data.third_out_need_clock ? '1' : '0',
						forth_in: lv_app_data.forth_in,
						forth_in_need_clock: lv_app_data.forth_in_need_clock ? '1' : '0',
						forth_out: lv_app_data.forth_out,
						forth_out_need_clock: lv_app_data.forth_out_need_clock ? '1' : '0',
						fifth_in: lv_app_data.fifth_in,
						fifth_in_need_clock: lv_app_data.fifth_in_need_clock ? '1' : '0',
						fifth_out: lv_app_data.fifth_out,
						fifth_out_need_clock: lv_app_data.fifth_out_need_clock ? '1' : '0',
						card_times: card_times,
						ot_valid_min: lv_app_data.ot_valid_min,
						ot_min_unit: lv_app_data.ot_min_unit,
						is_need_first: lv_app_data.is_need_first,
						is_need_second: lv_app_data.is_need_second,
						is_need_ot: lv_app_data.is_need_ot,
						ot_hours: lv_app_data.ot_hours,
						ot_code: lv_app_data.ot_code_key,
						ot_date: lv_app_data.ot_date,
						task_id: '',
						process_id: lv_app_data.process_id,
						employee_no: lv_app_data.employee_no,
						apply_remark: $("#ot_apply_remark").val(),
						notify_list: notify_list,
						actor: approve_list,
						submit_flag: submit_flag,
						show_type: lv_app_data.show_type,
						biz_type_key: lv_app_data.biz_type_key,
						wf_app_table: lv_app_data.wf_app_table,
						is_standard_wf: lv_app_data.is_standard_wf,
						approver_id_list: lv_app_data.approver_id_list,
						action: 'submit',
						process_instance: '',
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							if (lv_app_data.approver_list_flag && lv_app_data._approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data._approver_list));
							}
							if (lv_app_data.notify_list_flag && lv_app_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data.notify_list));
							}

							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_apply');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			saveModifyApply: function (approve_list, notify_list, card_times, submit_flag) {
				if (fufu_processing) {
					return;
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					data: {
						first_in: lv_app_data.first_in,
						first_in_need_clock: lv_app_data.first_in_need_clock ? '1' : '0',
						first_out: lv_app_data.first_out,
						first_out_need_clock: lv_app_data.first_out_need_clock ? '1' : '0',
						second_in: lv_app_data.second_in,
						second_in_need_clock: lv_app_data.second_in_need_clock ? '1' : '0',
						second_out: lv_app_data.second_out,
						second_out_need_clock: lv_app_data.second_out_need_clock ? '1' : '0',
						third_in: lv_app_data.third_in,
						third_in_need_clock: lv_app_data.third_in_need_clock ? '1' : '0',
						third_out: lv_app_data.third_out,
						third_out_need_clock: lv_app_data.third_out_need_clock ? '1' : '0',
						forth_in: lv_app_data.forth_in,
						forth_in_need_clock: lv_app_data.forth_in_need_clock ? '1' : '0',
						forth_out: lv_app_data.forth_out,
						forth_out_need_clock: lv_app_data.forth_out_need_clock ? '1' : '0',
						fifth_in: lv_app_data.fifth_in,
						fifth_in_need_clock: lv_app_data.fifth_in_need_clock ? '1' : '0',
						fifth_out: lv_app_data.fifth_out,
						fifth_out_need_clock: lv_app_data.fifth_out_need_clock ? '1' : '0',
						card_times: card_times,
						ot_valid_min: lv_app_data.ot_valid_min,
						ot_min_unit: lv_app_data.ot_min_unit,
						is_need_first: lv_app_data.is_need_first,
						is_need_second: lv_app_data.is_need_second,
						is_need_ot: lv_app_data.is_need_ot,
						ot_hours: lv_app_data.ot_hours,
						employee_no: lv_app_data.employee_no,
						ot_code: lv_app_data.ot_code_key,
						ot_date: lv_app_data.ot_date,
						task_id: lv_app_data.task_id,
						process_id: '0',
						submit_flag: submit_flag,
						apply_remark: $("#ot_apply_remark").val(),
						notify_list: notify_list,
						actor: approve_list,
						show_type: lv_app_data.show_type,
						biz_type_key: lv_app_data.biz_type_key,
						wf_app_table: lv_app_data.wf_app_table,
						is_standard_wf: lv_app_data.is_standard_wf,
						approver_id_list: lv_app_data.approver_id_list,
						action: 'modify',
						process_instance: lv_app_data.process_instance,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_modify');
								essMyOtApplyDSev.loadData('overtime', 'UC');
								$ionicHistory.goBack(-2);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			add_time_save: function (add_time_list, $scope, is_submit, submit_flag, card_times) {

				$rootScope.showLoading();
				var first_in = '';
				var first_out = '';
				var second_in = '';
				var second_out = '';
				var third_in = '';
				var third_out = '';
				var forth_in = '';
				var forth_out = '';
				var fifth_in = '';
				var fifth_out = '';
				var is_need_first = false;
				var is_need_second = false;
				var is_need_ot = false;
				var first_in_need_clock = lv_app_data.first_in_need_clock;
				var first_out_need_clock = false;
				var second_in_need_clock = false;
				var second_out_need_clock = false;
				var third_in_need_clock = false;
				var third_out_need_clock = false;
				var forth_in_need_clock = false;
				var forth_out_need_clock = false;
				var fifth_in_need_clock = false;
				var fifth_out_need_clock = false;

				if (card_times == '1') {
					first_out_need_clock = lv_app_data.first_out_need_clock;
				} else if (card_times == '2') {
					first_out_need_clock = lv_app_data.second_in_need_clock;
					second_out_need_clock = lv_app_data.first_out_need_clock;
				} else if (card_times == '3') {

					first_out_need_clock = lv_app_data.second_in_need_clock;
					third_out_need_clock = lv_app_data.first_out_need_clock;
				} else if (card_times == '4') {
					first_out_need_clock = lv_app_data.second_in_need_clock;
					forth_out_need_clock = lv_app_data.first_out_need_clock;
				} else if (card_times == '5') {
					first_out_need_clock = lv_app_data.second_in_need_clock;
					fifth_out_need_clock = lv_app_data.first_out_need_clock;
				}

				if (add_time_list.length == 0) {
					first_in = lv_app_data.first_in;
					first_out = lv_app_data.first_out
				}
				for (var i = 0; i <= add_time_list.length; i++) {
					if (i == 0) {
						first_in = lv_app_data.add_time_first_in;
						first_out = lv_app_data.add_time_last_out;
						//first_out_need_clock=lv_app_data.first_out_need_clock;
					} else if (i == 1) {
						first_out = add_time_list[i - 1].in;
						second_in = add_time_list[i - 1].out;
						second_out = lv_app_data.add_time_last_out;

						//second_in_need_clock = add_time_list[1].in_need_clock;
						//second_out_need_clock=lv_app_data.first_out_need_clock;
					} else if (i == 2) {
						second_out = add_time_list[i - 1].in;
						third_in = add_time_list[i - 1].out;
						third_out = lv_app_data.add_time_last_out;
						//third_out_need_clock=lv_app_data.first_out_need_clock;
					} else if (i == 3) {
						third_out = add_time_list[i - 1].in;
						forth_in = add_time_list[i - 1].out;
						forth_out = lv_app_data.add_time_last_out;
						//forth_out_need_clock=lv_app_data.first_out_need_clock;
					} else if (i == 4) {
						forth_out = add_time_list[i - 1].in;
						fifth_in = add_time_list[i - 1].out;
						fifth_out = lv_app_data.add_time_last_out;
						//fifth_out_need_clock=lv_app_data.first_out_need_clock;
					}
				}
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otCardTimeValidation', {}, {
					timeout: _var_timeout,
					params: {
						ot_code: lv_app_data.ot_code_key,
						first_in: first_in,
						first_out: first_out,
						second_in: second_in,
						second_out: second_out,
						third_in: third_in,
						third_out: third_out,
						forth_in: forth_in,
						forth_out: forth_out,
						fifth_in: fifth_in,
						fifth_out: fifth_out,
						card_times: card_times,
						ot_valid_min: lv_app_data.ot_valid_min,
						ot_min_unit: lv_app_data.ot_min_unit,
						ot_date: lv_app_data.ot_date,
						process_instance: '0',
						submit_flag: submit_flag,
						is_standard_wf: lv_app_data.is_standard_wf,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (lv_app_data.approver_list_flag) {

					} else {
						lv_app_data._approver_list = lv_app_data.approver_list;
						ess_empl_data.approver_id_list = lv_app_data.approver_id_list;
					}
					lv_app_data._approver_list = lv_app_data.approver_list;
					if (data.flag == '0' && is_submit) {

						//lv_app_data.approver_id_list=data.approver_id_list;
						//lv_app_data.approver_list=data.approver_list;
						lv_app_data.first_in = first_in;
						lv_app_data.first_out = first_out;
						lv_app_data.second_in = second_in;
						lv_app_data.second_out = second_out;
						lv_app_data.third_in = third_in;
						lv_app_data.third_out = third_out;
						lv_app_data.forth_in = forth_in;
						lv_app_data.forth_out = forth_out;
						lv_app_data.fifth_in = fifth_in;
						lv_app_data.fifth_out = fifth_out;
						lv_app_data.is_need_first = is_need_first;
						lv_app_data.is_need_second = is_need_second;
						lv_app_data.is_need_ot = is_need_ot;
						lv_app_data.first_in_need_clock = first_in_need_clock;
						lv_app_data.first_out_need_clock = first_out_need_clock;
						lv_app_data.second_in_need_clock = second_in_need_clock;
						lv_app_data.second_out_need_clock = second_out_need_clock;
						lv_app_data.third_in_need_clock = third_in_need_clock;
						lv_app_data.third_out_need_clock = third_out_need_clock;
						lv_app_data.forth_in_need_clock = forth_in_need_clock;
						lv_app_data.forth_out_need_clock = forth_out_need_clock;
						lv_app_data.fifth_in_need_clock = fifth_in_need_clock;
						lv_app_data.fifth_out_need_clock = fifth_out_need_clock;




						lv_app_data.card_times = card_times;
						if (card_times == 1) {
							lv_app_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							lv_app_data.first_out_need_clock = document.getElementById('first_out_need_clock').checked;

						} else if (card_times == 2) {
							lv_app_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							lv_app_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							lv_app_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							lv_app_data.second_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = lv_app_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = lv_app_data.second_in_need_clock;
						} else if (card_times == 3) {

							lv_app_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							lv_app_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							lv_app_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							lv_app_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							lv_app_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							lv_app_data.third_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = lv_app_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = lv_app_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = lv_app_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = lv_app_data.third_in_need_clock;
						} else if (card_times == 4) {
							lv_app_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							lv_app_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							lv_app_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							lv_app_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							lv_app_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							lv_app_data.third_out_need_clock = document.getElementById('rest_in2').checked;
							lv_app_data.forth_in_need_clock = document.getElementById('rest_out2').checked;
							lv_app_data.forth_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = lv_app_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = lv_app_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = lv_app_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = lv_app_data.third_in_need_clock;
							$scope.add_time_list[2].in_need_clock = lv_app_data.third_out_need_clock;
							$scope.add_time_list[2].out_need_clock = lv_app_data.forth_in_need_clock;
						} else if (card_times == 5) {
							lv_app_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							lv_app_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							lv_app_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							lv_app_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							lv_app_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							lv_app_data.third_out_need_clock = document.getElementById('rest_in2').checked;
							lv_app_data.forth_in_need_clock = document.getElementById('rest_out2').checked;
							lv_app_data.forth_out_need_clock = document.getElementById('rest_in3').checked;
							lv_app_data.fifth_in_need_clock = document.getElementById('rest_out3').checked;
							lv_app_data.fifth_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = lv_app_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = lv_app_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = lv_app_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = lv_app_data.third_in_need_clock;
							$scope.add_time_list[2].in_need_clock = lv_app_data.third_out_need_clock;
							$scope.add_time_list[2].out_need_clock = lv_app_data.forth_in_need_clock;
							$scope.add_time_list[3].in_need_clock = lv_app_data.forth_out_need_clock;
							$scope.add_time_list[3].out_need_clock = lv_app_data.fifth_in_need_clock;
						}
						lv_app_data.last_out_need_clock = document.getElementById('first_out_need_clock').checked;




						if (typeof ($scope.add_time_list) != 'undefined') {
							time_list_ot_apply.splice(0, time_list_ot_apply.length);
							for (var i = 0; i < $scope.add_time_list.length; i++) {
								time_list_ot_apply.push($scope.add_time_list[i]);
							}
						}


						if ($scope.ot_app_data.fifth_in != '') {
							$scope.ot_app_data.add_time_last_out = $scope.ot_app_data.fifth_out;
							$scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.fifth_out_need_clock;
						} else if ($scope.ot_app_data.forth_in != '') {
							$scope.ot_app_data.add_time_last_out = $scope.ot_app_data.forth_out;
							$scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.forth_out_need_clock;
						} else if ($scope.ot_app_data.third_in != '') {
							$scope.ot_app_data.add_time_last_out = $scope.ot_app_data.third_out;
							$scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.third_out_need_clock;
						} else if ($scope.ot_app_data.second_in != '') {
							$scope.ot_app_data.add_time_last_out = $scope.ot_app_data.second_out;
							$scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.second_out_need_clock;
						} else {
							$scope.ot_app_data.add_time_last_out = $scope.ot_app_data.first_out;
							$scope.ot_app_data.add_time_last_out_need_clock = $scope.ot_app_data.first_out_need_clock;
						}
						lv_app_data.ot_hours = data.ot_hours;
						lv_app_data._ot_hours = lv_app_data.ot_hours;
						if (document.getElementById("add_ot_hours") == null) {

						} else {
							document.getElementById("add_ot_hours").innerHTML = data.ot_hours + '小时';
						}

						document.getElementById("ot_hours").innerHTML = lv_app_data.ot_hours + '小时';

						//document.getElementById("ot_hours").innerHTML=lv_app_data.ot_hours+'小时';
						lv_app_data.time_first_in = lv_app_data.add_time_first_in;
						lv_app_data.time_last_out = lv_app_data.add_time_last_out;
						$scope.ot_app_data.card_times = card_times;

						if (lv_app_data.is_standard_wf == '1' && submit_flag == '1') {
							lv_app_data.approver_id_list = data.approver_id_list;
							lv_app_data.approver_list = data.approver_list;

							lv_app_data._approver_list.splice(0, lv_app_data._approver_list.length);
							for (var i = 0; i < data.approver_list.length; i++) {
								lv_app_data._approver_list.push(data.approver_list[i]);
							}
						}
						$ionicHistory.goBack();
						//console.log(lv_app_data);
					} else if (data.flag == '0' && !is_submit) {
						$("#add_time_submit").css({
							"opacity": "1"
						})
						if (document.getElementById("add_ot_hours") == null) {

						} else {
							document.getElementById("add_ot_hours").innerHTML = data.ot_hours + '小时';
						}

						document.getElementById("ot_hours").innerHTML = lv_app_data.ot_hours + '小时';

						if (lv_app_data.is_standard_wf == '1' && submit_flag == '1') {

							lv_app_data._approver_list.splice(0, lv_app_data._approver_list.length);
							for (var i = 0; i < data.approver_list.length; i++) {
								lv_app_data._approver_list.push(data.approver_list[i]);
							}

						}
					} else if (data.flag == '1') {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
						$("#add_time_submit").css({
							"opacity": "0.5"
						})
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

		}
	})

	.factory('essMyOtApplyDSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_data = [];
		var ess_my_applyD_other_data = [];
		var search_control = {};
		search_control.search_val = ''
		return {
			loadData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOtApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					//if(ess_my_applyD_data.data1.length>=ess_my_applyD_data.data2.length){
					//  document.getElementById('ess_my_apply_details_wrap').style.overflow='visible';
					//  document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style","width:50%;position: absolute;left:0px;top:0px;");
					//  document.getElementById('ess_my_apply_details_approved_div').setAttribute("style","width: 50%;float: right");
					//  ess_my_applyD_data.cls_flag=true;
					//}
					//else{
					//  document.getElementById('ess_my_apply_details_wrap').style.overflow='hidden';
					//  document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style","width:50%;");
					//  document.getElementById('ess_my_apply_details_approved_div').setAttribute("style","width: 50%;position: absolute;left:50%;top:0px;");
					//  ess_my_applyD_data.cls_flag=false;
					//}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOtApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_other_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			getOtherData: function () {
				return ess_my_applyD_other_data;
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyOtApplyDSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyOtApplyDSearchDiv").style.display = 'none';
					document.getElementById("essMyOtApplyDBack").style.display = 'block';
					return false;
				}
			},
			clearData: function () {
				ess_my_applyD_data = [];
				ess_my_applyD_other_data = [];
			}
		}
	})

	.factory('essMyOtApplyDetailsContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyOtApplyDSev) {
		var ess_my_applyD_data = {};
		var time_list_ot_apply = [];
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOtApplyDetailContent&' + _str + '&process_instance=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.notify_text = [];
					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_applyD_data.notify_text;
					ess_my_applyD_data.add_time_first_in = ess_my_applyD_data.first_in;
					ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.first_out;
					if (ess_my_applyD_data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.first_out,
							in_need_clock: ess_my_applyD_data.first_out_need_clock,
							out: ess_my_applyD_data.second_in,
							out_need_clock: ess_my_applyD_data.second_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.second_out;
					}
					if (ess_my_applyD_data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.second_out,
							in_need_clock: ess_my_applyD_data.second_out_need_clock,
							out: ess_my_applyD_data.third_in,
							out_need_clock: ess_my_applyD_data.third_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.third_out;
					}
					if (ess_my_applyD_data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.third_out,
							in_need_clock: ess_my_applyD_data.third_out_need_clock,
							out: ess_my_applyD_data.forth_in,
							out_need_clock: ess_my_applyD_data.forth_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.forth_out;
					}
					if (ess_my_applyD_data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.forth_out,
							in_need_clock: ess_my_applyD_data.forth_out_need_clock,
							out: ess_my_applyD_data.fifth_in,
							out_need_clock: ess_my_applyD_data.fifth_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.fifth_out;
					}

					if (ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '更多';
					} else if (ess_my_applyD_data.modify && !ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '修改';
					} else if (!ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '撤销';
					} else {
						ess_my_applyD_data.action_text = '';
					}




				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadNoprocessData: function (show_type, ot_date, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadNoprocessMyOtApplyDetailContent&' + _str + '&show_type=' + show_type + '&ot_date=' + ot_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					//ess_my_applyD_data.notify_text=[];
					//for(var i=0;i<ess_my_applyD_data.notify_list.length;i++){
					//  ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					//}
					//document.getElementById('notify_text').innerText=ess_my_applyD_data.notify_text;
					ess_my_applyD_data.add_time_first_in = ess_my_applyD_data.first_in;
					ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.first_out;
					if (ess_my_applyD_data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.first_out,
							in_need_clock: ess_my_applyD_data.first_out_need_clock,
							out: ess_my_applyD_data.second_in,
							out_need_clock: ess_my_applyD_data.second_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.second_out;
					}
					if (ess_my_applyD_data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.second_out,
							in_need_clock: ess_my_applyD_data.second_out_need_clock,
							out: ess_my_applyD_data.third_in,
							out_need_clock: ess_my_applyD_data.third_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.third_out;
					}
					if (ess_my_applyD_data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.third_out,
							in_need_clock: ess_my_applyD_data.third_out_need_clock,
							out: ess_my_applyD_data.forth_in,
							out_need_clock: ess_my_applyD_data.forth_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.forth_out;
					}
					if (ess_my_applyD_data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.forth_out,
							in_need_clock: ess_my_applyD_data.forth_out_need_clock,
							out: ess_my_applyD_data.fifth_in,
							out_need_clock: ess_my_applyD_data.fifth_in_need_clock,
							is_need: true
						})
						ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.fifth_out;
					}

					if (ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '更多';
					} else if (ess_my_applyD_data.modify && !ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '修改';
					} else if (!ess_my_applyD_data.modify && ess_my_applyD_data.cancel) {
						ess_my_applyD_data.action_text = '撤销';
					} else {
						ess_my_applyD_data.action_text = '';
					}




				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				ess_my_applyD_data = {};
				time_list_ot_apply = [];
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			getTimeList: function () {
				return time_list_ot_apply
			},
			submitAction: function (action, my_app_result) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				_d = ess_my_applyD_data.notify_list;
				for (var i = 0; i < _d.length; i++) {
					notify_list = notify_list + _d[i].user_id + ',';
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					data: {
						first_in: ess_my_applyD_data.first_in,
						first_in_need_clock: ess_my_applyD_data.first_in_need_clock ? '1' : '0',
						first_out: ess_my_applyD_data.first_out,
						first_out_need_clock: ess_my_applyD_data.first_out_need_clock ? '1' : '0',
						second_in: ess_my_applyD_data.second_in,
						second_in_need_clock: ess_my_applyD_data.second_in_need_clock ? '1' : '0',
						second_out: ess_my_applyD_data.second_out,
						second_out_need_clock: ess_my_applyD_data.second_out_need_clock ? '1' : '0',
						ot_in: ess_my_applyD_data.ot_in,
						ot_in_need_clock: ess_my_applyD_data.ot_in_need_clock ? '1' : '0',
						ot_out: ess_my_applyD_data.ot_out,
						ot_out_need_clock: ess_my_applyD_data.ot_out_need_clock ? '1' : '0',
						is_need_first: ess_my_applyD_data.is_need_first,
						is_need_second: ess_my_applyD_data.is_need_second,
						is_need_ot: ess_my_applyD_data.is_need_ot,
						ot_hours: ess_my_applyD_data.ot_hours,
						ot_code: ess_my_applyD_data.ot_code_key,
						ot_date: ess_my_applyD_data.ot_date,
						task_id: ess_my_applyD_data.task_id,
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						//apply_remark: '',
						notify_list: notify_list,
						actor: actor,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						approver_id_list: ess_my_applyD_data.approver_id_list,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								if (action == 'Cancel') {
									fufuMobclickAgent('click_ot_cancel');
								}
								essMyOtApplyDSev.loadData('overtime', my_app_result)
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})
	.factory('essOtApplyModifySev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyOtApplyDSev) {
		var ess_my_applyD_data = {};
		var time_list_ot_apply = [];
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOtApplyDetailContent&' + _str + '&process_instance=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var essOtPolicy_data = [];
					data.essOtPolicy_index = '';
					document.getElementById('essOtPolicy').innerHTML = '请选择';
					data.essOtPolicy_data_key = '';
					for (var i = 0; i < data.ot_code.length; i++) {
						essOtPolicy_data[i] = data.ot_code[i];
						essOtPolicy_data[i].key = data.ot_code[i].key_;
						essOtPolicy_data[i].value = data.ot_code[i].value_;
						if (essOtPolicy_data[i].check) {
							data.essOtPolicy_index = i;
							document.getElementById('essOtPolicy').innerHTML = essOtPolicy_data[i].value;
						}
					}
					data.essOtPolicy_data = essOtPolicy_data;

					angular.copy(data, ess_my_applyD_data);

					document.getElementById("ot_hours").innerHTML = ess_my_applyD_data.ot_hours + '小时';


					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_applyD_data.notify_list[i].user_id;
						ess_my_applyD_data.notify_list[i].flag = 1;
						if (i < ess_my_applyD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}
					if (ess_my_applyD_data.is_standard_wf == '1') {

						var approver_list = [];
						for (var i = 0; i < ess_my_applyD_data.approver_list.length; i++) {
							approver_list.push(ess_my_applyD_data.approver_list[i + 1])
							if (i == ess_my_applyD_data.approver_list.length - 2) {
								break;
							}
						}
						$scope.approver_list = approver_list;
						document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
					} else {
						if (ess_my_applyD_data.approver_list.length > 0) {
							$scope.select_user_id = ess_my_applyD_data.approver_list[ess_my_applyD_data.approver_list.length - 1].user_id;
							ess_my_applyD_data.approver_list.splice(0, ess_my_applyD_data.approver_list.length - 1);
							ess_my_applyD_data.approver_list[0].flag = 1;
						}
						$scope.approver_list = ess_my_applyD_data.approver_list;
						document.getElementById('approver_list_div').style.width = (ess_my_applyD_data.approver_list.length + 1) * 100 + 20 + 'px';
					}

					document.getElementById('notify_list_div').style.width = (ess_my_applyD_data.notify_list.length + 1) * 100 + 20 + 'px';
					ess_my_applyD_data.add_time_first_in = ess_my_applyD_data.first_in;
					ess_my_applyD_data.add_time_last_out = ess_my_applyD_data.first_out;

					if (ess_my_applyD_data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.first_out,
							in_need_clock: ess_my_applyD_data.first_out_need_clock,
							out: ess_my_applyD_data.second_in,
							out_need_clock: ess_my_applyD_data.second_in_need_clock,
							is_need: true
						})
					}
					if (ess_my_applyD_data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.second_out,
							in_need_clock: ess_my_applyD_data.second_out_need_clock,
							out: ess_my_applyD_data.third_in,
							out_need_clock: ess_my_applyD_data.third_in_need_clock,
							is_need: true
						})
					}
					if (ess_my_applyD_data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.third_out,
							in_need_clock: ess_my_applyD_data.third_out_need_clock,
							out: ess_my_applyD_data.forth_in,
							out_need_clock: ess_my_applyD_data.forth_in_need_clock,
							is_need: true
						})
					}
					if (ess_my_applyD_data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_applyD_data.forth_out,
							in_need_clock: ess_my_applyD_data.forth_out_need_clock,
							out: ess_my_applyD_data.fifth_in,
							out_need_clock: ess_my_applyD_data.fifth_in_need_clock,
							is_need: true
						})
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_applyD_data = {};
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			saveApply: function (approve_list, notify_list) {
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					data: {
						first_in: ess_my_applyD_data.first_in,
						first_in_need_clock: ess_my_applyD_data.first_in_need_clock ? '1' : '0',
						first_out: ess_my_applyD_data.first_out,
						first_out_need_clock: ess_my_applyD_data.first_out_need_clock ? '1' : '0',
						second_in: ess_my_applyD_data.second_in,
						second_in_need_clock: ess_my_applyD_data.second_in_need_clock ? '1' : '0',
						second_out: ess_my_applyD_data.second_out,
						second_out_need_clock: ess_my_applyD_data.second_out_need_clock ? '1' : '0',
						ot_in: ess_my_applyD_data.ot_in,
						ot_in_need_clock: ess_my_applyD_data.ot_in_need_clock ? '1' : '0',
						ot_out: ess_my_applyD_data.ot_out,
						ot_out_need_clock: ess_my_applyD_data.ot_out_need_clock ? '1' : '0',
						is_need_first: ess_my_applyD_data.is_need_first,
						is_need_second: ess_my_applyD_data.is_need_second,
						is_need_ot: ess_my_applyD_data.is_need_ot,
						ot_hours: ess_my_applyD_data.ot_hours,
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						ot_code: ess_my_applyD_data.ot_code_key,
						ot_date: ess_my_applyD_data.ot_date,
						task_id: ess_my_applyD_data.task_id,
						process_id: '0',
						apply_remark: $("#ot_apply_remark").val(),
						notify_list: notify_list,
						actor: approve_list,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						approver_id_list: ess_my_applyD_data.approver_id_list,
						action: 'modify',
						process_instance: ess_my_applyD_data.process_instance,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_modify');
								essMyOtApplyDSev.loadData('overtime', 'UC');
								$ionicHistory.goBack(-2);
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			add_time_save: function (add_time_list, $scope) {
				$rootScope.showLoading();
				var first_in = '';
				var first_out = '';
				var second_in = '';
				var second_out = '';
				var ot_in = '';
				var ot_out = '';
				var is_need_first = false;
				var is_need_second = false;
				var is_need_ot = false;
				var first_in_need_clock = false;
				var first_out_need_clock = false;
				var second_in_need_clock = false;
				var second_out_need_clock = false;
				var ot_in_need_clock = false;
				var ot_out_need_clock = false;
				for (var i = 0; i < add_time_list.length; i++) {
					if (i == 0) {
						first_in = document.getElementById('in_time_id0').innerHTML;
						first_out = document.getElementById('out_time_id0').innerHTML;
						is_need_first = '1';
						first_in_need_clock = add_time_list[0].in_need_clock;
						first_out_need_clock = add_time_list[0].out_need_clock;
					} else if (i == 1) {
						second_in = document.getElementById('in_time_id1').innerHTML;
						second_out = document.getElementById('out_time_id1').innerHTML;
						is_need_second = '1';
						second_in_need_clock = add_time_list[1].in_need_clock;
						second_out_need_clock = add_time_list[1].out_need_clock;
					} else if (i == 2) {
						ot_in = document.getElementById('in_time_id2').innerHTML;
						ot_out = document.getElementById('out_time_id2').innerHTML;
						is_need_ot = '1';
						ot_in_need_clock = add_time_list[2].in_need_clock;
						ot_out_need_clock = add_time_list[2].out_need_clock;
					}
				}
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otCardTimeValidation', {}, {
					timeout: _var_timeout,
					params: {
						ot_code: ess_my_applyD_data.ot_code_key,
						first_in: first_in,
						first_out: first_out,
						second_in: second_in,
						second_out: second_out,
						ot_in: ot_in,
						ot_out: ot_out,
						is_need_first: is_need_first ? '1' : '0',
						is_need_second: is_need_second ? '1' : '0',
						is_need_ot: is_need_ot ? '1' : '0',
						ot_date: ess_my_applyD_data.ot_date,
						process_instance: '0',
						submit_flag: '1',
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {

					$rootScope.hideLoading();
					if (data.flag == '0') {
						ess_my_applyD_data.first_in = first_in;
						ess_my_applyD_data.first_out = first_out;
						ess_my_applyD_data.second_in = second_in;
						ess_my_applyD_data.second_out = second_out;
						ess_my_applyD_data.ot_in = ot_in;
						ess_my_applyD_data.ot_out = ot_out;
						ess_my_applyD_data.is_need_first = is_need_first;
						ess_my_applyD_data.is_need_second = is_need_second;
						ess_my_applyD_data.is_need_ot = is_need_ot;
						ess_my_applyD_data.first_in_need_clock = first_in_need_clock;
						ess_my_applyD_data.first_out_need_clock = first_out_need_clock;
						ess_my_applyD_data.second_in_need_clock = second_in_need_clock;
						ess_my_applyD_data.second_out_need_clock = second_out_need_clock;
						ess_my_applyD_data.ot_in_need_clock = ot_in_need_clock;
						ess_my_applyD_data.ot_out_need_clock = ot_out_need_clock;
						//alert(ot_in);
						ess_my_applyD_data.ot_hours = data.ot_hours;
						//document.getElementById("ot_hours").innerHTML=ess_my_applyD_data.ot_hours+'小时';
						$ionicHistory.goBack();
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			get_ot_hours: function () {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otCardTimeValidation', {}, {
					timeout: _var_timeout,
					params: {
						ot_code: ess_my_applyD_data.ot_code_key,
						first_in: ess_my_applyD_data.first_in,
						first_out: ess_my_applyD_data.first_out,
						second_in: ess_my_applyD_data.second_in,
						second_out: ess_my_applyD_data.second_out,
						ot_in: ess_my_applyD_data.ot_in,
						ot_out: ess_my_applyD_data.ot_out,
						is_need_first: ess_my_applyD_data.is_need_first ? '1' : '0',
						is_need_second: ess_my_applyD_data.is_need_second ? '1' : '0',
						is_need_ot: ess_my_applyD_data.is_need_ot ? '1' : '0',
						ot_date: ess_my_applyD_data.ot_date,
						process_instance: '0',
						submit_flag: '1',
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					//console.log(data);
					//console.log(add_time_list);
					$rootScope.hideLoading();
					if (data.flag == '0') {
						ess_my_applyD_data.ot_hours = data.ot_hours;
						//document.getElementById("ot_hours").innerHTML=lv_app_data.ot_hours+'小时';
						//$ionicHistory.goBack();
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			get_ot_hours_normal: function (min, ot_valid_min, ot_min_unit) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otCardTimeValidation', {}, {
					timeout: _var_timeout,
					params: {
						ot_code: ess_my_applyD_data.ot_code_key,
						first_in: ess_my_applyD_data.first_in,
						first_out: ess_my_applyD_data.first_out,
						second_in: ess_my_applyD_data.second_in,
						second_out: ess_my_applyD_data.second_out,
						ot_in: ess_my_applyD_data.ot_in,
						ot_out: ess_my_applyD_data.ot_out,
						is_need_first: ess_my_applyD_data.is_need_first ? '1' : '0',
						is_need_second: ess_my_applyD_data.is_need_second ? '1' : '0',
						is_need_ot: ess_my_applyD_data.is_need_ot ? '1' : '0',
						ot_date: ess_my_applyD_data.ot_date,
						process_instance: '0',
						submit_flag: '1',
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						ess_my_applyD_data.ot_hours = data.ot_hours;
						document.getElementById("ot_hours").innerHTML = ess_my_applyD_data.ot_hours + '小时';
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}

		}
	})




	.factory('essMyApprovalDOTSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_approvalDOT_data = [];
		var ess_my_approvalDOT_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailOvertime&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDOT_data);
					ess_my_approvalDOT_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailOvertime&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDOT_other_data);
					ess_my_approvalDOT_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_approvalDOT_data;
			},
			getOtherData: function () {
				return ess_my_approvalDOT_other_data;
			},
			clearData: function () {
				ess_my_approvalDOT_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyApprovalDOTSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDOTSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDOTBack").style.display = 'block';
					return false;
				}
			},

		}
	})


	.factory('essMyApprovalDOTCSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApprovalDOTSev, homeMessageContentSev) {
		var ess_my_approvalD_data = {};
		var time_list_ot_apply = [];
		return {
			loadData: function (p_inst, show_type, task_id, my_app_result, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContentOvertime&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_data);
					ess_my_approvalD_data.notify_text = [];
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						ess_my_approvalD_data.notify_text.push(ess_my_approvalD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_approvalD_data.notify_text;
					document.getElementById('notify_list_div').style.width = (ess_my_approvalD_data.notify_list.length + 1) * 100 + 20 + 'px';
					ess_my_approvalD_data._ot_hours = ess_my_approvalD_data.ot_hours;
					document.getElementById("ot_hours").innerHTML = ess_my_approvalD_data.ot_hours + '小时';
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_approvalD_data.notify_list[i].user_id;
						ess_my_approvalD_data.notify_list[i].flag = 1;
						if (i < ess_my_approvalD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}

					ess_my_approvalD_data.add_time_first_in = ess_my_approvalD_data.first_in;
					ess_my_approvalD_data.add_time_last_out = ess_my_approvalD_data.first_out;
					ess_my_approvalD_data.time_first_in = ess_my_approvalD_data.first_in;
					ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.first_out;
					ess_my_approvalD_data.last_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
					if (ess_my_approvalD_data.second_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_approvalD_data.first_out,
							in_need_clock: ess_my_approvalD_data.first_out_need_clock,
							out: ess_my_approvalD_data.second_in,
							out_need_clock: ess_my_approvalD_data.second_in_need_clock,
							is_need: true
						})
						ess_my_approvalD_data.add_time_last_out = ess_my_approvalD_data.second_out;
						ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.second_out;
						ess_my_approvalD_data.last_out_need_clock = ess_my_approvalD_data.second_out_need_clock
					}
					if (ess_my_approvalD_data.third_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_approvalD_data.second_out,
							in_need_clock: ess_my_approvalD_data.second_out_need_clock,
							out: ess_my_approvalD_data.third_in,
							out_need_clock: ess_my_approvalD_data.third_in_need_clock,
							is_need: true
						})
						ess_my_approvalD_data.add_time_last_out = ess_my_approvalD_data.third_out;
						ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.third_out;
						ess_my_approvalD_data.last_out_need_clock = ess_my_approvalD_data.third_out_need_clock
					}
					if (ess_my_approvalD_data.forth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_approvalD_data.third_out,
							in_need_clock: ess_my_approvalD_data.third_out_need_clock,
							out: ess_my_approvalD_data.forth_in,
							out_need_clock: ess_my_approvalD_data.forth_in_need_clock,
							is_need: true
						})
						ess_my_approvalD_data.add_time_last_out = ess_my_approvalD_data.forth_out;
						ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.forth_out;
						ess_my_approvalD_data.last_out_need_clock = ess_my_approvalD_data.forth_out_need_clock
					}
					if (ess_my_approvalD_data.fifth_in != '') {
						time_list_ot_apply.push({
							name: '',
							in: ess_my_approvalD_data.forth_out,
							in_need_clock: ess_my_approvalD_data.forth_out_need_clock,
							out: ess_my_approvalD_data.fifth_in,
							out_need_clock: ess_my_approvalD_data.fifth_in_need_clock,
							is_need: true
						})
						ess_my_approvalD_data.add_time_last_out = ess_my_approvalD_data.fifth_out;
						ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.fifth_out;
						ess_my_approvalD_data.last_out_need_clock = ess_my_approvalD_data.fifth_out_need_clock
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approvalD_data = {};
				time_list_ot_apply = [];
			},
			getData: function () {
				return ess_my_approvalD_data;
			},
			getTimeList: function () {
				return time_list_ot_apply
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(ess_my_applyD_data, data);
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			applyReject: function (select_user_id, select_notify_id, my_app_result, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					timeout: _var_timeout,
					data: {
						operate_date: ess_my_approvalD_data.operate_date,
						first_in: ess_my_approvalD_data.first_in,
						first_in_need_clock: ess_my_approvalD_data.first_in_need_clock ? '1' : '0',
						first_out: ess_my_approvalD_data.first_out,
						first_out_need_clock: ess_my_approvalD_data.first_out_need_clock ? '1' : '0',
						second_in: ess_my_approvalD_data.second_in,
						second_in_need_clock: ess_my_approvalD_data.second_in_need_clock ? '1' : '0',
						second_out: ess_my_approvalD_data.second_out,
						second_out_need_clock: ess_my_approvalD_data.second_out_need_clock ? '1' : '0',
						third_in: ess_my_approvalD_data.third_in,
						third_in_need_clock: ess_my_approvalD_data.third_in_need_clock ? '1' : '0',
						third_out: ess_my_approvalD_data.third_out,
						third_out_need_clock: ess_my_approvalD_data.third_out_need_clock ? '1' : '0',
						forth_in: ess_my_approvalD_data.forth_in,
						forth_in_need_clock: ess_my_approvalD_data.forth_in_need_clock ? '1' : '0',
						forth_out: ess_my_approvalD_data.forth_out,
						forth_out_need_clock: ess_my_approvalD_data.forth_out_need_clock ? '1' : '0',
						fifth_in: ess_my_approvalD_data.fifth_in,
						fifth_in_need_clock: ess_my_approvalD_data.fifth_in_need_clock ? '1' : '0',
						fifth_out: ess_my_approvalD_data.fifth_out,
						fifth_out_need_clock: ess_my_approvalD_data.fifth_out_need_clock ? '1' : '0',
						card_times: ess_my_approvalD_data.card_times,
						ot_min_unit: ess_my_approvalD_data.ot_min_unit,
						ot_valid_min: ess_my_approvalD_data.ot_valid_min,
						is_need_first: ess_my_approvalD_data.is_need_first,
						is_need_second: ess_my_approvalD_data.is_need_second,
						is_need_ot: ess_my_approvalD_data.is_need_ot,
						ot_hours: ess_my_approvalD_data.ot_hours,
						employee_no: ess_my_approvalD_data.employee_no,
						ot_code: ess_my_approvalD_data.ot_code_key,
						ot_date: ess_my_approvalD_data.ot_date,
						task_id: ess_my_approvalD_data.task_id,
						process_id: '0',
						apply_remark: ess_my_approvalD_data.apply_remark,
						approve_remark: $("#remark_textarea").val(),
						notify_list: select_notify_id,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						actor: select_user_id,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Reject',
						process_instance: ess_my_approvalD_data.process_instance,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_approve');
								if (from_source == "my_approval") {
									essMyApprovalDOTSev.loadData('overtime', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (select_user_id, select_notify_id, my_app_result, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOtApply',
					data: {
						operate_date: ess_my_approvalD_data.operate_date,
						first_in: ess_my_approvalD_data.first_in,
						first_in_need_clock: ess_my_approvalD_data.first_in_need_clock ? '1' : '0',
						first_out: ess_my_approvalD_data.first_out,
						first_out_need_clock: ess_my_approvalD_data.first_out_need_clock ? '1' : '0',
						second_in: ess_my_approvalD_data.second_in,
						second_in_need_clock: ess_my_approvalD_data.second_in_need_clock ? '1' : '0',
						second_out: ess_my_approvalD_data.second_out,
						second_out_need_clock: ess_my_approvalD_data.second_out_need_clock ? '1' : '0',
						third_in: ess_my_approvalD_data.third_in,
						third_in_need_clock: ess_my_approvalD_data.third_in_need_clock ? '1' : '0',
						third_out: ess_my_approvalD_data.third_out,
						third_out_need_clock: ess_my_approvalD_data.third_out_need_clock ? '1' : '0',
						forth_in: ess_my_approvalD_data.forth_in,
						forth_in_need_clock: ess_my_approvalD_data.forth_in_need_clock ? '1' : '0',
						forth_out: ess_my_approvalD_data.forth_out,
						forth_out_need_clock: ess_my_approvalD_data.forth_out_need_clock ? '1' : '0',
						fifth_in: ess_my_approvalD_data.fifth_in,
						fifth_in_need_clock: ess_my_approvalD_data.fifth_in_need_clock ? '1' : '0',
						fifth_out: ess_my_approvalD_data.fifth_out,
						fifth_out_need_clock: ess_my_approvalD_data.fifth_out_need_clock ? '1' : '0',
						card_times: ess_my_approvalD_data.card_times,
						ot_min_unit: ess_my_approvalD_data.ot_min_unit,
						ot_valid_min: ess_my_approvalD_data.ot_valid_min,
						is_need_first: ess_my_approvalD_data.is_need_first,
						is_need_second: ess_my_approvalD_data.is_need_second,
						is_need_ot: ess_my_approvalD_data.is_need_ot,
						ot_hours: ess_my_approvalD_data.ot_hours,
						employee_no: ess_my_approvalD_data.employee_no,
						ot_code: ess_my_approvalD_data.ot_code_key,
						ot_date: ess_my_approvalD_data.ot_date,
						task_id: ess_my_approvalD_data.task_id,
						process_id: '0',
						apply_remark: ess_my_approvalD_data.apply_remark,
						approve_remark: $("#remark_textarea").val(),
						notify_list: select_notify_id,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						actor: select_user_id,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Approve',
						process_instance: ess_my_approvalD_data.process_instance,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_ot_approve');
								if (from_source == "my_approval") {
									essMyApprovalDOTSev.loadData('overtime', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			add_time_save: function (add_time_list, $scope, is_submit, submit_flag, card_times) {
				$rootScope.showLoading();
				var first_in = '';
				var first_out = '';
				var second_in = '';
				var second_out = '';
				var third_in = '';
				var third_out = '';
				var forth_in = '';
				var forth_out = '';
				var fifth_in = '';
				var fifth_out = '';
				var is_need_first = false;
				var is_need_second = false;
				var is_need_ot = false;
				var first_in_need_clock = ess_my_approvalD_data.first_in_need_clock;
				var first_out_need_clock = false;
				var second_in_need_clock = false;
				var second_out_need_clock = false;
				var third_in_need_clock = false;
				var third_out_need_clock = false;
				var forth_in_need_clock = false;
				var forth_out_need_clock = false;
				var fifth_in_need_clock = false;
				var fifth_out_need_clock = false;

				if (card_times == '1') {
					first_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
				} else if (card_times == '2') {
					first_out_need_clock = ess_my_approvalD_data.second_in_need_clock;
					second_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
				} else if (card_times == '3') {

					first_out_need_clock = ess_my_approvalD_data.second_in_need_clock;
					third_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
				} else if (card_times == '4') {
					first_out_need_clock = ess_my_approvalD_data.second_in_need_clock;
					forth_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
				} else if (card_times == '5') {
					first_out_need_clock = ess_my_approvalD_data.second_in_need_clock;
					fifth_out_need_clock = ess_my_approvalD_data.first_out_need_clock;
				}

				if (add_time_list.length == 0) {
					first_in = ess_my_approvalD_data.first_in;
					first_out = ess_my_approvalD_data.first_out
				}
				for (var i = 0; i <= add_time_list.length; i++) {
					if (i == 0) {
						first_in = ess_my_approvalD_data.add_time_first_in;
						first_out = ess_my_approvalD_data.add_time_last_out;
						//first_out_need_clock=ess_my_approvalD_data.first_out_need_clock;
					} else if (i == 1) {
						first_out = add_time_list[i - 1].in;
						second_in = add_time_list[i - 1].out;
						second_out = ess_my_approvalD_data.add_time_last_out;

						//second_in_need_clock = add_time_list[1].in_need_clock;
						//second_out_need_clock=ess_my_approvalD_data.first_out_need_clock;
					} else if (i == 2) {
						second_out = add_time_list[i - 1].in;
						third_in = add_time_list[i - 1].out;
						third_out = ess_my_approvalD_data.add_time_last_out;
						//third_out_need_clock=ess_my_approvalD_data.first_out_need_clock;
					} else if (i == 3) {
						third_out = add_time_list[i - 1].in;
						forth_in = add_time_list[i - 1].out;
						forth_out = ess_my_approvalD_data.add_time_last_out;
						//forth_out_need_clock=ess_my_approvalD_data.first_out_need_clock;
					} else if (i == 4) {
						forth_out = add_time_list[i - 1].in;
						fifth_in = add_time_list[i - 1].out;
						fifth_out = ess_my_approvalD_data.add_time_last_out;
						//fifth_out_need_clock=ess_my_approvalD_data.first_out_need_clock;
					}
				}
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.otCardTimeValidation', {}, {
					timeout: _var_timeout,
					params: {
						ot_code: ess_my_approvalD_data.ot_code_key,
						first_in: first_in,
						first_out: first_out,
						second_in: second_in,
						second_out: second_out,
						third_in: third_in,
						third_out: third_out,
						forth_in: forth_in,
						forth_out: forth_out,
						fifth_in: fifth_in,
						fifth_out: fifth_out,
						card_times: card_times,
						ot_valid_min: ess_my_approvalD_data.ot_valid_min,
						ot_min_unit: ess_my_approvalD_data.ot_min_unit,
						ot_date: ess_my_approvalD_data.ot_date,
						process_instance: '0',
						submit_flag: submit_flag,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					//if(ess_my_approvalD_data.approver_list_flag){
					//
					//}
					//else{
					//  $scope.approver_list=ess_my_approvalD_data.approver_list;
					//  ess_empl_data.approver_id_list=ess_my_approvalD_data.approver_id_list;
					//}
					//$scope.approver_list=ess_my_approvalD_data.approver_list;
					if (data.flag == '0' && is_submit) {

						//ess_my_approvalD_data.approver_id_list=data.approver_id_list;
						//ess_my_approvalD_data.approver_list=data.approver_list;
						ess_my_approvalD_data.first_in = first_in;
						ess_my_approvalD_data.first_out = first_out;
						ess_my_approvalD_data.second_in = second_in;
						ess_my_approvalD_data.second_out = second_out;
						ess_my_approvalD_data.third_in = third_in;
						ess_my_approvalD_data.third_out = third_out;
						ess_my_approvalD_data.forth_in = forth_in;
						ess_my_approvalD_data.forth_out = forth_out;
						ess_my_approvalD_data.fifth_in = fifth_in;
						ess_my_approvalD_data.fifth_out = fifth_out;
						ess_my_approvalD_data.is_need_first = is_need_first;
						ess_my_approvalD_data.is_need_second = is_need_second;
						ess_my_approvalD_data.is_need_ot = is_need_ot;
						//ess_my_approvalD_data.first_in_need_clock=first_in_need_clock;
						//ess_my_approvalD_data.first_out_need_clock=first_out_need_clock;
						//ess_my_approvalD_data.second_in_need_clock=second_in_need_clock;
						//ess_my_approvalD_data.second_out_need_clock=second_out_need_clock;
						//ess_my_approvalD_data.third_in_need_clock=third_in_need_clock;
						//ess_my_approvalD_data.third_out_need_clock=third_out_need_clock;
						//ess_my_approvalD_data.forth_in_need_clock=forth_in_need_clock;
						//ess_my_approvalD_data.forth_out_need_clock=forth_out_need_clock;
						//ess_my_approvalD_data.fifth_in_need_clock=fifth_in_need_clock;
						//ess_my_approvalD_data.fifth_out_need_clock=fifth_out_need_clock;
						ess_my_approvalD_data.card_times = card_times;
						if (card_times == 1) {
							ess_my_approvalD_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							ess_my_approvalD_data.first_out_need_clock = document.getElementById('first_out_need_clock').checked;

						} else if (card_times == 2) {
							ess_my_approvalD_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							ess_my_approvalD_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							ess_my_approvalD_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							ess_my_approvalD_data.second_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = ess_my_approvalD_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = ess_my_approvalD_data.second_in_need_clock;
						} else if (card_times == 3) {

							ess_my_approvalD_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							ess_my_approvalD_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							ess_my_approvalD_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							ess_my_approvalD_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							ess_my_approvalD_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							ess_my_approvalD_data.third_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = ess_my_approvalD_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = ess_my_approvalD_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = ess_my_approvalD_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = ess_my_approvalD_data.third_in_need_clock;
						} else if (card_times == 4) {
							ess_my_approvalD_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							ess_my_approvalD_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							ess_my_approvalD_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							ess_my_approvalD_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							ess_my_approvalD_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							ess_my_approvalD_data.third_out_need_clock = document.getElementById('rest_in2').checked;
							ess_my_approvalD_data.forth_in_need_clock = document.getElementById('rest_out2').checked;
							ess_my_approvalD_data.forth_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = ess_my_approvalD_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = ess_my_approvalD_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = ess_my_approvalD_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = ess_my_approvalD_data.third_in_need_clock;
							$scope.add_time_list[2].in_need_clock = ess_my_approvalD_data.third_out_need_clock;
							$scope.add_time_list[2].out_need_clock = ess_my_approvalD_data.forth_in_need_clock;
						} else if (card_times == 5) {
							ess_my_approvalD_data.first_in_need_clock = document.getElementById('first_in_need_clock').checked;
							ess_my_approvalD_data.first_out_need_clock = document.getElementById('rest_in0').checked;
							ess_my_approvalD_data.second_in_need_clock = document.getElementById('rest_out0').checked;
							ess_my_approvalD_data.second_out_need_clock = document.getElementById('rest_in1').checked;
							ess_my_approvalD_data.third_in_need_clock = document.getElementById('rest_out1').checked;
							ess_my_approvalD_data.third_out_need_clock = document.getElementById('rest_in2').checked;
							ess_my_approvalD_data.forth_in_need_clock = document.getElementById('rest_out2').checked;
							ess_my_approvalD_data.forth_out_need_clock = document.getElementById('rest_in3').checked;
							ess_my_approvalD_data.fifth_in_need_clock = document.getElementById('rest_out3').checked;
							ess_my_approvalD_data.fifth_out_need_clock = document.getElementById('first_out_need_clock').checked;
							$scope.add_time_list[0].in_need_clock = ess_my_approvalD_data.first_out_need_clock;
							$scope.add_time_list[0].out_need_clock = ess_my_approvalD_data.second_in_need_clock;
							$scope.add_time_list[1].in_need_clock = ess_my_approvalD_data.second_out_need_clock;
							$scope.add_time_list[1].out_need_clock = ess_my_approvalD_data.third_in_need_clock;
							$scope.add_time_list[2].in_need_clock = ess_my_approvalD_data.third_out_need_clock;
							$scope.add_time_list[2].out_need_clock = ess_my_approvalD_data.forth_in_need_clock;
							$scope.add_time_list[3].in_need_clock = ess_my_approvalD_data.forth_out_need_clock;
							$scope.add_time_list[3].out_need_clock = ess_my_approvalD_data.fifth_in_need_clock;
						}
						ess_my_approvalD_data.last_out_need_clock = document.getElementById('first_out_need_clock').checked;


						time_list_ot_apply.splice(0, time_list_ot_apply.length);


						for (var i = 0; i < $scope.add_time_list.length; i++) {
							time_list_ot_apply.push($scope.add_time_list[i]);
						}

						ess_my_approvalD_data.ot_hours = data.ot_hours;
						ess_my_approvalD_data._ot_hours = ess_my_approvalD_data.ot_hours;
						document.getElementById("add_ot_hours").innerHTML = data.ot_hours + '小时';
						document.getElementById("ot_hours").innerHTML = ess_my_approvalD_data.ot_hours + '小时';

						//document.getElementById("ot_hours").innerHTML=lv_app_data.ot_hours+'小时';
						ess_my_approvalD_data.time_first_in = ess_my_approvalD_data.add_time_first_in;
						ess_my_approvalD_data.time_last_out = ess_my_approvalD_data.add_time_last_out;
						$scope.ot_app_data.card_times = card_times;

						$ionicHistory.goBack();
						//console.log(ess_my_approvalD_data);
					} else if (data.flag == '0' && !is_submit) {

						//$ionicHistory.goBack();
						//ess_my_approvalD_data.ot_hours=data.ot_hours;
						//document.getElementById("ot_hours").innerHTML=ess_my_approvalD_data.ot_hours+'小时';

						document.getElementById("add_ot_hours").innerHTML = data.ot_hours + '小时';
						document.getElementById("ot_hours").innerHTML = ess_my_approvalD_data.ot_hours + '小时';
					} else if (data.flag == '1') {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})


	.factory('OtTeamRecordSev', function ($http, $rootScope, $ionicPopup) {
		var ot_team_record_data = [];
		var ot_team_record_statistics_data = {
			"ot_data": []
		};
		var flag = {};
		flag.f = true;
		return {
			loadData: function (date, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOtTeamRecordData&' + _str + "&date=" + date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ot_team_record_data);
					ot_team_record_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			setF: function (_flag) {
				flag.f = _flag;
				return flag;
			},

			getData: function () {
				return ot_team_record_data;
			},
			clearData: function () {
				ot_team_record_data = [];
				ot_team_record_statistics_data = {
					"ot_data": []
				};
			},
			loadStatisticsData: function (date, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOtTeamRecordStatisticsData&' + _str + "&date=" + date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ot_team_record_statistics_data);
					//$scope.ot_hc_num=ot_team_record_statistics_data.ot_hc_num;
					//$scope.ot_num=ot_team_record_statistics_data.ot_num;
					ot_team_record_statistics_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getStatisticsData: function () {

				return ot_team_record_statistics_data;
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("statistics_div").style.display == 'none') {
					return true;
				} else {
					document.getElementById('details_div').style.color = '#53afff';
					document.getElementById('details_div').style.backgroundColor = 'white';
					document.getElementById('details_div').style.border = 'none';
					document.getElementById('statistics_div').style.color = 'white';
					document.getElementById('statistics_div').style.backgroundColor = '#53afff';
					document.getElementById('statistics_div').style.border = '1px solid white';
					document.getElementById('statistics_div').style.borderLeft = 'none';
					document.getElementById('details_content_div').style.display = "block";
					document.getElementById('statistics_content_div').style.display = "none";
					return false;
				}
			}

		}
	})




	.factory('LvTeamRecordSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var lv_team_record_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvTeamRecordData&' + _str + '&date=' + date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, lv_team_record_data);
					lv_team_record_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return lv_team_record_data;
			},
			clearData: function () {
				lv_team_record_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("LvTeamRecordSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("LvTeamRecordSearchDiv").style.display = 'none';
					document.getElementById("LvTeamRecordBack").style.display = 'block';
					return false;
				}
			}

		}
	})
	.factory('LvTeamDCSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, $q, $timeout) {
		var lv_team_details_data = [];
		return {
			loadData: function (process_instance, app_id, is_pc) {
				var deferred = $q.defer();

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvTeamDCRecordData&' + _str + '&process_instance=' + process_instance + '&app_id=' + app_id + '&is_pc=' + is_pc, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, lv_team_details_data);
					if (is_pc != '1') {
						lv_team_details_data.notify_text = [];
						for (var i = 0; i < lv_team_details_data.notify_list.length; i++) {
							lv_team_details_data.notify_text.push(lv_team_details_data.notify_list[i].name)
						}
						document.getElementById('notify_text').innerText = lv_team_details_data.notify_text;
					}

					$timeout(function () {
						deferred.resolve(status);
					}, 0);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});

				return deferred.promise;
			},
			clearData: function () {
				lv_team_details_data = [];
			},
			getData: function () {
				return lv_team_details_data;
			}

		}
	})

	.factory('OtTeamDCSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ot_team_details_data = [];
		return {
			loadData: function (process_instance, shift_date, is_pc, employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOtTeamDCRecordData&' + _str + '&process_instance=' + process_instance + '&shift_date=' + shift_date + '&is_pc=' + is_pc + '&employee_no=' + employee_no, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ot_team_details_data);
					if (is_pc != '1') {
						ot_team_details_data.notify_text = [];
						for (var i = 0; i < ot_team_details_data.notify_list.length; i++) {
							ot_team_details_data.notify_text.push(ot_team_details_data.notify_list[i].name)
						}
						document.getElementById('notify_text').innerText = ot_team_details_data.notify_text;
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ot_team_details_data = [];
			},
			getData: function () {
				return ot_team_details_data;
			}

		}
	})


	.factory('MyLvBalanceSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var my_lv_balance_data = [];
		return {
			loadData: function (lv_code_id, lv_code_key, start_date, end_date, employee_no) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getMyLvBalanceData&' + _str + '&lv_code_id=' + lv_code_id + '&lv_code_key=' + lv_code_key + '&start_date=' + start_date + '&end_date=' + end_date + '&employee_no=' + employee_no, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					for (var i = 0; i < data.lv_str.length; i++) {
						data.lv_str[i].key = data.lv_str[i].key_;
						data.lv_str[i].value = data.lv_str[i].name_;
						if (data.lv_str[i].ch) {
							data.selectIndex = i;
							data.selectLvCodeId = data.lv_str[i].id;
							data.selectLvCodeKey = data.lv_str[i].key_;
							$('#leaveTypeUnit').html(data.lv_str[i].unit_name);
							$('#leaveTypeName').html(data.lv_str[i].name_ + '结余');
							if (data.lv_str[i].key_ == 'CL') {
								document.getElementById('start_date_text').style.color = '#53afff';
								document.getElementById('end_date_text').style.color = '#53afff';
							} else {
								document.getElementById('start_date_text').style.color = '#000000';
								document.getElementById('end_date_text').style.color = '#53afff';
							}
						}
					}
					data.start_date_text = data.start_date.split('-')[0] + '年' + data.start_date.split('-')[1] + '月' + data.start_date.split('-')[2] + '日';
					data.end_date_text = data.end_date.split('-')[0] + '年' + data.end_date.split('-')[1] + '月' + data.end_date.split('-')[2] + '日';
					angular.copy(data, my_lv_balance_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return my_lv_balance_data;
			},
			clearData: function () {
				my_lv_balance_data = [];
			}

		}
	})

	.factory('OutdoorApplySev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var lv_app_data = {};
		var ess_empl_data = [];
		return {
			loadData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOutdoorApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					if (data.approver_list_flag) {
						if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
							data.approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
							for (var i = 0; i < data.approver_list.length; i++) {
								$scope.select_user_id += data.approver_list[i].user_id;
								if (i <= data.approver_list.length - 2) {
									$scope.select_user_id += ',';
								}
							}
						}
					}

					if (data.notify_list_flag) {
						if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {
							data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);
							for (var i = 0; i < data.notify_list.length; i++) {
								$scope.select_notify_id += data.notify_list[i].user_id;
								if (i <= data.notify_list.length - 2) {
									$scope.select_notify_id += ',';
								}
							}

						}
					}
					document.getElementById('approver_list_div').style.width = (data.approver_list.length + 1) * 100 + 20 + 'px';
					document.getElementById('notify_list_div').style.width = (data.notify_list.length + 1) * 100 + 20 + 'px';


					angular.copy(data, lv_app_data);
					if (lv_app_data.reason == '拜访客户') {
						document.getElementById("outdoor_customer_name_div").style.display = "block";
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				lv_app_data = {};
			},
			getData: function () {
				return lv_app_data;
			},

			saveApply: function (approve_list, notify_list, latitude, longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
                $rootScope.showLoading();

                var reason = document.getElementById("outdoor_reason").innerHTML, reason_id = "";
                var len = (lv_app_data && lv_app_data.egress_reason_list.length) || 0;
                if(reason){
                    for (var i = 0; i < len; i++){
                      if (reason === lv_app_data.egress_reason_list[i].value){
                        reason_id = lv_app_data.egress_reason_list[i].key;
                        break;
                      }
                    }
                  }

				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOutdoorOtApply',
					data: {
						employee_no: lv_app_data.employee_no,
						start_date: lv_app_data.start_date,
						start_time: lv_app_data.start_time,
						end_date: lv_app_data.end_date,
						end_time: lv_app_data.end_time,
						location: document.getElementById("address_now").innerHTML,
						//location:'address',
						latitude: latitude,
						longitude: longitude,
						reason: reason_id,
						customers: $("#outdoor_customer_name").val(),
						apply_remark: $("#outdoor_remark").val(),
						approve_remark: '',
						notify_list: notify_list,
						actor: approve_list,
						old_duration: lv_app_data.old_duration,
						show_type: lv_app_data.show_type,
						biz_type_key: lv_app_data.biz_type_key,
						wf_app_table: lv_app_data.wf_app_table,
						action: 'submit',
						process_instance: '0',
						process_id: '0',
						task_id: '0',
						is_standard_wf: lv_app_data.is_standard_wf,
						approver_id_list: lv_app_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							if (lv_app_data.approver_list_flag && lv_app_data.approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data.approver_list));
							}
							if (lv_app_data.notify_list_flag && lv_app_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data.notify_list));
							}
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_outdoor_apply');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			saveApplyWithoutApprovel: function (latitude, longitude) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
                $rootScope.showLoading();
                
                var reason = document.getElementById("outdoor_reason").innerHTML, reason_id = "";
                var len = (lv_app_data && lv_app_data.egress_reason_list.length) || 0;
                if(reason){
                    for (var i = 0; i < len; i++){
                      if (reason === lv_app_data.egress_reason_list[i].value){
                        reason_id = lv_app_data.egress_reason_list[i].key;
                        break;
                      }
                    }
                  }

				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveOutdoorApply',
					data: {
						//employee_no:lv_app_data.employee_no,
						start_date: lv_app_data.start_date,
						start_time: lv_app_data.start_time,
						end_date: lv_app_data.end_date,
						end_time: lv_app_data.end_time,
						location: document.getElementById("address_now").innerHTML,
						latitude: latitude,
						longitude: longitude,
						//location:"adress",
						reason: reason_id,
						customers: $("#outdoor_customer_name").val(),
						remark: $("#outdoor_remark").val(),
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							if (lv_app_data.approver_list_flag && lv_app_data.approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data.approver_list));
							}
							if (lv_app_data.notify_list_flag && lv_app_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(lv_app_data.notify_list));
							}
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_outdoor_apply');
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);
					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
		}
	})

	.factory('essMyOutApplyDSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_data = [];
		var ess_my_applyD_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOutApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOutApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_other_data);
					ess_my_applyD_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			getOtherData: function () {
				return ess_my_applyD_other_data;
			},
			clearData: function () {
				ess_my_applyD_data = [];
				ess_my_applyD_other_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyOutApplyDSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyOutApplyDBack").style.display = 'block';
					document.getElementById("essMyOutApplyDSearchDiv").style.display = 'none';
					return false;
				}
			},

		}
	})

	.factory('essMyOutApplyDetailsContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyOutApplyDSev) {
		var ess_my_applyD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOutApplyDetailContent&' + _str + '&process_instance=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.notify_text = [];
					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_applyD_data.notify_text;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadNoprocessData: function (show_type, app_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadNoprocessMyOutApplyDetailContent&' + _str + '&show_type=' + show_type + '&app_id=' + app_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				ess_my_applyD_data = {};
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			submitAction: function (action, my_app_result, is_process, obj_id, biz_type_key) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				if (typeof (ess_my_applyD_data.notify_list) != 'undefined') {
					_d = ess_my_applyD_data.notify_list;
					for (var i = 0; i < _d.length; i++) {
						notify_list = notify_list + _d[i].user_id + ',';
					}
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOutdoorOtApply',
					data: {
						biz_type_key: biz_type_key,
						obj_id: obj_id,
						is_process: is_process,
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						start_date: ess_my_applyD_data.start_date,
						start_time: ess_my_applyD_data.start_time,
						end_date: ess_my_applyD_data.end_date,
						end_time: ess_my_applyD_data.end_time,
						location: ess_my_applyD_data.location,
						//location:'address',
						latitude: ess_my_applyD_data.latitude,
						longitude: ess_my_applyD_data.longitude,
						reason: ess_my_applyD_data.reason,
						customers: ess_my_applyD_data.customers,
						apply_remark: '',
						approve_remark: '',
						notify_list: notify_list,
						actor: actor,
						old_duration: ess_my_applyD_data.old_duration,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: '0',
						task_id: ess_my_applyD_data.task_id,
						is_standard_wf: ess_my_applyD_data.is_standard_wf,
						approver_id_list: ess_my_applyD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								if (action == 'Cancel') {
									fufuMobclickAgent('click_outdoor_cancel');
								}
								essMyOutApplyDSev.loadData('fieldwork_bill', my_app_result)
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('essMyApprovalDOSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_approvalDOT_data = [];
		var ess_my_approvalDOT_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailOut&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDOT_data);
					ess_my_approvalDOT_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return ess_my_approvalDOT_data;
			},
			loadOtherData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailOut&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDOT_other_data);
					ess_my_approvalDOT_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getOtherData: function () {
				return ess_my_approvalDOT_other_data;
			},
			clearData: function () {
				ess_my_approvalDOT_data = [];
				ess_my_approvalDOT_other_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyApprovalDOSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDOSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDOBack").style.display = 'block';
					return false;
				}
			},

		}
	})

	.factory('essMyApprovalDFCOSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApprovalDOSev, homeMessageContentSev, homeMessageContentSev) {
		var ess_my_approvalD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, my_app_result, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContentOut&' + _str + '&process_instance=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_data);

					ess_my_approvalD_data.notify_text = [];
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						ess_my_approvalD_data.notify_text.push(ess_my_approvalD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_approvalD_data.notify_text;
					document.getElementById('notify_list_div').style.width = (ess_my_approvalD_data.notify_list.length + 1) * 100 + 20 + 'px';
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_approvalD_data.notify_list[i].user_id;
						ess_my_approvalD_data.notify_list[i].flag = 1;
						if (i < ess_my_approvalD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approvalD_data = {};
			},
			getData: function () {
				return ess_my_approvalD_data;
			},

			applyReject: function (actor, notify_list, my_app_result, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOutdoorOtApply',
					timeout: _var_timeout,
					data: {
						operate_date: ess_my_approvalD_data.operate_date,
						employee_no: ess_my_approvalD_data.employee_no,
						start_date: ess_my_approvalD_data.start_date,
						start_time: ess_my_approvalD_data.start_time,
						end_date: ess_my_approvalD_data.end_date,
						end_time: ess_my_approvalD_data.end_time,
						location: ess_my_approvalD_data.location,
						reason: ess_my_approvalD_data.reason,
						customers: ess_my_approvalD_data.customers,
						apply_remark: ess_my_approvalD_data.apply_remark,
						approve_remark: $("#remark_textarea").val(),
						notify_list: notify_list,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						actor: actor,
						old_duration: ess_my_approvalD_data.old_duration,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Reject',
						process_instance: ess_my_approvalD_data.process_instance,
						process_id: '0',
						task_id: ess_my_approvalD_data.task_id,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_outdoor_approve');
								if (from_source == 'my_approval') {
									essMyApprovalDOSev.loadData('fieldwork_bill', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}

								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (actor, notify_list, my_app_result, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssOutdoorOtApply',
					timeout: _var_timeout,
					data: {
						operate_date: ess_my_approvalD_data.operate_date,
						employee_no: ess_my_approvalD_data.employee_no,
						start_date: ess_my_approvalD_data.start_date,
						start_time: ess_my_approvalD_data.start_time,
						end_date: ess_my_approvalD_data.end_date,
						end_time: ess_my_approvalD_data.end_time,
						location: ess_my_approvalD_data.location,
						reason: ess_my_approvalD_data.reason,
						customers: ess_my_approvalD_data.customers,
						apply_remark: ess_my_approvalD_data.apply_remark,
						approve_remark: $("#remark_textarea").val(),
						notify_list: notify_list,
						old_notify_list: ess_my_approvalD_data.old_notify_list,
						actor: actor,
						old_duration: ess_my_approvalD_data.old_duration,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						action: 'Approve',
						process_instance: ess_my_approvalD_data.process_instance,
						process_id: '0',
						task_id: ess_my_approvalD_data.task_id,
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						is_require_upload: '0',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_outdoor_approve');
								if (from_source == 'my_approval') {
									essMyApprovalDOSev.loadData('fieldwork_bill', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})



	.factory('OutdoorTeamRecordSev', function ($http, $rootScope, $ionicPopup) {
		var outdoor_team_record_data = [];
		var outdoor_team_record_statistics_data = {
			"data_list": []
		};

		return {
			loadData: function (date, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOutdoorTeamRecordData&' + _str + "&date=" + date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, outdoor_team_record_data);
					$scope.outdoor_hc_num = outdoor_team_record_data.data1.bill_hc_num;
					//$scope.ot_num=ot_team_record_data.ot_num;
					outdoor_team_record_data.data_ready = true;

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return outdoor_team_record_data;
			},
			clearData: function () {
				outdoor_team_record_data = [];
				//outdoor_team_record_statistics_data=[];
				ot_team_record_statistics_data = {
					"data_list": []
				};
			},
			loadStatisticsData: function (date, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getOutdoorTeamRecordStatisticsData&' + _str + "&date=" + date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, outdoor_team_record_statistics_data);
					$scope.outdoor_hc_num = outdoor_team_record_statistics_data.statis_hc_num;
					outdoor_team_record_statistics_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getStatisticsData: function () {
				return outdoor_team_record_statistics_data;
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("details_div").style.display == 'none') {
					return true;
				} else {
					document.getElementById('details_div').style.color = '#53afff';
					document.getElementById('details_div').style.backgroundColor = 'white';
					document.getElementById('details_div').style.border = 'none';
					document.getElementById('statistics_div').style.color = 'white';
					document.getElementById('statistics_div').style.backgroundColor = '#53afff';
					document.getElementById('statistics_div').style.border = '1px solid white';
					document.getElementById('statistics_div').style.borderLeft = 'none';
					document.getElementById('details_content_div').style.display = "block";
					document.getElementById('statistics_content_div').style.display = "none";
					return false;
				}
			}
		}
	})

	.factory('essMyOutdoorApplyDetailsContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_data = {};
		return {
			loadData: function (p_inst, app_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyOutdoorApplyDetailContent&' + _str + '&process_instance=' + p_inst + '&app_id=' + app_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.notify_text = [];
					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_applyD_data.notify_text;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_applyD_data = {};
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			submitAction: function (action) {
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				_d = ess_my_applyD_data.notify_list;
				for (var i = 0; i < _d.length; i++) {
					notify_list = notify_list + _d[i].user_id + ',';
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssApply',
					data: {
						employee_no: ess_my_applyD_data.employee_no,
						operate_date: ess_my_applyD_data.operate_date,
						lv_code_id: ess_my_applyD_data.default_lv_code_id,
						lv_code_key: ess_my_applyD_data.lv_code_key,
						task_id: ess_my_applyD_data.task_id,
						start_date: $('#_ess_my_apply_d1').val(),
						start_time: $('#_ess_my_apply_t1').val(),
						notify_list: notify_list,
						end_date: $('#_ess_my_apply_d2').val(),
						end_time: $('#_ess_my_apply_t2').val(),
						duration: ess_my_applyD_data.duration,
						lv_unit: ess_my_applyD_data.lv_unit,
						apply_remark: ess_my_applyD_data.apply_remark,
						actor: actor,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: 0,
						is_require_upload: 0,
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('homemessageSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, $timeout) {
		var home_message_date = [];
		var home_message_count = {};

		var ly_flag = {
			state: 0
		};

		var message_approval_data = {};
		var message_process_notice_data = {};
		var message_card_notice_data = {};
		var message_secretary_data = {};
		var message_notice_data = {};
		var message_system_data = {};
		var message_opendoor_notice_data = {};
		var message_visitor_notice_data = {};
		home_message_count.message_count = 0;

		return {
			setLyFlag: function (state) {
				ly_flag.state = state;
			},
			retLyFlag: function () {
				return ly_flag
			},
			setApprovalMessageData: function (data) {
				if (typeof (data.num) != 'undefined' && data.num == '0') {
					data.content = '暂无最新消息';
					data.date = '';
				}
				setLocalStorageVar("message_approval_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					if (typeof (message_approval_data.num) == 'undefined') {
						message_approval_data.num = 0;
					}
					message_approval_data.num = data.num;
					message_approval_data.date = data.date;
					message_approval_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getApprovalMessageData: function () {
				return message_approval_data;
			},

			clearProcessNoticeMessageData: function () {
				//window.localStorage["message_process_notice_data" + window.localStorage['_user_name']] = "";
				$timeout(function () {
					message_process_notice_data.num = 0;
					//message_process_notice_data.date = '';
					//message_process_notice_data.content = '暂无最新消息';
					setLocalStorageVar("message_process_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_process_notice_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			setProcessNoticeMessageData: function (data) {
				if (typeof (message_process_notice_data.num) == 'undefined') {
					message_process_notice_data.num = 0;
				}
				message_process_notice_data.num++;
				data.num = message_process_notice_data.num;
				setLocalStorageVar("message_process_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_process_notice_data.num = data.num;
					message_process_notice_data.date = data.date;
					message_process_notice_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			reSetProcessNoticeMessageData: function (data) {
				setLocalStorageVar("message_process_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_process_notice_data.date = data.date;
					message_process_notice_data.content = data.content;
				});
			},
			reSetSecretaryMessageData: function (data) {
				setLocalStorageVar("message_secretary_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_secretary_data.date = data.date;
					message_secretary_data.content = data.content;
				});
			},
			getProcessNoticeMessageData: function () {
				return message_process_notice_data;
			},

			clearCardNoticeMessageData: function () {
				$timeout(function () {
					message_card_notice_data.num = 0;
					//message_card_notice_data.date = '';
					//message_card_notice_data.content = '暂无最新消息';
					setLocalStorageVar("message_card_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_card_notice_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			setCardNoticeMessageData: function (data) {
				if (typeof (message_card_notice_data.num) == 'undefined') {
					message_card_notice_data.num = 0;
				}
				message_card_notice_data.num++;
				data.num = message_card_notice_data.num;
				setLocalStorageVar("message_card_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_card_notice_data.num = data.num;
					message_card_notice_data.date = data.date;
					message_card_notice_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getCardNoticeMessageData: function () {
				return message_card_notice_data;
			},

			clearVisitorNoticeMessageData: function () {
				$timeout(function () {
					message_visitor_notice_data.num = 0;
					setLocalStorageVar("message_visitor_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_visitor_notice_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			setVisitorNoticeMessageData: function (data) {
				if (typeof (message_visitor_notice_data.num) == 'undefined') {
					message_visitor_notice_data.num = 0;
				}
				message_visitor_notice_data.num++;
				data.num = message_visitor_notice_data.num;
				setLocalStorageVar("message_visitor_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_visitor_notice_data.num = data.num;
					message_visitor_notice_data.date = data.date;
					message_visitor_notice_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getVisitorNoticeMessageData: function () {
				return message_visitor_notice_data;
			},
			clearOpenDoorNoticeMessageData: function () {
				$timeout(function () {
                    message_opendoor_notice_data.num = 0;
					setLocalStorageVar("message_opendoor_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_opendoor_notice_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			setOpenDoorNoticeMessageData: function (data) {
				if (typeof (message_opendoor_notice_data.num) == 'undefined') {
					message_opendoor_notice_data.num = 0;
				}
				message_opendoor_notice_data.num++;
				data.num = message_opendoor_notice_data.num;
                setLocalStorageVar("message_opendoor_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_opendoor_notice_data.num = data.num;
					message_opendoor_notice_data.date = data.date_time;
					message_opendoor_notice_data.content = data.device_info;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getOpenDoorNoticeMessageData: function () {
				return message_opendoor_notice_data;
			},
			clearSecretaryMessageData: function () {
				//window.localStorage["message_secretary_data" + window.localStorage['_user_name']] = "";
				$timeout(function () {
					message_secretary_data.num = 0;
					//message_secretary_data.date = '';
					//message_secretary_data.content = '暂无最新消息';
					setLocalStorageVar("message_secretary_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_secretary_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},

			setSecretaryMessageData: function (data) {
				if (typeof (message_secretary_data.num) == 'undefined') {
					message_secretary_data.num = 0;
				}
				message_secretary_data.num++;
				data.num = message_secretary_data.num;
				setLocalStorageVar("message_secretary_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_secretary_data.num = data.num;
					message_secretary_data.date = data.date;
					message_secretary_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getSecretaryMessageData: function () {
				return message_secretary_data;
			},

			clearNoticeMessageData: function () {
				//window.localStorage["message_notice_data" + window.localStorage['_user_name']] = "";
				$timeout(function () {
					message_notice_data.num = 0;
					//message_notice_data.date = '';
					//message_notice_data.content = '暂无最新消息';
					setLocalStorageVar("message_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_notice_data));
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			reSetNoticeMessageData: function (data) {
				setLocalStorageVar("message_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_notice_data.date = data.date;
					message_notice_data.content = data.content;
				});
			},
			setNoticeMessageData: function (data) {
				if (typeof (message_notice_data.num) == 'undefined') {
					message_notice_data.num = 0;
				}
				message_notice_data.num++;
				data.num = message_notice_data.num;
				setLocalStorageVar("message_notice_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_notice_data.num = data.num;
					message_notice_data.date = data.date;
					message_notice_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getNoticeMessageData: function () {
				return message_notice_data;
			},
			clearSystemMessageData: function () {
				//window.localStorage["message_system_data" + window.localStorage['_user_name']] = "";
				$timeout(function () {
					message_system_data.num = 0;
					//message_system_data.date = '';
					//message_system_data.content = '暂无最新消息';
					setLocalStorageVar("message_system_data" + getLocalStorageVar("_user_name"), JSON.stringify(message_system_data));

					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			reSetSystemMessageData: function (data) {
				setLocalStorageVar("message_system_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_system_data.num = data.num;
					message_system_data.date = data.date;
					message_system_data.content = data.content;
				});
			},
			setSystemMessageData: function (data) {
				if (typeof (message_system_data.num) == 'undefined') {
					message_system_data.num = 0;
				}
				message_system_data.num++;
				data.num = message_system_data.num;

				setLocalStorageVar("message_system_data" + getLocalStorageVar("_user_name"), JSON.stringify(data));
				$timeout(function () {
					message_system_data.num = data.num;
					message_system_data.date = data.date;
					message_system_data.content = data.content;
					home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				});
			},
			getSystemMessageData: function () {
				return message_system_data;
			},



			loadMessageCount: function () {
				//暂时可以不用这function
				return;
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getHomeMessageCount&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					//$rootScope.hideLoading();
					if (data.flag == '0') {
						home_message_count.message_count = parseInt(data.messageCount, 10);

					}

				}).
				error(function (data, status) {
					//$rootScope.hideLoading();
				});
			},
			getMessageCount: function () {
				if (window.localStorage["message_approval_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_approval_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_approval_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_approval_data" + window.localStorage['_user_name']]), message_approval_data);
				} else {
					message_approval_data.num = 0;
					message_approval_data.date = '';
					message_approval_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_process_notice_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_process_notice_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_process_notice_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_process_notice_data" + window.localStorage['_user_name']]), message_process_notice_data);
				} else {
					message_process_notice_data.num = 0;
					message_process_notice_data.date = '';
					message_process_notice_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_card_notice_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_card_notice_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_card_notice_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_card_notice_data" + window.localStorage['_user_name']]), message_card_notice_data);
				} else {
					message_card_notice_data.num = 0;
					message_card_notice_data.date = '';
					message_card_notice_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_secretary_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_secretary_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_secretary_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_secretary_data" + window.localStorage['_user_name']]), message_secretary_data);
				} else {
					message_secretary_data.num = 0;
					message_secretary_data.date = '';
					message_secretary_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_notice_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_notice_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_notice_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_notice_data" + window.localStorage['_user_name']]), message_notice_data);
				} else {
					message_notice_data.num = 0;
					message_notice_data.date = '';
					message_notice_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_system_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_system_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_system_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_system_data" + window.localStorage['_user_name']]), message_system_data);
				} else {
					message_system_data.num = 0;
					message_system_data.date = '';
					message_system_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_opendoor_notice_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_opendoor_notice_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_opendoor_notice_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_opendoor_notice_data" + window.localStorage['_user_name']]), message_opendoor_notice_data);
				} else {
					message_opendoor_notice_data.num = 0;
					message_opendoor_notice_data.date = '';
					message_opendoor_notice_data.content = '暂无最新消息';
				}

				if (window.localStorage["message_visitor_notice_data" + window.localStorage['_user_name']] != null && typeof (window.localStorage["message_visitor_notice_data" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["message_visitor_notice_data" + window.localStorage['_user_name']] != '') {
					angular.copy($.parseJSON(window.localStorage["message_visitor_notice_data" + window.localStorage['_user_name']]), message_visitor_notice_data);
				} else {
					message_visitor_notice_data.num = 0;
					message_visitor_notice_data.date = '';
					message_visitor_notice_data.content = '暂无最新消息';
				}

				home_message_count.message_count = parseInt(message_approval_data.num, 10) + parseInt(message_process_notice_data.num, 10) + parseInt(message_card_notice_data.num, 10) + parseInt(message_secretary_data.num, 10) + parseInt(message_notice_data.num, 10) + parseInt(message_system_data.num, 10)+ parseInt(message_opendoor_notice_data.num, 10)+ parseInt(message_visitor_notice_data.num, 10);
				return home_message_count;
			},


			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessage&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					for (var i = 0; i < data.length; i++) {
						if (data[i].mesg == "") {
							data[i].mesg = '暂无最新消息';
						}
					}
					angular.copy(data, home_message_date);
					if (data.length > 1 && typeof (data[0].type) != 'undefined') {
						setLocalStorageVar("menu_message", JSON.stringify(home_message_date));
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
				});
			},
			refreshData: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessage&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.refreshComplete');
					for (var i = 0; i < data.length; i++) {
						if (data[i].mesg == "") {
							data[i].mesg = '暂无最新消息';
						}
					}
					angular.copy(data, home_message_date);
					if (data.length > 1 && typeof (data[0].type) != 'undefined') {
						setLocalStorageVar("menu_message", JSON.stringify(home_message_date));
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.refreshComplete');
					/*
					 $ionicPopup.alert({
					 title: '提醒',
					 template: '<div style="text-align: center;">'+ fufu_network_error_msg + '</div>',
					 okText: '确定'
					 })
					 */
				});
			},
			clearData: function () {
				home_message_date = [];
			},
			getData: function () {
				return home_message_date;
			},
			setData: function (tempList) {
				angular.copy(tempList, home_message_date);
			}




		}

	})

	.factory('homeMessageContentSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, homemessageSev) {
		var home_message_content_date = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (message_type) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessageContent&' + _str + '&message_type=' + message_type + '&current_page=0' + '&search_value="" ', {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, home_message_content_date);
					home_message_content_date.data_ready = true;
					if (home_message_content_date.length > 0) {
						homemessageSev.setApprovalMessageData({
							"num": home_message_content_date.length,
							"content": home_message_content_date[0].content,
							"date": home_message_content_date[0].date_,
						});
					} else {
						homemessageSev.setApprovalMessageData({
							"num": 0
						});
					}
					for (var i = 0; i < home_message_content_date.length; i++) {
						if (home_message_content_date[i].biz_type_key == "at_daily_adj") {
							home_message_content_date[i].date_text = home_message_content_date[i].shift_date.split('-')[0] + "年" + home_message_content_date[i].shift_date.split('-')[1] + "月" + home_message_content_date[i].shift_date.split('-')[2] + "日"
						}
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			clearData: function () {
				home_message_content_date = [];
			},
			getData: function () {
				return home_message_content_date;
			}
		}
	})
	.factory('homeMessageDetailSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, $timeout, homemessageSev, $ionicScrollDelegate) {
		var home_message_detail_date = [];
		var current_page = 1;
		var end_of_list = {};
		end_of_list.status = false;
		var search_control = {};
		search_control.search_val = '';
		var searchState = {};
		searchState.flag = false;
		searchState.is_show_wrap = true;
		var searchNodata = {};
		searchNodata.is_search = false;
		return {
			loadData: function (message_type, search_value) {
				var _str = '';
				current_page = 1
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessageContent&' + _str + '&message_type=' + message_type + '&current_page=' + current_page + "&search_value=" + search_value, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					$ionicScrollDelegate.scrollTop();
					for (var i = 0; i < data.length; i++) {
						if (data[i].app_status.toLowerCase() == 'approve' || data[i].app_status.toLowerCase() == 'approve cancel') {
							data[i].text_color = "#ff6600";
						} else if (data[i].app_status.toLowerCase() == 'modify') {
							data[i].text_color = "#53afff";
						} else if (data[i].app_status.toLowerCase() == 'cancel') {
							data[i].text_color = "#999";
						}
						if (data[i].app_status.toLowerCase() == 'reject' || data[i].app_status.toLowerCase() == 'reject cancel') {
							data[i].text_color = "#ff3a30";
						}
					}

					searchState.flag = true;
					searchState.is_show_wrap = true;
					document.getElementById("homeMessageDetailWrap").style.display = 'block';
					current_page++;

					if (typeof (data.length) == 'undefined') {
						end_of_list.status = true;
					} else {
						if (data.length < 20) {

							end_of_list.status = true;
						} else {

							end_of_list.status = false;
						}
					}



					/*
					if (data.length < 20) {

						end_of_list.status = true;

					}
					else{
						end_of_list.status = false;
					}
					*/
					angular.copy(data, home_message_detail_date);





					home_message_detail_date.data_ready = true;
					for (var i = 0; i < home_message_detail_date.length; i++) {
						if (home_message_detail_date[i].biz_type_key == "at_daily_adj") {
							home_message_detail_date[i].date_text = home_message_detail_date[i].shift_date.split('-')[0] + "年" + home_message_detail_date[i].shift_date.split('-')[1] + "月" + home_message_detail_date[i].shift_date.split('-')[2] + "日"
						}
					}

					//window.localStorage["message_process_notice_data" + window.localStorage['_user_name']] = '';
					homemessageSev.clearProcessNoticeMessageData();
					homemessageSev.getMessageCount();
					$timeout(function () {
						if (home_message_detail_date.length > 0) {
							homemessageSev.reSetProcessNoticeMessageData({
								"num": '0',
								"date": home_message_detail_date[0].date_,
								"content": home_message_detail_date[0].content
							})
						}
					}, 500)


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.infiniteScrollComplete');
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadMoreData: function ($scope, message_type, search_value) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessageContent&' + _str + '&message_type=' + message_type + '&current_page=' + current_page + "&search_value=" + search_value, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					for (var i = 0; i < data.length; i++) {
						if (data[i].app_status == 'approve') {
							data[i].text_color = "#ff6600";
						} else if (data[i].app_status == 'modify') {
							data[i].text_color = "#53afff";
						} else if (data[i].app_status == 'cancel') {
							data[i].text_color = "#999";
						}
						if (data[i].app_status == 'reject') {
							data[i].text_color = "#ff3a30";
						}
					}


					if (home_message_detail_date.length == 0) {
						angular.copy(data, home_message_detail_date);
					} else {
						if (data.length != 0) {
							for (var i = 0; i < data.length; i++) {
								home_message_detail_date.push(data[i]);
							}


						}

					}
					current_page++;
					if (data.length < 20) {

						end_of_list.status = true;



					}
					$scope.$broadcast('scroll.infiniteScrollComplete');



					home_message_detail_date.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					$scope.$broadcast('scroll.infiniteScrollComplete');
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadSearchData: function (message_type, search_value) {
				var _str = '';
				searchState.flag = false;

				current_page = 1;
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadHomeMessageContent&' + _str + '&message_type=' + message_type + '&current_page=' + current_page + "&search_value=" + search_value, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, home_message_detail_date);
					searchState.flag = true;
					searchState.is_show_wrap = true;
					document.getElementById("homeMessageDetailWrap").style.display = 'block';

					current_page++;
					if (data.length < 20) {

						end_of_list.status = true;
					} else {
						end_of_list.status = false;
					}




					home_message_detail_date.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_value) {
				$timeout(function () {
					search_control.search_val = search_value;
				})

			},
			setSearchState: function (flag) {
				searchState.flag = flag;
			},
			getSearchValue: function () {
				return search_control;
			},
			getSearchNodata: function () {
				return searchNodata;
			},
			setSearchNodata: function (flag) {
				searchNodata.is_search = flag;
			},
			clearData: function () {
				home_message_detail_date = [];
				current_page = 1;
				end_of_list.status = false;
			},
			getData: function () {
				return home_message_detail_date;
			},
			getEndOfList: function () {
				return end_of_list;
			},
			getSearchState: function () {
				return searchState;
			},
			setIsShowWrap: function (flag) {
				searchState.is_show_wrap = flag;
			}


		}
	})

	.factory('essMyApplyDetailsContentOfficWorkSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApplyDSev) {
		var ess_my_applyD_Fieldwork_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyDetailContentOfficWork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_Fieldwork_data);
					$('#_ess_my_apply_d1').val(ess_my_applyD_Fieldwork_data.start_date);
					$('#_ess_my_apply_d2').val(ess_my_applyD_Fieldwork_data.end_date);
					$('#_ess_my_apply_t1').val(ess_my_applyD_Fieldwork_data.start_time);
					$('#_ess_my_apply_t2').val(ess_my_applyD_Fieldwork_data.end_time);

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadNoprocessData: function (show_type, rec_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadNoprocessMyApplyDetailContentOfficWork&' + _str + '&show_type=' + show_type + '&rec_id=' + rec_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_Fieldwork_data);


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_applyD_Fieldwork_data = {};
			},
			getData: function () {
				return ess_my_applyD_Fieldwork_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					angular.extend(ess_my_applyD_data, data);
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			submitAction: function (action, my_app_result, is_process, obj_id, biz_type_key) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_Fieldwork_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}

				if (typeof (ess_my_applyD_Fieldwork_data.notify_list) != 'undefined') {
					_d = ess_my_applyD_Fieldwork_data.notify_list;
					for (var i = 0; i < _d.length; i++) {
						notify_list = notify_list + _d[i].user_id + ',';
					}
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInRemoteSave',
					data: {
						biz_type_key: biz_type_key,
						obj_id: obj_id,
						is_process: is_process,
						employee_no: ess_my_applyD_Fieldwork_data.employee_no,
						operate_date: ess_my_applyD_Fieldwork_data.operate_date,
						location: ess_my_applyD_Fieldwork_data.location,
						longitude: ess_my_applyD_Fieldwork_data.longitude,
						latitude: ess_my_applyD_Fieldwork_data.latitude,
						photo: ess_my_applyD_Fieldwork_data.photo,
						reason: ess_my_applyD_Fieldwork_data.reason,
						apply_remark: '',
						is_fieldwork: "0",
						i_wf: ess_my_applyD_Fieldwork_data.i_wf,
						i_l: ess_my_applyD_Fieldwork_data.i_l,
						i_p: ess_my_applyD_Fieldwork_data.i_p,
						customer: ess_my_applyD_Fieldwork_data.customer,
						location_detail: ess_my_applyD_Fieldwork_data.location_detail,
						actor: actor,
						show_type: ess_my_applyD_Fieldwork_data.show_type,
						wf_app_table: ess_my_applyD_Fieldwork_data.wf_app_table,
						is_require_upload: '0',
						is_standard_wf: ess_my_applyD_Fieldwork_data.is_standard_wf,
						approver_id_list: ess_my_applyD_Fieldwork_data.approver_id_list,
						o_photo: ess_my_applyD_Fieldwork_data.o_photo,
						action: action,
						notify_list: notify_list,
						task_id: ess_my_applyD_Fieldwork_data.task_id,
						process_id: '0',
						process_instance: ess_my_applyD_Fieldwork_data.process_instance,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								if (action == 'Cancel') {
									fufuMobclickAgent('click_remote_cancel');
								}
								essMyApplyDSev.loadData('offic_work_out', my_app_result)
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})

	.factory('essMyApprovalDCOSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyApprovalDFSev, homeMessageContentSev, homeMessageContentSev) {
		var ess_my_approvalD_data = {};
		var ess_my_approvalD_other_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, my_app_result, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContentofficwork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_data);
					ess_my_approvalD_data.notify_text = [];
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						ess_my_approvalD_data.notify_text.push(ess_my_approvalD_data.notify_list[i].name)
					}
					for (var i = 0; i < ess_my_approvalD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_approvalD_data.notify_list[i].user_id;
						ess_my_approvalD_data.notify_list[i].flag = 1;
						if (i < ess_my_approvalD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}
					document.getElementById('notify_text').innerText = ess_my_approvalD_data.notify_text;
					document.getElementById('notify_list_div').style.width = (ess_my_approvalD_data.notify_list.length + 1) * 100 + 20 + 'px';

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (p_inst, show_type, task_id, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailContentofficwork&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalD_other_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_approvalD_data = {};
				ess_my_approvalD_other_data = {};
			},
			getData: function () {
				return ess_my_approvalD_data;
			},
			getOtherData: function () {
				return ess_my_approvalD_other_data;
			},
			changeEssLvPolicy: function (lv_code_id) {
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.changeEssLvPolicy', {}, {
					timeout: _var_timeout,
					params: {
						lv_code_id: lv_code_id,
						s_date: $('#_ess_my_apply_d1').val(),
						s_time: $('#_ess_my_apply_t1').val(),
						e_date: $('#_ess_my_apply_d2').val(),
						e_time: $('#_ess_my_apply_t2').val(),
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']
					}
				}).
				success(function (data, status, headers, config) {
					angular.extend(ess_my_applyD_data, data);
					$rootScope.hideLoading();

				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			applyReject: function (actor, my_app_result, notify_id, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInRemoteSave',
					timeout: _var_timeout,
					data: {
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						operate_date: ess_my_approvalD_data.operate_date,
						location: ess_my_approvalD_data.location,
						longitude: ess_my_approvalD_data.longitude,
						latitude: ess_my_approvalD_data.latitude,
						photo: ess_my_approvalD_data.photo,
						reason: ess_my_approvalD_data.reason,
						remark: ess_my_approvalD_data.remark,
						approval_remark: $("#remark_textarea").val(),
						is_fieldwork: "0",
						employee_no: ess_my_approvalD_data.employee_no,
						i_wf: '1',
						notify_list: notify_id,
						customer: ess_my_approvalD_data.customer,
						location_detail: ess_my_approvalD_data.location_detail,
						actor: actor,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						is_require_upload: '0',
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						task_id: ess_my_approvalD_data.task_id,
						o_photo: '',
						action: 'Reject',
						process_instance: ess_my_approvalD_data.process_instance,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_remote_approve');
								if (from_source == 'my_approval') {
									essMyApprovalDFSev.loadData('offic_work_out', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}

								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			applyApprove: function (actor, my_app_result, notify_id, from_source) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.atSignInRemoteSave',
					data: {
						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type'],
						operate_date: ess_my_approvalD_data.operate_date,
						location: ess_my_approvalD_data.location,
						longitude: ess_my_approvalD_data.longitude,
						latitude: ess_my_approvalD_data.latitude,
						photo: ess_my_approvalD_data.photo,
						reason: ess_my_approvalD_data.reason,
						remark: ess_my_approvalD_data.remark,
						approval_remark: $("#remark_textarea").val(),
						is_fieldwork: "0",
						i_wf: '1',
						notify_list: notify_id,
						employee_no: ess_my_approvalD_data.employee_no,
						//i_l: at_sign_in_remote_data.i_l,
						//i_p: at_sign_in_remote_data.i_p,
						customer: ess_my_approvalD_data.customer,
						location_detail: ess_my_approvalD_data.location_detail,
						actor: actor,
						show_type: ess_my_approvalD_data.show_type,
						biz_type_key: ess_my_approvalD_data.biz_type_key,
						wf_app_table: ess_my_approvalD_data.wf_app_table,
						is_require_upload: '0',
						is_standard_wf: ess_my_approvalD_data.is_standard_wf,
						approver_id_list: ess_my_approvalD_data.approver_id_list,
						task_id: ess_my_approvalD_data.task_id,
						o_photo: '',
						action: 'Approve',
						process_instance: ess_my_approvalD_data.process_instance,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								fufuMobclickAgent('click_remote_approve');
								if (from_source == 'my_approval') {
									essMyApprovalDFSev.loadData('offic_work_out', my_app_result);
								} else {
									homeMessageContentSev.loadData("process_approval");
								}
								$ionicHistory.goBack();
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}
		}
	})


	.factory('teamAtExceptionSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var team_at_exception_data = [];
		var filtered_data = [];
		return {
			loadData: function (target_date, is_show_leave, is_show_attendance, employee_list) {
				var is_lv = (is_show_leave ? '1' : '0');
				var is_out = (is_show_attendance ? '1' : '0');
				var _str = '';

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getTeamAtExceptionData&' + _str + '&target_date=' + target_date + '&is_lv=' + is_lv + '&is_out=' + is_out + '&empl_no_list=' + employee_list, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, team_at_exception_data);
					angular.copy(team_at_exception_data, filtered_data);
					filtered_data.data_ready = true;
					for (var i = 0; i < filtered_data.length; i++) {
						filtered_data[i].list2_has_data = 0;
						for (var j = 0; j < filtered_data[i].list2.length; j++) {
							if (filtered_data[i].list2[j].num_type != "") {
								filtered_data[i].list2_has_data = 1;
								break;
							}
						}
					}

					if ($("#team_at_exception_filter_employee_list").val() != '') {
						var employee_list_array = $("#team_at_exception_filter_employee_list").val().split(',');
						for (var j = 0; j < employee_list_array.length; j++) {
							for (var i = 0; i < filtered_data.length; i++) {
								if (employee_list_array[employee_list_array.length - j - 1] == filtered_data[i].employee_no) {
									filtered_data.unshift(filtered_data.splice(i, 1)[0]);
									break;
								}
							}
						}
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getData: function () {
				return filtered_data;
			},
			clearData: function () {
				team_at_exception_data = [];
				filtered_data = [];
			}
		}
	})

	.factory('teamAtExceptionEmployeeSelectSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var team_at_exception_employee_select_data = [];
		return {
			loadData: function (employee_list) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}

				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getTeamAtExceptionEmployeeSelectData&' + _str + '&employee_no_list=' + employee_list, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					var temp_obj = new Object();
					temp_obj.total_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck == true) {
							temp_obj.total_checked++;
						}
					}

					if (employee_list != '') {
						var employee_list_array = employee_list.split(',');
						for (var j = 0; j < employee_list_array.length; j++) {
							for (var i = 0; i < data.length; i++) {
								if (employee_list_array[employee_list_array.length - j - 1] == data[i].emp) {
									data.unshift(data.splice(i, 1)[0]);
									break;
								}
							}
						}
					}


					temp_obj.data = data;
					angular.copy(temp_obj, team_at_exception_employee_select_data);
					team_at_exception_employee_select_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				team_at_exception_employee_select_data = [];
			},
			getData: function () {
				return team_at_exception_employee_select_data;
			}
		}
	})

	.factory('LvBalanceTeamRecordSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout, $ionicScrollDelegate) {
		var leave_balance_team_record_data = [];
		var current_page = 1;
		var end_of_list = {};
		end_of_list.status = false;
		var search_control = {};
		search_control.search_val = '';
		var searchState = {};
		searchState.flag = false;
		searchState.is_show_wrap = true;
		var searchNodata = {};
		searchNodata.is_search = false;
		return {
			loadData: function (dept_id_list, filter_str) {
				current_page = 1;

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvBalanceTeamRecordData&' + _str + '&dept_id_list=' + dept_id_list + '&current_page=' + current_page + '&filter_str=' + filter_str,
					timeout: _var_timeout,

					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						$ionicScrollDelegate.scrollTop();

						var _data = $.parseJSON(data);
						//angular.copy(_data, leave_balance_team_record_data);
						searchState.flag = true;
						searchState.is_show_wrap = true;
						//document.getElementById("LeaveBalanceTeamRecordWrap").style.display='block';
						current_page++;

						if (typeof (_data.length) == 'undefined') {
							end_of_list.status = true;
						} else {
							if (_data.length < 20) {

								end_of_list.status = true;
							} else {

								end_of_list.status = false;
							}
						}

						//leave_balance_team_record_data=[];

						angular.copy(_data, leave_balance_team_record_data);
						leave_balance_team_record_data.data_ready = true;
						document.getElementById('statistics_content_div').style.display = 'block';



					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			loadSearchData: function (dept_id_list, filter_str) {
				current_page = 1;

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvBalanceTeamRecordData&' + _str + '&dept_id_list=' + dept_id_list + '&current_page=' + current_page + '&filter_str=' + filter_str,
					timeout: _var_timeout,

					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);


						if (leave_balance_team_record_data.length == 0) {
							angular.copy(_data, leave_balance_team_record_data);
						} else {
							if (_data.length != 0) {
								for (var i = 0; i < _data.length; i++) {
									leave_balance_team_record_data.push(_data[i]);
								}


							}

						}

						//angular.copy(_data, leave_balance_team_record_data);
						leave_balance_team_record_data.data_ready = true;
						current_page++;

						if (_data.length < 20) {
							end_of_list.status = true;
						} else {
							end_of_list.status = false;
						}
						//$scope.$broadcast('scroll.infiniteScrollComplete');
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},

			loadMoreData: function ($scope, dept_id_list, filter_str) {

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getLvBalanceTeamRecordData&' + _str + '&dept_id_list=' + dept_id_list + '&current_page=' + current_page + '&filter_str=' + filter_str,
					timeout: _var_timeout,

					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						var _data = $.parseJSON(data);

						if (_data.length < 20) {
							end_of_list.status = true;
						} else {
							end_of_list.status = false;
						}

						if (leave_balance_team_record_data.length == 0) {
							angular.copy(_data, leave_balance_team_record_data);
						} else {
							if (_data.length != 0) {
								for (var i = 0; i < _data.length; i++) {
									leave_balance_team_record_data.push(_data[i]);
								}


							}

						}

						//angular.copy(_data, leave_balance_team_record_data);
						leave_balance_team_record_data.data_ready = true;
						current_page++;


						$scope.$broadcast('scroll.infiniteScrollComplete');
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getEndOfList: function () {
				return end_of_list;
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("LvBalanceTeamRecordSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("LvBalanceTeamRecordSearchDiv").style.display = 'none';
					document.getElementById("LvBalanceTeamRecordBack").style.display = 'block';
					return false;
				}
			},
			getData: function () {
				return leave_balance_team_record_data;
			},
			clearData: function () {
				leave_balance_team_record_data = [];
			},
			setSearchState: function (flag) {
				searchState.flag = flag;
			},
			getSearchValue: function () {
				return search_control;
			},
			getSearchNodata: function () {
				return searchNodata;
			},
			setSearchValue: function (search_value) {
				$timeout(function () {
					search_control.search_val = search_value;
				})
			},
			setSearchNodata: function (flag) {
				searchNodata.is_search = flag;
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			getSearchState: function () {
				return searchState;
			},
			setIsShowWrap: function (flag) {
				searchState.is_show_wrap = flag;
			}
		}
	})


	.factory('benefitSettingSev', function ($http, $rootScope, $ionicPopup) {
		var ess_my_apply_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_apply_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_apply_data = [];
			},
			getData: function () {
				return ess_my_apply_data;
			},

			loadMoreData: function ($scope) {

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					//$rootScope.hideLoading();
					//ess_my_apply_data.concat(data);
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}

					$scope.$broadcast("scroll.infiniteScrollComplete");
					if (ess_my_apply_data.length >= 200) {
						$scope.scroll_last_page = true;
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});

			}
		}
	})


	.factory('userImportResultSev', function ($http, $rootScope, $ionicPopup) {
		var user_import_result_data = [];
		return {
			loadData: function (operate_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadUserImportResultData&' + _str + '&operate_date=' + operate_date, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (data.success_list.length > 0) {
						//document.getElementById('user_import_result_success_list').addClass('user_import_result_success_list_not_empty');
						document.getElementById('user_import_result_success_list').style.paddingBottom = "10px";
					}
					angular.copy(data, user_import_result_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				user_import_result_data = [];
			},
			getData: function () {
				return user_import_result_data;
			}
		}
	})

	.factory('perDataDetailSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, sysUserSev) {
		var master_details_data = {};
		return {
			loadStaffMsDetails: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadPerDetail&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					if (typeof (data.employee_name) != 'undefined') {
						var personnal_data_json = '{"img_src":"' + data.img_src + '","employee_no":"' + data.employee_no + '","staff_no":"' + data.staff_no + '","employee_name":"' + data.employee_name + '"}';
						setLocalStorageVar("personnal_data", personnal_data_json);
						sysUserSev.setData($.parseJSON(window.localStorage["personnal_data"]));
					} else {
						return;
					}

					data.age = new Date().getFullYear() - data.date_of_birth.split("-")[0];

					var id_type_data = [];
					data.id_type_index = '';
					data.id_type_data_key = '';
					for (var i = 0; i < data.id_type.length; i++) {
						id_type_data[i] = data.id_type[i];
						id_type_data[i].key = data.id_type[i].key_;
						id_type_data[i].value = data.id_type[i].value_;
						if (id_type_data[i].ch) {
							data.id_type_index = i;
							data.id_type_data_key = id_type_data[i].key;
						}
					}
					data.id_type_data = id_type_data;

					//data.id_type_data_key=id_type_data[data.id_type_index].key;

					var gender_data = [];
					data.gender_index = '';
					data.gender_data_key = '';
					for (var i = 0; i < data.gender.length; i++) {
						gender_data[i] = data.gender[i];
						gender_data[i].key = data.gender[i].key_;
						gender_data[i].value = data.gender[i].value_;
						if (gender_data[i].ch) {
							data.gender_index = i;
							data.gender_data_key = gender_data[i].key;
						}
					}
					data.gender_data = gender_data;


					var nationality_data = [];
					data.nationality_index = '';
					data.nationality_data_key = '';
					for (var i = 0; i < data.nationality.length; i++) {
						nationality_data[i] = data.nationality[i];
						nationality_data[i].key = data.nationality[i].key_;
						nationality_data[i].value = data.nationality[i].value_;
						if (nationality_data[i].ch) {
							data.nationality_index = i;
							data.nationality_data_key = nationality_data[i].key;
						}
					}
					data.nationality_data = nationality_data;


					var race_data = [];
					data.race_index = '';
					data.race_data_key = '';
					for (var i = 0; i < data.race.length; i++) {
						race_data[i] = data.race[i];

						race_data[i].key = data.race[i].key_;
						race_data[i].value = data.race[i].value_;
						if (race_data[i].ch) {
							data.race_index = i;
							data.race_data_key = race_data[i].key;
						}
					}
					data.race_data = race_data;

					var education_level_data = [];
					data.education_level_index = '';
					data.education_level_data_key = '';
					for (var i = 0; i < data.education_level.length; i++) {
						education_level_data[i] = data.education_level[i];
						education_level_data[i].key = data.education_level[i].key_;
						education_level_data[i].value = data.education_level[i].value_;
						if (education_level_data[i].ch) {
							data.education_level_index = i;
							data.education_level_data_key = education_level_data[i].key;
						}
					}
					data.education_level_data = education_level_data;
					angular.copy(data, master_details_data);

					master_details_data._gender_key = '';
					master_details_data._id_type_key = '';
					master_details_data._education_level_key = '';
					master_details_data._nationality_key = '';
					master_details_data._race_key = '';
					master_details_data._id_type = '';
					master_details_data._education_level = '';
					master_details_data._gender = '男';
					for (var i = 0.; i < master_details_data.gender.length; i++) {
						if (master_details_data.gender[i].ch) {
							master_details_data._gender_key = master_details_data.gender[i].key_
							master_details_data._gender = master_details_data.gender[i].value_;
						}
					}
					for (var i = 0.; i < master_details_data.id_type.length; i++) {
						if (master_details_data.id_type[i].ch) {
							master_details_data._id_type_key = master_details_data.id_type[i].key_;
							master_details_data._id_type = master_details_data.id_type[i].value_;
						}
					}
					for (var i = 0.; i < master_details_data.education_level.length; i++) {
						if (master_details_data.education_level[i].ch) {
							master_details_data._education_level_key = master_details_data.education_level[i].key_;
							master_details_data._education_level = master_details_data.education_level[i].value_;
						}
					}
					for (var i = 0.; i < master_details_data.nationality.length; i++) {
						if (master_details_data.nationality[i].ch) {
							master_details_data._nationality_key = master_details_data.nationality[i].key_
						}
					}
					for (var i = 0.; i < master_details_data.race.length; i++) {
						if (master_details_data.race[i].ch) {
							master_details_data._race_key = master_details_data.race[i].key_
						}
					}


				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				master_details_data = {};
			},
			getStaffMsDetails: function () {
				return master_details_data;
			},
			saveStaffPhoto: function (staff_employee_no) {

				var options = new FileUploadOptions();
				options.fileKey = 'personnal_details_employee_photo';
				options.chunkedMode = false;
				options.mimeType = "multipart/form-data";
				options.headers = {
					Connection: "close"
				}
				var params = new Object();

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					params._user_name = window.localStorage['_user_name'];
					params._pass_word = window.localStorage['_pass_word'];
					params._is_login = window.localStorage['_is_login'];
					params._notification_token = window.localStorage['_notification_token'];
					params._device_type = window.localStorage['_device_type'];
				}
				//alert(staff_employee_no)
				params.employee_no = staff_employee_no;


				options.chunkedMode = false;
				options.params = params;
				var ft = new FileTransfer();
				$rootScope.showLoading();
				ft.upload(
					document.getElementById('perdatadetail_bg_img').src,
					window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveStaffBackgroundImg',
					function (data) {
						$rootScope.hideLoading();

						var _data = $.parseJSON(data.response);
						if (typeof (_data.message) != 'undefined') {
							$('#personnal_data_details_bg').attr("style", "position: relative ;height: 210px;background-image: url(" + document.getElementById('perdatadetail_bg_img').src + ");background-size:100%;");
							$('#personnal_data_details_other_bg').attr("style", "position: relative;height: 210px;background-image: url(" + document.getElementById('perdatadetail_bg_img').src + ");background-size:100%;");
						} else {
							window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
						}

					},
					function (error) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}, options);

			}


		}
	})

	.factory('EditIdDetailsSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, perDataDetailSev) {
		var master_details_data = {};
		return {
			saveStaffDetails: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePerDataDetail&' + _str, {}, {
					params: {
						employee_no: $scope.staff_master_details.employee_no,
						employee_name: $scope.staff_master_details.employee_name,
						p_n_i: $("#p_n_i").val(),
						o_n_i: $("#o_n_i").val(),
						join_date: $scope.staff_master_details.join_date,
						p_c_d: $scope.staff_master_details.p_c_d,
						id_type: $scope.staff_master_details.id_type_data_key,
						id_number: $("#id_number").val(),
						date_of_birth: $scope.staff_master_details.date_of_birth,
						gender: $scope.staff_master_details._gender_key,
						home_tel_no: $scope.staff_master_details.home_tel_no,
						email: $scope.staff_master_details.email,
						address: $scope.staff_master_details.address,
						nationality: $scope.staff_master_details._nationality,
						p_o_b: $scope.staff_master_details.p_o_b,
						race: $scope.staff_master_details.race_data_key,
						education_level: $scope.staff_master_details.education_level_data_key,
						emergency_contact_name1: $scope.staff_master_details.emergency_contact_name1,
						emergency_contact_no1: $scope.staff_master_details.emergency_contact_no1,
						is_require_upload: '0',
						is_need_valid: '0',
						data_type: "2"

					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_personnal_save');
							perDataDetailSev.loadStaffMsDetails();
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})

	.factory('EditContactDetailsSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, perDataDetailSev) {
		var master_details_data = {};
		return {
			saveStaffDetails: function ($scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.savePerDataDetail&' + _str, {}, {
					params: {
						employee_no: $scope.staff_master_details.employee_no,
						employee_name: $scope.staff_master_details.employee_name,
						p_n_i: $("#p_n_i").val(),
						o_n_i: $("#o_n_i").val(),
						join_date: $scope.staff_master_details.join_date,
						p_c_d: $scope.staff_master_details.p_c_d,
						id_type: $scope.staff_master_details.id_type_data_key,
						id_number: $scope.staff_master_details.id_number,
						date_of_birth: $scope.staff_master_details.date_of_birth,
						gender: $scope.staff_master_details._gender_key,
						home_tel_no: $("#mobile_no").val(),
						email: $("#email").val(),
						address: $("#address").val(),
						nationality: $scope.staff_master_details._nationality,
						p_o_b: $scope.staff_master_details.p_o_b,
						race: $scope.staff_master_details.race_data_key,
						education_level: $scope.staff_master_details.education_level_data_key,
						emergency_contact_name1: $("#emergency_contact_name1").val(),
						emergency_contact_no1: $("#emergency_contact_no1").val(),
						is_require_upload: '0',
						is_need_valid: '0',
						data_type: "3"

					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_personnal_save');
							perDataDetailSev.loadStaffMsDetails();
							$ionicHistory.goBack();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})
	.factory('MyBusinessSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var master_details_data = {};
		return {
			loadStaffMsDetails: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyBusiness&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, master_details_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				master_details_data = {};
			},
			getStaffMsDetails: function () {
				return master_details_data;
			}

		}
	})


	.factory('atSignInNewSev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout, $ionicScrollDelegate) {
		var at_sign_in_data = [];
		var display_time = '';
		var clock_timeout;
		var location_error_obj = {};

		location_error_obj.location_not_valid = false;
		location_error_obj.wifi_sign_in = false;
		location_error_obj.sign_in_no_validation = false;
		location_error_obj.wifi_not_valid = false;
		location_error_obj.location_valid = false;
		location_error_obj.sign_in_all_valid = false;
		//新方案
		location_error_obj.sign_in_validate_error = false;
		location_error_obj.sign_in_validate_no_error = false;

		var service_obj = {

			loadData: function (current_date, is_reload) {
				var _str = '';
				var temp_location_not_valid;
				var temp_location_valid;
				var temp_wifi_sign_in;
				var temp_wifi_not_valid;
				var temp_sign_in_all_valid;

				var temp_sign_in_validate_error;
				var temp_sign_in_validate_no_error;

				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				document.getElementById('fufu_spinner_div').style.display = "none";
				$(".atSignInNewCtrlSpinnerWarp").css({
					"display": "block"
				});
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtSignInData&' + _str,
					timeout: _var_timeout,
					data: {
						current_date: '',
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {

						$rootScope.hideLoading();
						$(".atSignInNewCtrlSpinnerWarp").css({
							"display": "none"
						});

						var location_loading = false;
						var wifi_loading = false;
						var validate_no_error = false;
						var hour;
						var minute;
						var second;
						var hour_diff = 0;
						var minute_diff = 0;
						var second_diff = 0;
						var today;
						var current_address = '';
						var current_latitude = '';
						var current_longitude = '';
						var address_city;

						var _data = $.parseJSON(data);
						if (_data.is_can_in == '0') {
							_data.setting_detail = [];
						}
						angular.copy(_data, at_sign_in_data);



						if (!is_reload) {
							$timeout(function () {
								location_error_obj.location_not_valid = false;
								location_error_obj.location_valid = false;
								location_error_obj.wifi_sign_in = false;
								location_error_obj.sign_in_no_validation = false;
								location_error_obj.wifi_not_valid = false;
								location_error_obj.sign_in_all_valid = false;
								location_error_obj.sign_in_validate_error = false;
								location_error_obj.sign_in_validate_no_error = false;

							});





							try {

								if (at_sign_in_data.setting_detail && at_sign_in_data.setting_detail.length) {
									for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
										if (at_sign_in_data.setting_detail[i].valid_mode == '1,2') {
											at_sign_in_data.setting_detail[i].wifi_validate = false;
											at_sign_in_data.setting_detail[i].gps_validate = false;
										} else if (at_sign_in_data.setting_detail[i].valid_mode == '') {
											at_sign_in_data.setting_detail[i].wifi_validate = true;
											at_sign_in_data.setting_detail[i].gps_validate = true;
										} else if (at_sign_in_data.setting_detail[i].valid_mode == '1') {
											at_sign_in_data.setting_detail[i].wifi_validate = false;
											at_sign_in_data.setting_detail[i].gps_validate = true;
										} else if (at_sign_in_data.setting_detail[i].valid_mode == '2') {
											at_sign_in_data.setting_detail[i].wifi_validate = true;
											at_sign_in_data.setting_detail[i].gps_validate = false;
										}
									}
								}


								if (at_sign_in_data.setting_detail && at_sign_in_data.setting_detail.length == 1 && at_sign_in_data.setting_detail[0].valid_mode == '' && at_sign_in_data.can_fieldwork != '1') {
									$timeout(function () {
										location_error_obj.sign_in_validate_no_error = true;
										location_error_obj.sign_in_validate_error = false;
										document.getElementById("sign_in_validate_no_error").style.display = 'block';
										document.getElementById("sign_in_validate_error").style.display = 'none';
									});
								}

							} catch (e) {
								console.log(e.message);
							}

							// gps认证

							var temp_gps_valid_mode = '';

							if (at_sign_in_data.setting_detail && at_sign_in_data.setting_detail.length) {
								for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
									if (at_sign_in_data.setting_detail[i].valid_mode == '2') {
										if (temp_gps_valid_mode == '') {
											temp_gps_valid_mode = '2';
										}
									} else if (at_sign_in_data.setting_detail[i].valid_mode == '1,2') {
										temp_gps_valid_mode = '1,2';
									}
								}
							}


							at_sign_in_data.temp_gps_valid_mode = temp_gps_valid_mode;


							if (((at_sign_in_data.temp_gps_valid_mode == '1,2' || at_sign_in_data.temp_gps_valid_mode == '2') && at_sign_in_data.is_can_in == '1') || at_sign_in_data.can_fieldwork == '1') {
								try {


									location_loading = true;
									//document.getElementById("signindooricon").style.display = "none";
									//document.getElementById("signindooricongary").style.display = "block";
									$(".atSignInNewCtrlSpinnerWarp").css({
										"display": "block"
									});
									getLocation.location(function (msg) {
										try {
											if (at_sign_in_data.temp_gps_valid_mode == '1,2') {
												if (wifi_loading == false) {
													if (_data.is_can_in == '1') {
														//document.getElementById("signindooricon").style.display = "block";
														//document.getElementById("signindooricongary").style.display = "none";
													}
													$(".atSignInNewCtrlSpinnerWarp").css({
														"display": "none"
													});
												}
											} else {
												if (_data.is_can_in == '1') {
													//document.getElementById("signindooricon").style.display = "block";
													//document.getElementById("signindooricongary").style.display = "none";
												}
												$(".atSignInNewCtrlSpinnerWarp").css({
													"display": "none"
												});
											}


											current_address = msg.address;
											current_latitude = msg.latitude;
											current_longitude = msg.longitude;
											address_city = msg.city;
											if (typeof (msg) == 'undefined' || typeof (msg.address) == 'undefined') {
												current_address = '';
												current_latitude = '';
												current_longitude = '';
											}
											document.getElementById('wifi_sign_in_out').style.display = 'block';
											document.getElementById('wifi_sign_in_out_address').innerHTML = current_address;

											var longitude_end;
											var latitude_end;
											var longitude_begin;
											var latitude_begin;
											var loc_deviation;

											if (at_sign_in_data.is_can_in == '1') {
												for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
													if (at_sign_in_data.setting_detail[i].valid_mode == '1,2' || at_sign_in_data.setting_detail[i].valid_mode == '2') {
														longitude_end = parseFloat(at_sign_in_data.setting_detail[i].longitude);
														latitude_end = parseFloat(at_sign_in_data.setting_detail[i].latitude);
														longitude_begin = parseFloat(current_longitude);
														latitude_begin = parseFloat(current_latitude);
														loc_deviation = get_two_place_differ_meter(longitude_begin, latitude_begin, longitude_end, latitude_end);
														if (parseFloat(at_sign_in_data.setting_detail[i].location_deviation) > loc_deviation) {
															at_sign_in_data.setting_detail[i].gps_validate = true;
														}
													}
												}
												if (!wifi_loading) {
													validate_no_error = false;
													for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
														if (at_sign_in_data.setting_detail[i].wifi_validate && at_sign_in_data.setting_detail[i].gps_validate) {
															validate_no_error = true;
															break;
														}
													}


													if (at_sign_in_data.setting_detail.length != 0) {
														if (validate_no_error) {
															$timeout(function () {
																location_error_obj.sign_in_validate_no_error = true;
																location_error_obj.sign_in_validate_error = false;
																document.getElementById("sign_in_validate_no_error").style.display = 'block';
																document.getElementById("sign_in_validate_error").style.display = 'none';
															}, 100);
														} else {
															$timeout(function () {
																location_error_obj.sign_in_validate_no_error = false;
																location_error_obj.sign_in_validate_error = true;
																document.getElementById("sign_in_validate_no_error").style.display = 'none';
																document.getElementById("sign_in_validate_error").style.display = 'block';
															}, 100);
														}
													}

												}




											}

											location_loading = false;
										} catch (e) {}
									}, function () {
										try {
											$timeout(function () {
												$(".atSignInNewCtrlSpinnerWarp").css({
													"display": "none"
												});
												location_error_obj.sign_in_validate_no_error = false;
												location_error_obj.sign_in_validate_error = true;
												document.getElementById("sign_in_validate_no_error").style.display = 'none';
												document.getElementById("sign_in_validate_error").style.display = 'block';
											}, 100);
										} catch (e) {

										}
									});

								} catch (e) {
									console.log(e.message);
								}
							} else {
                                /* add by kevin at 2018-08-24 begin */ 
                                var len = (at_sign_in_data && at_sign_in_data.setting_detail && at_sign_in_data.setting_detail.length) || 0;
                                /* add by kevin at 2018-08-24 end */ 
								for (var i = 0; i < len; i++) {
									if (at_sign_in_data.setting_detail[i].wifi_validate && at_sign_in_data.setting_detail[i].gps_validate) {
										$timeout(function () {
											//为了解决div闪动问题, 我们默认隐藏这div, 如果不需要任何gps或者wifi认证我们马上显示这2个div
											location_error_obj.sign_in_validate_no_error = true;
											location_error_obj.sign_in_validate_error = false;
											//document.getElementById("sign_in_validate_no_error").style.display='block';
											//document.getElementById("sign_in_validate_error").style.display='none';
										});
										break;
									}
								}

							}

							// wifi认证
							var temp_wifi_valid_mode = '';
							for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
								if (at_sign_in_data.setting_detail[i].valid_mode == '1') {
									if (temp_wifi_valid_mode == '') {
										temp_wifi_valid_mode = '1';
									}
								} else if (at_sign_in_data.setting_detail[i].valid_mode == '1,2') {
									temp_wifi_valid_mode = '1,2';
								}
							}
							at_sign_in_data.temp_wifi_valid_mode = temp_wifi_valid_mode;

							if ((at_sign_in_data.temp_wifi_valid_mode == '1,2' || at_sign_in_data.temp_wifi_valid_mode == '1') && at_sign_in_data.is_can_in == '1') {

								try {
									wifi_loading = true;
									//document.getElementById("signindooricon").style.display = "none";
									//document.getElementById("signindooricongary").style.display = "block";
									$(".atSignInNewCtrlSpinnerWarp").css({
										"display": "block"
									});
									network.wifiInfo(function (msg) {
										try {
											if (location_loading == false) {
												if (_data.is_can_in == '1') {
													//document.getElementById("signindooricon").style.display = "block";
													//document.getElementById("signindooricongary").style.display = "none";
												}
												$(".atSignInNewCtrlSpinnerWarp").css({
													"display": "none"
												});
											}



											if (msg.state == '-1' && ionic.Platform.isIOS()) {
												$ionicPopup.alert({
													title: '提醒',
													template: '<div style="text-align: center;">无法获取当前WiFi,请启动WIFI重试</div>',
													okText: '确定'
												});
												return;
											}

											if (typeof (msg.mac) == 'undefined') {
												msg.mac = '';
											}

											if (typeof (msg.wifiName) == 'undefined') {
												msg.wifiName = '';
											}

											var wifi_arr1 = msg.wifiName.replace(/(.)(?=[^$])/g, "$1,").split(",");
											var wifi_str = "";
											for (var v = 0; v < wifi_arr1.length; v++) {
												if (wifi_arr1[v] != '"') {
													wifi_str = wifi_str + wifi_arr1[v];
												}
											}
											document.getElementById("sign_in_wifi_name").value = wifi_str;
											document.getElementById("sign_in_wifi_mac").value = msg.mac;

											for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
												if (at_sign_in_data.setting_detail[i].valid_mode == '1,2' || at_sign_in_data.setting_detail[i].valid_mode == '1') {
													if (at_sign_in_data.setting_detail[i].wifi_mac == msg.mac) {
														at_sign_in_data.setting_detail[i].wifi_validate = true;
													}
												}
											}
											if (!location_loading) {
												validate_no_error = false;
												for (var i = 0; i < at_sign_in_data.setting_detail.length; i++) {
													if (at_sign_in_data.setting_detail[i].wifi_validate && at_sign_in_data.setting_detail[i].gps_validate) {
														validate_no_error = true;
														break;
													}
												}

												if (at_sign_in_data.setting_detail.length != 0) {
													if (validate_no_error) {
														$timeout(function () {
															location_error_obj.sign_in_validate_no_error = true;
															location_error_obj.sign_in_validate_error = false;
															document.getElementById("sign_in_validate_no_error").style.display = 'block';
															document.getElementById("sign_in_validate_error").style.display = 'none';
														});
													} else {
														$timeout(function () {
															location_error_obj.sign_in_validate_no_error = false;
															location_error_obj.sign_in_validate_error = true;
															document.getElementById("sign_in_validate_no_error").style.display = 'none';
															document.getElementById("sign_in_validate_error").style.display = 'block';
														});
													}
												}
											}


											wifi_loading = false;
										} catch (e) {

										}

									});
								} catch (e) {
									console.log(e.message);

								}

							}






						} // end of reload


						at_sign_in_data.c_d = at_sign_in_data.c_d.split('-')[0] + "年" + at_sign_in_data.c_d.split('-')[1] + "月" + at_sign_in_data.c_d.split('-')[2] + "日";
						if (document.getElementById('sign_in_tab_1') && document.getElementById('sign_in_tab_1').style) {
							document.getElementById('sign_in_tab_1').style.color = '#53afff';
							document.getElementById('sign_in_tab_1').style.backgroundColor = 'white';
						}
						if (document.getElementById('sign_in_tab_2') && document.getElementById('sign_in_tab_2').style) {
							document.getElementById('sign_in_tab_2').style.color = 'white';
							document.getElementById('sign_in_tab_2').style.backgroundColor = '#53afff';
						}
						if (document.getElementById('signindoor') && document.getElementById('signindoor').style) {
							document.getElementById('signindoor').style.display = "block";
						}
						if (document.getElementById('signoutdoor') && document.getElementById('signoutdoor').style) {
							document.getElementById('signoutdoor').style.display = "none";
						}


						var sign_in_new_content_top;



						if (_data.ca_r.length == '0') {
							/*
              $("#atSignInNew .sign_in_new_content").css({
                "top":(parseInt(document.body.scrollHeight)*0.50 + 122) + "px"
              });
              $(".platform-win32.platform-cordova #atSignInNew .sign_in_new_content").css({
                "top":(parseInt(document.body.scrollHeight)*0.50 + 102) + "px"
              });
              $(".platform-android.platform-cordova #atSignInNew .sign_in_new_content").css({
                "top":(parseInt(document.body.scrollHeight)*0.50 + 102) + "px"
              });
			*/
						} else {

							if (ionic.Platform.isIOS()) {
								sign_in_new_content_top = '324px';
							} else {
								sign_in_new_content_top = '304px';
							}



							/*
              var animate_duration = 0.5;
              TweenMax.to(document.getElementById('sign_in_new_content'),animate_duration,{
                top:sign_in_new_content_top,
                autoRound:false,
                force3D:true,
                onComplete: function(){
                  $ionicScrollDelegate.scrollTop();
                }
              });

              TweenMax.to(document.getElementById('at_sign_in_new_wrap'),animate_duration,{
                height:'202px',
                autoRound:false,
                force3D:true,
                onComplete: function(){
                  $ionicScrollDelegate.scrollTop();
                }
              });
              TweenMax.to(document.getElementById('signindooricon'),animate_duration,{
                top:'120px',
                autoRound:false,
                force3D:true
              });
              TweenMax.to(document.getElementById('signindooricongary'),animate_duration,{
                top:'120px',
                autoRound:false,
                force3D:true
              });
              TweenMax.to(document.getElementById('at_sign_in_new_bg_2_div'),animate_duration,{
                transform:'translate(66px,53px)',
                autoRound:false,
                force3D:true
              });

              TweenMax.to(document.getElementById('at_sign_out_new_wrap'),animate_duration,{
                height:'202px',
                autoRound:false,
                force3D:true
              });
              TweenMax.to(document.getElementById('signoutdooricon'),animate_duration,{
                top:'120px',
                autoRound:false,
                force3D:true
              });
              TweenMax.to(document.getElementById('signoutdooricongary'),animate_duration,{
                top:'120px',
                autoRound:false,
                force3D:true
              });
              TweenMax.to(document.getElementById('at_sign_out_new_bg_2_div'),animate_duration,{
                transform:'translate(66px,53px)',
                autoRound:false,
                force3D:true
              });
			  */
							//document.getElementById("at_sign_out_new_wrap").style.height='202px';
							//document.getElementById("signoutdooricon").style.top='120px';
							//document.getElementById("at_sign_out_new_bg_2_div").style.transform='translate(66px,53px)';
						}


						if (_data.is_can_in == '0') {
							document.getElementById("signindooricongary").style.display = "block";
							document.getElementById("signindooricon").style.display = "none";

							if (_data.is_can_out == '1') {
								document.getElementById("signindooricongary").style.display = "none";
								document.getElementById("signindooricon").style.display = "block";
							}
						} else {
							document.getElementById("signindooricongary").style.display = "none";
							document.getElementById("signindooricon").style.display = "block";
						}

						if (_data.is_can_out == '0') {
							document.getElementById("signoutdooricongary").style.display = "block";
						}
						if (_data.can_fieldwork == '0') {
							document.getElementById("signoutdooricongary").style.display = "block";
							document.getElementById("signoutdooricon").style.display = "none";
						} else {
							document.getElementById("signoutdooricongary").style.display = "none";
							document.getElementById("signoutdooricon").style.display = "block";
						}




						if (_data.is_c_d == 0) {
							return
						}

						hour = _data.c_t.split(':')[0];
						hour = parseInt(hour, '10');
						minute = _data.c_t.split(':')[1];
						minute = parseInt(minute, '10');
						second = _data.c_t.split(':')[2];
						second = parseInt(second, '10');

						today = new Date();
						hour_diff = hour - today.getHours();
						minute_diff = minute - today.getMinutes();
						second_diff = second - today.getSeconds();

						clearTimeout(clock_timeout);

						function run_clock() {

							if ($ionicHistory.currentView().stateName != 'home_page.at_sign_in_new') {
								clearTimeout(clock_timeout);
								return;
							}
							clock_timeout = setTimeout(run_clock, 1000);
							display_time = '';

							today = new Date();
							hour = today.getHours() + hour_diff;
							minute = today.getMinutes() + minute_diff;
							second = today.getSeconds() + second_diff;


							if (second >= 60) {
								second = second - 60;
								minute++;
							} else if (second < 0) {
								second = second + 60;
								minute--;
							}
							if (minute >= 60) {
								minute = minute - 60;
								hour++;
							} else if (minute < 0) {
								minute = minute + 60;
								hour--;
							}
							if (hour >= 24) {
								hour = hour - 24;
								//$scope.load_card_record();
								service_obj.loadData($('#at_sign_in_current_date').val());
								clearTimeout(clock_timeout);
								return;
							} else if (hour < 0) {
								hour = hour + 24;
							}
							display_time = '';
							if (hour <= 9)
								display_time = '0' + hour;
							else
								display_time = hour;
							if (minute <= 9)
								display_time += ':' + '0' + minute;
							else
								display_time += ':' + minute;
							if (second <= 9)
								display_time += ':' + '0' + second;
							else
								display_time += ':' + second;


							$('#sign_in_clock_div').html(display_time);
							$('#sign_out_clock_div').html(display_time);

						}
						run_clock();
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						$(".atSignInNewCtrlSpinnerWarp").css({
							"display": "none"
						});

						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getData: function () {

				return at_sign_in_data;
			},
			getLocationErrorObjData: function () {
				return location_error_obj;
			},
			clearLocationErrorObjData: function () {
				location_error_obj.location_not_valid = false;
				location_error_obj.location_valid = false;
				location_error_obj.wifi_sign_in = false;
				location_error_obj.sign_in_no_validation = false;
				location_error_obj.wifi_not_valid = false;
				location_error_obj.sign_in_all_valid = false;
				location_error_obj.sign_in_validate_error = false;
				location_error_obj.sign_in_validate_no_error = false;
			},
			clearData: function () {
				at_sign_in_data = [];
			},
			getDisplayTime: function () {
				return display_time;
			},

			signInAction: function ($scope, current_address, current_latitude, current_longitude) {

				/*
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				*/
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//alert(device.uuid);
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.signInAction&' + _str,
					timeout: _var_timeout,
					data: {
						latitude: current_latitude,
						longitude: current_longitude,
						address: current_address,
						wifi_value: document.getElementById("sign_in_wifi_name").value,
						card_rec_time: $('#sign_in_clock_div').html(),
						wifi_mac: document.getElementById("sign_in_wifi_mac").value,
						mobile_token: device.uuid,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {

						$rootScope.hideLoading();
						$(".atSignInNewCtrlSpinnerWarp").css({
							"display": "none"
						});
						document.getElementById('sign_in_validate_error').style.display = "block";
						document.getElementById('sign_in_validate_no_error').style.display = "block";
						//fufu_processing = false;
						$scope.processing = 0;
						var _data = $.parseJSON(data);
						if (_data.flag == '2') {
							$scope.reddi();
						} else {
							if (_data.flag == '0') {
								//window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function() {
								//fufuMobclickAgent('click_sign_in_submit');
								//$scope.load_card_record();
								//});
								$("#signinsucessbox").css({
									'display': 'block'
								})
								$("#signinsucessdiv").slideDown();
								$("#signinsucessdiv").css({
									'-webkit-transform': 'scale(1,1)'
								})
								setTimeout(function () {
									$("#signinsucessdiv").css({
										"opacity": '0'
									})
								}, 1900);
								setTimeout(function () {
									$("#signinsucessbox").css({
										'display': 'none'
									})
									$("#signinsucessdiv").css({
										"opacity": '1',
										'-webkit-transform': 'scale(0.1,0.1)'
									})
								}, 1900);
								fufuMobclickAgent('click_sign_in_submit');
								$scope.load_card_record();
							} else {
								window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
							}
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						$(".atSignInNewCtrlSpinnerWarp").css({
							"display": "none"
						});
						document.getElementById('sign_in_validate_error').style.display = "block";
						document.getElementById('sign_in_validate_no_error').style.display = "block";
						//fufu_processing = false;
						//$('._press_at_sign_in').text('按一下打卡');
						$scope.processing = 0;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
		return service_obj;
	})

	.factory('UseHelpSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var use_help_data = [];
		return {
			loadData: function (menu_key) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadUseHelpData&' + _str + '&menu_key=' + menu_key, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, use_help_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				use_help_data = [];
			},
			getData: function () {
				return use_help_data;
			}

		}
	})
	.factory('UseHelpDetailSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var use_help_detail_data = {};
		return {
			loadData: function (help_title_id) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadUseHelpDetailData&' + _str + '&help_title_id=' + help_title_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					document.getElementById("use_help_detail_content_text").innerHTML = data.help_text;
					angular.copy(data, use_help_detail_data);
					use_help_detail_data.done_good = '';
					use_help_detail_data.done_bad = '';
					if (use_help_detail_data.opinion_text == '1') {
						use_help_detail_data.done_good = true;
						use_help_detail_data.done_bad = false;
					} else if (use_help_detail_data.opinion_text == '0') {
						use_help_detail_data.done_bad = true;
						use_help_detail_data.done_good = false;
					} else {
						use_help_detail_data.done_bad = false;
						use_help_detail_data.done_good = false;
					}
					console.log(use_help_detail_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				use_help_detail_data = {};
			},
			getData: function () {
				return use_help_detail_data;
			},
			save: function (help_title_id, opinion_text, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.post(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveUserHelpDetail&' + _str, {}, {
					params: {
						help_title_id: help_title_id,
						opinion_text: opinion_text

					},
					timeout: _var_timeout
				}).
				success(function (data, status, headers, config) {
					$rootScope.hideLoading();
					if (data.flag == '0') {
						window.fufuSuccessBox(data.message, fufu_success_message_box_duration, function () {
							fufuMobclickAgent('click_personnal_save');
							$scope.reload_data();
						});
					} else {
						window.fufuMessageBox(data.message, fufu_message_box_duration, function () {});
					}
				}).
				error(function (data, status, headers, config) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			}
		}
	})


	.factory('atSignInHistorySev', function ($http, $rootScope, $ionicPopup, $ionicHistory, $timeout) {
		var at_sign_in_data = [];
		var display_time = '';
		var clock_timeout;
		var service_obj = {
			loadData: function (current_date) {
				//alert(current_date);
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.getAtSignInData&' + _str,
					timeout: _var_timeout,
					data: {
						current_date: current_date,
						time_zone: $rootScope.get_utc_time_zone()
					},
					success: function (data, status, headers, config) {
						//$rootScope.hideLoading();
						try {
							var _data = $.parseJSON(data);

							$("#atSignInHistoryContent").css({
								'opacity': '1'
							});
							$("#atSignInHistoryCtrlSpinner").css({
								'display': 'none'
							})
							$timeout(function () {
								angular.copy(_data, at_sign_in_data);
								at_sign_in_data.is_future = false;
								var dt = new Date();
								if (parseInt(current_date.split('-')[0]) - parseInt(dt.getFullYear()) > 0) {

									at_sign_in_data.is_future = true;
								} else if (parseInt(current_date.split('-')[0]) - parseInt(dt.getFullYear()) < 0) {
									at_sign_in_data.is_future = false;
								} else {
									if ((parseInt(current_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) > 0) {
										at_sign_in_data.is_future = true;
									} else if ((parseInt(current_date.split('-')[1], 10) - 1) - parseInt(dt.getMonth()) < 0) {
										at_sign_in_data.is_future = false;
									} else {
										if (parseInt(current_date.split('-')[2]) - parseInt(dt.getDate()) >= 0) {
											at_sign_in_data.is_future = true;
										} else if (parseInt(current_date.split('-')[2]) - parseInt(dt.getDate()) < 0) {
											at_sign_in_data.is_future = false;
										}
									}
								}
							})
						} catch (e) {

						}









					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			},
			getData: function () {
				return at_sign_in_data;
			},
			clearData: function () {
				at_sign_in_data = [];
			}

		}
		return service_obj;
	})

	.factory('atHomeNewSev', function ($http, $rootScope, $ionicPopup) {
		var ess_my_apply_data = [];
		return {
			loadData: function () {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_apply_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				ess_my_apply_data = [];
			},
			getData: function () {
				return ess_my_apply_data;
			},

			loadMoreData: function ($scope) {

				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				//$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApplyData&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					//$rootScope.hideLoading();
					//ess_my_apply_data.concat(data);
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}
					for (i = 0; i < data.length; i++) {
						ess_my_apply_data.push(data[i]);
					}

					$scope.$broadcast("scroll.infiniteScrollComplete");
					if (ess_my_apply_data.length >= 200) {
						$scope.scroll_last_page = true;
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});

			}
		}
	})

	.factory('cardRecordAdjApplySev', function ($http, $rootScope, $ionicPopup, $ionicHistory) {
		var card_record_adj_apply_data = {};
		var ess_empl_data = [];
		return {
			chooseAdjReason:function(adj_type_id,shift_date,employee_no){
				var _str = '';
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];

				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.chooseAdjReason&adj_type_id='+adj_type_id+'&employee_no='+employee_no+'&shift_date=' + shift_date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (card_record_adj_apply_data.is_standard_wf == '1') {
						card_record_adj_apply_data.approver_list = data.approver_list;
						card_record_adj_apply_data.approver_id_list = data.approver_id_list;
						var approver_list = [];
						for (var i = 0; i < card_record_adj_apply_data.approver_list.length; i++) {
							approver_list.push(card_record_adj_apply_data.approver_list[i])
						}
						card_record_adj_apply_data._approver_list = approver_list;
						document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
					}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadData: function (shift_date, $scope) {
				var _str = '';
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];

				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadCardRecordAdjApplyData&shift_date=' + shift_date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					if (data.approver_list_flag) {
						if (window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_approver_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_approver_list" + window.localStorage['_user_name']] != '') {
							data.approver_list = $.parseJSON(window.localStorage["ess_approver_list" + window.localStorage['_user_name']]);
							for (var i = 0; i < data.approver_list.length; i++) {
								$scope.select_user_id += data.approver_list[i].user_id;
								if (i <= data.approver_list.length - 2) {
									$scope.select_user_id += ',';
								}
							}
							data._approver_list = data.approver_list;
						}
					}

					if (data.notify_list_flag) {
						if (window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != null && typeof (window.localStorage["ess_notify_list" + window.localStorage['_user_name']]) != 'undefined' && window.localStorage["ess_notify_list" + window.localStorage['_user_name']] != '') {

							data.notify_list = $.parseJSON(window.localStorage["ess_notify_list" + window.localStorage['_user_name']]);

							for (var i = 0; i < data.notify_list.length; i++) {

								$scope.select_notify_id += data.notify_list[i].user_id;
								if (i <= data.notify_list.length - 2) {
									$scope.select_notify_id += ',';
								}
							}
						}
					}
					document.getElementById('approver_list_div').style.width = (data.approver_list.length + 1) * 100 + 20 + 'px';
					document.getElementById('notify_list_div').style.width = (data.notify_list.length + 1) * 100 + 20 + 'px';

					angular.copy(data, card_record_adj_apply_data);
					if (typeof (card_record_adj_apply_data.adj_times) != 'undefined') {
						card_record_adj_apply_data.date_text = shift_date.split("-")[0] + '年' + shift_date.split("-")[1] + '月' + shift_date.split("-")[2] + '日';
						if (card_record_adj_apply_data.shift_date_dw == '1') {
							card_record_adj_apply_data.day_of_week_text = "星期天";
						} else if (card_record_adj_apply_data.shift_date_dw == '2') {
							card_record_adj_apply_data.day_of_week_text = "星期一";
						} else if (card_record_adj_apply_data.shift_date_dw == '3') {
							card_record_adj_apply_data.day_of_week_text = "星期二";
						} else if (card_record_adj_apply_data.shift_date_dw == '4') {
							card_record_adj_apply_data.day_of_week_text = "星期三";
						} else if (card_record_adj_apply_data.shift_date_dw == '5') {
							card_record_adj_apply_data.day_of_week_text = "星期四";
						} else if (card_record_adj_apply_data.shift_date_dw == '6') {
							card_record_adj_apply_data.day_of_week_text = "星期五";
						} else if (card_record_adj_apply_data.shift_date_dw == '7') {
							card_record_adj_apply_data.day_of_week_text = "星期六";
						}

						card_record_adj_apply_data.at_start_text = card_record_adj_apply_data.at_start.split('/')[0] + '年' + card_record_adj_apply_data.at_start.split('/')[1] + '月累计补签';

						/*for (var i = 0; i < card_record_adj_apply_data.notify_list.length; i++) {
							$scope.select_notify_id = $scope.select_notify_id + card_record_adj_apply_data.notify_list[i].user_id;
							card_record_adj_apply_data.notify_list[i].flag = 1;
							if (i < card_record_adj_apply_data.notify_list.length - 1) {
								$scope.select_notify_id = $scope.select_notify_id + ',';
							}
						}
						*/
						if (card_record_adj_apply_data.is_standard_wf == '1') {
							var approver_list = [];
							for (var i = 0; i < card_record_adj_apply_data.approver_list.length; i++) {
								approver_list.push(card_record_adj_apply_data.approver_list[i])

							}
							card_record_adj_apply_data._approver_list = approver_list;
							console.log(approver_list);
							document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
						} else {
							if (card_record_adj_apply_data.approver_list.length > 0) {
								$scope.select_user_id = card_record_adj_apply_data.approver_list[card_record_adj_apply_data.approver_list.length - 1].user_id;
								card_record_adj_apply_data.approver_list.splice(0, card_record_adj_apply_data.approver_list.length - 1);
								card_record_adj_apply_data.approver_list[0].flag = 1;
							}
							card_record_adj_apply_data._approver_list = card_record_adj_apply_data.approver_list;
							document.getElementById('approver_list_div').style.width = (card_record_adj_apply_data.approver_list.length + 1) * 100 + 20 + 'px';
						}

						document.getElementById('notify_list_div').style.width = (card_record_adj_apply_data.notify_list.length + 1) * 100 + 20 + 'px';
						if (card_record_adj_apply_data.adj_type_id == '0') {
							document.getElementById("card_record_adj_apply_remark").style.display = 'block';

						}

						for (var i = 0; i < card_record_adj_apply_data.adj_type.length; i++) {
							card_record_adj_apply_data.adj_type[i].key = card_record_adj_apply_data.adj_type[i].key_;
							card_record_adj_apply_data.adj_type[i].value = card_record_adj_apply_data.adj_type[i].value_;
							if (card_record_adj_apply_data.adj_type[i].key_ == card_record_adj_apply_data.adj_type_id) {
								document.getElementById("adjReason").innerHTML = card_record_adj_apply_data.adj_type[i].value_;
								card_record_adj_apply_data.adj_type_index = i;
							}
						}

						card_record_adj_apply_data.first_in = '';
						card_record_adj_apply_data.first_in_old = '';
						card_record_adj_apply_data.first_out = '';
						card_record_adj_apply_data.first_out_old = '';
						card_record_adj_apply_data.second_in = '';
						card_record_adj_apply_data.second_in_old = '';
						card_record_adj_apply_data.second_out = '';
						card_record_adj_apply_data.second_out_old = '';
						card_record_adj_apply_data.third_in = '';
						card_record_adj_apply_data.third_in_old = '';
						card_record_adj_apply_data.third_out = '';
						card_record_adj_apply_data.third_out_old = '';
						card_record_adj_apply_data.forth_in = '';
						card_record_adj_apply_data.forth_in_old = '';
						card_record_adj_apply_data.forth_out = '';
						card_record_adj_apply_data.forth_out_old = '';
						card_record_adj_apply_data.fifth_in = '';
						card_record_adj_apply_data.fifth_in_old = '';
						card_record_adj_apply_data.fifth_out = '';
						card_record_adj_apply_data.fifth_out_old = '';

						var abnormal_flag_array = new Array();
						abnormal_flag_array[0] = '0';
						abnormal_flag_array[1] = '0';
						abnormal_flag_array[2] = '0';
						abnormal_flag_array[3] = '0';
						abnormal_flag_array[4] = '0';
						abnormal_flag_array[5] = '0';
						abnormal_flag_array[6] = '0';
						abnormal_flag_array[7] = '0';
						abnormal_flag_array[8] = '0';
						abnormal_flag_array[9] = '0';


						for (var i = 0; i < card_record_adj_apply_data.card_data.length; i++) {
							if (i == 0) {
								abnormal_flag_array[0] = card_record_adj_apply_data.card_data[i].is_abnormal_in;
								abnormal_flag_array[1] = card_record_adj_apply_data.card_data[i].is_abnormal_out;
								if (card_record_adj_apply_data.card_data[i].time_in == "") {
									card_record_adj_apply_data.first_in_old = card_record_adj_apply_data.card_data[i].mesg_in;
								} else {
									card_record_adj_apply_data.first_in_old = card_record_adj_apply_data.card_data[i].time_in;
								}
								if (card_record_adj_apply_data.card_data[i].time_out == "") {
									card_record_adj_apply_data.first_out_old = card_record_adj_apply_data.card_data[i].mesg_out;
								} else {
									card_record_adj_apply_data.first_out_old = card_record_adj_apply_data.card_data[i].time_out;
								}
							} else if (i == 1) {
								abnormal_flag_array[2] = card_record_adj_apply_data.card_data[i].is_abnormal_in;
								abnormal_flag_array[3] = card_record_adj_apply_data.card_data[i].is_abnormal_out;
								if (card_record_adj_apply_data.card_data[i].time_in == "") {
									card_record_adj_apply_data.second_in_old = card_record_adj_apply_data.card_data[i].mesg_in;
								} else {
									card_record_adj_apply_data.second_in_old = card_record_adj_apply_data.card_data[i].time_in;
								}
								if (card_record_adj_apply_data.card_data[i].time_out == "") {
									card_record_adj_apply_data.second_out_old = card_record_adj_apply_data.card_data[i].mesg_out;
								} else {
									card_record_adj_apply_data.second_out_old = card_record_adj_apply_data.card_data[i].time_out;
								}

							} else if (i == 2) {
								abnormal_flag_array[4] = card_record_adj_apply_data.card_data[i].is_abnormal_in;
								abnormal_flag_array[5] = card_record_adj_apply_data.card_data[i].is_abnormal_out;
								if (card_record_adj_apply_data.card_data[i].time_in == "") {
									card_record_adj_apply_data.third_in_old = card_record_adj_apply_data.card_data[i].mesg_in;
								} else {
									card_record_adj_apply_data.third_in_old = card_record_adj_apply_data.card_data[i].time_in;
								}
								if (card_record_adj_apply_data.card_data[i].time_out == "") {
									card_record_adj_apply_data.third_out_old = card_record_adj_apply_data.card_data[i].mesg_out;
								} else {
									card_record_adj_apply_data.third_out_old = card_record_adj_apply_data.card_data[i].time_out;
								}
							} else if (i == 3) {
								abnormal_flag_array[6] = card_record_adj_apply_data.card_data[i].is_abnormal_in;
								abnormal_flag_array[7] = card_record_adj_apply_data.card_data[i].is_abnormal_out;
								if (card_record_adj_apply_data.card_data[i].time_in == "") {
									card_record_adj_apply_data.forth_in_old = card_record_adj_apply_data.card_data[i].mesg_in;
								} else {
									card_record_adj_apply_data.forth_in_old = card_record_adj_apply_data.card_data[i].time_in;
								}
								if (card_record_adj_apply_data.card_data[i].time_out == "") {
									card_record_adj_apply_data.forth_out_old = card_record_adj_apply_data.card_data[i].mesg_out;
								} else {
									card_record_adj_apply_data.forth_out_old = card_record_adj_apply_data.card_data[i].time_out;
								}
							} else if (i == 4) {
								abnormal_flag_array[8] = card_record_adj_apply_data.card_data[i].is_abnormal_in;
								abnormal_flag_array[9] = card_record_adj_apply_data.card_data[i].is_abnormal_out;
								if (card_record_adj_apply_data.card_data[i].time_in == "") {
									card_record_adj_apply_data.fifth_in_old = card_record_adj_apply_data.card_data[i].mesg_in;
								} else {
									card_record_adj_apply_data.fifth_in_old = card_record_adj_apply_data.card_data[i].time_in;
								}
								if (card_record_adj_apply_data.card_data[i].time_out == "") {
									card_record_adj_apply_data.fifth_out_old = card_record_adj_apply_data.card_data[i].mesg_out;
								} else {
									card_record_adj_apply_data.fifth_out_old = card_record_adj_apply_data.card_data[i].time_out;
								}
							}
						}

						card_record_adj_apply_data.abnormal_flag = abnormal_flag_array.join('');

					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				card_record_adj_apply_data = {};
			},
			getData: function () {
				return card_record_adj_apply_data;
			},
			loadEssEmplData: function (s_user_id, empl_no, p_inst) {
				var _str = '';
				ess_empl_data = [];
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadEssEmplData&user_list=' + s_user_id + '&' + _str + '&empl_no=' + empl_no + '&p_inst=' + p_inst, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_empl_data);
					ess_empl_data.data_ready = true;
					ess_empl_data.num_checked = 0;
					for (var i = 0; i < data.length; i++) {
						if (data[i].ck) {
							ess_empl_data.num_checked++;
						}
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			getEssEmplData: function () {
				return ess_empl_data;
			},
			saveApply: function (approve_list, notify_list) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssCardAdjApply',
					data: {
						approve_remark: '',
						abnormal_flag: card_record_adj_apply_data.abnormal_flag,
						apply_remark: $("#card_record_adj_apply_remark").val(),
						biz_type_key: card_record_adj_apply_data.biz_type_key,
						wf_app_table: card_record_adj_apply_data.wf_app_table,
						show_type: card_record_adj_apply_data.show_type,
						approver_id_list: card_record_adj_apply_data.approver_id_list,
						is_standard_wf: card_record_adj_apply_data.is_standard_wf,
						shift_date: card_record_adj_apply_data.shift_date,
						adj_type_id: card_record_adj_apply_data.adj_type_id,

						first_in: card_record_adj_apply_data.first_in,
						first_in_old: card_record_adj_apply_data.first_in_old,
						first_out: card_record_adj_apply_data.first_out,
						first_out_old: card_record_adj_apply_data.first_out_old,
						second_in: card_record_adj_apply_data.second_in,
						second_in_old: card_record_adj_apply_data.second_in_old,
						second_out: card_record_adj_apply_data.second_out,
						second_out_old: card_record_adj_apply_data.second_out_old,
						third_in: card_record_adj_apply_data.third_in,
						third_in_old: card_record_adj_apply_data.third_in_old,
						third_out: card_record_adj_apply_data.third_out,
						third_out_old: card_record_adj_apply_data.third_out_old,
						forth_in: card_record_adj_apply_data.forth_in,
						forth_in_old: card_record_adj_apply_data.forth_in_old,
						forth_out: card_record_adj_apply_data.forth_out,
						forth_out_old: card_record_adj_apply_data.forth_out_old,
						fifth_in: card_record_adj_apply_data.fifth_in,
						fifth_in_old: card_record_adj_apply_data.fifth_in_old,
						fifth_out: card_record_adj_apply_data.fifth_out,
						fifth_out_old: card_record_adj_apply_data.fifth_out_old,

						task_id: '',
						process_id: card_record_adj_apply_data.process_id,
						process_instance: '',
						notify_list: notify_list,
						actor: approve_list,
						action: 'submit',

						_user_name: window.localStorage['_user_name'],
						_pass_word: window.localStorage['_pass_word'],
						_is_login: window.localStorage['_is_login'],
						_notification_token: window.localStorage['_notification_token'],
						_device_type: window.localStorage['_device_type']

					},
					success: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						var _data = $.parseJSON(data);
						if (_data.flag == '0') {
							if (card_record_adj_apply_data.approver_list_flag && card_record_adj_apply_data.approver_list.length != 0) {
								setLocalStorageVar("ess_approver_list" + getLocalStorageVar("_user_name"), JSON.stringify(card_record_adj_apply_data._approver_list));
							}
							if (card_record_adj_apply_data.notify_list_flag && card_record_adj_apply_data.notify_list.length != 0) {
								setLocalStorageVar("ess_notify_list" + getLocalStorageVar("_user_name"), JSON.stringify(card_record_adj_apply_data.notify_list));
							}

							window.fufuSuccessBox(_data.message, fufu_success_message_box_duration, function () {
								$ionicHistory.goBack();
								fufuMobclickAgent('click_card_record_adj_apply_submit');
							});
						} else {
							window.fufuMessageBox(_data.message, fufu_message_box_duration, function () {});
						}
					},
					error: function (data, status, headers, config) {
						$rootScope.hideLoading();
						fufu_processing = false;
						window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
					}
				});
			}

		}
	})

	.factory('atMonthReportSev', function ($http, $rootScope, $ionicPopup) {
		var at_month_report_data = {};
		return {
			loadData: function (shift_date) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadAtMonthReportData&shift_date=' + shift_date + '&' + _str, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					if (typeof (data.at_result) != 'undefined') {
						for (var i = 0; i < data.at_result.length; i++) {
							if (data.at_result[i].duration == '-') {
								data.at_result[i].duration = '—';
							}
							if (data.at_result[i].times == '-') {
								data.at_result[i].times = '—';
							}
							if (data.at_result[i].amount == '-') {
								data.at_result[i].amount = '—';
							}

							data.at_result[i].is_show_img = true;
							data.at_result[i].is_show_bottom = true;

							if (i == 7 || i == 8 || i == 9 || i == 11 || i == 12) {
								data.at_result[i].is_show_bottom = false;
							}

							if (i == 7 || i == 8 || i == 9 || i == 10 || i == 12 || i == 13) {
								data.at_result[i].is_show_img = false;
								data.at_result[i].img_src = '';
							} else {
								if (i < 7) {
									data.at_result[i].img_src = local_resource + 'img/icon/month_report' + (i + 1) + '.png';
								} else if (i == 11) {
									data.at_result[i].img_src = local_resource + 'img/icon/month_report' + (i - 3) + '.png';
								} else if (i > 13) {
									data.at_result[i].img_src = local_resource + 'img/icon/month_report' + (i - 5) + '.png';
								}
							}

						}


						if (data.at_result.length == 0) {
							data.has_result = false;
							var current_date = new Date();
							var compare_date_str = '';
							if (current_date.getMonth() + 1 < 10) {
								compare_date_str = current_date.getFullYear() + '-0' + (current_date.getMonth() + 1) + '-01';
							} else {
								compare_date_str = current_date.getFullYear() + '-' + (current_date.getMonth() + 1) + '-01';
							}

							console.log(compare_date_str);
							if (compare_date_str < data.at_date) {
								data.no_data_message = '当月还没有考勤数据哦~';
								data.no_data_img_src = local_resource + 'img/icon/at_month_report_no_data1.png';
							} else {
								data.no_data_message = '管理员暂未开放数据哦~';
								data.no_data_img_src = local_resource + 'img/icon/at_month_report_no_data2.png';

							}

						} else {
							data.has_result = true;
						}


						angular.copy(data, at_month_report_data);
					}



				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearData: function () {
				at_month_report_data = {};
			},
			getData: function () {
				return at_month_report_data;
			}

		}
	})

	.factory('essMyCardAdjApplyDSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_applyD_data = [];
		var ess_my_applyD_other_data = [];
		var search_control = {};
		search_control.search_val = ''
		return {
			loadData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyCardAdjApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_data);
					ess_my_applyD_data.data_ready = true;
					for (var i = 0; i < ess_my_applyD_data.data1.length; i++) {
						ess_my_applyD_data.data1[i].date_text = ess_my_applyD_data.data1[i].shift_date.split("/")[0] + '年' + ess_my_applyD_data.data1[i].shift_date.split("/")[1] + '月' + ess_my_applyD_data.data1[i].shift_date.split("/")[2] + '日';
					}
					for (var i = 0; i < ess_my_applyD_data.data2.length; i++) {
						ess_my_applyD_data.data2[i].date_text = ess_my_applyD_data.data2[i].shift_date.split("/")[0] + '年' + ess_my_applyD_data.data2[i].shift_date.split("/")[1] + '月' + ess_my_applyD_data.data2[i].shift_date.split("/")[2] + '日';
					}
					fufuMobclickAgent('menu_card_record_adj_apply');
					//if(ess_my_applyD_data.data1.length>=ess_my_applyD_data.data2.length){
					//  document.getElementById('ess_my_apply_details_wrap').style.overflow='visible';
					//  document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style","width:50%;position: absolute;left:0px;top:0px;");
					//  document.getElementById('ess_my_apply_details_approved_div').setAttribute("style","width: 50%;float: right");
					//  ess_my_applyD_data.cls_flag=true;
					//}
					//else{
					//  document.getElementById('ess_my_apply_details_wrap').style.overflow='hidden';
					//  document.getElementById('ess_my_apply_details_noapprove_div').setAttribute("style","width:50%;");
					//  document.getElementById('ess_my_apply_details_approved_div').setAttribute("style","width: 50%;position: absolute;left:50%;top:0px;");
					//  ess_my_applyD_data.cls_flag=false;
					//}
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, process_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyCardAdjApplyDetail&' + _str + '&biz_type_key=' + type + '&process_result=' + process_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_applyD_other_data);
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_applyD_data;
			},
			getOtherData: function () {
				return ess_my_applyD_other_data;
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyCardAdjApplyDSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyCardAdjApplyDSearchDiv").style.display = 'none';
					document.getElementById("essMyCardAdjApplyDBack").style.display = 'block';
					return false;
				}
			},
			clearData: function () {
				ess_my_applyD_data = [];
				ess_my_applyD_other_data = [];
			}
		}
	})

	.factory('essMyApprovalDCardAdjSev', function ($http, $rootScope, $ionicHistory, $ionicPopup) {
		var ess_my_approvalDCardAdj_data = [];
		var ess_my_approvalDCardAdj_other_data = [];
		var search_control = {};
		search_control.search_val = '';
		return {
			loadData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailCardAdj&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDCardAdj_data);
					ess_my_approvalDCardAdj_data.data_ready = true;
					for (var i = 0; i < ess_my_approvalDCardAdj_data.data1.length; i++) {
						ess_my_approvalDCardAdj_data.data1[i].date_text = ess_my_approvalDCardAdj_data.data1[i].shift_date.split("/")[0] + '年' + ess_my_approvalDCardAdj_data.data1[i].shift_date.split("/")[1] + '月' + ess_my_approvalDCardAdj_data.data1[i].shift_date.split("/")[2] + '日';
					}
					for (var i = 0; i < ess_my_approvalDCardAdj_data.data2.length; i++) {
						ess_my_approvalDCardAdj_data.data2[i].date_text = ess_my_approvalDCardAdj_data.data2[i].shift_date.split("/")[0] + '年' + ess_my_approvalDCardAdj_data.data2[i].shift_date.split("/")[1] + '月' + ess_my_approvalDCardAdj_data.data2[i].shift_date.split("/")[2] + '日';
					}

				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			loadOtherData: function (type, my_app_result) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadMyApprovalDetailCardAdj&' + _str + '&biz_type_key=' + type + '&my_app_result=' + my_app_result, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();
					angular.copy(data, ess_my_approvalDCardAdj_other_data);
					ess_my_approvalDCardAdj_data.data_ready = true;
				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},
			clearSearchValue: function () {
				search_control.search_val = '';
			},
			setSearchValue: function (search_val) {
				search_control.search_val = search_val;
			},
			getSearchValue: function () {
				return search_control;
			},
			getData: function () {
				return ess_my_approvalDCardAdj_data;
			},
			getOtherData: function () {
				return ess_my_approvalDCardAdj_other_data;
			},
			clearData: function () {
				ess_my_approvalDCardAdj_data = [];
			},
			clearStatusBar: function () {
				//如果需要还原statusbar, 先执行还原动作, 然后返回false

				if (document.getElementById("essMyApprovalDCardAdjSearchDiv").style.display == 'none') {
					return true;
				} else {
					document.getElementById("essMyApprovalDCardAdjSearchDiv").style.display = 'none';
					document.getElementById("essMyApprovalDCardAdjBack").style.display = 'block';
					return false;
				}
			},

		}
	})


	.factory('essMyCardAdjApplyDCCSev', function ($http, $rootScope, $ionicHistory, $ionicPopup, essMyCardAdjApplyDSev) {
		var ess_my_applyD_data = {};
		return {
			loadData: function (p_inst, show_type, task_id, $scope) {
				var _str = '';
				if (angular.isDefined(window.localStorage['_is_login']) && window.localStorage['_is_login'] == true) {
					_str = '_user_name=' + window.localStorage['_user_name'] + '&_pass_word=' + window.localStorage['_pass_word'] + '&_is_login=' + window.localStorage['_is_login'] + '&_notification_token=' + window.localStorage['_notification_token'] + '&_device_type=' + window.localStorage['_device_type'];
				}
				$rootScope.showLoading();
				$http.get(window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.loadCardAdjApplyContent&' + _str + '&p_inst=' + p_inst + '&show_type=' + show_type + '&task_id=' + task_id, {
					timeout: _var_timeout
				}).
				success(function (data, status) {
					$rootScope.hideLoading();

					angular.copy(data, ess_my_applyD_data);


					ess_my_applyD_data.date_text = ess_my_applyD_data.shift_date.split("-")[0] + '年' + ess_my_applyD_data.shift_date.split("-")[1] + '月' + ess_my_applyD_data.shift_date.split("-")[2] + '日';
					if (ess_my_applyD_data.shift_date_dw == '1') {
						ess_my_applyD_data.day_of_week_text = "星期天";
					} else if (ess_my_applyD_data.shift_date_dw == '2') {
						ess_my_applyD_data.day_of_week_text = "星期一";
					} else if (ess_my_applyD_data.shift_date_dw == '3') {
						ess_my_applyD_data.day_of_week_text = "星期二";
					} else if (ess_my_applyD_data.shift_date_dw == '4') {
						ess_my_applyD_data.day_of_week_text = "星期三";
					} else if (ess_my_applyD_data.shift_date_dw == '5') {
						ess_my_applyD_data.day_of_week_text = "星期四";
					} else if (ess_my_applyD_data.shift_date_dw == '6') {
						ess_my_applyD_data.day_of_week_text = "星期五";
					} else if (ess_my_applyD_data.shift_date_dw == '7') {
						ess_my_applyD_data.day_of_week_text = "星期六";
					}

					//ess_my_applyD_data.at_start_text = ess_my_applyD_data.at_start.split('/')[0] + '年' + ess_my_applyD_data.at_start.split('/')[1] + '月份已经补签次数';

					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						$scope.select_notify_id = $scope.select_notify_id + ess_my_applyD_data.notify_list[i].user_id;
						ess_my_applyD_data.notify_list[i].flag = 1;
						if (i < ess_my_applyD_data.notify_list.length - 1) {
							$scope.select_notify_id = $scope.select_notify_id + ',';
						}
					}
					ess_my_applyD_data.notify_text = [];
					for (var i = 0; i < ess_my_applyD_data.notify_list.length; i++) {
						ess_my_applyD_data.notify_text.push(ess_my_applyD_data.notify_list[i].name)
					}
					document.getElementById('notify_text').innerText = ess_my_applyD_data.notify_text;
					/*
				if (ess_my_applyD_data.is_standard_wf == '1') {

					var approver_list = [];
					for (var i = 0; i < ess_my_applyD_data.approver_list.length; i++) {
						approver_list.push(ess_my_applyD_data.approver_list[i + 1])
						if (i == ess_my_applyD_data.approver_list.length - 2) {
							break;
						}
					}
					ess_my_applyD_data._approver_list = approver_list;
					document.getElementById('approver_list_div').style.width = (approver_list.length + 1) * 80 + 'px';
				} else {
					if (ess_my_applyD_data.approver_list.length > 0) {
						$scope.select_user_id = ess_my_applyD_data.approver_list[ess_my_applyD_data.approver_list.length - 1].user_id;
						ess_my_applyD_data.approver_list.splice(0, ess_my_applyD_data.approver_list.length - 1);
						ess_my_applyD_data.approver_list[0].flag = 1;
					}
					ess_my_applyD_data._approver_list = ess_my_applyD_data.approver_list;
					document.getElementById('approver_list_div').style.width = (ess_my_applyD_data.approver_list.length + 1) * 100 + 20 + 'px';
				}

	*/
					for (var i = 0; i < ess_my_applyD_data.adj_type.length; i++) {
						if (ess_my_applyD_data.adj_type[i].check) {
							if (ess_my_applyD_data.adj_type[i].key_ == '0') {
								ess_my_applyD_data.adjReason = ess_my_applyD_data.apply_remark;
							} else {
								ess_my_applyD_data.adjReason = ess_my_applyD_data.adj_type[i].value_;
							}


							//document.getElementById("ess_myapply_adjReason").innerHTML = ess_my_applyD_data.adj_type[i].value_;

						}
					}
					//document.getElementById('notify_list_div').style.width = (ess_my_applyD_data.notify_list.length + 1) * 100 + 20 + 'px';

					ess_my_applyD_data.first_in = '';
					ess_my_applyD_data.first_in_old = '';
					ess_my_applyD_data.first_out = '';
					ess_my_applyD_data.first_out_old = '';
					ess_my_applyD_data.second_in = '';
					ess_my_applyD_data.second_in_old = '';
					ess_my_applyD_data.second_out = '';
					ess_my_applyD_data.second_out_old = '';
					ess_my_applyD_data.third_in = '';
					ess_my_applyD_data.third_in_old = '';
					ess_my_applyD_data.third_out = '';
					ess_my_applyD_data.third_out_old = '';
					ess_my_applyD_data.forth_in = '';
					ess_my_applyD_data.forth_in_old = '';
					ess_my_applyD_data.forth_out = '';
					ess_my_applyD_data.forth_out_old = '';
					ess_my_applyD_data.fifth_in = '';
					ess_my_applyD_data.fifth_in_old = '';
					ess_my_applyD_data.fifth_out = '';
					ess_my_applyD_data.fifth_out_old = '';

					var abnormal_flag_array = new Array();
					abnormal_flag_array[0] = '0';
					abnormal_flag_array[1] = '0';
					abnormal_flag_array[2] = '0';
					abnormal_flag_array[3] = '0';
					abnormal_flag_array[4] = '0';
					abnormal_flag_array[5] = '0';
					abnormal_flag_array[6] = '0';
					abnormal_flag_array[7] = '0';
					abnormal_flag_array[8] = '0';
					abnormal_flag_array[9] = '0';


					for (var i = 0; i < ess_my_applyD_data.card_data.length; i++) {
						if (i == 0) {
							abnormal_flag_array[0] = ess_my_applyD_data.card_data[i].is_abnormal_in;
							abnormal_flag_array[1] = ess_my_applyD_data.card_data[i].is_abnormal_out;
							if (ess_my_applyD_data.card_data[i].wf_in == "") {
								//ess_my_applyD_data.first_in_old = ess_my_applyD_data.card_data[i].mesg_in;
							} else {
								ess_my_applyD_data.first_in = ess_my_applyD_data.card_data[i].wf_in;
								if (ess_my_applyD_data.card_data[i].time_in == "") {
									ess_my_applyD_data.first_in_old = ess_my_applyD_data.card_data[i].mesg_in;
								} else {
									ess_my_applyD_data.first_in_old = ess_my_applyD_data.card_data[i].time_in;
								}

							}
							if (ess_my_applyD_data.card_data[i].wf_out == "") {
								//ess_my_applyD_data.first_out_old = ess_my_applyD_data.card_data[i].mesg_out;
							} else {
								ess_my_applyD_data.first_out = ess_my_applyD_data.card_data[i].wf_out;
								if (ess_my_applyD_data.card_data[i].time_out == "") {
									ess_my_applyD_data.first_out_old = ess_my_applyD_data.card_data[i].mesg_out;
								} else {
									ess_my_applyD_data.first_out_old = ess_my_applyD_data.card_data[i].time_out;
								}

							}
						} else if (i == 1) {
							abnormal_flag_array[2] = ess_my_applyD_data.card_data[i].is_abnormal_in;
							abnormal_flag_array[3] = ess_my_applyD_data.card_data[i].is_abnormal_out;
							if (ess_my_applyD_data.card_data[i].wf_in == "") {
								//ess_my_applyD_data.first_in_old = ess_my_applyD_data.card_data[i].mesg_in;
							} else {
								ess_my_applyD_data.second_in = ess_my_applyD_data.card_data[i].wf_in;
								if (ess_my_applyD_data.card_data[i].time_in == "") {
									ess_my_applyD_data.second_in_old = ess_my_applyD_data.card_data[i].mesg_in;
								} else {
									ess_my_applyD_data.second_in_old = ess_my_applyD_data.card_data[i].time_in;
								}

							}
							if (ess_my_applyD_data.card_data[i].wf_out == "") {
								//ess_my_applyD_data.first_out_old = ess_my_applyD_data.card_data[i].mesg_out;
							} else {
								ess_my_applyD_data.second_out = ess_my_applyD_data.card_data[i].wf_out;
								if (ess_my_applyD_data.card_data[i].time_out == "") {
									ess_my_applyD_data.second_out_old = ess_my_applyD_data.card_data[i].mesg_out;
								} else {
									ess_my_applyD_data.second_out_old = ess_my_applyD_data.card_data[i].time_out;
								}

							}

						} else if (i == 2) {
							abnormal_flag_array[4] = ess_my_applyD_data.card_data[i].is_abnormal_in;
							abnormal_flag_array[5] = ess_my_applyD_data.card_data[i].is_abnormal_out;
							if (ess_my_applyD_data.card_data[i].wf_in == "") {
								//ess_my_applyD_data.third_in_old = ess_my_applyD_data.card_data[i].mesg_in;
							} else {
								ess_my_applyD_data.third_in = ess_my_applyD_data.card_data[i].wf_in;
								if (ess_my_applyD_data.card_data[i].time_in == "") {
									ess_my_applyD_data.third_in_old = ess_my_applyD_data.card_data[i].mesg_in;
								} else {
									ess_my_applyD_data.third_in_out = ess_my_applyD_data.card_data[i].time_in;
								}

							}
							if (ess_my_applyD_data.card_data[i].wf_out == "") {
								//ess_my_applyD_data.third_out_old = ess_my_applyD_data.card_data[i].mesg_out;
							} else {
								ess_my_applyD_data.third_out = ess_my_applyD_data.card_data[i].wf_out;
								if (ess_my_applyD_data.card_data[i].time_out == "") {
									ess_my_applyD_data.third_out_old = ess_my_applyD_data.card_data[i].mesg_out;
								} else {
									ess_my_applyD_data.third_out_old = ess_my_applyD_data.card_data[i].time_out;
								}

							}
						} else if (i == 3) {
							abnormal_flag_array[6] = ess_my_applyD_data.card_data[i].is_abnormal_in;
							abnormal_flag_array[7] = ess_my_applyD_data.card_data[i].is_abnormal_out;
							if (ess_my_applyD_data.card_data[i].wf_in == "") {
								//ess_my_applyD_data.forth_in_old = ess_my_applyD_data.card_data[i].mesg_in;
							} else {
								if (ess_my_applyD_data.card_data[i].time_in == "") {
									ess_my_applyD_data.forth_in_old = ess_my_applyD_data.card_data[i].mesg_in;
								} else {
									ess_my_applyD_data.forth_in_old = ess_my_applyD_data.card_data[i].time_in;
								}
								ess_my_applyD_data.forth_in = ess_my_applyD_data.card_data[i].wf_in;
							}
							if (ess_my_applyD_data.card_data[i].wf_out == "") {

							} else {
								if (ess_my_applyD_data.card_data[i].time_out == "") {
									ess_my_applyD_data.forth_out_old = ess_my_applyD_data.card_data[i].mesg_out;
								} else {
									ess_my_applyD_data.forth_out_old = ess_my_applyD_data.card_data[i].time_out;
								}
								ess_my_applyD_data.forth_out = ess_my_applyD_data.card_data[i].wf_out;
							}
						} else if (i == 4) {
							abnormal_flag_array[8] = ess_my_applyD_data.card_data[i].is_abnormal_in;
							abnormal_flag_array[9] = ess_my_applyD_data.card_data[i].is_abnormal_out;
							if (ess_my_applyD_data.card_data[i].wf_in == "") {
								//ess_my_applyD_data.fifth_in_old = ess_my_applyD_data.card_data[i].mesg_in;
							} else {
								if (ess_my_applyD_data.card_data[i].time_in == "") {
									ess_my_applyD_data.fifth_in_old = ess_my_applyD_data.card_data[i].mesg_in;
								} else {
									ess_my_applyD_data.fifth_in_old = ess_my_applyD_data.card_data[i].time_in;
								}

								ess_my_applyD_data.fifth_in = ess_my_applyD_data.card_data[i].wf_in;
							}
							if (ess_my_applyD_data.card_data[i].wf_out == "") {
								//ess_my_applyD_data.fifth_out_old = ess_my_applyD_data.card_data[i].mesg_out;
							} else {
								if (ess_my_applyD_data.card_data[i].time_out == "") {
									ess_my_applyD_data.fifth_out_old = ess_my_applyD_data.card_data[i].mesg_out;
								} else {
									ess_my_applyD_data.fifth_out_old = ess_my_applyD_data.card_data[i].time_out;
								}
								ess_my_applyD_data.fifth_out = ess_my_applyD_data.card_data[i].wf_out;
							}
						}
					}

					ess_my_applyD_data.abnormal_flag = abnormal_flag_array.join('');





				}).
				error(function (data, status) {
					$rootScope.hideLoading();
					window.fufuMessageBox(fufu_network_error_msg, fufu_message_box_duration, function () {});
				});
			},

			clearData: function () {
				ess_my_applyD_data = {};
			},
			getData: function () {
				return ess_my_applyD_data;
			},

			submitAction: function (action, my_app_result) {
				if (fufu_processing) {
					return;
				}
				fufu_processing = true;
				var actor = '';
				var notify_list = '';
				var _d = ess_my_applyD_data.approver_list;
				if (_d.length > 0) {
					var len = _d.length;
					actor = _d[len - 1].user_id;
				}
				_d = ess_my_applyD_data.notify_list;
				for (var i = 0; i < _d.length; i++) {
					notify_list = notify_list + _d[i].user_id + ',';
				}
				if (notify_list != '') {
					notify_list = notify_list.substring(0, notify_list.length - 1);
				}
				$rootScope.showLoading();
				$.ajax({
					type: 'POST',
					timeout: _var_timeout,
					url: window.localStorage['_remote_server_addr'] + '?event=ionicAction.ionicAction.saveEssCardAdjApply',
					data: {
						/*is_standard_wf: ess_my_applyD_data.is_standard_wf,
						approver_id_list: ess_my_applyD_data.approver_id_list,
						employee_no: ess_my_applyD_data.employee_no,
						lv_code_key: ess_my_applyD_data.lv_code_key,
						lv_code_id: ess_my_applyD_data.default_lv_code_id,
						task_id: ess_my_applyD_data.task_id,
						//process_id: ess_my_applyD_data.process_id,
						start_date: ess_my_applyD_data.start_date,
						start_time: ess_my_applyD_data.start_time,
						end_date: ess_my_applyD_data.end_date,
						end_time: ess_my_applyD_data.end_time,
						duration: ess_my_applyD_data.duration,
						lv_unit: ess_my_applyD_data.lv_unit,
						apply_remark: '',
						approve_remark: '',
						notify_list: notify_list,
						actor: actor,
						attachment: '',
						old_lv_code_id: ess_my_applyD_data.old_lv_code_id,
						old_lv_code_key: ess_my_applyD_data.old_lv_code_key,
						old_duration: ess_my_applyD_data.old_duration,
						show_type: ess_my_applyD_data.show_type,
						biz_type_key: ess_my_applyD_data.biz_type_key,
						wf_app_table: ess_my_applyD_data.wf_app_table,
						action: action,
						process_instance: ess_my_applyD_data.process_instance,
						process_id: 0,
						_user_na