#!/usr/bin/ruby

require 'json'
require 'fileutils'
require 'openssl'
require 'optparse'
require 'base64'

OutputHeader = "DMUnbigdayHelper.h"
OutputFile = "DMUnbigdayHelper.m"
OutputAndroidFile = "DMUnbigdayHelper.java"

options = {
  input: nil,
  output: nil,
  key: nil,
  target: nil
}

optsparser = OptionParser.new do |opts|
  opts.on("-i", "--input INPUT", "Input files") do |input|
    options[:input] = input
  end

  opts.on("-o", "--output OUTPUT", "Output path") do |output|
    options[:output] = output
  end
  
  opts.on("-k", "--key KEY", "encrypt key") do |output|
    options[:key] = output
  end  
  
  opts.on("-t", "--target TARGET", "target") do |output|
    options[:target] = output
  end  
end

def save_hash data_hash, to_path, encrypt_key, target
  key = encrypt_key != nil ? encrypt_key : "[NSString stringWithFormat:form]"

  cipher = OpenSSL::Cipher::AES256.new(:CBC)
  cipher.encrypt
  cipher.key = key
  encrypt_result = cipher.update(data_hash.to_json) + cipher.final
  str = Base64.strict_encode64(encrypt_result)
  
  if target == "android"
    create_code_android(str, to_path)
  elsif target == "iOS" || target == "ios"
    create_code_ios(str, to_path)
  else
    create_code_ios(str, to_path)
    create_code_android(str, to_path)
  end
  
  cipher.reset
end

def create_code_android encrypt_string, to_path
  File.open("#{to_path}/#{OutputAndroidFile}","w") do |f|
    f.puts "// THIS FILE IS GENERATED BY encrypt.rb
// DO NOT EDIT THIS FILE DIRECTLY!"

    f.puts ""
    f.puts "package com.clover.daysmatter.utils;

import android.os.Build;

import org.json.JSONArray;

import java.util.ArrayList;"
    f.puts ""
    f.puts "public class DMUnbigdayHelper {"
    f.puts "    static String encryptString = \"#{encrypt_string}\";"
    f.puts ""
    f.puts "    public static ArrayList<String> unbigdayNames() {"
    f.puts "        ArrayList<String> arrayList = new ArrayList<>();"
    f.puts "        byte[] data;"
    f.puts "        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {"
    f.puts "            data = java.util.Base64.getDecoder().decode(encryptString);"
    f.puts "        } else {"
    f.puts "            data = android.util.Base64.decode(encryptString, android.util.Base64.DEFAULT);"
    f.puts "        }"
    f.puts "        try {"
    f.puts "            String rawJson = EncryptHelper.decryptAESCBC(\"[NSString stringWithFormat:form]\", data);"
    f.puts "            JSONArray jsonArray = new JSONArray(rawJson);"
    f.puts "            for (int i = 0; i < jsonArray.length(); i++) {"
    f.puts "                arrayList.add((String) jsonArray.get(i));"
    f.puts "            }"
    f.puts "            return arrayList;"
    f.puts "        } catch (Exception e) {"
    f.puts "            e.printStackTrace();"
    f.puts "        }"
    f.puts "        return arrayList;"
    f.puts "    }"
    f.puts "}"
  end
end

def create_code_ios encrypt_string, to_path
  File.open("#{to_path}/#{OutputHeader}","w") do |f|
    f.puts "//
//  DMBadEvents.h
//  Clover Project
//
//  Auto Created by encrypt.rb
//  Copyright (c) 2021 Clover.ly. All rights reserved.
//

// THIS FILE IS GENERATED BY encrypt.rb
// DO NOT EDIT THIS FILE DIRECTLY!"

    f.puts ""
    f.puts "#import \"DMUnbigdayHelper.h\""
    f.puts ""
    f.puts "@interface DMUnbigdayHelper : NSObject"
    f.puts ""
    f.puts "+ (NSArray *)unbigdayNames;"
    f.puts ""
    f.puts "@end"
#    f.write(cipher.update(data_hash.to_json) + cipher.final)
  end
  
  File.open("#{to_path}/#{OutputFile}","w") do |f|
    f.puts "//
//  DMBadEvents.h
//  Clover Project
//
//  Auto Created by encrypt.rb
//  Copyright (c) 2021 Clover.ly. All rights reserved.
//

// THIS FILE IS GENERATED BY encrypt.rb
// DO NOT EDIT THIS FILE DIRECTLY!"

    f.puts ""
    f.puts "#import \"DMUnbigdayHelper.h\""
    f.puts ""
    f.puts "@implementation DMUnbigdayHelper"
    f.puts ""
    f.puts "+ (NSString *)encryptString {"
    f.puts "    return @\"#{encrypt_string}\";"
    f.puts "}"
    f.puts ""
    
    f.puts "+ (NSArray *)unbigdayNames {"
    f.puts "    static NSArray *_nameList;"
    f.puts "    static dispatch_once_t onceToken;"
    f.puts "    dispatch_once(&onceToken, ^{"  
    f.puts "        NSString *string = [self encryptString];"  
    f.puts "        NSData *data = [[NSData alloc] initWithBase64EncodedString:string options:0];"  
    f.puts "        data = [data cl_AES256DecryptWithKey:@\"[NSString stringWithFormat:form]\"];"  
    f.puts "        NSError *error = nil;"      
    f.puts "        _nameList = [NSJSONSerialization JSONObjectWithData:data options:0 error:&error];"      
    f.puts "    });"      
    f.puts "    return _nameList;"
    f.puts "}"  
    f.puts ""
    
    f.puts "@end"
  end
end

begin
  optsparser.parse!
  missing = Array.new
  missing << 'input' if options[:input].nil?
  missing << 'output' if options[:output].nil?
  raise OptionParser::MissingArgument.new(missing.join(', ')) unless missing.empty?
rescue OptionParser::InvalidOption, OptionParser::MissingArgument
  puts $!.to_s
  puts optsparser
  exit 1
end

file = File.read(options[:input],
                 :external_encoding => 'utf-8',
                 :internal_encoding => 'utf-8'
                 )
data = JSON.parse(file)
save_hash(data, options[:output], options[:key], options[:target])
