precision highp float;

varying highp vec2 aCoordinate;
uniform sampler2D bgTexture;// 图片纹理
uniform int type;// 透明度 1普通纹理 2背景纹理
uniform sampler2D vTexture;
uniform float progress;// 转场进度
//uniform highp vec2 center;
void main()
{
    if (type==2){
        gl_FragColor = texture2D(bgTexture, aCoordinate);
        return;
    }
    vec2 center=vec2(0.8, 0.5);
    highp vec2 normCoord = 2.0 * aCoordinate - 1.0;
    highp vec2 normCenter = 2.0 * center - 1.0;

    normCoord -= normCenter;
    mediump vec2 s = sign(normCoord);
    normCoord = abs(normCoord);
    normCoord = 0.5 * normCoord + 0.5 * smoothstep(0.25, 0.5, normCoord) * normCoord;
    normCoord = s * normCoord;

    normCoord += normCenter;

    mediump vec2 textureCoordinateToUse = normCoord / 2.0 + 0.5;


    gl_FragColor = texture2D(vTexture, textureCoordinateToUse);

}