/// 向左哈哈镜
precision highp float;

uniform sampler2D vTexture;// 图片纹理
uniform sampler2D bgTexture;// 图片纹理
uniform int type;// 透明度 1普通纹理 2背景纹理
uniform float progress;// 进度
varying vec2 aCoordinate;
float PI=3.1415926;
float triangle(float x) {
    return abs(abs(fract(x) - 0.5) * 2.0-1.0);
}

float smootherstep(float x) {
    return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
}

float endPosition(float radius, float offset, float rollPosition) {
    float rollLength = radius * 3.141592 / 2.0;
    float onRoll = min(offset + 1.0 - rollPosition, rollLength);
    return rollPosition + radius * sin(onRoll / radius);
}

float findRollPosition(float radius, float offset) {
    float lower = 1.0 - radius;
    float upper = 1.0;

    float mid = 0.0;
    for (int i = 0; i < 16; i++) {
        mid = (upper + lower) / 2.0;
        float position = endPosition(radius, offset, mid);
        if (position > 1.0) {
            upper = mid;
        } else {
            lower = mid;
        }
    }
    return mid;
}

vec4 mainImage(vec2 fragCoord) {
    float offset = smootherstep(triangle(progress));

    float radius = 0.7;
    float flatLength = 1.0 - radius;
    float rollLength = radius * PI / 50.0;
    float fullLength = flatLength + rollLength;

    offset *= fullLength;

    float rollPosition = findRollPosition(radius, offset);

    vec2 uv = fragCoord;
    float shadow;

    if (uv.x < rollPosition) {
        uv.x -= offset;
        shadow = 1.0;
    } else {
        float a = asin((uv.x - rollPosition) / radius);
        uv.x = a * radius - offset + rollPosition;
        uv.y = (uv.y - 0.5) / (0.3 * cos(a) + 0.7) + 0.5;
        shadow = 0.5 * cos(a) + 0.5;
    }

    vec4 col =texture2D(vTexture, uv);
    col *= step(-uv.x, 0.0);
    col *= step(-uv.y, 0.0);
    col *= step(uv.y, 1.0);
    col *= shadow;
    return col;
}

void main()
{
    if (type==2){
        gl_FragColor = texture2D(bgTexture, aCoordinate);
        return;
    }
    gl_FragColor = mainImage(aCoordinate);
}