/// 缩放模糊
precision highp float;
uniform sampler2D vTexture;// 图片纹理
uniform sampler2D bgTexture;// 图片纹理
uniform int type;// 透明度 1普通纹理 2背景纹理
uniform float progress;// 进度
varying vec2 aCoordinate;
void main()
{
    if (type==2){
        gl_FragColor = texture2D(bgTexture, aCoordinate);
        return;
    }
    float  p=smoothstep(0.0, 1.0, progress);
    //    float zoom = (0.5 + 0.5 * p);
    //    vec2 scaleCenter = vec2(0.5);
    //    vec2  uv = (aCoordinate - scaleCenter) * zoom + scaleCenter;
    vec2  uv =aCoordinate;

    highp vec2 blurCenter=vec2(0.5, 0.5);
    uv-=blurCenter;
    uv*=(0.9+0.1*p);
    uv+=blurCenter;
    highp float blurSize=1.5-(1.5*p);
    highp vec2 samplingOffset = 1.0/150.0 * (blurCenter - uv) * blurSize;
    lowp vec4 fragmentColor = texture2D(vTexture, uv) * 0.18;
    fragmentColor += texture2D(vTexture, uv + samplingOffset) * 0.15;
    fragmentColor += texture2D(vTexture, uv + (2.0 * samplingOffset)) *  0.12;
    fragmentColor += texture2D(vTexture, uv + (3.0 * samplingOffset)) * 0.09;
    fragmentColor += texture2D(vTexture, uv + (4.0 * samplingOffset)) * 0.05;
    fragmentColor += texture2D(vTexture, uv - samplingOffset) * 0.15;
    fragmentColor += texture2D(vTexture, uv - (2.0 * samplingOffset)) *  0.12;
    fragmentColor += texture2D(vTexture, uv - (3.0 * samplingOffset)) * 0.09;
    fragmentColor += texture2D(vTexture, uv - (4.0 * samplingOffset)) * 0.05;

    gl_FragColor = fragmentColor;
}