// 圆形转场动画
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;

uniform float progress;// 转场进度
uniform float ratio;// width/height比例
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 transition(vec2 p) {
    vec2 ratio2 = vec2(1.0, 1.0 / ratio);
    float s = pow(2.0 * abs(progress - 0.5), 3.0);
    float dist = length((vec2(p) - 0.5) * ratio2);
    return mix(
    progress < 0.5 ? getFromColor(p) : getToColor(p), getFromColor(p),
    step(s, dist)
    );
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
