precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
const vec2 center = vec2(0.5); // = vec2(0.5)
const float threshold=3.0; // = 3.0
const float fadeEdge=0.1; // = 0.1
uniform float progress;// 转场进度
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
float rand(vec2 co) {
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
vec4 transition(vec2 p) {
    float dist = distance(center, p) / threshold;
    float r = progress - min(rand(vec2(p.y, 0.0)), rand(vec2(0.0, p.x)));
    return mix(getFromColor(p), getToColor(p), mix(0.0, mix(step(dist, r), 1.0, smoothstep(1.0-fadeEdge, 1.0, progress)), smoothstep(0.0, fadeEdge, progress)));
}

void main(){
    gl_FragColor=transition(aCoordinate);
}
