precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;

const vec2 direction = vec2(1.0, 1.0);// 方向
const float smoothness = 0.5;
const vec2 center = vec2(0.5, 0.5);
uniform float progress;// 转场进度
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition(vec2 uv) {
    vec2 v = normalize(direction);
    v /= abs(v.x) + abs(v.y);
    float d = v.x * center.x + v.y * center.y;
    float m = 1.0 - smoothstep(-smoothness, 0.0, v.x * uv.x + v.y * uv.y - (d - 0.5 + progress * (1.0 + smoothness)));
    return mix(getFromColor((uv - 0.5) * (1.0 - m) + 0.5), getToColor((uv - 0.5) * m + 0.5), m);
}

void main(){
    gl_FragColor=transition(aCoordinate);
}
