// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const float strength=0.1;// = 0.1

vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 transition(vec2 p) {
    vec4 ca = getFromColor(p);
    vec4 cb = getToColor(p);

    vec2 oa = (((ca.rg+ca.b)*0.5)*2.0-1.0);
    vec2 ob = (((cb.rg+cb.b)*0.5)*2.0-1.0);
    vec2 oc = mix(oa, ob, 0.5)*strength;

    float w0 = progress;
    float w1 = 1.0-w0;
    return mix(getFromColor(p+oc*w0), getToColor(p-oc*w1), progress);
}


void main(){
    gl_FragColor=transition(aCoordinate);
}
