precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const float speed=2.0;// = 2.0;

vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 transition(vec2 uv) {

    vec2 p = uv.xy / vec2(1.0).xy;

    float circPos = atan(p.y - 0.5, p.x - 0.5) + progress * speed;
    float modPos = mod(circPos, 3.1415 / 4.);
    float signed = sign(progress - modPos);

    return mix(getToColor(p), getFromColor(p), step(signed, 0.5));

}

void main(){
    if (progress<=0.05){
        gl_FragColor= texture2D(vTexture, aCoordinate);
        return;
    }
    gl_FragColor=transition(aCoordinate);
}
