// 马赛克转场
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const ivec2 squaresMin = ivec2(20)/* = ivec2(20) */;// minimum number of squares (when the effect is at its higher level)
const int steps=50 /* = 50 */;// zero disable the stepping

vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition(vec2 uv) {
    float d = min(progress, 1.0 - progress);
    float dist = steps>0 ? ceil(d * float(steps)) / float(steps) : d;
    vec2 squareSize = 2.0 * dist / vec2(squaresMin);
    vec2 p = dist>0.0 ? (floor(uv / squareSize) + 0.5) * squareSize : uv;
    return mix(getFromColor(p), getToColor(p), progress);
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
